/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scroller {
    public static final int DOWN = 0;
    public static final int UP = 1;
    private boolean canScroll = false;
    private final Instrumentation inst;
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    public Scroller(Instrumentation inst, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        long downTime = SystemClock.uptimeMillis();
        long eventTime = SystemClock.uptimeMillis();
        float y = fromY;
        float x = fromX;
        float yStep = (toY - fromY) / (float)stepCount;
        float xStep = (toX - fromX) / (float)stepCount;
        MotionEvent event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)0, (float)fromX, (float)fromY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        for (int i = 0; i < stepCount; ++i) {
            eventTime = SystemClock.uptimeMillis();
            event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            try {
                this.inst.sendPointerSync(event);
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        eventTime = SystemClock.uptimeMillis();
        event = MotionEvent.obtain((long)downTime, (long)eventTime, (int)1, (float)toX, (float)toY, (int)0);
        try {
            this.inst.sendPointerSync(event);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    private boolean scrollScrollView(final ScrollView view, int direction) {
        if (view == null) {
            return false;
        }
        int height = view.getHeight();
        --height;
        int scrollTo = -1;
        if (direction == 0) {
            scrollTo = height;
        } else if (direction == 1) {
            scrollTo = -height;
        }
        int originalY = view.getScrollY();
        final int scrollAmount = scrollTo;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.scrollBy(0, scrollAmount);
            }
        });
        return originalY != view.getScrollY();
    }

    private void scrollScrollViewAllTheWay(ScrollView view, int direction) {
        while (this.scrollScrollView(view, direction)) {
        }
    }

    public boolean scroll(int direction) {
        return this.scroll(direction, false);
    }

    public boolean scroll(int direction, boolean allTheWay) {
        ArrayList<View> viewList = RobotiumUtils.removeInvisibleViews(this.viewFetcher.getAllViews(true));
        ArrayList<View> views = RobotiumUtils.filterViewsToSet(new Class[]{ListView.class, ScrollView.class, GridView.class, WebView.class}, viewList);
        View view = this.viewFetcher.getFreshestView(views);
        if (view == null) {
            return false;
        }
        if (view instanceof AbsListView) {
            return this.scrollList((AbsListView)view, direction, allTheWay);
        }
        if (view instanceof ScrollView) {
            if (allTheWay) {
                this.scrollScrollViewAllTheWay((ScrollView)view, direction);
                return false;
            }
            return this.scrollScrollView((ScrollView)view, direction);
        }
        if (view instanceof WebView) {
            return this.scrollWebView((WebView)view, direction, allTheWay);
        }
        return false;
    }

    public boolean scrollWebView(final WebView webView, int direction, final boolean allTheWay) {
        if (direction == 0) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    Scroller.this.canScroll = webView.pageDown(allTheWay);
                }
            });
        }
        if (direction == 1) {
            this.inst.runOnMainSync(new Runnable(){

                public void run() {
                    Scroller.this.canScroll = webView.pageUp(allTheWay);
                }
            });
        }
        return this.canScroll;
    }

    public <T extends AbsListView> boolean scrollList(T absListView, int direction, boolean allTheWay) {
        if (absListView == null) {
            return false;
        }
        if (direction == 0) {
            if (allTheWay) {
                this.scrollListToLine(absListView, absListView.getCount() - 1);
                return false;
            }
            if (absListView.getLastVisiblePosition() >= absListView.getCount() - 1) {
                this.scrollListToLine(absListView, absListView.getLastVisiblePosition());
                return false;
            }
            if (absListView.getFirstVisiblePosition() != absListView.getLastVisiblePosition()) {
                this.scrollListToLine(absListView, absListView.getLastVisiblePosition());
            } else {
                this.scrollListToLine(absListView, absListView.getFirstVisiblePosition() + 1);
            }
        } else if (direction == 1) {
            if (allTheWay || absListView.getFirstVisiblePosition() < 2) {
                this.scrollListToLine(absListView, 0);
                return false;
            }
            int lines = absListView.getLastVisiblePosition() - absListView.getFirstVisiblePosition();
            int lineToScrollTo = absListView.getFirstVisiblePosition() - lines;
            if (lineToScrollTo == absListView.getLastVisiblePosition()) {
                --lineToScrollTo;
            }
            if (lineToScrollTo < 0) {
                lineToScrollTo = 0;
            }
            this.scrollListToLine(absListView, lineToScrollTo);
        }
        this.sleeper.sleep();
        return true;
    }

    public <T extends AbsListView> void scrollListToLine(final T view, int line) {
        if (view == null) {
            Assert.assertTrue((String)"AbsListView is null!", (boolean)false);
        }
        final int lineToMoveTo = view instanceof GridView ? line + 1 : line;
        this.inst.runOnMainSync(new Runnable(){

            public void run() {
                view.setSelection(lineToMoveTo);
            }
        });
    }

    public void scrollToSide(Side side) {
        int screenHeight = this.activityUtils.getCurrentActivity().getWindowManager().getDefaultDisplay().getHeight();
        int screenWidth = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getWidth();
        float x = (float)screenWidth * 0.55f;
        float y = (float)screenHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(0.0f, x, y, y, 40);
        } else if (side == Side.RIGHT) {
            this.drag(x, 0.0f, y, y, 40);
        }
    }

    public void scrollViewToSide(View view, Side side) {
        int[] corners = new int[2];
        view.getLocationOnScreen(corners);
        int viewHeight = view.getHeight();
        int viewWidth = view.getWidth();
        float x = (float)corners[0] + (float)viewWidth * 0.55f;
        float y = (float)corners[1] + (float)viewHeight / 2.0f;
        if (side == Side.LEFT) {
            this.drag(corners[0], x, y, y, 40);
        } else if (side == Side.RIGHT) {
            this.drag(x, corners[0], y, y, 40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT,
        RIGHT;

    }
}

