//@line 42 "/export/home/mozilla/uild/firefox-3.0b3/src/mozilla/toolkit/content/viewZoomOverlay.js"

/** Document Zoom Management Code
 *
 * To use this, you'll need to have a getBrowser() function.
 **/

var ZoomManager = {
  get _prefBranch ZoomManager_get__prefBranch() {
    return Components.classes["@mozilla.org/preferences-service;1"]
                     .getService(Components.interfaces.nsIPrefBranch);
  },

  get MIN ZoomManager_get_MIN() {
    delete this.MIN;
    return this.MIN = this._prefBranch.getIntPref("fullZoom.minPercent") / 100;
  },

  get MAX ZoomManager_get_MAX() {
    delete this.MAX;
    return this.MAX = this._prefBranch.getIntPref("fullZoom.maxPercent") / 100;
  },

  get fullZoom ZoomManager_get_fullZoom() {
    return getBrowser().markupDocumentViewer.fullZoom;
  },

  set fullZoom ZoomManager_set_fullZoom(aVal) {
    if (aVal < this.MIN || aVal > this.MAX)
      throw Components.results.NS_ERROR_INVALID_ARG;

    return (getBrowser().markupDocumentViewer.fullZoom = aVal);
  },

  get fullZoomValues ZoomManager_get_fullZoomValues() {
    var fullZoomValues = this._prefBranch.getCharPref("toolkit.zoomManager.fullZoomValues")
                                         .split(",").map(parseFloat);
    fullZoomValues.sort();

    while (fullZoomValues[0] < this.MIN)
      fullZoomValues.shift();

    while (fullZoomValues[fullZoomValues.length - 1] > this.MAX)
      fullZoomValues.pop();

    delete this.fullZoomValues;
    return this.fullZoomValues = fullZoomValues;
  },

  enlarge: function ZoomManager_enlarge() {
    var i = this.fullZoomValues.indexOf(this.snap(this.fullZoom)) + 1;
    if (i < this.fullZoomValues.length)
      this.fullZoom = this.fullZoomValues[i];
  },

  reduce: function ZoomManager_reduce() {
    var i = this.fullZoomValues.indexOf(this.snap(this.fullZoom)) - 1;
    if (i >= 0)
      this.fullZoom = this.fullZoomValues[i];
  },

  reset: function ZoomManager_reset() {
    this.fullZoom = 1;
  },

  snap: function ZoomManager_snap(aVal) {
    var values = this.fullZoomValues;
    for (var i = 0; i < values.length; i++) {
      if (values[i] >= aVal) {
        if (i > 0 && aVal - values[i - 1] < values[i] - aVal)
          i--;
        return values[i];
      }
    }
    return values[i - 1];
  }
}
