/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is InnoTek Plugin Wrapper code.
 *
 * The Initial Developer of the Original Code is
 * InnoTek Systemberatung GmbH.
 * Portions created by the Initial Developer are Copyright (C) 2003-2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   InnoTek Systemberatung GmbH / Knut St. Osmundsen
 *   Peter Weilbacher <mozilla@weilbacher.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * ID constants.
 */

/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#ifndef NP_DEF_ID
#define NP_DEF_ID(_name, _iidspec) extern const nsIID _name
#endif


/*******************************************************************************
*   Global Variables                                                           *
*******************************************************************************/
/** @name Component and Interface IDs Constants.
 * @{
 */
#ifdef NS_CDEFAULTURIFIXUP_IID
NP_DEF_ID(kCDefaultURIFixupIID, NS_CDEFAULTURIFIXUP_IID);
#endif
#ifdef NS_CDOCSHELL_IID
NP_DEF_ID(kCDocShellIID, NS_CDOCSHELL_IID);
#endif
#ifdef NS_CEXTERNALHANDLERSERVICE_IID
NP_DEF_ID(kCExternalHandlerServiceIID, NS_CEXTERNALHANDLERSERVICE_IID);
#endif
#ifdef NS_CURILOADER_IID
NP_DEF_ID(kCURILoaderIID, NS_CURILOADER_IID);
#endif
#ifdef NS_CWEBBROWSER_IID
NP_DEF_ID(kCWebBrowserIID, NS_CWEBBROWSER_IID);
#endif
#ifdef NS_CWEBBROWSERPERSIST_IID
NP_DEF_ID(kCWebBrowserPersistIID, NS_CWEBBROWSERPERSIST_IID);
#endif
#ifdef NS_IABADDRESSCOLLECTER_IID
NP_DEF_ID(kAbAddressCollecterIID, NS_IABADDRESSCOLLECTER_IID);
#endif
#ifdef NS_IABAUTOCOMPLETESESSION_IID
NP_DEF_ID(kAbAutoCompleteSessionIID, NS_IABAUTOCOMPLETESESSION_IID);
#endif
#ifdef NS_IABBASE_IID
NP_DEF_ID(kAbBaseIID, NS_IABBASE_IID);
#endif
#ifdef NS_IABBOOLEANEXPRESSION_IID
NP_DEF_ID(kAbBooleanExpressionIID, NS_IABBOOLEANEXPRESSION_IID);
#endif
#ifdef NS_IABCARD_IID
NP_DEF_ID(kAbCardIID, NS_IABCARD_IID);
#endif
#ifdef NS_IABDIRECTORY_IID
NP_DEF_ID(kAbDirectoryIID, NS_IABDIRECTORY_IID);
#endif
#ifdef NS_IABDIRECTORYQUERY_IID
NP_DEF_ID(kAbDirectoryQueryIID, NS_IABDIRECTORYQUERY_IID);
#endif
#ifdef NS_IABDIRECTORYQUERYPROXY_IID
NP_DEF_ID(kAbDirectoryQueryProxyIID, NS_IABDIRECTORYQUERYPROXY_IID);
#endif
#ifdef NS_IABDIRECTORYSEARCH_IID
NP_DEF_ID(kAbDirectorySearchIID, NS_IABDIRECTORYSEARCH_IID);
#endif
#ifdef NS_IABDIRFACTORY_IID
NP_DEF_ID(kAbDirFactoryIID, NS_IABDIRFACTORY_IID);
#endif
#ifdef NS_IABDIRFACTORYSERVICE_IID
NP_DEF_ID(kAbDirFactoryServiceIID, NS_IABDIRFACTORYSERVICE_IID);
#endif
#ifdef NS_IABLDAPAUTOCOMPFORMATTER_IID
NP_DEF_ID(kAbLDAPAutoCompFormatterIID, NS_IABLDAPAUTOCOMPFORMATTER_IID);
#endif
#ifdef NS_IABLDAPREPLICATIONDATA_IID
NP_DEF_ID(kAbLDAPReplicationDataIID, NS_IABLDAPREPLICATIONDATA_IID);
#endif
#ifdef NS_IABLDAPREPLICATIONQUERY_IID
NP_DEF_ID(kAbLDAPReplicationQueryIID, NS_IABLDAPREPLICATIONQUERY_IID);
#endif
#ifdef NS_IABLDAPREPLICATIONSERVICE_IID
NP_DEF_ID(kAbLDAPReplicationServiceIID, NS_IABLDAPREPLICATIONSERVICE_IID);
#endif
#ifdef NS_IABLISTENER_IID
NP_DEF_ID(kAbListenerIID, NS_IABLISTENER_IID);
#endif
#ifdef NS_IABMDBCARD_IID
NP_DEF_ID(kAbMDBCardIID, NS_IABMDBCARD_IID);
#endif
#ifdef NS_IABMDBDIRECTORY_IID
NP_DEF_ID(kAbMDBDirectoryIID, NS_IABMDBDIRECTORY_IID);
#endif
#ifdef NS_IABOUTMODULE_IID
NP_DEF_ID(kAboutModuleIID, NS_IABOUTMODULE_IID);
#endif
#ifdef NS_IABUPGRADER_IID
NP_DEF_ID(kAbUpgraderIID, NS_IABUPGRADER_IID);
#endif
#ifdef NS_IABVIEW_IID
NP_DEF_ID(kAbViewIID, NS_IABVIEW_IID);
#endif
#ifdef NS_IACCESSIBILITYSERVICE_IID
NP_DEF_ID(kAccessibilityServiceIID, NS_IACCESSIBILITYSERVICE_IID);
#endif
#ifdef NS_IACCESSIBLE_IID
NP_DEF_ID(kAccessibleIID, NS_IACCESSIBLE_IID);
#endif
#ifdef NS_IACCESSIBLEACTION_IID
NP_DEF_ID(kAccessibleActionIID, NS_IACCESSIBLEACTION_IID);
#endif
#ifdef NS_IACCESSIBLECARET_IID
NP_DEF_ID(kAccessibleCaretIID, NS_IACCESSIBLECARET_IID);
#endif
#ifdef NS_IACCESSIBLEDOCUMENT_IID
NP_DEF_ID(kAccessibleDocumentIID, NS_IACCESSIBLEDOCUMENT_IID);
#endif
#ifdef NS_IACCESSIBLEEDITABLETEXT_IID
NP_DEF_ID(kAccessibleEditableTextIID, NS_IACCESSIBLEEDITABLETEXT_IID);
#endif
#ifdef NS_IACCESSIBLEEVENTLISTENER_IID
NP_DEF_ID(kAccessibleEventListenerIID, NS_IACCESSIBLEEVENTLISTENER_IID);
#endif
#ifdef NS_IACCESSIBLEEVENTRECEIVER_IID
NP_DEF_ID(kAccessibleEventReceiverIID, NS_IACCESSIBLEEVENTRECEIVER_IID);
#endif
#ifdef NS_IACCESSIBLEHYPERLINK_IID
NP_DEF_ID(kAccessibleHyperLinkIID, NS_IACCESSIBLEHYPERLINK_IID);
#endif
#ifdef NS_IACCESSIBLEHYPERTEXT_IID
NP_DEF_ID(kAccessibleHyperTextIID, NS_IACCESSIBLEHYPERTEXT_IID);
#endif
#ifdef NS_IACCESSIBLEPROVIDER_IID
NP_DEF_ID(kAccessibleProviderIID, NS_IACCESSIBLEPROVIDER_IID);
#endif
#ifdef NS_IACCESSIBLESELECTABLE_IID
NP_DEF_ID(kAccessibleSelectableIID, NS_IACCESSIBLESELECTABLE_IID);
#endif
#ifdef NS_IACCESSIBLETABLE_IID
NP_DEF_ID(kAccessibleTableIID, NS_IACCESSIBLETABLE_IID);
#endif
#ifdef NS_IACCESSIBLETEXT_IID
NP_DEF_ID(kAccessibleTextIID, NS_IACCESSIBLETEXT_IID);
#endif
#ifdef NS_IACCESSIBLEVALUE_IID
NP_DEF_ID(kAccessibleValueIID, NS_IACCESSIBLEVALUE_IID);
#endif
#ifdef NS_IACCESSIBLEWIN32OBJECT_IID
NP_DEF_ID(kAccessibleWin32ObjectIID, NS_IACCESSIBLEWIN32OBJECT_IID);
#endif
#ifdef NS_IADDBOOKURL_IID
NP_DEF_ID(kAddbookUrlIID, NS_IADDBOOKURL_IID);
#endif
#ifdef NS_IADDRBOOKSESSION_IID
NP_DEF_ID(kAddrBookSessionIID, NS_IADDRBOOKSESSION_IID);
#endif
#ifdef NS_IADDRDATABASE_IID
NP_DEF_ID(kAddrDatabaseIID, NS_IADDRDATABASE_IID);
#endif
#ifdef NS_IADDRDBANNOUNCER_IID
NP_DEF_ID(kAddrDBAnnouncerIID, NS_IADDRDBANNOUNCER_IID);
#endif
#ifdef NS_IADDRDBLISTENER_IID
NP_DEF_ID(kAddrDBListenerIID, NS_IADDRDBLISTENER_IID);
#endif
#ifdef NS_IADDRESSBOOK_IID
NP_DEF_ID(kAddressBookIID, NS_IADDRESSBOOK_IID);
#endif
#ifdef NS_IAGGREGATEPRINCIPAL_IID
NP_DEF_ID(kAggregatePrincipalIID, NS_IAGGREGATEPRINCIPAL_IID);
#endif
#ifdef NS_IAPPSHELL_IID
NP_DEF_ID(kAppShellIID, NS_IAPPSHELL_IID);
#endif
#ifdef NS_IAPPSHELLSERVICE_IID
NP_DEF_ID(kAppShellServiceIID, NS_IAPPSHELLSERVICE_IID);
#endif
#ifdef NS_IARRAY_IID
NP_DEF_ID(kArrayIID, NS_IARRAY_IID);
#endif
#ifdef NS_IASN1OBJECT_IID
NP_DEF_ID(kASN1ObjectIID, NS_IASN1OBJECT_IID);
#endif
#ifdef NS_IASN1PRINTABLEITEM_IID
NP_DEF_ID(kASN1PrintableItemIID, NS_IASN1PRINTABLEITEM_IID);
#endif
#ifdef NS_IASN1SEQUENCE_IID
NP_DEF_ID(kASN1SequenceIID, NS_IASN1SEQUENCE_IID);
#endif
#ifdef NS_IASN1TREE_IID
NP_DEF_ID(kASN1TreeIID, NS_IASN1TREE_IID);
#endif
#ifdef NS_IASYNCINPUTSTREAM_IID
NP_DEF_ID(kAsyncInputStreamIID, NS_IASYNCINPUTSTREAM_IID);
#endif
#ifdef NS_IASYNCOUTPUTSTREAM_IID
NP_DEF_ID(kAsyncOutputStreamIID, NS_IASYNCOUTPUTSTREAM_IID);
#endif
#ifdef NS_IASYNCSTREAMCOPIER_IID
NP_DEF_ID(kAsyncStreamCopierIID, NS_IASYNCSTREAMCOPIER_IID);
#endif
#ifdef NS_IATOM_IID
NP_DEF_ID(kAtomIID, NS_IATOM_IID);
#endif
#ifdef NS_IATOMSERVICE_IID
NP_DEF_ID(kAtomServiceIID, NS_IATOMSERVICE_IID);
#endif
#ifdef NS_IAUTHPROMPT_IID
NP_DEF_ID(kAuthPromptIID, NS_IAUTHPROMPT_IID);
#endif
#ifdef NS_IAUTHPROMPTWRAPPER_IID
NP_DEF_ID(kAuthPromptWrapperIID, NS_IAUTHPROMPTWRAPPER_IID);
#endif
#ifdef NS_IAUTOCOMPLETELISTENER_IID
NP_DEF_ID(kAutoCompleteListenerIID, NS_IAUTOCOMPLETELISTENER_IID);
#endif
#ifdef NS_IAUTOCOMPLETERESULTS_IID
NP_DEF_ID(kAutoCompleteResultsIID, NS_IAUTOCOMPLETERESULTS_IID);
#endif
#ifdef NS_IAUTOCOMPLETESESSION_IID
NP_DEF_ID(kAutoCompleteSessionIID, NS_IAUTOCOMPLETESESSION_IID);
#endif
#ifdef NS_IAUTOCONFIG_IID
NP_DEF_ID(kAutoConfigIID, NS_IAUTOCONFIG_IID);
#endif
#ifdef NS_IBADCERTLISTENER_IID
NP_DEF_ID(kBadCertListenerIID, NS_IBADCERTLISTENER_IID);
#endif
#ifdef NS_IBASEWINDOW_IID
NP_DEF_ID(kBaseWindowIID, NS_IBASEWINDOW_IID);
#endif
#ifdef NS_IBIDIKEYBOARD_IID
NP_DEF_ID(kBidiKeyboardIID, NS_IBIDIKEYBOARD_IID);
#endif
#ifdef NS_IBINARYINPUTSTREAM_IID
NP_DEF_ID(kBinaryInputStreamIID, NS_IBINARYINPUTSTREAM_IID);
#endif
#ifdef NS_IBINARYOUTPUTSTREAM_IID
NP_DEF_ID(kBinaryOutputStreamIID, NS_IBINARYOUTPUTSTREAM_IID);
#endif
#ifdef NS_IBOOKMARKSSERVICE_IID
NP_DEF_ID(kBookmarksServiceIID, NS_IBOOKMARKSSERVICE_IID);
#endif
#ifdef NS_IBOXLAYOUTMANAGER_IID
NP_DEF_ID(kBoxLayoutManagerIID, NS_IBOXLAYOUTMANAGER_IID);
#endif
#ifdef NS_IBOXOBJECT_IID
NP_DEF_ID(kBoxObjectIID, NS_IBOXOBJECT_IID);
#endif
#ifdef NS_IBOXPAINTMANAGER_IID
NP_DEF_ID(kBoxPaintManagerIID, NS_IBOXPAINTMANAGER_IID);
#endif
#ifdef NS_IBROWSERBOXOBJECT_IID
NP_DEF_ID(kBrowserBoxObjectIID, NS_IBROWSERBOXOBJECT_IID);
#endif
#ifdef NS_IBROWSERHISTORY_IID
NP_DEF_ID(kBrowserHistoryIID, NS_IBROWSERHISTORY_IID);
#endif
#ifdef NS_IBROWSERINSTANCE_IID
NP_DEF_ID(kBrowserInstanceIID, NS_IBROWSERINSTANCE_IID);
#endif
#ifdef NS_IBUFENTROPYCOLLECTOR_IID
NP_DEF_ID(kBufEntropyCollectorIID, NS_IBUFENTROPYCOLLECTOR_IID);
#endif
#ifdef NS_IBUFFEREDSTREAMS_IID
NP_DEF_ID(kBufferedStreamsIID, NS_IBUFFEREDSTREAMS_IID);
#endif
#ifdef NS_IBYTEARRAYINPUTSTREAM_IID
NP_DEF_ID(kByteArrayInputStreamIID, NS_IBYTEARRAYINPUTSTREAM_IID);
#endif
#ifdef NS_IBYTERANGEREQUEST_IID
NP_DEF_ID(kByteRangeRequestIID, NS_IBYTERANGEREQUEST_IID);
#endif
#ifdef NS_ICACHE_IID
NP_DEF_ID(kCacheIID, NS_ICACHE_IID);
#endif
#ifdef NS_ICACHEENTRYDESCRIPTOR_IID
NP_DEF_ID(kCacheEntryDescriptorIID, NS_ICACHEENTRYDESCRIPTOR_IID);
#endif
#ifdef NS_ICACHELISTENER_IID
NP_DEF_ID(kCacheListenerIID, NS_ICACHELISTENER_IID);
#endif
#ifdef NS_ICACHESERVICE_IID
NP_DEF_ID(kCacheServiceIID, NS_ICACHESERVICE_IID);
#endif
#ifdef NS_ICACHESESSION_IID
NP_DEF_ID(kCacheSessionIID, NS_ICACHESESSION_IID);
#endif
#ifdef NS_ICACHEVISITOR_IID
NP_DEF_ID(kCacheVisitorIID, NS_ICACHEVISITOR_IID);
#endif
#ifdef NS_ICACHINGCHANNEL_IID
NP_DEF_ID(kCachingChannelIID, NS_ICACHINGCHANNEL_IID);
#endif
#ifdef NS_ICATEGORYMANAGER_IID
NP_DEF_ID(kCategoryManagerIID, NS_ICATEGORYMANAGER_IID);
#endif
#ifdef NS_ICERTIFICATEDIALOGS_IID
NP_DEF_ID(kCertificateDialogsIID, NS_ICERTIFICATEDIALOGS_IID);
#endif
#ifdef NS_ICERTIFICATEPRINCIPAL_IID
NP_DEF_ID(kCertificatePrincipalIID, NS_ICERTIFICATEPRINCIPAL_IID);
#endif
#ifdef NS_ICERTPICKDIALOGS_IID
NP_DEF_ID(kCertPickDialogsIID, NS_ICERTPICKDIALOGS_IID);
#endif
#ifdef NS_ICERTSELECT_IID
NP_DEF_ID(kCertSelectIID, NS_ICERTSELECT_IID);
#endif
#ifdef NS_ICERTTREE_IID
NP_DEF_ID(kCertTreeIID, NS_ICERTTREE_IID);
#endif
#ifdef NS_ICHANNEL_IID
NP_DEF_ID(kChannelIID, NS_ICHANNEL_IID);
#endif
#ifdef NS_ICHARSETCONVERTERMANAGER2_IID
NP_DEF_ID(kCharsetConverterManager2IID, NS_ICHARSETCONVERTERMANAGER2_IID);
#endif
#ifdef NS_ICHROMEEVENTHANDLER_IID
NP_DEF_ID(kChromeEventHandlerIID, NS_ICHROMEEVENTHANDLER_IID);
#endif
#ifdef NS_ICHROMEREGISTRY_IID
NP_DEF_ID(kChromeRegistryIID, NS_ICHROMEREGISTRY_IID);
#endif
#ifdef NS_ICIPHERINFO_IID
NP_DEF_ID(kCipherInfoIID, NS_ICIPHERINFO_IID);
#endif
#ifdef NS_ICITER_IID
NP_DEF_ID(kCiterIID, NS_ICITER_IID);
#endif
#ifdef NS_ICLASSICPLUGINFACTORY_IID
NP_DEF_ID(kClassicPluginFactoryIID, NS_ICLASSICPLUGINFACTORY_IID);
#endif
#ifdef NS_ICLASSINFO_IID
NP_DEF_ID(kClassInfoIID, NS_ICLASSINFO_IID);
#endif
#ifdef NS_ICLIENTAUTHDIALOGS_IID
NP_DEF_ID(kClientAuthDialogsIID, NS_ICLIENTAUTHDIALOGS_IID);
#endif
#ifdef NS_ICLIPBOARD_IID
NP_DEF_ID(kClipboardIID, NS_ICLIPBOARD_IID);
#endif
#ifdef NS_ICLIPBOARDCOMMANDS_IID
NP_DEF_ID(kClipboardCommandsIID, NS_ICLIPBOARDCOMMANDS_IID);
#endif
#ifdef NS_ICLIPBOARDHELPER_IID
NP_DEF_ID(kClipboardHelperIID, NS_ICLIPBOARDHELPER_IID);
#endif
#ifdef NS_ICLIPBOARDOWNER_IID
NP_DEF_ID(kClipboardOwnerIID, NS_ICLIPBOARDOWNER_IID);
#endif
#ifdef NS_ICLOSEALLWINDOWS_IID
NP_DEF_ID(kCloseAllWindowsIID, NS_ICLOSEALLWINDOWS_IID);
#endif
#ifdef NS_ICMDLINEHANDLER_IID
NP_DEF_ID(kCmdLineHandlerIID, NS_ICMDLINEHANDLER_IID);
#endif
#ifdef NS_ICMDLINESERVICE_IID
NP_DEF_ID(kCmdLineServiceIID, NS_ICMDLINESERVICE_IID);
#endif
#ifdef NS_ICMSDECODER_IID
NP_DEF_ID(kCMSDecoderIID, NS_ICMSDECODER_IID);
#endif
#ifdef NS_ICMSENCODER_IID
NP_DEF_ID(kCMSEncoderIID, NS_ICMSENCODER_IID);
#endif
#ifdef NS_ICMSMESSAGE_IID
NP_DEF_ID(kCMSMessageIID, NS_ICMSMESSAGE_IID);
#endif
#ifdef NS_ICMSMESSAGEERRORS_IID
NP_DEF_ID(kCMSMessageErrorsIID, NS_ICMSMESSAGEERRORS_IID);
#endif
#ifdef NS_ICMSSECUREMESSAGE_IID
NP_DEF_ID(kCMSSecureMessageIID, NS_ICMSSECUREMESSAGE_IID);
#endif
#ifdef NS_ICODEBASEPRINCIPAL_IID
NP_DEF_ID(kCodebasePrincipalIID, NS_ICODEBASEPRINCIPAL_IID);
#endif
#ifdef NS_ICOLLECTION_IID
NP_DEF_ID(kCollectionIID, NS_ICOLLECTION_IID);
#endif
#ifdef NS_ICOMM4XPROFILE_IID
NP_DEF_ID(kComm4xProfileIID, NS_ICOMM4XPROFILE_IID);
#endif
#ifdef NS_ICOMMANDHANDLER_IID
NP_DEF_ID(kCommandHandlerIID, NS_ICOMMANDHANDLER_IID);
#endif
#ifdef NS_ICOMMANDMANAGER_IID
NP_DEF_ID(kCommandManagerIID, NS_ICOMMANDMANAGER_IID);
#endif
#ifdef NS_ICOMMANDPARAMS_IID
NP_DEF_ID(kCommandParamsIID, NS_ICOMMANDPARAMS_IID);
#endif
#ifdef NS_ICOMPONENTLOADER_IID
NP_DEF_ID(kComponentLoaderIID, NS_ICOMPONENTLOADER_IID);
#endif
#ifdef NS_ICOMPONENTLOADERMANAGER_IID
NP_DEF_ID(kComponentLoaderManagerIID, NS_ICOMPONENTLOADERMANAGER_IID);
#endif
#ifdef NS_ICOMPONENTMANAGER_IID
NP_DEF_ID(kComponentManagerIID, NS_ICOMPONENTMANAGER_IID);
#endif
#ifdef NS_ICOMPONENTMANAGEROBSOLETE_IID
NP_DEF_ID(kComponentManagerObsoleteIID, NS_ICOMPONENTMANAGEROBSOLETE_IID);
#endif
#ifdef NS_ICOMPONENTREGISTRAR_IID
NP_DEF_ID(kComponentRegistrarIID, NS_ICOMPONENTREGISTRAR_IID);
#endif
#ifdef NS_ICONSOLELISTENER_IID
NP_DEF_ID(kConsoleListenerIID, NS_ICONSOLELISTENER_IID);
#endif
#ifdef NS_ICONSOLEMESSAGE_IID
NP_DEF_ID(kConsoleMessageIID, NS_ICONSOLEMESSAGE_IID);
#endif
#ifdef NS_ICONSOLESERVICE_IID
NP_DEF_ID(kConsoleServiceIID, NS_ICONSOLESERVICE_IID);
#endif
#ifdef NS_ICONTENTHANDLER_IID
NP_DEF_ID(kContentHandlerIID, NS_ICONTENTHANDLER_IID);
#endif
#ifdef NS_ICONTENTPOLICY_IID
NP_DEF_ID(kContentPolicyIID, NS_ICONTENTPOLICY_IID);
#endif
#ifdef NS_ICONTENTVIEWER_IID
NP_DEF_ID(kContentViewerIID, NS_ICONTENTVIEWER_IID);
#endif
#ifdef NS_ICONTENTVIEWERCONTAINER_IID
NP_DEF_ID(kContentViewerContainerIID, NS_ICONTENTVIEWERCONTAINER_IID);
#endif
#ifdef NS_ICONTENTVIEWEREDIT_IID
NP_DEF_ID(kContentViewerEditIID, NS_ICONTENTVIEWEREDIT_IID);
#endif
#ifdef NS_ICONTENTVIEWERFILE_IID
NP_DEF_ID(kContentViewerFileIID, NS_ICONTENTVIEWERFILE_IID);
#endif
#ifdef NS_ICONTEXTMENULISTENER_IID
NP_DEF_ID(kContextMenuListenerIID, NS_ICONTEXTMENULISTENER_IID);
#endif
#ifdef NS_ICONTEXTMENULISTENER2_IID
NP_DEF_ID(kContextMenuListener2IID, NS_ICONTEXTMENULISTENER2_IID);
#endif
#ifdef NS_ICONTROLLER_IID
NP_DEF_ID(kControllerIID, NS_ICONTROLLER_IID);
#endif
#ifdef NS_ICONTROLLERCOMMAND_IID
NP_DEF_ID(kControllerCommandIID, NS_ICONTROLLERCOMMAND_IID);
#endif
#ifdef NS_ICONTROLLERCOMMANDMANAGER_IID
NP_DEF_ID(kControllerCommandManagerIID, NS_ICONTROLLERCOMMANDMANAGER_IID);
#endif
#ifdef NS_ICONTROLLERCONTEXT_IID
NP_DEF_ID(kControllerContextIID, NS_ICONTROLLERCONTEXT_IID);
#endif
#ifdef NS_ICONTROLLERS_IID
NP_DEF_ID(kControllersIID, NS_ICONTROLLERS_IID);
#endif
#ifdef NS_ICOOKIE_IID
NP_DEF_ID(kCookieIID, NS_ICOOKIE_IID);
#endif
#ifdef NS_ICOOKIEACCEPTDIALOG_IID
NP_DEF_ID(kCookieAcceptDialogIID, NS_ICOOKIEACCEPTDIALOG_IID);
#endif
#ifdef NS_ICOOKIECONSENT_IID
NP_DEF_ID(kCookieConsentIID, NS_ICOOKIECONSENT_IID);
#endif
#ifdef NS_ICOOKIEMANAGER_IID
NP_DEF_ID(kCookieManagerIID, NS_ICOOKIEMANAGER_IID);
#endif
#ifdef NS_ICOOKIEMANAGER2_IID
NP_DEF_ID(kCookieManager2IID, NS_ICOOKIEMANAGER2_IID);
#endif
#ifdef NS_ICOOKIEPROMPTSERVICE_IID
NP_DEF_ID(kCookiePromptServiceIID, NS_ICOOKIEPROMPTSERVICE_IID);
#endif
#ifdef NS_ICOOKIESERVICE_IID
NP_DEF_ID(kCookieServiceIID, NS_ICOOKIESERVICE_IID);
#endif
#ifdef NS_ICOOKIESTORAGE_IID
NP_DEF_ID(kCookieStorageIID, NS_ICOOKIESTORAGE_IID);
#endif
#ifdef NS_ICOPYMESSAGELISTENER_IID
NP_DEF_ID(kCopyMessageListenerIID, NS_ICOPYMESSAGELISTENER_IID);
#endif
#ifdef NS_ICOPYMSGSTREAMLISTENER_IID
NP_DEF_ID(kCopyMsgStreamListenerIID, NS_ICOPYMSGSTREAMLISTENER_IID);
#endif
#ifdef NS_ICRLINFO_IID
NP_DEF_ID(kCRLInfoIID, NS_ICRLINFO_IID);
#endif
#ifdef NS_ICRLMANAGER_IID
NP_DEF_ID(kCRLManagerIID, NS_ICRLMANAGER_IID);
#endif
#ifdef NS_ICURRENTCHARSETLISTENER_IID
NP_DEF_ID(kCurrentCharsetListenerIID, NS_ICURRENTCHARSETLISTENER_IID);
#endif
#ifdef NS_IDATACHANNEL_IID
NP_DEF_ID(kDataChannelIID, NS_IDATACHANNEL_IID);
#endif
#ifdef NS_IDBCHANGEANNOUNCER_IID
NP_DEF_ID(kDBChangeAnnouncerIID, NS_IDBCHANGEANNOUNCER_IID);
#endif
#ifdef NS_IDBCHANGELISTENER_IID
NP_DEF_ID(kDBChangeListenerIID, NS_IDBCHANGELISTENER_IID);
#endif
#ifdef NS_IDBFOLDERINFO_IID
NP_DEF_ID(kDBFolderInfoIID, NS_IDBFOLDERINFO_IID);
#endif
#ifdef NS_IDIALOGPARAMBLOCK_IID
NP_DEF_ID(kDialogParamBlockIID, NS_IDIALOGPARAMBLOCK_IID);
#endif
#ifdef NS_IDICTIONARY_IID
NP_DEF_ID(kDictionaryIID, NS_IDICTIONARY_IID);
#endif
#ifdef NS_IDIRECTORYLISTING_IID
NP_DEF_ID(kDirectoryListingIID, NS_IDIRECTORYLISTING_IID);
#endif
#ifdef NS_IDIRECTORYSERVICE_IID
NP_DEF_ID(kDirectoryServiceIID, NS_IDIRECTORYSERVICE_IID);
#endif
#ifdef NS_IDIRINDEX_IID
NP_DEF_ID(kDirIndexIID, NS_IDIRINDEX_IID);
#endif
#ifdef NS_IDIRINDEXLISTENER_IID
NP_DEF_ID(kDirIndexListenerIID, NS_IDIRINDEXLISTENER_IID);
#endif
#ifdef NS_IDNSLISTENER_IID
NP_DEF_ID(kDNSListenerIID, NS_IDNSLISTENER_IID);
#endif
#ifdef NS_IDNSSERVICE_IID
NP_DEF_ID(kDNSServiceIID, NS_IDNSSERVICE_IID);
#endif
#ifdef NS_IDOCCHARSET_IID
NP_DEF_ID(kDocCharsetIID, NS_IDOCCHARSET_IID);
#endif
#ifdef NS_IDOCSHELL_IID
NP_DEF_ID(kDocShellIID, NS_IDOCSHELL_IID);
#endif
#ifdef NS_IDOCSHELLHISTORY_IID
NP_DEF_ID(kDocShellHistoryIID, NS_IDOCSHELLHISTORY_IID);
#endif
#ifdef NS_IDOCSHELLLOADINFO_IID
NP_DEF_ID(kDocShellLoadInfoIID, NS_IDOCSHELLLOADINFO_IID);
#endif
#ifdef NS_IDOCSHELLTREEITEM_IID
NP_DEF_ID(kDocShellTreeItemIID, NS_IDOCSHELLTREEITEM_IID);
#endif
#ifdef NS_IDOCSHELLTREENODE_IID
NP_DEF_ID(kDocShellTreeNodeIID, NS_IDOCSHELLTREENODE_IID);
#endif
#ifdef NS_IDOCSHELLTREEOWNER_IID
NP_DEF_ID(kDocShellTreeOwnerIID, NS_IDOCSHELLTREEOWNER_IID);
#endif
#ifdef NS_IDOCUMENTCHARSETINFO_IID
NP_DEF_ID(kDocumentCharsetInfoIID, NS_IDOCUMENTCHARSETINFO_IID);
#endif
#ifdef NS_IDOCUMENTLOADER_IID
NP_DEF_ID(kDocumentLoaderIID, NS_IDOCUMENTLOADER_IID);
#endif
#ifdef NS_IDOCUMENTLOADERFACTORY_IID
NP_DEF_ID(kDocumentLoaderFactoryIID, NS_IDOCUMENTLOADERFACTORY_IID);
#endif
#ifdef NS_IDOCUMENTSTATELISTENER_IID
NP_DEF_ID(kDocumentStateListenerIID, NS_IDOCUMENTSTATELISTENER_IID);
#endif
#ifdef NS_IDOM3DOCUMENTEVENT_IID
NP_DEF_ID(kDOM3DocumentEventIID, NS_IDOM3DOCUMENTEVENT_IID);
#endif
#ifdef NS_IDOM3EVENTTARGET_IID
NP_DEF_ID(kDOM3EventTargetIID, NS_IDOM3EVENTTARGET_IID);
#endif
#ifdef NS_IDOM3NODE_IID
NP_DEF_ID(kDOM3NodeIID, NS_IDOM3NODE_IID);
#endif
#ifdef NS_IDOMABSTRACTVIEW_IID
NP_DEF_ID(kDOMAbstractViewIID, NS_IDOMABSTRACTVIEW_IID);
#endif
#ifdef NS_IDOMATTR_IID
NP_DEF_ID(kDOMAttrIID, NS_IDOMATTR_IID);
#endif
#ifdef NS_IDOMBARPROP_IID
NP_DEF_ID(kDOMBarPropIID, NS_IDOMBARPROP_IID);
#endif
#ifdef NS_IDOMCDATASECTION_IID
NP_DEF_ID(kDOMCDATASectionIID, NS_IDOMCDATASECTION_IID);
#endif
#ifdef NS_IDOMCHARACTERDATA_IID
NP_DEF_ID(kDOMCharacterDataIID, NS_IDOMCHARACTERDATA_IID);
#endif
#ifdef NS_IDOMCHROMEWINDOW_IID
NP_DEF_ID(kDOMChromeWindowIID, NS_IDOMCHROMEWINDOW_IID);
#endif
#ifdef NS_IDOMCOMMENT_IID
NP_DEF_ID(kDOMCommentIID, NS_IDOMCOMMENT_IID);
#endif
#ifdef NS_IDOMCOUNTER_IID
NP_DEF_ID(kDOMCounterIID, NS_IDOMCOUNTER_IID);
#endif
#ifdef NS_IDOMCRMFOBJECT_IID
NP_DEF_ID(kDOMCRMFObjectIID, NS_IDOMCRMFOBJECT_IID);
#endif
#ifdef NS_IDOMCRYPTO_IID
NP_DEF_ID(kDOMCryptoIID, NS_IDOMCRYPTO_IID);
#endif
#ifdef NS_IDOMCRYPTODIALOGS_IID
NP_DEF_ID(kDOMCryptoDialogsIID, NS_IDOMCRYPTODIALOGS_IID);
#endif
#ifdef NS_IDOMCSS2PROPERTIES_IID
NP_DEF_ID(kDOMCSS2PropertiesIID, NS_IDOMCSS2PROPERTIES_IID);
#endif
#ifdef NS_IDOMCSSCHARSETRULE_IID
NP_DEF_ID(kDOMCSSCharsetRuleIID, NS_IDOMCSSCHARSETRULE_IID);
#endif
#ifdef NS_IDOMCSSFONTFACERULE_IID
NP_DEF_ID(kDOMCSSFontFaceRuleIID, NS_IDOMCSSFONTFACERULE_IID);
#endif
#ifdef NS_IDOMCSSIMPORTRULE_IID
NP_DEF_ID(kDOMCSSImportRuleIID, NS_IDOMCSSIMPORTRULE_IID);
#endif
#ifdef NS_IDOMCSSMEDIARULE_IID
NP_DEF_ID(kDOMCSSMediaRuleIID, NS_IDOMCSSMEDIARULE_IID);
#endif
#ifdef NS_IDOMCSSPAGERULE_IID
NP_DEF_ID(kDOMCSSPageRuleIID, NS_IDOMCSSPAGERULE_IID);
#endif
#ifdef NS_IDOMCSSPRIMITIVEVALUE_IID
NP_DEF_ID(kDOMCSSPrimitiveValueIID, NS_IDOMCSSPRIMITIVEVALUE_IID);
#endif
#ifdef NS_IDOMCSSRULE_IID
NP_DEF_ID(kDOMCSSRuleIID, NS_IDOMCSSRULE_IID);
#endif
#ifdef NS_IDOMCSSRULELIST_IID
NP_DEF_ID(kDOMCSSRuleListIID, NS_IDOMCSSRULELIST_IID);
#endif
#ifdef NS_IDOMCSSSTYLEDECLARATION_IID
NP_DEF_ID(kDOMCSSStyleDeclarationIID, NS_IDOMCSSSTYLEDECLARATION_IID);
#endif
#ifdef NS_IDOMCSSSTYLERULE_IID
NP_DEF_ID(kDOMCSSStyleRuleIID, NS_IDOMCSSSTYLERULE_IID);
#endif
#ifdef NS_IDOMCSSSTYLESHEET_IID
NP_DEF_ID(kDOMCSSStyleSheetIID, NS_IDOMCSSSTYLESHEET_IID);
#endif
#ifdef NS_IDOMCSSUNKNOWNRULE_IID
NP_DEF_ID(kDOMCSSUnknownRuleIID, NS_IDOMCSSUNKNOWNRULE_IID);
#endif
#ifdef NS_IDOMCSSVALUE_IID
NP_DEF_ID(kDOMCSSValueIID, NS_IDOMCSSVALUE_IID);
#endif
#ifdef NS_IDOMCSSVALUELIST_IID
NP_DEF_ID(kDOMCSSValueListIID, NS_IDOMCSSVALUELIST_IID);
#endif
#ifdef NS_IDOMDOCUMENT_IID
NP_DEF_ID(kDOMDocumentIID, NS_IDOMDOCUMENT_IID);
#endif
#ifdef NS_IDOMDOCUMENTCSS_IID
NP_DEF_ID(kDOMDocumentCSSIID, NS_IDOMDOCUMENTCSS_IID);
#endif
#ifdef NS_IDOMDOCUMENTEVENT_IID
NP_DEF_ID(kDOMDocumentEventIID, NS_IDOMDOCUMENTEVENT_IID);
#endif
#ifdef NS_IDOMDOCUMENTFRAGMENT_IID
NP_DEF_ID(kDOMDocumentFragmentIID, NS_IDOMDOCUMENTFRAGMENT_IID);
#endif
#ifdef NS_IDOMDOCUMENTRANGE_IID
NP_DEF_ID(kDOMDocumentRangeIID, NS_IDOMDOCUMENTRANGE_IID);
#endif
#ifdef NS_IDOMDOCUMENTSTYLE_IID
NP_DEF_ID(kDOMDocumentStyleIID, NS_IDOMDOCUMENTSTYLE_IID);
#endif
#ifdef NS_IDOMDOCUMENTTRAVERSAL_IID
NP_DEF_ID(kDOMDocumentTraversalIID, NS_IDOMDOCUMENTTRAVERSAL_IID);
#endif
#ifdef NS_IDOMDOCUMENTTYPE_IID
NP_DEF_ID(kDOMDocumentTypeIID, NS_IDOMDOCUMENTTYPE_IID);
#endif
#ifdef NS_IDOMDOCUMENTVIEW_IID
NP_DEF_ID(kDOMDocumentViewIID, NS_IDOMDOCUMENTVIEW_IID);
#endif
#ifdef NS_IDOMDOCUMENTXBL_IID
NP_DEF_ID(kDOMDocumentXBLIID, NS_IDOMDOCUMENTXBL_IID);
#endif
#ifdef NS_IDOMDOMEXCEPTION_IID
NP_DEF_ID(kDOMDOMExceptionIID, NS_IDOMDOMEXCEPTION_IID);
#endif
#ifdef NS_IDOMDOMIMPLEMENTATION_IID
NP_DEF_ID(kDOMDOMImplementationIID, NS_IDOMDOMIMPLEMENTATION_IID);
#endif
#ifdef NS_IDOMELEMENT_IID
NP_DEF_ID(kDOMElementIID, NS_IDOMELEMENT_IID);
#endif
#ifdef NS_IDOMELEMENTCSSINLINESTYLE_IID
NP_DEF_ID(kDOMElementCSSInlineStyleIID, NS_IDOMELEMENTCSSINLINESTYLE_IID);
#endif
#ifdef NS_IDOMENTITY_IID
NP_DEF_ID(kDOMEntityIID, NS_IDOMENTITY_IID);
#endif
#ifdef NS_IDOMENTITYREFERENCE_IID
NP_DEF_ID(kDOMEntityReferenceIID, NS_IDOMENTITYREFERENCE_IID);
#endif
#ifdef NS_IDOMEVENT_IID
NP_DEF_ID(kDOMEventIID, NS_IDOMEVENT_IID);
#endif
#ifdef NS_IDOMEVENTGROUP_IID
NP_DEF_ID(kDOMEventGroupIID, NS_IDOMEVENTGROUP_IID);
#endif
#ifdef NS_IDOMEVENTLISTENER_IID
NP_DEF_ID(kDOMEventListenerIID, NS_IDOMEVENTLISTENER_IID);
#endif
#ifdef NS_IDOMEVENTTARGET_IID
NP_DEF_ID(kDOMEventTargetIID, NS_IDOMEVENTTARGET_IID);
#endif
#ifdef NS_IDOMHISTORY_IID
NP_DEF_ID(kDOMHistoryIID, NS_IDOMHISTORY_IID);
#endif
#ifdef NS_IDOMHTMLANCHORELEMENT_IID
NP_DEF_ID(kDOMHTMLAnchorElementIID, NS_IDOMHTMLANCHORELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLAPPLETELEMENT_IID
NP_DEF_ID(kDOMHTMLAppletElementIID, NS_IDOMHTMLAPPLETELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLAREAELEMENT_IID
NP_DEF_ID(kDOMHTMLAreaElementIID, NS_IDOMHTMLAREAELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLBASEELEMENT_IID
NP_DEF_ID(kDOMHTMLBaseElementIID, NS_IDOMHTMLBASEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLBASEFONTELEMENT_IID
NP_DEF_ID(kDOMHTMLBaseFontElementIID, NS_IDOMHTMLBASEFONTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLBODYELEMENT_IID
NP_DEF_ID(kDOMHTMLBodyElementIID, NS_IDOMHTMLBODYELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLBRELEMENT_IID
NP_DEF_ID(kDOMHTMLBRElementIID, NS_IDOMHTMLBRELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLBUTTONELEMENT_IID
NP_DEF_ID(kDOMHTMLButtonElementIID, NS_IDOMHTMLBUTTONELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLCOLLECTION_IID
NP_DEF_ID(kDOMHTMLCollectionIID, NS_IDOMHTMLCOLLECTION_IID);
#endif
#ifdef NS_IDOMHTMLDIRECTORYELEMENT_IID
NP_DEF_ID(kDOMHTMLDirectoryElementIID, NS_IDOMHTMLDIRECTORYELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLDIVELEMENT_IID
NP_DEF_ID(kDOMHTMLDivElementIID, NS_IDOMHTMLDIVELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLDLISTELEMENT_IID
NP_DEF_ID(kDOMHTMLDListElementIID, NS_IDOMHTMLDLISTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLDOCUMENT_IID
NP_DEF_ID(kDOMHTMLDocumentIID, NS_IDOMHTMLDOCUMENT_IID);
#endif
#ifdef NS_IDOMHTMLELEMENT_IID
NP_DEF_ID(kDOMHTMLElementIID, NS_IDOMHTMLELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLEMBEDELEMENT_IID
NP_DEF_ID(kDOMHTMLEmbedElementIID, NS_IDOMHTMLEMBEDELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLFIELDSETELEMENT_IID
NP_DEF_ID(kDOMHTMLFieldSetElementIID, NS_IDOMHTMLFIELDSETELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLFONTELEMENT_IID
NP_DEF_ID(kDOMHTMLFontElementIID, NS_IDOMHTMLFONTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLFORMELEMENT_IID
NP_DEF_ID(kDOMHTMLFormElementIID, NS_IDOMHTMLFORMELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLFRAMEELEMENT_IID
NP_DEF_ID(kDOMHTMLFrameElementIID, NS_IDOMHTMLFRAMEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLFRAMESETELEMENT_IID
NP_DEF_ID(kDOMHTMLFrameSetElementIID, NS_IDOMHTMLFRAMESETELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLHEADELEMENT_IID
NP_DEF_ID(kDOMHTMLHeadElementIID, NS_IDOMHTMLHEADELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLHEADINGELEMENT_IID
NP_DEF_ID(kDOMHTMLHeadingElementIID, NS_IDOMHTMLHEADINGELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLHRELEMENT_IID
NP_DEF_ID(kDOMHTMLHRElementIID, NS_IDOMHTMLHRELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLHTMLELEMENT_IID
NP_DEF_ID(kDOMHTMLHtmlElementIID, NS_IDOMHTMLHTMLELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLIFRAMEELEMENT_IID
NP_DEF_ID(kDOMHTMLIFrameElementIID, NS_IDOMHTMLIFRAMEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLIMAGEELEMENT_IID
NP_DEF_ID(kDOMHTMLImageElementIID, NS_IDOMHTMLIMAGEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLINPUTELEMENT_IID
NP_DEF_ID(kDOMHTMLInputElementIID, NS_IDOMHTMLINPUTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLISINDEXELEMENT_IID
NP_DEF_ID(kDOMHTMLIsIndexElementIID, NS_IDOMHTMLISINDEXELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLLABELELEMENT_IID
NP_DEF_ID(kDOMHTMLLabelElementIID, NS_IDOMHTMLLABELELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLLEGENDELEMENT_IID
NP_DEF_ID(kDOMHTMLLegendElementIID, NS_IDOMHTMLLEGENDELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLLIELEMENT_IID
NP_DEF_ID(kDOMHTMLLIElementIID, NS_IDOMHTMLLIELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLLINKELEMENT_IID
NP_DEF_ID(kDOMHTMLLinkElementIID, NS_IDOMHTMLLINKELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLMAPELEMENT_IID
NP_DEF_ID(kDOMHTMLMapElementIID, NS_IDOMHTMLMAPELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLMENUELEMENT_IID
NP_DEF_ID(kDOMHTMLMenuElementIID, NS_IDOMHTMLMENUELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLMETAELEMENT_IID
NP_DEF_ID(kDOMHTMLMetaElementIID, NS_IDOMHTMLMETAELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLMODELEMENT_IID
NP_DEF_ID(kDOMHTMLModElementIID, NS_IDOMHTMLMODELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLOBJECTELEMENT_IID
NP_DEF_ID(kDOMHTMLObjectElementIID, NS_IDOMHTMLOBJECTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLOLISTELEMENT_IID
NP_DEF_ID(kDOMHTMLOListElementIID, NS_IDOMHTMLOLISTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLOPTGROUPELEMENT_IID
NP_DEF_ID(kDOMHTMLOptGroupElementIID, NS_IDOMHTMLOPTGROUPELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLOPTIONELEMENT_IID
NP_DEF_ID(kDOMHTMLOptionElementIID, NS_IDOMHTMLOPTIONELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLPARAGRAPHELEMENT_IID
NP_DEF_ID(kDOMHTMLParagraphElementIID, NS_IDOMHTMLPARAGRAPHELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLPARAMELEMENT_IID
NP_DEF_ID(kDOMHTMLParamElementIID, NS_IDOMHTMLPARAMELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLPREELEMENT_IID
NP_DEF_ID(kDOMHTMLPreElementIID, NS_IDOMHTMLPREELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLQUOTEELEMENT_IID
NP_DEF_ID(kDOMHTMLQuoteElementIID, NS_IDOMHTMLQUOTEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLSCRIPTELEMENT_IID
NP_DEF_ID(kDOMHTMLScriptElementIID, NS_IDOMHTMLSCRIPTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLSELECTELEMENT_IID
NP_DEF_ID(kDOMHTMLSelectElementIID, NS_IDOMHTMLSELECTELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLSTYLEELEMENT_IID
NP_DEF_ID(kDOMHTMLStyleElementIID, NS_IDOMHTMLSTYLEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTABLECAPTIONELEM_IID
NP_DEF_ID(kDOMHTMLTableCaptionElemIID, NS_IDOMHTMLTABLECAPTIONELEM_IID);
#endif
#ifdef NS_IDOMHTMLTABLECELLELEMENT_IID
NP_DEF_ID(kDOMHTMLTableCellElementIID, NS_IDOMHTMLTABLECELLELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTABLECOLELEMENT_IID
NP_DEF_ID(kDOMHTMLTableColElementIID, NS_IDOMHTMLTABLECOLELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTABLEELEMENT_IID
NP_DEF_ID(kDOMHTMLTableElementIID, NS_IDOMHTMLTABLEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTABLEROWELEMENT_IID
NP_DEF_ID(kDOMHTMLTableRowElementIID, NS_IDOMHTMLTABLEROWELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTABLESECTIONELEM_IID
NP_DEF_ID(kDOMHTMLTableSectionElemIID, NS_IDOMHTMLTABLESECTIONELEM_IID);
#endif
#ifdef NS_IDOMHTMLTEXTAREAELEMENT_IID
NP_DEF_ID(kDOMHTMLTextAreaElementIID, NS_IDOMHTMLTEXTAREAELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLTITLEELEMENT_IID
NP_DEF_ID(kDOMHTMLTitleElementIID, NS_IDOMHTMLTITLEELEMENT_IID);
#endif
#ifdef NS_IDOMHTMLULISTELEMENT_IID
NP_DEF_ID(kDOMHTMLUListElementIID, NS_IDOMHTMLULISTELEMENT_IID);
#endif
#ifdef NS_IDOMJSWINDOW_IID
NP_DEF_ID(kDOMJSWindowIID, NS_IDOMJSWINDOW_IID);
#endif
#ifdef NS_IDOMKEYEVENT_IID
NP_DEF_ID(kDOMKeyEventIID, NS_IDOMKEYEVENT_IID);
#endif
#ifdef NS_IDOMLINKSTYLE_IID
NP_DEF_ID(kDOMLinkStyleIID, NS_IDOMLINKSTYLE_IID);
#endif
#ifdef NS_IDOMLOCATION_IID
NP_DEF_ID(kDOMLocationIID, NS_IDOMLOCATION_IID);
#endif
#ifdef NS_IDOMMEDIALIST_IID
NP_DEF_ID(kDOMMediaListIID, NS_IDOMMEDIALIST_IID);
#endif
#ifdef NS_IDOMMIMETYPE_IID
NP_DEF_ID(kDOMMimeTypeIID, NS_IDOMMIMETYPE_IID);
#endif
#ifdef NS_IDOMMIMETYPEARRAY_IID
NP_DEF_ID(kDOMMimeTypeArrayIID, NS_IDOMMIMETYPEARRAY_IID);
#endif
#ifdef NS_IDOMMOUSEEVENT_IID
NP_DEF_ID(kDOMMouseEventIID, NS_IDOMMOUSEEVENT_IID);
#endif
#ifdef NS_IDOMMUTATIONEVENT_IID
NP_DEF_ID(kDOMMutationEventIID, NS_IDOMMUTATIONEVENT_IID);
#endif
#ifdef NS_IDOMNAMEDNODEMAP_IID
NP_DEF_ID(kDOMNamedNodeMapIID, NS_IDOMNAMEDNODEMAP_IID);
#endif
#ifdef NS_IDOMNAVIGATOR_IID
NP_DEF_ID(kDOMNavigatorIID, NS_IDOMNAVIGATOR_IID);
#endif
#ifdef NS_IDOMNODE_IID
NP_DEF_ID(kDOMNodeIID, NS_IDOMNODE_IID);
#endif
#ifdef NS_IDOMNODEFILTER_IID
NP_DEF_ID(kDOMNodeFilterIID, NS_IDOMNODEFILTER_IID);
#endif
#ifdef NS_IDOMNODEITERATOR_IID
NP_DEF_ID(kDOMNodeIteratorIID, NS_IDOMNODEITERATOR_IID);
#endif
#ifdef NS_IDOMNODELIST_IID
NP_DEF_ID(kDOMNodeListIID, NS_IDOMNODELIST_IID);
#endif
#ifdef NS_IDOMNOTATION_IID
NP_DEF_ID(kDOMNotationIID, NS_IDOMNOTATION_IID);
#endif
#ifdef NS_IDOMNSDOCUMENT_IID
NP_DEF_ID(kDOMNSDocumentIID, NS_IDOMNSDOCUMENT_IID);
#endif
#ifdef NS_IDOMNSEVENT_IID
NP_DEF_ID(kDOMNSEventIID, NS_IDOMNSEVENT_IID);
#endif
#ifdef NS_IDOMNSHISTORY_IID
NP_DEF_ID(kDOMNSHistoryIID, NS_IDOMNSHISTORY_IID);
#endif
#ifdef NS_IDOMNSHTMLANCHORELEMENT_IID
NP_DEF_ID(kDOMNSHTMLAnchorElementIID, NS_IDOMNSHTMLANCHORELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLAREAELEMENT_IID
NP_DEF_ID(kDOMNSHTMLAreaElementIID, NS_IDOMNSHTMLAREAELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLBUTTONELEMENT_IID
NP_DEF_ID(kDOMNSHTMLButtonElementIID, NS_IDOMNSHTMLBUTTONELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLDOCUMENT_IID
NP_DEF_ID(kDOMNSHTMLDocumentIID, NS_IDOMNSHTMLDOCUMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLELEMENT_IID
NP_DEF_ID(kDOMNSHTMLElementIID, NS_IDOMNSHTMLELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLFORMCONTROLLIST_IID
NP_DEF_ID(kDOMNSHTMLFormControlListIID, NS_IDOMNSHTMLFORMCONTROLLIST_IID);
#endif
#ifdef NS_IDOMNSHTMLFORMELEMENT_IID
NP_DEF_ID(kDOMNSHTMLFormElementIID, NS_IDOMNSHTMLFORMELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLFRAMEELEMENT_IID
NP_DEF_ID(kDOMNSHTMLFrameElementIID, NS_IDOMNSHTMLFRAMEELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLIMAGEELEMENT_IID
NP_DEF_ID(kDOMNSHTMLImageElementIID, NS_IDOMNSHTMLIMAGEELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLINPUTELEMENT_IID
NP_DEF_ID(kDOMNSHTMLInputElementIID, NS_IDOMNSHTMLINPUTELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLOPTIONCOLLECTN_IID
NP_DEF_ID(kDOMNSHTMLOptionCollectnIID, NS_IDOMNSHTMLOPTIONCOLLECTN_IID);
#endif
#ifdef NS_IDOMNSHTMLSELECTELEMENT_IID
NP_DEF_ID(kDOMNSHTMLSelectElementIID, NS_IDOMNSHTMLSELECTELEMENT_IID);
#endif
#ifdef NS_IDOMNSHTMLTEXTAREAELEMENT_IID
NP_DEF_ID(kDOMNSHTMLTextAreaElementIID, NS_IDOMNSHTMLTEXTAREAELEMENT_IID);
#endif
#ifdef NS_IDOMNSLOCATION_IID
NP_DEF_ID(kDOMNSLocationIID, NS_IDOMNSLOCATION_IID);
#endif
#ifdef NS_IDOMNSRANGE_IID
NP_DEF_ID(kDOMNSRangeIID, NS_IDOMNSRANGE_IID);
#endif
#ifdef NS_IDOMNSUIEVENT_IID
NP_DEF_ID(kDOMNSUIEventIID, NS_IDOMNSUIEVENT_IID);
#endif
#ifdef NS_IDOMNSXBLFORMCONTROL_IID
NP_DEF_ID(kDOMNSXBLFormControlIID, NS_IDOMNSXBLFORMCONTROL_IID);
#endif
#ifdef NS_IDOMPARSER_IID
NP_DEF_ID(kDOMParserIID, NS_IDOMPARSER_IID);
#endif
#ifdef NS_IDOMPKCS11_IID
NP_DEF_ID(kDOMPkcs11IID, NS_IDOMPKCS11_IID);
#endif
#ifdef NS_IDOMPLUGIN_IID
NP_DEF_ID(kDOMPluginIID, NS_IDOMPLUGIN_IID);
#endif
#ifdef NS_IDOMPLUGINARRAY_IID
NP_DEF_ID(kDOMPluginArrayIID, NS_IDOMPLUGINARRAY_IID);
#endif
#ifdef NS_IDOMPROCESSINGINSTRUCTION_IID
NP_DEF_ID(kDOMProcessingInstructionIID, NS_IDOMPROCESSINGINSTRUCTION_IID);
#endif
#ifdef NS_IDOMRANGE_IID
NP_DEF_ID(kDOMRangeIID, NS_IDOMRANGE_IID);
#endif
#ifdef NS_IDOMRANGEEXCEPTION_IID
NP_DEF_ID(kDOMRangeExceptionIID, NS_IDOMRANGEEXCEPTION_IID);
#endif
#ifdef NS_IDOMRECT_IID
NP_DEF_ID(kDOMRectIID, NS_IDOMRECT_IID);
#endif
#ifdef NS_IDOMRGBCOLOR_IID
NP_DEF_ID(kDOMRGBColorIID, NS_IDOMRGBCOLOR_IID);
#endif
#ifdef NS_IDOMSCREEN_IID
NP_DEF_ID(kDOMScreenIID, NS_IDOMSCREEN_IID);
#endif
#ifdef NS_IDOMSERIALIZER_IID
NP_DEF_ID(kDOMSerializerIID, NS_IDOMSERIALIZER_IID);
#endif
#ifdef NS_IDOMSTYLESHEET_IID
NP_DEF_ID(kDOMStyleSheetIID, NS_IDOMSTYLESHEET_IID);
#endif
#ifdef NS_IDOMSTYLESHEETLIST_IID
NP_DEF_ID(kDOMStyleSheetListIID, NS_IDOMSTYLESHEETLIST_IID);
#endif
#ifdef NS_IDOMTEXT_IID
NP_DEF_ID(kDOMTextIID, NS_IDOMTEXT_IID);
#endif
#ifdef NS_IDOMTREEWALKER_IID
NP_DEF_ID(kDOMTreeWalkerIID, NS_IDOMTREEWALKER_IID);
#endif
#ifdef NS_IDOMUIEVENT_IID
NP_DEF_ID(kDOMUIEventIID, NS_IDOMUIEVENT_IID);
#endif
#ifdef NS_IDOMVIEWCSS_IID
NP_DEF_ID(kDOMViewCSSIID, NS_IDOMVIEWCSS_IID);
#endif
#ifdef NS_IDOMWINDOW_IID
NP_DEF_ID(kDOMWindowIID, NS_IDOMWINDOW_IID);
#endif
#ifdef NS_IDOMWINDOWCOLLECTION_IID
NP_DEF_ID(kDOMWindowCollectionIID, NS_IDOMWINDOWCOLLECTION_IID);
#endif
#ifdef NS_IDOMWINDOWINTERNAL_IID
NP_DEF_ID(kDOMWindowInternalIID, NS_IDOMWINDOWINTERNAL_IID);
#endif
#ifdef NS_IDOMXMLDOCUMENT_IID
NP_DEF_ID(kDOMXMLDocumentIID, NS_IDOMXMLDOCUMENT_IID);
#endif
#ifdef NS_IDOMXPATHEVALUATOR_IID
NP_DEF_ID(kDOMXPathEvaluatorIID, NS_IDOMXPATHEVALUATOR_IID);
#endif
#ifdef NS_IDOMXPATHEXCEPTION_IID
NP_DEF_ID(kDOMXPathExceptionIID, NS_IDOMXPATHEXCEPTION_IID);
#endif
#ifdef NS_IDOMXPATHEXPRESSION_IID
NP_DEF_ID(kDOMXPathExpressionIID, NS_IDOMXPATHEXPRESSION_IID);
#endif
#ifdef NS_IDOMXPATHNAMESPACE_IID
NP_DEF_ID(kDOMXPathNamespaceIID, NS_IDOMXPATHNAMESPACE_IID);
#endif
#ifdef NS_IDOMXPATHNSRESOLVER_IID
NP_DEF_ID(kDOMXPathNSResolverIID, NS_IDOMXPATHNSRESOLVER_IID);
#endif
#ifdef NS_IDOMXPATHRESULT_IID
NP_DEF_ID(kDOMXPathResultIID, NS_IDOMXPATHRESULT_IID);
#endif
#ifdef NS_IDOMXULBUTTONELEMENT_IID
NP_DEF_ID(kDOMXULButtonElementIID, NS_IDOMXULBUTTONELEMENT_IID);
#endif
#ifdef NS_IDOMXULCHECKBOXELEMENT_IID
NP_DEF_ID(kDOMXULCheckboxElementIID, NS_IDOMXULCHECKBOXELEMENT_IID);
#endif
#ifdef NS_IDOMXULCOMMANDDISPATCHER_IID
NP_DEF_ID(kDOMXULCommandDispatcherIID, NS_IDOMXULCOMMANDDISPATCHER_IID);
#endif
#ifdef NS_IDOMXULCONTROLELEMENT_IID
NP_DEF_ID(kDOMXULControlElementIID, NS_IDOMXULCONTROLELEMENT_IID);
#endif
#ifdef NS_IDOMXULDESCRIPTIONELEMENT_IID
NP_DEF_ID(kDOMXULDescriptionElementIID, NS_IDOMXULDESCRIPTIONELEMENT_IID);
#endif
#ifdef NS_IDOMXULDOCUMENT_IID
NP_DEF_ID(kDOMXULDocumentIID, NS_IDOMXULDOCUMENT_IID);
#endif
#ifdef NS_IDOMXULELEMENT_IID
NP_DEF_ID(kDOMXULElementIID, NS_IDOMXULELEMENT_IID);
#endif
#ifdef NS_IDOMXULIMAGEELEMENT_IID
NP_DEF_ID(kDOMXULImageElementIID, NS_IDOMXULIMAGEELEMENT_IID);
#endif
#ifdef NS_IDOMXULLABELEDCONTROLEL_IID
NP_DEF_ID(kDOMXULLabeledControlElIID, NS_IDOMXULLABELEDCONTROLEL_IID);
#endif
#ifdef NS_IDOMXULLABELELEMENT_IID
NP_DEF_ID(kDOMXULLabelElementIID, NS_IDOMXULLABELELEMENT_IID);
#endif
#ifdef NS_IDOMXULMENULISTELEMENT_IID
NP_DEF_ID(kDOMXULMenuListElementIID, NS_IDOMXULMENULISTELEMENT_IID);
#endif
#ifdef NS_IDOMXULMULTSELECTCNTRLEL_IID
NP_DEF_ID(kDOMXULMultSelectCntrlElIID, NS_IDOMXULMULTSELECTCNTRLEL_IID);
#endif
#ifdef NS_IDOMXULPOPUPELEMENT_IID
NP_DEF_ID(kDOMXULPopupElementIID, NS_IDOMXULPOPUPELEMENT_IID);
#endif
#ifdef NS_IDOMXULSELECTCNTRLEL_IID
NP_DEF_ID(kDOMXULSelectCntrlElIID, NS_IDOMXULSELECTCNTRLEL_IID);
#endif
#ifdef NS_IDOMXULSELECTCNTRLITEMEL_IID
NP_DEF_ID(kDOMXULSelectCntrlItemElIID, NS_IDOMXULSELECTCNTRLITEMEL_IID);
#endif
#ifdef NS_IDOWNLOAD_IID
NP_DEF_ID(kDownloadIID, NS_IDOWNLOAD_IID);
#endif
#ifdef NS_IDOWNLOADER_IID
NP_DEF_ID(kDownloaderIID, NS_IDOWNLOADER_IID);
#endif
#ifdef NS_IDOWNLOADMANAGER_IID
NP_DEF_ID(kDownloadManagerIID, NS_IDOWNLOADMANAGER_IID);
#endif
#ifdef NS_IDOWNLOADPROGRESSLISTENER_IID
NP_DEF_ID(kDownloadProgressListenerIID, NS_IDOWNLOADPROGRESSLISTENER_IID);
#endif
#ifdef NS_IDRAGDROPHANDLER_IID
NP_DEF_ID(kDragDropHandlerIID, NS_IDRAGDROPHANDLER_IID);
#endif
#ifdef NS_IDRAGDROPOVERRIDE_IID
NP_DEF_ID(kDragDropOverrideIID, NS_IDRAGDROPOVERRIDE_IID);
#endif
#ifdef NS_IDRAGSERVICE_IID
NP_DEF_ID(kDragServiceIID, NS_IDRAGSERVICE_IID);
#endif
#ifdef NS_IDRAGSESSION_IID
NP_DEF_ID(kDragSessionIID, NS_IDRAGSESSION_IID);
#endif
#ifdef NS_IDRAGTRACKER_IID
NP_DEF_ID(kDragTrackerIID, NS_IDRAGTRACKER_IID);
#endif
#ifdef NS_IEDITACTIONLISTENER_IID
NP_DEF_ID(kEditActionListenerIID, NS_IEDITACTIONLISTENER_IID);
#endif
#ifdef NS_IEDITINGSESSION_IID
NP_DEF_ID(kEditingSessionIID, NS_IEDITINGSESSION_IID);
#endif
#ifdef NS_IEDITOR_IID
NP_DEF_ID(kEditorIID, NS_IEDITOR_IID);
#endif
#ifdef NS_IEDITORBOXOBJECT_IID
NP_DEF_ID(kEditorBoxObjectIID, NS_IEDITORBOXOBJECT_IID);
#endif
#ifdef NS_IEDITORDOCSHELL_IID
NP_DEF_ID(kEditorDocShellIID, NS_IEDITORDOCSHELL_IID);
#endif
#ifdef NS_IEDITORIMESUPPORT_IID
NP_DEF_ID(kEditorIMESupportIID, NS_IEDITORIMESUPPORT_IID);
#endif
#ifdef NS_IEDITORLOGGING_IID
NP_DEF_ID(kEditorLoggingIID, NS_IEDITORLOGGING_IID);
#endif
#ifdef NS_IEDITORMAILSUPPORT_IID
NP_DEF_ID(kEditorMailSupportIID, NS_IEDITORMAILSUPPORT_IID);
#endif
#ifdef NS_IEDITOROBSERVER_IID
NP_DEF_ID(kEditorObserverIID, NS_IEDITOROBSERVER_IID);
#endif
#ifdef NS_IEDITORSPELLCHECK_IID
NP_DEF_ID(kEditorSpellCheckIID, NS_IEDITORSPELLCHECK_IID);
#endif
#ifdef NS_IEDITORSTYLESHEETS_IID
NP_DEF_ID(kEditorStyleSheetsIID, NS_IEDITORSTYLESHEETS_IID);
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW_IID
NP_DEF_ID(kEmbeddingSiteWindowIID, NS_IEMBEDDINGSITEWINDOW_IID);
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW2_IID
NP_DEF_ID(kEmbeddingSiteWindow2IID, NS_IEMBEDDINGSITEWINDOW2_IID);
#endif
#ifdef NS_IENCODEDCHANNEL_IID
NP_DEF_ID(kEncodedChannelIID, NS_IENCODEDCHANNEL_IID);
#endif
#ifdef NS_IENCRYPTEDSMIMEURISSRVC_IID
NP_DEF_ID(kEncryptedSMIMEURIsSrvcIID, NS_IENCRYPTEDSMIMEURISSRVC_IID);
#endif
#ifdef NS_IENTITYCONVERTER_IID
NP_DEF_ID(kEntityConverterIID, NS_IENTITYCONVERTER_IID);
#endif
#ifdef NS_IENTROPYCOLLECTOR_IID
NP_DEF_ID(kEntropyCollectorIID, NS_IENTROPYCOLLECTOR_IID);
#endif
#ifdef NS_IENUMERATOR_IID
NP_DEF_ID(kEnumeratorIID, NS_IENUMERATOR_IID);
#endif
#ifdef NS_IERRORSERVICE_IID
NP_DEF_ID(kErrorServiceIID, NS_IERRORSERVICE_IID);
#endif
#ifdef NS_IEVALUATESTRINGPROXY_IID
NP_DEF_ID(kEvaluateStringProxyIID, NS_IEVALUATESTRINGPROXY_IID);
#endif
#ifdef NS_IEVENTHANDLER_IID
NP_DEF_ID(kEventHandlerIID, NS_IEVENTHANDLER_IID);
#endif
#ifdef NS_IEVENTQUEUE_IID
NP_DEF_ID(kEventQueueIID, NS_IEVENTQUEUE_IID);
#endif
#ifdef NS_IEVENTQUEUESERVICE_IID
NP_DEF_ID(kEventQueueServiceIID, NS_IEVENTQUEUESERVICE_IID);
#endif
#ifdef NS_IEXCEPTION_IID
NP_DEF_ID(kExceptionIID, NS_IEXCEPTION_IID);
#endif
#ifdef NS_IEXCEPTIONSERVICE_IID
NP_DEF_ID(kExceptionServiceIID, NS_IEXCEPTIONSERVICE_IID);
#endif
#ifdef NS_IEXPATSINK_IID
NP_DEF_ID(kExpatSinkIID, NS_IEXPATSINK_IID);
#endif
#ifdef NS_IEXTERNALHELPERAPPSERVICE_IID
NP_DEF_ID(kExternalHelperAppServiceIID, NS_IEXTERNALHELPERAPPSERVICE_IID);
#endif
#ifdef NS_IEXTERNALPROTOCOLHANDLER_IID
NP_DEF_ID(kExternalProtocolHandlerIID, NS_IEXTERNALPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IEXTERNALPROTOCOLSERVICE_IID
NP_DEF_ID(kExternalProtocolServiceIID, NS_IEXTERNALPROTOCOLSERVICE_IID);
#endif
#ifdef NS_IFACTORY_IID
NP_DEF_ID(kFactoryIID, NS_IFACTORY_IID);
#endif
#ifdef NS_IFASTLOADFILECONTROL_IID
NP_DEF_ID(kFastLoadFileControlIID, NS_IFASTLOADFILECONTROL_IID);
#endif
#ifdef NS_IFASTLOADSERVICE_IID
NP_DEF_ID(kFastLoadServiceIID, NS_IFASTLOADSERVICE_IID);
#endif
#ifdef NS_IFILE_IID
NP_DEF_ID(kFileIID, NS_IFILE_IID);
#endif
#ifdef NS_IFILECHANNEL_IID
NP_DEF_ID(kFileChannelIID, NS_IFILECHANNEL_IID);
#endif
#ifdef NS_IFILEPICKER_IID
NP_DEF_ID(kFilePickerIID, NS_IFILEPICKER_IID);
#endif
#ifdef NS_IFILEPROTOCOLHANDLER_IID
NP_DEF_ID(kFileProtocolHandlerIID, NS_IFILEPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IFILESPEC_IID
NP_DEF_ID(kFileSpecIID, NS_IFILESPEC_IID);
#endif
#ifdef NS_IFILESTREAMS_IID
NP_DEF_ID(kFileStreamsIID, NS_IFILESTREAMS_IID);
#endif
#ifdef NS_IFILEURL_IID
NP_DEF_ID(kFileURLIID, NS_IFILEURL_IID);
#endif
#ifdef NS_IFILEUTILITIES_IID
NP_DEF_ID(kFileUtilitiesIID, NS_IFILEUTILITIES_IID);
#endif
#ifdef NS_IFIND_IID
NP_DEF_ID(kFindIID, NS_IFIND_IID);
#endif
#ifdef NS_IFINDSERVICE_IID
NP_DEF_ID(kFindServiceIID, NS_IFINDSERVICE_IID);
#endif
#ifdef NS_IFOLDER_IID
NP_DEF_ID(kFolderIID, NS_IFOLDER_IID);
#endif
#ifdef NS_IFOLDERLISTENER_IID
NP_DEF_ID(kFolderListenerIID, NS_IFOLDERLISTENER_IID);
#endif
#ifdef NS_IFONTCATALOGSERVICE_IID
NP_DEF_ID(kFontCatalogServiceIID, NS_IFONTCATALOGSERVICE_IID);
#endif
#ifdef NS_IFONTENUMERATOR_IID
NP_DEF_ID(kFontEnumeratorIID, NS_IFONTENUMERATOR_IID);
#endif
#ifdef NS_IFONTLIST_IID
NP_DEF_ID(kFontListIID, NS_IFONTLIST_IID);
#endif
#ifdef NS_IFONTPACKAGEHANDLER_IID
NP_DEF_ID(kFontPackageHandlerIID, NS_IFONTPACKAGEHANDLER_IID);
#endif
#ifdef NS_IFONTPACKAGEPROXY_IID
NP_DEF_ID(kFontPackageProxyIID, NS_IFONTPACKAGEPROXY_IID);
#endif
#ifdef NS_IFONTPACKAGESERVICE_IID
NP_DEF_ID(kFontPackageServiceIID, NS_IFONTPACKAGESERVICE_IID);
#endif
#ifdef NS_IFORMATCONVERTER_IID
NP_DEF_ID(kFormatConverterIID, NS_IFORMATCONVERTER_IID);
#endif
#ifdef NS_IFREETYPE2_IID
NP_DEF_ID(kFreeType2IID, NS_IFREETYPE2_IID);
#endif
#ifdef NS_IFTPCHANNEL_IID
NP_DEF_ID(kFTPChannelIID, NS_IFTPCHANNEL_IID);
#endif
#ifdef NS_IFULLSCREEN_IID
NP_DEF_ID(kFullScreenIID, NS_IFULLSCREEN_IID);
#endif
#ifdef NS_IGENKEYPAIRINFODLG_IID
NP_DEF_ID(kGenKeypairInfoDlgIID, NS_IGENKEYPAIRINFODLG_IID);
#endif
#ifdef NS_IGLOBALHISTORY_IID
NP_DEF_ID(kGlobalHistoryIID, NS_IGLOBALHISTORY_IID);
#endif
#ifdef NS_IGRAPHICS_IID
NP_DEF_ID(kGraphicsIID, NS_IGRAPHICS_IID);
#endif
#ifdef NS_IHASH_IID
NP_DEF_ID(kHashIID, NS_IHASH_IID);
#endif
#ifdef NS_IHELPERAPPLAUNCHERDIALOG_IID
NP_DEF_ID(kHelperAppLauncherDialogIID, NS_IHELPERAPPLAUNCHERDIALOG_IID);
#endif
#ifdef NS_IHISTORYENTRY_IID
NP_DEF_ID(kHistoryEntryIID, NS_IHISTORYENTRY_IID);
#endif
#ifdef NS_IHTMLEDITOR_IID
NP_DEF_ID(kHTMLEditorIID, NS_IHTMLEDITOR_IID);
#endif
#ifdef NS_IHTMLOBJECTRESIZER_IID
NP_DEF_ID(kHTMLObjectResizerIID, NS_IHTMLOBJECTRESIZER_IID);
#endif
#ifdef NS_IHTTPAUTHENTICATOR_IID
NP_DEF_ID(kHttpAuthenticatorIID, NS_IHTTPAUTHENTICATOR_IID);
#endif
#ifdef NS_IHTTPCHANNEL_IID
NP_DEF_ID(kHttpChannelIID, NS_IHTTPCHANNEL_IID);
#endif
#ifdef NS_IHTTPCHANNELINTERNAL_IID
NP_DEF_ID(kHttpChannelInternalIID, NS_IHTTPCHANNELINTERNAL_IID);
#endif
#ifdef NS_IHTTPEVENTSINK_IID
NP_DEF_ID(kHttpEventSinkIID, NS_IHTTPEVENTSINK_IID);
#endif
#ifdef NS_IHTTPHEADERLISTENER_IID
NP_DEF_ID(kHTTPHeaderListenerIID, NS_IHTTPHEADERLISTENER_IID);
#endif
#ifdef NS_IHTTPHEADERVISITOR_IID
NP_DEF_ID(kHttpHeaderVisitorIID, NS_IHTTPHEADERVISITOR_IID);
#endif
#ifdef NS_IHTTPINDEX_IID
NP_DEF_ID(kHTTPIndexIID, NS_IHTTPINDEX_IID);
#endif
#ifdef NS_IHTTPNOTIFY_IID
NP_DEF_ID(kHttpNotifyIID, NS_IHTTPNOTIFY_IID);
#endif
#ifdef NS_IHTTPPROTOCOLHANDLER_IID
NP_DEF_ID(kHttpProtocolHandlerIID, NS_IHTTPPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IICONURI_IID
NP_DEF_ID(kIconURIIID, NS_IICONURI_IID);
#endif
#ifdef NS_IIDNSERVICE_IID
NP_DEF_ID(kIDNServiceIID, NS_IIDNSERVICE_IID);
#endif
#ifdef NS_IIFRAMEBOXOBJECT_IID
NP_DEF_ID(kIFrameBoxObjectIID, NS_IIFRAMEBOXOBJECT_IID);
#endif
#ifdef NS_IIMAGEDOCUMENT_IID
NP_DEF_ID(kImageDocumentIID, NS_IIMAGEDOCUMENT_IID);
#endif
#ifdef NS_IIMAPFLAGANDUIDSTATE_IID
NP_DEF_ID(kImapFlagAndUidStateIID, NS_IIMAPFLAGANDUIDSTATE_IID);
#endif
#ifdef NS_IIMAPHEADERXFERINFO_IID
NP_DEF_ID(kImapHeaderXferInfoIID, NS_IIMAPHEADERXFERINFO_IID);
#endif
#ifdef NS_IIMAPINCOMINGSERVER_IID
NP_DEF_ID(kImapIncomingServerIID, NS_IIMAPINCOMINGSERVER_IID);
#endif
#ifdef NS_IIMAPMAILFOLDERSINK_IID
NP_DEF_ID(kImapMailFolderSinkIID, NS_IIMAPMAILFOLDERSINK_IID);
#endif
#ifdef NS_IIMAPMESSAGESINK_IID
NP_DEF_ID(kImapMessageSinkIID, NS_IIMAPMESSAGESINK_IID);
#endif
#ifdef NS_IIMAPMOCKCHANNEL_IID
NP_DEF_ID(kImapMockChannelIID, NS_IIMAPMOCKCHANNEL_IID);
#endif
#ifdef NS_IIMAPPROTOCOL_IID
NP_DEF_ID(kImapProtocolIID, NS_IIMAPPROTOCOL_IID);
#endif
#ifdef NS_IIMAPSERVERSINK_IID
NP_DEF_ID(kImapServerSinkIID, NS_IIMAPSERVERSINK_IID);
#endif
#ifdef NS_IIMAPSERVICE_IID
NP_DEF_ID(kImapServiceIID, NS_IIMAPSERVICE_IID);
#endif
#ifdef NS_IIMAPURL_IID
NP_DEF_ID(kImapUrlIID, NS_IIMAPURL_IID);
#endif
#ifdef NS_IIMGMANAGER_IID
NP_DEF_ID(kImgManagerIID, NS_IIMGMANAGER_IID);
#endif
#ifdef NS_IIMPORTABDESCRIPTOR_IID
NP_DEF_ID(kImportABDescriptorIID, NS_IIMPORTABDESCRIPTOR_IID);
#endif
#ifdef NS_IIMPORTADDRESSBOOKS_IID
NP_DEF_ID(kImportAddressBooksIID, NS_IIMPORTADDRESSBOOKS_IID);
#endif
#ifdef NS_IIMPORTFIELDMAP_IID
NP_DEF_ID(kImportFieldMapIID, NS_IIMPORTFIELDMAP_IID);
#endif
#ifdef NS_IIMPORTGENERIC_IID
NP_DEF_ID(kImportGenericIID, NS_IIMPORTGENERIC_IID);
#endif
#ifdef NS_IIMPORTMAIL_IID
NP_DEF_ID(kImportMailIID, NS_IIMPORTMAIL_IID);
#endif
#ifdef NS_IIMPORTMAILBOXDESCRIPTOR_IID
NP_DEF_ID(kImportMailboxDescriptorIID, NS_IIMPORTMAILBOXDESCRIPTOR_IID);
#endif
#ifdef NS_IIMPORTMIMEENCODE_IID
NP_DEF_ID(kImportMimeEncodeIID, NS_IIMPORTMIMEENCODE_IID);
#endif
#ifdef NS_IIMPORTMODULE_IID
NP_DEF_ID(kImportModuleIID, NS_IIMPORTMODULE_IID);
#endif
#ifdef NS_IIMPORTSERVICE_IID
NP_DEF_ID(kImportServiceIID, NS_IIMPORTSERVICE_IID);
#endif
#ifdef NS_IIMPORTSETTINGS_IID
NP_DEF_ID(kImportSettingsIID, NS_IIMPORTSETTINGS_IID);
#endif
#ifdef NS_IINCOMINGSERVERLISTENER_IID
NP_DEF_ID(kIncomingServerListenerIID, NS_IINCOMINGSERVERLISTENER_IID);
#endif
#ifdef NS_IINPUTSTREAM_IID
NP_DEF_ID(kInputStreamIID, NS_IINPUTSTREAM_IID);
#endif
#ifdef NS_IINPUTSTREAMCHANNEL_IID
NP_DEF_ID(kInputStreamChannelIID, NS_IINPUTSTREAMCHANNEL_IID);
#endif
#ifdef NS_IINPUTSTREAMPUMP_IID
NP_DEF_ID(kInputStreamPumpIID, NS_IINPUTSTREAMPUMP_IID);
#endif
#ifdef NS_IINPUTSTREAMTEE_IID
NP_DEF_ID(kInputStreamTeeIID, NS_IINPUTSTREAMTEE_IID);
#endif
#ifdef NS_IINTERFACEINFO_IID
NP_DEF_ID(kInterfaceInfoIID, NS_IINTERFACEINFO_IID);
#endif
#ifdef NS_IINTERFACEINFOMANAGER_IID
NP_DEF_ID(kInterfaceInfoManagerIID, NS_IINTERFACEINFOMANAGER_IID);
#endif
#ifdef NS_IINTERFACEREQUESTOR_IID
NP_DEF_ID(kInterfaceRequestorIID, NS_IINTERFACEREQUESTOR_IID);
#endif
#ifdef NS_IIOSERVICE_IID
NP_DEF_ID(kIOServiceIID, NS_IIOSERVICE_IID);
#endif
#ifdef NS_IJAR_IID
NP_DEF_ID(kJARIID, NS_IJAR_IID);
#endif
#ifdef NS_IJARCHANNEL_IID
NP_DEF_ID(kJARChannelIID, NS_IJARCHANNEL_IID);
#endif
#ifdef NS_IJARPROTOCOLHANDLER_IID
NP_DEF_ID(kJARProtocolHandlerIID, NS_IJARPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IJARURI_IID
NP_DEF_ID(kJARURIIID, NS_IJARURI_IID);
#endif
#ifdef NS_IJRILIVECONNECTPIPEER_IID
NP_DEF_ID(kJRILiveConnectPIPeerIID, NS_IJRILIVECONNECTPIPEER_IID);
#endif
#ifdef NS_IJRILIVECONNECTPLUGIN_IID
NP_DEF_ID(kJRILiveConnectPluginIID, NS_IJRILIVECONNECTPLUGIN_IID);
#endif
#ifdef NS_IJSCONSOLESERVICE_IID
NP_DEF_ID(kJSConsoleServiceIID, NS_IJSCONSOLESERVICE_IID);
#endif
#ifdef NS_IJSCONTEXTSTACK_IID
NP_DEF_ID(kJSContextStackIID, NS_IJSCONTEXTSTACK_IID);
#endif
#ifdef NS_IJSRUNTIMESERVICE_IID
NP_DEF_ID(kJSRuntimeServiceIID, NS_IJSRUNTIMESERVICE_IID);
#endif
#ifdef NS_IKEYEDSTREAMGENERATOR_IID
NP_DEF_ID(kKeyedStreamGeneratorIID, NS_IKEYEDSTREAMGENERATOR_IID);
#endif
#ifdef NS_IKEYGENTHREAD_IID
NP_DEF_ID(kKeygenThreadIID, NS_IKEYGENTHREAD_IID);
#endif
#ifdef NS_ILANGUAGEATOM_IID
NP_DEF_ID(kLanguageAtomIID, NS_ILANGUAGEATOM_IID);
#endif
#ifdef NS_ILANGUAGEATOMSERVICE_IID
NP_DEF_ID(kLanguageAtomServiceIID, NS_ILANGUAGEATOMSERVICE_IID);
#endif
#ifdef NS_ILDAPAUTOCOMPFORMATTER_IID
NP_DEF_ID(kLDAPAutoCompFormatterIID, NS_ILDAPAUTOCOMPFORMATTER_IID);
#endif
#ifdef NS_ILDAPAUTOCOMPLETESESSION_IID
NP_DEF_ID(kLDAPAutoCompleteSessionIID, NS_ILDAPAUTOCOMPLETESESSION_IID);
#endif
#ifdef NS_ILDAPBERVALUE_IID
NP_DEF_ID(kLDAPBERValueIID, NS_ILDAPBERVALUE_IID);
#endif
#ifdef NS_ILDAPCONNECTION_IID
NP_DEF_ID(kLDAPConnectionIID, NS_ILDAPCONNECTION_IID);
#endif
#ifdef NS_ILDAPERRORS_IID
NP_DEF_ID(kLDAPErrorsIID, NS_ILDAPERRORS_IID);
#endif
#ifdef NS_ILDAPMESSAGE_IID
NP_DEF_ID(kLDAPMessageIID, NS_ILDAPMESSAGE_IID);
#endif
#ifdef NS_ILDAPMESSAGELISTENER_IID
NP_DEF_ID(kLDAPMessageListenerIID, NS_ILDAPMESSAGELISTENER_IID);
#endif
#ifdef NS_ILDAPOPERATION_IID
NP_DEF_ID(kLDAPOperationIID, NS_ILDAPOPERATION_IID);
#endif
#ifdef NS_ILDAPPREFSSERVICE_IID
NP_DEF_ID(kLDAPPrefsServiceIID, NS_ILDAPPREFSSERVICE_IID);
#endif
#ifdef NS_ILDAPSERVER_IID
NP_DEF_ID(kLDAPServerIID, NS_ILDAPSERVER_IID);
#endif
#ifdef NS_ILDAPSERVICE_IID
NP_DEF_ID(kLDAPServiceIID, NS_ILDAPSERVICE_IID);
#endif
#ifdef NS_ILDAPSYNCQUERY_IID
NP_DEF_ID(kLDAPSyncQueryIID, NS_ILDAPSYNCQUERY_IID);
#endif
#ifdef NS_ILDAPURL_IID
NP_DEF_ID(kLDAPURLIID, NS_ILDAPURL_IID);
#endif
#ifdef NS_ILINEINPUTSTREAM_IID
NP_DEF_ID(kLineInputStreamIID, NS_ILINEINPUTSTREAM_IID);
#endif
#ifdef NS_ILISTBOXOBJECT_IID
NP_DEF_ID(kListBoxObjectIID, NS_ILISTBOXOBJECT_IID);
#endif
#ifdef NS_ILOADGROUP_IID
NP_DEF_ID(kLoadGroupIID, NS_ILOADGROUP_IID);
#endif
#ifdef NS_ILOCALE_IID
NP_DEF_ID(kLocaleIID, NS_ILOCALE_IID);
#endif
#ifdef NS_ILOCALESERVICE_IID
NP_DEF_ID(kLocaleServiceIID, NS_ILOCALESERVICE_IID);
#endif
#ifdef NS_ILOCALFILE_IID
NP_DEF_ID(kLocalFileIID, NS_ILOCALFILE_IID);
#endif
#ifdef NS_ILOCALMAILINCOMINGSERVER_IID
NP_DEF_ID(kLocalMailIncomingServerIID, NS_ILOCALMAILINCOMINGSERVER_IID);
#endif
#ifdef NS_IMAILBOXSERVICE_IID
NP_DEF_ID(kMailboxServiceIID, NS_IMAILBOXSERVICE_IID);
#endif
#ifdef NS_IMAILBOXSPEC_IID
NP_DEF_ID(kMailboxSpecIID, NS_IMAILBOXSPEC_IID);
#endif
#ifdef NS_IMAILBOXURL_IID
NP_DEF_ID(kMailboxUrlIID, NS_IMAILBOXURL_IID);
#endif
#ifdef NS_IMARKUPDOCUMENTVIEWER_IID
NP_DEF_ID(kMarkupDocumentViewerIID, NS_IMARKUPDOCUMENTVIEWER_IID);
#endif
#ifdef NS_IMEMORY_IID
NP_DEF_ID(kMemoryIID, NS_IMEMORY_IID);
#endif
#ifdef NS_IMENUBOXOBJECT_IID
NP_DEF_ID(kMenuBoxObjectIID, NS_IMENUBOXOBJECT_IID);
#endif
#ifdef NS_IMENUROLLUP_IID
NP_DEF_ID(kMenuRollupIID, NS_IMENUROLLUP_IID);
#endif
#ifdef NS_IMESSENGER_IID
NP_DEF_ID(kMessengerIID, NS_IMESSENGER_IID);
#endif
#ifdef NS_IMESSENGERMIGRATOR_IID
NP_DEF_ID(kMessengerMigratorIID, NS_IMESSENGERMIGRATOR_IID);
#endif
#ifdef NS_IMESSENGEROSINTEGRATION_IID
NP_DEF_ID(kMessengerOSIntegrationIID, NS_IMESSENGEROSINTEGRATION_IID);
#endif
#ifdef NS_IMESSENGERWINDOWSERVICE_IID
NP_DEF_ID(kMessengerWindowServiceIID, NS_IMESSENGERWINDOWSERVICE_IID);
#endif
#ifdef NS_IMIMEEMITTER_IID
NP_DEF_ID(kMimeEmitterIID, NS_IMIMEEMITTER_IID);
#endif
#ifdef NS_IMIMEHEADERS_IID
NP_DEF_ID(kMimeHeadersIID, NS_IMIMEHEADERS_IID);
#endif
#ifdef NS_IMIMEINFO_IID
NP_DEF_ID(kMIMEInfoIID, NS_IMIMEINFO_IID);
#endif
#ifdef NS_IMIMEINPUTSTREAM_IID
NP_DEF_ID(kMIMEInputStreamIID, NS_IMIMEINPUTSTREAM_IID);
#endif
#ifdef NS_IMIMEMISCSTATUS_IID
NP_DEF_ID(kMimeMiscStatusIID, NS_IMIMEMISCSTATUS_IID);
#endif
#ifdef NS_IMIMESERVICE_IID
NP_DEF_ID(kMIMEServiceIID, NS_IMIMESERVICE_IID);
#endif
#ifdef NS_IMIMESTREAMCONVERTER_IID
NP_DEF_ID(kMimeStreamConverterIID, NS_IMIMESTREAMCONVERTER_IID);
#endif
#ifdef NS_IMODULE_IID
NP_DEF_ID(kModuleIID, NS_IMODULE_IID);
#endif
#ifdef NS_IMSGACCOUNT_IID
NP_DEF_ID(kMsgAccountIID, NS_IMSGACCOUNT_IID);
#endif
#ifdef NS_IMSGACCOUNTMANAGER_IID
NP_DEF_ID(kMsgAccountManagerIID, NS_IMSGACCOUNTMANAGER_IID);
#endif
#ifdef NS_IMSGATTACHMENT_IID
NP_DEF_ID(kMsgAttachmentIID, NS_IMSGATTACHMENT_IID);
#endif
#ifdef NS_IMSGBIFFMANAGER_IID
NP_DEF_ID(kMsgBiffManagerIID, NS_IMSGBIFFMANAGER_IID);
#endif
#ifdef NS_IMSGCOMPFIELDS_IID
NP_DEF_ID(kMsgCompFieldsIID, NS_IMSGCOMPFIELDS_IID);
#endif
#ifdef NS_IMSGCOMPOSE_IID
NP_DEF_ID(kMsgComposeIID, NS_IMSGCOMPOSE_IID);
#endif
#ifdef NS_IMSGCOMPOSEPARAMS_IID
NP_DEF_ID(kMsgComposeParamsIID, NS_IMSGCOMPOSEPARAMS_IID);
#endif
#ifdef NS_IMSGCOMPOSEPROGRESSPARAMS_IID
NP_DEF_ID(kMsgComposeProgressParamsIID, NS_IMSGCOMPOSEPROGRESSPARAMS_IID);
#endif
#ifdef NS_IMSGCOMPOSESECURE_IID
NP_DEF_ID(kMsgComposeSecureIID, NS_IMSGCOMPOSESECURE_IID);
#endif
#ifdef NS_IMSGCOMPOSESERVICE_IID
NP_DEF_ID(kMsgComposeServiceIID, NS_IMSGCOMPOSESERVICE_IID);
#endif
#ifdef NS_IMSGCOMPUTILS_IID
NP_DEF_ID(kMsgCompUtilsIID, NS_IMSGCOMPUTILS_IID);
#endif
#ifdef NS_IMSGCOPYSERVICE_IID
NP_DEF_ID(kMsgCopyServiceIID, NS_IMSGCOPYSERVICE_IID);
#endif
#ifdef NS_IMSGCOPYSERVICELISTENER_IID
NP_DEF_ID(kMsgCopyServiceListenerIID, NS_IMSGCOPYSERVICELISTENER_IID);
#endif
#ifdef NS_IMSGDATABASE_IID
NP_DEF_ID(kMsgDatabaseIID, NS_IMSGDATABASE_IID);
#endif
#ifdef NS_IMSGDBVIEW_IID
NP_DEF_ID(kMsgDBViewIID, NS_IMSGDBVIEW_IID);
#endif
#ifdef NS_IMSGDRAFT_IID
NP_DEF_ID(kMsgDraftIID, NS_IMSGDRAFT_IID);
#endif
#ifdef NS_IMSGFILTER_IID
NP_DEF_ID(kMsgFilterIID, NS_IMSGFILTER_IID);
#endif
#ifdef NS_IMSGFILTERHITNOTIFY_IID
NP_DEF_ID(kMsgFilterHitNotifyIID, NS_IMSGFILTERHITNOTIFY_IID);
#endif
#ifdef NS_IMSGFILTERLIST_IID
NP_DEF_ID(kMsgFilterListIID, NS_IMSGFILTERLIST_IID);
#endif
#ifdef NS_IMSGFILTERPLUGIN_IID
NP_DEF_ID(kMsgFilterPluginIID, NS_IMSGFILTERPLUGIN_IID);
#endif
#ifdef NS_IMSGFILTERSERVICE_IID
NP_DEF_ID(kMsgFilterServiceIID, NS_IMSGFILTERSERVICE_IID);
#endif
#ifdef NS_IMSGFOLDER_IID
NP_DEF_ID(kMsgFolderIID, NS_IMSGFOLDER_IID);
#endif
#ifdef NS_IMSGFOLDERCACHE_IID
NP_DEF_ID(kMsgFolderCacheIID, NS_IMSGFOLDERCACHE_IID);
#endif
#ifdef NS_IMSGFOLDERCACHEELEMENT_IID
NP_DEF_ID(kMsgFolderCacheElementIID, NS_IMSGFOLDERCACHEELEMENT_IID);
#endif
#ifdef NS_IMSGFOLDERCOMPACTOR_IID
NP_DEF_ID(kMsgFolderCompactorIID, NS_IMSGFOLDERCOMPACTOR_IID);
#endif
#ifdef NS_IMSGGROUPRECORD_IID
NP_DEF_ID(kMsgGroupRecordIID, NS_IMSGGROUPRECORD_IID);
#endif
#ifdef NS_IMSGHDR_IID
NP_DEF_ID(kMsgHdrIID, NS_IMSGHDR_IID);
#endif
#ifdef NS_IMSGHEADERPARSER_IID
NP_DEF_ID(kMsgHeaderParserIID, NS_IMSGHEADERPARSER_IID);
#endif
#ifdef NS_IMSGHOST_IID
NP_DEF_ID(kMsgHostIID, NS_IMSGHOST_IID);
#endif
#ifdef NS_IMSGIDENTITY_IID
NP_DEF_ID(kMsgIdentityIID, NS_IMSGIDENTITY_IID);
#endif
#ifdef NS_IMSGIMAPMAILFOLDER_IID
NP_DEF_ID(kMsgImapMailFolderIID, NS_IMSGIMAPMAILFOLDER_IID);
#endif
#ifdef NS_IMSGINCOMINGSERVER_IID
NP_DEF_ID(kMsgIncomingServerIID, NS_IMSGINCOMINGSERVER_IID);
#endif
#ifdef NS_IMSGLOCALMAILFOLDER_IID
NP_DEF_ID(kMsgLocalMailFolderIID, NS_IMSGLOCALMAILFOLDER_IID);
#endif
#ifdef NS_IMSGLOGONREDIRECTOR_IID
NP_DEF_ID(kMsgLogonRedirectorIID, NS_IMSGLOGONREDIRECTOR_IID);
#endif
#ifdef NS_IMSGMAILNEWSURL_IID
NP_DEF_ID(kMsgMailNewsUrlIID, NS_IMSGMAILNEWSURL_IID);
#endif
#ifdef NS_IMSGMAILSESSION_IID
NP_DEF_ID(kMsgMailSessionIID, NS_IMSGMAILSESSION_IID);
#endif
#ifdef NS_IMSGMAILVIEW_IID
NP_DEF_ID(kMsgMailViewIID, NS_IMSGMAILVIEW_IID);
#endif
#ifdef NS_IMSGMAILVIEWLIST_IID
NP_DEF_ID(kMsgMailViewListIID, NS_IMSGMAILVIEWLIST_IID);
#endif
#ifdef NS_IMSGMDNGENERATOR_IID
NP_DEF_ID(kMsgMdnGeneratorIID, NS_IMSGMDNGENERATOR_IID);
#endif
#ifdef NS_IMSGMESSAGESERVICE_IID
NP_DEF_ID(kMsgMessageServiceIID, NS_IMSGMESSAGESERVICE_IID);
#endif
#ifdef NS_IMSGNEWSFOLDER_IID
NP_DEF_ID(kMsgNewsFolderIID, NS_IMSGNEWSFOLDER_IID);
#endif
#ifdef NS_IMSGOFFLINEIMAPOPERATION_IID
NP_DEF_ID(kMsgOfflineImapOperationIID, NS_IMSGOFFLINEIMAPOPERATION_IID);
#endif
#ifdef NS_IMSGOFFLINEMANAGER_IID
NP_DEF_ID(kMsgOfflineManagerIID, NS_IMSGOFFLINEMANAGER_IID);
#endif
#ifdef NS_IMSGOFFLINENEWSSTATE_IID
NP_DEF_ID(kMsgOfflineNewsStateIID, NS_IMSGOFFLINENEWSSTATE_IID);
#endif
#ifdef NS_IMSGPARSEMAILMSGSTATE_IID
NP_DEF_ID(kMsgParseMailMsgStateIID, NS_IMSGPARSEMAILMSGSTATE_IID);
#endif
#ifdef NS_IMSGPRINTENGINE_IID
NP_DEF_ID(kMsgPrintEngineIID, NS_IMSGPRINTENGINE_IID);
#endif
#ifdef NS_IMSGPROGRESS_IID
NP_DEF_ID(kMsgProgressIID, NS_IMSGPROGRESS_IID);
#endif
#ifdef NS_IMSGPROTOCOLINFO_IID
NP_DEF_ID(kMsgProtocolInfoIID, NS_IMSGPROTOCOLINFO_IID);
#endif
#ifdef NS_IMSGPURGESERVICE_IID
NP_DEF_ID(kMsgPurgeServiceIID, NS_IMSGPURGESERVICE_IID);
#endif
#ifdef NS_IMSGQUOTE_IID
NP_DEF_ID(kMsgQuoteIID, NS_IMSGQUOTE_IID);
#endif
#ifdef NS_IMSGRDFDATASOURCE_IID
NP_DEF_ID(kMsgRDFDataSourceIID, NS_IMSGRDFDATASOURCE_IID);
#endif
#ifdef NS_IMSGRECIPIENTARRAY_IID
NP_DEF_ID(kMsgRecipientArrayIID, NS_IMSGRECIPIENTARRAY_IID);
#endif
#ifdef NS_IMSGSEARCHADAPTER_IID
NP_DEF_ID(kMsgSearchAdapterIID, NS_IMSGSEARCHADAPTER_IID);
#endif
#ifdef NS_IMSGSEARCHNOTIFY_IID
NP_DEF_ID(kMsgSearchNotifyIID, NS_IMSGSEARCHNOTIFY_IID);
#endif
#ifdef NS_IMSGSEARCHSCOPETERM_IID
NP_DEF_ID(kMsgSearchScopeTermIID, NS_IMSGSEARCHSCOPETERM_IID);
#endif
#ifdef NS_IMSGSEARCHSESSION_IID
NP_DEF_ID(kMsgSearchSessionIID, NS_IMSGSEARCHSESSION_IID);
#endif
#ifdef NS_IMSGSEARCHTERM_IID
NP_DEF_ID(kMsgSearchTermIID, NS_IMSGSEARCHTERM_IID);
#endif
#ifdef NS_IMSGSEARCHVALIDITYMANAGER_IID
NP_DEF_ID(kMsgSearchValidityManagerIID, NS_IMSGSEARCHVALIDITYMANAGER_IID);
#endif
#ifdef NS_IMSGSEARCHVALIDITYTABLE_IID
NP_DEF_ID(kMsgSearchValidityTableIID, NS_IMSGSEARCHVALIDITYTABLE_IID);
#endif
#ifdef NS_IMSGSEARCHVALUE_IID
NP_DEF_ID(kMsgSearchValueIID, NS_IMSGSEARCHVALUE_IID);
#endif
#ifdef NS_IMSGSEND_IID
NP_DEF_ID(kMsgSendIID, NS_IMSGSEND_IID);
#endif
#ifdef NS_IMSGSENDLATER_IID
NP_DEF_ID(kMsgSendLaterIID, NS_IMSGSENDLATER_IID);
#endif
#ifdef NS_IMSGSENDLATERLISTENER_IID
NP_DEF_ID(kMsgSendLaterListenerIID, NS_IMSGSENDLATERLISTENER_IID);
#endif
#ifdef NS_IMSGSENDLISTENER_IID
NP_DEF_ID(kMsgSendListenerIID, NS_IMSGSENDLISTENER_IID);
#endif
#ifdef NS_IMSGSENDREPORT_IID
NP_DEF_ID(kMsgSendReportIID, NS_IMSGSENDREPORT_IID);
#endif
#ifdef NS_IMSGSIGNATURE_IID
NP_DEF_ID(kMsgSignatureIID, NS_IMSGSIGNATURE_IID);
#endif
#ifdef NS_IMSGSMIMECOMPFIELDS_IID
NP_DEF_ID(kMsgSMIMECompFieldsIID, NS_IMSGSMIMECOMPFIELDS_IID);
#endif
#ifdef NS_IMSGSMIMEHEADERSINK_IID
NP_DEF_ID(kMsgSMIMEHeaderSinkIID, NS_IMSGSMIMEHEADERSINK_IID);
#endif
#ifdef NS_IMSGSTATUSFEEDBACK_IID
NP_DEF_ID(kMsgStatusFeedbackIID, NS_IMSGSTATUSFEEDBACK_IID);
#endif
#ifdef NS_IMSGSTRINGSERVICE_IID
NP_DEF_ID(kMsgStringServiceIID, NS_IMSGSTRINGSERVICE_IID);
#endif
#ifdef NS_IMSGTHREAD_IID
NP_DEF_ID(kMsgThreadIID, NS_IMSGTHREAD_IID);
#endif
#ifdef NS_IMSGVCARD_IID
NP_DEF_ID(kMsgVCardIID, NS_IMSGVCARD_IID);
#endif
#ifdef NS_IMSGWINDOW_IID
NP_DEF_ID(kMsgWindowIID, NS_IMSGWINDOW_IID);
#endif
#ifdef NS_IMULTIPARTCHANNEL_IID
NP_DEF_ID(kMultiPartChannelIID, NS_IMULTIPARTCHANNEL_IID);
#endif
#ifdef NS_IMULTIPLEXINPUTSTREAM_IID
NP_DEF_ID(kMultiplexInputStreamIID, NS_IMULTIPLEXINPUTSTREAM_IID);
#endif
#ifdef NS_INATIVEAPPSUPPORT_IID
NP_DEF_ID(kNativeAppSupportIID, NS_INATIVEAPPSUPPORT_IID);
#endif
#ifdef NS_INATIVECOMPONENTLOADER_IID
NP_DEF_ID(kNativeComponentLoaderIID, NS_INATIVECOMPONENTLOADER_IID);
#endif
#ifdef NS_INATIVESCROLLBAR_IID
NP_DEF_ID(kNativeScrollbarIID, NS_INATIVESCROLLBAR_IID);
#endif
#ifdef NS_INETMODREGENTRY_IID
NP_DEF_ID(kNetModRegEntryIID, NS_INETMODREGENTRY_IID);
#endif
#ifdef NS_INETMODULEMGR_IID
NP_DEF_ID(kNetModuleMgrIID, NS_INETMODULEMGR_IID);
#endif
#ifdef NS_INETNOTIFY_IID
NP_DEF_ID(kNetNotifyIID, NS_INETNOTIFY_IID);
#endif
#ifdef NS_INEWSDATABASE_IID
NP_DEF_ID(kNewsDatabaseIID, NS_INEWSDATABASE_IID);
#endif
#ifdef NS_INEWSDOWNLOADDIALOGARGS_IID
NP_DEF_ID(kNewsDownloadDialogArgsIID, NS_INEWSDOWNLOADDIALOGARGS_IID);
#endif
#ifdef NS_INNTPARTICLELIST_IID
NP_DEF_ID(kNNTPArticleListIID, NS_INNTPARTICLELIST_IID);
#endif
#ifdef NS_INNTPINCOMINGSERVER_IID
NP_DEF_ID(kNntpIncomingServerIID, NS_INNTPINCOMINGSERVER_IID);
#endif
#ifdef NS_INNTPNEWSGROUPLIST_IID
NP_DEF_ID(kNNTPNewsgroupListIID, NS_INNTPNEWSGROUPLIST_IID);
#endif
#ifdef NS_INNTPNEWSGROUPPOST_IID
NP_DEF_ID(kNNTPNewsgroupPostIID, NS_INNTPNEWSGROUPPOST_IID);
#endif
#ifdef NS_INNTPPROTOCOL_IID
NP_DEF_ID(kNNTPProtocolIID, NS_INNTPPROTOCOL_IID);
#endif
#ifdef NS_INNTPSERVICE_IID
NP_DEF_ID(kNntpServiceIID, NS_INNTPSERVICE_IID);
#endif
#ifdef NS_INNTPURL_IID
NP_DEF_ID(kNntpUrlIID, NS_INNTPURL_IID);
#endif
#ifdef NS_INOINCOMINGSERVER_IID
NP_DEF_ID(kNoIncomingServerIID, NS_INOINCOMINGSERVER_IID);
#endif
#ifdef NS_INONESERVICE_IID
NP_DEF_ID(kNoneServiceIID, NS_INONESERVICE_IID);
#endif
#ifdef NS_INSSCERTCACHE_IID
NP_DEF_ID(kNSSCertCacheIID, NS_INSSCERTCACHE_IID);
#endif
#ifdef NS_IOBJECTINPUTSTREAM_IID
NP_DEF_ID(kObjectInputStreamIID, NS_IOBJECTINPUTSTREAM_IID);
#endif
#ifdef NS_IOBJECTOUTPUTSTREAM_IID
NP_DEF_ID(kObjectOutputStreamIID, NS_IOBJECTOUTPUTSTREAM_IID);
#endif
#ifdef NS_IOBSERVER_IID
NP_DEF_ID(kObserverIID, NS_IOBSERVER_IID);
#endif
#ifdef NS_IOBSERVERSERVICE_IID
NP_DEF_ID(kObserverServiceIID, NS_IOBSERVERSERVICE_IID);
#endif
#ifdef NS_IOCSPRESPONDER_IID
NP_DEF_ID(kOCSPResponderIID, NS_IOCSPRESPONDER_IID);
#endif
#ifdef NS_IOUTPUTSTREAM_IID
NP_DEF_ID(kOutputStreamIID, NS_IOUTPUTSTREAM_IID);
#endif
#ifdef NS_IPASSWORD_IID
NP_DEF_ID(kPasswordIID, NS_IPASSWORD_IID);
#endif
#ifdef NS_IPASSWORDMANAGER_IID
NP_DEF_ID(kPasswordManagerIID, NS_IPASSWORDMANAGER_IID);
#endif
#ifdef NS_IPASSWORDMANAGERINTERNAL_IID
NP_DEF_ID(kPasswordManagerInternalIID, NS_IPASSWORDMANAGERINTERNAL_IID);
#endif
#ifdef NS_IPASSWORDSINK_IID
NP_DEF_ID(kPasswordSinkIID, NS_IPASSWORDSINK_IID);
#endif
#ifdef NS_IPERMISSION_IID
NP_DEF_ID(kPermissionIID, NS_IPERMISSION_IID);
#endif
#ifdef NS_IPERMISSIONMANAGER_IID
NP_DEF_ID(kPermissionManagerIID, NS_IPERMISSIONMANAGER_IID);
#endif
#ifdef NS_IPERSISTENTPROPERTIES2_IID
NP_DEF_ID(kPersistentProperties2IID, NS_IPERSISTENTPROPERTIES2_IID);
#endif
#ifdef NS_IPHONETIC_IID
NP_DEF_ID(kPhoneticIID, NS_IPHONETIC_IID);
#endif
#ifdef NS_IPIPE_IID
NP_DEF_ID(kPipeIID, NS_IPIPE_IID);
#endif
#ifdef NS_IPK11TOKEN_IID
NP_DEF_ID(kPK11TokenIID, NS_IPK11TOKEN_IID);
#endif
#ifdef NS_IPK11TOKENDB_IID
NP_DEF_ID(kPK11TokenDBIID, NS_IPK11TOKENDB_IID);
#endif
#ifdef NS_IPKCS11MODULE_IID
NP_DEF_ID(kPKCS11ModuleIID, NS_IPKCS11MODULE_IID);
#endif
#ifdef NS_IPKCS11MODULEDB_IID
NP_DEF_ID(kPKCS11ModuleDBIID, NS_IPKCS11MODULEDB_IID);
#endif
#ifdef NS_IPKCS11SLOT_IID
NP_DEF_ID(kPKCS11SlotIID, NS_IPKCS11SLOT_IID);
#endif
#ifdef NS_IPKIPARAMBLOCK_IID
NP_DEF_ID(kPKIParamBlockIID, NS_IPKIPARAMBLOCK_IID);
#endif
#ifdef NS_IPLAINTEXTEDITOR_IID
NP_DEF_ID(kPlaintextEditorIID, NS_IPLAINTEXTEDITOR_IID);
#endif
#ifdef NS_IPLUGIN_IID
NP_DEF_ID(kPluginIID, NS_IPLUGIN_IID);
#endif
#ifdef NS_IPLUGINHOST_IID
NP_DEF_ID(kPluginHostIID, NS_IPLUGINHOST_IID);
#endif
#ifdef NS_IPLUGININPUTSTREAM_IID
NP_DEF_ID(kPluginInputStreamIID, NS_IPLUGININPUTSTREAM_IID);
#endif
#ifdef NS_IPLUGININSTANCE_IID
NP_DEF_ID(kPluginInstanceIID, NS_IPLUGININSTANCE_IID);
#endif
#ifdef NS_IPLUGININSTANCEOWNER_IID
NP_DEF_ID(kPluginInstanceOwnerIID, NS_IPLUGININSTANCEOWNER_IID);
#endif
#ifdef NS_IPLUGININSTANCEPEER_IID
NP_DEF_ID(kPluginInstancePeerIID, NS_IPLUGININSTANCEPEER_IID);
#endif
#ifdef NS_IPLUGININSTANCEPEER2_IID
NP_DEF_ID(kPluginInstancePeer2IID, NS_IPLUGININSTANCEPEER2_IID);
#endif
#ifdef NS_IPLUGINMANAGER_IID
NP_DEF_ID(kPluginManagerIID, NS_IPLUGINMANAGER_IID);
#endif
#ifdef NS_IPLUGINMANAGER2_IID
NP_DEF_ID(kPluginManager2IID, NS_IPLUGINMANAGER2_IID);
#endif
#ifdef NS_IPLUGINSTREAMINFO_IID
NP_DEF_ID(kPluginStreamInfoIID, NS_IPLUGINSTREAMINFO_IID);
#endif
#ifdef NS_IPLUGINSTREAMLISTENER_IID
NP_DEF_ID(kPluginStreamListenerIID, NS_IPLUGINSTREAMLISTENER_IID);
#endif
#ifdef NS_IPLUGINTAGINFO_IID
NP_DEF_ID(kPluginTagInfoIID, NS_IPLUGINTAGINFO_IID);
#endif
#ifdef NS_IPLUGINTAGINFO2_IID
NP_DEF_ID(kPluginTagInfo2IID, NS_IPLUGINTAGINFO2_IID);
#endif
#ifdef NS_IPLUGINVIEWER_IID
NP_DEF_ID(kPluginViewerIID, NS_IPLUGINVIEWER_IID);
#endif
#ifdef NS_IPOP3INCOMINGSERVER_IID
NP_DEF_ID(kPop3IncomingServerIID, NS_IPOP3INCOMINGSERVER_IID);
#endif
#ifdef NS_IPOP3SERVICE_IID
NP_DEF_ID(kPop3ServiceIID, NS_IPOP3SERVICE_IID);
#endif
#ifdef NS_IPOP3SINK_IID
NP_DEF_ID(kPop3SinkIID, NS_IPOP3SINK_IID);
#endif
#ifdef NS_IPOP3URL_IID
NP_DEF_ID(kPop3URLIID, NS_IPOP3URL_IID);
#endif
#ifdef NS_IPOPUPBOXOBJECT_IID
NP_DEF_ID(kPopupBoxObjectIID, NS_IPOPUPBOXOBJECT_IID);
#endif
#ifdef NS_IPOPUPWINDOWMANAGER_IID
NP_DEF_ID(kPopupWindowManagerIID, NS_IPOPUPWINDOWMANAGER_IID);
#endif
#ifdef NS_IPREF_IID
NP_DEF_ID(kPrefIID, NS_IPREF_IID);
#endif
#ifdef NS_IPREFBRANCH_IID
NP_DEF_ID(kPrefBranchIID, NS_IPREFBRANCH_IID);
#endif
#ifdef NS_IPREFBRANCHINTERNAL_IID
NP_DEF_ID(kPrefBranchInternalIID, NS_IPREFBRANCHINTERNAL_IID);
#endif
#ifdef NS_IPREFETCHSERVICE_IID
NP_DEF_ID(kPrefetchServiceIID, NS_IPREFETCHSERVICE_IID);
#endif
#ifdef NS_IPREFLOCALIZEDSTRING_IID
NP_DEF_ID(kPrefLocalizedStringIID, NS_IPREFLOCALIZEDSTRING_IID);
#endif
#ifdef NS_IPREFMIGRATION_IID
NP_DEF_ID(kPrefMigrationIID, NS_IPREFMIGRATION_IID);
#endif
#ifdef NS_IPREFMIGRATIONPROGRESS_IID
NP_DEF_ID(kPrefMigrationProgressIID, NS_IPREFMIGRATIONPROGRESS_IID);
#endif
#ifdef NS_IPREFSERVICE_IID
NP_DEF_ID(kPrefServiceIID, NS_IPREFSERVICE_IID);
#endif
#ifdef NS_IPRINCIPAL_IID
NP_DEF_ID(kPrincipalIID, NS_IPRINCIPAL_IID);
#endif
#ifdef NS_IPRINTINGPROMPT_IID
NP_DEF_ID(kPrintingPromptIID, NS_IPRINTINGPROMPT_IID);
#endif
#ifdef NS_IPRINTINGPROMPTSERVICE_IID
NP_DEF_ID(kPrintingPromptServiceIID, NS_IPRINTINGPROMPTSERVICE_IID);
#endif
#ifdef NS_IPRINTOPTIONS_IID
NP_DEF_ID(kPrintOptionsIID, NS_IPRINTOPTIONS_IID);
#endif
#ifdef NS_IPRINTPROGRESS_IID
NP_DEF_ID(kPrintProgressIID, NS_IPRINTPROGRESS_IID);
#endif
#ifdef NS_IPRINTPROGRESSPARAMS_IID
NP_DEF_ID(kPrintProgressParamsIID, NS_IPRINTPROGRESSPARAMS_IID);
#endif
#ifdef NS_IPRINTSESSION_IID
NP_DEF_ID(kPrintSessionIID, NS_IPRINTSESSION_IID);
#endif
#ifdef NS_IPRINTSETTINGS_IID
NP_DEF_ID(kPrintSettingsIID, NS_IPRINTSETTINGS_IID);
#endif
#ifdef NS_IPRINTSETTINGSSERVICE_IID
NP_DEF_ID(kPrintSettingsServiceIID, NS_IPRINTSETTINGSSERVICE_IID);
#endif
#ifdef NS_IPRINTSTATUSFEEDBACK_IID
NP_DEF_ID(kPrintStatusFeedbackIID, NS_IPRINTSTATUSFEEDBACK_IID);
#endif
#ifdef NS_IPROCESS_IID
NP_DEF_ID(kProcessIID, NS_IPROCESS_IID);
#endif
#ifdef NS_IPROFILE_IID
NP_DEF_ID(kProfileIID, NS_IPROFILE_IID);
#endif
#ifdef NS_IPROFILECHANGESTATUS_IID
NP_DEF_ID(kProfileChangeStatusIID, NS_IPROFILECHANGESTATUS_IID);
#endif
#ifdef NS_IPROFILEINTERNAL_IID
NP_DEF_ID(kProfileInternalIID, NS_IPROFILEINTERNAL_IID);
#endif
#ifdef NS_IPROFILESTARTUPLISTENER_IID
NP_DEF_ID(kProfileStartupListenerIID, NS_IPROFILESTARTUPLISTENER_IID);
#endif
#ifdef NS_IPROGRAMMINGLANGUAGE_IID
NP_DEF_ID(kProgrammingLanguageIID, NS_IPROGRAMMINGLANGUAGE_IID);
#endif
#ifdef NS_IPROGRESSDIALOG_IID
NP_DEF_ID(kProgressDialogIID, NS_IPROGRESSDIALOG_IID);
#endif
#ifdef NS_IPROGRESSEVENTSINK_IID
NP_DEF_ID(kProgressEventSinkIID, NS_IPROGRESSEVENTSINK_IID);
#endif
#ifdef NS_IPROMPT_IID
NP_DEF_ID(kPromptIID, NS_IPROMPT_IID);
#endif
#ifdef NS_IPROMPTSERVICE_IID
NP_DEF_ID(kPromptServiceIID, NS_IPROMPTSERVICE_IID);
#endif
#ifdef NS_IPROPERTIES_IID
NP_DEF_ID(kPropertiesIID, NS_IPROPERTIES_IID);
#endif
#ifdef NS_IPROPERTYBAG_IID
NP_DEF_ID(kPropertyBagIID, NS_IPROPERTYBAG_IID);
#endif
#ifdef NS_IPROTOCOLHANDLER_IID
NP_DEF_ID(kProtocolHandlerIID, NS_IPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IPROTOCOLPROXYSERVICE_IID
NP_DEF_ID(kProtocolProxyServiceIID, NS_IPROTOCOLPROXYSERVICE_IID);
#endif
#ifdef NS_IPROXIEDPROTOCOLHANDLER_IID
NP_DEF_ID(kProxiedProtocolHandlerIID, NS_IPROXIEDPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IPROXY_IID
NP_DEF_ID(kProxyIID, NS_IPROXY_IID);
#endif
#ifdef NS_IPROXYAUTOCONFIG_IID
NP_DEF_ID(kProxyAutoConfigIID, NS_IPROXYAUTOCONFIG_IID);
#endif
#ifdef NS_IPROXYCREATEINSTANCE_IID
NP_DEF_ID(kProxyCreateInstanceIID, NS_IPROXYCREATEINSTANCE_IID);
#endif
#ifdef NS_IPROXYINFO_IID
NP_DEF_ID(kProxyInfoIID, NS_IPROXYINFO_IID);
#endif
#ifdef NS_IPROXYOBJECTMANAGER_IID
NP_DEF_ID(kProxyObjectManagerIID, NS_IPROXYOBJECTMANAGER_IID);
#endif
#ifdef NS_IRDFCOMPOSITEDATASOURCE_IID
NP_DEF_ID(kRDFCompositeDataSourceIID, NS_IRDFCOMPOSITEDATASOURCE_IID);
#endif
#ifdef NS_IRDFCONTAINER_IID
NP_DEF_ID(kRDFContainerIID, NS_IRDFCONTAINER_IID);
#endif
#ifdef NS_IRDFCONTAINERUTILS_IID
NP_DEF_ID(kRDFContainerUtilsIID, NS_IRDFCONTAINERUTILS_IID);
#endif
#ifdef NS_IRDFDATASOURCE_IID
NP_DEF_ID(kRDFDataSourceIID, NS_IRDFDATASOURCE_IID);
#endif
#ifdef NS_IRDFDELEGATEFACTORY_IID
NP_DEF_ID(kRDFDelegateFactoryIID, NS_IRDFDELEGATEFACTORY_IID);
#endif
#ifdef NS_IRDFINMEMORYDATASOURCE_IID
NP_DEF_ID(kRDFInMemoryDataSourceIID, NS_IRDFINMEMORYDATASOURCE_IID);
#endif
#ifdef NS_IRDFLITERAL_IID
NP_DEF_ID(kRDFLiteralIID, NS_IRDFLITERAL_IID);
#endif
#ifdef NS_IRDFNODE_IID
NP_DEF_ID(kRDFNodeIID, NS_IRDFNODE_IID);
#endif
#ifdef NS_IRDFOBSERVER_IID
NP_DEF_ID(kRDFObserverIID, NS_IRDFOBSERVER_IID);
#endif
#ifdef NS_IRDFPURGEABLEDATASOURCE_IID
NP_DEF_ID(kRDFPurgeableDataSourceIID, NS_IRDFPURGEABLEDATASOURCE_IID);
#endif
#ifdef NS_IRDFREMOTEDATASOURCE_IID
NP_DEF_ID(kRDFRemoteDataSourceIID, NS_IRDFREMOTEDATASOURCE_IID);
#endif
#ifdef NS_IRDFRESOURCE_IID
NP_DEF_ID(kRDFResourceIID, NS_IRDFRESOURCE_IID);
#endif
#ifdef NS_IRDFSERVICE_IID
NP_DEF_ID(kRDFServiceIID, NS_IRDFSERVICE_IID);
#endif
#ifdef NS_IRDFXMLPARSER_IID
NP_DEF_ID(kRDFXMLParserIID, NS_IRDFXMLPARSER_IID);
#endif
#ifdef NS_IRDFXMLSERIALIZER_IID
NP_DEF_ID(kRDFXMLSerializerIID, NS_IRDFXMLSERIALIZER_IID);
#endif
#ifdef NS_IRDFXMLSINK_IID
NP_DEF_ID(kRDFXMLSinkIID, NS_IRDFXMLSINK_IID);
#endif
#ifdef NS_IRDFXMLSOURCE_IID
NP_DEF_ID(kRDFXMLSourceIID, NS_IRDFXMLSOURCE_IID);
#endif
#ifdef NS_IREADCONFIG_IID
NP_DEF_ID(kReadConfigIID, NS_IREADCONFIG_IID);
#endif
#ifdef NS_IRECYCLINGALLOCATOR_IID
NP_DEF_ID(kRecyclingAllocatorIID, NS_IRECYCLINGALLOCATOR_IID);
#endif
#ifdef NS_IREFRESHURI_IID
NP_DEF_ID(kRefreshURIIID, NS_IREFRESHURI_IID);
#endif
#ifdef NS_IREGISTRY_IID
NP_DEF_ID(kRegistryIID, NS_IREGISTRY_IID);
#endif
#ifdef NS_IRELATIVEFILEPREF_IID
NP_DEF_ID(kRelativeFilePrefIID, NS_IRELATIVEFILEPREF_IID);
#endif
#ifdef NS_IREQUEST_IID
NP_DEF_ID(kRequestIID, NS_IREQUEST_IID);
#endif
#ifdef NS_IREQUESTOBSERVER_IID
NP_DEF_ID(kRequestObserverIID, NS_IREQUESTOBSERVER_IID);
#endif
#ifdef NS_IREQUESTOBSERVERPROXY_IID
NP_DEF_ID(kRequestObserverProxyIID, NS_IREQUESTOBSERVERPROXY_IID);
#endif
#ifdef NS_IRESPROTOCOLHANDLER_IID
NP_DEF_ID(kResProtocolHandlerIID, NS_IRESPROTOCOLHANDLER_IID);
#endif
#ifdef NS_IRESUMABLECHANNEL_IID
NP_DEF_ID(kResumableChannelIID, NS_IRESUMABLECHANNEL_IID);
#endif
#ifdef NS_IRESUMABLEENTITYID_IID
NP_DEF_ID(kResumableEntityIDIID, NS_IRESUMABLEENTITYID_IID);
#endif
#ifdef NS_IROLLUPLISTENER_IID
NP_DEF_ID(kRollupListenerIID, NS_IROLLUPLISTENER_IID);
#endif
#ifdef NS_IRUNNABLE_IID
NP_DEF_ID(kRunnableIID, NS_IRUNNABLE_IID);
#endif
#ifdef NS_ISAMPLE_IID
NP_DEF_ID(kSampleIID, NS_ISAMPLE_IID);
#endif
#ifdef NS_ISAVEASCHARSET_IID
NP_DEF_ID(kSaveAsCharsetIID, NS_ISAVEASCHARSET_IID);
#endif
#ifdef NS_ISCHEMA_IID
NP_DEF_ID(kSchemaIID, NS_ISCHEMA_IID);
#endif
#ifdef NS_ISCHEMALOADER_IID
NP_DEF_ID(kSchemaLoaderIID, NS_ISCHEMALOADER_IID);
#endif
#ifdef NS_ISCREEN_IID
NP_DEF_ID(kScreenIID, NS_ISCREEN_IID);
#endif
#ifdef NS_ISCREENMANAGER_IID
NP_DEF_ID(kScreenManagerIID, NS_ISCREENMANAGER_IID);
#endif
#ifdef NS_ISCRIPTABLEDATEFORMAT_IID
NP_DEF_ID(kScriptableDateFormatIID, NS_ISCRIPTABLEDATEFORMAT_IID);
#endif
#ifdef NS_ISCRIPTABLEINPUTSTREAM_IID
NP_DEF_ID(kScriptableInputStreamIID, NS_ISCRIPTABLEINPUTSTREAM_IID);
#endif
#ifdef NS_ISCRIPTABLEINTERFACES_IID
NP_DEF_ID(kScriptableInterfacesIID, NS_ISCRIPTABLEINTERFACES_IID);
#endif
#ifdef NS_ISCRIPTABLEPLUGIN_IID
NP_DEF_ID(kScriptablePluginIID, NS_ISCRIPTABLEPLUGIN_IID);
#endif
#ifdef NS_ISCRIPTABLEREGION_IID
NP_DEF_ID(kScriptableRegionIID, NS_ISCRIPTABLEREGION_IID);
#endif
#ifdef NS_ISCRIPTABLEUCONV_IID
NP_DEF_ID(kScriptableUConvIID, NS_ISCRIPTABLEUCONV_IID);
#endif
#ifdef NS_ISCRIPTCONTEXTOWNER_IID
NP_DEF_ID(kScriptContextOwnerIID, NS_ISCRIPTCONTEXTOWNER_IID);
#endif
#ifdef NS_ISCRIPTERROR_IID
NP_DEF_ID(kScriptErrorIID, NS_ISCRIPTERROR_IID);
#endif
#ifdef NS_ISCRIPTEVENTHANDLER_IID
NP_DEF_ID(kScriptEventHandlerIID, NS_ISCRIPTEVENTHANDLER_IID);
#endif
#ifdef NS_ISCRIPTEVENTMANAGER_IID
NP_DEF_ID(kScriptEventManagerIID, NS_ISCRIPTEVENTMANAGER_IID);
#endif
#ifdef NS_ISCRIPTGLOBALOBJECTOWNER_IID
NP_DEF_ID(kScriptGlobalObjectOwnerIID, NS_ISCRIPTGLOBALOBJECTOWNER_IID);
#endif
#ifdef NS_ISCRIPTLOADER_IID
NP_DEF_ID(kScriptLoaderIID, NS_ISCRIPTLOADER_IID);
#endif
#ifdef NS_ISCRIPTLOADEROBSERVER_IID
NP_DEF_ID(kScriptLoaderObserverIID, NS_ISCRIPTLOADEROBSERVER_IID);
#endif
#ifdef NS_ISCRIPTSECURITYMANAGER_IID
NP_DEF_ID(kScriptSecurityManagerIID, NS_ISCRIPTSECURITYMANAGER_IID);
#endif
#ifdef NS_ISCROLLABLE_IID
NP_DEF_ID(kScrollableIID, NS_ISCROLLABLE_IID);
#endif
#ifdef NS_ISCROLLBOXOBJECT_IID
NP_DEF_ID(kScrollBoxObjectIID, NS_ISCROLLBOXOBJECT_IID);
#endif
#ifdef NS_ISEARCHCONTEXT_IID
NP_DEF_ID(kSearchContextIID, NS_ISEARCHCONTEXT_IID);
#endif
#ifdef NS_ISEARCHSERVICE_IID
NP_DEF_ID(kSearchServiceIID, NS_ISEARCHSERVICE_IID);
#endif
#ifdef NS_ISECRETDECODERRING_IID
NP_DEF_ID(kSecretDecoderRingIID, NS_ISECRETDECODERRING_IID);
#endif
#ifdef NS_ISECUREBROWSERUI_IID
NP_DEF_ID(kSecureBrowserUIIID, NS_ISECUREBROWSERUI_IID);
#endif
#ifdef NS_ISECURITYCHECKEDCOMPONENT_IID
NP_DEF_ID(kSecurityCheckedComponentIID, NS_ISECURITYCHECKEDCOMPONENT_IID);
#endif
#ifdef NS_ISECURITYEVENTSINK_IID
NP_DEF_ID(kSecurityEventSinkIID, NS_ISECURITYEVENTSINK_IID);
#endif
#ifdef NS_ISECURITYPREF_IID
NP_DEF_ID(kSecurityPrefIID, NS_ISECURITYPREF_IID);
#endif
#ifdef NS_ISECURITYWARNINGDIALOGS_IID
NP_DEF_ID(kSecurityWarningDialogsIID, NS_ISECURITYWARNINGDIALOGS_IID);
#endif
#ifdef NS_ISEEKABLESTREAM_IID
NP_DEF_ID(kSeekableStreamIID, NS_ISEEKABLESTREAM_IID);
#endif
#ifdef NS_ISELECTELEMENT_IID
NP_DEF_ID(kSelectElementIID, NS_ISELECTELEMENT_IID);
#endif
#ifdef NS_ISELECTION_IID
NP_DEF_ID(kSelectionIID, NS_ISELECTION_IID);
#endif
#ifdef NS_ISELECTIONCONTROLLER_IID
NP_DEF_ID(kSelectionControllerIID, NS_ISELECTIONCONTROLLER_IID);
#endif
#ifdef NS_ISELECTIONDISPLAY_IID
NP_DEF_ID(kSelectionDisplayIID, NS_ISELECTIONDISPLAY_IID);
#endif
#ifdef NS_ISELECTIONIMAGESERVICE_IID
NP_DEF_ID(kSelectionImageServiceIID, NS_ISELECTIONIMAGESERVICE_IID);
#endif
#ifdef NS_ISELECTIONLISTENER_IID
NP_DEF_ID(kSelectionListenerIID, NS_ISELECTIONLISTENER_IID);
#endif
#ifdef NS_ISELECTIONPRIVATE_IID
NP_DEF_ID(kSelectionPrivateIID, NS_ISELECTIONPRIVATE_IID);
#endif
#ifdef NS_ISEMANTICUNITSCANNER_IID
NP_DEF_ID(kSemanticUnitScannerIID, NS_ISEMANTICUNITSCANNER_IID);
#endif
#ifdef NS_ISERIALIZABLE_IID
NP_DEF_ID(kSerializableIID, NS_ISERIALIZABLE_IID);
#endif
#ifdef NS_ISERVICEMANAGER_IID
NP_DEF_ID(kServiceManagerIID, NS_ISERVICEMANAGER_IID);
#endif
#ifdef NS_ISHCONTAINER_IID
NP_DEF_ID(kSHContainerIID, NS_ISHCONTAINER_IID);
#endif
#ifdef NS_ISHENTRY_IID
NP_DEF_ID(kSHEntryIID, NS_ISHENTRY_IID);
#endif
#ifdef NS_ISHISTORY_IID
NP_DEF_ID(kSHistoryIID, NS_ISHISTORY_IID);
#endif
#ifdef NS_ISHISTORYINTERNAL_IID
NP_DEF_ID(kSHistoryInternalIID, NS_ISHISTORYINTERNAL_IID);
#endif
#ifdef NS_ISHISTORYLISTENER_IID
NP_DEF_ID(kSHistoryListenerIID, NS_ISHISTORYLISTENER_IID);
#endif
#ifdef NS_ISHTRANSACTION_IID
NP_DEF_ID(kSHTransactionIID, NS_ISHTRANSACTION_IID);
#endif
#ifdef NS_ISIDEBAR_IID
NP_DEF_ID(kSidebarIID, NS_ISIDEBAR_IID);
#endif
#ifdef NS_ISIGNATUREVERIFIER_IID
NP_DEF_ID(kSignatureVerifierIID, NS_ISIGNATUREVERIFIER_IID);
#endif
#ifdef NS_ISIGNONVIEWER_IID
NP_DEF_ID(kSignonViewerIID, NS_ISIGNONVIEWER_IID);
#endif
#ifdef NS_ISIMPLEENUMERATOR_IID
NP_DEF_ID(kSimpleEnumeratorIID, NS_ISIMPLEENUMERATOR_IID);
#endif
#ifdef NS_ISIMPLESTREAMLISTENER_IID
NP_DEF_ID(kSimpleStreamListenerIID, NS_ISIMPLESTREAMLISTENER_IID);
#endif
#ifdef NS_ISMIMECERT_IID
NP_DEF_ID(kSMimeCertIID, NS_ISMIMECERT_IID);
#endif
#ifdef NS_ISMIMEJSHELPER_IID
NP_DEF_ID(kSMimeJSHelperIID, NS_ISMIMEJSHELPER_IID);
#endif
#ifdef NS_ISMTPSERVER_IID
NP_DEF_ID(kSmtpServerIID, NS_ISMTPSERVER_IID);
#endif
#ifdef NS_ISMTPSERVICE_IID
NP_DEF_ID(kSmtpServiceIID, NS_ISMTPSERVICE_IID);
#endif
#ifdef NS_ISMTPURL_IID
NP_DEF_ID(kSmtpUrlIID, NS_ISMTPURL_IID);
#endif
#ifdef NS_ISOAPATTACHMENTS_IID
NP_DEF_ID(kSOAPAttachmentsIID, NS_ISOAPATTACHMENTS_IID);
#endif
#ifdef NS_ISOAPBLOCK_IID
NP_DEF_ID(kSOAPBlockIID, NS_ISOAPBLOCK_IID);
#endif
#ifdef NS_ISOAPCALL_IID
NP_DEF_ID(kSOAPCallIID, NS_ISOAPCALL_IID);
#endif
#ifdef NS_ISOAPCALLCOMPLETION_IID
NP_DEF_ID(kSOAPCallCompletionIID, NS_ISOAPCALLCOMPLETION_IID);
#endif
#ifdef NS_ISOAPDECODER_IID
NP_DEF_ID(kSOAPDecoderIID, NS_ISOAPDECODER_IID);
#endif
#ifdef NS_ISOAPENCODER_IID
NP_DEF_ID(kSOAPEncoderIID, NS_ISOAPENCODER_IID);
#endif
#ifdef NS_ISOAPENCODING_IID
NP_DEF_ID(kSOAPEncodingIID, NS_ISOAPENCODING_IID);
#endif
#ifdef NS_ISOAPFAULT_IID
NP_DEF_ID(kSOAPFaultIID, NS_ISOAPFAULT_IID);
#endif
#ifdef NS_ISOAPHEADERBLOCK_IID
NP_DEF_ID(kSOAPHeaderBlockIID, NS_ISOAPHEADERBLOCK_IID);
#endif
#ifdef NS_ISOAPMESSAGE_IID
NP_DEF_ID(kSOAPMessageIID, NS_ISOAPMESSAGE_IID);
#endif
#ifdef NS_ISOAPPARAMETER_IID
NP_DEF_ID(kSOAPParameterIID, NS_ISOAPPARAMETER_IID);
#endif
#ifdef NS_ISOAPPROPERTYBAGMUTATOR_IID
NP_DEF_ID(kSOAPPropertyBagMutatorIID, NS_ISOAPPROPERTYBAGMUTATOR_IID);
#endif
#ifdef NS_ISOAPRESPONSE_IID
NP_DEF_ID(kSOAPResponseIID, NS_ISOAPRESPONSE_IID);
#endif
#ifdef NS_ISOAPRESPONSELISTENER_IID
NP_DEF_ID(kSOAPResponseListenerIID, NS_ISOAPRESPONSELISTENER_IID);
#endif
#ifdef NS_ISOAPSERVICE_IID
NP_DEF_ID(kSOAPServiceIID, NS_ISOAPSERVICE_IID);
#endif
#ifdef NS_ISOAPSERVICEREGISTRY_IID
NP_DEF_ID(kSOAPServiceRegistryIID, NS_ISOAPSERVICEREGISTRY_IID);
#endif
#ifdef NS_ISOAPTRANSPORT_IID
NP_DEF_ID(kSOAPTransportIID, NS_ISOAPTRANSPORT_IID);
#endif
#ifdef NS_ISOAPTRANSPORTLISTENER_IID
NP_DEF_ID(kSOAPTransportListenerIID, NS_ISOAPTRANSPORTLISTENER_IID);
#endif
#ifdef NS_ISOCKETPROVIDER_IID
NP_DEF_ID(kSocketProviderIID, NS_ISOCKETPROVIDER_IID);
#endif
#ifdef NS_ISOCKETPROVIDERSERVICE_IID
NP_DEF_ID(kSocketProviderServiceIID, NS_ISOCKETPROVIDERSERVICE_IID);
#endif
#ifdef NS_ISOCKETTRANSPORT_IID
NP_DEF_ID(kSocketTransportIID, NS_ISOCKETTRANSPORT_IID);
#endif
#ifdef NS_ISOCKETTRANSPORTSERVICE_IID
NP_DEF_ID(kSocketTransportServiceIID, NS_ISOCKETTRANSPORTSERVICE_IID);
#endif
#ifdef NS_ISOCKS4SOCKETINFO_IID
NP_DEF_ID(kSOCKS4SocketInfoIID, NS_ISOCKS4SOCKETINFO_IID);
#endif
#ifdef NS_ISOCKS4SOCKETPROVIDER_IID
NP_DEF_ID(kSOCKS4SocketProviderIID, NS_ISOCKS4SOCKETPROVIDER_IID);
#endif
#ifdef NS_ISOCKSSOCKETINFO_IID
NP_DEF_ID(kSOCKSSocketInfoIID, NS_ISOCKSSOCKETINFO_IID);
#endif
#ifdef NS_ISOCKSSOCKETPROVIDER_IID
NP_DEF_ID(kSOCKSSocketProviderIID, NS_ISOCKSSOCKETPROVIDER_IID);
#endif
#ifdef NS_ISOUND_IID
NP_DEF_ID(kSoundIID, NS_ISOUND_IID);
#endif
#ifdef NS_ISPAMSETTINGS_IID
NP_DEF_ID(kSpamSettingsIID, NS_ISPAMSETTINGS_IID);
#endif
#ifdef NS_ISSLSOCKETCONTROL_IID
NP_DEF_ID(kSSLSocketControlIID, NS_ISSLSOCKETCONTROL_IID);
#endif
#ifdef NS_ISSLSOCKETPROVIDER_IID
NP_DEF_ID(kSSLSocketProviderIID, NS_ISSLSOCKETPROVIDER_IID);
#endif
#ifdef NS_ISSLSTATUS_IID
NP_DEF_ID(kSSLStatusIID, NS_ISSLSTATUS_IID);
#endif
#ifdef NS_ISSLSTATUSPROVIDER_IID
NP_DEF_ID(kSSLStatusProviderIID, NS_ISSLSTATUSPROVIDER_IID);
#endif
#ifdef NS_ISTANDARDURL_IID
NP_DEF_ID(kStandardURLIID, NS_ISTANDARDURL_IID);
#endif
#ifdef NS_ISTORAGESTREAM_IID
NP_DEF_ID(kStorageStreamIID, NS_ISTORAGESTREAM_IID);
#endif
#ifdef NS_ISTREAMBUFFERACCESS_IID
NP_DEF_ID(kStreamBufferAccessIID, NS_ISTREAMBUFFERACCESS_IID);
#endif
#ifdef NS_ISTREAMCONVERTER_IID
NP_DEF_ID(kStreamConverterIID, NS_ISTREAMCONVERTER_IID);
#endif
#ifdef NS_ISTREAMCONVERTERSERVICE_IID
NP_DEF_ID(kStreamConverterServiceIID, NS_ISTREAMCONVERTERSERVICE_IID);
#endif
#ifdef NS_ISTREAMLISTENER_IID
NP_DEF_ID(kStreamListenerIID, NS_ISTREAMLISTENER_IID);
#endif
#ifdef NS_ISTREAMLISTENERPROXY_IID
NP_DEF_ID(kStreamListenerProxyIID, NS_ISTREAMLISTENERPROXY_IID);
#endif
#ifdef NS_ISTREAMLISTENERTEE_IID
NP_DEF_ID(kStreamListenerTeeIID, NS_ISTREAMLISTENERTEE_IID);
#endif
#ifdef NS_ISTREAMLOADER_IID
NP_DEF_ID(kStreamLoaderIID, NS_ISTREAMLOADER_IID);
#endif
#ifdef NS_ISTREAMTRANSPORTSERVICE_IID
NP_DEF_ID(kStreamTransportServiceIID, NS_ISTREAMTRANSPORTSERVICE_IID);
#endif
#ifdef NS_ISTRINGBUNDLE_IID
NP_DEF_ID(kStringBundleIID, NS_ISTRINGBUNDLE_IID);
#endif
#ifdef NS_ISTRINGBUNDLEOVERRIDE_IID
NP_DEF_ID(kStringBundleOverrideIID, NS_ISTRINGBUNDLEOVERRIDE_IID);
#endif
#ifdef NS_ISTRINGSERVICE_IID
NP_DEF_ID(kStringServiceIID, NS_ISTRINGSERVICE_IID);
#endif
#ifdef NS_ISTRINGSTREAM_IID
NP_DEF_ID(kStringStreamIID, NS_ISTRINGSTREAM_IID);
#endif
#ifdef NS_ISUBSCRIBABLESERVER_IID
NP_DEF_ID(kSubscribableServerIID, NS_ISUBSCRIBABLESERVER_IID);
#endif
#ifdef NS_ISUPPORTS_IID
NP_DEF_ID(kSupportsIID, NS_ISUPPORTS_IID);
#endif
#ifdef NS_ISUPPORTSARRAY_IID
NP_DEF_ID(kSupportsArrayIID, NS_ISUPPORTSARRAY_IID);
#endif
#ifdef NS_ISUPPORTSITERATORS_IID
NP_DEF_ID(kSupportsIteratorsIID, NS_ISUPPORTSITERATORS_IID);
#endif
#ifdef NS_ISUPPORTSPRIMITIVES_IID
NP_DEF_ID(kSupportsPrimitivesIID, NS_ISUPPORTSPRIMITIVES_IID);
#endif
#ifdef NS_ISYNCLOADDOMSERVICE_IID
NP_DEF_ID(kSyncLoadDOMServiceIID, NS_ISYNCLOADDOMSERVICE_IID);
#endif
#ifdef NS_ITABLEEDITOR_IID
NP_DEF_ID(kTableEditorIID, NS_ITABLEEDITOR_IID);
#endif
#ifdef NS_ITESTPROXY_IID
NP_DEF_ID(kTestProxyIID, NS_ITESTPROXY_IID);
#endif
#ifdef NS_ITEXTAREAELEMENT_IID
NP_DEF_ID(kTextAreaElementIID, NS_ITEXTAREAELEMENT_IID);
#endif
#ifdef NS_ITEXTSCROLL_IID
NP_DEF_ID(kTextScrollIID, NS_ITEXTSCROLL_IID);
#endif
#ifdef NS_ITEXTSERVICESFILTER_IID
NP_DEF_ID(kTextServicesFilterIID, NS_ITEXTSERVICESFILTER_IID);
#endif
#ifdef NS_ITEXTTOSUBURI_IID
NP_DEF_ID(kTextToSubURIIID, NS_ITEXTTOSUBURI_IID);
#endif
#ifdef NS_ITHREAD_IID
NP_DEF_ID(kThreadIID, NS_ITHREAD_IID);
#endif
#ifdef NS_ITHREADPOOL_IID
NP_DEF_ID(kThreadPoolIID, NS_ITHREADPOOL_IID);
#endif
#ifdef NS_ITIMEBOMB_IID
NP_DEF_ID(kTimeBombIID, NS_ITIMEBOMB_IID);
#endif
#ifdef NS_ITIMELINESERVICE_IID
NP_DEF_ID(kTimelineServiceIID, NS_ITIMELINESERVICE_IID);
#endif
#ifdef NS_ITIMER_IID
NP_DEF_ID(kTimerIID, NS_ITIMER_IID);
#endif
#ifdef NS_ITIMERECORDER_IID
NP_DEF_ID(kTimeRecorderIID, NS_ITIMERECORDER_IID);
#endif
#ifdef NS_ITIMERINTERNAL_IID
NP_DEF_ID(kTimerInternalIID, NS_ITIMERINTERNAL_IID);
#endif
#ifdef NS_ITIMERMANAGER_IID
NP_DEF_ID(kTimerManagerIID, NS_ITIMERMANAGER_IID);
#endif
#ifdef NS_ITIMINGSERVICE_IID
NP_DEF_ID(kTimingServiceIID, NS_ITIMINGSERVICE_IID);
#endif
#ifdef NS_ITOKENDIALOGS_IID
NP_DEF_ID(kTokenDialogsIID, NS_ITOKENDIALOGS_IID);
#endif
#ifdef NS_ITOKENPASSWORDDIALOGS_IID
NP_DEF_ID(kTokenPasswordDialogsIID, NS_ITOKENPASSWORDDIALOGS_IID);
#endif
#ifdef NS_ITOOLKIT_IID
NP_DEF_ID(kToolkitIID, NS_ITOOLKIT_IID);
#endif
#ifdef NS_ITOOLTIPLISTENER_IID
NP_DEF_ID(kTooltipListenerIID, NS_ITOOLTIPLISTENER_IID);
#endif
#ifdef NS_ITOOLTIPTEXTPROVIDER_IID
NP_DEF_ID(kTooltipTextProviderIID, NS_ITOOLTIPTEXTPROVIDER_IID);
#endif
#ifdef NS_ITRANSACTION_IID
NP_DEF_ID(kTransactionIID, NS_ITRANSACTION_IID);
#endif
#ifdef NS_ITRANSACTIONLIST_IID
NP_DEF_ID(kTransactionListIID, NS_ITRANSACTIONLIST_IID);
#endif
#ifdef NS_ITRANSACTIONLISTENER_IID
NP_DEF_ID(kTransactionListenerIID, NS_ITRANSACTIONLISTENER_IID);
#endif
#ifdef NS_ITRANSACTIONMANAGER_IID
NP_DEF_ID(kTransactionManagerIID, NS_ITRANSACTIONMANAGER_IID);
#endif
#ifdef NS_ITRANSFERABLE_IID
NP_DEF_ID(kTransferableIID, NS_ITRANSFERABLE_IID);
#endif
#ifdef NS_ITRANSPORT_IID
NP_DEF_ID(kTransportIID, NS_ITRANSPORT_IID);
#endif
#ifdef NS_ITRANSPORTSECURITYINFO_IID
NP_DEF_ID(kTransportSecurityInfoIID, NS_ITRANSPORTSECURITYINFO_IID);
#endif
#ifdef NS_ITREEBOXOBJECT_IID
NP_DEF_ID(kTreeBoxObjectIID, NS_ITREEBOXOBJECT_IID);
#endif
#ifdef NS_ITREECONTENTVIEW_IID
NP_DEF_ID(kTreeContentViewIID, NS_ITREECONTENTVIEW_IID);
#endif
#ifdef NS_ITREESELECTION_IID
NP_DEF_ID(kTreeSelectionIID, NS_ITREESELECTION_IID);
#endif
#ifdef NS_ITREEVIEW_IID
NP_DEF_ID(kTreeViewIID, NS_ITREEVIEW_IID);
#endif
#ifdef NS_ITXTTOHTMLCONV_IID
NP_DEF_ID(kTXTToHTMLConvIID, NS_ITXTTOHTMLCONV_IID);
#endif
#ifdef NS_ITYPEAHEADFIND_IID
NP_DEF_ID(kTypeAheadFindIID, NS_ITYPEAHEADFIND_IID);
#endif
#ifdef NS_IUNICHARSTREAMLOADER_IID
NP_DEF_ID(kUnicharStreamLoaderIID, NS_IUNICHARSTREAMLOADER_IID);
#endif
#ifdef NS_IUNICODENORMALIZER_IID
NP_DEF_ID(kUnicodeNormalizerIID, NS_IUNICODENORMALIZER_IID);
#endif
#ifdef NS_IUPLOADCHANNEL_IID
NP_DEF_ID(kUploadChannelIID, NS_IUPLOADCHANNEL_IID);
#endif
#ifdef NS_IURI_IID
NP_DEF_ID(kURIIID, NS_IURI_IID);
#endif
#ifdef NS_IURICHECKER_IID
NP_DEF_ID(kURICheckerIID, NS_IURICHECKER_IID);
#endif
#ifdef NS_IURICONTENTLISTENER_IID
NP_DEF_ID(kURIContentListenerIID, NS_IURICONTENTLISTENER_IID);
#endif
#ifdef NS_IURIFIXUP_IID
NP_DEF_ID(kURIFixupIID, NS_IURIFIXUP_IID);
#endif
#ifdef NS_IURILOADER_IID
NP_DEF_ID(kURILoaderIID, NS_IURILOADER_IID);
#endif
#ifdef NS_IURIREFOBJECT_IID
NP_DEF_ID(kURIRefObjectIID, NS_IURIREFOBJECT_IID);
#endif
#ifdef NS_IURL_IID
NP_DEF_ID(kURLIID, NS_IURL_IID);
#endif
#ifdef NS_IURLBARHISTORY_IID
NP_DEF_ID(kUrlbarHistoryIID, NS_IURLBARHISTORY_IID);
#endif
#ifdef NS_IURLFETCHER_IID
NP_DEF_ID(kURLFetcherIID, NS_IURLFETCHER_IID);
#endif
#ifdef NS_IURLLISTENER_IID
NP_DEF_ID(kUrlListenerIID, NS_IURLLISTENER_IID);
#endif
#ifdef NS_IURLLISTENERMANAGER_IID
NP_DEF_ID(kUrlListenerManagerIID, NS_IURLLISTENERMANAGER_IID);
#endif
#ifdef NS_IURLPARSER_IID
NP_DEF_ID(kURLParserIID, NS_IURLPARSER_IID);
#endif
#ifdef NS_IUSERCERTPICKER_IID
NP_DEF_ID(kUserCertPickerIID, NS_IUSERCERTPICKER_IID);
#endif
#ifdef NS_IUSERINFO_IID
NP_DEF_ID(kUserInfoIID, NS_IUSERINFO_IID);
#endif
#ifdef NS_IVARIANT_IID
NP_DEF_ID(kVariantIID, NS_IVARIANT_IID);
#endif
#ifdef NS_IVIEWSOURCECHANNEL_IID
NP_DEF_ID(kViewSourceChannelIID, NS_IVIEWSOURCECHANNEL_IID);
#endif
#ifdef NS_IWALLETEDITOR_IID
NP_DEF_ID(kWalletEditorIID, NS_IWALLETEDITOR_IID);
#endif
#ifdef NS_IWALLETPREVIEW_IID
NP_DEF_ID(kWalletPreviewIID, NS_IWALLETPREVIEW_IID);
#endif
#ifdef NS_IWALLETSERVICE_IID
NP_DEF_ID(kWalletServiceIID, NS_IWALLETSERVICE_IID);
#endif
#ifdef NS_IWEAKREFERENCE_IID
NP_DEF_ID(kWeakReferenceIID, NS_IWEAKREFERENCE_IID);
#endif
#ifdef NS_IWEBBROWSER_IID
NP_DEF_ID(kWebBrowserIID, NS_IWEBBROWSER_IID);
#endif
#ifdef NS_IWEBBROWSERCHROME_IID
NP_DEF_ID(kWebBrowserChromeIID, NS_IWEBBROWSERCHROME_IID);
#endif
#ifdef NS_IWEBBROWSERCHROMEFOCUS_IID
NP_DEF_ID(kWebBrowserChromeFocusIID, NS_IWEBBROWSERCHROMEFOCUS_IID);
#endif
#ifdef NS_IWEBBROWSERFIND_IID
NP_DEF_ID(kWebBrowserFindIID, NS_IWEBBROWSERFIND_IID);
#endif
#ifdef NS_IWEBBROWSERFOCUS_IID
NP_DEF_ID(kWebBrowserFocusIID, NS_IWEBBROWSERFOCUS_IID);
#endif
#ifdef NS_IWEBBROWSERPERSIST_IID
NP_DEF_ID(kWebBrowserPersistIID, NS_IWEBBROWSERPERSIST_IID);
#endif
#ifdef NS_IWEBBROWSERPRINT_IID
NP_DEF_ID(kWebBrowserPrintIID, NS_IWEBBROWSERPRINT_IID);
#endif
#ifdef NS_IWEBBROWSERSETUP_IID
NP_DEF_ID(kWebBrowserSetupIID, NS_IWEBBROWSERSETUP_IID);
#endif
#ifdef NS_IWEBNAVIGATION_IID
NP_DEF_ID(kWebNavigationIID, NS_IWEBNAVIGATION_IID);
#endif
#ifdef NS_IWEBPAGEDESCRIPTOR_IID
NP_DEF_ID(kWebPageDescriptorIID, NS_IWEBPAGEDESCRIPTOR_IID);
#endif
#ifdef NS_IWEBPROGRESS_IID
NP_DEF_ID(kWebProgressIID, NS_IWEBPROGRESS_IID);
#endif
#ifdef NS_IWEBPROGRESSLISTENER_IID
NP_DEF_ID(kWebProgressListenerIID, NS_IWEBPROGRESSLISTENER_IID);
#endif
#ifdef NS_IWINDOWCREATOR_IID
NP_DEF_ID(kWindowCreatorIID, NS_IWINDOWCREATOR_IID);
#endif
#ifdef NS_IWINDOWCREATOR2_IID
NP_DEF_ID(kWindowCreator2IID, NS_IWINDOWCREATOR2_IID);
#endif
#ifdef NS_IWINDOWDATASOURCE_IID
NP_DEF_ID(kWindowDataSourceIID, NS_IWINDOWDATASOURCE_IID);
#endif
#ifdef NS_IWINDOWLESSPLUGINSTPEER_IID
NP_DEF_ID(kWindowlessPlugInstPeerIID, NS_IWINDOWLESSPLUGINSTPEER_IID);
#endif
#ifdef NS_IWINDOWMEDIATOR_IID
NP_DEF_ID(kWindowMediatorIID, NS_IWINDOWMEDIATOR_IID);
#endif
#ifdef NS_IWINDOWMEDIATORLISTENER_IID
NP_DEF_ID(kWindowMediatorListenerIID, NS_IWINDOWMEDIATORLISTENER_IID);
#endif
#ifdef NS_IWINDOWWATCHER_IID
NP_DEF_ID(kWindowWatcherIID, NS_IWINDOWWATCHER_IID);
#endif
#ifdef NS_IWYCIWYGCHANNEL_IID
NP_DEF_ID(kWyciwygChannelIID, NS_IWYCIWYGCHANNEL_IID);
#endif
#ifdef NS_IX509CERT_IID
NP_DEF_ID(kX509CertIID, NS_IX509CERT_IID);
#endif
#ifdef NS_IX509CERTDB_IID
NP_DEF_ID(kX509CertDBIID, NS_IX509CERTDB_IID);
#endif
#ifdef NS_IX509CERTVALIDITY_IID
NP_DEF_ID(kX509CertValidityIID, NS_IX509CERTVALIDITY_IID);
#endif
#ifdef NS_IXMLHTTPREQUEST_IID
NP_DEF_ID(kXMLHttpRequestIID, NS_IXMLHTTPREQUEST_IID);
#endif
#ifdef NS_IXMLRPCCLIENT_IID
NP_DEF_ID(kXmlRpcClientIID, NS_IXMLRPCCLIENT_IID);
#endif
#ifdef NS_IXMLRPCCLIENTLISTENER_IID
NP_DEF_ID(kXmlRpcClientListenerIID, NS_IXMLRPCCLIENTLISTENER_IID);
#endif
#ifdef NS_IXPCONNECT_IID
NP_DEF_ID(kXPConnectIID, NS_IXPCONNECT_IID);
#endif
#ifdef NS_IXPCSCRIPTABLE_IID
NP_DEF_ID(kXPCScriptableIID, NS_IXPCSCRIPTABLE_IID);
#endif
#ifdef NS_IXPCSCRIPTNOTIFY_IID
NP_DEF_ID(kXPCScriptNotifyIID, NS_IXPCSCRIPTNOTIFY_IID);
#endif
#ifdef NS_IXPCSECURITYMANAGER_IID
NP_DEF_ID(kXPCSecurityManagerIID, NS_IXPCSECURITYMANAGER_IID);
#endif
#ifdef NS_IXPIDIALOGSERVICE_IID
NP_DEF_ID(kXPIDialogServiceIID, NS_IXPIDIALOGSERVICE_IID);
#endif
#ifdef NS_IXPINOTIFIER_IID
NP_DEF_ID(kXPINotifierIID, NS_IXPINOTIFIER_IID);
#endif
#ifdef NS_IXPIPROGRESSDIALOG_IID
NP_DEF_ID(kXPIProgressDialogIID, NS_IXPIPROGRESSDIALOG_IID);
#endif
#ifdef NS_IXPTLOADER_IID
NP_DEF_ID(kXPTLoaderIID, NS_IXPTLOADER_IID);
#endif
#ifdef NS_IXREMOTECLIENT_IID
NP_DEF_ID(kXRemoteClientIID, NS_IXREMOTECLIENT_IID);
#endif
#ifdef NS_IXSLTEXCEPTION_IID
NP_DEF_ID(kXSLTExceptionIID, NS_IXSLTEXCEPTION_IID);
#endif
#ifdef NS_IXSLTPROCESSOR_IID
NP_DEF_ID(kXSLTProcessorIID, NS_IXSLTPROCESSOR_IID);
#endif
#ifdef NS_IXSLTPROCESSOROBSOLETE_IID
NP_DEF_ID(kXSLTProcessorObsoleteIID, NS_IXSLTPROCESSOROBSOLETE_IID);
#endif
#ifdef NS_IXULBROWSERWINDOW_IID
NP_DEF_ID(kXULBrowserWindowIID, NS_IXULBROWSERWINDOW_IID);
#endif
#ifdef NS_IXULSORTSERVICE_IID
NP_DEF_ID(kXULSortServiceIID, NS_IXULSORTSERVICE_IID);
#endif
#ifdef NS_IXULTEMPLATEBUILDER_IID
NP_DEF_ID(kXULTemplateBuilderIID, NS_IXULTEMPLATEBUILDER_IID);
#endif
#ifdef NS_IXULWINDOW_IID
NP_DEF_ID(kXULWindowIID, NS_IXULWINDOW_IID);
#endif
#ifdef NS_IZIPREADER_IID
NP_DEF_ID(kZipReaderIID, NS_IZIPREADER_IID);
#endif
#ifdef NS_IJRIPLUGIN_IID
NP_DEF_ID(kJRIPluginIID, NS_IJRIPLUGIN_IID);
#endif
#ifdef NS_IJVMCONSOLE_IID
NP_DEF_ID(kJVMConsoleIID, NS_IJVMCONSOLE_IID);
#endif
#ifdef NS_IJVMMANAGER_IID
NP_DEF_ID(kJVMManagerIID, NS_IJVMMANAGER_IID);
#endif
#ifdef NS_IJVMPLUGIN_IID
NP_DEF_ID(kJVMPluginIID, NS_IJVMPLUGIN_IID);
#endif
#ifdef NS_IJVMPLUGININSTANCE_IID
NP_DEF_ID(kJVMPluginInstanceIID, NS_IJVMPLUGININSTANCE_IID);
#endif
#ifdef NS_IJVMPLUGINTAGINFO_IID
NP_DEF_ID(kJVMPluginTagInfoIID, NS_IJVMPLUGINTAGINFO_IID);
#endif
#ifdef NS_IJVMPREFSWINDOW_IID
NP_DEF_ID(kJVMPrefsWindowIID, NS_IJVMPREFSWINDOW_IID);
#endif
#ifdef NS_IJVMWINDOW_IID
NP_DEF_ID(kJVMWindowIID, NS_IJVMWINDOW_IID);
#endif
#ifdef NS_ILIVECONNECTMANAGER_IID
NP_DEF_ID(kLiveConnectManagerIID, NS_ILIVECONNECTMANAGER_IID);
#endif
#ifdef NS_ISECUREENV_IID
NP_DEF_ID(kSecureEnvIID, NS_ISECUREENV_IID);
#endif
#ifdef NS_ISYMANTECDEBUGGER_IID
NP_DEF_ID(kSymantecDebuggerIID, NS_ISYMANTECDEBUGGER_IID);
#endif
#ifdef NS_ISYMANTECDEBUGMANAGER_IID
NP_DEF_ID(kSymantecDebugManagerIID, NS_ISYMANTECDEBUGMANAGER_IID);
#endif
#ifdef NS_IREADMANAGER_IID
NP_DEF_ID(kreadManagerIID, NS_IREADMANAGER_IID);
#endif
#ifdef NS_JVM_IID
NP_DEF_ID(kjvmIID, NS_JVM_IID);
#endif
#ifdef NS_JVMMANAGER_IID
NP_DEF_ID(kJVMManagerIID, NS_JVMMANAGER_IID);
#endif
#ifdef NS_JVMMANAGER_CID
NP_DEF_ID(kJVMManagerCID, NS_JVMMANAGER_CID);
#endif
#ifdef NS_JVMPLUGINTAGINFO_IID
NP_DEF_ID(kJVMPluginTagInfoIID, NS_JVMPLUGINTAGINFO_IID);
#endif
#ifdef NS_ILIVECONNECT_IID
NP_DEF_ID(kLiveconnectIID, NS_ILIVECONNECT_IID);
#endif
#ifdef NS_ISECURELIVECONNECT_IID
NP_DEF_ID(kSecureLiveconnectIID, NS_ISECURELIVECONNECT_IID);
#endif
#ifdef NS_ISECURITYCONTEXT_IID
NP_DEF_ID(kSecurityContextIID, NS_ISECURITYCONTEXT_IID);
#endif
#ifdef NS_ISHUTDOWNLISTENER_IID
NP_DEF_ID(kShutdownListenerIID, NS_ISHUTDOWNLISTENER_IID);
#endif
#ifdef NS_ISERVICEMANAGER_OBSOLETE_IID
NP_DEF_ID(kServiceManagerObsoleteIID, NS_ISERVICEMANAGER_OBSOLETE_IID);
#endif
#ifdef NS_IJVMTHREADMANAGER_IID
NP_DEF_ID(kJVMThreadManagerIID, NS_IJVMTHREADMANAGER_IID);
#endif
#ifdef FLASH_IOBJECT7_IID
NP_DEF_ID(kFlashIObject7IID, FLASH_IOBJECT7_IID);
#endif
#ifdef FLASH_ISCRIPTABLEPLUGIN7_IID
NP_DEF_ID(kFlashIScriptablePlugin7IID, FLASH_ISCRIPTABLEPLUGIN7_IID);
#endif
#ifdef NS_IFLASH5_IID
NP_DEF_ID(kFlash5IID, NS_IFLASH5_IID);
#endif



#ifdef NP_INCL_LOOKUP
/**
 * Lookup list for IIDs and CIDs to get an understandable name.
 */
static struct nsIDNameLookupEntry
{
    const nsID *    pID;
    const char *    pszName;
}   aIDNameLookup[] =
{
#ifdef NS_CDEFAULTURIFIXUP_IID
    { &kCDefaultURIFixupIID, "NS_CDEFAULTURIFIXUP_IID" },
#endif
#ifdef NS_CDOCSHELL_IID
    { &kCDocShellIID, "NS_CDOCSHELL_IID" },
#endif
#ifdef NS_CEXTERNALHANDLERSERVICE_IID
    { &kCExternalHandlerServiceIID, "NS_CEXTERNALHANDLERSERVICE_IID" },
#endif
#ifdef NS_CURILOADER_IID
    { &kCURILoaderIID, "NS_CURILOADER_IID" },
#endif
#ifdef NS_CWEBBROWSER_IID
    { &kCWebBrowserIID, "NS_CWEBBROWSER_IID" },
#endif
#ifdef NS_CWEBBROWSERPERSIST_IID
    { &kCWebBrowserPersistIID, "NS_CWEBBROWSERPERSIST_IID" },
#endif
#ifdef NS_IABADDRESSCOLLECTER_IID
    { &kAbAddressCollecterIID, "NS_IABADDRESSCOLLECTER_IID" },
#endif
#ifdef NS_IABAUTOCOMPLETESESSION_IID
    { &kAbAutoCompleteSessionIID, "NS_IABAUTOCOMPLETESESSION_IID" },
#endif
#ifdef NS_IABBASE_IID
    { &kAbBaseIID, "NS_IABBASE_IID" },
#endif
#ifdef NS_IABBOOLEANEXPRESSION_IID
    { &kAbBooleanExpressionIID, "NS_IABBOOLEANEXPRESSION_IID" },
#endif
#ifdef NS_IABCARD_IID
    { &kAbCardIID, "NS_IABCARD_IID" },
#endif
#ifdef NS_IABDIRECTORY_IID
    { &kAbDirectoryIID, "NS_IABDIRECTORY_IID" },
#endif
#ifdef NS_IABDIRECTORYQUERY_IID
    { &kAbDirectoryQueryIID, "NS_IABDIRECTORYQUERY_IID" },
#endif
#ifdef NS_IABDIRECTORYQUERYPROXY_IID
    { &kAbDirectoryQueryProxyIID, "NS_IABDIRECTORYQUERYPROXY_IID" },
#endif
#ifdef NS_IABDIRECTORYSEARCH_IID
    { &kAbDirectorySearchIID, "NS_IABDIRECTORYSEARCH_IID" },
#endif
#ifdef NS_IABDIRFACTORY_IID
    { &kAbDirFactoryIID, "NS_IABDIRFACTORY_IID" },
#endif
#ifdef NS_IABDIRFACTORYSERVICE_IID
    { &kAbDirFactoryServiceIID, "NS_IABDIRFACTORYSERVICE_IID" },
#endif
#ifdef NS_IABLDAPAUTOCOMPFORMATTER_IID
    { &kAbLDAPAutoCompFormatterIID, "NS_IABLDAPAUTOCOMPFORMATTER_IID" },
#endif
#ifdef NS_IABLDAPREPLICATIONDATA_IID
    { &kAbLDAPReplicationDataIID, "NS_IABLDAPREPLICATIONDATA_IID" },
#endif
#ifdef NS_IABLDAPREPLICATIONQUERY_IID
    { &kAbLDAPReplicationQueryIID, "NS_IABLDAPREPLICATIONQUERY_IID" },
#endif
#ifdef NS_IABLDAPREPLICATIONSERVICE_IID
    { &kAbLDAPReplicationServiceIID, "NS_IABLDAPREPLICATIONSERVICE_IID" },
#endif
#ifdef NS_IABLISTENER_IID
    { &kAbListenerIID, "NS_IABLISTENER_IID" },
#endif
#ifdef NS_IABMDBCARD_IID
    { &kAbMDBCardIID, "NS_IABMDBCARD_IID" },
#endif
#ifdef NS_IABMDBDIRECTORY_IID
    { &kAbMDBDirectoryIID, "NS_IABMDBDIRECTORY_IID" },
#endif
#ifdef NS_IABOUTMODULE_IID
    { &kAboutModuleIID, "NS_IABOUTMODULE_IID" },
#endif
#ifdef NS_IABUPGRADER_IID
    { &kAbUpgraderIID, "NS_IABUPGRADER_IID" },
#endif
#ifdef NS_IABVIEW_IID
    { &kAbViewIID, "NS_IABVIEW_IID" },
#endif
#ifdef NS_IACCESSIBILITYSERVICE_IID
    { &kAccessibilityServiceIID, "NS_IACCESSIBILITYSERVICE_IID" },
#endif
#ifdef NS_IACCESSIBLE_IID
    { &kAccessibleIID, "NS_IACCESSIBLE_IID" },
#endif
#ifdef NS_IACCESSIBLEACTION_IID
    { &kAccessibleActionIID, "NS_IACCESSIBLEACTION_IID" },
#endif
#ifdef NS_IACCESSIBLECARET_IID
    { &kAccessibleCaretIID, "NS_IACCESSIBLECARET_IID" },
#endif
#ifdef NS_IACCESSIBLEDOCUMENT_IID
    { &kAccessibleDocumentIID, "NS_IACCESSIBLEDOCUMENT_IID" },
#endif
#ifdef NS_IACCESSIBLEEDITABLETEXT_IID
    { &kAccessibleEditableTextIID, "NS_IACCESSIBLEEDITABLETEXT_IID" },
#endif
#ifdef NS_IACCESSIBLEEVENTLISTENER_IID
    { &kAccessibleEventListenerIID, "NS_IACCESSIBLEEVENTLISTENER_IID" },
#endif
#ifdef NS_IACCESSIBLEEVENTRECEIVER_IID
    { &kAccessibleEventReceiverIID, "NS_IACCESSIBLEEVENTRECEIVER_IID" },
#endif
#ifdef NS_IACCESSIBLEHYPERLINK_IID
    { &kAccessibleHyperLinkIID, "NS_IACCESSIBLEHYPERLINK_IID" },
#endif
#ifdef NS_IACCESSIBLEHYPERTEXT_IID
    { &kAccessibleHyperTextIID, "NS_IACCESSIBLEHYPERTEXT_IID" },
#endif
#ifdef NS_IACCESSIBLEPROVIDER_IID
    { &kAccessibleProviderIID, "NS_IACCESSIBLEPROVIDER_IID" },
#endif
#ifdef NS_IACCESSIBLESELECTABLE_IID
    { &kAccessibleSelectableIID, "NS_IACCESSIBLESELECTABLE_IID" },
#endif
#ifdef NS_IACCESSIBLETABLE_IID
    { &kAccessibleTableIID, "NS_IACCESSIBLETABLE_IID" },
#endif
#ifdef NS_IACCESSIBLETEXT_IID
    { &kAccessibleTextIID, "NS_IACCESSIBLETEXT_IID" },
#endif
#ifdef NS_IACCESSIBLEVALUE_IID
    { &kAccessibleValueIID, "NS_IACCESSIBLEVALUE_IID" },
#endif
#ifdef NS_IACCESSIBLEWIN32OBJECT_IID
    { &kAccessibleWin32ObjectIID, "NS_IACCESSIBLEWIN32OBJECT_IID" },
#endif
#ifdef NS_IADDBOOKURL_IID
    { &kAddbookUrlIID, "NS_IADDBOOKURL_IID" },
#endif
#ifdef NS_IADDRBOOKSESSION_IID
    { &kAddrBookSessionIID, "NS_IADDRBOOKSESSION_IID" },
#endif
#ifdef NS_IADDRDATABASE_IID
    { &kAddrDatabaseIID, "NS_IADDRDATABASE_IID" },
#endif
#ifdef NS_IADDRDBANNOUNCER_IID
    { &kAddrDBAnnouncerIID, "NS_IADDRDBANNOUNCER_IID" },
#endif
#ifdef NS_IADDRDBLISTENER_IID
    { &kAddrDBListenerIID, "NS_IADDRDBLISTENER_IID" },
#endif
#ifdef NS_IADDRESSBOOK_IID
    { &kAddressBookIID, "NS_IADDRESSBOOK_IID" },
#endif
#ifdef NS_IAGGREGATEPRINCIPAL_IID
    { &kAggregatePrincipalIID, "NS_IAGGREGATEPRINCIPAL_IID" },
#endif
#ifdef NS_IAPPSHELL_IID
    { &kAppShellIID, "NS_IAPPSHELL_IID" },
#endif
#ifdef NS_IAPPSHELLSERVICE_IID
    { &kAppShellServiceIID, "NS_IAPPSHELLSERVICE_IID" },
#endif
#ifdef NS_IARRAY_IID
    { &kArrayIID, "NS_IARRAY_IID" },
#endif
#ifdef NS_IASN1OBJECT_IID
    { &kASN1ObjectIID, "NS_IASN1OBJECT_IID" },
#endif
#ifdef NS_IASN1PRINTABLEITEM_IID
    { &kASN1PrintableItemIID, "NS_IASN1PRINTABLEITEM_IID" },
#endif
#ifdef NS_IASN1SEQUENCE_IID
    { &kASN1SequenceIID, "NS_IASN1SEQUENCE_IID" },
#endif
#ifdef NS_IASN1TREE_IID
    { &kASN1TreeIID, "NS_IASN1TREE_IID" },
#endif
#ifdef NS_IASYNCINPUTSTREAM_IID
    { &kAsyncInputStreamIID, "NS_IASYNCINPUTSTREAM_IID" },
#endif
#ifdef NS_IASYNCOUTPUTSTREAM_IID
    { &kAsyncOutputStreamIID, "NS_IASYNCOUTPUTSTREAM_IID" },
#endif
#ifdef NS_IASYNCSTREAMCOPIER_IID
    { &kAsyncStreamCopierIID, "NS_IASYNCSTREAMCOPIER_IID" },
#endif
#ifdef NS_IATOM_IID
    { &kAtomIID, "NS_IATOM_IID" },
#endif
#ifdef NS_IATOMSERVICE_IID
    { &kAtomServiceIID, "NS_IATOMSERVICE_IID" },
#endif
#ifdef NS_IAUTHPROMPT_IID
    { &kAuthPromptIID, "NS_IAUTHPROMPT_IID" },
#endif
#ifdef NS_IAUTHPROMPTWRAPPER_IID
    { &kAuthPromptWrapperIID, "NS_IAUTHPROMPTWRAPPER_IID" },
#endif
#ifdef NS_IAUTOCOMPLETELISTENER_IID
    { &kAutoCompleteListenerIID, "NS_IAUTOCOMPLETELISTENER_IID" },
#endif
#ifdef NS_IAUTOCOMPLETERESULTS_IID
    { &kAutoCompleteResultsIID, "NS_IAUTOCOMPLETERESULTS_IID" },
#endif
#ifdef NS_IAUTOCOMPLETESESSION_IID
    { &kAutoCompleteSessionIID, "NS_IAUTOCOMPLETESESSION_IID" },
#endif
#ifdef NS_IAUTOCONFIG_IID
    { &kAutoConfigIID, "NS_IAUTOCONFIG_IID" },
#endif
#ifdef NS_IBADCERTLISTENER_IID
    { &kBadCertListenerIID, "NS_IBADCERTLISTENER_IID" },
#endif
#ifdef NS_IBASEWINDOW_IID
    { &kBaseWindowIID, "NS_IBASEWINDOW_IID" },
#endif
#ifdef NS_IBIDIKEYBOARD_IID
    { &kBidiKeyboardIID, "NS_IBIDIKEYBOARD_IID" },
#endif
#ifdef NS_IBINARYINPUTSTREAM_IID
    { &kBinaryInputStreamIID, "NS_IBINARYINPUTSTREAM_IID" },
#endif
#ifdef NS_IBINARYOUTPUTSTREAM_IID
    { &kBinaryOutputStreamIID, "NS_IBINARYOUTPUTSTREAM_IID" },
#endif
#ifdef NS_IBOOKMARKSSERVICE_IID
    { &kBookmarksServiceIID, "NS_IBOOKMARKSSERVICE_IID" },
#endif
#ifdef NS_IBOXLAYOUTMANAGER_IID
    { &kBoxLayoutManagerIID, "NS_IBOXLAYOUTMANAGER_IID" },
#endif
#ifdef NS_IBOXOBJECT_IID
    { &kBoxObjectIID, "NS_IBOXOBJECT_IID" },
#endif
#ifdef NS_IBOXPAINTMANAGER_IID
    { &kBoxPaintManagerIID, "NS_IBOXPAINTMANAGER_IID" },
#endif
#ifdef NS_IBROWSERBOXOBJECT_IID
    { &kBrowserBoxObjectIID, "NS_IBROWSERBOXOBJECT_IID" },
#endif
#ifdef NS_IBROWSERHISTORY_IID
    { &kBrowserHistoryIID, "NS_IBROWSERHISTORY_IID" },
#endif
#ifdef NS_IBROWSERINSTANCE_IID
    { &kBrowserInstanceIID, "NS_IBROWSERINSTANCE_IID" },
#endif
#ifdef NS_IBUFENTROPYCOLLECTOR_IID
    { &kBufEntropyCollectorIID, "NS_IBUFENTROPYCOLLECTOR_IID" },
#endif
#ifdef NS_IBUFFEREDSTREAMS_IID
    { &kBufferedStreamsIID, "NS_IBUFFEREDSTREAMS_IID" },
#endif
#ifdef NS_IBYTEARRAYINPUTSTREAM_IID
    { &kByteArrayInputStreamIID, "NS_IBYTEARRAYINPUTSTREAM_IID" },
#endif
#ifdef NS_IBYTERANGEREQUEST_IID
    { &kByteRangeRequestIID, "NS_IBYTERANGEREQUEST_IID" },
#endif
#ifdef NS_ICACHE_IID
    { &kCacheIID, "NS_ICACHE_IID" },
#endif
#ifdef NS_ICACHEENTRYDESCRIPTOR_IID
    { &kCacheEntryDescriptorIID, "NS_ICACHEENTRYDESCRIPTOR_IID" },
#endif
#ifdef NS_ICACHELISTENER_IID
    { &kCacheListenerIID, "NS_ICACHELISTENER_IID" },
#endif
#ifdef NS_ICACHESERVICE_IID
    { &kCacheServiceIID, "NS_ICACHESERVICE_IID" },
#endif
#ifdef NS_ICACHESESSION_IID
    { &kCacheSessionIID, "NS_ICACHESESSION_IID" },
#endif
#ifdef NS_ICACHEVISITOR_IID
    { &kCacheVisitorIID, "NS_ICACHEVISITOR_IID" },
#endif
#ifdef NS_ICACHINGCHANNEL_IID
    { &kCachingChannelIID, "NS_ICACHINGCHANNEL_IID" },
#endif
#ifdef NS_ICATEGORYMANAGER_IID
    { &kCategoryManagerIID, "NS_ICATEGORYMANAGER_IID" },
#endif
#ifdef NS_ICERTIFICATEDIALOGS_IID
    { &kCertificateDialogsIID, "NS_ICERTIFICATEDIALOGS_IID" },
#endif
#ifdef NS_ICERTIFICATEPRINCIPAL_IID
    { &kCertificatePrincipalIID, "NS_ICERTIFICATEPRINCIPAL_IID" },
#endif
#ifdef NS_ICERTPICKDIALOGS_IID
    { &kCertPickDialogsIID, "NS_ICERTPICKDIALOGS_IID" },
#endif
#ifdef NS_ICERTSELECT_IID
    { &kCertSelectIID, "NS_ICERTSELECT_IID" },
#endif
#ifdef NS_ICERTTREE_IID
    { &kCertTreeIID, "NS_ICERTTREE_IID" },
#endif
#ifdef NS_ICHANNEL_IID
    { &kChannelIID, "NS_ICHANNEL_IID" },
#endif
#ifdef NS_ICHARSETCONVERTERMANAGER2_IID
    { &kCharsetConverterManager2IID, "NS_ICHARSETCONVERTERMANAGER2_IID" },
#endif
#ifdef NS_ICHROMEEVENTHANDLER_IID
    { &kChromeEventHandlerIID, "NS_ICHROMEEVENTHANDLER_IID" },
#endif
#ifdef NS_ICHROMEREGISTRY_IID
    { &kChromeRegistryIID, "NS_ICHROMEREGISTRY_IID" },
#endif
#ifdef NS_ICIPHERINFO_IID
    { &kCipherInfoIID, "NS_ICIPHERINFO_IID" },
#endif
#ifdef NS_ICITER_IID
    { &kCiterIID, "NS_ICITER_IID" },
#endif
#ifdef NS_ICLASSICPLUGINFACTORY_IID
    { &kClassicPluginFactoryIID, "NS_ICLASSICPLUGINFACTORY_IID" },
#endif
#ifdef NS_ICLASSINFO_IID
    { &kClassInfoIID, "NS_ICLASSINFO_IID" },
#endif
#ifdef NS_ICLIENTAUTHDIALOGS_IID
    { &kClientAuthDialogsIID, "NS_ICLIENTAUTHDIALOGS_IID" },
#endif
#ifdef NS_ICLIPBOARD_IID
    { &kClipboardIID, "NS_ICLIPBOARD_IID" },
#endif
#ifdef NS_ICLIPBOARDCOMMANDS_IID
    { &kClipboardCommandsIID, "NS_ICLIPBOARDCOMMANDS_IID" },
#endif
#ifdef NS_ICLIPBOARDHELPER_IID
    { &kClipboardHelperIID, "NS_ICLIPBOARDHELPER_IID" },
#endif
#ifdef NS_ICLIPBOARDOWNER_IID
    { &kClipboardOwnerIID, "NS_ICLIPBOARDOWNER_IID" },
#endif
#ifdef NS_ICLOSEALLWINDOWS_IID
    { &kCloseAllWindowsIID, "NS_ICLOSEALLWINDOWS_IID" },
#endif
#ifdef NS_ICMDLINEHANDLER_IID
    { &kCmdLineHandlerIID, "NS_ICMDLINEHANDLER_IID" },
#endif
#ifdef NS_ICMDLINESERVICE_IID
    { &kCmdLineServiceIID, "NS_ICMDLINESERVICE_IID" },
#endif
#ifdef NS_ICMSDECODER_IID
    { &kCMSDecoderIID, "NS_ICMSDECODER_IID" },
#endif
#ifdef NS_ICMSENCODER_IID
    { &kCMSEncoderIID, "NS_ICMSENCODER_IID" },
#endif
#ifdef NS_ICMSMESSAGE_IID
    { &kCMSMessageIID, "NS_ICMSMESSAGE_IID" },
#endif
#ifdef NS_ICMSMESSAGEERRORS_IID
    { &kCMSMessageErrorsIID, "NS_ICMSMESSAGEERRORS_IID" },
#endif
#ifdef NS_ICMSSECUREMESSAGE_IID
    { &kCMSSecureMessageIID, "NS_ICMSSECUREMESSAGE_IID" },
#endif
#ifdef NS_ICODEBASEPRINCIPAL_IID
    { &kCodebasePrincipalIID, "NS_ICODEBASEPRINCIPAL_IID" },
#endif
#ifdef NS_ICOLLECTION_IID
    { &kCollectionIID, "NS_ICOLLECTION_IID" },
#endif
#ifdef NS_ICOMM4XPROFILE_IID
    { &kComm4xProfileIID, "NS_ICOMM4XPROFILE_IID" },
#endif
#ifdef NS_ICOMMANDHANDLER_IID
    { &kCommandHandlerIID, "NS_ICOMMANDHANDLER_IID" },
#endif
#ifdef NS_ICOMMANDMANAGER_IID
    { &kCommandManagerIID, "NS_ICOMMANDMANAGER_IID" },
#endif
#ifdef NS_ICOMMANDPARAMS_IID
    { &kCommandParamsIID, "NS_ICOMMANDPARAMS_IID" },
#endif
#ifdef NS_ICOMPONENTLOADER_IID
    { &kComponentLoaderIID, "NS_ICOMPONENTLOADER_IID" },
#endif
#ifdef NS_ICOMPONENTLOADERMANAGER_IID
    { &kComponentLoaderManagerIID, "NS_ICOMPONENTLOADERMANAGER_IID" },
#endif
#ifdef NS_ICOMPONENTMANAGER_IID
    { &kComponentManagerIID, "NS_ICOMPONENTMANAGER_IID" },
#endif
#ifdef NS_ICOMPONENTMANAGEROBSOLETE_IID
    { &kComponentManagerObsoleteIID, "NS_ICOMPONENTMANAGEROBSOLETE_IID" },
#endif
#ifdef NS_ICOMPONENTREGISTRAR_IID
    { &kComponentRegistrarIID, "NS_ICOMPONENTREGISTRAR_IID" },
#endif
#ifdef NS_ICONSOLELISTENER_IID
    { &kConsoleListenerIID, "NS_ICONSOLELISTENER_IID" },
#endif
#ifdef NS_ICONSOLEMESSAGE_IID
    { &kConsoleMessageIID, "NS_ICONSOLEMESSAGE_IID" },
#endif
#ifdef NS_ICONSOLESERVICE_IID
    { &kConsoleServiceIID, "NS_ICONSOLESERVICE_IID" },
#endif
#ifdef NS_ICONTENTHANDLER_IID
    { &kContentHandlerIID, "NS_ICONTENTHANDLER_IID" },
#endif
#ifdef NS_ICONTENTPOLICY_IID
    { &kContentPolicyIID, "NS_ICONTENTPOLICY_IID" },
#endif
#ifdef NS_ICONTENTVIEWER_IID
    { &kContentViewerIID, "NS_ICONTENTVIEWER_IID" },
#endif
#ifdef NS_ICONTENTVIEWERCONTAINER_IID
    { &kContentViewerContainerIID, "NS_ICONTENTVIEWERCONTAINER_IID" },
#endif
#ifdef NS_ICONTENTVIEWEREDIT_IID
    { &kContentViewerEditIID, "NS_ICONTENTVIEWEREDIT_IID" },
#endif
#ifdef NS_ICONTENTVIEWERFILE_IID
    { &kContentViewerFileIID, "NS_ICONTENTVIEWERFILE_IID" },
#endif
#ifdef NS_ICONTEXTMENULISTENER_IID
    { &kContextMenuListenerIID, "NS_ICONTEXTMENULISTENER_IID" },
#endif
#ifdef NS_ICONTEXTMENULISTENER2_IID
    { &kContextMenuListener2IID, "NS_ICONTEXTMENULISTENER2_IID" },
#endif
#ifdef NS_ICONTROLLER_IID
    { &kControllerIID, "NS_ICONTROLLER_IID" },
#endif
#ifdef NS_ICONTROLLERCOMMAND_IID
    { &kControllerCommandIID, "NS_ICONTROLLERCOMMAND_IID" },
#endif
#ifdef NS_ICONTROLLERCOMMANDMANAGER_IID
    { &kControllerCommandManagerIID, "NS_ICONTROLLERCOMMANDMANAGER_IID" },
#endif
#ifdef NS_ICONTROLLERCONTEXT_IID
    { &kControllerContextIID, "NS_ICONTROLLERCONTEXT_IID" },
#endif
#ifdef NS_ICONTROLLERS_IID
    { &kControllersIID, "NS_ICONTROLLERS_IID" },
#endif
#ifdef NS_ICOOKIE_IID
    { &kCookieIID, "NS_ICOOKIE_IID" },
#endif
#ifdef NS_ICOOKIEACCEPTDIALOG_IID
    { &kCookieAcceptDialogIID, "NS_ICOOKIEACCEPTDIALOG_IID" },
#endif
#ifdef NS_ICOOKIECONSENT_IID
    { &kCookieConsentIID, "NS_ICOOKIECONSENT_IID" },
#endif
#ifdef NS_ICOOKIEMANAGER_IID
    { &kCookieManagerIID, "NS_ICOOKIEMANAGER_IID" },
#endif
#ifdef NS_ICOOKIEMANAGER2_IID
    { &kCookieManager2IID, "NS_ICOOKIEMANAGER2_IID" },
#endif
#ifdef NS_ICOOKIEPROMPTSERVICE_IID
    { &kCookiePromptServiceIID, "NS_ICOOKIEPROMPTSERVICE_IID" },
#endif
#ifdef NS_ICOOKIESERVICE_IID
    { &kCookieServiceIID, "NS_ICOOKIESERVICE_IID" },
#endif
#ifdef NS_ICOOKIESTORAGE_IID
    { &kCookieStorageIID, "NS_ICOOKIESTORAGE_IID" },
#endif
#ifdef NS_ICOPYMESSAGELISTENER_IID
    { &kCopyMessageListenerIID, "NS_ICOPYMESSAGELISTENER_IID" },
#endif
#ifdef NS_ICOPYMSGSTREAMLISTENER_IID
    { &kCopyMsgStreamListenerIID, "NS_ICOPYMSGSTREAMLISTENER_IID" },
#endif
#ifdef NS_ICRLINFO_IID
    { &kCRLInfoIID, "NS_ICRLINFO_IID" },
#endif
#ifdef NS_ICRLMANAGER_IID
    { &kCRLManagerIID, "NS_ICRLMANAGER_IID" },
#endif
#ifdef NS_ICURRENTCHARSETLISTENER_IID
    { &kCurrentCharsetListenerIID, "NS_ICURRENTCHARSETLISTENER_IID" },
#endif
#ifdef NS_IDATACHANNEL_IID
    { &kDataChannelIID, "NS_IDATACHANNEL_IID" },
#endif
#ifdef NS_IDBCHANGEANNOUNCER_IID
    { &kDBChangeAnnouncerIID, "NS_IDBCHANGEANNOUNCER_IID" },
#endif
#ifdef NS_IDBCHANGELISTENER_IID
    { &kDBChangeListenerIID, "NS_IDBCHANGELISTENER_IID" },
#endif
#ifdef NS_IDBFOLDERINFO_IID
    { &kDBFolderInfoIID, "NS_IDBFOLDERINFO_IID" },
#endif
#ifdef NS_IDIALOGPARAMBLOCK_IID
    { &kDialogParamBlockIID, "NS_IDIALOGPARAMBLOCK_IID" },
#endif
#ifdef NS_IDICTIONARY_IID
    { &kDictionaryIID, "NS_IDICTIONARY_IID" },
#endif
#ifdef NS_IDIRECTORYLISTING_IID
    { &kDirectoryListingIID, "NS_IDIRECTORYLISTING_IID" },
#endif
#ifdef NS_IDIRECTORYSERVICE_IID
    { &kDirectoryServiceIID, "NS_IDIRECTORYSERVICE_IID" },
#endif
#ifdef NS_IDIRINDEX_IID
    { &kDirIndexIID, "NS_IDIRINDEX_IID" },
#endif
#ifdef NS_IDIRINDEXLISTENER_IID
    { &kDirIndexListenerIID, "NS_IDIRINDEXLISTENER_IID" },
#endif
#ifdef NS_IDNSLISTENER_IID
    { &kDNSListenerIID, "NS_IDNSLISTENER_IID" },
#endif
#ifdef NS_IDNSSERVICE_IID
    { &kDNSServiceIID, "NS_IDNSSERVICE_IID" },
#endif
#ifdef NS_IDOCCHARSET_IID
    { &kDocCharsetIID, "NS_IDOCCHARSET_IID" },
#endif
#ifdef NS_IDOCSHELL_IID
    { &kDocShellIID, "NS_IDOCSHELL_IID" },
#endif
#ifdef NS_IDOCSHELLHISTORY_IID
    { &kDocShellHistoryIID, "NS_IDOCSHELLHISTORY_IID" },
#endif
#ifdef NS_IDOCSHELLLOADINFO_IID
    { &kDocShellLoadInfoIID, "NS_IDOCSHELLLOADINFO_IID" },
#endif
#ifdef NS_IDOCSHELLTREEITEM_IID
    { &kDocShellTreeItemIID, "NS_IDOCSHELLTREEITEM_IID" },
#endif
#ifdef NS_IDOCSHELLTREENODE_IID
    { &kDocShellTreeNodeIID, "NS_IDOCSHELLTREENODE_IID" },
#endif
#ifdef NS_IDOCSHELLTREEOWNER_IID
    { &kDocShellTreeOwnerIID, "NS_IDOCSHELLTREEOWNER_IID" },
#endif
#ifdef NS_IDOCUMENTCHARSETINFO_IID
    { &kDocumentCharsetInfoIID, "NS_IDOCUMENTCHARSETINFO_IID" },
#endif
#ifdef NS_IDOCUMENTLOADER_IID
    { &kDocumentLoaderIID, "NS_IDOCUMENTLOADER_IID" },
#endif
#ifdef NS_IDOCUMENTLOADERFACTORY_IID
    { &kDocumentLoaderFactoryIID, "NS_IDOCUMENTLOADERFACTORY_IID" },
#endif
#ifdef NS_IDOCUMENTSTATELISTENER_IID
    { &kDocumentStateListenerIID, "NS_IDOCUMENTSTATELISTENER_IID" },
#endif
#ifdef NS_IDOM3DOCUMENTEVENT_IID
    { &kDOM3DocumentEventIID, "NS_IDOM3DOCUMENTEVENT_IID" },
#endif
#ifdef NS_IDOM3EVENTTARGET_IID
    { &kDOM3EventTargetIID, "NS_IDOM3EVENTTARGET_IID" },
#endif
#ifdef NS_IDOM3NODE_IID
    { &kDOM3NodeIID, "NS_IDOM3NODE_IID" },
#endif
#ifdef NS_IDOMABSTRACTVIEW_IID
    { &kDOMAbstractViewIID, "NS_IDOMABSTRACTVIEW_IID" },
#endif
#ifdef NS_IDOMATTR_IID
    { &kDOMAttrIID, "NS_IDOMATTR_IID" },
#endif
#ifdef NS_IDOMBARPROP_IID
    { &kDOMBarPropIID, "NS_IDOMBARPROP_IID" },
#endif
#ifdef NS_IDOMCDATASECTION_IID
    { &kDOMCDATASectionIID, "NS_IDOMCDATASECTION_IID" },
#endif
#ifdef NS_IDOMCHARACTERDATA_IID
    { &kDOMCharacterDataIID, "NS_IDOMCHARACTERDATA_IID" },
#endif
#ifdef NS_IDOMCHROMEWINDOW_IID
    { &kDOMChromeWindowIID, "NS_IDOMCHROMEWINDOW_IID" },
#endif
#ifdef NS_IDOMCOMMENT_IID
    { &kDOMCommentIID, "NS_IDOMCOMMENT_IID" },
#endif
#ifdef NS_IDOMCOUNTER_IID
    { &kDOMCounterIID, "NS_IDOMCOUNTER_IID" },
#endif
#ifdef NS_IDOMCRMFOBJECT_IID
    { &kDOMCRMFObjectIID, "NS_IDOMCRMFOBJECT_IID" },
#endif
#ifdef NS_IDOMCRYPTO_IID
    { &kDOMCryptoIID, "NS_IDOMCRYPTO_IID" },
#endif
#ifdef NS_IDOMCRYPTODIALOGS_IID
    { &kDOMCryptoDialogsIID, "NS_IDOMCRYPTODIALOGS_IID" },
#endif
#ifdef NS_IDOMCSS2PROPERTIES_IID
    { &kDOMCSS2PropertiesIID, "NS_IDOMCSS2PROPERTIES_IID" },
#endif
#ifdef NS_IDOMCSSCHARSETRULE_IID
    { &kDOMCSSCharsetRuleIID, "NS_IDOMCSSCHARSETRULE_IID" },
#endif
#ifdef NS_IDOMCSSFONTFACERULE_IID
    { &kDOMCSSFontFaceRuleIID, "NS_IDOMCSSFONTFACERULE_IID" },
#endif
#ifdef NS_IDOMCSSIMPORTRULE_IID
    { &kDOMCSSImportRuleIID, "NS_IDOMCSSIMPORTRULE_IID" },
#endif
#ifdef NS_IDOMCSSMEDIARULE_IID
    { &kDOMCSSMediaRuleIID, "NS_IDOMCSSMEDIARULE_IID" },
#endif
#ifdef NS_IDOMCSSPAGERULE_IID
    { &kDOMCSSPageRuleIID, "NS_IDOMCSSPAGERULE_IID" },
#endif
#ifdef NS_IDOMCSSPRIMITIVEVALUE_IID
    { &kDOMCSSPrimitiveValueIID, "NS_IDOMCSSPRIMITIVEVALUE_IID" },
#endif
#ifdef NS_IDOMCSSRULE_IID
    { &kDOMCSSRuleIID, "NS_IDOMCSSRULE_IID" },
#endif
#ifdef NS_IDOMCSSRULELIST_IID
    { &kDOMCSSRuleListIID, "NS_IDOMCSSRULELIST_IID" },
#endif
#ifdef NS_IDOMCSSSTYLEDECLARATION_IID
    { &kDOMCSSStyleDeclarationIID, "NS_IDOMCSSSTYLEDECLARATION_IID" },
#endif
#ifdef NS_IDOMCSSSTYLERULE_IID
    { &kDOMCSSStyleRuleIID, "NS_IDOMCSSSTYLERULE_IID" },
#endif
#ifdef NS_IDOMCSSSTYLESHEET_IID
    { &kDOMCSSStyleSheetIID, "NS_IDOMCSSSTYLESHEET_IID" },
#endif
#ifdef NS_IDOMCSSUNKNOWNRULE_IID
    { &kDOMCSSUnknownRuleIID, "NS_IDOMCSSUNKNOWNRULE_IID" },
#endif
#ifdef NS_IDOMCSSVALUE_IID
    { &kDOMCSSValueIID, "NS_IDOMCSSVALUE_IID" },
#endif
#ifdef NS_IDOMCSSVALUELIST_IID
    { &kDOMCSSValueListIID, "NS_IDOMCSSVALUELIST_IID" },
#endif
#ifdef NS_IDOMDOCUMENT_IID
    { &kDOMDocumentIID, "NS_IDOMDOCUMENT_IID" },
#endif
#ifdef NS_IDOMDOCUMENTCSS_IID
    { &kDOMDocumentCSSIID, "NS_IDOMDOCUMENTCSS_IID" },
#endif
#ifdef NS_IDOMDOCUMENTEVENT_IID
    { &kDOMDocumentEventIID, "NS_IDOMDOCUMENTEVENT_IID" },
#endif
#ifdef NS_IDOMDOCUMENTFRAGMENT_IID
    { &kDOMDocumentFragmentIID, "NS_IDOMDOCUMENTFRAGMENT_IID" },
#endif
#ifdef NS_IDOMDOCUMENTRANGE_IID
    { &kDOMDocumentRangeIID, "NS_IDOMDOCUMENTRANGE_IID" },
#endif
#ifdef NS_IDOMDOCUMENTSTYLE_IID
    { &kDOMDocumentStyleIID, "NS_IDOMDOCUMENTSTYLE_IID" },
#endif
#ifdef NS_IDOMDOCUMENTTRAVERSAL_IID
    { &kDOMDocumentTraversalIID, "NS_IDOMDOCUMENTTRAVERSAL_IID" },
#endif
#ifdef NS_IDOMDOCUMENTTYPE_IID
    { &kDOMDocumentTypeIID, "NS_IDOMDOCUMENTTYPE_IID" },
#endif
#ifdef NS_IDOMDOCUMENTVIEW_IID
    { &kDOMDocumentViewIID, "NS_IDOMDOCUMENTVIEW_IID" },
#endif
#ifdef NS_IDOMDOCUMENTXBL_IID
    { &kDOMDocumentXBLIID, "NS_IDOMDOCUMENTXBL_IID" },
#endif
#ifdef NS_IDOMDOMEXCEPTION_IID
    { &kDOMDOMExceptionIID, "NS_IDOMDOMEXCEPTION_IID" },
#endif
#ifdef NS_IDOMDOMIMPLEMENTATION_IID
    { &kDOMDOMImplementationIID, "NS_IDOMDOMIMPLEMENTATION_IID" },
#endif
#ifdef NS_IDOMELEMENT_IID
    { &kDOMElementIID, "NS_IDOMELEMENT_IID" },
#endif
#ifdef NS_IDOMELEMENTCSSINLINESTYLE_IID
    { &kDOMElementCSSInlineStyleIID, "NS_IDOMELEMENTCSSINLINESTYLE_IID" },
#endif
#ifdef NS_IDOMENTITY_IID
    { &kDOMEntityIID, "NS_IDOMENTITY_IID" },
#endif
#ifdef NS_IDOMENTITYREFERENCE_IID
    { &kDOMEntityReferenceIID, "NS_IDOMENTITYREFERENCE_IID" },
#endif
#ifdef NS_IDOMEVENT_IID
    { &kDOMEventIID, "NS_IDOMEVENT_IID" },
#endif
#ifdef NS_IDOMEVENTGROUP_IID
    { &kDOMEventGroupIID, "NS_IDOMEVENTGROUP_IID" },
#endif
#ifdef NS_IDOMEVENTLISTENER_IID
    { &kDOMEventListenerIID, "NS_IDOMEVENTLISTENER_IID" },
#endif
#ifdef NS_IDOMEVENTTARGET_IID
    { &kDOMEventTargetIID, "NS_IDOMEVENTTARGET_IID" },
#endif
#ifdef NS_IDOMHISTORY_IID
    { &kDOMHistoryIID, "NS_IDOMHISTORY_IID" },
#endif
#ifdef NS_IDOMHTMLANCHORELEMENT_IID
    { &kDOMHTMLAnchorElementIID, "NS_IDOMHTMLANCHORELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLAPPLETELEMENT_IID
    { &kDOMHTMLAppletElementIID, "NS_IDOMHTMLAPPLETELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLAREAELEMENT_IID
    { &kDOMHTMLAreaElementIID, "NS_IDOMHTMLAREAELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLBASEELEMENT_IID
    { &kDOMHTMLBaseElementIID, "NS_IDOMHTMLBASEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLBASEFONTELEMENT_IID
    { &kDOMHTMLBaseFontElementIID, "NS_IDOMHTMLBASEFONTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLBODYELEMENT_IID
    { &kDOMHTMLBodyElementIID, "NS_IDOMHTMLBODYELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLBRELEMENT_IID
    { &kDOMHTMLBRElementIID, "NS_IDOMHTMLBRELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLBUTTONELEMENT_IID
    { &kDOMHTMLButtonElementIID, "NS_IDOMHTMLBUTTONELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLCOLLECTION_IID
    { &kDOMHTMLCollectionIID, "NS_IDOMHTMLCOLLECTION_IID" },
#endif
#ifdef NS_IDOMHTMLDIRECTORYELEMENT_IID
    { &kDOMHTMLDirectoryElementIID, "NS_IDOMHTMLDIRECTORYELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLDIVELEMENT_IID
    { &kDOMHTMLDivElementIID, "NS_IDOMHTMLDIVELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLDLISTELEMENT_IID
    { &kDOMHTMLDListElementIID, "NS_IDOMHTMLDLISTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLDOCUMENT_IID
    { &kDOMHTMLDocumentIID, "NS_IDOMHTMLDOCUMENT_IID" },
#endif
#ifdef NS_IDOMHTMLELEMENT_IID
    { &kDOMHTMLElementIID, "NS_IDOMHTMLELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLEMBEDELEMENT_IID
    { &kDOMHTMLEmbedElementIID, "NS_IDOMHTMLEMBEDELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLFIELDSETELEMENT_IID
    { &kDOMHTMLFieldSetElementIID, "NS_IDOMHTMLFIELDSETELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLFONTELEMENT_IID
    { &kDOMHTMLFontElementIID, "NS_IDOMHTMLFONTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLFORMELEMENT_IID
    { &kDOMHTMLFormElementIID, "NS_IDOMHTMLFORMELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLFRAMEELEMENT_IID
    { &kDOMHTMLFrameElementIID, "NS_IDOMHTMLFRAMEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLFRAMESETELEMENT_IID
    { &kDOMHTMLFrameSetElementIID, "NS_IDOMHTMLFRAMESETELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLHEADELEMENT_IID
    { &kDOMHTMLHeadElementIID, "NS_IDOMHTMLHEADELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLHEADINGELEMENT_IID
    { &kDOMHTMLHeadingElementIID, "NS_IDOMHTMLHEADINGELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLHRELEMENT_IID
    { &kDOMHTMLHRElementIID, "NS_IDOMHTMLHRELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLHTMLELEMENT_IID
    { &kDOMHTMLHtmlElementIID, "NS_IDOMHTMLHTMLELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLIFRAMEELEMENT_IID
    { &kDOMHTMLIFrameElementIID, "NS_IDOMHTMLIFRAMEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLIMAGEELEMENT_IID
    { &kDOMHTMLImageElementIID, "NS_IDOMHTMLIMAGEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLINPUTELEMENT_IID
    { &kDOMHTMLInputElementIID, "NS_IDOMHTMLINPUTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLISINDEXELEMENT_IID
    { &kDOMHTMLIsIndexElementIID, "NS_IDOMHTMLISINDEXELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLLABELELEMENT_IID
    { &kDOMHTMLLabelElementIID, "NS_IDOMHTMLLABELELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLLEGENDELEMENT_IID
    { &kDOMHTMLLegendElementIID, "NS_IDOMHTMLLEGENDELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLLIELEMENT_IID
    { &kDOMHTMLLIElementIID, "NS_IDOMHTMLLIELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLLINKELEMENT_IID
    { &kDOMHTMLLinkElementIID, "NS_IDOMHTMLLINKELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLMAPELEMENT_IID
    { &kDOMHTMLMapElementIID, "NS_IDOMHTMLMAPELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLMENUELEMENT_IID
    { &kDOMHTMLMenuElementIID, "NS_IDOMHTMLMENUELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLMETAELEMENT_IID
    { &kDOMHTMLMetaElementIID, "NS_IDOMHTMLMETAELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLMODELEMENT_IID
    { &kDOMHTMLModElementIID, "NS_IDOMHTMLMODELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLOBJECTELEMENT_IID
    { &kDOMHTMLObjectElementIID, "NS_IDOMHTMLOBJECTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLOLISTELEMENT_IID
    { &kDOMHTMLOListElementIID, "NS_IDOMHTMLOLISTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLOPTGROUPELEMENT_IID
    { &kDOMHTMLOptGroupElementIID, "NS_IDOMHTMLOPTGROUPELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLOPTIONELEMENT_IID
    { &kDOMHTMLOptionElementIID, "NS_IDOMHTMLOPTIONELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLPARAGRAPHELEMENT_IID
    { &kDOMHTMLParagraphElementIID, "NS_IDOMHTMLPARAGRAPHELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLPARAMELEMENT_IID
    { &kDOMHTMLParamElementIID, "NS_IDOMHTMLPARAMELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLPREELEMENT_IID
    { &kDOMHTMLPreElementIID, "NS_IDOMHTMLPREELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLQUOTEELEMENT_IID
    { &kDOMHTMLQuoteElementIID, "NS_IDOMHTMLQUOTEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLSCRIPTELEMENT_IID
    { &kDOMHTMLScriptElementIID, "NS_IDOMHTMLSCRIPTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLSELECTELEMENT_IID
    { &kDOMHTMLSelectElementIID, "NS_IDOMHTMLSELECTELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLSTYLEELEMENT_IID
    { &kDOMHTMLStyleElementIID, "NS_IDOMHTMLSTYLEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTABLECAPTIONELEM_IID
    { &kDOMHTMLTableCaptionElemIID, "NS_IDOMHTMLTABLECAPTIONELEM_IID" },
#endif
#ifdef NS_IDOMHTMLTABLECELLELEMENT_IID
    { &kDOMHTMLTableCellElementIID, "NS_IDOMHTMLTABLECELLELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTABLECOLELEMENT_IID
    { &kDOMHTMLTableColElementIID, "NS_IDOMHTMLTABLECOLELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTABLEELEMENT_IID
    { &kDOMHTMLTableElementIID, "NS_IDOMHTMLTABLEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTABLEROWELEMENT_IID
    { &kDOMHTMLTableRowElementIID, "NS_IDOMHTMLTABLEROWELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTABLESECTIONELEM_IID
    { &kDOMHTMLTableSectionElemIID, "NS_IDOMHTMLTABLESECTIONELEM_IID" },
#endif
#ifdef NS_IDOMHTMLTEXTAREAELEMENT_IID
    { &kDOMHTMLTextAreaElementIID, "NS_IDOMHTMLTEXTAREAELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLTITLEELEMENT_IID
    { &kDOMHTMLTitleElementIID, "NS_IDOMHTMLTITLEELEMENT_IID" },
#endif
#ifdef NS_IDOMHTMLULISTELEMENT_IID
    { &kDOMHTMLUListElementIID, "NS_IDOMHTMLULISTELEMENT_IID" },
#endif
#ifdef NS_IDOMJSWINDOW_IID
    { &kDOMJSWindowIID, "NS_IDOMJSWINDOW_IID" },
#endif
#ifdef NS_IDOMKEYEVENT_IID
    { &kDOMKeyEventIID, "NS_IDOMKEYEVENT_IID" },
#endif
#ifdef NS_IDOMLINKSTYLE_IID
    { &kDOMLinkStyleIID, "NS_IDOMLINKSTYLE_IID" },
#endif
#ifdef NS_IDOMLOCATION_IID
    { &kDOMLocationIID, "NS_IDOMLOCATION_IID" },
#endif
#ifdef NS_IDOMMEDIALIST_IID
    { &kDOMMediaListIID, "NS_IDOMMEDIALIST_IID" },
#endif
#ifdef NS_IDOMMIMETYPE_IID
    { &kDOMMimeTypeIID, "NS_IDOMMIMETYPE_IID" },
#endif
#ifdef NS_IDOMMIMETYPEARRAY_IID
    { &kDOMMimeTypeArrayIID, "NS_IDOMMIMETYPEARRAY_IID" },
#endif
#ifdef NS_IDOMMOUSEEVENT_IID
    { &kDOMMouseEventIID, "NS_IDOMMOUSEEVENT_IID" },
#endif
#ifdef NS_IDOMMUTATIONEVENT_IID
    { &kDOMMutationEventIID, "NS_IDOMMUTATIONEVENT_IID" },
#endif
#ifdef NS_IDOMNAMEDNODEMAP_IID
    { &kDOMNamedNodeMapIID, "NS_IDOMNAMEDNODEMAP_IID" },
#endif
#ifdef NS_IDOMNAVIGATOR_IID
    { &kDOMNavigatorIID, "NS_IDOMNAVIGATOR_IID" },
#endif
#ifdef NS_IDOMNODE_IID
    { &kDOMNodeIID, "NS_IDOMNODE_IID" },
#endif
#ifdef NS_IDOMNODEFILTER_IID
    { &kDOMNodeFilterIID, "NS_IDOMNODEFILTER_IID" },
#endif
#ifdef NS_IDOMNODEITERATOR_IID
    { &kDOMNodeIteratorIID, "NS_IDOMNODEITERATOR_IID" },
#endif
#ifdef NS_IDOMNODELIST_IID
    { &kDOMNodeListIID, "NS_IDOMNODELIST_IID" },
#endif
#ifdef NS_IDOMNOTATION_IID
    { &kDOMNotationIID, "NS_IDOMNOTATION_IID" },
#endif
#ifdef NS_IDOMNSDOCUMENT_IID
    { &kDOMNSDocumentIID, "NS_IDOMNSDOCUMENT_IID" },
#endif
#ifdef NS_IDOMNSEVENT_IID
    { &kDOMNSEventIID, "NS_IDOMNSEVENT_IID" },
#endif
#ifdef NS_IDOMNSHISTORY_IID
    { &kDOMNSHistoryIID, "NS_IDOMNSHISTORY_IID" },
#endif
#ifdef NS_IDOMNSHTMLANCHORELEMENT_IID
    { &kDOMNSHTMLAnchorElementIID, "NS_IDOMNSHTMLANCHORELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLAREAELEMENT_IID
    { &kDOMNSHTMLAreaElementIID, "NS_IDOMNSHTMLAREAELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLBUTTONELEMENT_IID
    { &kDOMNSHTMLButtonElementIID, "NS_IDOMNSHTMLBUTTONELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLDOCUMENT_IID
    { &kDOMNSHTMLDocumentIID, "NS_IDOMNSHTMLDOCUMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLELEMENT_IID
    { &kDOMNSHTMLElementIID, "NS_IDOMNSHTMLELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLFORMCONTROLLIST_IID
    { &kDOMNSHTMLFormControlListIID, "NS_IDOMNSHTMLFORMCONTROLLIST_IID" },
#endif
#ifdef NS_IDOMNSHTMLFORMELEMENT_IID
    { &kDOMNSHTMLFormElementIID, "NS_IDOMNSHTMLFORMELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLFRAMEELEMENT_IID
    { &kDOMNSHTMLFrameElementIID, "NS_IDOMNSHTMLFRAMEELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLIMAGEELEMENT_IID
    { &kDOMNSHTMLImageElementIID, "NS_IDOMNSHTMLIMAGEELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLINPUTELEMENT_IID
    { &kDOMNSHTMLInputElementIID, "NS_IDOMNSHTMLINPUTELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLOPTIONCOLLECTN_IID
    { &kDOMNSHTMLOptionCollectnIID, "NS_IDOMNSHTMLOPTIONCOLLECTN_IID" },
#endif
#ifdef NS_IDOMNSHTMLSELECTELEMENT_IID
    { &kDOMNSHTMLSelectElementIID, "NS_IDOMNSHTMLSELECTELEMENT_IID" },
#endif
#ifdef NS_IDOMNSHTMLTEXTAREAELEMENT_IID
    { &kDOMNSHTMLTextAreaElementIID, "NS_IDOMNSHTMLTEXTAREAELEMENT_IID" },
#endif
#ifdef NS_IDOMNSLOCATION_IID
    { &kDOMNSLocationIID, "NS_IDOMNSLOCATION_IID" },
#endif
#ifdef NS_IDOMNSRANGE_IID
    { &kDOMNSRangeIID, "NS_IDOMNSRANGE_IID" },
#endif
#ifdef NS_IDOMNSUIEVENT_IID
    { &kDOMNSUIEventIID, "NS_IDOMNSUIEVENT_IID" },
#endif
#ifdef NS_IDOMNSXBLFORMCONTROL_IID
    { &kDOMNSXBLFormControlIID, "NS_IDOMNSXBLFORMCONTROL_IID" },
#endif
#ifdef NS_IDOMPARSER_IID
    { &kDOMParserIID, "NS_IDOMPARSER_IID" },
#endif
#ifdef NS_IDOMPKCS11_IID
    { &kDOMPkcs11IID, "NS_IDOMPKCS11_IID" },
#endif
#ifdef NS_IDOMPLUGIN_IID
    { &kDOMPluginIID, "NS_IDOMPLUGIN_IID" },
#endif
#ifdef NS_IDOMPLUGINARRAY_IID
    { &kDOMPluginArrayIID, "NS_IDOMPLUGINARRAY_IID" },
#endif
#ifdef NS_IDOMPROCESSINGINSTRUCTION_IID
    { &kDOMProcessingInstructionIID, "NS_IDOMPROCESSINGINSTRUCTION_IID" },
#endif
#ifdef NS_IDOMRANGE_IID
    { &kDOMRangeIID, "NS_IDOMRANGE_IID" },
#endif
#ifdef NS_IDOMRANGEEXCEPTION_IID
    { &kDOMRangeExceptionIID, "NS_IDOMRANGEEXCEPTION_IID" },
#endif
#ifdef NS_IDOMRECT_IID
    { &kDOMRectIID, "NS_IDOMRECT_IID" },
#endif
#ifdef NS_IDOMRGBCOLOR_IID
    { &kDOMRGBColorIID, "NS_IDOMRGBCOLOR_IID" },
#endif
#ifdef NS_IDOMSCREEN_IID
    { &kDOMScreenIID, "NS_IDOMSCREEN_IID" },
#endif
#ifdef NS_IDOMSERIALIZER_IID
    { &kDOMSerializerIID, "NS_IDOMSERIALIZER_IID" },
#endif
#ifdef NS_IDOMSTYLESHEET_IID
    { &kDOMStyleSheetIID, "NS_IDOMSTYLESHEET_IID" },
#endif
#ifdef NS_IDOMSTYLESHEETLIST_IID
    { &kDOMStyleSheetListIID, "NS_IDOMSTYLESHEETLIST_IID" },
#endif
#ifdef NS_IDOMTEXT_IID
    { &kDOMTextIID, "NS_IDOMTEXT_IID" },
#endif
#ifdef NS_IDOMTREEWALKER_IID
    { &kDOMTreeWalkerIID, "NS_IDOMTREEWALKER_IID" },
#endif
#ifdef NS_IDOMUIEVENT_IID
    { &kDOMUIEventIID, "NS_IDOMUIEVENT_IID" },
#endif
#ifdef NS_IDOMVIEWCSS_IID
    { &kDOMViewCSSIID, "NS_IDOMVIEWCSS_IID" },
#endif
#ifdef NS_IDOMWINDOW_IID
    { &kDOMWindowIID, "NS_IDOMWINDOW_IID" },
#endif
#ifdef NS_IDOMWINDOWCOLLECTION_IID
    { &kDOMWindowCollectionIID, "NS_IDOMWINDOWCOLLECTION_IID" },
#endif
#ifdef NS_IDOMWINDOWINTERNAL_IID
    { &kDOMWindowInternalIID, "NS_IDOMWINDOWINTERNAL_IID" },
#endif
#ifdef NS_IDOMXMLDOCUMENT_IID
    { &kDOMXMLDocumentIID, "NS_IDOMXMLDOCUMENT_IID" },
#endif
#ifdef NS_IDOMXPATHEVALUATOR_IID
    { &kDOMXPathEvaluatorIID, "NS_IDOMXPATHEVALUATOR_IID" },
#endif
#ifdef NS_IDOMXPATHEXCEPTION_IID
    { &kDOMXPathExceptionIID, "NS_IDOMXPATHEXCEPTION_IID" },
#endif
#ifdef NS_IDOMXPATHEXPRESSION_IID
    { &kDOMXPathExpressionIID, "NS_IDOMXPATHEXPRESSION_IID" },
#endif
#ifdef NS_IDOMXPATHNAMESPACE_IID
    { &kDOMXPathNamespaceIID, "NS_IDOMXPATHNAMESPACE_IID" },
#endif
#ifdef NS_IDOMXPATHNSRESOLVER_IID
    { &kDOMXPathNSResolverIID, "NS_IDOMXPATHNSRESOLVER_IID" },
#endif
#ifdef NS_IDOMXPATHRESULT_IID
    { &kDOMXPathResultIID, "NS_IDOMXPATHRESULT_IID" },
#endif
#ifdef NS_IDOMXULBUTTONELEMENT_IID
    { &kDOMXULButtonElementIID, "NS_IDOMXULBUTTONELEMENT_IID" },
#endif
#ifdef NS_IDOMXULCHECKBOXELEMENT_IID
    { &kDOMXULCheckboxElementIID, "NS_IDOMXULCHECKBOXELEMENT_IID" },
#endif
#ifdef NS_IDOMXULCOMMANDDISPATCHER_IID
    { &kDOMXULCommandDispatcherIID, "NS_IDOMXULCOMMANDDISPATCHER_IID" },
#endif
#ifdef NS_IDOMXULCONTROLELEMENT_IID
    { &kDOMXULControlElementIID, "NS_IDOMXULCONTROLELEMENT_IID" },
#endif
#ifdef NS_IDOMXULDESCRIPTIONELEMENT_IID
    { &kDOMXULDescriptionElementIID, "NS_IDOMXULDESCRIPTIONELEMENT_IID" },
#endif
#ifdef NS_IDOMXULDOCUMENT_IID
    { &kDOMXULDocumentIID, "NS_IDOMXULDOCUMENT_IID" },
#endif
#ifdef NS_IDOMXULELEMENT_IID
    { &kDOMXULElementIID, "NS_IDOMXULELEMENT_IID" },
#endif
#ifdef NS_IDOMXULIMAGEELEMENT_IID
    { &kDOMXULImageElementIID, "NS_IDOMXULIMAGEELEMENT_IID" },
#endif
#ifdef NS_IDOMXULLABELEDCONTROLEL_IID
    { &kDOMXULLabeledControlElIID, "NS_IDOMXULLABELEDCONTROLEL_IID" },
#endif
#ifdef NS_IDOMXULLABELELEMENT_IID
    { &kDOMXULLabelElementIID, "NS_IDOMXULLABELELEMENT_IID" },
#endif
#ifdef NS_IDOMXULMENULISTELEMENT_IID
    { &kDOMXULMenuListElementIID, "NS_IDOMXULMENULISTELEMENT_IID" },
#endif
#ifdef NS_IDOMXULMULTSELECTCNTRLEL_IID
    { &kDOMXULMultSelectCntrlElIID, "NS_IDOMXULMULTSELECTCNTRLEL_IID" },
#endif
#ifdef NS_IDOMXULPOPUPELEMENT_IID
    { &kDOMXULPopupElementIID, "NS_IDOMXULPOPUPELEMENT_IID" },
#endif
#ifdef NS_IDOMXULSELECTCNTRLEL_IID
    { &kDOMXULSelectCntrlElIID, "NS_IDOMXULSELECTCNTRLEL_IID" },
#endif
#ifdef NS_IDOMXULSELECTCNTRLITEMEL_IID
    { &kDOMXULSelectCntrlItemElIID, "NS_IDOMXULSELECTCNTRLITEMEL_IID" },
#endif
#ifdef NS_IDOWNLOAD_IID
    { &kDownloadIID, "NS_IDOWNLOAD_IID" },
#endif
#ifdef NS_IDOWNLOADER_IID
    { &kDownloaderIID, "NS_IDOWNLOADER_IID" },
#endif
#ifdef NS_IDOWNLOADMANAGER_IID
    { &kDownloadManagerIID, "NS_IDOWNLOADMANAGER_IID" },
#endif
#ifdef NS_IDOWNLOADPROGRESSLISTENER_IID
    { &kDownloadProgressListenerIID, "NS_IDOWNLOADPROGRESSLISTENER_IID" },
#endif
#ifdef NS_IDRAGDROPHANDLER_IID
    { &kDragDropHandlerIID, "NS_IDRAGDROPHANDLER_IID" },
#endif
#ifdef NS_IDRAGDROPOVERRIDE_IID
    { &kDragDropOverrideIID, "NS_IDRAGDROPOVERRIDE_IID" },
#endif
#ifdef NS_IDRAGSERVICE_IID
    { &kDragServiceIID, "NS_IDRAGSERVICE_IID" },
#endif
#ifdef NS_IDRAGSESSION_IID
    { &kDragSessionIID, "NS_IDRAGSESSION_IID" },
#endif
#ifdef NS_IDRAGTRACKER_IID
    { &kDragTrackerIID, "NS_IDRAGTRACKER_IID" },
#endif
#ifdef NS_IEDITACTIONLISTENER_IID
    { &kEditActionListenerIID, "NS_IEDITACTIONLISTENER_IID" },
#endif
#ifdef NS_IEDITINGSESSION_IID
    { &kEditingSessionIID, "NS_IEDITINGSESSION_IID" },
#endif
#ifdef NS_IEDITOR_IID
    { &kEditorIID, "NS_IEDITOR_IID" },
#endif
#ifdef NS_IEDITORBOXOBJECT_IID
    { &kEditorBoxObjectIID, "NS_IEDITORBOXOBJECT_IID" },
#endif
#ifdef NS_IEDITORDOCSHELL_IID
    { &kEditorDocShellIID, "NS_IEDITORDOCSHELL_IID" },
#endif
#ifdef NS_IEDITORIMESUPPORT_IID
    { &kEditorIMESupportIID, "NS_IEDITORIMESUPPORT_IID" },
#endif
#ifdef NS_IEDITORLOGGING_IID
    { &kEditorLoggingIID, "NS_IEDITORLOGGING_IID" },
#endif
#ifdef NS_IEDITORMAILSUPPORT_IID
    { &kEditorMailSupportIID, "NS_IEDITORMAILSUPPORT_IID" },
#endif
#ifdef NS_IEDITOROBSERVER_IID
    { &kEditorObserverIID, "NS_IEDITOROBSERVER_IID" },
#endif
#ifdef NS_IEDITORSPELLCHECK_IID
    { &kEditorSpellCheckIID, "NS_IEDITORSPELLCHECK_IID" },
#endif
#ifdef NS_IEDITORSTYLESHEETS_IID
    { &kEditorStyleSheetsIID, "NS_IEDITORSTYLESHEETS_IID" },
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW_IID
    { &kEmbeddingSiteWindowIID, "NS_IEMBEDDINGSITEWINDOW_IID" },
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW2_IID
    { &kEmbeddingSiteWindow2IID, "NS_IEMBEDDINGSITEWINDOW2_IID" },
#endif
#ifdef NS_IENCODEDCHANNEL_IID
    { &kEncodedChannelIID, "NS_IENCODEDCHANNEL_IID" },
#endif
#ifdef NS_IENCRYPTEDSMIMEURISSRVC_IID
    { &kEncryptedSMIMEURIsSrvcIID, "NS_IENCRYPTEDSMIMEURISSRVC_IID" },
#endif
#ifdef NS_IENTITYCONVERTER_IID
    { &kEntityConverterIID, "NS_IENTITYCONVERTER_IID" },
#endif
#ifdef NS_IENTROPYCOLLECTOR_IID
    { &kEntropyCollectorIID, "NS_IENTROPYCOLLECTOR_IID" },
#endif
#ifdef NS_IENUMERATOR_IID
    { &kEnumeratorIID, "NS_IENUMERATOR_IID" },
#endif
#ifdef NS_IERRORSERVICE_IID
    { &kErrorServiceIID, "NS_IERRORSERVICE_IID" },
#endif
#ifdef NS_IEVALUATESTRINGPROXY_IID
    { &kEvaluateStringProxyIID, "NS_IEVALUATESTRINGPROXY_IID" },
#endif
#ifdef NS_IEVENTHANDLER_IID
    { &kEventHandlerIID, "NS_IEVENTHANDLER_IID" },
#endif
#ifdef NS_IEVENTQUEUE_IID
    { &kEventQueueIID, "NS_IEVENTQUEUE_IID" },
#endif
#ifdef NS_IEVENTQUEUESERVICE_IID
    { &kEventQueueServiceIID, "NS_IEVENTQUEUESERVICE_IID" },
#endif
#ifdef NS_IEXCEPTION_IID
    { &kExceptionIID, "NS_IEXCEPTION_IID" },
#endif
#ifdef NS_IEXCEPTIONSERVICE_IID
    { &kExceptionServiceIID, "NS_IEXCEPTIONSERVICE_IID" },
#endif
#ifdef NS_IEXPATSINK_IID
    { &kExpatSinkIID, "NS_IEXPATSINK_IID" },
#endif
#ifdef NS_IEXTERNALHELPERAPPSERVICE_IID
    { &kExternalHelperAppServiceIID, "NS_IEXTERNALHELPERAPPSERVICE_IID" },
#endif
#ifdef NS_IEXTERNALPROTOCOLHANDLER_IID
    { &kExternalProtocolHandlerIID, "NS_IEXTERNALPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IEXTERNALPROTOCOLSERVICE_IID
    { &kExternalProtocolServiceIID, "NS_IEXTERNALPROTOCOLSERVICE_IID" },
#endif
#ifdef NS_IFACTORY_IID
    { &kFactoryIID, "NS_IFACTORY_IID" },
#endif
#ifdef NS_IFASTLOADFILECONTROL_IID
    { &kFastLoadFileControlIID, "NS_IFASTLOADFILECONTROL_IID" },
#endif
#ifdef NS_IFASTLOADSERVICE_IID
    { &kFastLoadServiceIID, "NS_IFASTLOADSERVICE_IID" },
#endif
#ifdef NS_IFILE_IID
    { &kFileIID, "NS_IFILE_IID" },
#endif
#ifdef NS_IFILECHANNEL_IID
    { &kFileChannelIID, "NS_IFILECHANNEL_IID" },
#endif
#ifdef NS_IFILEPICKER_IID
    { &kFilePickerIID, "NS_IFILEPICKER_IID" },
#endif
#ifdef NS_IFILEPROTOCOLHANDLER_IID
    { &kFileProtocolHandlerIID, "NS_IFILEPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IFILESPEC_IID
    { &kFileSpecIID, "NS_IFILESPEC_IID" },
#endif
#ifdef NS_IFILESTREAMS_IID
    { &kFileStreamsIID, "NS_IFILESTREAMS_IID" },
#endif
#ifdef NS_IFILEURL_IID
    { &kFileURLIID, "NS_IFILEURL_IID" },
#endif
#ifdef NS_IFILEUTILITIES_IID
    { &kFileUtilitiesIID, "NS_IFILEUTILITIES_IID" },
#endif
#ifdef NS_IFIND_IID
    { &kFindIID, "NS_IFIND_IID" },
#endif
#ifdef NS_IFINDSERVICE_IID
    { &kFindServiceIID, "NS_IFINDSERVICE_IID" },
#endif
#ifdef NS_IFOLDER_IID
    { &kFolderIID, "NS_IFOLDER_IID" },
#endif
#ifdef NS_IFOLDERLISTENER_IID
    { &kFolderListenerIID, "NS_IFOLDERLISTENER_IID" },
#endif
#ifdef NS_IFONTCATALOGSERVICE_IID
    { &kFontCatalogServiceIID, "NS_IFONTCATALOGSERVICE_IID" },
#endif
#ifdef NS_IFONTENUMERATOR_IID
    { &kFontEnumeratorIID, "NS_IFONTENUMERATOR_IID" },
#endif
#ifdef NS_IFONTLIST_IID
    { &kFontListIID, "NS_IFONTLIST_IID" },
#endif
#ifdef NS_IFONTPACKAGEHANDLER_IID
    { &kFontPackageHandlerIID, "NS_IFONTPACKAGEHANDLER_IID" },
#endif
#ifdef NS_IFONTPACKAGEPROXY_IID
    { &kFontPackageProxyIID, "NS_IFONTPACKAGEPROXY_IID" },
#endif
#ifdef NS_IFONTPACKAGESERVICE_IID
    { &kFontPackageServiceIID, "NS_IFONTPACKAGESERVICE_IID" },
#endif
#ifdef NS_IFORMATCONVERTER_IID
    { &kFormatConverterIID, "NS_IFORMATCONVERTER_IID" },
#endif
#ifdef NS_IFREETYPE2_IID
    { &kFreeType2IID, "NS_IFREETYPE2_IID" },
#endif
#ifdef NS_IFTPCHANNEL_IID
    { &kFTPChannelIID, "NS_IFTPCHANNEL_IID" },
#endif
#ifdef NS_IFULLSCREEN_IID
    { &kFullScreenIID, "NS_IFULLSCREEN_IID" },
#endif
#ifdef NS_IGENKEYPAIRINFODLG_IID
    { &kGenKeypairInfoDlgIID, "NS_IGENKEYPAIRINFODLG_IID" },
#endif
#ifdef NS_IGLOBALHISTORY_IID
    { &kGlobalHistoryIID, "NS_IGLOBALHISTORY_IID" },
#endif
#ifdef NS_IGRAPHICS_IID
    { &kGraphicsIID, "NS_IGRAPHICS_IID" },
#endif
#ifdef NS_IHASH_IID
    { &kHashIID, "NS_IHASH_IID" },
#endif
#ifdef NS_IHELPERAPPLAUNCHERDIALOG_IID
    { &kHelperAppLauncherDialogIID, "NS_IHELPERAPPLAUNCHERDIALOG_IID" },
#endif
#ifdef NS_IHISTORYENTRY_IID
    { &kHistoryEntryIID, "NS_IHISTORYENTRY_IID" },
#endif
#ifdef NS_IHTMLEDITOR_IID
    { &kHTMLEditorIID, "NS_IHTMLEDITOR_IID" },
#endif
#ifdef NS_IHTMLOBJECTRESIZER_IID
    { &kHTMLObjectResizerIID, "NS_IHTMLOBJECTRESIZER_IID" },
#endif
#ifdef NS_IHTTPAUTHENTICATOR_IID
    { &kHttpAuthenticatorIID, "NS_IHTTPAUTHENTICATOR_IID" },
#endif
#ifdef NS_IHTTPCHANNEL_IID
    { &kHttpChannelIID, "NS_IHTTPCHANNEL_IID" },
#endif
#ifdef NS_IHTTPCHANNELINTERNAL_IID
    { &kHttpChannelInternalIID, "NS_IHTTPCHANNELINTERNAL_IID" },
#endif
#ifdef NS_IHTTPEVENTSINK_IID
    { &kHttpEventSinkIID, "NS_IHTTPEVENTSINK_IID" },
#endif
#ifdef NS_IHTTPHEADERLISTENER_IID
    { &kHTTPHeaderListenerIID, "NS_IHTTPHEADERLISTENER_IID" },
#endif
#ifdef NS_IHTTPHEADERVISITOR_IID
    { &kHttpHeaderVisitorIID, "NS_IHTTPHEADERVISITOR_IID" },
#endif
#ifdef NS_IHTTPINDEX_IID
    { &kHTTPIndexIID, "NS_IHTTPINDEX_IID" },
#endif
#ifdef NS_IHTTPNOTIFY_IID
    { &kHttpNotifyIID, "NS_IHTTPNOTIFY_IID" },
#endif
#ifdef NS_IHTTPPROTOCOLHANDLER_IID
    { &kHttpProtocolHandlerIID, "NS_IHTTPPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IICONURI_IID
    { &kIconURIIID, "NS_IICONURI_IID" },
#endif
#ifdef NS_IIDNSERVICE_IID
    { &kIDNServiceIID, "NS_IIDNSERVICE_IID" },
#endif
#ifdef NS_IIFRAMEBOXOBJECT_IID
    { &kIFrameBoxObjectIID, "NS_IIFRAMEBOXOBJECT_IID" },
#endif
#ifdef NS_IIMAGEDOCUMENT_IID
    { &kImageDocumentIID, "NS_IIMAGEDOCUMENT_IID" },
#endif
#ifdef NS_IIMAPFLAGANDUIDSTATE_IID
    { &kImapFlagAndUidStateIID, "NS_IIMAPFLAGANDUIDSTATE_IID" },
#endif
#ifdef NS_IIMAPHEADERXFERINFO_IID
    { &kImapHeaderXferInfoIID, "NS_IIMAPHEADERXFERINFO_IID" },
#endif
#ifdef NS_IIMAPINCOMINGSERVER_IID
    { &kImapIncomingServerIID, "NS_IIMAPINCOMINGSERVER_IID" },
#endif
#ifdef NS_IIMAPMAILFOLDERSINK_IID
    { &kImapMailFolderSinkIID, "NS_IIMAPMAILFOLDERSINK_IID" },
#endif
#ifdef NS_IIMAPMESSAGESINK_IID
    { &kImapMessageSinkIID, "NS_IIMAPMESSAGESINK_IID" },
#endif
#ifdef NS_IIMAPMOCKCHANNEL_IID
    { &kImapMockChannelIID, "NS_IIMAPMOCKCHANNEL_IID" },
#endif
#ifdef NS_IIMAPPROTOCOL_IID
    { &kImapProtocolIID, "NS_IIMAPPROTOCOL_IID" },
#endif
#ifdef NS_IIMAPSERVERSINK_IID
    { &kImapServerSinkIID, "NS_IIMAPSERVERSINK_IID" },
#endif
#ifdef NS_IIMAPSERVICE_IID
    { &kImapServiceIID, "NS_IIMAPSERVICE_IID" },
#endif
#ifdef NS_IIMAPURL_IID
    { &kImapUrlIID, "NS_IIMAPURL_IID" },
#endif
#ifdef NS_IIMGMANAGER_IID
    { &kImgManagerIID, "NS_IIMGMANAGER_IID" },
#endif
#ifdef NS_IIMPORTABDESCRIPTOR_IID
    { &kImportABDescriptorIID, "NS_IIMPORTABDESCRIPTOR_IID" },
#endif
#ifdef NS_IIMPORTADDRESSBOOKS_IID
    { &kImportAddressBooksIID, "NS_IIMPORTADDRESSBOOKS_IID" },
#endif
#ifdef NS_IIMPORTFIELDMAP_IID
    { &kImportFieldMapIID, "NS_IIMPORTFIELDMAP_IID" },
#endif
#ifdef NS_IIMPORTGENERIC_IID
    { &kImportGenericIID, "NS_IIMPORTGENERIC_IID" },
#endif
#ifdef NS_IIMPORTMAIL_IID
    { &kImportMailIID, "NS_IIMPORTMAIL_IID" },
#endif
#ifdef NS_IIMPORTMAILBOXDESCRIPTOR_IID
    { &kImportMailboxDescriptorIID, "NS_IIMPORTMAILBOXDESCRIPTOR_IID" },
#endif
#ifdef NS_IIMPORTMIMEENCODE_IID
    { &kImportMimeEncodeIID, "NS_IIMPORTMIMEENCODE_IID" },
#endif
#ifdef NS_IIMPORTMODULE_IID
    { &kImportModuleIID, "NS_IIMPORTMODULE_IID" },
#endif
#ifdef NS_IIMPORTSERVICE_IID
    { &kImportServiceIID, "NS_IIMPORTSERVICE_IID" },
#endif
#ifdef NS_IIMPORTSETTINGS_IID
    { &kImportSettingsIID, "NS_IIMPORTSETTINGS_IID" },
#endif
#ifdef NS_IINCOMINGSERVERLISTENER_IID
    { &kIncomingServerListenerIID, "NS_IINCOMINGSERVERLISTENER_IID" },
#endif
#ifdef NS_IINPUTSTREAM_IID
    { &kInputStreamIID, "NS_IINPUTSTREAM_IID" },
#endif
#ifdef NS_IINPUTSTREAMCHANNEL_IID
    { &kInputStreamChannelIID, "NS_IINPUTSTREAMCHANNEL_IID" },
#endif
#ifdef NS_IINPUTSTREAMPUMP_IID
    { &kInputStreamPumpIID, "NS_IINPUTSTREAMPUMP_IID" },
#endif
#ifdef NS_IINPUTSTREAMTEE_IID
    { &kInputStreamTeeIID, "NS_IINPUTSTREAMTEE_IID" },
#endif
#ifdef NS_IINTERFACEINFO_IID
    { &kInterfaceInfoIID, "NS_IINTERFACEINFO_IID" },
#endif
#ifdef NS_IINTERFACEINFOMANAGER_IID
    { &kInterfaceInfoManagerIID, "NS_IINTERFACEINFOMANAGER_IID" },
#endif
#ifdef NS_IINTERFACEREQUESTOR_IID
    { &kInterfaceRequestorIID, "NS_IINTERFACEREQUESTOR_IID" },
#endif
#ifdef NS_IIOSERVICE_IID
    { &kIOServiceIID, "NS_IIOSERVICE_IID" },
#endif
#ifdef NS_IJAR_IID
    { &kJARIID, "NS_IJAR_IID" },
#endif
#ifdef NS_IJARCHANNEL_IID
    { &kJARChannelIID, "NS_IJARCHANNEL_IID" },
#endif
#ifdef NS_IJARPROTOCOLHANDLER_IID
    { &kJARProtocolHandlerIID, "NS_IJARPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IJARURI_IID
    { &kJARURIIID, "NS_IJARURI_IID" },
#endif
#ifdef NS_IJRILIVECONNECTPIPEER_IID
    { &kJRILiveConnectPIPeerIID, "NS_IJRILIVECONNECTPIPEER_IID" },
#endif
#ifdef NS_IJRILIVECONNECTPLUGIN_IID
    { &kJRILiveConnectPluginIID, "NS_IJRILIVECONNECTPLUGIN_IID" },
#endif
#ifdef NS_IJSCONSOLESERVICE_IID
    { &kJSConsoleServiceIID, "NS_IJSCONSOLESERVICE_IID" },
#endif
#ifdef NS_IJSCONTEXTSTACK_IID
    { &kJSContextStackIID, "NS_IJSCONTEXTSTACK_IID" },
#endif
#ifdef NS_IJSRUNTIMESERVICE_IID
    { &kJSRuntimeServiceIID, "NS_IJSRUNTIMESERVICE_IID" },
#endif
#ifdef NS_IKEYEDSTREAMGENERATOR_IID
    { &kKeyedStreamGeneratorIID, "NS_IKEYEDSTREAMGENERATOR_IID" },
#endif
#ifdef NS_IKEYGENTHREAD_IID
    { &kKeygenThreadIID, "NS_IKEYGENTHREAD_IID" },
#endif
#ifdef NS_ILANGUAGEATOM_IID
    { &kLanguageAtomIID, "NS_ILANGUAGEATOM_IID" },
#endif
#ifdef NS_ILANGUAGEATOMSERVICE_IID
    { &kLanguageAtomServiceIID, "NS_ILANGUAGEATOMSERVICE_IID" },
#endif
#ifdef NS_ILDAPAUTOCOMPFORMATTER_IID
    { &kLDAPAutoCompFormatterIID, "NS_ILDAPAUTOCOMPFORMATTER_IID" },
#endif
#ifdef NS_ILDAPAUTOCOMPLETESESSION_IID
    { &kLDAPAutoCompleteSessionIID, "NS_ILDAPAUTOCOMPLETESESSION_IID" },
#endif
#ifdef NS_ILDAPBERVALUE_IID
    { &kLDAPBERValueIID, "NS_ILDAPBERVALUE_IID" },
#endif
#ifdef NS_ILDAPCONNECTION_IID
    { &kLDAPConnectionIID, "NS_ILDAPCONNECTION_IID" },
#endif
#ifdef NS_ILDAPERRORS_IID
    { &kLDAPErrorsIID, "NS_ILDAPERRORS_IID" },
#endif
#ifdef NS_ILDAPMESSAGE_IID
    { &kLDAPMessageIID, "NS_ILDAPMESSAGE_IID" },
#endif
#ifdef NS_ILDAPMESSAGELISTENER_IID
    { &kLDAPMessageListenerIID, "NS_ILDAPMESSAGELISTENER_IID" },
#endif
#ifdef NS_ILDAPOPERATION_IID
    { &kLDAPOperationIID, "NS_ILDAPOPERATION_IID" },
#endif
#ifdef NS_ILDAPPREFSSERVICE_IID
    { &kLDAPPrefsServiceIID, "NS_ILDAPPREFSSERVICE_IID" },
#endif
#ifdef NS_ILDAPSERVER_IID
    { &kLDAPServerIID, "NS_ILDAPSERVER_IID" },
#endif
#ifdef NS_ILDAPSERVICE_IID
    { &kLDAPServiceIID, "NS_ILDAPSERVICE_IID" },
#endif
#ifdef NS_ILDAPSYNCQUERY_IID
    { &kLDAPSyncQueryIID, "NS_ILDAPSYNCQUERY_IID" },
#endif
#ifdef NS_ILDAPURL_IID
    { &kLDAPURLIID, "NS_ILDAPURL_IID" },
#endif
#ifdef NS_ILINEINPUTSTREAM_IID
    { &kLineInputStreamIID, "NS_ILINEINPUTSTREAM_IID" },
#endif
#ifdef NS_ILISTBOXOBJECT_IID
    { &kListBoxObjectIID, "NS_ILISTBOXOBJECT_IID" },
#endif
#ifdef NS_ILOADGROUP_IID
    { &kLoadGroupIID, "NS_ILOADGROUP_IID" },
#endif
#ifdef NS_ILOCALE_IID
    { &kLocaleIID, "NS_ILOCALE_IID" },
#endif
#ifdef NS_ILOCALESERVICE_IID
    { &kLocaleServiceIID, "NS_ILOCALESERVICE_IID" },
#endif
#ifdef NS_ILOCALFILE_IID
    { &kLocalFileIID, "NS_ILOCALFILE_IID" },
#endif
#ifdef NS_ILOCALMAILINCOMINGSERVER_IID
    { &kLocalMailIncomingServerIID, "NS_ILOCALMAILINCOMINGSERVER_IID" },
#endif
#ifdef NS_IMAILBOXSERVICE_IID
    { &kMailboxServiceIID, "NS_IMAILBOXSERVICE_IID" },
#endif
#ifdef NS_IMAILBOXSPEC_IID
    { &kMailboxSpecIID, "NS_IMAILBOXSPEC_IID" },
#endif
#ifdef NS_IMAILBOXURL_IID
    { &kMailboxUrlIID, "NS_IMAILBOXURL_IID" },
#endif
#ifdef NS_IMARKUPDOCUMENTVIEWER_IID
    { &kMarkupDocumentViewerIID, "NS_IMARKUPDOCUMENTVIEWER_IID" },
#endif
#ifdef NS_IMEMORY_IID
    { &kMemoryIID, "NS_IMEMORY_IID" },
#endif
#ifdef NS_IMENUBOXOBJECT_IID
    { &kMenuBoxObjectIID, "NS_IMENUBOXOBJECT_IID" },
#endif
#ifdef NS_IMENUROLLUP_IID
    { &kMenuRollupIID, "NS_IMENUROLLUP_IID" },
#endif
#ifdef NS_IMESSENGER_IID
    { &kMessengerIID, "NS_IMESSENGER_IID" },
#endif
#ifdef NS_IMESSENGERMIGRATOR_IID
    { &kMessengerMigratorIID, "NS_IMESSENGERMIGRATOR_IID" },
#endif
#ifdef NS_IMESSENGEROSINTEGRATION_IID
    { &kMessengerOSIntegrationIID, "NS_IMESSENGEROSINTEGRATION_IID" },
#endif
#ifdef NS_IMESSENGERWINDOWSERVICE_IID
    { &kMessengerWindowServiceIID, "NS_IMESSENGERWINDOWSERVICE_IID" },
#endif
#ifdef NS_IMIMEEMITTER_IID
    { &kMimeEmitterIID, "NS_IMIMEEMITTER_IID" },
#endif
#ifdef NS_IMIMEHEADERS_IID
    { &kMimeHeadersIID, "NS_IMIMEHEADERS_IID" },
#endif
#ifdef NS_IMIMEINFO_IID
    { &kMIMEInfoIID, "NS_IMIMEINFO_IID" },
#endif
#ifdef NS_IMIMEINPUTSTREAM_IID
    { &kMIMEInputStreamIID, "NS_IMIMEINPUTSTREAM_IID" },
#endif
#ifdef NS_IMIMEMISCSTATUS_IID
    { &kMimeMiscStatusIID, "NS_IMIMEMISCSTATUS_IID" },
#endif
#ifdef NS_IMIMESERVICE_IID
    { &kMIMEServiceIID, "NS_IMIMESERVICE_IID" },
#endif
#ifdef NS_IMIMESTREAMCONVERTER_IID
    { &kMimeStreamConverterIID, "NS_IMIMESTREAMCONVERTER_IID" },
#endif
#ifdef NS_IMODULE_IID
    { &kModuleIID, "NS_IMODULE_IID" },
#endif
#ifdef NS_IMSGACCOUNT_IID
    { &kMsgAccountIID, "NS_IMSGACCOUNT_IID" },
#endif
#ifdef NS_IMSGACCOUNTMANAGER_IID
    { &kMsgAccountManagerIID, "NS_IMSGACCOUNTMANAGER_IID" },
#endif
#ifdef NS_IMSGATTACHMENT_IID
    { &kMsgAttachmentIID, "NS_IMSGATTACHMENT_IID" },
#endif
#ifdef NS_IMSGBIFFMANAGER_IID
    { &kMsgBiffManagerIID, "NS_IMSGBIFFMANAGER_IID" },
#endif
#ifdef NS_IMSGCOMPFIELDS_IID
    { &kMsgCompFieldsIID, "NS_IMSGCOMPFIELDS_IID" },
#endif
#ifdef NS_IMSGCOMPOSE_IID
    { &kMsgComposeIID, "NS_IMSGCOMPOSE_IID" },
#endif
#ifdef NS_IMSGCOMPOSEPARAMS_IID
    { &kMsgComposeParamsIID, "NS_IMSGCOMPOSEPARAMS_IID" },
#endif
#ifdef NS_IMSGCOMPOSEPROGRESSPARAMS_IID
    { &kMsgComposeProgressParamsIID, "NS_IMSGCOMPOSEPROGRESSPARAMS_IID" },
#endif
#ifdef NS_IMSGCOMPOSESECURE_IID
    { &kMsgComposeSecureIID, "NS_IMSGCOMPOSESECURE_IID" },
#endif
#ifdef NS_IMSGCOMPOSESERVICE_IID
    { &kMsgComposeServiceIID, "NS_IMSGCOMPOSESERVICE_IID" },
#endif
#ifdef NS_IMSGCOMPUTILS_IID
    { &kMsgCompUtilsIID, "NS_IMSGCOMPUTILS_IID" },
#endif
#ifdef NS_IMSGCOPYSERVICE_IID
    { &kMsgCopyServiceIID, "NS_IMSGCOPYSERVICE_IID" },
#endif
#ifdef NS_IMSGCOPYSERVICELISTENER_IID
    { &kMsgCopyServiceListenerIID, "NS_IMSGCOPYSERVICELISTENER_IID" },
#endif
#ifdef NS_IMSGDATABASE_IID
    { &kMsgDatabaseIID, "NS_IMSGDATABASE_IID" },
#endif
#ifdef NS_IMSGDBVIEW_IID
    { &kMsgDBViewIID, "NS_IMSGDBVIEW_IID" },
#endif
#ifdef NS_IMSGDRAFT_IID
    { &kMsgDraftIID, "NS_IMSGDRAFT_IID" },
#endif
#ifdef NS_IMSGFILTER_IID
    { &kMsgFilterIID, "NS_IMSGFILTER_IID" },
#endif
#ifdef NS_IMSGFILTERHITNOTIFY_IID
    { &kMsgFilterHitNotifyIID, "NS_IMSGFILTERHITNOTIFY_IID" },
#endif
#ifdef NS_IMSGFILTERLIST_IID
    { &kMsgFilterListIID, "NS_IMSGFILTERLIST_IID" },
#endif
#ifdef NS_IMSGFILTERPLUGIN_IID
    { &kMsgFilterPluginIID, "NS_IMSGFILTERPLUGIN_IID" },
#endif
#ifdef NS_IMSGFILTERSERVICE_IID
    { &kMsgFilterServiceIID, "NS_IMSGFILTERSERVICE_IID" },
#endif
#ifdef NS_IMSGFOLDER_IID
    { &kMsgFolderIID, "NS_IMSGFOLDER_IID" },
#endif
#ifdef NS_IMSGFOLDERCACHE_IID
    { &kMsgFolderCacheIID, "NS_IMSGFOLDERCACHE_IID" },
#endif
#ifdef NS_IMSGFOLDERCACHEELEMENT_IID
    { &kMsgFolderCacheElementIID, "NS_IMSGFOLDERCACHEELEMENT_IID" },
#endif
#ifdef NS_IMSGFOLDERCOMPACTOR_IID
    { &kMsgFolderCompactorIID, "NS_IMSGFOLDERCOMPACTOR_IID" },
#endif
#ifdef NS_IMSGGROUPRECORD_IID
    { &kMsgGroupRecordIID, "NS_IMSGGROUPRECORD_IID" },
#endif
#ifdef NS_IMSGHDR_IID
    { &kMsgHdrIID, "NS_IMSGHDR_IID" },
#endif
#ifdef NS_IMSGHEADERPARSER_IID
    { &kMsgHeaderParserIID, "NS_IMSGHEADERPARSER_IID" },
#endif
#ifdef NS_IMSGHOST_IID
    { &kMsgHostIID, "NS_IMSGHOST_IID" },
#endif
#ifdef NS_IMSGIDENTITY_IID
    { &kMsgIdentityIID, "NS_IMSGIDENTITY_IID" },
#endif
#ifdef NS_IMSGIMAPMAILFOLDER_IID
    { &kMsgImapMailFolderIID, "NS_IMSGIMAPMAILFOLDER_IID" },
#endif
#ifdef NS_IMSGINCOMINGSERVER_IID
    { &kMsgIncomingServerIID, "NS_IMSGINCOMINGSERVER_IID" },
#endif
#ifdef NS_IMSGLOCALMAILFOLDER_IID
    { &kMsgLocalMailFolderIID, "NS_IMSGLOCALMAILFOLDER_IID" },
#endif
#ifdef NS_IMSGLOGONREDIRECTOR_IID
    { &kMsgLogonRedirectorIID, "NS_IMSGLOGONREDIRECTOR_IID" },
#endif
#ifdef NS_IMSGMAILNEWSURL_IID
    { &kMsgMailNewsUrlIID, "NS_IMSGMAILNEWSURL_IID" },
#endif
#ifdef NS_IMSGMAILSESSION_IID
    { &kMsgMailSessionIID, "NS_IMSGMAILSESSION_IID" },
#endif
#ifdef NS_IMSGMAILVIEW_IID
    { &kMsgMailViewIID, "NS_IMSGMAILVIEW_IID" },
#endif
#ifdef NS_IMSGMAILVIEWLIST_IID
    { &kMsgMailViewListIID, "NS_IMSGMAILVIEWLIST_IID" },
#endif
#ifdef NS_IMSGMDNGENERATOR_IID
    { &kMsgMdnGeneratorIID, "NS_IMSGMDNGENERATOR_IID" },
#endif
#ifdef NS_IMSGMESSAGESERVICE_IID
    { &kMsgMessageServiceIID, "NS_IMSGMESSAGESERVICE_IID" },
#endif
#ifdef NS_IMSGNEWSFOLDER_IID
    { &kMsgNewsFolderIID, "NS_IMSGNEWSFOLDER_IID" },
#endif
#ifdef NS_IMSGOFFLINEIMAPOPERATION_IID
    { &kMsgOfflineImapOperationIID, "NS_IMSGOFFLINEIMAPOPERATION_IID" },
#endif
#ifdef NS_IMSGOFFLINEMANAGER_IID
    { &kMsgOfflineManagerIID, "NS_IMSGOFFLINEMANAGER_IID" },
#endif
#ifdef NS_IMSGOFFLINENEWSSTATE_IID
    { &kMsgOfflineNewsStateIID, "NS_IMSGOFFLINENEWSSTATE_IID" },
#endif
#ifdef NS_IMSGPARSEMAILMSGSTATE_IID
    { &kMsgParseMailMsgStateIID, "NS_IMSGPARSEMAILMSGSTATE_IID" },
#endif
#ifdef NS_IMSGPRINTENGINE_IID
    { &kMsgPrintEngineIID, "NS_IMSGPRINTENGINE_IID" },
#endif
#ifdef NS_IMSGPROGRESS_IID
    { &kMsgProgressIID, "NS_IMSGPROGRESS_IID" },
#endif
#ifdef NS_IMSGPROTOCOLINFO_IID
    { &kMsgProtocolInfoIID, "NS_IMSGPROTOCOLINFO_IID" },
#endif
#ifdef NS_IMSGPURGESERVICE_IID
    { &kMsgPurgeServiceIID, "NS_IMSGPURGESERVICE_IID" },
#endif
#ifdef NS_IMSGQUOTE_IID
    { &kMsgQuoteIID, "NS_IMSGQUOTE_IID" },
#endif
#ifdef NS_IMSGRDFDATASOURCE_IID
    { &kMsgRDFDataSourceIID, "NS_IMSGRDFDATASOURCE_IID" },
#endif
#ifdef NS_IMSGRECIPIENTARRAY_IID
    { &kMsgRecipientArrayIID, "NS_IMSGRECIPIENTARRAY_IID" },
#endif
#ifdef NS_IMSGSEARCHADAPTER_IID
    { &kMsgSearchAdapterIID, "NS_IMSGSEARCHADAPTER_IID" },
#endif
#ifdef NS_IMSGSEARCHNOTIFY_IID
    { &kMsgSearchNotifyIID, "NS_IMSGSEARCHNOTIFY_IID" },
#endif
#ifdef NS_IMSGSEARCHSCOPETERM_IID
    { &kMsgSearchScopeTermIID, "NS_IMSGSEARCHSCOPETERM_IID" },
#endif
#ifdef NS_IMSGSEARCHSESSION_IID
    { &kMsgSearchSessionIID, "NS_IMSGSEARCHSESSION_IID" },
#endif
#ifdef NS_IMSGSEARCHTERM_IID
    { &kMsgSearchTermIID, "NS_IMSGSEARCHTERM_IID" },
#endif
#ifdef NS_IMSGSEARCHVALIDITYMANAGER_IID
    { &kMsgSearchValidityManagerIID, "NS_IMSGSEARCHVALIDITYMANAGER_IID" },
#endif
#ifdef NS_IMSGSEARCHVALIDITYTABLE_IID
    { &kMsgSearchValidityTableIID, "NS_IMSGSEARCHVALIDITYTABLE_IID" },
#endif
#ifdef NS_IMSGSEARCHVALUE_IID
    { &kMsgSearchValueIID, "NS_IMSGSEARCHVALUE_IID" },
#endif
#ifdef NS_IMSGSEND_IID
    { &kMsgSendIID, "NS_IMSGSEND_IID" },
#endif
#ifdef NS_IMSGSENDLATER_IID
    { &kMsgSendLaterIID, "NS_IMSGSENDLATER_IID" },
#endif
#ifdef NS_IMSGSENDLATERLISTENER_IID
    { &kMsgSendLaterListenerIID, "NS_IMSGSENDLATERLISTENER_IID" },
#endif
#ifdef NS_IMSGSENDLISTENER_IID
    { &kMsgSendListenerIID, "NS_IMSGSENDLISTENER_IID" },
#endif
#ifdef NS_IMSGSENDREPORT_IID
    { &kMsgSendReportIID, "NS_IMSGSENDREPORT_IID" },
#endif
#ifdef NS_IMSGSIGNATURE_IID
    { &kMsgSignatureIID, "NS_IMSGSIGNATURE_IID" },
#endif
#ifdef NS_IMSGSMIMECOMPFIELDS_IID
    { &kMsgSMIMECompFieldsIID, "NS_IMSGSMIMECOMPFIELDS_IID" },
#endif
#ifdef NS_IMSGSMIMEHEADERSINK_IID
    { &kMsgSMIMEHeaderSinkIID, "NS_IMSGSMIMEHEADERSINK_IID" },
#endif
#ifdef NS_IMSGSTATUSFEEDBACK_IID
    { &kMsgStatusFeedbackIID, "NS_IMSGSTATUSFEEDBACK_IID" },
#endif
#ifdef NS_IMSGSTRINGSERVICE_IID
    { &kMsgStringServiceIID, "NS_IMSGSTRINGSERVICE_IID" },
#endif
#ifdef NS_IMSGTHREAD_IID
    { &kMsgThreadIID, "NS_IMSGTHREAD_IID" },
#endif
#ifdef NS_IMSGVCARD_IID
    { &kMsgVCardIID, "NS_IMSGVCARD_IID" },
#endif
#ifdef NS_IMSGWINDOW_IID
    { &kMsgWindowIID, "NS_IMSGWINDOW_IID" },
#endif
#ifdef NS_IMULTIPARTCHANNEL_IID
    { &kMultiPartChannelIID, "NS_IMULTIPARTCHANNEL_IID" },
#endif
#ifdef NS_IMULTIPLEXINPUTSTREAM_IID
    { &kMultiplexInputStreamIID, "NS_IMULTIPLEXINPUTSTREAM_IID" },
#endif
#ifdef NS_INATIVEAPPSUPPORT_IID
    { &kNativeAppSupportIID, "NS_INATIVEAPPSUPPORT_IID" },
#endif
#ifdef NS_INATIVECOMPONENTLOADER_IID
    { &kNativeComponentLoaderIID, "NS_INATIVECOMPONENTLOADER_IID" },
#endif
#ifdef NS_INATIVESCROLLBAR_IID
    { &kNativeScrollbarIID, "NS_INATIVESCROLLBAR_IID" },
#endif
#ifdef NS_INETMODREGENTRY_IID
    { &kNetModRegEntryIID, "NS_INETMODREGENTRY_IID" },
#endif
#ifdef NS_INETMODULEMGR_IID
    { &kNetModuleMgrIID, "NS_INETMODULEMGR_IID" },
#endif
#ifdef NS_INETNOTIFY_IID
    { &kNetNotifyIID, "NS_INETNOTIFY_IID" },
#endif
#ifdef NS_INEWSDATABASE_IID
    { &kNewsDatabaseIID, "NS_INEWSDATABASE_IID" },
#endif
#ifdef NS_INEWSDOWNLOADDIALOGARGS_IID
    { &kNewsDownloadDialogArgsIID, "NS_INEWSDOWNLOADDIALOGARGS_IID" },
#endif
#ifdef NS_INNTPARTICLELIST_IID
    { &kNNTPArticleListIID, "NS_INNTPARTICLELIST_IID" },
#endif
#ifdef NS_INNTPINCOMINGSERVER_IID
    { &kNntpIncomingServerIID, "NS_INNTPINCOMINGSERVER_IID" },
#endif
#ifdef NS_INNTPNEWSGROUPLIST_IID
    { &kNNTPNewsgroupListIID, "NS_INNTPNEWSGROUPLIST_IID" },
#endif
#ifdef NS_INNTPNEWSGROUPPOST_IID
    { &kNNTPNewsgroupPostIID, "NS_INNTPNEWSGROUPPOST_IID" },
#endif
#ifdef NS_INNTPPROTOCOL_IID
    { &kNNTPProtocolIID, "NS_INNTPPROTOCOL_IID" },
#endif
#ifdef NS_INNTPSERVICE_IID
    { &kNntpServiceIID, "NS_INNTPSERVICE_IID" },
#endif
#ifdef NS_INNTPURL_IID
    { &kNntpUrlIID, "NS_INNTPURL_IID" },
#endif
#ifdef NS_INOINCOMINGSERVER_IID
    { &kNoIncomingServerIID, "NS_INOINCOMINGSERVER_IID" },
#endif
#ifdef NS_INONESERVICE_IID
    { &kNoneServiceIID, "NS_INONESERVICE_IID" },
#endif
#ifdef NS_INSSCERTCACHE_IID
    { &kNSSCertCacheIID, "NS_INSSCERTCACHE_IID" },
#endif
#ifdef NS_IOBJECTINPUTSTREAM_IID
    { &kObjectInputStreamIID, "NS_IOBJECTINPUTSTREAM_IID" },
#endif
#ifdef NS_IOBJECTOUTPUTSTREAM_IID
    { &kObjectOutputStreamIID, "NS_IOBJECTOUTPUTSTREAM_IID" },
#endif
#ifdef NS_IOBSERVER_IID
    { &kObserverIID, "NS_IOBSERVER_IID" },
#endif
#ifdef NS_IOBSERVERSERVICE_IID
    { &kObserverServiceIID, "NS_IOBSERVERSERVICE_IID" },
#endif
#ifdef NS_IOCSPRESPONDER_IID
    { &kOCSPResponderIID, "NS_IOCSPRESPONDER_IID" },
#endif
#ifdef NS_IOUTPUTSTREAM_IID
    { &kOutputStreamIID, "NS_IOUTPUTSTREAM_IID" },
#endif
#ifdef NS_IPASSWORD_IID
    { &kPasswordIID, "NS_IPASSWORD_IID" },
#endif
#ifdef NS_IPASSWORDMANAGER_IID
    { &kPasswordManagerIID, "NS_IPASSWORDMANAGER_IID" },
#endif
#ifdef NS_IPASSWORDMANAGERINTERNAL_IID
    { &kPasswordManagerInternalIID, "NS_IPASSWORDMANAGERINTERNAL_IID" },
#endif
#ifdef NS_IPASSWORDSINK_IID
    { &kPasswordSinkIID, "NS_IPASSWORDSINK_IID" },
#endif
#ifdef NS_IPERMISSION_IID
    { &kPermissionIID, "NS_IPERMISSION_IID" },
#endif
#ifdef NS_IPERMISSIONMANAGER_IID
    { &kPermissionManagerIID, "NS_IPERMISSIONMANAGER_IID" },
#endif
#ifdef NS_IPERSISTENTPROPERTIES2_IID
    { &kPersistentProperties2IID, "NS_IPERSISTENTPROPERTIES2_IID" },
#endif
#ifdef NS_IPHONETIC_IID
    { &kPhoneticIID, "NS_IPHONETIC_IID" },
#endif
#ifdef NS_IPIPE_IID
    { &kPipeIID, "NS_IPIPE_IID" },
#endif
#ifdef NS_IPK11TOKEN_IID
    { &kPK11TokenIID, "NS_IPK11TOKEN_IID" },
#endif
#ifdef NS_IPK11TOKENDB_IID
    { &kPK11TokenDBIID, "NS_IPK11TOKENDB_IID" },
#endif
#ifdef NS_IPKCS11MODULE_IID
    { &kPKCS11ModuleIID, "NS_IPKCS11MODULE_IID" },
#endif
#ifdef NS_IPKCS11MODULEDB_IID
    { &kPKCS11ModuleDBIID, "NS_IPKCS11MODULEDB_IID" },
#endif
#ifdef NS_IPKCS11SLOT_IID
    { &kPKCS11SlotIID, "NS_IPKCS11SLOT_IID" },
#endif
#ifdef NS_IPKIPARAMBLOCK_IID
    { &kPKIParamBlockIID, "NS_IPKIPARAMBLOCK_IID" },
#endif
#ifdef NS_IPLAINTEXTEDITOR_IID
    { &kPlaintextEditorIID, "NS_IPLAINTEXTEDITOR_IID" },
#endif
#ifdef NS_IPLUGIN_IID
    { &kPluginIID, "NS_IPLUGIN_IID" },
#endif
#ifdef NS_IPLUGINHOST_IID
    { &kPluginHostIID, "NS_IPLUGINHOST_IID" },
#endif
#ifdef NS_IPLUGININPUTSTREAM_IID
    { &kPluginInputStreamIID, "NS_IPLUGININPUTSTREAM_IID" },
#endif
#ifdef NS_IPLUGININSTANCE_IID
    { &kPluginInstanceIID, "NS_IPLUGININSTANCE_IID" },
#endif
#ifdef NS_IPLUGININSTANCEOWNER_IID
    { &kPluginInstanceOwnerIID, "NS_IPLUGININSTANCEOWNER_IID" },
#endif
#ifdef NS_IPLUGININSTANCEPEER_IID
    { &kPluginInstancePeerIID, "NS_IPLUGININSTANCEPEER_IID" },
#endif
#ifdef NS_IPLUGININSTANCEPEER2_IID
    { &kPluginInstancePeer2IID, "NS_IPLUGININSTANCEPEER2_IID" },
#endif
#ifdef NS_IPLUGINMANAGER_IID
    { &kPluginManagerIID, "NS_IPLUGINMANAGER_IID" },
#endif
#ifdef NS_IPLUGINMANAGER2_IID
    { &kPluginManager2IID, "NS_IPLUGINMANAGER2_IID" },
#endif
#ifdef NS_IPLUGINSTREAMINFO_IID
    { &kPluginStreamInfoIID, "NS_IPLUGINSTREAMINFO_IID" },
#endif
#ifdef NS_IPLUGINSTREAMLISTENER_IID
    { &kPluginStreamListenerIID, "NS_IPLUGINSTREAMLISTENER_IID" },
#endif
#ifdef NS_IPLUGINTAGINFO_IID
    { &kPluginTagInfoIID, "NS_IPLUGINTAGINFO_IID" },
#endif
#ifdef NS_IPLUGINTAGINFO2_IID
    { &kPluginTagInfo2IID, "NS_IPLUGINTAGINFO2_IID" },
#endif
#ifdef NS_IPLUGINVIEWER_IID
    { &kPluginViewerIID, "NS_IPLUGINVIEWER_IID" },
#endif
#ifdef NS_IPOP3INCOMINGSERVER_IID
    { &kPop3IncomingServerIID, "NS_IPOP3INCOMINGSERVER_IID" },
#endif
#ifdef NS_IPOP3SERVICE_IID
    { &kPop3ServiceIID, "NS_IPOP3SERVICE_IID" },
#endif
#ifdef NS_IPOP3SINK_IID
    { &kPop3SinkIID, "NS_IPOP3SINK_IID" },
#endif
#ifdef NS_IPOP3URL_IID
    { &kPop3URLIID, "NS_IPOP3URL_IID" },
#endif
#ifdef NS_IPOPUPBOXOBJECT_IID
    { &kPopupBoxObjectIID, "NS_IPOPUPBOXOBJECT_IID" },
#endif
#ifdef NS_IPOPUPWINDOWMANAGER_IID
    { &kPopupWindowManagerIID, "NS_IPOPUPWINDOWMANAGER_IID" },
#endif
#ifdef NS_IPREF_IID
    { &kPrefIID, "NS_IPREF_IID" },
#endif
#ifdef NS_IPREFBRANCH_IID
    { &kPrefBranchIID, "NS_IPREFBRANCH_IID" },
#endif
#ifdef NS_IPREFBRANCHINTERNAL_IID
    { &kPrefBranchInternalIID, "NS_IPREFBRANCHINTERNAL_IID" },
#endif
#ifdef NS_IPREFETCHSERVICE_IID
    { &kPrefetchServiceIID, "NS_IPREFETCHSERVICE_IID" },
#endif
#ifdef NS_IPREFLOCALIZEDSTRING_IID
    { &kPrefLocalizedStringIID, "NS_IPREFLOCALIZEDSTRING_IID" },
#endif
#ifdef NS_IPREFMIGRATION_IID
    { &kPrefMigrationIID, "NS_IPREFMIGRATION_IID" },
#endif
#ifdef NS_IPREFMIGRATIONPROGRESS_IID
    { &kPrefMigrationProgressIID, "NS_IPREFMIGRATIONPROGRESS_IID" },
#endif
#ifdef NS_IPREFSERVICE_IID
    { &kPrefServiceIID, "NS_IPREFSERVICE_IID" },
#endif
#ifdef NS_IPRINCIPAL_IID
    { &kPrincipalIID, "NS_IPRINCIPAL_IID" },
#endif
#ifdef NS_IPRINTINGPROMPT_IID
    { &kPrintingPromptIID, "NS_IPRINTINGPROMPT_IID" },
#endif
#ifdef NS_IPRINTINGPROMPTSERVICE_IID
    { &kPrintingPromptServiceIID, "NS_IPRINTINGPROMPTSERVICE_IID" },
#endif
#ifdef NS_IPRINTOPTIONS_IID
    { &kPrintOptionsIID, "NS_IPRINTOPTIONS_IID" },
#endif
#ifdef NS_IPRINTPROGRESS_IID
    { &kPrintProgressIID, "NS_IPRINTPROGRESS_IID" },
#endif
#ifdef NS_IPRINTPROGRESSPARAMS_IID
    { &kPrintProgressParamsIID, "NS_IPRINTPROGRESSPARAMS_IID" },
#endif
#ifdef NS_IPRINTSESSION_IID
    { &kPrintSessionIID, "NS_IPRINTSESSION_IID" },
#endif
#ifdef NS_IPRINTSETTINGS_IID
    { &kPrintSettingsIID, "NS_IPRINTSETTINGS_IID" },
#endif
#ifdef NS_IPRINTSETTINGSSERVICE_IID
    { &kPrintSettingsServiceIID, "NS_IPRINTSETTINGSSERVICE_IID" },
#endif
#ifdef NS_IPRINTSTATUSFEEDBACK_IID
    { &kPrintStatusFeedbackIID, "NS_IPRINTSTATUSFEEDBACK_IID" },
#endif
#ifdef NS_IPROCESS_IID
    { &kProcessIID, "NS_IPROCESS_IID" },
#endif
#ifdef NS_IPROFILE_IID
    { &kProfileIID, "NS_IPROFILE_IID" },
#endif
#ifdef NS_IPROFILECHANGESTATUS_IID
    { &kProfileChangeStatusIID, "NS_IPROFILECHANGESTATUS_IID" },
#endif
#ifdef NS_IPROFILEINTERNAL_IID
    { &kProfileInternalIID, "NS_IPROFILEINTERNAL_IID" },
#endif
#ifdef NS_IPROFILESTARTUPLISTENER_IID
    { &kProfileStartupListenerIID, "NS_IPROFILESTARTUPLISTENER_IID" },
#endif
#ifdef NS_IPROGRAMMINGLANGUAGE_IID
    { &kProgrammingLanguageIID, "NS_IPROGRAMMINGLANGUAGE_IID" },
#endif
#ifdef NS_IPROGRESSDIALOG_IID
    { &kProgressDialogIID, "NS_IPROGRESSDIALOG_IID" },
#endif
#ifdef NS_IPROGRESSEVENTSINK_IID
    { &kProgressEventSinkIID, "NS_IPROGRESSEVENTSINK_IID" },
#endif
#ifdef NS_IPROMPT_IID
    { &kPromptIID, "NS_IPROMPT_IID" },
#endif
#ifdef NS_IPROMPTSERVICE_IID
    { &kPromptServiceIID, "NS_IPROMPTSERVICE_IID" },
#endif
#ifdef NS_IPROPERTIES_IID
    { &kPropertiesIID, "NS_IPROPERTIES_IID" },
#endif
#ifdef NS_IPROPERTYBAG_IID
    { &kPropertyBagIID, "NS_IPROPERTYBAG_IID" },
#endif
#ifdef NS_IPROTOCOLHANDLER_IID
    { &kProtocolHandlerIID, "NS_IPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IPROTOCOLPROXYSERVICE_IID
    { &kProtocolProxyServiceIID, "NS_IPROTOCOLPROXYSERVICE_IID" },
#endif
#ifdef NS_IPROXIEDPROTOCOLHANDLER_IID
    { &kProxiedProtocolHandlerIID, "NS_IPROXIEDPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IPROXY_IID
    { &kProxyIID, "NS_IPROXY_IID" },
#endif
#ifdef NS_IPROXYAUTOCONFIG_IID
    { &kProxyAutoConfigIID, "NS_IPROXYAUTOCONFIG_IID" },
#endif
#ifdef NS_IPROXYCREATEINSTANCE_IID
    { &kProxyCreateInstanceIID, "NS_IPROXYCREATEINSTANCE_IID" },
#endif
#ifdef NS_IPROXYINFO_IID
    { &kProxyInfoIID, "NS_IPROXYINFO_IID" },
#endif
#ifdef NS_IPROXYOBJECTMANAGER_IID
    { &kProxyObjectManagerIID, "NS_IPROXYOBJECTMANAGER_IID" },
#endif
#ifdef NS_IRDFCOMPOSITEDATASOURCE_IID
    { &kRDFCompositeDataSourceIID, "NS_IRDFCOMPOSITEDATASOURCE_IID" },
#endif
#ifdef NS_IRDFCONTAINER_IID
    { &kRDFContainerIID, "NS_IRDFCONTAINER_IID" },
#endif
#ifdef NS_IRDFCONTAINERUTILS_IID
    { &kRDFContainerUtilsIID, "NS_IRDFCONTAINERUTILS_IID" },
#endif
#ifdef NS_IRDFDATASOURCE_IID
    { &kRDFDataSourceIID, "NS_IRDFDATASOURCE_IID" },
#endif
#ifdef NS_IRDFDELEGATEFACTORY_IID
    { &kRDFDelegateFactoryIID, "NS_IRDFDELEGATEFACTORY_IID" },
#endif
#ifdef NS_IRDFINMEMORYDATASOURCE_IID
    { &kRDFInMemoryDataSourceIID, "NS_IRDFINMEMORYDATASOURCE_IID" },
#endif
#ifdef NS_IRDFLITERAL_IID
    { &kRDFLiteralIID, "NS_IRDFLITERAL_IID" },
#endif
#ifdef NS_IRDFNODE_IID
    { &kRDFNodeIID, "NS_IRDFNODE_IID" },
#endif
#ifdef NS_IRDFOBSERVER_IID
    { &kRDFObserverIID, "NS_IRDFOBSERVER_IID" },
#endif
#ifdef NS_IRDFPURGEABLEDATASOURCE_IID
    { &kRDFPurgeableDataSourceIID, "NS_IRDFPURGEABLEDATASOURCE_IID" },
#endif
#ifdef NS_IRDFREMOTEDATASOURCE_IID
    { &kRDFRemoteDataSourceIID, "NS_IRDFREMOTEDATASOURCE_IID" },
#endif
#ifdef NS_IRDFRESOURCE_IID
    { &kRDFResourceIID, "NS_IRDFRESOURCE_IID" },
#endif
#ifdef NS_IRDFSERVICE_IID
    { &kRDFServiceIID, "NS_IRDFSERVICE_IID" },
#endif
#ifdef NS_IRDFXMLPARSER_IID
    { &kRDFXMLParserIID, "NS_IRDFXMLPARSER_IID" },
#endif
#ifdef NS_IRDFXMLSERIALIZER_IID
    { &kRDFXMLSerializerIID, "NS_IRDFXMLSERIALIZER_IID" },
#endif
#ifdef NS_IRDFXMLSINK_IID
    { &kRDFXMLSinkIID, "NS_IRDFXMLSINK_IID" },
#endif
#ifdef NS_IRDFXMLSOURCE_IID
    { &kRDFXMLSourceIID, "NS_IRDFXMLSOURCE_IID" },
#endif
#ifdef NS_IREADCONFIG_IID
    { &kReadConfigIID, "NS_IREADCONFIG_IID" },
#endif
#ifdef NS_IRECYCLINGALLOCATOR_IID
    { &kRecyclingAllocatorIID, "NS_IRECYCLINGALLOCATOR_IID" },
#endif
#ifdef NS_IREFRESHURI_IID
    { &kRefreshURIIID, "NS_IREFRESHURI_IID" },
#endif
#ifdef NS_IREGISTRY_IID
    { &kRegistryIID, "NS_IREGISTRY_IID" },
#endif
#ifdef NS_IRELATIVEFILEPREF_IID
    { &kRelativeFilePrefIID, "NS_IRELATIVEFILEPREF_IID" },
#endif
#ifdef NS_IREQUEST_IID
    { &kRequestIID, "NS_IREQUEST_IID" },
#endif
#ifdef NS_IREQUESTOBSERVER_IID
    { &kRequestObserverIID, "NS_IREQUESTOBSERVER_IID" },
#endif
#ifdef NS_IREQUESTOBSERVERPROXY_IID
    { &kRequestObserverProxyIID, "NS_IREQUESTOBSERVERPROXY_IID" },
#endif
#ifdef NS_IRESPROTOCOLHANDLER_IID
    { &kResProtocolHandlerIID, "NS_IRESPROTOCOLHANDLER_IID" },
#endif
#ifdef NS_IRESUMABLECHANNEL_IID
    { &kResumableChannelIID, "NS_IRESUMABLECHANNEL_IID" },
#endif
#ifdef NS_IRESUMABLEENTITYID_IID
    { &kResumableEntityIDIID, "NS_IRESUMABLEENTITYID_IID" },
#endif
#ifdef NS_IROLLUPLISTENER_IID
    { &kRollupListenerIID, "NS_IROLLUPLISTENER_IID" },
#endif
#ifdef NS_IRUNNABLE_IID
    { &kRunnableIID, "NS_IRUNNABLE_IID" },
#endif
#ifdef NS_ISAMPLE_IID
    { &kSampleIID, "NS_ISAMPLE_IID" },
#endif
#ifdef NS_ISAVEASCHARSET_IID
    { &kSaveAsCharsetIID, "NS_ISAVEASCHARSET_IID" },
#endif
#ifdef NS_ISCHEMA_IID
    { &kSchemaIID, "NS_ISCHEMA_IID" },
#endif
#ifdef NS_ISCHEMALOADER_IID
    { &kSchemaLoaderIID, "NS_ISCHEMALOADER_IID" },
#endif
#ifdef NS_ISCREEN_IID
    { &kScreenIID, "NS_ISCREEN_IID" },
#endif
#ifdef NS_ISCREENMANAGER_IID
    { &kScreenManagerIID, "NS_ISCREENMANAGER_IID" },
#endif
#ifdef NS_ISCRIPTABLEDATEFORMAT_IID
    { &kScriptableDateFormatIID, "NS_ISCRIPTABLEDATEFORMAT_IID" },
#endif
#ifdef NS_ISCRIPTABLEINPUTSTREAM_IID
    { &kScriptableInputStreamIID, "NS_ISCRIPTABLEINPUTSTREAM_IID" },
#endif
#ifdef NS_ISCRIPTABLEINTERFACES_IID
    { &kScriptableInterfacesIID, "NS_ISCRIPTABLEINTERFACES_IID" },
#endif
#ifdef NS_ISCRIPTABLEPLUGIN_IID
    { &kScriptablePluginIID, "NS_ISCRIPTABLEPLUGIN_IID" },
#endif
#ifdef NS_ISCRIPTABLEREGION_IID
    { &kScriptableRegionIID, "NS_ISCRIPTABLEREGION_IID" },
#endif
#ifdef NS_ISCRIPTABLEUCONV_IID
    { &kScriptableUConvIID, "NS_ISCRIPTABLEUCONV_IID" },
#endif
#ifdef NS_ISCRIPTCONTEXTOWNER_IID
    { &kScriptContextOwnerIID, "NS_ISCRIPTCONTEXTOWNER_IID" },
#endif
#ifdef NS_ISCRIPTERROR_IID
    { &kScriptErrorIID, "NS_ISCRIPTERROR_IID" },
#endif
#ifdef NS_ISCRIPTEVENTHANDLER_IID
    { &kScriptEventHandlerIID, "NS_ISCRIPTEVENTHANDLER_IID" },
#endif
#ifdef NS_ISCRIPTEVENTMANAGER_IID
    { &kScriptEventManagerIID, "NS_ISCRIPTEVENTMANAGER_IID" },
#endif
#ifdef NS_ISCRIPTGLOBALOBJECTOWNER_IID
    { &kScriptGlobalObjectOwnerIID, "NS_ISCRIPTGLOBALOBJECTOWNER_IID" },
#endif
#ifdef NS_ISCRIPTLOADER_IID
    { &kScriptLoaderIID, "NS_ISCRIPTLOADER_IID" },
#endif
#ifdef NS_ISCRIPTLOADEROBSERVER_IID
    { &kScriptLoaderObserverIID, "NS_ISCRIPTLOADEROBSERVER_IID" },
#endif
#ifdef NS_ISCRIPTSECURITYMANAGER_IID
    { &kScriptSecurityManagerIID, "NS_ISCRIPTSECURITYMANAGER_IID" },
#endif
#ifdef NS_ISCROLLABLE_IID
    { &kScrollableIID, "NS_ISCROLLABLE_IID" },
#endif
#ifdef NS_ISCROLLBOXOBJECT_IID
    { &kScrollBoxObjectIID, "NS_ISCROLLBOXOBJECT_IID" },
#endif
#ifdef NS_ISEARCHCONTEXT_IID
    { &kSearchContextIID, "NS_ISEARCHCONTEXT_IID" },
#endif
#ifdef NS_ISEARCHSERVICE_IID
    { &kSearchServiceIID, "NS_ISEARCHSERVICE_IID" },
#endif
#ifdef NS_ISECRETDECODERRING_IID
    { &kSecretDecoderRingIID, "NS_ISECRETDECODERRING_IID" },
#endif
#ifdef NS_ISECUREBROWSERUI_IID
    { &kSecureBrowserUIIID, "NS_ISECUREBROWSERUI_IID" },
#endif
#ifdef NS_ISECURITYCHECKEDCOMPONENT_IID
    { &kSecurityCheckedComponentIID, "NS_ISECURITYCHECKEDCOMPONENT_IID" },
#endif
#ifdef NS_ISECURITYEVENTSINK_IID
    { &kSecurityEventSinkIID, "NS_ISECURITYEVENTSINK_IID" },
#endif
#ifdef NS_ISECURITYPREF_IID
    { &kSecurityPrefIID, "NS_ISECURITYPREF_IID" },
#endif
#ifdef NS_ISECURITYWARNINGDIALOGS_IID
    { &kSecurityWarningDialogsIID, "NS_ISECURITYWARNINGDIALOGS_IID" },
#endif
#ifdef NS_ISEEKABLESTREAM_IID
    { &kSeekableStreamIID, "NS_ISEEKABLESTREAM_IID" },
#endif
#ifdef NS_ISELECTELEMENT_IID
    { &kSelectElementIID, "NS_ISELECTELEMENT_IID" },
#endif
#ifdef NS_ISELECTION_IID
    { &kSelectionIID, "NS_ISELECTION_IID" },
#endif
#ifdef NS_ISELECTIONCONTROLLER_IID
    { &kSelectionControllerIID, "NS_ISELECTIONCONTROLLER_IID" },
#endif
#ifdef NS_ISELECTIONDISPLAY_IID
    { &kSelectionDisplayIID, "NS_ISELECTIONDISPLAY_IID" },
#endif
#ifdef NS_ISELECTIONIMAGESERVICE_IID
    { &kSelectionImageServiceIID, "NS_ISELECTIONIMAGESERVICE_IID" },
#endif
#ifdef NS_ISELECTIONLISTENER_IID
    { &kSelectionListenerIID, "NS_ISELECTIONLISTENER_IID" },
#endif
#ifdef NS_ISELECTIONPRIVATE_IID
    { &kSelectionPrivateIID, "NS_ISELECTIONPRIVATE_IID" },
#endif
#ifdef NS_ISEMANTICUNITSCANNER_IID
    { &kSemanticUnitScannerIID, "NS_ISEMANTICUNITSCANNER_IID" },
#endif
#ifdef NS_ISERIALIZABLE_IID
    { &kSerializableIID, "NS_ISERIALIZABLE_IID" },
#endif
#ifdef NS_ISERVICEMANAGER_IID
    { &kServiceManagerIID, "NS_ISERVICEMANAGER_IID" },
#endif
#ifdef NS_ISHCONTAINER_IID
    { &kSHContainerIID, "NS_ISHCONTAINER_IID" },
#endif
#ifdef NS_ISHENTRY_IID
    { &kSHEntryIID, "NS_ISHENTRY_IID" },
#endif
#ifdef NS_ISHISTORY_IID
    { &kSHistoryIID, "NS_ISHISTORY_IID" },
#endif
#ifdef NS_ISHISTORYINTERNAL_IID
    { &kSHistoryInternalIID, "NS_ISHISTORYINTERNAL_IID" },
#endif
#ifdef NS_ISHISTORYLISTENER_IID
    { &kSHistoryListenerIID, "NS_ISHISTORYLISTENER_IID" },
#endif
#ifdef NS_ISHTRANSACTION_IID
    { &kSHTransactionIID, "NS_ISHTRANSACTION_IID" },
#endif
#ifdef NS_ISIDEBAR_IID
    { &kSidebarIID, "NS_ISIDEBAR_IID" },
#endif
#ifdef NS_ISIGNATUREVERIFIER_IID
    { &kSignatureVerifierIID, "NS_ISIGNATUREVERIFIER_IID" },
#endif
#ifdef NS_ISIGNONVIEWER_IID
    { &kSignonViewerIID, "NS_ISIGNONVIEWER_IID" },
#endif
#ifdef NS_ISIMPLEENUMERATOR_IID
    { &kSimpleEnumeratorIID, "NS_ISIMPLEENUMERATOR_IID" },
#endif
#ifdef NS_ISIMPLESTREAMLISTENER_IID
    { &kSimpleStreamListenerIID, "NS_ISIMPLESTREAMLISTENER_IID" },
#endif
#ifdef NS_ISMIMECERT_IID
    { &kSMimeCertIID, "NS_ISMIMECERT_IID" },
#endif
#ifdef NS_ISMIMEJSHELPER_IID
    { &kSMimeJSHelperIID, "NS_ISMIMEJSHELPER_IID" },
#endif
#ifdef NS_ISMTPSERVER_IID
    { &kSmtpServerIID, "NS_ISMTPSERVER_IID" },
#endif
#ifdef NS_ISMTPSERVICE_IID
    { &kSmtpServiceIID, "NS_ISMTPSERVICE_IID" },
#endif
#ifdef NS_ISMTPURL_IID
    { &kSmtpUrlIID, "NS_ISMTPURL_IID" },
#endif
#ifdef NS_ISOAPATTACHMENTS_IID
    { &kSOAPAttachmentsIID, "NS_ISOAPATTACHMENTS_IID" },
#endif
#ifdef NS_ISOAPBLOCK_IID
    { &kSOAPBlockIID, "NS_ISOAPBLOCK_IID" },
#endif
#ifdef NS_ISOAPCALL_IID
    { &kSOAPCallIID, "NS_ISOAPCALL_IID" },
#endif
#ifdef NS_ISOAPCALLCOMPLETION_IID
    { &kSOAPCallCompletionIID, "NS_ISOAPCALLCOMPLETION_IID" },
#endif
#ifdef NS_ISOAPDECODER_IID
    { &kSOAPDecoderIID, "NS_ISOAPDECODER_IID" },
#endif
#ifdef NS_ISOAPENCODER_IID
    { &kSOAPEncoderIID, "NS_ISOAPENCODER_IID" },
#endif
#ifdef NS_ISOAPENCODING_IID
    { &kSOAPEncodingIID, "NS_ISOAPENCODING_IID" },
#endif
#ifdef NS_ISOAPFAULT_IID
    { &kSOAPFaultIID, "NS_ISOAPFAULT_IID" },
#endif
#ifdef NS_ISOAPHEADERBLOCK_IID
    { &kSOAPHeaderBlockIID, "NS_ISOAPHEADERBLOCK_IID" },
#endif
#ifdef NS_ISOAPMESSAGE_IID
    { &kSOAPMessageIID, "NS_ISOAPMESSAGE_IID" },
#endif
#ifdef NS_ISOAPPARAMETER_IID
    { &kSOAPParameterIID, "NS_ISOAPPARAMETER_IID" },
#endif
#ifdef NS_ISOAPPROPERTYBAGMUTATOR_IID
    { &kSOAPPropertyBagMutatorIID, "NS_ISOAPPROPERTYBAGMUTATOR_IID" },
#endif
#ifdef NS_ISOAPRESPONSE_IID
    { &kSOAPResponseIID, "NS_ISOAPRESPONSE_IID" },
#endif
#ifdef NS_ISOAPRESPONSELISTENER_IID
    { &kSOAPResponseListenerIID, "NS_ISOAPRESPONSELISTENER_IID" },
#endif
#ifdef NS_ISOAPSERVICE_IID
    { &kSOAPServiceIID, "NS_ISOAPSERVICE_IID" },
#endif
#ifdef NS_ISOAPSERVICEREGISTRY_IID
    { &kSOAPServiceRegistryIID, "NS_ISOAPSERVICEREGISTRY_IID" },
#endif
#ifdef NS_ISOAPTRANSPORT_IID
    { &kSOAPTransportIID, "NS_ISOAPTRANSPORT_IID" },
#endif
#ifdef NS_ISOAPTRANSPORTLISTENER_IID
    { &kSOAPTransportListenerIID, "NS_ISOAPTRANSPORTLISTENER_IID" },
#endif
#ifdef NS_ISOCKETPROVIDER_IID
    { &kSocketProviderIID, "NS_ISOCKETPROVIDER_IID" },
#endif
#ifdef NS_ISOCKETPROVIDERSERVICE_IID
    { &kSocketProviderServiceIID, "NS_ISOCKETPROVIDERSERVICE_IID" },
#endif
#ifdef NS_ISOCKETTRANSPORT_IID
    { &kSocketTransportIID, "NS_ISOCKETTRANSPORT_IID" },
#endif
#ifdef NS_ISOCKETTRANSPORTSERVICE_IID
    { &kSocketTransportServiceIID, "NS_ISOCKETTRANSPORTSERVICE_IID" },
#endif
#ifdef NS_ISOCKS4SOCKETINFO_IID
    { &kSOCKS4SocketInfoIID, "NS_ISOCKS4SOCKETINFO_IID" },
#endif
#ifdef NS_ISOCKS4SOCKETPROVIDER_IID
    { &kSOCKS4SocketProviderIID, "NS_ISOCKS4SOCKETPROVIDER_IID" },
#endif
#ifdef NS_ISOCKSSOCKETINFO_IID
    { &kSOCKSSocketInfoIID, "NS_ISOCKSSOCKETINFO_IID" },
#endif
#ifdef NS_ISOCKSSOCKETPROVIDER_IID
    { &kSOCKSSocketProviderIID, "NS_ISOCKSSOCKETPROVIDER_IID" },
#endif
#ifdef NS_ISOUND_IID
    { &kSoundIID, "NS_ISOUND_IID" },
#endif
#ifdef NS_ISPAMSETTINGS_IID
    { &kSpamSettingsIID, "NS_ISPAMSETTINGS_IID" },
#endif
#ifdef NS_ISSLSOCKETCONTROL_IID
    { &kSSLSocketControlIID, "NS_ISSLSOCKETCONTROL_IID" },
#endif
#ifdef NS_ISSLSOCKETPROVIDER_IID
    { &kSSLSocketProviderIID, "NS_ISSLSOCKETPROVIDER_IID" },
#endif
#ifdef NS_ISSLSTATUS_IID
    { &kSSLStatusIID, "NS_ISSLSTATUS_IID" },
#endif
#ifdef NS_ISSLSTATUSPROVIDER_IID
    { &kSSLStatusProviderIID, "NS_ISSLSTATUSPROVIDER_IID" },
#endif
#ifdef NS_ISTANDARDURL_IID
    { &kStandardURLIID, "NS_ISTANDARDURL_IID" },
#endif
#ifdef NS_ISTORAGESTREAM_IID
    { &kStorageStreamIID, "NS_ISTORAGESTREAM_IID" },
#endif
#ifdef NS_ISTREAMBUFFERACCESS_IID
    { &kStreamBufferAccessIID, "NS_ISTREAMBUFFERACCESS_IID" },
#endif
#ifdef NS_ISTREAMCONVERTER_IID
    { &kStreamConverterIID, "NS_ISTREAMCONVERTER_IID" },
#endif
#ifdef NS_ISTREAMCONVERTERSERVICE_IID
    { &kStreamConverterServiceIID, "NS_ISTREAMCONVERTERSERVICE_IID" },
#endif
#ifdef NS_ISTREAMLISTENER_IID
    { &kStreamListenerIID, "NS_ISTREAMLISTENER_IID" },
#endif
#ifdef NS_ISTREAMLISTENERPROXY_IID
    { &kStreamListenerProxyIID, "NS_ISTREAMLISTENERPROXY_IID" },
#endif
#ifdef NS_ISTREAMLISTENERTEE_IID
    { &kStreamListenerTeeIID, "NS_ISTREAMLISTENERTEE_IID" },
#endif
#ifdef NS_ISTREAMLOADER_IID
    { &kStreamLoaderIID, "NS_ISTREAMLOADER_IID" },
#endif
#ifdef NS_ISTREAMTRANSPORTSERVICE_IID
    { &kStreamTransportServiceIID, "NS_ISTREAMTRANSPORTSERVICE_IID" },
#endif
#ifdef NS_ISTRINGBUNDLE_IID
    { &kStringBundleIID, "NS_ISTRINGBUNDLE_IID" },
#endif
#ifdef NS_ISTRINGBUNDLEOVERRIDE_IID
    { &kStringBundleOverrideIID, "NS_ISTRINGBUNDLEOVERRIDE_IID" },
#endif
#ifdef NS_ISTRINGSERVICE_IID
    { &kStringServiceIID, "NS_ISTRINGSERVICE_IID" },
#endif
#ifdef NS_ISTRINGSTREAM_IID
    { &kStringStreamIID, "NS_ISTRINGSTREAM_IID" },
#endif
#ifdef NS_ISUBSCRIBABLESERVER_IID
    { &kSubscribableServerIID, "NS_ISUBSCRIBABLESERVER_IID" },
#endif
#ifdef NS_ISUPPORTS_IID
    { &kSupportsIID, "NS_ISUPPORTS_IID" },
#endif
#ifdef NS_ISUPPORTSARRAY_IID
    { &kSupportsArrayIID, "NS_ISUPPORTSARRAY_IID" },
#endif
#ifdef NS_ISUPPORTSITERATORS_IID
    { &kSupportsIteratorsIID, "NS_ISUPPORTSITERATORS_IID" },
#endif
#ifdef NS_ISUPPORTSPRIMITIVES_IID
    { &kSupportsPrimitivesIID, "NS_ISUPPORTSPRIMITIVES_IID" },
#endif
#ifdef NS_ISYNCLOADDOMSERVICE_IID
    { &kSyncLoadDOMServiceIID, "NS_ISYNCLOADDOMSERVICE_IID" },
#endif
#ifdef NS_ITABLEEDITOR_IID
    { &kTableEditorIID, "NS_ITABLEEDITOR_IID" },
#endif
#ifdef NS_ITESTPROXY_IID
    { &kTestProxyIID, "NS_ITESTPROXY_IID" },
#endif
#ifdef NS_ITEXTAREAELEMENT_IID
    { &kTextAreaElementIID, "NS_ITEXTAREAELEMENT_IID" },
#endif
#ifdef NS_ITEXTSCROLL_IID
    { &kTextScrollIID, "NS_ITEXTSCROLL_IID" },
#endif
#ifdef NS_ITEXTSERVICESFILTER_IID
    { &kTextServicesFilterIID, "NS_ITEXTSERVICESFILTER_IID" },
#endif
#ifdef NS_ITEXTTOSUBURI_IID
    { &kTextToSubURIIID, "NS_ITEXTTOSUBURI_IID" },
#endif
#ifdef NS_ITHREAD_IID
    { &kThreadIID, "NS_ITHREAD_IID" },
#endif
#ifdef NS_ITHREADPOOL_IID
    { &kThreadPoolIID, "NS_ITHREADPOOL_IID" },
#endif
#ifdef NS_ITIMEBOMB_IID
    { &kTimeBombIID, "NS_ITIMEBOMB_IID" },
#endif
#ifdef NS_ITIMELINESERVICE_IID
    { &kTimelineServiceIID, "NS_ITIMELINESERVICE_IID" },
#endif
#ifdef NS_ITIMER_IID
    { &kTimerIID, "NS_ITIMER_IID" },
#endif
#ifdef NS_ITIMERECORDER_IID
    { &kTimeRecorderIID, "NS_ITIMERECORDER_IID" },
#endif
#ifdef NS_ITIMERINTERNAL_IID
    { &kTimerInternalIID, "NS_ITIMERINTERNAL_IID" },
#endif
#ifdef NS_ITIMERMANAGER_IID
    { &kTimerManagerIID, "NS_ITIMERMANAGER_IID" },
#endif
#ifdef NS_ITIMINGSERVICE_IID
    { &kTimingServiceIID, "NS_ITIMINGSERVICE_IID" },
#endif
#ifdef NS_ITOKENDIALOGS_IID
    { &kTokenDialogsIID, "NS_ITOKENDIALOGS_IID" },
#endif
#ifdef NS_ITOKENPASSWORDDIALOGS_IID
    { &kTokenPasswordDialogsIID, "NS_ITOKENPASSWORDDIALOGS_IID" },
#endif
#ifdef NS_ITOOLKIT_IID
    { &kToolkitIID, "NS_ITOOLKIT_IID" },
#endif
#ifdef NS_ITOOLTIPLISTENER_IID
    { &kTooltipListenerIID, "NS_ITOOLTIPLISTENER_IID" },
#endif
#ifdef NS_ITOOLTIPTEXTPROVIDER_IID
    { &kTooltipTextProviderIID, "NS_ITOOLTIPTEXTPROVIDER_IID" },
#endif
#ifdef NS_ITRANSACTION_IID
    { &kTransactionIID, "NS_ITRANSACTION_IID" },
#endif
#ifdef NS_ITRANSACTIONLIST_IID
    { &kTransactionListIID, "NS_ITRANSACTIONLIST_IID" },
#endif
#ifdef NS_ITRANSACTIONLISTENER_IID
    { &kTransactionListenerIID, "NS_ITRANSACTIONLISTENER_IID" },
#endif
#ifdef NS_ITRANSACTIONMANAGER_IID
    { &kTransactionManagerIID, "NS_ITRANSACTIONMANAGER_IID" },
#endif
#ifdef NS_ITRANSFERABLE_IID
    { &kTransferableIID, "NS_ITRANSFERABLE_IID" },
#endif
#ifdef NS_ITRANSPORT_IID
    { &kTransportIID, "NS_ITRANSPORT_IID" },
#endif
#ifdef NS_ITRANSPORTSECURITYINFO_IID
    { &kTransportSecurityInfoIID, "NS_ITRANSPORTSECURITYINFO_IID" },
#endif
#ifdef NS_ITREEBOXOBJECT_IID
    { &kTreeBoxObjectIID, "NS_ITREEBOXOBJECT_IID" },
#endif
#ifdef NS_ITREECONTENTVIEW_IID
    { &kTreeContentViewIID, "NS_ITREECONTENTVIEW_IID" },
#endif
#ifdef NS_ITREESELECTION_IID
    { &kTreeSelectionIID, "NS_ITREESELECTION_IID" },
#endif
#ifdef NS_ITREEVIEW_IID
    { &kTreeViewIID, "NS_ITREEVIEW_IID" },
#endif
#ifdef NS_ITXTTOHTMLCONV_IID
    { &kTXTToHTMLConvIID, "NS_ITXTTOHTMLCONV_IID" },
#endif
#ifdef NS_ITYPEAHEADFIND_IID
    { &kTypeAheadFindIID, "NS_ITYPEAHEADFIND_IID" },
#endif
#ifdef NS_IUNICHARSTREAMLOADER_IID
    { &kUnicharStreamLoaderIID, "NS_IUNICHARSTREAMLOADER_IID" },
#endif
#ifdef NS_IUNICODENORMALIZER_IID
    { &kUnicodeNormalizerIID, "NS_IUNICODENORMALIZER_IID" },
#endif
#ifdef NS_IUPLOADCHANNEL_IID
    { &kUploadChannelIID, "NS_IUPLOADCHANNEL_IID" },
#endif
#ifdef NS_IURI_IID
    { &kURIIID, "NS_IURI_IID" },
#endif
#ifdef NS_IURICHECKER_IID
    { &kURICheckerIID, "NS_IURICHECKER_IID" },
#endif
#ifdef NS_IURICONTENTLISTENER_IID
    { &kURIContentListenerIID, "NS_IURICONTENTLISTENER_IID" },
#endif
#ifdef NS_IURIFIXUP_IID
    { &kURIFixupIID, "NS_IURIFIXUP_IID" },
#endif
#ifdef NS_IURILOADER_IID
    { &kURILoaderIID, "NS_IURILOADER_IID" },
#endif
#ifdef NS_IURIREFOBJECT_IID
    { &kURIRefObjectIID, "NS_IURIREFOBJECT_IID" },
#endif
#ifdef NS_IURL_IID
    { &kURLIID, "NS_IURL_IID" },
#endif
#ifdef NS_IURLBARHISTORY_IID
    { &kUrlbarHistoryIID, "NS_IURLBARHISTORY_IID" },
#endif
#ifdef NS_IURLFETCHER_IID
    { &kURLFetcherIID, "NS_IURLFETCHER_IID" },
#endif
#ifdef NS_IURLLISTENER_IID
    { &kUrlListenerIID, "NS_IURLLISTENER_IID" },
#endif
#ifdef NS_IURLLISTENERMANAGER_IID
    { &kUrlListenerManagerIID, "NS_IURLLISTENERMANAGER_IID" },
#endif
#ifdef NS_IURLPARSER_IID
    { &kURLParserIID, "NS_IURLPARSER_IID" },
#endif
#ifdef NS_IUSERCERTPICKER_IID
    { &kUserCertPickerIID, "NS_IUSERCERTPICKER_IID" },
#endif
#ifdef NS_IUSERINFO_IID
    { &kUserInfoIID, "NS_IUSERINFO_IID" },
#endif
#ifdef NS_IVARIANT_IID
    { &kVariantIID, "NS_IVARIANT_IID" },
#endif
#ifdef NS_IVIEWSOURCECHANNEL_IID
    { &kViewSourceChannelIID, "NS_IVIEWSOURCECHANNEL_IID" },
#endif
#ifdef NS_IWALLETEDITOR_IID
    { &kWalletEditorIID, "NS_IWALLETEDITOR_IID" },
#endif
#ifdef NS_IWALLETPREVIEW_IID
    { &kWalletPreviewIID, "NS_IWALLETPREVIEW_IID" },
#endif
#ifdef NS_IWALLETSERVICE_IID
    { &kWalletServiceIID, "NS_IWALLETSERVICE_IID" },
#endif
#ifdef NS_IWEAKREFERENCE_IID
    { &kWeakReferenceIID, "NS_IWEAKREFERENCE_IID" },
#endif
#ifdef NS_IWEBBROWSER_IID
    { &kWebBrowserIID, "NS_IWEBBROWSER_IID" },
#endif
#ifdef NS_IWEBBROWSERCHROME_IID
    { &kWebBrowserChromeIID, "NS_IWEBBROWSERCHROME_IID" },
#endif
#ifdef NS_IWEBBROWSERCHROMEFOCUS_IID
    { &kWebBrowserChromeFocusIID, "NS_IWEBBROWSERCHROMEFOCUS_IID" },
#endif
#ifdef NS_IWEBBROWSERFIND_IID
    { &kWebBrowserFindIID, "NS_IWEBBROWSERFIND_IID" },
#endif
#ifdef NS_IWEBBROWSERFOCUS_IID
    { &kWebBrowserFocusIID, "NS_IWEBBROWSERFOCUS_IID" },
#endif
#ifdef NS_IWEBBROWSERPERSIST_IID
    { &kWebBrowserPersistIID, "NS_IWEBBROWSERPERSIST_IID" },
#endif
#ifdef NS_IWEBBROWSERPRINT_IID
    { &kWebBrowserPrintIID, "NS_IWEBBROWSERPRINT_IID" },
#endif
#ifdef NS_IWEBBROWSERSETUP_IID
    { &kWebBrowserSetupIID, "NS_IWEBBROWSERSETUP_IID" },
#endif
#ifdef NS_IWEBNAVIGATION_IID
    { &kWebNavigationIID, "NS_IWEBNAVIGATION_IID" },
#endif
#ifdef NS_IWEBPAGEDESCRIPTOR_IID
    { &kWebPageDescriptorIID, "NS_IWEBPAGEDESCRIPTOR_IID" },
#endif
#ifdef NS_IWEBPROGRESS_IID
    { &kWebProgressIID, "NS_IWEBPROGRESS_IID" },
#endif
#ifdef NS_IWEBPROGRESSLISTENER_IID
    { &kWebProgressListenerIID, "NS_IWEBPROGRESSLISTENER_IID" },
#endif
#ifdef NS_IWINDOWCREATOR_IID
    { &kWindowCreatorIID, "NS_IWINDOWCREATOR_IID" },
#endif
#ifdef NS_IWINDOWCREATOR2_IID
    { &kWindowCreator2IID, "NS_IWINDOWCREATOR2_IID" },
#endif
#ifdef NS_IWINDOWDATASOURCE_IID
    { &kWindowDataSourceIID, "NS_IWINDOWDATASOURCE_IID" },
#endif
#ifdef NS_IWINDOWLESSPLUGINSTPEER_IID
    { &kWindowlessPlugInstPeerIID, "NS_IWINDOWLESSPLUGINSTPEER_IID" },
#endif
#ifdef NS_IWINDOWMEDIATOR_IID
    { &kWindowMediatorIID, "NS_IWINDOWMEDIATOR_IID" },
#endif
#ifdef NS_IWINDOWMEDIATORLISTENER_IID
    { &kWindowMediatorListenerIID, "NS_IWINDOWMEDIATORLISTENER_IID" },
#endif
#ifdef NS_IWINDOWWATCHER_IID
    { &kWindowWatcherIID, "NS_IWINDOWWATCHER_IID" },
#endif
#ifdef NS_IWYCIWYGCHANNEL_IID
    { &kWyciwygChannelIID, "NS_IWYCIWYGCHANNEL_IID" },
#endif
#ifdef NS_IX509CERT_IID
    { &kX509CertIID, "NS_IX509CERT_IID" },
#endif
#ifdef NS_IX509CERTDB_IID
    { &kX509CertDBIID, "NS_IX509CERTDB_IID" },
#endif
#ifdef NS_IX509CERTVALIDITY_IID
    { &kX509CertValidityIID, "NS_IX509CERTVALIDITY_IID" },
#endif
#ifdef NS_IXMLHTTPREQUEST_IID
    { &kXMLHttpRequestIID, "NS_IXMLHTTPREQUEST_IID" },
#endif
#ifdef NS_IXMLRPCCLIENT_IID
    { &kXmlRpcClientIID, "NS_IXMLRPCCLIENT_IID" },
#endif
#ifdef NS_IXMLRPCCLIENTLISTENER_IID
    { &kXmlRpcClientListenerIID, "NS_IXMLRPCCLIENTLISTENER_IID" },
#endif
#ifdef NS_IXPCONNECT_IID
    { &kXPConnectIID, "NS_IXPCONNECT_IID" },
#endif
#ifdef NS_IXPCSCRIPTABLE_IID
    { &kXPCScriptableIID, "NS_IXPCSCRIPTABLE_IID" },
#endif
#ifdef NS_IXPCSCRIPTNOTIFY_IID
    { &kXPCScriptNotifyIID, "NS_IXPCSCRIPTNOTIFY_IID" },
#endif
#ifdef NS_IXPCSECURITYMANAGER_IID
    { &kXPCSecurityManagerIID, "NS_IXPCSECURITYMANAGER_IID" },
#endif
#ifdef NS_IXPIDIALOGSERVICE_IID
    { &kXPIDialogServiceIID, "NS_IXPIDIALOGSERVICE_IID" },
#endif
#ifdef NS_IXPINOTIFIER_IID
    { &kXPINotifierIID, "NS_IXPINOTIFIER_IID" },
#endif
#ifdef NS_IXPIPROGRESSDIALOG_IID
    { &kXPIProgressDialogIID, "NS_IXPIPROGRESSDIALOG_IID" },
#endif
#ifdef NS_IXPTLOADER_IID
    { &kXPTLoaderIID, "NS_IXPTLOADER_IID" },
#endif
#ifdef NS_IXREMOTECLIENT_IID
    { &kXRemoteClientIID, "NS_IXREMOTECLIENT_IID" },
#endif
#ifdef NS_IXSLTEXCEPTION_IID
    { &kXSLTExceptionIID, "NS_IXSLTEXCEPTION_IID" },
#endif
#ifdef NS_IXSLTPROCESSOR_IID
    { &kXSLTProcessorIID, "NS_IXSLTPROCESSOR_IID" },
#endif
#ifdef NS_IXSLTPROCESSOROBSOLETE_IID
    { &kXSLTProcessorObsoleteIID, "NS_IXSLTPROCESSOROBSOLETE_IID" },
#endif
#ifdef NS_IXULBROWSERWINDOW_IID
    { &kXULBrowserWindowIID, "NS_IXULBROWSERWINDOW_IID" },
#endif
#ifdef NS_IXULSORTSERVICE_IID
    { &kXULSortServiceIID, "NS_IXULSORTSERVICE_IID" },
#endif
#ifdef NS_IXULTEMPLATEBUILDER_IID
    { &kXULTemplateBuilderIID, "NS_IXULTEMPLATEBUILDER_IID" },
#endif
#ifdef NS_IXULWINDOW_IID
    { &kXULWindowIID, "NS_IXULWINDOW_IID" },
#endif
#ifdef NS_IZIPREADER_IID
    { &kZipReaderIID, "NS_IZIPREADER_IID" },
#endif
#ifdef NS_IJRIPLUGIN_IID
    { &kJRIPluginIID, "NS_IJRIPLUGIN_IID" },
#endif
#ifdef NS_IJVMCONSOLE_IID
    { &kJVMConsoleIID, "NS_IJVMCONSOLE_IID" },
#endif
#ifdef NS_IJVMMANAGER_IID
    { &kJVMManagerIID, "NS_IJVMMANAGER_IID" },
#endif
#ifdef NS_IJVMPLUGIN_IID
    { &kJVMPluginIID, "NS_IJVMPLUGIN_IID" },
#endif
#ifdef NS_IJVMPLUGININSTANCE_IID
    { &kJVMPluginInstanceIID, "NS_IJVMPLUGININSTANCE_IID" },
#endif
#ifdef NS_IJVMPLUGINTAGINFO_IID
    { &kJVMPluginTagInfoIID, "NS_IJVMPLUGINTAGINFO_IID" },
#endif
#ifdef NS_IJVMPREFSWINDOW_IID
    { &kJVMPrefsWindowIID, "NS_IJVMPREFSWINDOW_IID" },
#endif
#ifdef NS_IJVMWINDOW_IID
    { &kJVMWindowIID, "NS_IJVMWINDOW_IID" },
#endif
#ifdef NS_ILIVECONNECTMANAGER_IID
    { &kLiveConnectManagerIID, "NS_ILIVECONNECTMANAGER_IID" },
#endif
#ifdef NS_ISECUREENV_IID
    { &kSecureEnvIID, "NS_ISECUREENV_IID" },
#endif
#ifdef NS_ISYMANTECDEBUGGER_IID
    { &kSymantecDebuggerIID, "NS_ISYMANTECDEBUGGER_IID" },
#endif
#ifdef NS_ISYMANTECDEBUGMANAGER_IID
    { &kSymantecDebugManagerIID, "NS_ISYMANTECDEBUGMANAGER_IID" },
#endif
#ifdef NS_IREADMANAGER_IID
    { &kreadManagerIID, "NS_IREADMANAGER_IID" },
#endif
#ifdef NS_JVM_IID
    { &kjvmIID, "NS_JVM_IID" },
#endif
#ifdef NS_JVMMANAGER_IID
    { &kJVMManagerIID, "NS_JVMMANAGER_IID" },
#endif
#ifdef NS_JVMMANAGER_CID
    { &kJVMManagerCID, "NS_JVMMANAGER_CID" },
#endif
#ifdef NS_JVMPLUGINTAGINFO_IID
    { &kJVMPluginTagInfoIID, "NS_JVMPLUGINTAGINFO_IID" },
#endif
#ifdef NS_ILIVECONNECT_IID
    { &kLiveconnectIID, "NS_ILIVECONNECT_IID" },
#endif
#ifdef NS_ISECURELIVECONNECT_IID
    { &kSecureLiveconnectIID, "NS_ISECURELIVECONNECT_IID" },
#endif
#ifdef NS_ISECURITYCONTEXT_IID
    { &kSecurityContextIID, "NS_ISECURITYCONTEXT_IID" },
#endif
#ifdef NS_ISHUTDOWNLISTENER_IID
    { &kShutdownListenerIID, "NS_ISHUTDOWNLISTENER_IID" },
#endif
#ifdef NS_ISERVICEMANAGER_OBSOLETE_IID
    { &kServiceManagerObsoleteIID, "NS_ISERVICEMANAGER_OBSOLETE_IID" },
#endif
#ifdef NS_IJVMTHREADMANAGER_IID
    { &kJVMThreadManagerIID, "NS_IJVMTHREADMANAGER_IID" },
#endif
#ifdef FLASH_IOBJECT7_IID
    { &kFlashIObject7IID, "FLASH_IOBJECT7_IID" },
#endif
#ifdef FLASH_ISCRIPTABLEPLUGIN7_IID
    { &kFlashIScriptablePlugin7IID, "FLASH_ISCRIPTABLEPLUGIN7_IID" },
#endif
#ifdef NS_IFLASH5_IID
    { &kFlash5IID, "NS_IFLASH5_IID" },
#endif
};



/**
 * Lookup list for IIDs and CIDs to get an understandable name.
 */
static struct nsLookupStrIDEntry
{
    const nsID *    pID;
    const char *    pszStrID;
}   aIDStrIDLookup[] =
{
#ifdef NS_CDEFAULTURIFIXUP_IID_STR
    { &kCDefaultURIFixupIID, NS_CDEFAULTURIFIXUP_IID_STR },
#endif
#ifdef NS_CDOCSHELL_IID_STR
    { &kCDocShellIID, NS_CDOCSHELL_IID_STR },
#endif
#ifdef NS_CEXTERNALHANDLERSERVICE_IID_STR
    { &kCExternalHandlerServiceIID, NS_CEXTERNALHANDLERSERVICE_IID_STR },
#endif
#ifdef NS_CURILOADER_IID_STR
    { &kCURILoaderIID, NS_CURILOADER_IID_STR },
#endif
#ifdef NS_CWEBBROWSER_IID_STR
    { &kCWebBrowserIID, NS_CWEBBROWSER_IID_STR },
#endif
#ifdef NS_CWEBBROWSERPERSIST_IID_STR
    { &kCWebBrowserPersistIID, NS_CWEBBROWSERPERSIST_IID_STR },
#endif
#ifdef NS_IABADDRESSCOLLECTER_IID_STR
    { &kAbAddressCollecterIID, NS_IABADDRESSCOLLECTER_IID_STR },
#endif
#ifdef NS_IABAUTOCOMPLETESESSION_IID_STR
    { &kAbAutoCompleteSessionIID, NS_IABAUTOCOMPLETESESSION_IID_STR },
#endif
#ifdef NS_IABBASE_IID_STR
    { &kAbBaseIID, NS_IABBASE_IID_STR },
#endif
#ifdef NS_IABBOOLEANEXPRESSION_IID_STR
    { &kAbBooleanExpressionIID, NS_IABBOOLEANEXPRESSION_IID_STR },
#endif
#ifdef NS_IABCARD_IID_STR
    { &kAbCardIID, NS_IABCARD_IID_STR },
#endif
#ifdef NS_IABDIRECTORY_IID_STR
    { &kAbDirectoryIID, NS_IABDIRECTORY_IID_STR },
#endif
#ifdef NS_IABDIRECTORYQUERY_IID_STR
    { &kAbDirectoryQueryIID, NS_IABDIRECTORYQUERY_IID_STR },
#endif
#ifdef NS_IABDIRECTORYQUERYPROXY_IID_STR
    { &kAbDirectoryQueryProxyIID, NS_IABDIRECTORYQUERYPROXY_IID_STR },
#endif
#ifdef NS_IABDIRECTORYSEARCH_IID_STR
    { &kAbDirectorySearchIID, NS_IABDIRECTORYSEARCH_IID_STR },
#endif
#ifdef NS_IABDIRFACTORY_IID_STR
    { &kAbDirFactoryIID, NS_IABDIRFACTORY_IID_STR },
#endif
#ifdef NS_IABDIRFACTORYSERVICE_IID_STR
    { &kAbDirFactoryServiceIID, NS_IABDIRFACTORYSERVICE_IID_STR },
#endif
#ifdef NS_IABLDAPAUTOCOMPFORMATTER_IID_STR
    { &kAbLDAPAutoCompFormatterIID, NS_IABLDAPAUTOCOMPFORMATTER_IID_STR },
#endif
#ifdef NS_IABLDAPREPLICATIONDATA_IID_STR
    { &kAbLDAPReplicationDataIID, NS_IABLDAPREPLICATIONDATA_IID_STR },
#endif
#ifdef NS_IABLDAPREPLICATIONQUERY_IID_STR
    { &kAbLDAPReplicationQueryIID, NS_IABLDAPREPLICATIONQUERY_IID_STR },
#endif
#ifdef NS_IABLDAPREPLICATIONSERVICE_IID_STR
    { &kAbLDAPReplicationServiceIID, NS_IABLDAPREPLICATIONSERVICE_IID_STR },
#endif
#ifdef NS_IABLISTENER_IID_STR
    { &kAbListenerIID, NS_IABLISTENER_IID_STR },
#endif
#ifdef NS_IABMDBCARD_IID_STR
    { &kAbMDBCardIID, NS_IABMDBCARD_IID_STR },
#endif
#ifdef NS_IABMDBDIRECTORY_IID_STR
    { &kAbMDBDirectoryIID, NS_IABMDBDIRECTORY_IID_STR },
#endif
#ifdef NS_IABOUTMODULE_IID_STR
    { &kAboutModuleIID, NS_IABOUTMODULE_IID_STR },
#endif
#ifdef NS_IABUPGRADER_IID_STR
    { &kAbUpgraderIID, NS_IABUPGRADER_IID_STR },
#endif
#ifdef NS_IABVIEW_IID_STR
    { &kAbViewIID, NS_IABVIEW_IID_STR },
#endif
#ifdef NS_IACCESSIBILITYSERVICE_IID_STR
    { &kAccessibilityServiceIID, NS_IACCESSIBILITYSERVICE_IID_STR },
#endif
#ifdef NS_IACCESSIBLE_IID_STR
    { &kAccessibleIID, NS_IACCESSIBLE_IID_STR },
#endif
#ifdef NS_IACCESSIBLEACTION_IID_STR
    { &kAccessibleActionIID, NS_IACCESSIBLEACTION_IID_STR },
#endif
#ifdef NS_IACCESSIBLECARET_IID_STR
    { &kAccessibleCaretIID, NS_IACCESSIBLECARET_IID_STR },
#endif
#ifdef NS_IACCESSIBLEDOCUMENT_IID_STR
    { &kAccessibleDocumentIID, NS_IACCESSIBLEDOCUMENT_IID_STR },
#endif
#ifdef NS_IACCESSIBLEEDITABLETEXT_IID_STR
    { &kAccessibleEditableTextIID, NS_IACCESSIBLEEDITABLETEXT_IID_STR },
#endif
#ifdef NS_IACCESSIBLEEVENTLISTENER_IID_STR
    { &kAccessibleEventListenerIID, NS_IACCESSIBLEEVENTLISTENER_IID_STR },
#endif
#ifdef NS_IACCESSIBLEEVENTRECEIVER_IID_STR
    { &kAccessibleEventReceiverIID, NS_IACCESSIBLEEVENTRECEIVER_IID_STR },
#endif
#ifdef NS_IACCESSIBLEHYPERLINK_IID_STR
    { &kAccessibleHyperLinkIID, NS_IACCESSIBLEHYPERLINK_IID_STR },
#endif
#ifdef NS_IACCESSIBLEHYPERTEXT_IID_STR
    { &kAccessibleHyperTextIID, NS_IACCESSIBLEHYPERTEXT_IID_STR },
#endif
#ifdef NS_IACCESSIBLEPROVIDER_IID_STR
    { &kAccessibleProviderIID, NS_IACCESSIBLEPROVIDER_IID_STR },
#endif
#ifdef NS_IACCESSIBLESELECTABLE_IID_STR
    { &kAccessibleSelectableIID, NS_IACCESSIBLESELECTABLE_IID_STR },
#endif
#ifdef NS_IACCESSIBLETABLE_IID_STR
    { &kAccessibleTableIID, NS_IACCESSIBLETABLE_IID_STR },
#endif
#ifdef NS_IACCESSIBLETEXT_IID_STR
    { &kAccessibleTextIID, NS_IACCESSIBLETEXT_IID_STR },
#endif
#ifdef NS_IACCESSIBLEVALUE_IID_STR
    { &kAccessibleValueIID, NS_IACCESSIBLEVALUE_IID_STR },
#endif
#ifdef NS_IACCESSIBLEWIN32OBJECT_IID_STR
    { &kAccessibleWin32ObjectIID, NS_IACCESSIBLEWIN32OBJECT_IID_STR },
#endif
#ifdef NS_IADDBOOKURL_IID_STR
    { &kAddbookUrlIID, NS_IADDBOOKURL_IID_STR },
#endif
#ifdef NS_IADDRBOOKSESSION_IID_STR
    { &kAddrBookSessionIID, NS_IADDRBOOKSESSION_IID_STR },
#endif
#ifdef NS_IADDRDATABASE_IID_STR
    { &kAddrDatabaseIID, NS_IADDRDATABASE_IID_STR },
#endif
#ifdef NS_IADDRDBANNOUNCER_IID_STR
    { &kAddrDBAnnouncerIID, NS_IADDRDBANNOUNCER_IID_STR },
#endif
#ifdef NS_IADDRDBLISTENER_IID_STR
    { &kAddrDBListenerIID, NS_IADDRDBLISTENER_IID_STR },
#endif
#ifdef NS_IADDRESSBOOK_IID_STR
    { &kAddressBookIID, NS_IADDRESSBOOK_IID_STR },
#endif
#ifdef NS_IAGGREGATEPRINCIPAL_IID_STR
    { &kAggregatePrincipalIID, NS_IAGGREGATEPRINCIPAL_IID_STR },
#endif
#ifdef NS_IAPPSHELL_IID_STR
    { &kAppShellIID, NS_IAPPSHELL_IID_STR },
#endif
#ifdef NS_IAPPSHELLSERVICE_IID_STR
    { &kAppShellServiceIID, NS_IAPPSHELLSERVICE_IID_STR },
#endif
#ifdef NS_IARRAY_IID_STR
    { &kArrayIID, NS_IARRAY_IID_STR },
#endif
#ifdef NS_IASN1OBJECT_IID_STR
    { &kASN1ObjectIID, NS_IASN1OBJECT_IID_STR },
#endif
#ifdef NS_IASN1PRINTABLEITEM_IID_STR
    { &kASN1PrintableItemIID, NS_IASN1PRINTABLEITEM_IID_STR },
#endif
#ifdef NS_IASN1SEQUENCE_IID_STR
    { &kASN1SequenceIID, NS_IASN1SEQUENCE_IID_STR },
#endif
#ifdef NS_IASN1TREE_IID_STR
    { &kASN1TreeIID, NS_IASN1TREE_IID_STR },
#endif
#ifdef NS_IASYNCINPUTSTREAM_IID_STR
    { &kAsyncInputStreamIID, NS_IASYNCINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IASYNCOUTPUTSTREAM_IID_STR
    { &kAsyncOutputStreamIID, NS_IASYNCOUTPUTSTREAM_IID_STR },
#endif
#ifdef NS_IASYNCSTREAMCOPIER_IID_STR
    { &kAsyncStreamCopierIID, NS_IASYNCSTREAMCOPIER_IID_STR },
#endif
#ifdef NS_IATOM_IID_STR
    { &kAtomIID, NS_IATOM_IID_STR },
#endif
#ifdef NS_IATOMSERVICE_IID_STR
    { &kAtomServiceIID, NS_IATOMSERVICE_IID_STR },
#endif
#ifdef NS_IAUTHPROMPT_IID_STR
    { &kAuthPromptIID, NS_IAUTHPROMPT_IID_STR },
#endif
#ifdef NS_IAUTHPROMPTWRAPPER_IID_STR
    { &kAuthPromptWrapperIID, NS_IAUTHPROMPTWRAPPER_IID_STR },
#endif
#ifdef NS_IAUTOCOMPLETELISTENER_IID_STR
    { &kAutoCompleteListenerIID, NS_IAUTOCOMPLETELISTENER_IID_STR },
#endif
#ifdef NS_IAUTOCOMPLETERESULTS_IID_STR
    { &kAutoCompleteResultsIID, NS_IAUTOCOMPLETERESULTS_IID_STR },
#endif
#ifdef NS_IAUTOCOMPLETESESSION_IID_STR
    { &kAutoCompleteSessionIID, NS_IAUTOCOMPLETESESSION_IID_STR },
#endif
#ifdef NS_IAUTOCONFIG_IID_STR
    { &kAutoConfigIID, NS_IAUTOCONFIG_IID_STR },
#endif
#ifdef NS_IBADCERTLISTENER_IID_STR
    { &kBadCertListenerIID, NS_IBADCERTLISTENER_IID_STR },
#endif
#ifdef NS_IBASEWINDOW_IID_STR
    { &kBaseWindowIID, NS_IBASEWINDOW_IID_STR },
#endif
#ifdef NS_IBIDIKEYBOARD_IID_STR
    { &kBidiKeyboardIID, NS_IBIDIKEYBOARD_IID_STR },
#endif
#ifdef NS_IBINARYINPUTSTREAM_IID_STR
    { &kBinaryInputStreamIID, NS_IBINARYINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IBINARYOUTPUTSTREAM_IID_STR
    { &kBinaryOutputStreamIID, NS_IBINARYOUTPUTSTREAM_IID_STR },
#endif
#ifdef NS_IBOOKMARKSSERVICE_IID_STR
    { &kBookmarksServiceIID, NS_IBOOKMARKSSERVICE_IID_STR },
#endif
#ifdef NS_IBOXLAYOUTMANAGER_IID_STR
    { &kBoxLayoutManagerIID, NS_IBOXLAYOUTMANAGER_IID_STR },
#endif
#ifdef NS_IBOXOBJECT_IID_STR
    { &kBoxObjectIID, NS_IBOXOBJECT_IID_STR },
#endif
#ifdef NS_IBOXPAINTMANAGER_IID_STR
    { &kBoxPaintManagerIID, NS_IBOXPAINTMANAGER_IID_STR },
#endif
#ifdef NS_IBROWSERBOXOBJECT_IID_STR
    { &kBrowserBoxObjectIID, NS_IBROWSERBOXOBJECT_IID_STR },
#endif
#ifdef NS_IBROWSERHISTORY_IID_STR
    { &kBrowserHistoryIID, NS_IBROWSERHISTORY_IID_STR },
#endif
#ifdef NS_IBROWSERINSTANCE_IID_STR
    { &kBrowserInstanceIID, NS_IBROWSERINSTANCE_IID_STR },
#endif
#ifdef NS_IBUFENTROPYCOLLECTOR_IID_STR
    { &kBufEntropyCollectorIID, NS_IBUFENTROPYCOLLECTOR_IID_STR },
#endif
#ifdef NS_IBUFFEREDSTREAMS_IID_STR
    { &kBufferedStreamsIID, NS_IBUFFEREDSTREAMS_IID_STR },
#endif
#ifdef NS_IBYTEARRAYINPUTSTREAM_IID_STR
    { &kByteArrayInputStreamIID, NS_IBYTEARRAYINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IBYTERANGEREQUEST_IID_STR
    { &kByteRangeRequestIID, NS_IBYTERANGEREQUEST_IID_STR },
#endif
#ifdef NS_ICACHE_IID_STR
    { &kCacheIID, NS_ICACHE_IID_STR },
#endif
#ifdef NS_ICACHEENTRYDESCRIPTOR_IID_STR
    { &kCacheEntryDescriptorIID, NS_ICACHEENTRYDESCRIPTOR_IID_STR },
#endif
#ifdef NS_ICACHELISTENER_IID_STR
    { &kCacheListenerIID, NS_ICACHELISTENER_IID_STR },
#endif
#ifdef NS_ICACHESERVICE_IID_STR
    { &kCacheServiceIID, NS_ICACHESERVICE_IID_STR },
#endif
#ifdef NS_ICACHESESSION_IID_STR
    { &kCacheSessionIID, NS_ICACHESESSION_IID_STR },
#endif
#ifdef NS_ICACHEVISITOR_IID_STR
    { &kCacheVisitorIID, NS_ICACHEVISITOR_IID_STR },
#endif
#ifdef NS_ICACHINGCHANNEL_IID_STR
    { &kCachingChannelIID, NS_ICACHINGCHANNEL_IID_STR },
#endif
#ifdef NS_ICATEGORYMANAGER_IID_STR
    { &kCategoryManagerIID, NS_ICATEGORYMANAGER_IID_STR },
#endif
#ifdef NS_ICERTIFICATEDIALOGS_IID_STR
    { &kCertificateDialogsIID, NS_ICERTIFICATEDIALOGS_IID_STR },
#endif
#ifdef NS_ICERTIFICATEPRINCIPAL_IID_STR
    { &kCertificatePrincipalIID, NS_ICERTIFICATEPRINCIPAL_IID_STR },
#endif
#ifdef NS_ICERTPICKDIALOGS_IID_STR
    { &kCertPickDialogsIID, NS_ICERTPICKDIALOGS_IID_STR },
#endif
#ifdef NS_ICERTSELECT_IID_STR
    { &kCertSelectIID, NS_ICERTSELECT_IID_STR },
#endif
#ifdef NS_ICERTTREE_IID_STR
    { &kCertTreeIID, NS_ICERTTREE_IID_STR },
#endif
#ifdef NS_ICHANNEL_IID_STR
    { &kChannelIID, NS_ICHANNEL_IID_STR },
#endif
#ifdef NS_ICHARSETCONVERTERMANAGER2_IID_STR
    { &kCharsetConverterManager2IID, NS_ICHARSETCONVERTERMANAGER2_IID_STR },
#endif
#ifdef NS_ICHROMEEVENTHANDLER_IID_STR
    { &kChromeEventHandlerIID, NS_ICHROMEEVENTHANDLER_IID_STR },
#endif
#ifdef NS_ICHROMEREGISTRY_IID_STR
    { &kChromeRegistryIID, NS_ICHROMEREGISTRY_IID_STR },
#endif
#ifdef NS_ICIPHERINFO_IID_STR
    { &kCipherInfoIID, NS_ICIPHERINFO_IID_STR },
#endif
#ifdef NS_ICITER_IID_STR
    { &kCiterIID, NS_ICITER_IID_STR },
#endif
#ifdef NS_ICLASSICPLUGINFACTORY_IID_STR
    { &kClassicPluginFactoryIID, NS_ICLASSICPLUGINFACTORY_IID_STR },
#endif
#ifdef NS_ICLASSINFO_IID_STR
    { &kClassInfoIID, NS_ICLASSINFO_IID_STR },
#endif
#ifdef NS_ICLIENTAUTHDIALOGS_IID_STR
    { &kClientAuthDialogsIID, NS_ICLIENTAUTHDIALOGS_IID_STR },
#endif
#ifdef NS_ICLIPBOARD_IID_STR
    { &kClipboardIID, NS_ICLIPBOARD_IID_STR },
#endif
#ifdef NS_ICLIPBOARDCOMMANDS_IID_STR
    { &kClipboardCommandsIID, NS_ICLIPBOARDCOMMANDS_IID_STR },
#endif
#ifdef NS_ICLIPBOARDHELPER_IID_STR
    { &kClipboardHelperIID, NS_ICLIPBOARDHELPER_IID_STR },
#endif
#ifdef NS_ICLIPBOARDOWNER_IID_STR
    { &kClipboardOwnerIID, NS_ICLIPBOARDOWNER_IID_STR },
#endif
#ifdef NS_ICLOSEALLWINDOWS_IID_STR
    { &kCloseAllWindowsIID, NS_ICLOSEALLWINDOWS_IID_STR },
#endif
#ifdef NS_ICMDLINEHANDLER_IID_STR
    { &kCmdLineHandlerIID, NS_ICMDLINEHANDLER_IID_STR },
#endif
#ifdef NS_ICMDLINESERVICE_IID_STR
    { &kCmdLineServiceIID, NS_ICMDLINESERVICE_IID_STR },
#endif
#ifdef NS_ICMSDECODER_IID_STR
    { &kCMSDecoderIID, NS_ICMSDECODER_IID_STR },
#endif
#ifdef NS_ICMSENCODER_IID_STR
    { &kCMSEncoderIID, NS_ICMSENCODER_IID_STR },
#endif
#ifdef NS_ICMSMESSAGE_IID_STR
    { &kCMSMessageIID, NS_ICMSMESSAGE_IID_STR },
#endif
#ifdef NS_ICMSMESSAGEERRORS_IID_STR
    { &kCMSMessageErrorsIID, NS_ICMSMESSAGEERRORS_IID_STR },
#endif
#ifdef NS_ICMSSECUREMESSAGE_IID_STR
    { &kCMSSecureMessageIID, NS_ICMSSECUREMESSAGE_IID_STR },
#endif
#ifdef NS_ICODEBASEPRINCIPAL_IID_STR
    { &kCodebasePrincipalIID, NS_ICODEBASEPRINCIPAL_IID_STR },
#endif
#ifdef NS_ICOLLECTION_IID_STR
    { &kCollectionIID, NS_ICOLLECTION_IID_STR },
#endif
#ifdef NS_ICOMM4XPROFILE_IID_STR
    { &kComm4xProfileIID, NS_ICOMM4XPROFILE_IID_STR },
#endif
#ifdef NS_ICOMMANDHANDLER_IID_STR
    { &kCommandHandlerIID, NS_ICOMMANDHANDLER_IID_STR },
#endif
#ifdef NS_ICOMMANDMANAGER_IID_STR
    { &kCommandManagerIID, NS_ICOMMANDMANAGER_IID_STR },
#endif
#ifdef NS_ICOMMANDPARAMS_IID_STR
    { &kCommandParamsIID, NS_ICOMMANDPARAMS_IID_STR },
#endif
#ifdef NS_ICOMPONENTLOADER_IID_STR
    { &kComponentLoaderIID, NS_ICOMPONENTLOADER_IID_STR },
#endif
#ifdef NS_ICOMPONENTLOADERMANAGER_IID_STR
    { &kComponentLoaderManagerIID, NS_ICOMPONENTLOADERMANAGER_IID_STR },
#endif
#ifdef NS_ICOMPONENTMANAGER_IID_STR
    { &kComponentManagerIID, NS_ICOMPONENTMANAGER_IID_STR },
#endif
#ifdef NS_ICOMPONENTMANAGEROBSOLETE_IID_STR
    { &kComponentManagerObsoleteIID, NS_ICOMPONENTMANAGEROBSOLETE_IID_STR },
#endif
#ifdef NS_ICOMPONENTREGISTRAR_IID_STR
    { &kComponentRegistrarIID, NS_ICOMPONENTREGISTRAR_IID_STR },
#endif
#ifdef NS_ICONSOLELISTENER_IID_STR
    { &kConsoleListenerIID, NS_ICONSOLELISTENER_IID_STR },
#endif
#ifdef NS_ICONSOLEMESSAGE_IID_STR
    { &kConsoleMessageIID, NS_ICONSOLEMESSAGE_IID_STR },
#endif
#ifdef NS_ICONSOLESERVICE_IID_STR
    { &kConsoleServiceIID, NS_ICONSOLESERVICE_IID_STR },
#endif
#ifdef NS_ICONTENTHANDLER_IID_STR
    { &kContentHandlerIID, NS_ICONTENTHANDLER_IID_STR },
#endif
#ifdef NS_ICONTENTPOLICY_IID_STR
    { &kContentPolicyIID, NS_ICONTENTPOLICY_IID_STR },
#endif
#ifdef NS_ICONTENTVIEWER_IID_STR
    { &kContentViewerIID, NS_ICONTENTVIEWER_IID_STR },
#endif
#ifdef NS_ICONTENTVIEWERCONTAINER_IID_STR
    { &kContentViewerContainerIID, NS_ICONTENTVIEWERCONTAINER_IID_STR },
#endif
#ifdef NS_ICONTENTVIEWEREDIT_IID_STR
    { &kContentViewerEditIID, NS_ICONTENTVIEWEREDIT_IID_STR },
#endif
#ifdef NS_ICONTENTVIEWERFILE_IID_STR
    { &kContentViewerFileIID, NS_ICONTENTVIEWERFILE_IID_STR },
#endif
#ifdef NS_ICONTEXTMENULISTENER_IID_STR
    { &kContextMenuListenerIID, NS_ICONTEXTMENULISTENER_IID_STR },
#endif
#ifdef NS_ICONTEXTMENULISTENER2_IID_STR
    { &kContextMenuListener2IID, NS_ICONTEXTMENULISTENER2_IID_STR },
#endif
#ifdef NS_ICONTROLLER_IID_STR
    { &kControllerIID, NS_ICONTROLLER_IID_STR },
#endif
#ifdef NS_ICONTROLLERCOMMAND_IID_STR
    { &kControllerCommandIID, NS_ICONTROLLERCOMMAND_IID_STR },
#endif
#ifdef NS_ICONTROLLERCOMMANDMANAGER_IID_STR
    { &kControllerCommandManagerIID, NS_ICONTROLLERCOMMANDMANAGER_IID_STR },
#endif
#ifdef NS_ICONTROLLERCONTEXT_IID_STR
    { &kControllerContextIID, NS_ICONTROLLERCONTEXT_IID_STR },
#endif
#ifdef NS_ICONTROLLERS_IID_STR
    { &kControllersIID, NS_ICONTROLLERS_IID_STR },
#endif
#ifdef NS_ICOOKIE_IID_STR
    { &kCookieIID, NS_ICOOKIE_IID_STR },
#endif
#ifdef NS_ICOOKIEACCEPTDIALOG_IID_STR
    { &kCookieAcceptDialogIID, NS_ICOOKIEACCEPTDIALOG_IID_STR },
#endif
#ifdef NS_ICOOKIECONSENT_IID_STR
    { &kCookieConsentIID, NS_ICOOKIECONSENT_IID_STR },
#endif
#ifdef NS_ICOOKIEMANAGER_IID_STR
    { &kCookieManagerIID, NS_ICOOKIEMANAGER_IID_STR },
#endif
#ifdef NS_ICOOKIEMANAGER2_IID_STR
    { &kCookieManager2IID, NS_ICOOKIEMANAGER2_IID_STR },
#endif
#ifdef NS_ICOOKIEPROMPTSERVICE_IID_STR
    { &kCookiePromptServiceIID, NS_ICOOKIEPROMPTSERVICE_IID_STR },
#endif
#ifdef NS_ICOOKIESERVICE_IID_STR
    { &kCookieServiceIID, NS_ICOOKIESERVICE_IID_STR },
#endif
#ifdef NS_ICOOKIESTORAGE_IID_STR
    { &kCookieStorageIID, NS_ICOOKIESTORAGE_IID_STR },
#endif
#ifdef NS_ICOPYMESSAGELISTENER_IID_STR
    { &kCopyMessageListenerIID, NS_ICOPYMESSAGELISTENER_IID_STR },
#endif
#ifdef NS_ICOPYMSGSTREAMLISTENER_IID_STR
    { &kCopyMsgStreamListenerIID, NS_ICOPYMSGSTREAMLISTENER_IID_STR },
#endif
#ifdef NS_ICRLINFO_IID_STR
    { &kCRLInfoIID, NS_ICRLINFO_IID_STR },
#endif
#ifdef NS_ICRLMANAGER_IID_STR
    { &kCRLManagerIID, NS_ICRLMANAGER_IID_STR },
#endif
#ifdef NS_ICURRENTCHARSETLISTENER_IID_STR
    { &kCurrentCharsetListenerIID, NS_ICURRENTCHARSETLISTENER_IID_STR },
#endif
#ifdef NS_IDATACHANNEL_IID_STR
    { &kDataChannelIID, NS_IDATACHANNEL_IID_STR },
#endif
#ifdef NS_IDBCHANGEANNOUNCER_IID_STR
    { &kDBChangeAnnouncerIID, NS_IDBCHANGEANNOUNCER_IID_STR },
#endif
#ifdef NS_IDBCHANGELISTENER_IID_STR
    { &kDBChangeListenerIID, NS_IDBCHANGELISTENER_IID_STR },
#endif
#ifdef NS_IDBFOLDERINFO_IID_STR
    { &kDBFolderInfoIID, NS_IDBFOLDERINFO_IID_STR },
#endif
#ifdef NS_IDIALOGPARAMBLOCK_IID_STR
    { &kDialogParamBlockIID, NS_IDIALOGPARAMBLOCK_IID_STR },
#endif
#ifdef NS_IDICTIONARY_IID_STR
    { &kDictionaryIID, NS_IDICTIONARY_IID_STR },
#endif
#ifdef NS_IDIRECTORYLISTING_IID_STR
    { &kDirectoryListingIID, NS_IDIRECTORYLISTING_IID_STR },
#endif
#ifdef NS_IDIRECTORYSERVICE_IID_STR
    { &kDirectoryServiceIID, NS_IDIRECTORYSERVICE_IID_STR },
#endif
#ifdef NS_IDIRINDEX_IID_STR
    { &kDirIndexIID, NS_IDIRINDEX_IID_STR },
#endif
#ifdef NS_IDIRINDEXLISTENER_IID_STR
    { &kDirIndexListenerIID, NS_IDIRINDEXLISTENER_IID_STR },
#endif
#ifdef NS_IDNSLISTENER_IID_STR
    { &kDNSListenerIID, NS_IDNSLISTENER_IID_STR },
#endif
#ifdef NS_IDNSSERVICE_IID_STR
    { &kDNSServiceIID, NS_IDNSSERVICE_IID_STR },
#endif
#ifdef NS_IDOCCHARSET_IID_STR
    { &kDocCharsetIID, NS_IDOCCHARSET_IID_STR },
#endif
#ifdef NS_IDOCSHELL_IID_STR
    { &kDocShellIID, NS_IDOCSHELL_IID_STR },
#endif
#ifdef NS_IDOCSHELLHISTORY_IID_STR
    { &kDocShellHistoryIID, NS_IDOCSHELLHISTORY_IID_STR },
#endif
#ifdef NS_IDOCSHELLLOADINFO_IID_STR
    { &kDocShellLoadInfoIID, NS_IDOCSHELLLOADINFO_IID_STR },
#endif
#ifdef NS_IDOCSHELLTREEITEM_IID_STR
    { &kDocShellTreeItemIID, NS_IDOCSHELLTREEITEM_IID_STR },
#endif
#ifdef NS_IDOCSHELLTREENODE_IID_STR
    { &kDocShellTreeNodeIID, NS_IDOCSHELLTREENODE_IID_STR },
#endif
#ifdef NS_IDOCSHELLTREEOWNER_IID_STR
    { &kDocShellTreeOwnerIID, NS_IDOCSHELLTREEOWNER_IID_STR },
#endif
#ifdef NS_IDOCUMENTCHARSETINFO_IID_STR
    { &kDocumentCharsetInfoIID, NS_IDOCUMENTCHARSETINFO_IID_STR },
#endif
#ifdef NS_IDOCUMENTLOADER_IID_STR
    { &kDocumentLoaderIID, NS_IDOCUMENTLOADER_IID_STR },
#endif
#ifdef NS_IDOCUMENTLOADERFACTORY_IID_STR
    { &kDocumentLoaderFactoryIID, NS_IDOCUMENTLOADERFACTORY_IID_STR },
#endif
#ifdef NS_IDOCUMENTSTATELISTENER_IID_STR
    { &kDocumentStateListenerIID, NS_IDOCUMENTSTATELISTENER_IID_STR },
#endif
#ifdef NS_IDOM3DOCUMENTEVENT_IID_STR
    { &kDOM3DocumentEventIID, NS_IDOM3DOCUMENTEVENT_IID_STR },
#endif
#ifdef NS_IDOM3EVENTTARGET_IID_STR
    { &kDOM3EventTargetIID, NS_IDOM3EVENTTARGET_IID_STR },
#endif
#ifdef NS_IDOM3NODE_IID_STR
    { &kDOM3NodeIID, NS_IDOM3NODE_IID_STR },
#endif
#ifdef NS_IDOMABSTRACTVIEW_IID_STR
    { &kDOMAbstractViewIID, NS_IDOMABSTRACTVIEW_IID_STR },
#endif
#ifdef NS_IDOMATTR_IID_STR
    { &kDOMAttrIID, NS_IDOMATTR_IID_STR },
#endif
#ifdef NS_IDOMBARPROP_IID_STR
    { &kDOMBarPropIID, NS_IDOMBARPROP_IID_STR },
#endif
#ifdef NS_IDOMCDATASECTION_IID_STR
    { &kDOMCDATASectionIID, NS_IDOMCDATASECTION_IID_STR },
#endif
#ifdef NS_IDOMCHARACTERDATA_IID_STR
    { &kDOMCharacterDataIID, NS_IDOMCHARACTERDATA_IID_STR },
#endif
#ifdef NS_IDOMCHROMEWINDOW_IID_STR
    { &kDOMChromeWindowIID, NS_IDOMCHROMEWINDOW_IID_STR },
#endif
#ifdef NS_IDOMCOMMENT_IID_STR
    { &kDOMCommentIID, NS_IDOMCOMMENT_IID_STR },
#endif
#ifdef NS_IDOMCOUNTER_IID_STR
    { &kDOMCounterIID, NS_IDOMCOUNTER_IID_STR },
#endif
#ifdef NS_IDOMCRMFOBJECT_IID_STR
    { &kDOMCRMFObjectIID, NS_IDOMCRMFOBJECT_IID_STR },
#endif
#ifdef NS_IDOMCRYPTO_IID_STR
    { &kDOMCryptoIID, NS_IDOMCRYPTO_IID_STR },
#endif
#ifdef NS_IDOMCRYPTODIALOGS_IID_STR
    { &kDOMCryptoDialogsIID, NS_IDOMCRYPTODIALOGS_IID_STR },
#endif
#ifdef NS_IDOMCSS2PROPERTIES_IID_STR
    { &kDOMCSS2PropertiesIID, NS_IDOMCSS2PROPERTIES_IID_STR },
#endif
#ifdef NS_IDOMCSSCHARSETRULE_IID_STR
    { &kDOMCSSCharsetRuleIID, NS_IDOMCSSCHARSETRULE_IID_STR },
#endif
#ifdef NS_IDOMCSSFONTFACERULE_IID_STR
    { &kDOMCSSFontFaceRuleIID, NS_IDOMCSSFONTFACERULE_IID_STR },
#endif
#ifdef NS_IDOMCSSIMPORTRULE_IID_STR
    { &kDOMCSSImportRuleIID, NS_IDOMCSSIMPORTRULE_IID_STR },
#endif
#ifdef NS_IDOMCSSMEDIARULE_IID_STR
    { &kDOMCSSMediaRuleIID, NS_IDOMCSSMEDIARULE_IID_STR },
#endif
#ifdef NS_IDOMCSSPAGERULE_IID_STR
    { &kDOMCSSPageRuleIID, NS_IDOMCSSPAGERULE_IID_STR },
#endif
#ifdef NS_IDOMCSSPRIMITIVEVALUE_IID_STR
    { &kDOMCSSPrimitiveValueIID, NS_IDOMCSSPRIMITIVEVALUE_IID_STR },
#endif
#ifdef NS_IDOMCSSRULE_IID_STR
    { &kDOMCSSRuleIID, NS_IDOMCSSRULE_IID_STR },
#endif
#ifdef NS_IDOMCSSRULELIST_IID_STR
    { &kDOMCSSRuleListIID, NS_IDOMCSSRULELIST_IID_STR },
#endif
#ifdef NS_IDOMCSSSTYLEDECLARATION_IID_STR
    { &kDOMCSSStyleDeclarationIID, NS_IDOMCSSSTYLEDECLARATION_IID_STR },
#endif
#ifdef NS_IDOMCSSSTYLERULE_IID_STR
    { &kDOMCSSStyleRuleIID, NS_IDOMCSSSTYLERULE_IID_STR },
#endif
#ifdef NS_IDOMCSSSTYLESHEET_IID_STR
    { &kDOMCSSStyleSheetIID, NS_IDOMCSSSTYLESHEET_IID_STR },
#endif
#ifdef NS_IDOMCSSUNKNOWNRULE_IID_STR
    { &kDOMCSSUnknownRuleIID, NS_IDOMCSSUNKNOWNRULE_IID_STR },
#endif
#ifdef NS_IDOMCSSVALUE_IID_STR
    { &kDOMCSSValueIID, NS_IDOMCSSVALUE_IID_STR },
#endif
#ifdef NS_IDOMCSSVALUELIST_IID_STR
    { &kDOMCSSValueListIID, NS_IDOMCSSVALUELIST_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENT_IID_STR
    { &kDOMDocumentIID, NS_IDOMDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTCSS_IID_STR
    { &kDOMDocumentCSSIID, NS_IDOMDOCUMENTCSS_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTEVENT_IID_STR
    { &kDOMDocumentEventIID, NS_IDOMDOCUMENTEVENT_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTFRAGMENT_IID_STR
    { &kDOMDocumentFragmentIID, NS_IDOMDOCUMENTFRAGMENT_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTRANGE_IID_STR
    { &kDOMDocumentRangeIID, NS_IDOMDOCUMENTRANGE_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTSTYLE_IID_STR
    { &kDOMDocumentStyleIID, NS_IDOMDOCUMENTSTYLE_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTTRAVERSAL_IID_STR
    { &kDOMDocumentTraversalIID, NS_IDOMDOCUMENTTRAVERSAL_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTTYPE_IID_STR
    { &kDOMDocumentTypeIID, NS_IDOMDOCUMENTTYPE_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTVIEW_IID_STR
    { &kDOMDocumentViewIID, NS_IDOMDOCUMENTVIEW_IID_STR },
#endif
#ifdef NS_IDOMDOCUMENTXBL_IID_STR
    { &kDOMDocumentXBLIID, NS_IDOMDOCUMENTXBL_IID_STR },
#endif
#ifdef NS_IDOMDOMEXCEPTION_IID_STR
    { &kDOMDOMExceptionIID, NS_IDOMDOMEXCEPTION_IID_STR },
#endif
#ifdef NS_IDOMDOMIMPLEMENTATION_IID_STR
    { &kDOMDOMImplementationIID, NS_IDOMDOMIMPLEMENTATION_IID_STR },
#endif
#ifdef NS_IDOMELEMENT_IID_STR
    { &kDOMElementIID, NS_IDOMELEMENT_IID_STR },
#endif
#ifdef NS_IDOMELEMENTCSSINLINESTYLE_IID_STR
    { &kDOMElementCSSInlineStyleIID, NS_IDOMELEMENTCSSINLINESTYLE_IID_STR },
#endif
#ifdef NS_IDOMENTITY_IID_STR
    { &kDOMEntityIID, NS_IDOMENTITY_IID_STR },
#endif
#ifdef NS_IDOMENTITYREFERENCE_IID_STR
    { &kDOMEntityReferenceIID, NS_IDOMENTITYREFERENCE_IID_STR },
#endif
#ifdef NS_IDOMEVENT_IID_STR
    { &kDOMEventIID, NS_IDOMEVENT_IID_STR },
#endif
#ifdef NS_IDOMEVENTGROUP_IID_STR
    { &kDOMEventGroupIID, NS_IDOMEVENTGROUP_IID_STR },
#endif
#ifdef NS_IDOMEVENTLISTENER_IID_STR
    { &kDOMEventListenerIID, NS_IDOMEVENTLISTENER_IID_STR },
#endif
#ifdef NS_IDOMEVENTTARGET_IID_STR
    { &kDOMEventTargetIID, NS_IDOMEVENTTARGET_IID_STR },
#endif
#ifdef NS_IDOMHISTORY_IID_STR
    { &kDOMHistoryIID, NS_IDOMHISTORY_IID_STR },
#endif
#ifdef NS_IDOMHTMLANCHORELEMENT_IID_STR
    { &kDOMHTMLAnchorElementIID, NS_IDOMHTMLANCHORELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLAPPLETELEMENT_IID_STR
    { &kDOMHTMLAppletElementIID, NS_IDOMHTMLAPPLETELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLAREAELEMENT_IID_STR
    { &kDOMHTMLAreaElementIID, NS_IDOMHTMLAREAELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLBASEELEMENT_IID_STR
    { &kDOMHTMLBaseElementIID, NS_IDOMHTMLBASEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLBASEFONTELEMENT_IID_STR
    { &kDOMHTMLBaseFontElementIID, NS_IDOMHTMLBASEFONTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLBODYELEMENT_IID_STR
    { &kDOMHTMLBodyElementIID, NS_IDOMHTMLBODYELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLBRELEMENT_IID_STR
    { &kDOMHTMLBRElementIID, NS_IDOMHTMLBRELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLBUTTONELEMENT_IID_STR
    { &kDOMHTMLButtonElementIID, NS_IDOMHTMLBUTTONELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLCOLLECTION_IID_STR
    { &kDOMHTMLCollectionIID, NS_IDOMHTMLCOLLECTION_IID_STR },
#endif
#ifdef NS_IDOMHTMLDIRECTORYELEMENT_IID_STR
    { &kDOMHTMLDirectoryElementIID, NS_IDOMHTMLDIRECTORYELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLDIVELEMENT_IID_STR
    { &kDOMHTMLDivElementIID, NS_IDOMHTMLDIVELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLDLISTELEMENT_IID_STR
    { &kDOMHTMLDListElementIID, NS_IDOMHTMLDLISTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLDOCUMENT_IID_STR
    { &kDOMHTMLDocumentIID, NS_IDOMHTMLDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLELEMENT_IID_STR
    { &kDOMHTMLElementIID, NS_IDOMHTMLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLEMBEDELEMENT_IID_STR
    { &kDOMHTMLEmbedElementIID, NS_IDOMHTMLEMBEDELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLFIELDSETELEMENT_IID_STR
    { &kDOMHTMLFieldSetElementIID, NS_IDOMHTMLFIELDSETELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLFONTELEMENT_IID_STR
    { &kDOMHTMLFontElementIID, NS_IDOMHTMLFONTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLFORMELEMENT_IID_STR
    { &kDOMHTMLFormElementIID, NS_IDOMHTMLFORMELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLFRAMEELEMENT_IID_STR
    { &kDOMHTMLFrameElementIID, NS_IDOMHTMLFRAMEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLFRAMESETELEMENT_IID_STR
    { &kDOMHTMLFrameSetElementIID, NS_IDOMHTMLFRAMESETELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLHEADELEMENT_IID_STR
    { &kDOMHTMLHeadElementIID, NS_IDOMHTMLHEADELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLHEADINGELEMENT_IID_STR
    { &kDOMHTMLHeadingElementIID, NS_IDOMHTMLHEADINGELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLHRELEMENT_IID_STR
    { &kDOMHTMLHRElementIID, NS_IDOMHTMLHRELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLHTMLELEMENT_IID_STR
    { &kDOMHTMLHtmlElementIID, NS_IDOMHTMLHTMLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLIFRAMEELEMENT_IID_STR
    { &kDOMHTMLIFrameElementIID, NS_IDOMHTMLIFRAMEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLIMAGEELEMENT_IID_STR
    { &kDOMHTMLImageElementIID, NS_IDOMHTMLIMAGEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLINPUTELEMENT_IID_STR
    { &kDOMHTMLInputElementIID, NS_IDOMHTMLINPUTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLISINDEXELEMENT_IID_STR
    { &kDOMHTMLIsIndexElementIID, NS_IDOMHTMLISINDEXELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLLABELELEMENT_IID_STR
    { &kDOMHTMLLabelElementIID, NS_IDOMHTMLLABELELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLLEGENDELEMENT_IID_STR
    { &kDOMHTMLLegendElementIID, NS_IDOMHTMLLEGENDELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLLIELEMENT_IID_STR
    { &kDOMHTMLLIElementIID, NS_IDOMHTMLLIELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLLINKELEMENT_IID_STR
    { &kDOMHTMLLinkElementIID, NS_IDOMHTMLLINKELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLMAPELEMENT_IID_STR
    { &kDOMHTMLMapElementIID, NS_IDOMHTMLMAPELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLMENUELEMENT_IID_STR
    { &kDOMHTMLMenuElementIID, NS_IDOMHTMLMENUELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLMETAELEMENT_IID_STR
    { &kDOMHTMLMetaElementIID, NS_IDOMHTMLMETAELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLMODELEMENT_IID_STR
    { &kDOMHTMLModElementIID, NS_IDOMHTMLMODELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLOBJECTELEMENT_IID_STR
    { &kDOMHTMLObjectElementIID, NS_IDOMHTMLOBJECTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLOLISTELEMENT_IID_STR
    { &kDOMHTMLOListElementIID, NS_IDOMHTMLOLISTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLOPTGROUPELEMENT_IID_STR
    { &kDOMHTMLOptGroupElementIID, NS_IDOMHTMLOPTGROUPELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLOPTIONELEMENT_IID_STR
    { &kDOMHTMLOptionElementIID, NS_IDOMHTMLOPTIONELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLPARAGRAPHELEMENT_IID_STR
    { &kDOMHTMLParagraphElementIID, NS_IDOMHTMLPARAGRAPHELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLPARAMELEMENT_IID_STR
    { &kDOMHTMLParamElementIID, NS_IDOMHTMLPARAMELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLPREELEMENT_IID_STR
    { &kDOMHTMLPreElementIID, NS_IDOMHTMLPREELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLQUOTEELEMENT_IID_STR
    { &kDOMHTMLQuoteElementIID, NS_IDOMHTMLQUOTEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLSCRIPTELEMENT_IID_STR
    { &kDOMHTMLScriptElementIID, NS_IDOMHTMLSCRIPTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLSELECTELEMENT_IID_STR
    { &kDOMHTMLSelectElementIID, NS_IDOMHTMLSELECTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLSTYLEELEMENT_IID_STR
    { &kDOMHTMLStyleElementIID, NS_IDOMHTMLSTYLEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLECAPTIONELEM_IID_STR
    { &kDOMHTMLTableCaptionElemIID, NS_IDOMHTMLTABLECAPTIONELEM_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLECELLELEMENT_IID_STR
    { &kDOMHTMLTableCellElementIID, NS_IDOMHTMLTABLECELLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLECOLELEMENT_IID_STR
    { &kDOMHTMLTableColElementIID, NS_IDOMHTMLTABLECOLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLEELEMENT_IID_STR
    { &kDOMHTMLTableElementIID, NS_IDOMHTMLTABLEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLEROWELEMENT_IID_STR
    { &kDOMHTMLTableRowElementIID, NS_IDOMHTMLTABLEROWELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTABLESECTIONELEM_IID_STR
    { &kDOMHTMLTableSectionElemIID, NS_IDOMHTMLTABLESECTIONELEM_IID_STR },
#endif
#ifdef NS_IDOMHTMLTEXTAREAELEMENT_IID_STR
    { &kDOMHTMLTextAreaElementIID, NS_IDOMHTMLTEXTAREAELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLTITLEELEMENT_IID_STR
    { &kDOMHTMLTitleElementIID, NS_IDOMHTMLTITLEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMHTMLULISTELEMENT_IID_STR
    { &kDOMHTMLUListElementIID, NS_IDOMHTMLULISTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMJSWINDOW_IID_STR
    { &kDOMJSWindowIID, NS_IDOMJSWINDOW_IID_STR },
#endif
#ifdef NS_IDOMKEYEVENT_IID_STR
    { &kDOMKeyEventIID, NS_IDOMKEYEVENT_IID_STR },
#endif
#ifdef NS_IDOMLINKSTYLE_IID_STR
    { &kDOMLinkStyleIID, NS_IDOMLINKSTYLE_IID_STR },
#endif
#ifdef NS_IDOMLOCATION_IID_STR
    { &kDOMLocationIID, NS_IDOMLOCATION_IID_STR },
#endif
#ifdef NS_IDOMMEDIALIST_IID_STR
    { &kDOMMediaListIID, NS_IDOMMEDIALIST_IID_STR },
#endif
#ifdef NS_IDOMMIMETYPE_IID_STR
    { &kDOMMimeTypeIID, NS_IDOMMIMETYPE_IID_STR },
#endif
#ifdef NS_IDOMMIMETYPEARRAY_IID_STR
    { &kDOMMimeTypeArrayIID, NS_IDOMMIMETYPEARRAY_IID_STR },
#endif
#ifdef NS_IDOMMOUSEEVENT_IID_STR
    { &kDOMMouseEventIID, NS_IDOMMOUSEEVENT_IID_STR },
#endif
#ifdef NS_IDOMMUTATIONEVENT_IID_STR
    { &kDOMMutationEventIID, NS_IDOMMUTATIONEVENT_IID_STR },
#endif
#ifdef NS_IDOMNAMEDNODEMAP_IID_STR
    { &kDOMNamedNodeMapIID, NS_IDOMNAMEDNODEMAP_IID_STR },
#endif
#ifdef NS_IDOMNAVIGATOR_IID_STR
    { &kDOMNavigatorIID, NS_IDOMNAVIGATOR_IID_STR },
#endif
#ifdef NS_IDOMNODE_IID_STR
    { &kDOMNodeIID, NS_IDOMNODE_IID_STR },
#endif
#ifdef NS_IDOMNODEFILTER_IID_STR
    { &kDOMNodeFilterIID, NS_IDOMNODEFILTER_IID_STR },
#endif
#ifdef NS_IDOMNODEITERATOR_IID_STR
    { &kDOMNodeIteratorIID, NS_IDOMNODEITERATOR_IID_STR },
#endif
#ifdef NS_IDOMNODELIST_IID_STR
    { &kDOMNodeListIID, NS_IDOMNODELIST_IID_STR },
#endif
#ifdef NS_IDOMNOTATION_IID_STR
    { &kDOMNotationIID, NS_IDOMNOTATION_IID_STR },
#endif
#ifdef NS_IDOMNSDOCUMENT_IID_STR
    { &kDOMNSDocumentIID, NS_IDOMNSDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMNSEVENT_IID_STR
    { &kDOMNSEventIID, NS_IDOMNSEVENT_IID_STR },
#endif
#ifdef NS_IDOMNSHISTORY_IID_STR
    { &kDOMNSHistoryIID, NS_IDOMNSHISTORY_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLANCHORELEMENT_IID_STR
    { &kDOMNSHTMLAnchorElementIID, NS_IDOMNSHTMLANCHORELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLAREAELEMENT_IID_STR
    { &kDOMNSHTMLAreaElementIID, NS_IDOMNSHTMLAREAELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLBUTTONELEMENT_IID_STR
    { &kDOMNSHTMLButtonElementIID, NS_IDOMNSHTMLBUTTONELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLDOCUMENT_IID_STR
    { &kDOMNSHTMLDocumentIID, NS_IDOMNSHTMLDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLELEMENT_IID_STR
    { &kDOMNSHTMLElementIID, NS_IDOMNSHTMLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLFORMCONTROLLIST_IID_STR
    { &kDOMNSHTMLFormControlListIID, NS_IDOMNSHTMLFORMCONTROLLIST_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLFORMELEMENT_IID_STR
    { &kDOMNSHTMLFormElementIID, NS_IDOMNSHTMLFORMELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLFRAMEELEMENT_IID_STR
    { &kDOMNSHTMLFrameElementIID, NS_IDOMNSHTMLFRAMEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLIMAGEELEMENT_IID_STR
    { &kDOMNSHTMLImageElementIID, NS_IDOMNSHTMLIMAGEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLINPUTELEMENT_IID_STR
    { &kDOMNSHTMLInputElementIID, NS_IDOMNSHTMLINPUTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLOPTIONCOLLECTN_IID_STR
    { &kDOMNSHTMLOptionCollectnIID, NS_IDOMNSHTMLOPTIONCOLLECTN_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLSELECTELEMENT_IID_STR
    { &kDOMNSHTMLSelectElementIID, NS_IDOMNSHTMLSELECTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSHTMLTEXTAREAELEMENT_IID_STR
    { &kDOMNSHTMLTextAreaElementIID, NS_IDOMNSHTMLTEXTAREAELEMENT_IID_STR },
#endif
#ifdef NS_IDOMNSLOCATION_IID_STR
    { &kDOMNSLocationIID, NS_IDOMNSLOCATION_IID_STR },
#endif
#ifdef NS_IDOMNSRANGE_IID_STR
    { &kDOMNSRangeIID, NS_IDOMNSRANGE_IID_STR },
#endif
#ifdef NS_IDOMNSUIEVENT_IID_STR
    { &kDOMNSUIEventIID, NS_IDOMNSUIEVENT_IID_STR },
#endif
#ifdef NS_IDOMNSXBLFORMCONTROL_IID_STR
    { &kDOMNSXBLFormControlIID, NS_IDOMNSXBLFORMCONTROL_IID_STR },
#endif
#ifdef NS_IDOMPARSER_IID_STR
    { &kDOMParserIID, NS_IDOMPARSER_IID_STR },
#endif
#ifdef NS_IDOMPKCS11_IID_STR
    { &kDOMPkcs11IID, NS_IDOMPKCS11_IID_STR },
#endif
#ifdef NS_IDOMPLUGIN_IID_STR
    { &kDOMPluginIID, NS_IDOMPLUGIN_IID_STR },
#endif
#ifdef NS_IDOMPLUGINARRAY_IID_STR
    { &kDOMPluginArrayIID, NS_IDOMPLUGINARRAY_IID_STR },
#endif
#ifdef NS_IDOMPROCESSINGINSTRUCTION_IID_STR
    { &kDOMProcessingInstructionIID, NS_IDOMPROCESSINGINSTRUCTION_IID_STR },
#endif
#ifdef NS_IDOMRANGE_IID_STR
    { &kDOMRangeIID, NS_IDOMRANGE_IID_STR },
#endif
#ifdef NS_IDOMRANGEEXCEPTION_IID_STR
    { &kDOMRangeExceptionIID, NS_IDOMRANGEEXCEPTION_IID_STR },
#endif
#ifdef NS_IDOMRECT_IID_STR
    { &kDOMRectIID, NS_IDOMRECT_IID_STR },
#endif
#ifdef NS_IDOMRGBCOLOR_IID_STR
    { &kDOMRGBColorIID, NS_IDOMRGBCOLOR_IID_STR },
#endif
#ifdef NS_IDOMSCREEN_IID_STR
    { &kDOMScreenIID, NS_IDOMSCREEN_IID_STR },
#endif
#ifdef NS_IDOMSERIALIZER_IID_STR
    { &kDOMSerializerIID, NS_IDOMSERIALIZER_IID_STR },
#endif
#ifdef NS_IDOMSTYLESHEET_IID_STR
    { &kDOMStyleSheetIID, NS_IDOMSTYLESHEET_IID_STR },
#endif
#ifdef NS_IDOMSTYLESHEETLIST_IID_STR
    { &kDOMStyleSheetListIID, NS_IDOMSTYLESHEETLIST_IID_STR },
#endif
#ifdef NS_IDOMTEXT_IID_STR
    { &kDOMTextIID, NS_IDOMTEXT_IID_STR },
#endif
#ifdef NS_IDOMTREEWALKER_IID_STR
    { &kDOMTreeWalkerIID, NS_IDOMTREEWALKER_IID_STR },
#endif
#ifdef NS_IDOMUIEVENT_IID_STR
    { &kDOMUIEventIID, NS_IDOMUIEVENT_IID_STR },
#endif
#ifdef NS_IDOMVIEWCSS_IID_STR
    { &kDOMViewCSSIID, NS_IDOMVIEWCSS_IID_STR },
#endif
#ifdef NS_IDOMWINDOW_IID_STR
    { &kDOMWindowIID, NS_IDOMWINDOW_IID_STR },
#endif
#ifdef NS_IDOMWINDOWCOLLECTION_IID_STR
    { &kDOMWindowCollectionIID, NS_IDOMWINDOWCOLLECTION_IID_STR },
#endif
#ifdef NS_IDOMWINDOWINTERNAL_IID_STR
    { &kDOMWindowInternalIID, NS_IDOMWINDOWINTERNAL_IID_STR },
#endif
#ifdef NS_IDOMXMLDOCUMENT_IID_STR
    { &kDOMXMLDocumentIID, NS_IDOMXMLDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMXPATHEVALUATOR_IID_STR
    { &kDOMXPathEvaluatorIID, NS_IDOMXPATHEVALUATOR_IID_STR },
#endif
#ifdef NS_IDOMXPATHEXCEPTION_IID_STR
    { &kDOMXPathExceptionIID, NS_IDOMXPATHEXCEPTION_IID_STR },
#endif
#ifdef NS_IDOMXPATHEXPRESSION_IID_STR
    { &kDOMXPathExpressionIID, NS_IDOMXPATHEXPRESSION_IID_STR },
#endif
#ifdef NS_IDOMXPATHNAMESPACE_IID_STR
    { &kDOMXPathNamespaceIID, NS_IDOMXPATHNAMESPACE_IID_STR },
#endif
#ifdef NS_IDOMXPATHNSRESOLVER_IID_STR
    { &kDOMXPathNSResolverIID, NS_IDOMXPATHNSRESOLVER_IID_STR },
#endif
#ifdef NS_IDOMXPATHRESULT_IID_STR
    { &kDOMXPathResultIID, NS_IDOMXPATHRESULT_IID_STR },
#endif
#ifdef NS_IDOMXULBUTTONELEMENT_IID_STR
    { &kDOMXULButtonElementIID, NS_IDOMXULBUTTONELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULCHECKBOXELEMENT_IID_STR
    { &kDOMXULCheckboxElementIID, NS_IDOMXULCHECKBOXELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULCOMMANDDISPATCHER_IID_STR
    { &kDOMXULCommandDispatcherIID, NS_IDOMXULCOMMANDDISPATCHER_IID_STR },
#endif
#ifdef NS_IDOMXULCONTROLELEMENT_IID_STR
    { &kDOMXULControlElementIID, NS_IDOMXULCONTROLELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULDESCRIPTIONELEMENT_IID_STR
    { &kDOMXULDescriptionElementIID, NS_IDOMXULDESCRIPTIONELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULDOCUMENT_IID_STR
    { &kDOMXULDocumentIID, NS_IDOMXULDOCUMENT_IID_STR },
#endif
#ifdef NS_IDOMXULELEMENT_IID_STR
    { &kDOMXULElementIID, NS_IDOMXULELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULIMAGEELEMENT_IID_STR
    { &kDOMXULImageElementIID, NS_IDOMXULIMAGEELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULLABELEDCONTROLEL_IID_STR
    { &kDOMXULLabeledControlElIID, NS_IDOMXULLABELEDCONTROLEL_IID_STR },
#endif
#ifdef NS_IDOMXULLABELELEMENT_IID_STR
    { &kDOMXULLabelElementIID, NS_IDOMXULLABELELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULMENULISTELEMENT_IID_STR
    { &kDOMXULMenuListElementIID, NS_IDOMXULMENULISTELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULMULTSELECTCNTRLEL_IID_STR
    { &kDOMXULMultSelectCntrlElIID, NS_IDOMXULMULTSELECTCNTRLEL_IID_STR },
#endif
#ifdef NS_IDOMXULPOPUPELEMENT_IID_STR
    { &kDOMXULPopupElementIID, NS_IDOMXULPOPUPELEMENT_IID_STR },
#endif
#ifdef NS_IDOMXULSELECTCNTRLEL_IID_STR
    { &kDOMXULSelectCntrlElIID, NS_IDOMXULSELECTCNTRLEL_IID_STR },
#endif
#ifdef NS_IDOMXULSELECTCNTRLITEMEL_IID_STR
    { &kDOMXULSelectCntrlItemElIID, NS_IDOMXULSELECTCNTRLITEMEL_IID_STR },
#endif
#ifdef NS_IDOWNLOAD_IID_STR
    { &kDownloadIID, NS_IDOWNLOAD_IID_STR },
#endif
#ifdef NS_IDOWNLOADER_IID_STR
    { &kDownloaderIID, NS_IDOWNLOADER_IID_STR },
#endif
#ifdef NS_IDOWNLOADMANAGER_IID_STR
    { &kDownloadManagerIID, NS_IDOWNLOADMANAGER_IID_STR },
#endif
#ifdef NS_IDOWNLOADPROGRESSLISTENER_IID_STR
    { &kDownloadProgressListenerIID, NS_IDOWNLOADPROGRESSLISTENER_IID_STR },
#endif
#ifdef NS_IDRAGDROPHANDLER_IID_STR
    { &kDragDropHandlerIID, NS_IDRAGDROPHANDLER_IID_STR },
#endif
#ifdef NS_IDRAGDROPOVERRIDE_IID_STR
    { &kDragDropOverrideIID, NS_IDRAGDROPOVERRIDE_IID_STR },
#endif
#ifdef NS_IDRAGSERVICE_IID_STR
    { &kDragServiceIID, NS_IDRAGSERVICE_IID_STR },
#endif
#ifdef NS_IDRAGSESSION_IID_STR
    { &kDragSessionIID, NS_IDRAGSESSION_IID_STR },
#endif
#ifdef NS_IDRAGTRACKER_IID_STR
    { &kDragTrackerIID, NS_IDRAGTRACKER_IID_STR },
#endif
#ifdef NS_IEDITACTIONLISTENER_IID_STR
    { &kEditActionListenerIID, NS_IEDITACTIONLISTENER_IID_STR },
#endif
#ifdef NS_IEDITINGSESSION_IID_STR
    { &kEditingSessionIID, NS_IEDITINGSESSION_IID_STR },
#endif
#ifdef NS_IEDITOR_IID_STR
    { &kEditorIID, NS_IEDITOR_IID_STR },
#endif
#ifdef NS_IEDITORBOXOBJECT_IID_STR
    { &kEditorBoxObjectIID, NS_IEDITORBOXOBJECT_IID_STR },
#endif
#ifdef NS_IEDITORDOCSHELL_IID_STR
    { &kEditorDocShellIID, NS_IEDITORDOCSHELL_IID_STR },
#endif
#ifdef NS_IEDITORIMESUPPORT_IID_STR
    { &kEditorIMESupportIID, NS_IEDITORIMESUPPORT_IID_STR },
#endif
#ifdef NS_IEDITORLOGGING_IID_STR
    { &kEditorLoggingIID, NS_IEDITORLOGGING_IID_STR },
#endif
#ifdef NS_IEDITORMAILSUPPORT_IID_STR
    { &kEditorMailSupportIID, NS_IEDITORMAILSUPPORT_IID_STR },
#endif
#ifdef NS_IEDITOROBSERVER_IID_STR
    { &kEditorObserverIID, NS_IEDITOROBSERVER_IID_STR },
#endif
#ifdef NS_IEDITORSPELLCHECK_IID_STR
    { &kEditorSpellCheckIID, NS_IEDITORSPELLCHECK_IID_STR },
#endif
#ifdef NS_IEDITORSTYLESHEETS_IID_STR
    { &kEditorStyleSheetsIID, NS_IEDITORSTYLESHEETS_IID_STR },
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW_IID_STR
    { &kEmbeddingSiteWindowIID, NS_IEMBEDDINGSITEWINDOW_IID_STR },
#endif
#ifdef NS_IEMBEDDINGSITEWINDOW2_IID_STR
    { &kEmbeddingSiteWindow2IID, NS_IEMBEDDINGSITEWINDOW2_IID_STR },
#endif
#ifdef NS_IENCODEDCHANNEL_IID_STR
    { &kEncodedChannelIID, NS_IENCODEDCHANNEL_IID_STR },
#endif
#ifdef NS_IENCRYPTEDSMIMEURISSRVC_IID_STR
    { &kEncryptedSMIMEURIsSrvcIID, NS_IENCRYPTEDSMIMEURISSRVC_IID_STR },
#endif
#ifdef NS_IENTITYCONVERTER_IID_STR
    { &kEntityConverterIID, NS_IENTITYCONVERTER_IID_STR },
#endif
#ifdef NS_IENTROPYCOLLECTOR_IID_STR
    { &kEntropyCollectorIID, NS_IENTROPYCOLLECTOR_IID_STR },
#endif
#ifdef NS_IENUMERATOR_IID_STR
    { &kEnumeratorIID, NS_IENUMERATOR_IID_STR },
#endif
#ifdef NS_IERRORSERVICE_IID_STR
    { &kErrorServiceIID, NS_IERRORSERVICE_IID_STR },
#endif
#ifdef NS_IEVALUATESTRINGPROXY_IID_STR
    { &kEvaluateStringProxyIID, NS_IEVALUATESTRINGPROXY_IID_STR },
#endif
#ifdef NS_IEVENTHANDLER_IID_STR
    { &kEventHandlerIID, NS_IEVENTHANDLER_IID_STR },
#endif
#ifdef NS_IEVENTQUEUE_IID_STR
    { &kEventQueueIID, NS_IEVENTQUEUE_IID_STR },
#endif
#ifdef NS_IEVENTQUEUESERVICE_IID_STR
    { &kEventQueueServiceIID, NS_IEVENTQUEUESERVICE_IID_STR },
#endif
#ifdef NS_IEXCEPTION_IID_STR
    { &kExceptionIID, NS_IEXCEPTION_IID_STR },
#endif
#ifdef NS_IEXCEPTIONSERVICE_IID_STR
    { &kExceptionServiceIID, NS_IEXCEPTIONSERVICE_IID_STR },
#endif
#ifdef NS_IEXPATSINK_IID_STR
    { &kExpatSinkIID, NS_IEXPATSINK_IID_STR },
#endif
#ifdef NS_IEXTERNALHELPERAPPSERVICE_IID_STR
    { &kExternalHelperAppServiceIID, NS_IEXTERNALHELPERAPPSERVICE_IID_STR },
#endif
#ifdef NS_IEXTERNALPROTOCOLHANDLER_IID_STR
    { &kExternalProtocolHandlerIID, NS_IEXTERNALPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IEXTERNALPROTOCOLSERVICE_IID_STR
    { &kExternalProtocolServiceIID, NS_IEXTERNALPROTOCOLSERVICE_IID_STR },
#endif
#ifdef NS_IFACTORY_IID_STR
    { &kFactoryIID, NS_IFACTORY_IID_STR },
#endif
#ifdef NS_IFASTLOADFILECONTROL_IID_STR
    { &kFastLoadFileControlIID, NS_IFASTLOADFILECONTROL_IID_STR },
#endif
#ifdef NS_IFASTLOADSERVICE_IID_STR
    { &kFastLoadServiceIID, NS_IFASTLOADSERVICE_IID_STR },
#endif
#ifdef NS_IFILE_IID_STR
    { &kFileIID, NS_IFILE_IID_STR },
#endif
#ifdef NS_IFILECHANNEL_IID_STR
    { &kFileChannelIID, NS_IFILECHANNEL_IID_STR },
#endif
#ifdef NS_IFILEPICKER_IID_STR
    { &kFilePickerIID, NS_IFILEPICKER_IID_STR },
#endif
#ifdef NS_IFILEPROTOCOLHANDLER_IID_STR
    { &kFileProtocolHandlerIID, NS_IFILEPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IFILESPEC_IID_STR
    { &kFileSpecIID, NS_IFILESPEC_IID_STR },
#endif
#ifdef NS_IFILESTREAMS_IID_STR
    { &kFileStreamsIID, NS_IFILESTREAMS_IID_STR },
#endif
#ifdef NS_IFILEURL_IID_STR
    { &kFileURLIID, NS_IFILEURL_IID_STR },
#endif
#ifdef NS_IFILEUTILITIES_IID_STR
    { &kFileUtilitiesIID, NS_IFILEUTILITIES_IID_STR },
#endif
#ifdef NS_IFIND_IID_STR
    { &kFindIID, NS_IFIND_IID_STR },
#endif
#ifdef NS_IFINDSERVICE_IID_STR
    { &kFindServiceIID, NS_IFINDSERVICE_IID_STR },
#endif
#ifdef NS_IFOLDER_IID_STR
    { &kFolderIID, NS_IFOLDER_IID_STR },
#endif
#ifdef NS_IFOLDERLISTENER_IID_STR
    { &kFolderListenerIID, NS_IFOLDERLISTENER_IID_STR },
#endif
#ifdef NS_IFONTCATALOGSERVICE_IID_STR
    { &kFontCatalogServiceIID, NS_IFONTCATALOGSERVICE_IID_STR },
#endif
#ifdef NS_IFONTENUMERATOR_IID_STR
    { &kFontEnumeratorIID, NS_IFONTENUMERATOR_IID_STR },
#endif
#ifdef NS_IFONTLIST_IID_STR
    { &kFontListIID, NS_IFONTLIST_IID_STR },
#endif
#ifdef NS_IFONTPACKAGEHANDLER_IID_STR
    { &kFontPackageHandlerIID, NS_IFONTPACKAGEHANDLER_IID_STR },
#endif
#ifdef NS_IFONTPACKAGEPROXY_IID_STR
    { &kFontPackageProxyIID, NS_IFONTPACKAGEPROXY_IID_STR },
#endif
#ifdef NS_IFONTPACKAGESERVICE_IID_STR
    { &kFontPackageServiceIID, NS_IFONTPACKAGESERVICE_IID_STR },
#endif
#ifdef NS_IFORMATCONVERTER_IID_STR
    { &kFormatConverterIID, NS_IFORMATCONVERTER_IID_STR },
#endif
#ifdef NS_IFREETYPE2_IID_STR
    { &kFreeType2IID, NS_IFREETYPE2_IID_STR },
#endif
#ifdef NS_IFTPCHANNEL_IID_STR
    { &kFTPChannelIID, NS_IFTPCHANNEL_IID_STR },
#endif
#ifdef NS_IFULLSCREEN_IID_STR
    { &kFullScreenIID, NS_IFULLSCREEN_IID_STR },
#endif
#ifdef NS_IGENKEYPAIRINFODLG_IID_STR
    { &kGenKeypairInfoDlgIID, NS_IGENKEYPAIRINFODLG_IID_STR },
#endif
#ifdef NS_IGLOBALHISTORY_IID_STR
    { &kGlobalHistoryIID, NS_IGLOBALHISTORY_IID_STR },
#endif
#ifdef NS_IGRAPHICS_IID_STR
    { &kGraphicsIID, NS_IGRAPHICS_IID_STR },
#endif
#ifdef NS_IHASH_IID_STR
    { &kHashIID, NS_IHASH_IID_STR },
#endif
#ifdef NS_IHELPERAPPLAUNCHERDIALOG_IID_STR
    { &kHelperAppLauncherDialogIID, NS_IHELPERAPPLAUNCHERDIALOG_IID_STR },
#endif
#ifdef NS_IHISTORYENTRY_IID_STR
    { &kHistoryEntryIID, NS_IHISTORYENTRY_IID_STR },
#endif
#ifdef NS_IHTMLEDITOR_IID_STR
    { &kHTMLEditorIID, NS_IHTMLEDITOR_IID_STR },
#endif
#ifdef NS_IHTMLOBJECTRESIZER_IID_STR
    { &kHTMLObjectResizerIID, NS_IHTMLOBJECTRESIZER_IID_STR },
#endif
#ifdef NS_IHTTPAUTHENTICATOR_IID_STR
    { &kHttpAuthenticatorIID, NS_IHTTPAUTHENTICATOR_IID_STR },
#endif
#ifdef NS_IHTTPCHANNEL_IID_STR
    { &kHttpChannelIID, NS_IHTTPCHANNEL_IID_STR },
#endif
#ifdef NS_IHTTPCHANNELINTERNAL_IID_STR
    { &kHttpChannelInternalIID, NS_IHTTPCHANNELINTERNAL_IID_STR },
#endif
#ifdef NS_IHTTPEVENTSINK_IID_STR
    { &kHttpEventSinkIID, NS_IHTTPEVENTSINK_IID_STR },
#endif
#ifdef NS_IHTTPHEADERLISTENER_IID_STR
    { &kHTTPHeaderListenerIID, NS_IHTTPHEADERLISTENER_IID_STR },
#endif
#ifdef NS_IHTTPHEADERVISITOR_IID_STR
    { &kHttpHeaderVisitorIID, NS_IHTTPHEADERVISITOR_IID_STR },
#endif
#ifdef NS_IHTTPINDEX_IID_STR
    { &kHTTPIndexIID, NS_IHTTPINDEX_IID_STR },
#endif
#ifdef NS_IHTTPNOTIFY_IID_STR
    { &kHttpNotifyIID, NS_IHTTPNOTIFY_IID_STR },
#endif
#ifdef NS_IHTTPPROTOCOLHANDLER_IID_STR
    { &kHttpProtocolHandlerIID, NS_IHTTPPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IICONURI_IID_STR
    { &kIconURIIID, NS_IICONURI_IID_STR },
#endif
#ifdef NS_IIDNSERVICE_IID_STR
    { &kIDNServiceIID, NS_IIDNSERVICE_IID_STR },
#endif
#ifdef NS_IIFRAMEBOXOBJECT_IID_STR
    { &kIFrameBoxObjectIID, NS_IIFRAMEBOXOBJECT_IID_STR },
#endif
#ifdef NS_IIMAGEDOCUMENT_IID_STR
    { &kImageDocumentIID, NS_IIMAGEDOCUMENT_IID_STR },
#endif
#ifdef NS_IIMAPFLAGANDUIDSTATE_IID_STR
    { &kImapFlagAndUidStateIID, NS_IIMAPFLAGANDUIDSTATE_IID_STR },
#endif
#ifdef NS_IIMAPHEADERXFERINFO_IID_STR
    { &kImapHeaderXferInfoIID, NS_IIMAPHEADERXFERINFO_IID_STR },
#endif
#ifdef NS_IIMAPINCOMINGSERVER_IID_STR
    { &kImapIncomingServerIID, NS_IIMAPINCOMINGSERVER_IID_STR },
#endif
#ifdef NS_IIMAPMAILFOLDERSINK_IID_STR
    { &kImapMailFolderSinkIID, NS_IIMAPMAILFOLDERSINK_IID_STR },
#endif
#ifdef NS_IIMAPMESSAGESINK_IID_STR
    { &kImapMessageSinkIID, NS_IIMAPMESSAGESINK_IID_STR },
#endif
#ifdef NS_IIMAPMOCKCHANNEL_IID_STR
    { &kImapMockChannelIID, NS_IIMAPMOCKCHANNEL_IID_STR },
#endif
#ifdef NS_IIMAPPROTOCOL_IID_STR
    { &kImapProtocolIID, NS_IIMAPPROTOCOL_IID_STR },
#endif
#ifdef NS_IIMAPSERVERSINK_IID_STR
    { &kImapServerSinkIID, NS_IIMAPSERVERSINK_IID_STR },
#endif
#ifdef NS_IIMAPSERVICE_IID_STR
    { &kImapServiceIID, NS_IIMAPSERVICE_IID_STR },
#endif
#ifdef NS_IIMAPURL_IID_STR
    { &kImapUrlIID, NS_IIMAPURL_IID_STR },
#endif
#ifdef NS_IIMGMANAGER_IID_STR
    { &kImgManagerIID, NS_IIMGMANAGER_IID_STR },
#endif
#ifdef NS_IIMPORTABDESCRIPTOR_IID_STR
    { &kImportABDescriptorIID, NS_IIMPORTABDESCRIPTOR_IID_STR },
#endif
#ifdef NS_IIMPORTADDRESSBOOKS_IID_STR
    { &kImportAddressBooksIID, NS_IIMPORTADDRESSBOOKS_IID_STR },
#endif
#ifdef NS_IIMPORTFIELDMAP_IID_STR
    { &kImportFieldMapIID, NS_IIMPORTFIELDMAP_IID_STR },
#endif
#ifdef NS_IIMPORTGENERIC_IID_STR
    { &kImportGenericIID, NS_IIMPORTGENERIC_IID_STR },
#endif
#ifdef NS_IIMPORTMAIL_IID_STR
    { &kImportMailIID, NS_IIMPORTMAIL_IID_STR },
#endif
#ifdef NS_IIMPORTMAILBOXDESCRIPTOR_IID_STR
    { &kImportMailboxDescriptorIID, NS_IIMPORTMAILBOXDESCRIPTOR_IID_STR },
#endif
#ifdef NS_IIMPORTMIMEENCODE_IID_STR
    { &kImportMimeEncodeIID, NS_IIMPORTMIMEENCODE_IID_STR },
#endif
#ifdef NS_IIMPORTMODULE_IID_STR
    { &kImportModuleIID, NS_IIMPORTMODULE_IID_STR },
#endif
#ifdef NS_IIMPORTSERVICE_IID_STR
    { &kImportServiceIID, NS_IIMPORTSERVICE_IID_STR },
#endif
#ifdef NS_IIMPORTSETTINGS_IID_STR
    { &kImportSettingsIID, NS_IIMPORTSETTINGS_IID_STR },
#endif
#ifdef NS_IINCOMINGSERVERLISTENER_IID_STR
    { &kIncomingServerListenerIID, NS_IINCOMINGSERVERLISTENER_IID_STR },
#endif
#ifdef NS_IINPUTSTREAM_IID_STR
    { &kInputStreamIID, NS_IINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IINPUTSTREAMCHANNEL_IID_STR
    { &kInputStreamChannelIID, NS_IINPUTSTREAMCHANNEL_IID_STR },
#endif
#ifdef NS_IINPUTSTREAMPUMP_IID_STR
    { &kInputStreamPumpIID, NS_IINPUTSTREAMPUMP_IID_STR },
#endif
#ifdef NS_IINPUTSTREAMTEE_IID_STR
    { &kInputStreamTeeIID, NS_IINPUTSTREAMTEE_IID_STR },
#endif
#ifdef NS_IINTERFACEINFO_IID_STR
    { &kInterfaceInfoIID, NS_IINTERFACEINFO_IID_STR },
#endif
#ifdef NS_IINTERFACEINFOMANAGER_IID_STR
    { &kInterfaceInfoManagerIID, NS_IINTERFACEINFOMANAGER_IID_STR },
#endif
#ifdef NS_IINTERFACEREQUESTOR_IID_STR
    { &kInterfaceRequestorIID, NS_IINTERFACEREQUESTOR_IID_STR },
#endif
#ifdef NS_IIOSERVICE_IID_STR
    { &kIOServiceIID, NS_IIOSERVICE_IID_STR },
#endif
#ifdef NS_IJAR_IID_STR
    { &kJARIID, NS_IJAR_IID_STR },
#endif
#ifdef NS_IJARCHANNEL_IID_STR
    { &kJARChannelIID, NS_IJARCHANNEL_IID_STR },
#endif
#ifdef NS_IJARPROTOCOLHANDLER_IID_STR
    { &kJARProtocolHandlerIID, NS_IJARPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IJARURI_IID_STR
    { &kJARURIIID, NS_IJARURI_IID_STR },
#endif
#ifdef NS_IJRILIVECONNECTPIPEER_IID_STR
    { &kJRILiveConnectPIPeerIID, NS_IJRILIVECONNECTPIPEER_IID_STR },
#endif
#ifdef NS_IJRILIVECONNECTPLUGIN_IID_STR
    { &kJRILiveConnectPluginIID, NS_IJRILIVECONNECTPLUGIN_IID_STR },
#endif
#ifdef NS_IJSCONSOLESERVICE_IID_STR
    { &kJSConsoleServiceIID, NS_IJSCONSOLESERVICE_IID_STR },
#endif
#ifdef NS_IJSCONTEXTSTACK_IID_STR
    { &kJSContextStackIID, NS_IJSCONTEXTSTACK_IID_STR },
#endif
#ifdef NS_IJSRUNTIMESERVICE_IID_STR
    { &kJSRuntimeServiceIID, NS_IJSRUNTIMESERVICE_IID_STR },
#endif
#ifdef NS_IKEYEDSTREAMGENERATOR_IID_STR
    { &kKeyedStreamGeneratorIID, NS_IKEYEDSTREAMGENERATOR_IID_STR },
#endif
#ifdef NS_IKEYGENTHREAD_IID_STR
    { &kKeygenThreadIID, NS_IKEYGENTHREAD_IID_STR },
#endif
#ifdef NS_ILANGUAGEATOM_IID_STR
    { &kLanguageAtomIID, NS_ILANGUAGEATOM_IID_STR },
#endif
#ifdef NS_ILANGUAGEATOMSERVICE_IID_STR
    { &kLanguageAtomServiceIID, NS_ILANGUAGEATOMSERVICE_IID_STR },
#endif
#ifdef NS_ILDAPAUTOCOMPFORMATTER_IID_STR
    { &kLDAPAutoCompFormatterIID, NS_ILDAPAUTOCOMPFORMATTER_IID_STR },
#endif
#ifdef NS_ILDAPAUTOCOMPLETESESSION_IID_STR
    { &kLDAPAutoCompleteSessionIID, NS_ILDAPAUTOCOMPLETESESSION_IID_STR },
#endif
#ifdef NS_ILDAPBERVALUE_IID_STR
    { &kLDAPBERValueIID, NS_ILDAPBERVALUE_IID_STR },
#endif
#ifdef NS_ILDAPCONNECTION_IID_STR
    { &kLDAPConnectionIID, NS_ILDAPCONNECTION_IID_STR },
#endif
#ifdef NS_ILDAPERRORS_IID_STR
    { &kLDAPErrorsIID, NS_ILDAPERRORS_IID_STR },
#endif
#ifdef NS_ILDAPMESSAGE_IID_STR
    { &kLDAPMessageIID, NS_ILDAPMESSAGE_IID_STR },
#endif
#ifdef NS_ILDAPMESSAGELISTENER_IID_STR
    { &kLDAPMessageListenerIID, NS_ILDAPMESSAGELISTENER_IID_STR },
#endif
#ifdef NS_ILDAPOPERATION_IID_STR
    { &kLDAPOperationIID, NS_ILDAPOPERATION_IID_STR },
#endif
#ifdef NS_ILDAPPREFSSERVICE_IID_STR
    { &kLDAPPrefsServiceIID, NS_ILDAPPREFSSERVICE_IID_STR },
#endif
#ifdef NS_ILDAPSERVER_IID_STR
    { &kLDAPServerIID, NS_ILDAPSERVER_IID_STR },
#endif
#ifdef NS_ILDAPSERVICE_IID_STR
    { &kLDAPServiceIID, NS_ILDAPSERVICE_IID_STR },
#endif
#ifdef NS_ILDAPSYNCQUERY_IID_STR
    { &kLDAPSyncQueryIID, NS_ILDAPSYNCQUERY_IID_STR },
#endif
#ifdef NS_ILDAPURL_IID_STR
    { &kLDAPURLIID, NS_ILDAPURL_IID_STR },
#endif
#ifdef NS_ILINEINPUTSTREAM_IID_STR
    { &kLineInputStreamIID, NS_ILINEINPUTSTREAM_IID_STR },
#endif
#ifdef NS_ILISTBOXOBJECT_IID_STR
    { &kListBoxObjectIID, NS_ILISTBOXOBJECT_IID_STR },
#endif
#ifdef NS_ILOADGROUP_IID_STR
    { &kLoadGroupIID, NS_ILOADGROUP_IID_STR },
#endif
#ifdef NS_ILOCALE_IID_STR
    { &kLocaleIID, NS_ILOCALE_IID_STR },
#endif
#ifdef NS_ILOCALESERVICE_IID_STR
    { &kLocaleServiceIID, NS_ILOCALESERVICE_IID_STR },
#endif
#ifdef NS_ILOCALFILE_IID_STR
    { &kLocalFileIID, NS_ILOCALFILE_IID_STR },
#endif
#ifdef NS_ILOCALMAILINCOMINGSERVER_IID_STR
    { &kLocalMailIncomingServerIID, NS_ILOCALMAILINCOMINGSERVER_IID_STR },
#endif
#ifdef NS_IMAILBOXSERVICE_IID_STR
    { &kMailboxServiceIID, NS_IMAILBOXSERVICE_IID_STR },
#endif
#ifdef NS_IMAILBOXSPEC_IID_STR
    { &kMailboxSpecIID, NS_IMAILBOXSPEC_IID_STR },
#endif
#ifdef NS_IMAILBOXURL_IID_STR
    { &kMailboxUrlIID, NS_IMAILBOXURL_IID_STR },
#endif
#ifdef NS_IMARKUPDOCUMENTVIEWER_IID_STR
    { &kMarkupDocumentViewerIID, NS_IMARKUPDOCUMENTVIEWER_IID_STR },
#endif
#ifdef NS_IMEMORY_IID_STR
    { &kMemoryIID, NS_IMEMORY_IID_STR },
#endif
#ifdef NS_IMENUBOXOBJECT_IID_STR
    { &kMenuBoxObjectIID, NS_IMENUBOXOBJECT_IID_STR },
#endif
#ifdef NS_IMENUROLLUP_IID_STR
    { &kMenuRollupIID, NS_IMENUROLLUP_IID_STR },
#endif
#ifdef NS_IMESSENGER_IID_STR
    { &kMessengerIID, NS_IMESSENGER_IID_STR },
#endif
#ifdef NS_IMESSENGERMIGRATOR_IID_STR
    { &kMessengerMigratorIID, NS_IMESSENGERMIGRATOR_IID_STR },
#endif
#ifdef NS_IMESSENGEROSINTEGRATION_IID_STR
    { &kMessengerOSIntegrationIID, NS_IMESSENGEROSINTEGRATION_IID_STR },
#endif
#ifdef NS_IMESSENGERWINDOWSERVICE_IID_STR
    { &kMessengerWindowServiceIID, NS_IMESSENGERWINDOWSERVICE_IID_STR },
#endif
#ifdef NS_IMIMEEMITTER_IID_STR
    { &kMimeEmitterIID, NS_IMIMEEMITTER_IID_STR },
#endif
#ifdef NS_IMIMEHEADERS_IID_STR
    { &kMimeHeadersIID, NS_IMIMEHEADERS_IID_STR },
#endif
#ifdef NS_IMIMEINFO_IID_STR
    { &kMIMEInfoIID, NS_IMIMEINFO_IID_STR },
#endif
#ifdef NS_IMIMEINPUTSTREAM_IID_STR
    { &kMIMEInputStreamIID, NS_IMIMEINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IMIMEMISCSTATUS_IID_STR
    { &kMimeMiscStatusIID, NS_IMIMEMISCSTATUS_IID_STR },
#endif
#ifdef NS_IMIMESERVICE_IID_STR
    { &kMIMEServiceIID, NS_IMIMESERVICE_IID_STR },
#endif
#ifdef NS_IMIMESTREAMCONVERTER_IID_STR
    { &kMimeStreamConverterIID, NS_IMIMESTREAMCONVERTER_IID_STR },
#endif
#ifdef NS_IMODULE_IID_STR
    { &kModuleIID, NS_IMODULE_IID_STR },
#endif
#ifdef NS_IMSGACCOUNT_IID_STR
    { &kMsgAccountIID, NS_IMSGACCOUNT_IID_STR },
#endif
#ifdef NS_IMSGACCOUNTMANAGER_IID_STR
    { &kMsgAccountManagerIID, NS_IMSGACCOUNTMANAGER_IID_STR },
#endif
#ifdef NS_IMSGATTACHMENT_IID_STR
    { &kMsgAttachmentIID, NS_IMSGATTACHMENT_IID_STR },
#endif
#ifdef NS_IMSGBIFFMANAGER_IID_STR
    { &kMsgBiffManagerIID, NS_IMSGBIFFMANAGER_IID_STR },
#endif
#ifdef NS_IMSGCOMPFIELDS_IID_STR
    { &kMsgCompFieldsIID, NS_IMSGCOMPFIELDS_IID_STR },
#endif
#ifdef NS_IMSGCOMPOSE_IID_STR
    { &kMsgComposeIID, NS_IMSGCOMPOSE_IID_STR },
#endif
#ifdef NS_IMSGCOMPOSEPARAMS_IID_STR
    { &kMsgComposeParamsIID, NS_IMSGCOMPOSEPARAMS_IID_STR },
#endif
#ifdef NS_IMSGCOMPOSEPROGRESSPARAMS_IID_STR
    { &kMsgComposeProgressParamsIID, NS_IMSGCOMPOSEPROGRESSPARAMS_IID_STR },
#endif
#ifdef NS_IMSGCOMPOSESECURE_IID_STR
    { &kMsgComposeSecureIID, NS_IMSGCOMPOSESECURE_IID_STR },
#endif
#ifdef NS_IMSGCOMPOSESERVICE_IID_STR
    { &kMsgComposeServiceIID, NS_IMSGCOMPOSESERVICE_IID_STR },
#endif
#ifdef NS_IMSGCOMPUTILS_IID_STR
    { &kMsgCompUtilsIID, NS_IMSGCOMPUTILS_IID_STR },
#endif
#ifdef NS_IMSGCOPYSERVICE_IID_STR
    { &kMsgCopyServiceIID, NS_IMSGCOPYSERVICE_IID_STR },
#endif
#ifdef NS_IMSGCOPYSERVICELISTENER_IID_STR
    { &kMsgCopyServiceListenerIID, NS_IMSGCOPYSERVICELISTENER_IID_STR },
#endif
#ifdef NS_IMSGDATABASE_IID_STR
    { &kMsgDatabaseIID, NS_IMSGDATABASE_IID_STR },
#endif
#ifdef NS_IMSGDBVIEW_IID_STR
    { &kMsgDBViewIID, NS_IMSGDBVIEW_IID_STR },
#endif
#ifdef NS_IMSGDRAFT_IID_STR
    { &kMsgDraftIID, NS_IMSGDRAFT_IID_STR },
#endif
#ifdef NS_IMSGFILTER_IID_STR
    { &kMsgFilterIID, NS_IMSGFILTER_IID_STR },
#endif
#ifdef NS_IMSGFILTERHITNOTIFY_IID_STR
    { &kMsgFilterHitNotifyIID, NS_IMSGFILTERHITNOTIFY_IID_STR },
#endif
#ifdef NS_IMSGFILTERLIST_IID_STR
    { &kMsgFilterListIID, NS_IMSGFILTERLIST_IID_STR },
#endif
#ifdef NS_IMSGFILTERPLUGIN_IID_STR
    { &kMsgFilterPluginIID, NS_IMSGFILTERPLUGIN_IID_STR },
#endif
#ifdef NS_IMSGFILTERSERVICE_IID_STR
    { &kMsgFilterServiceIID, NS_IMSGFILTERSERVICE_IID_STR },
#endif
#ifdef NS_IMSGFOLDER_IID_STR
    { &kMsgFolderIID, NS_IMSGFOLDER_IID_STR },
#endif
#ifdef NS_IMSGFOLDERCACHE_IID_STR
    { &kMsgFolderCacheIID, NS_IMSGFOLDERCACHE_IID_STR },
#endif
#ifdef NS_IMSGFOLDERCACHEELEMENT_IID_STR
    { &kMsgFolderCacheElementIID, NS_IMSGFOLDERCACHEELEMENT_IID_STR },
#endif
#ifdef NS_IMSGFOLDERCOMPACTOR_IID_STR
    { &kMsgFolderCompactorIID, NS_IMSGFOLDERCOMPACTOR_IID_STR },
#endif
#ifdef NS_IMSGGROUPRECORD_IID_STR
    { &kMsgGroupRecordIID, NS_IMSGGROUPRECORD_IID_STR },
#endif
#ifdef NS_IMSGHDR_IID_STR
    { &kMsgHdrIID, NS_IMSGHDR_IID_STR },
#endif
#ifdef NS_IMSGHEADERPARSER_IID_STR
    { &kMsgHeaderParserIID, NS_IMSGHEADERPARSER_IID_STR },
#endif
#ifdef NS_IMSGHOST_IID_STR
    { &kMsgHostIID, NS_IMSGHOST_IID_STR },
#endif
#ifdef NS_IMSGIDENTITY_IID_STR
    { &kMsgIdentityIID, NS_IMSGIDENTITY_IID_STR },
#endif
#ifdef NS_IMSGIMAPMAILFOLDER_IID_STR
    { &kMsgImapMailFolderIID, NS_IMSGIMAPMAILFOLDER_IID_STR },
#endif
#ifdef NS_IMSGINCOMINGSERVER_IID_STR
    { &kMsgIncomingServerIID, NS_IMSGINCOMINGSERVER_IID_STR },
#endif
#ifdef NS_IMSGLOCALMAILFOLDER_IID_STR
    { &kMsgLocalMailFolderIID, NS_IMSGLOCALMAILFOLDER_IID_STR },
#endif
#ifdef NS_IMSGLOGONREDIRECTOR_IID_STR
    { &kMsgLogonRedirectorIID, NS_IMSGLOGONREDIRECTOR_IID_STR },
#endif
#ifdef NS_IMSGMAILNEWSURL_IID_STR
    { &kMsgMailNewsUrlIID, NS_IMSGMAILNEWSURL_IID_STR },
#endif
#ifdef NS_IMSGMAILSESSION_IID_STR
    { &kMsgMailSessionIID, NS_IMSGMAILSESSION_IID_STR },
#endif
#ifdef NS_IMSGMAILVIEW_IID_STR
    { &kMsgMailViewIID, NS_IMSGMAILVIEW_IID_STR },
#endif
#ifdef NS_IMSGMAILVIEWLIST_IID_STR
    { &kMsgMailViewListIID, NS_IMSGMAILVIEWLIST_IID_STR },
#endif
#ifdef NS_IMSGMDNGENERATOR_IID_STR
    { &kMsgMdnGeneratorIID, NS_IMSGMDNGENERATOR_IID_STR },
#endif
#ifdef NS_IMSGMESSAGESERVICE_IID_STR
    { &kMsgMessageServiceIID, NS_IMSGMESSAGESERVICE_IID_STR },
#endif
#ifdef NS_IMSGNEWSFOLDER_IID_STR
    { &kMsgNewsFolderIID, NS_IMSGNEWSFOLDER_IID_STR },
#endif
#ifdef NS_IMSGOFFLINEIMAPOPERATION_IID_STR
    { &kMsgOfflineImapOperationIID, NS_IMSGOFFLINEIMAPOPERATION_IID_STR },
#endif
#ifdef NS_IMSGOFFLINEMANAGER_IID_STR
    { &kMsgOfflineManagerIID, NS_IMSGOFFLINEMANAGER_IID_STR },
#endif
#ifdef NS_IMSGOFFLINENEWSSTATE_IID_STR
    { &kMsgOfflineNewsStateIID, NS_IMSGOFFLINENEWSSTATE_IID_STR },
#endif
#ifdef NS_IMSGPARSEMAILMSGSTATE_IID_STR
    { &kMsgParseMailMsgStateIID, NS_IMSGPARSEMAILMSGSTATE_IID_STR },
#endif
#ifdef NS_IMSGPRINTENGINE_IID_STR
    { &kMsgPrintEngineIID, NS_IMSGPRINTENGINE_IID_STR },
#endif
#ifdef NS_IMSGPROGRESS_IID_STR
    { &kMsgProgressIID, NS_IMSGPROGRESS_IID_STR },
#endif
#ifdef NS_IMSGPROTOCOLINFO_IID_STR
    { &kMsgProtocolInfoIID, NS_IMSGPROTOCOLINFO_IID_STR },
#endif
#ifdef NS_IMSGPURGESERVICE_IID_STR
    { &kMsgPurgeServiceIID, NS_IMSGPURGESERVICE_IID_STR },
#endif
#ifdef NS_IMSGQUOTE_IID_STR
    { &kMsgQuoteIID, NS_IMSGQUOTE_IID_STR },
#endif
#ifdef NS_IMSGRDFDATASOURCE_IID_STR
    { &kMsgRDFDataSourceIID, NS_IMSGRDFDATASOURCE_IID_STR },
#endif
#ifdef NS_IMSGRECIPIENTARRAY_IID_STR
    { &kMsgRecipientArrayIID, NS_IMSGRECIPIENTARRAY_IID_STR },
#endif
#ifdef NS_IMSGSEARCHADAPTER_IID_STR
    { &kMsgSearchAdapterIID, NS_IMSGSEARCHADAPTER_IID_STR },
#endif
#ifdef NS_IMSGSEARCHNOTIFY_IID_STR
    { &kMsgSearchNotifyIID, NS_IMSGSEARCHNOTIFY_IID_STR },
#endif
#ifdef NS_IMSGSEARCHSCOPETERM_IID_STR
    { &kMsgSearchScopeTermIID, NS_IMSGSEARCHSCOPETERM_IID_STR },
#endif
#ifdef NS_IMSGSEARCHSESSION_IID_STR
    { &kMsgSearchSessionIID, NS_IMSGSEARCHSESSION_IID_STR },
#endif
#ifdef NS_IMSGSEARCHTERM_IID_STR
    { &kMsgSearchTermIID, NS_IMSGSEARCHTERM_IID_STR },
#endif
#ifdef NS_IMSGSEARCHVALIDITYMANAGER_IID_STR
    { &kMsgSearchValidityManagerIID, NS_IMSGSEARCHVALIDITYMANAGER_IID_STR },
#endif
#ifdef NS_IMSGSEARCHVALIDITYTABLE_IID_STR
    { &kMsgSearchValidityTableIID, NS_IMSGSEARCHVALIDITYTABLE_IID_STR },
#endif
#ifdef NS_IMSGSEARCHVALUE_IID_STR
    { &kMsgSearchValueIID, NS_IMSGSEARCHVALUE_IID_STR },
#endif
#ifdef NS_IMSGSEND_IID_STR
    { &kMsgSendIID, NS_IMSGSEND_IID_STR },
#endif
#ifdef NS_IMSGSENDLATER_IID_STR
    { &kMsgSendLaterIID, NS_IMSGSENDLATER_IID_STR },
#endif
#ifdef NS_IMSGSENDLATERLISTENER_IID_STR
    { &kMsgSendLaterListenerIID, NS_IMSGSENDLATERLISTENER_IID_STR },
#endif
#ifdef NS_IMSGSENDLISTENER_IID_STR
    { &kMsgSendListenerIID, NS_IMSGSENDLISTENER_IID_STR },
#endif
#ifdef NS_IMSGSENDREPORT_IID_STR
    { &kMsgSendReportIID, NS_IMSGSENDREPORT_IID_STR },
#endif
#ifdef NS_IMSGSIGNATURE_IID_STR
    { &kMsgSignatureIID, NS_IMSGSIGNATURE_IID_STR },
#endif
#ifdef NS_IMSGSMIMECOMPFIELDS_IID_STR
    { &kMsgSMIMECompFieldsIID, NS_IMSGSMIMECOMPFIELDS_IID_STR },
#endif
#ifdef NS_IMSGSMIMEHEADERSINK_IID_STR
    { &kMsgSMIMEHeaderSinkIID, NS_IMSGSMIMEHEADERSINK_IID_STR },
#endif
#ifdef NS_IMSGSTATUSFEEDBACK_IID_STR
    { &kMsgStatusFeedbackIID, NS_IMSGSTATUSFEEDBACK_IID_STR },
#endif
#ifdef NS_IMSGSTRINGSERVICE_IID_STR
    { &kMsgStringServiceIID, NS_IMSGSTRINGSERVICE_IID_STR },
#endif
#ifdef NS_IMSGTHREAD_IID_STR
    { &kMsgThreadIID, NS_IMSGTHREAD_IID_STR },
#endif
#ifdef NS_IMSGVCARD_IID_STR
    { &kMsgVCardIID, NS_IMSGVCARD_IID_STR },
#endif
#ifdef NS_IMSGWINDOW_IID_STR
    { &kMsgWindowIID, NS_IMSGWINDOW_IID_STR },
#endif
#ifdef NS_IMULTIPARTCHANNEL_IID_STR
    { &kMultiPartChannelIID, NS_IMULTIPARTCHANNEL_IID_STR },
#endif
#ifdef NS_IMULTIPLEXINPUTSTREAM_IID_STR
    { &kMultiplexInputStreamIID, NS_IMULTIPLEXINPUTSTREAM_IID_STR },
#endif
#ifdef NS_INATIVEAPPSUPPORT_IID_STR
    { &kNativeAppSupportIID, NS_INATIVEAPPSUPPORT_IID_STR },
#endif
#ifdef NS_INATIVECOMPONENTLOADER_IID_STR
    { &kNativeComponentLoaderIID, NS_INATIVECOMPONENTLOADER_IID_STR },
#endif
#ifdef NS_INATIVESCROLLBAR_IID_STR
    { &kNativeScrollbarIID, NS_INATIVESCROLLBAR_IID_STR },
#endif
#ifdef NS_INETMODREGENTRY_IID_STR
    { &kNetModRegEntryIID, NS_INETMODREGENTRY_IID_STR },
#endif
#ifdef NS_INETMODULEMGR_IID_STR
    { &kNetModuleMgrIID, NS_INETMODULEMGR_IID_STR },
#endif
#ifdef NS_INETNOTIFY_IID_STR
    { &kNetNotifyIID, NS_INETNOTIFY_IID_STR },
#endif
#ifdef NS_INEWSDATABASE_IID_STR
    { &kNewsDatabaseIID, NS_INEWSDATABASE_IID_STR },
#endif
#ifdef NS_INEWSDOWNLOADDIALOGARGS_IID_STR
    { &kNewsDownloadDialogArgsIID, NS_INEWSDOWNLOADDIALOGARGS_IID_STR },
#endif
#ifdef NS_INNTPARTICLELIST_IID_STR
    { &kNNTPArticleListIID, NS_INNTPARTICLELIST_IID_STR },
#endif
#ifdef NS_INNTPINCOMINGSERVER_IID_STR
    { &kNntpIncomingServerIID, NS_INNTPINCOMINGSERVER_IID_STR },
#endif
#ifdef NS_INNTPNEWSGROUPLIST_IID_STR
    { &kNNTPNewsgroupListIID, NS_INNTPNEWSGROUPLIST_IID_STR },
#endif
#ifdef NS_INNTPNEWSGROUPPOST_IID_STR
    { &kNNTPNewsgroupPostIID, NS_INNTPNEWSGROUPPOST_IID_STR },
#endif
#ifdef NS_INNTPPROTOCOL_IID_STR
    { &kNNTPProtocolIID, NS_INNTPPROTOCOL_IID_STR },
#endif
#ifdef NS_INNTPSERVICE_IID_STR
    { &kNntpServiceIID, NS_INNTPSERVICE_IID_STR },
#endif
#ifdef NS_INNTPURL_IID_STR
    { &kNntpUrlIID, NS_INNTPURL_IID_STR },
#endif
#ifdef NS_INOINCOMINGSERVER_IID_STR
    { &kNoIncomingServerIID, NS_INOINCOMINGSERVER_IID_STR },
#endif
#ifdef NS_INONESERVICE_IID_STR
    { &kNoneServiceIID, NS_INONESERVICE_IID_STR },
#endif
#ifdef NS_INSSCERTCACHE_IID_STR
    { &kNSSCertCacheIID, NS_INSSCERTCACHE_IID_STR },
#endif
#ifdef NS_IOBJECTINPUTSTREAM_IID_STR
    { &kObjectInputStreamIID, NS_IOBJECTINPUTSTREAM_IID_STR },
#endif
#ifdef NS_IOBJECTOUTPUTSTREAM_IID_STR
    { &kObjectOutputStreamIID, NS_IOBJECTOUTPUTSTREAM_IID_STR },
#endif
#ifdef NS_IOBSERVER_IID_STR
    { &kObserverIID, NS_IOBSERVER_IID_STR },
#endif
#ifdef NS_IOBSERVERSERVICE_IID_STR
    { &kObserverServiceIID, NS_IOBSERVERSERVICE_IID_STR },
#endif
#ifdef NS_IOCSPRESPONDER_IID_STR
    { &kOCSPResponderIID, NS_IOCSPRESPONDER_IID_STR },
#endif
#ifdef NS_IOUTPUTSTREAM_IID_STR
    { &kOutputStreamIID, NS_IOUTPUTSTREAM_IID_STR },
#endif
#ifdef NS_IPASSWORD_IID_STR
    { &kPasswordIID, NS_IPASSWORD_IID_STR },
#endif
#ifdef NS_IPASSWORDMANAGER_IID_STR
    { &kPasswordManagerIID, NS_IPASSWORDMANAGER_IID_STR },
#endif
#ifdef NS_IPASSWORDMANAGERINTERNAL_IID_STR
    { &kPasswordManagerInternalIID, NS_IPASSWORDMANAGERINTERNAL_IID_STR },
#endif
#ifdef NS_IPASSWORDSINK_IID_STR
    { &kPasswordSinkIID, NS_IPASSWORDSINK_IID_STR },
#endif
#ifdef NS_IPERMISSION_IID_STR
    { &kPermissionIID, NS_IPERMISSION_IID_STR },
#endif
#ifdef NS_IPERMISSIONMANAGER_IID_STR
    { &kPermissionManagerIID, NS_IPERMISSIONMANAGER_IID_STR },
#endif
#ifdef NS_IPERSISTENTPROPERTIES2_IID_STR
    { &kPersistentProperties2IID, NS_IPERSISTENTPROPERTIES2_IID_STR },
#endif
#ifdef NS_IPHONETIC_IID_STR
    { &kPhoneticIID, NS_IPHONETIC_IID_STR },
#endif
#ifdef NS_IPIPE_IID_STR
    { &kPipeIID, NS_IPIPE_IID_STR },
#endif
#ifdef NS_IPK11TOKEN_IID_STR
    { &kPK11TokenIID, NS_IPK11TOKEN_IID_STR },
#endif
#ifdef NS_IPK11TOKENDB_IID_STR
    { &kPK11TokenDBIID, NS_IPK11TOKENDB_IID_STR },
#endif
#ifdef NS_IPKCS11MODULE_IID_STR
    { &kPKCS11ModuleIID, NS_IPKCS11MODULE_IID_STR },
#endif
#ifdef NS_IPKCS11MODULEDB_IID_STR
    { &kPKCS11ModuleDBIID, NS_IPKCS11MODULEDB_IID_STR },
#endif
#ifdef NS_IPKCS11SLOT_IID_STR
    { &kPKCS11SlotIID, NS_IPKCS11SLOT_IID_STR },
#endif
#ifdef NS_IPKIPARAMBLOCK_IID_STR
    { &kPKIParamBlockIID, NS_IPKIPARAMBLOCK_IID_STR },
#endif
#ifdef NS_IPLAINTEXTEDITOR_IID_STR
    { &kPlaintextEditorIID, NS_IPLAINTEXTEDITOR_IID_STR },
#endif
#ifdef NS_IPLUGIN_IID_STR
    { &kPluginIID, NS_IPLUGIN_IID_STR },
#endif
#ifdef NS_IPLUGINHOST_IID_STR
    { &kPluginHostIID, NS_IPLUGINHOST_IID_STR },
#endif
#ifdef NS_IPLUGININPUTSTREAM_IID_STR
    { &kPluginInputStreamIID, NS_IPLUGININPUTSTREAM_IID_STR },
#endif
#ifdef NS_IPLUGININSTANCE_IID_STR
    { &kPluginInstanceIID, NS_IPLUGININSTANCE_IID_STR },
#endif
#ifdef NS_IPLUGININSTANCEOWNER_IID_STR
    { &kPluginInstanceOwnerIID, NS_IPLUGININSTANCEOWNER_IID_STR },
#endif
#ifdef NS_IPLUGININSTANCEPEER_IID_STR
    { &kPluginInstancePeerIID, NS_IPLUGININSTANCEPEER_IID_STR },
#endif
#ifdef NS_IPLUGININSTANCEPEER2_IID_STR
    { &kPluginInstancePeer2IID, NS_IPLUGININSTANCEPEER2_IID_STR },
#endif
#ifdef NS_IPLUGINMANAGER_IID_STR
    { &kPluginManagerIID, NS_IPLUGINMANAGER_IID_STR },
#endif
#ifdef NS_IPLUGINMANAGER2_IID_STR
    { &kPluginManager2IID, NS_IPLUGINMANAGER2_IID_STR },
#endif
#ifdef NS_IPLUGINSTREAMINFO_IID_STR
    { &kPluginStreamInfoIID, NS_IPLUGINSTREAMINFO_IID_STR },
#endif
#ifdef NS_IPLUGINSTREAMLISTENER_IID_STR
    { &kPluginStreamListenerIID, NS_IPLUGINSTREAMLISTENER_IID_STR },
#endif
#ifdef NS_IPLUGINTAGINFO_IID_STR
    { &kPluginTagInfoIID, NS_IPLUGINTAGINFO_IID_STR },
#endif
#ifdef NS_IPLUGINTAGINFO2_IID_STR
    { &kPluginTagInfo2IID, NS_IPLUGINTAGINFO2_IID_STR },
#endif
#ifdef NS_IPLUGINVIEWER_IID_STR
    { &kPluginViewerIID, NS_IPLUGINVIEWER_IID_STR },
#endif
#ifdef NS_IPOP3INCOMINGSERVER_IID_STR
    { &kPop3IncomingServerIID, NS_IPOP3INCOMINGSERVER_IID_STR },
#endif
#ifdef NS_IPOP3SERVICE_IID_STR
    { &kPop3ServiceIID, NS_IPOP3SERVICE_IID_STR },
#endif
#ifdef NS_IPOP3SINK_IID_STR
    { &kPop3SinkIID, NS_IPOP3SINK_IID_STR },
#endif
#ifdef NS_IPOP3URL_IID_STR
    { &kPop3URLIID, NS_IPOP3URL_IID_STR },
#endif
#ifdef NS_IPOPUPBOXOBJECT_IID_STR
    { &kPopupBoxObjectIID, NS_IPOPUPBOXOBJECT_IID_STR },
#endif
#ifdef NS_IPOPUPWINDOWMANAGER_IID_STR
    { &kPopupWindowManagerIID, NS_IPOPUPWINDOWMANAGER_IID_STR },
#endif
#ifdef NS_IPREF_IID_STR
    { &kPrefIID, NS_IPREF_IID_STR },
#endif
#ifdef NS_IPREFBRANCH_IID_STR
    { &kPrefBranchIID, NS_IPREFBRANCH_IID_STR },
#endif
#ifdef NS_IPREFBRANCHINTERNAL_IID_STR
    { &kPrefBranchInternalIID, NS_IPREFBRANCHINTERNAL_IID_STR },
#endif
#ifdef NS_IPREFETCHSERVICE_IID_STR
    { &kPrefetchServiceIID, NS_IPREFETCHSERVICE_IID_STR },
#endif
#ifdef NS_IPREFLOCALIZEDSTRING_IID_STR
    { &kPrefLocalizedStringIID, NS_IPREFLOCALIZEDSTRING_IID_STR },
#endif
#ifdef NS_IPREFMIGRATION_IID_STR
    { &kPrefMigrationIID, NS_IPREFMIGRATION_IID_STR },
#endif
#ifdef NS_IPREFMIGRATIONPROGRESS_IID_STR
    { &kPrefMigrationProgressIID, NS_IPREFMIGRATIONPROGRESS_IID_STR },
#endif
#ifdef NS_IPREFSERVICE_IID_STR
    { &kPrefServiceIID, NS_IPREFSERVICE_IID_STR },
#endif
#ifdef NS_IPRINCIPAL_IID_STR
    { &kPrincipalIID, NS_IPRINCIPAL_IID_STR },
#endif
#ifdef NS_IPRINTINGPROMPT_IID_STR
    { &kPrintingPromptIID, NS_IPRINTINGPROMPT_IID_STR },
#endif
#ifdef NS_IPRINTINGPROMPTSERVICE_IID_STR
    { &kPrintingPromptServiceIID, NS_IPRINTINGPROMPTSERVICE_IID_STR },
#endif
#ifdef NS_IPRINTOPTIONS_IID_STR
    { &kPrintOptionsIID, NS_IPRINTOPTIONS_IID_STR },
#endif
#ifdef NS_IPRINTPROGRESS_IID_STR
    { &kPrintProgressIID, NS_IPRINTPROGRESS_IID_STR },
#endif
#ifdef NS_IPRINTPROGRESSPARAMS_IID_STR
    { &kPrintProgressParamsIID, NS_IPRINTPROGRESSPARAMS_IID_STR },
#endif
#ifdef NS_IPRINTSESSION_IID_STR
    { &kPrintSessionIID, NS_IPRINTSESSION_IID_STR },
#endif
#ifdef NS_IPRINTSETTINGS_IID_STR
    { &kPrintSettingsIID, NS_IPRINTSETTINGS_IID_STR },
#endif
#ifdef NS_IPRINTSETTINGSSERVICE_IID_STR
    { &kPrintSettingsServiceIID, NS_IPRINTSETTINGSSERVICE_IID_STR },
#endif
#ifdef NS_IPRINTSTATUSFEEDBACK_IID_STR
    { &kPrintStatusFeedbackIID, NS_IPRINTSTATUSFEEDBACK_IID_STR },
#endif
#ifdef NS_IPROCESS_IID_STR
    { &kProcessIID, NS_IPROCESS_IID_STR },
#endif
#ifdef NS_IPROFILE_IID_STR
    { &kProfileIID, NS_IPROFILE_IID_STR },
#endif
#ifdef NS_IPROFILECHANGESTATUS_IID_STR
    { &kProfileChangeStatusIID, NS_IPROFILECHANGESTATUS_IID_STR },
#endif
#ifdef NS_IPROFILEINTERNAL_IID_STR
    { &kProfileInternalIID, NS_IPROFILEINTERNAL_IID_STR },
#endif
#ifdef NS_IPROFILESTARTUPLISTENER_IID_STR
    { &kProfileStartupListenerIID, NS_IPROFILESTARTUPLISTENER_IID_STR },
#endif
#ifdef NS_IPROGRAMMINGLANGUAGE_IID_STR
    { &kProgrammingLanguageIID, NS_IPROGRAMMINGLANGUAGE_IID_STR },
#endif
#ifdef NS_IPROGRESSDIALOG_IID_STR
    { &kProgressDialogIID, NS_IPROGRESSDIALOG_IID_STR },
#endif
#ifdef NS_IPROGRESSEVENTSINK_IID_STR
    { &kProgressEventSinkIID, NS_IPROGRESSEVENTSINK_IID_STR },
#endif
#ifdef NS_IPROMPT_IID_STR
    { &kPromptIID, NS_IPROMPT_IID_STR },
#endif
#ifdef NS_IPROMPTSERVICE_IID_STR
    { &kPromptServiceIID, NS_IPROMPTSERVICE_IID_STR },
#endif
#ifdef NS_IPROPERTIES_IID_STR
    { &kPropertiesIID, NS_IPROPERTIES_IID_STR },
#endif
#ifdef NS_IPROPERTYBAG_IID_STR
    { &kPropertyBagIID, NS_IPROPERTYBAG_IID_STR },
#endif
#ifdef NS_IPROTOCOLHANDLER_IID_STR
    { &kProtocolHandlerIID, NS_IPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IPROTOCOLPROXYSERVICE_IID_STR
    { &kProtocolProxyServiceIID, NS_IPROTOCOLPROXYSERVICE_IID_STR },
#endif
#ifdef NS_IPROXIEDPROTOCOLHANDLER_IID_STR
    { &kProxiedProtocolHandlerIID, NS_IPROXIEDPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IPROXY_IID_STR
    { &kProxyIID, NS_IPROXY_IID_STR },
#endif
#ifdef NS_IPROXYAUTOCONFIG_IID_STR
    { &kProxyAutoConfigIID, NS_IPROXYAUTOCONFIG_IID_STR },
#endif
#ifdef NS_IPROXYCREATEINSTANCE_IID_STR
    { &kProxyCreateInstanceIID, NS_IPROXYCREATEINSTANCE_IID_STR },
#endif
#ifdef NS_IPROXYINFO_IID_STR
    { &kProxyInfoIID, NS_IPROXYINFO_IID_STR },
#endif
#ifdef NS_IPROXYOBJECTMANAGER_IID_STR
    { &kProxyObjectManagerIID, NS_IPROXYOBJECTMANAGER_IID_STR },
#endif
#ifdef NS_IRDFCOMPOSITEDATASOURCE_IID_STR
    { &kRDFCompositeDataSourceIID, NS_IRDFCOMPOSITEDATASOURCE_IID_STR },
#endif
#ifdef NS_IRDFCONTAINER_IID_STR
    { &kRDFContainerIID, NS_IRDFCONTAINER_IID_STR },
#endif
#ifdef NS_IRDFCONTAINERUTILS_IID_STR
    { &kRDFContainerUtilsIID, NS_IRDFCONTAINERUTILS_IID_STR },
#endif
#ifdef NS_IRDFDATASOURCE_IID_STR
    { &kRDFDataSourceIID, NS_IRDFDATASOURCE_IID_STR },
#endif
#ifdef NS_IRDFDELEGATEFACTORY_IID_STR
    { &kRDFDelegateFactoryIID, NS_IRDFDELEGATEFACTORY_IID_STR },
#endif
#ifdef NS_IRDFINMEMORYDATASOURCE_IID_STR
    { &kRDFInMemoryDataSourceIID, NS_IRDFINMEMORYDATASOURCE_IID_STR },
#endif
#ifdef NS_IRDFLITERAL_IID_STR
    { &kRDFLiteralIID, NS_IRDFLITERAL_IID_STR },
#endif
#ifdef NS_IRDFNODE_IID_STR
    { &kRDFNodeIID, NS_IRDFNODE_IID_STR },
#endif
#ifdef NS_IRDFOBSERVER_IID_STR
    { &kRDFObserverIID, NS_IRDFOBSERVER_IID_STR },
#endif
#ifdef NS_IRDFPURGEABLEDATASOURCE_IID_STR
    { &kRDFPurgeableDataSourceIID, NS_IRDFPURGEABLEDATASOURCE_IID_STR },
#endif
#ifdef NS_IRDFREMOTEDATASOURCE_IID_STR
    { &kRDFRemoteDataSourceIID, NS_IRDFREMOTEDATASOURCE_IID_STR },
#endif
#ifdef NS_IRDFRESOURCE_IID_STR
    { &kRDFResourceIID, NS_IRDFRESOURCE_IID_STR },
#endif
#ifdef NS_IRDFSERVICE_IID_STR
    { &kRDFServiceIID, NS_IRDFSERVICE_IID_STR },
#endif
#ifdef NS_IRDFXMLPARSER_IID_STR
    { &kRDFXMLParserIID, NS_IRDFXMLPARSER_IID_STR },
#endif
#ifdef NS_IRDFXMLSERIALIZER_IID_STR
    { &kRDFXMLSerializerIID, NS_IRDFXMLSERIALIZER_IID_STR },
#endif
#ifdef NS_IRDFXMLSINK_IID_STR
    { &kRDFXMLSinkIID, NS_IRDFXMLSINK_IID_STR },
#endif
#ifdef NS_IRDFXMLSOURCE_IID_STR
    { &kRDFXMLSourceIID, NS_IRDFXMLSOURCE_IID_STR },
#endif
#ifdef NS_IREADCONFIG_IID_STR
    { &kReadConfigIID, NS_IREADCONFIG_IID_STR },
#endif
#ifdef NS_IRECYCLINGALLOCATOR_IID_STR
    { &kRecyclingAllocatorIID, NS_IRECYCLINGALLOCATOR_IID_STR },
#endif
#ifdef NS_IREFRESHURI_IID_STR
    { &kRefreshURIIID, NS_IREFRESHURI_IID_STR },
#endif
#ifdef NS_IREGISTRY_IID_STR
    { &kRegistryIID, NS_IREGISTRY_IID_STR },
#endif
#ifdef NS_IRELATIVEFILEPREF_IID_STR
    { &kRelativeFilePrefIID, NS_IRELATIVEFILEPREF_IID_STR },
#endif
#ifdef NS_IREQUEST_IID_STR
    { &kRequestIID, NS_IREQUEST_IID_STR },
#endif
#ifdef NS_IREQUESTOBSERVER_IID_STR
    { &kRequestObserverIID, NS_IREQUESTOBSERVER_IID_STR },
#endif
#ifdef NS_IREQUESTOBSERVERPROXY_IID_STR
    { &kRequestObserverProxyIID, NS_IREQUESTOBSERVERPROXY_IID_STR },
#endif
#ifdef NS_IRESPROTOCOLHANDLER_IID_STR
    { &kResProtocolHandlerIID, NS_IRESPROTOCOLHANDLER_IID_STR },
#endif
#ifdef NS_IRESUMABLECHANNEL_IID_STR
    { &kResumableChannelIID, NS_IRESUMABLECHANNEL_IID_STR },
#endif
#ifdef NS_IRESUMABLEENTITYID_IID_STR
    { &kResumableEntityIDIID, NS_IRESUMABLEENTITYID_IID_STR },
#endif
#ifdef NS_IROLLUPLISTENER_IID_STR
    { &kRollupListenerIID, NS_IROLLUPLISTENER_IID_STR },
#endif
#ifdef NS_IRUNNABLE_IID_STR
    { &kRunnableIID, NS_IRUNNABLE_IID_STR },
#endif
#ifdef NS_ISAMPLE_IID_STR
    { &kSampleIID, NS_ISAMPLE_IID_STR },
#endif
#ifdef NS_ISAVEASCHARSET_IID_STR
    { &kSaveAsCharsetIID, NS_ISAVEASCHARSET_IID_STR },
#endif
#ifdef NS_ISCHEMA_IID_STR
    { &kSchemaIID, NS_ISCHEMA_IID_STR },
#endif
#ifdef NS_ISCHEMALOADER_IID_STR
    { &kSchemaLoaderIID, NS_ISCHEMALOADER_IID_STR },
#endif
#ifdef NS_ISCREEN_IID_STR
    { &kScreenIID, NS_ISCREEN_IID_STR },
#endif
#ifdef NS_ISCREENMANAGER_IID_STR
    { &kScreenManagerIID, NS_ISCREENMANAGER_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEDATEFORMAT_IID_STR
    { &kScriptableDateFormatIID, NS_ISCRIPTABLEDATEFORMAT_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEINPUTSTREAM_IID_STR
    { &kScriptableInputStreamIID, NS_ISCRIPTABLEINPUTSTREAM_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEINTERFACES_IID_STR
    { &kScriptableInterfacesIID, NS_ISCRIPTABLEINTERFACES_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEPLUGIN_IID_STR
    { &kScriptablePluginIID, NS_ISCRIPTABLEPLUGIN_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEREGION_IID_STR
    { &kScriptableRegionIID, NS_ISCRIPTABLEREGION_IID_STR },
#endif
#ifdef NS_ISCRIPTABLEUCONV_IID_STR
    { &kScriptableUConvIID, NS_ISCRIPTABLEUCONV_IID_STR },
#endif
#ifdef NS_ISCRIPTCONTEXTOWNER_IID_STR
    { &kScriptContextOwnerIID, NS_ISCRIPTCONTEXTOWNER_IID_STR },
#endif
#ifdef NS_ISCRIPTERROR_IID_STR
    { &kScriptErrorIID, NS_ISCRIPTERROR_IID_STR },
#endif
#ifdef NS_ISCRIPTEVENTHANDLER_IID_STR
    { &kScriptEventHandlerIID, NS_ISCRIPTEVENTHANDLER_IID_STR },
#endif
#ifdef NS_ISCRIPTEVENTMANAGER_IID_STR
    { &kScriptEventManagerIID, NS_ISCRIPTEVENTMANAGER_IID_STR },
#endif
#ifdef NS_ISCRIPTGLOBALOBJECTOWNER_IID_STR
    { &kScriptGlobalObjectOwnerIID, NS_ISCRIPTGLOBALOBJECTOWNER_IID_STR },
#endif
#ifdef NS_ISCRIPTLOADER_IID_STR
    { &kScriptLoaderIID, NS_ISCRIPTLOADER_IID_STR },
#endif
#ifdef NS_ISCRIPTLOADEROBSERVER_IID_STR
    { &kScriptLoaderObserverIID, NS_ISCRIPTLOADEROBSERVER_IID_STR },
#endif
#ifdef NS_ISCRIPTSECURITYMANAGER_IID_STR
    { &kScriptSecurityManagerIID, NS_ISCRIPTSECURITYMANAGER_IID_STR },
#endif
#ifdef NS_ISCROLLABLE_IID_STR
    { &kScrollableIID, NS_ISCROLLABLE_IID_STR },
#endif
#ifdef NS_ISCROLLBOXOBJECT_IID_STR
    { &kScrollBoxObjectIID, NS_ISCROLLBOXOBJECT_IID_STR },
#endif
#ifdef NS_ISEARCHCONTEXT_IID_STR
    { &kSearchContextIID, NS_ISEARCHCONTEXT_IID_STR },
#endif
#ifdef NS_ISEARCHSERVICE_IID_STR
    { &kSearchServiceIID, NS_ISEARCHSERVICE_IID_STR },
#endif
#ifdef NS_ISECRETDECODERRING_IID_STR
    { &kSecretDecoderRingIID, NS_ISECRETDECODERRING_IID_STR },
#endif
#ifdef NS_ISECUREBROWSERUI_IID_STR
    { &kSecureBrowserUIIID, NS_ISECUREBROWSERUI_IID_STR },
#endif
#ifdef NS_ISECURITYCHECKEDCOMPONENT_IID_STR
    { &kSecurityCheckedComponentIID, NS_ISECURITYCHECKEDCOMPONENT_IID_STR },
#endif
#ifdef NS_ISECURITYEVENTSINK_IID_STR
    { &kSecurityEventSinkIID, NS_ISECURITYEVENTSINK_IID_STR },
#endif
#ifdef NS_ISECURITYPREF_IID_STR
    { &kSecurityPrefIID, NS_ISECURITYPREF_IID_STR },
#endif
#ifdef NS_ISECURITYWARNINGDIALOGS_IID_STR
    { &kSecurityWarningDialogsIID, NS_ISECURITYWARNINGDIALOGS_IID_STR },
#endif
#ifdef NS_ISEEKABLESTREAM_IID_STR
    { &kSeekableStreamIID, NS_ISEEKABLESTREAM_IID_STR },
#endif
#ifdef NS_ISELECTELEMENT_IID_STR
    { &kSelectElementIID, NS_ISELECTELEMENT_IID_STR },
#endif
#ifdef NS_ISELECTION_IID_STR
    { &kSelectionIID, NS_ISELECTION_IID_STR },
#endif
#ifdef NS_ISELECTIONCONTROLLER_IID_STR
    { &kSelectionControllerIID, NS_ISELECTIONCONTROLLER_IID_STR },
#endif
#ifdef NS_ISELECTIONDISPLAY_IID_STR
    { &kSelectionDisplayIID, NS_ISELECTIONDISPLAY_IID_STR },
#endif
#ifdef NS_ISELECTIONIMAGESERVICE_IID_STR
    { &kSelectionImageServiceIID, NS_ISELECTIONIMAGESERVICE_IID_STR },
#endif
#ifdef NS_ISELECTIONLISTENER_IID_STR
    { &kSelectionListenerIID, NS_ISELECTIONLISTENER_IID_STR },
#endif
#ifdef NS_ISELECTIONPRIVATE_IID_STR
    { &kSelectionPrivateIID, NS_ISELECTIONPRIVATE_IID_STR },
#endif
#ifdef NS_ISEMANTICUNITSCANNER_IID_STR
    { &kSemanticUnitScannerIID, NS_ISEMANTICUNITSCANNER_IID_STR },
#endif
#ifdef NS_ISERIALIZABLE_IID_STR
    { &kSerializableIID, NS_ISERIALIZABLE_IID_STR },
#endif
#ifdef NS_ISERVICEMANAGER_IID_STR
    { &kServiceManagerIID, NS_ISERVICEMANAGER_IID_STR },
#endif
#ifdef NS_ISHCONTAINER_IID_STR
    { &kSHContainerIID, NS_ISHCONTAINER_IID_STR },
#endif
#ifdef NS_ISHENTRY_IID_STR
    { &kSHEntryIID, NS_ISHENTRY_IID_STR },
#endif
#ifdef NS_ISHISTORY_IID_STR
    { &kSHistoryIID, NS_ISHISTORY_IID_STR },
#endif
#ifdef NS_ISHISTORYINTERNAL_IID_STR
    { &kSHistoryInternalIID, NS_ISHISTORYINTERNAL_IID_STR },
#endif
#ifdef NS_ISHISTORYLISTENER_IID_STR
    { &kSHistoryListenerIID, NS_ISHISTORYLISTENER_IID_STR },
#endif
#ifdef NS_ISHTRANSACTION_IID_STR
    { &kSHTransactionIID, NS_ISHTRANSACTION_IID_STR },
#endif
#ifdef NS_ISIDEBAR_IID_STR
    { &kSidebarIID, NS_ISIDEBAR_IID_STR },
#endif
#ifdef NS_ISIGNATUREVERIFIER_IID_STR
    { &kSignatureVerifierIID, NS_ISIGNATUREVERIFIER_IID_STR },
#endif
#ifdef NS_ISIGNONVIEWER_IID_STR
    { &kSignonViewerIID, NS_ISIGNONVIEWER_IID_STR },
#endif
#ifdef NS_ISIMPLEENUMERATOR_IID_STR
    { &kSimpleEnumeratorIID, NS_ISIMPLEENUMERATOR_IID_STR },
#endif
#ifdef NS_ISIMPLESTREAMLISTENER_IID_STR
    { &kSimpleStreamListenerIID, NS_ISIMPLESTREAMLISTENER_IID_STR },
#endif
#ifdef NS_ISMIMECERT_IID_STR
    { &kSMimeCertIID, NS_ISMIMECERT_IID_STR },
#endif
#ifdef NS_ISMIMEJSHELPER_IID_STR
    { &kSMimeJSHelperIID, NS_ISMIMEJSHELPER_IID_STR },
#endif
#ifdef NS_ISMTPSERVER_IID_STR
    { &kSmtpServerIID, NS_ISMTPSERVER_IID_STR },
#endif
#ifdef NS_ISMTPSERVICE_IID_STR
    { &kSmtpServiceIID, NS_ISMTPSERVICE_IID_STR },
#endif
#ifdef NS_ISMTPURL_IID_STR
    { &kSmtpUrlIID, NS_ISMTPURL_IID_STR },
#endif
#ifdef NS_ISOAPATTACHMENTS_IID_STR
    { &kSOAPAttachmentsIID, NS_ISOAPATTACHMENTS_IID_STR },
#endif
#ifdef NS_ISOAPBLOCK_IID_STR
    { &kSOAPBlockIID, NS_ISOAPBLOCK_IID_STR },
#endif
#ifdef NS_ISOAPCALL_IID_STR
    { &kSOAPCallIID, NS_ISOAPCALL_IID_STR },
#endif
#ifdef NS_ISOAPCALLCOMPLETION_IID_STR
    { &kSOAPCallCompletionIID, NS_ISOAPCALLCOMPLETION_IID_STR },
#endif
#ifdef NS_ISOAPDECODER_IID_STR
    { &kSOAPDecoderIID, NS_ISOAPDECODER_IID_STR },
#endif
#ifdef NS_ISOAPENCODER_IID_STR
    { &kSOAPEncoderIID, NS_ISOAPENCODER_IID_STR },
#endif
#ifdef NS_ISOAPENCODING_IID_STR
    { &kSOAPEncodingIID, NS_ISOAPENCODING_IID_STR },
#endif
#ifdef NS_ISOAPFAULT_IID_STR
    { &kSOAPFaultIID, NS_ISOAPFAULT_IID_STR },
#endif
#ifdef NS_ISOAPHEADERBLOCK_IID_STR
    { &kSOAPHeaderBlockIID, NS_ISOAPHEADERBLOCK_IID_STR },
#endif
#ifdef NS_ISOAPMESSAGE_IID_STR
    { &kSOAPMessageIID, NS_ISOAPMESSAGE_IID_STR },
#endif
#ifdef NS_ISOAPPARAMETER_IID_STR
    { &kSOAPParameterIID, NS_ISOAPPARAMETER_IID_STR },
#endif
#ifdef NS_ISOAPPROPERTYBAGMUTATOR_IID_STR
    { &kSOAPPropertyBagMutatorIID, NS_ISOAPPROPERTYBAGMUTATOR_IID_STR },
#endif
#ifdef NS_ISOAPRESPONSE_IID_STR
    { &kSOAPResponseIID, NS_ISOAPRESPONSE_IID_STR },
#endif
#ifdef NS_ISOAPRESPONSELISTENER_IID_STR
    { &kSOAPResponseListenerIID, NS_ISOAPRESPONSELISTENER_IID_STR },
#endif
#ifdef NS_ISOAPSERVICE_IID_STR
    { &kSOAPServiceIID, NS_ISOAPSERVICE_IID_STR },
#endif
#ifdef NS_ISOAPSERVICEREGISTRY_IID_STR
    { &kSOAPServiceRegistryIID, NS_ISOAPSERVICEREGISTRY_IID_STR },
#endif
#ifdef NS_ISOAPTRANSPORT_IID_STR
    { &kSOAPTransportIID, NS_ISOAPTRANSPORT_IID_STR },
#endif
#ifdef NS_ISOAPTRANSPORTLISTENER_IID_STR
    { &kSOAPTransportListenerIID, NS_ISOAPTRANSPORTLISTENER_IID_STR },
#endif
#ifdef NS_ISOCKETPROVIDER_IID_STR
    { &kSocketProviderIID, NS_ISOCKETPROVIDER_IID_STR },
#endif
#ifdef NS_ISOCKETPROVIDERSERVICE_IID_STR
    { &kSocketProviderServiceIID, NS_ISOCKETPROVIDERSERVICE_IID_STR },
#endif
#ifdef NS_ISOCKETTRANSPORT_IID_STR
    { &kSocketTransportIID, NS_ISOCKETTRANSPORT_IID_STR },
#endif
#ifdef NS_ISOCKETTRANSPORTSERVICE_IID_STR
    { &kSocketTransportServiceIID, NS_ISOCKETTRANSPORTSERVICE_IID_STR },
#endif
#ifdef NS_ISOCKS4SOCKETINFO_IID_STR
    { &kSOCKS4SocketInfoIID, NS_ISOCKS4SOCKETINFO_IID_STR },
#endif
#ifdef NS_ISOCKS4SOCKETPROVIDER_IID_STR
    { &kSOCKS4SocketProviderIID, NS_ISOCKS4SOCKETPROVIDER_IID_STR },
#endif
#ifdef NS_ISOCKSSOCKETINFO_IID_STR
    { &kSOCKSSocketInfoIID, NS_ISOCKSSOCKETINFO_IID_STR },
#endif
#ifdef NS_ISOCKSSOCKETPROVIDER_IID_STR
    { &kSOCKSSocketProviderIID, NS_ISOCKSSOCKETPROVIDER_IID_STR },
#endif
#ifdef NS_ISOUND_IID_STR
    { &kSoundIID, NS_ISOUND_IID_STR },
#endif
#ifdef NS_ISPAMSETTINGS_IID_STR
    { &kSpamSettingsIID, NS_ISPAMSETTINGS_IID_STR },
#endif
#ifdef NS_ISSLSOCKETCONTROL_IID_STR
    { &kSSLSocketControlIID, NS_ISSLSOCKETCONTROL_IID_STR },
#endif
#ifdef NS_ISSLSOCKETPROVIDER_IID_STR
    { &kSSLSocketProviderIID, NS_ISSLSOCKETPROVIDER_IID_STR },
#endif
#ifdef NS_ISSLSTATUS_IID_STR
    { &kSSLStatusIID, NS_ISSLSTATUS_IID_STR },
#endif
#ifdef NS_ISSLSTATUSPROVIDER_IID_STR
    { &kSSLStatusProviderIID, NS_ISSLSTATUSPROVIDER_IID_STR },
#endif
#ifdef NS_ISTANDARDURL_IID_STR
    { &kStandardURLIID, NS_ISTANDARDURL_IID_STR },
#endif
#ifdef NS_ISTORAGESTREAM_IID_STR
    { &kStorageStreamIID, NS_ISTORAGESTREAM_IID_STR },
#endif
#ifdef NS_ISTREAMBUFFERACCESS_IID_STR
    { &kStreamBufferAccessIID, NS_ISTREAMBUFFERACCESS_IID_STR },
#endif
#ifdef NS_ISTREAMCONVERTER_IID_STR
    { &kStreamConverterIID, NS_ISTREAMCONVERTER_IID_STR },
#endif
#ifdef NS_ISTREAMCONVERTERSERVICE_IID_STR
    { &kStreamConverterServiceIID, NS_ISTREAMCONVERTERSERVICE_IID_STR },
#endif
#ifdef NS_ISTREAMLISTENER_IID_STR
    { &kStreamListenerIID, NS_ISTREAMLISTENER_IID_STR },
#endif
#ifdef NS_ISTREAMLISTENERPROXY_IID_STR
    { &kStreamListenerProxyIID, NS_ISTREAMLISTENERPROXY_IID_STR },
#endif
#ifdef NS_ISTREAMLISTENERTEE_IID_STR
    { &kStreamListenerTeeIID, NS_ISTREAMLISTENERTEE_IID_STR },
#endif
#ifdef NS_ISTREAMLOADER_IID_STR
    { &kStreamLoaderIID, NS_ISTREAMLOADER_IID_STR },
#endif
#ifdef NS_ISTREAMTRANSPORTSERVICE_IID_STR
    { &kStreamTransportServiceIID, NS_ISTREAMTRANSPORTSERVICE_IID_STR },
#endif
#ifdef NS_ISTRINGBUNDLE_IID_STR
    { &kStringBundleIID, NS_ISTRINGBUNDLE_IID_STR },
#endif
#ifdef NS_ISTRINGBUNDLEOVERRIDE_IID_STR
    { &kStringBundleOverrideIID, NS_ISTRINGBUNDLEOVERRIDE_IID_STR },
#endif
#ifdef NS_ISTRINGSERVICE_IID_STR
    { &kStringServiceIID, NS_ISTRINGSERVICE_IID_STR },
#endif
#ifdef NS_ISTRINGSTREAM_IID_STR
    { &kStringStreamIID, NS_ISTRINGSTREAM_IID_STR },
#endif
#ifdef NS_ISUBSCRIBABLESERVER_IID_STR
    { &kSubscribableServerIID, NS_ISUBSCRIBABLESERVER_IID_STR },
#endif
#ifdef NS_ISUPPORTS_IID_STR
    { &kSupportsIID, NS_ISUPPORTS_IID_STR },
#endif
#ifdef NS_ISUPPORTSARRAY_IID_STR
    { &kSupportsArrayIID, NS_ISUPPORTSARRAY_IID_STR },
#endif
#ifdef NS_ISUPPORTSITERATORS_IID_STR
    { &kSupportsIteratorsIID, NS_ISUPPORTSITERATORS_IID_STR },
#endif
#ifdef NS_ISUPPORTSPRIMITIVES_IID_STR
    { &kSupportsPrimitivesIID, NS_ISUPPORTSPRIMITIVES_IID_STR },
#endif
#ifdef NS_ISYNCLOADDOMSERVICE_IID_STR
    { &kSyncLoadDOMServiceIID, NS_ISYNCLOADDOMSERVICE_IID_STR },
#endif
#ifdef NS_ITABLEEDITOR_IID_STR
    { &kTableEditorIID, NS_ITABLEEDITOR_IID_STR },
#endif
#ifdef NS_ITESTPROXY_IID_STR
    { &kTestProxyIID, NS_ITESTPROXY_IID_STR },
#endif
#ifdef NS_ITEXTAREAELEMENT_IID_STR
    { &kTextAreaElementIID, NS_ITEXTAREAELEMENT_IID_STR },
#endif
#ifdef NS_ITEXTSCROLL_IID_STR
    { &kTextScrollIID, NS_ITEXTSCROLL_IID_STR },
#endif
#ifdef NS_ITEXTSERVICESFILTER_IID_STR
    { &kTextServicesFilterIID, NS_ITEXTSERVICESFILTER_IID_STR },
#endif
#ifdef NS_ITEXTTOSUBURI_IID_STR
    { &kTextToSubURIIID, NS_ITEXTTOSUBURI_IID_STR },
#endif
#ifdef NS_ITHREAD_IID_STR
    { &kThreadIID, NS_ITHREAD_IID_STR },
#endif
#ifdef NS_ITHREADPOOL_IID_STR
    { &kThreadPoolIID, NS_ITHREADPOOL_IID_STR },
#endif
#ifdef NS_ITIMEBOMB_IID_STR
    { &kTimeBombIID, NS_ITIMEBOMB_IID_STR },
#endif
#ifdef NS_ITIMELINESERVICE_IID_STR
    { &kTimelineServiceIID, NS_ITIMELINESERVICE_IID_STR },
#endif
#ifdef NS_ITIMER_IID_STR
    { &kTimerIID, NS_ITIMER_IID_STR },
#endif
#ifdef NS_ITIMERECORDER_IID_STR
    { &kTimeRecorderIID, NS_ITIMERECORDER_IID_STR },
#endif
#ifdef NS_ITIMERINTERNAL_IID_STR
    { &kTimerInternalIID, NS_ITIMERINTERNAL_IID_STR },
#endif
#ifdef NS_ITIMERMANAGER_IID_STR
    { &kTimerManagerIID, NS_ITIMERMANAGER_IID_STR },
#endif
#ifdef NS_ITIMINGSERVICE_IID_STR
    { &kTimingServiceIID, NS_ITIMINGSERVICE_IID_STR },
#endif
#ifdef NS_ITOKENDIALOGS_IID_STR
    { &kTokenDialogsIID, NS_ITOKENDIALOGS_IID_STR },
#endif
#ifdef NS_ITOKENPASSWORDDIALOGS_IID_STR
    { &kTokenPasswordDialogsIID, NS_ITOKENPASSWORDDIALOGS_IID_STR },
#endif
#ifdef NS_ITOOLKIT_IID_STR
    { &kToolkitIID, NS_ITOOLKIT_IID_STR },
#endif
#ifdef NS_ITOOLTIPLISTENER_IID_STR
    { &kTooltipListenerIID, NS_ITOOLTIPLISTENER_IID_STR },
#endif
#ifdef NS_ITOOLTIPTEXTPROVIDER_IID_STR
    { &kTooltipTextProviderIID, NS_ITOOLTIPTEXTPROVIDER_IID_STR },
#endif
#ifdef NS_ITRANSACTION_IID_STR
    { &kTransactionIID, NS_ITRANSACTION_IID_STR },
#endif
#ifdef NS_ITRANSACTIONLIST_IID_STR
    { &kTransactionListIID, NS_ITRANSACTIONLIST_IID_STR },
#endif
#ifdef NS_ITRANSACTIONLISTENER_IID_STR
    { &kTransactionListenerIID, NS_ITRANSACTIONLISTENER_IID_STR },
#endif
#ifdef NS_ITRANSACTIONMANAGER_IID_STR
    { &kTransactionManagerIID, NS_ITRANSACTIONMANAGER_IID_STR },
#endif
#ifdef NS_ITRANSFERABLE_IID_STR
    { &kTransferableIID, NS_ITRANSFERABLE_IID_STR },
#endif
#ifdef NS_ITRANSPORT_IID_STR
    { &kTransportIID, NS_ITRANSPORT_IID_STR },
#endif
#ifdef NS_ITRANSPORTSECURITYINFO_IID_STR
    { &kTransportSecurityInfoIID, NS_ITRANSPORTSECURITYINFO_IID_STR },
#endif
#ifdef NS_ITREEBOXOBJECT_IID_STR
    { &kTreeBoxObjectIID, NS_ITREEBOXOBJECT_IID_STR },
#endif
#ifdef NS_ITREECONTENTVIEW_IID_STR
    { &kTreeContentViewIID, NS_ITREECONTENTVIEW_IID_STR },
#endif
#ifdef NS_ITREESELECTION_IID_STR
    { &kTreeSelectionIID, NS_ITREESELECTION_IID_STR },
#endif
#ifdef NS_ITREEVIEW_IID_STR
    { &kTreeViewIID, NS_ITREEVIEW_IID_STR },
#endif
#ifdef NS_ITXTTOHTMLCONV_IID_STR
    { &kTXTToHTMLConvIID, NS_ITXTTOHTMLCONV_IID_STR },
#endif
#ifdef NS_ITYPEAHEADFIND_IID_STR
    { &kTypeAheadFindIID, NS_ITYPEAHEADFIND_IID_STR },
#endif
#ifdef NS_IUNICHARSTREAMLOADER_IID_STR
    { &kUnicharStreamLoaderIID, NS_IUNICHARSTREAMLOADER_IID_STR },
#endif
#ifdef NS_IUNICODENORMALIZER_IID_STR
    { &kUnicodeNormalizerIID, NS_IUNICODENORMALIZER_IID_STR },
#endif
#ifdef NS_IUPLOADCHANNEL_IID_STR
    { &kUploadChannelIID, NS_IUPLOADCHANNEL_IID_STR },
#endif
#ifdef NS_IURI_IID_STR
    { &kURIIID, NS_IURI_IID_STR },
#endif
#ifdef NS_IURICHECKER_IID_STR
    { &kURICheckerIID, NS_IURICHECKER_IID_STR },
#endif
#ifdef NS_IURICONTENTLISTENER_IID_STR
    { &kURIContentListenerIID, NS_IURICONTENTLISTENER_IID_STR },
#endif
#ifdef NS_IURIFIXUP_IID_STR
    { &kURIFixupIID, NS_IURIFIXUP_IID_STR },
#endif
#ifdef NS_IURILOADER_IID_STR
    { &kURILoaderIID, NS_IURILOADER_IID_STR },
#endif
#ifdef NS_IURIREFOBJECT_IID_STR
    { &kURIRefObjectIID, NS_IURIREFOBJECT_IID_STR },
#endif
#ifdef NS_IURL_IID_STR
    { &kURLIID, NS_IURL_IID_STR },
#endif
#ifdef NS_IURLBARHISTORY_IID_STR
    { &kUrlbarHistoryIID, NS_IURLBARHISTORY_IID_STR },
#endif
#ifdef NS_IURLFETCHER_IID_STR
    { &kURLFetcherIID, NS_IURLFETCHER_IID_STR },
#endif
#ifdef NS_IURLLISTENER_IID_STR
    { &kUrlListenerIID, NS_IURLLISTENER_IID_STR },
#endif
#ifdef NS_IURLLISTENERMANAGER_IID_STR
    { &kUrlListenerManagerIID, NS_IURLLISTENERMANAGER_IID_STR },
#endif
#ifdef NS_IURLPARSER_IID_STR
    { &kURLParserIID, NS_IURLPARSER_IID_STR },
#endif
#ifdef NS_IUSERCERTPICKER_IID_STR
    { &kUserCertPickerIID, NS_IUSERCERTPICKER_IID_STR },
#endif
#ifdef NS_IUSERINFO_IID_STR
    { &kUserInfoIID, NS_IUSERINFO_IID_STR },
#endif
#ifdef NS_IVARIANT_IID_STR
    { &kVariantIID, NS_IVARIANT_IID_STR },
#endif
#ifdef NS_IVIEWSOURCECHANNEL_IID_STR
    { &kViewSourceChannelIID, NS_IVIEWSOURCECHANNEL_IID_STR },
#endif
#ifdef NS_IWALLETEDITOR_IID_STR
    { &kWalletEditorIID, NS_IWALLETEDITOR_IID_STR },
#endif
#ifdef NS_IWALLETPREVIEW_IID_STR
    { &kWalletPreviewIID, NS_IWALLETPREVIEW_IID_STR },
#endif
#ifdef NS_IWALLETSERVICE_IID_STR
    { &kWalletServiceIID, NS_IWALLETSERVICE_IID_STR },
#endif
#ifdef NS_IWEAKREFERENCE_IID_STR
    { &kWeakReferenceIID, NS_IWEAKREFERENCE_IID_STR },
#endif
#ifdef NS_IWEBBROWSER_IID_STR
    { &kWebBrowserIID, NS_IWEBBROWSER_IID_STR },
#endif
#ifdef NS_IWEBBROWSERCHROME_IID_STR
    { &kWebBrowserChromeIID, NS_IWEBBROWSERCHROME_IID_STR },
#endif
#ifdef NS_IWEBBROWSERCHROMEFOCUS_IID_STR
    { &kWebBrowserChromeFocusIID, NS_IWEBBROWSERCHROMEFOCUS_IID_STR },
#endif
#ifdef NS_IWEBBROWSERFIND_IID_STR
    { &kWebBrowserFindIID, NS_IWEBBROWSERFIND_IID_STR },
#endif
#ifdef NS_IWEBBROWSERFOCUS_IID_STR
    { &kWebBrowserFocusIID, NS_IWEBBROWSERFOCUS_IID_STR },
#endif
#ifdef NS_IWEBBROWSERPERSIST_IID_STR
    { &kWebBrowserPersistIID, NS_IWEBBROWSERPERSIST_IID_STR },
#endif
#ifdef NS_IWEBBROWSERPRINT_IID_STR
    { &kWebBrowserPrintIID, NS_IWEBBROWSERPRINT_IID_STR },
#endif
#ifdef NS_IWEBBROWSERSETUP_IID_STR
    { &kWebBrowserSetupIID, NS_IWEBBROWSERSETUP_IID_STR },
#endif
#ifdef NS_IWEBNAVIGATION_IID_STR
    { &kWebNavigationIID, NS_IWEBNAVIGATION_IID_STR },
#endif
#ifdef NS_IWEBPAGEDESCRIPTOR_IID_STR
    { &kWebPageDescriptorIID, NS_IWEBPAGEDESCRIPTOR_IID_STR },
#endif
#ifdef NS_IWEBPROGRESS_IID_STR
    { &kWebProgressIID, NS_IWEBPROGRESS_IID_STR },
#endif
#ifdef NS_IWEBPROGRESSLISTENER_IID_STR
    { &kWebProgressListenerIID, NS_IWEBPROGRESSLISTENER_IID_STR },
#endif
#ifdef NS_IWINDOWCREATOR_IID_STR
    { &kWindowCreatorIID, NS_IWINDOWCREATOR_IID_STR },
#endif
#ifdef NS_IWINDOWCREATOR2_IID_STR
    { &kWindowCreator2IID, NS_IWINDOWCREATOR2_IID_STR },
#endif
#ifdef NS_IWINDOWDATASOURCE_IID_STR
    { &kWindowDataSourceIID, NS_IWINDOWDATASOURCE_IID_STR },
#endif
#ifdef NS_IWINDOWLESSPLUGINSTPEER_IID_STR
    { &kWindowlessPlugInstPeerIID, NS_IWINDOWLESSPLUGINSTPEER_IID_STR },
#endif
#ifdef NS_IWINDOWMEDIATOR_IID_STR
    { &kWindowMediatorIID, NS_IWINDOWMEDIATOR_IID_STR },
#endif
#ifdef NS_IWINDOWMEDIATORLISTENER_IID_STR
    { &kWindowMediatorListenerIID, NS_IWINDOWMEDIATORLISTENER_IID_STR },
#endif
#ifdef NS_IWINDOWWATCHER_IID_STR
    { &kWindowWatcherIID, NS_IWINDOWWATCHER_IID_STR },
#endif
#ifdef NS_IWYCIWYGCHANNEL_IID_STR
    { &kWyciwygChannelIID, NS_IWYCIWYGCHANNEL_IID_STR },
#endif
#ifdef NS_IX509CERT_IID_STR
    { &kX509CertIID, NS_IX509CERT_IID_STR },
#endif
#ifdef NS_IX509CERTDB_IID_STR
    { &kX509CertDBIID, NS_IX509CERTDB_IID_STR },
#endif
#ifdef NS_IX509CERTVALIDITY_IID_STR
    { &kX509CertValidityIID, NS_IX509CERTVALIDITY_IID_STR },
#endif
#ifdef NS_IXMLHTTPREQUEST_IID_STR
    { &kXMLHttpRequestIID, NS_IXMLHTTPREQUEST_IID_STR },
#endif
#ifdef NS_IXMLRPCCLIENT_IID_STR
    { &kXmlRpcClientIID, NS_IXMLRPCCLIENT_IID_STR },
#endif
#ifdef NS_IXMLRPCCLIENTLISTENER_IID_STR
    { &kXmlRpcClientListenerIID, NS_IXMLRPCCLIENTLISTENER_IID_STR },
#endif
#ifdef NS_IXPCONNECT_IID_STR
    { &kXPConnectIID, NS_IXPCONNECT_IID_STR },
#endif
#ifdef NS_IXPCSCRIPTABLE_IID_STR
    { &kXPCScriptableIID, NS_IXPCSCRIPTABLE_IID_STR },
#endif
#ifdef NS_IXPCSCRIPTNOTIFY_IID_STR
    { &kXPCScriptNotifyIID, NS_IXPCSCRIPTNOTIFY_IID_STR },
#endif
#ifdef NS_IXPCSECURITYMANAGER_IID_STR
    { &kXPCSecurityManagerIID, NS_IXPCSECURITYMANAGER_IID_STR },
#endif
#ifdef NS_IXPIDIALOGSERVICE_IID_STR
    { &kXPIDialogServiceIID, NS_IXPIDIALOGSERVICE_IID_STR },
#endif
#ifdef NS_IXPINOTIFIER_IID_STR
    { &kXPINotifierIID, NS_IXPINOTIFIER_IID_STR },
#endif
#ifdef NS_IXPIPROGRESSDIALOG_IID_STR
    { &kXPIProgressDialogIID, NS_IXPIPROGRESSDIALOG_IID_STR },
#endif
#ifdef NS_IXPTLOADER_IID_STR
    { &kXPTLoaderIID, NS_IXPTLOADER_IID_STR },
#endif
#ifdef NS_IXREMOTECLIENT_IID_STR
    { &kXRemoteClientIID, NS_IXREMOTECLIENT_IID_STR },
#endif
#ifdef NS_IXSLTEXCEPTION_IID_STR
    { &kXSLTExceptionIID, NS_IXSLTEXCEPTION_IID_STR },
#endif
#ifdef NS_IXSLTPROCESSOR_IID_STR
    { &kXSLTProcessorIID, NS_IXSLTPROCESSOR_IID_STR },
#endif
#ifdef NS_IXSLTPROCESSOROBSOLETE_IID_STR
    { &kXSLTProcessorObsoleteIID, NS_IXSLTPROCESSOROBSOLETE_IID_STR },
#endif
#ifdef NS_IXULBROWSERWINDOW_IID_STR
    { &kXULBrowserWindowIID, NS_IXULBROWSERWINDOW_IID_STR },
#endif
#ifdef NS_IXULSORTSERVICE_IID_STR
    { &kXULSortServiceIID, NS_IXULSORTSERVICE_IID_STR },
#endif
#ifdef NS_IXULTEMPLATEBUILDER_IID_STR
    { &kXULTemplateBuilderIID, NS_IXULTEMPLATEBUILDER_IID_STR },
#endif
#ifdef NS_IXULWINDOW_IID_STR
    { &kXULWindowIID, NS_IXULWINDOW_IID_STR },
#endif
#ifdef NS_IZIPREADER_IID_STR
    { &kZipReaderIID, NS_IZIPREADER_IID_STR },
#endif
#ifdef NS_IJRIPLUGIN_IID_STR
    { &kJRIPluginIID, NS_IJRIPLUGIN_IID_STR },
#endif
#ifdef NS_IJVMCONSOLE_IID_STR
    { &kJVMConsoleIID, NS_IJVMCONSOLE_IID_STR },
#endif
#ifdef NS_IJVMMANAGER_IID_STR
    { &kJVMManagerIID, NS_IJVMMANAGER_IID_STR },
#endif
#ifdef NS_IJVMPLUGIN_IID_STR
    { &kJVMPluginIID, NS_IJVMPLUGIN_IID_STR },
#endif
#ifdef NS_IJVMPLUGININSTANCE_IID_STR
    { &kJVMPluginInstanceIID, NS_IJVMPLUGININSTANCE_IID_STR },
#endif
#ifdef NS_IJVMPLUGINTAGINFO_IID_STR
    { &kJVMPluginTagInfoIID, NS_IJVMPLUGINTAGINFO_IID_STR },
#endif
#ifdef NS_IJVMPREFSWINDOW_IID_STR
    { &kJVMPrefsWindowIID, NS_IJVMPREFSWINDOW_IID_STR },
#endif
#ifdef NS_IJVMWINDOW_IID_STR
    { &kJVMWindowIID, NS_IJVMWINDOW_IID_STR },
#endif
#ifdef NS_ILIVECONNECTMANAGER_IID_STR
    { &kLiveConnectManagerIID, NS_ILIVECONNECTMANAGER_IID_STR },
#endif
#ifdef NS_ISECUREENV_IID_STR
    { &kSecureEnvIID, NS_ISECUREENV_IID_STR },
#endif
#ifdef NS_ISYMANTECDEBUGGER_IID_STR
    { &kSymantecDebuggerIID, NS_ISYMANTECDEBUGGER_IID_STR },
#endif
#ifdef NS_ISYMANTECDEBUGMANAGER_IID_STR
    { &kSymantecDebugManagerIID, NS_ISYMANTECDEBUGMANAGER_IID_STR },
#endif
#ifdef NS_IREADMANAGER_IID_STR
    { &kreadManagerIID, NS_IREADMANAGER_IID_STR },
#endif
#ifdef NS_JVM_IID_STR
    { &kjvmIID, NS_JVM_IID_STR },
#endif
#ifdef NS_JVMMANAGER_IID_STR
    { &kJVMManagerIID, NS_JVMMANAGER_IID_STR },
#endif
#ifdef NS_JVMMANAGER_CID_STR
    { &kJVMManagerCID, NS_JVMMANAGER_CID_STR },
#endif
#ifdef NS_JVMPLUGINTAGINFO_IID_STR
    { &kJVMPluginTagInfoIID, NS_JVMPLUGINTAGINFO_IID_STR },
#endif
#ifdef NS_ILIVECONNECT_IID_STR
    { &kLiveconnectIID, NS_ILIVECONNECT_IID_STR },
#endif
#ifdef NS_ISECURELIVECONNECT_IID_STR
    { &kSecureLiveconnectIID, NS_ISECURELIVECONNECT_IID_STR },
#endif
#ifdef NS_ISECURITYCONTEXT_IID_STR
    { &kSecurityContextIID, NS_ISECURITYCONTEXT_IID_STR },
#endif
#ifdef NS_ISHUTDOWNLISTENER_IID_STR
    { &kShutdownListenerIID, NS_ISHUTDOWNLISTENER_IID_STR },
#endif
#ifdef NS_ISERVICEMANAGER_OBSOLETE_IID_STR
    { &kServiceManagerObsoleteIID, NS_ISERVICEMANAGER_OBSOLETE_IID_STR },
#endif
#ifdef NS_IJVMTHREADMANAGER_IID_STR
    { &kJVMThreadManagerIID, NS_IJVMTHREADMANAGER_IID_STR },
#endif
#ifdef FLASH_IOBJECT7_IID_STR
    { &kFlashIObject7IID, FLASH_IOBJECT7_IID_STR },
#endif
#ifdef FLASH_ISCRIPTABLEPLUGIN7_IID_STR
    { &kFlashIScriptablePlugin7IID, FLASH_ISCRIPTABLEPLUGIN7_IID_STR },
#endif
#ifdef NS_IFLASH5_IID_STR
    { &kFlash5IID, NS_IFLASH5_IID_STR },
#endif
};
#endif

