# -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

      <menugroup id="context-navigation">
        <menuitem id="context-back"
                  class="menuitem-iconic"
                  tooltiptext="&backButton.tooltip;"
                  aria-label="&backCmd.label;"
                  command="Browser:BackOrBackDuplicate"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-forward"
                  class="menuitem-iconic"
                  tooltiptext="&forwardButton.tooltip;"
                  aria-label="&forwardCmd.label;"
                  command="Browser:ForwardOrForwardDuplicate"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-reload"
                  class="menuitem-iconic"
                  tooltiptext="&reloadButton.tooltip;"
                  aria-label="&reloadCmd.label;"
                  oncommand="gContextMenu.reload(event);"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-stop"
                  class="menuitem-iconic"
                  tooltiptext="&stopButton.tooltip;"
                  aria-label="&stopCmd.label;"
                  command="Browser:Stop"/>
        <menuitem id="context-bookmarkpage"
                  class="menuitem-iconic"
                  tooltiptext="&bookmarkPageCmd2.label;"
                  aria-label="&bookmarkPageCmd2.label;"
                  oncommand="gContextMenu.bookmarkThisPage();"/>
      </menugroup>
      <menuseparator id="context-sep-navigation"/>
      <menuseparator id="page-menu-separator"/>
      <menuitem id="spell-no-suggestions"
                disabled="true"
                label="&spellNoSuggestions.label;"/>
      <menuitem id="spell-add-to-dictionary"
                label="&spellAddToDictionary.label;"
                accesskey="&spellAddToDictionary.accesskey;"
                oncommand="InlineSpellCheckerUI.addToDictionary();"/>
      <menuitem id="spell-undo-add-to-dictionary"
                label="&spellUndoAddToDictionary.label;"
                accesskey="&spellUndoAddToDictionary.accesskey;"
                oncommand="InlineSpellCheckerUI.undoAddToDictionary();" />
      <menuseparator id="spell-suggestions-separator"/>
      <menuitem id="context-openlinkincurrent"
                label="&openLinkCmdInCurrent.label;"
                accesskey="&openLinkCmdInCurrent.accesskey;"
                oncommand="gContextMenu.openLinkInCurrent();"/>
      <menuitem id="context-openlinkintab"
                label="&openLinkCmdInTab.label;"
                accesskey="&openLinkCmdInTab.accesskey;"
                oncommand="gContextMenu.openLinkInTab();"/>
      <menuitem id="context-openlink"
                label="&openLinkCmd.label;"
                accesskey="&openLinkCmd.accesskey;"
                oncommand="gContextMenu.openLink();"/>
      <menuitem id="context-openlinkprivate"
                label="&openLinkInPrivateWindowCmd.label;"
                accesskey="&openLinkInPrivateWindowCmd.accesskey;"
                oncommand="gContextMenu.openLinkInPrivateWindow();"/>
      <menuseparator id="context-sep-open"/>
      <menuitem id="context-bookmarklink"
                label="&bookmarkThisLinkCmd.label;"
                accesskey="&bookmarkThisLinkCmd.accesskey;"
                oncommand="gContextMenu.bookmarkLink();"/>
      <menuitem id="context-sharelink"
                label="&shareLinkCmd.label;"
                accesskey="&shareLinkCmd.accesskey;"
                oncommand="gContextMenu.shareLink();"/>
      <menuitem id="context-savelink"
                label="&saveLinkCmd.label;"
                accesskey="&saveLinkCmd.accesskey;"
                oncommand="gContextMenu.saveLink();"/>
      <menu id="context-marklinkMenu" label="&social.marklinkMenu.label;"
            accesskey="&social.marklinkMenu.accesskey;">
        <menupopup/>
      </menu>
      <menuitem id="context-copyemail"
                label="&copyEmailCmd.label;"
                accesskey="&copyEmailCmd.accesskey;"
                oncommand="gContextMenu.copyEmail();"/>
      <menuitem id="context-copylink"
                label="&copyLinkCmd.label;"
                accesskey="&copyLinkCmd.accesskey;"
                oncommand="gContextMenu.copyLink();"/>
      <menuseparator id="context-sep-copylink"/>
      <menuitem id="context-media-play"
                label="&mediaPlay.label;"
                accesskey="&mediaPlay.accesskey;"
                oncommand="gContextMenu.mediaCommand('play');"/>
      <menuitem id="context-media-pause"
                label="&mediaPause.label;"
                accesskey="&mediaPause.accesskey;"
                oncommand="gContextMenu.mediaCommand('pause');"/>
      <menuitem id="context-media-mute"
                label="&mediaMute.label;"
                accesskey="&mediaMute.accesskey;"
                oncommand="gContextMenu.mediaCommand('mute');"/>
      <menuitem id="context-media-unmute"
                label="&mediaUnmute.label;"
                accesskey="&mediaUnmute.accesskey;"
                oncommand="gContextMenu.mediaCommand('unmute');"/>
      <menu id="context-media-playbackrate" label="&mediaPlaybackRate.label;" accesskey="&mediaPlaybackRate.accesskey;">
        <menupopup>
          <menuitem id="context-media-playbackrate-050x"
                    label="&mediaPlaybackRate050x.label;"
                    accesskey="&mediaPlaybackRate050x.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 0.5);"/>
          <menuitem id="context-media-playbackrate-100x"
                    label="&mediaPlaybackRate100x.label;"
                    accesskey="&mediaPlaybackRate100x.accesskey;"
                    type="radio"
                    name="playbackrate"
                    checked="true"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 1.0);"/>
          <menuitem id="context-media-playbackrate-150x"
                    label="&mediaPlaybackRate150x.label;"
                    accesskey="&mediaPlaybackRate150x.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 1.5);"/>
          <menuitem id="context-media-playbackrate-200x"
                    label="&mediaPlaybackRate200x.label;"
                    accesskey="&mediaPlaybackRate200x.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 2.0);"/>
        </menupopup>
      </menu>
      <menuitem id="context-media-showcontrols"
                label="&mediaShowControls.label;"
                accesskey="&mediaShowControls.accesskey;"
                oncommand="gContextMenu.mediaCommand('showcontrols');"/>
      <menuitem id="context-media-hidecontrols"
                label="&mediaHideControls.label;"
                accesskey="&mediaHideControls.accesskey;"
                oncommand="gContextMenu.mediaCommand('hidecontrols');"/>
      <menuitem id="context-video-showstats"
                accesskey="&videoShowStats.accesskey;"
                label="&videoShowStats.label;"
                oncommand="gContextMenu.mediaCommand('showstats');"/>
      <menuitem id="context-video-hidestats"
                accesskey="&videoHideStats.accesskey;"
                label="&videoHideStats.label;"
                oncommand="gContextMenu.mediaCommand('hidestats');"/>
      <menuitem id="context-video-fullscreen"
                accesskey="&videoFullScreen.accesskey;"
                label="&videoFullScreen.label;"
                oncommand="gContextMenu.fullScreenVideo();"/>
      <menuitem id="context-leave-dom-fullscreen"
                accesskey="&leaveDOMFullScreen.accesskey;"
                label="&leaveDOMFullScreen.label;"
                oncommand="gContextMenu.leaveDOMFullScreen();"/>
      <menuseparator id="context-media-sep-commands"/>
      <menuitem id="context-reloadimage"
                label="&reloadImageCmd.label;"
                accesskey="&reloadImageCmd.accesskey;"
                oncommand="gContextMenu.reloadImage();"/>
      <menuitem id="context-viewimage"
                label="&viewImageCmd.label;"
                accesskey="&viewImageCmd.accesskey;"
                oncommand="gContextMenu.viewMedia(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-viewvideo"
                label="&viewVideoCmd.label;"
                accesskey="&viewVideoCmd.accesskey;"
                oncommand="gContextMenu.viewMedia(event);"
                onclick="checkForMiddleClick(this, event);"/>
#ifdef CONTEXT_COPY_IMAGE_CONTENTS
      <menuitem id="context-copyimage-contents"
                label="&copyImageContentsCmd.label;"
                accesskey="&copyImageContentsCmd.accesskey;"
                oncommand="goDoCommand('cmd_copyImage');"/>
#endif
      <menuitem id="context-copyimage"
                label="&copyImageCmd.label;"
                accesskey="&copyImageCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuitem id="context-copyvideourl"
                label="&copyVideoURLCmd.label;"
                accesskey="&copyVideoURLCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuitem id="context-copyaudiourl"
                label="&copyAudioURLCmd.label;"
                accesskey="&copyAudioURLCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuseparator id="context-sep-copyimage"/>
      <menuitem id="context-saveimage"
                label="&saveImageCmd.label;"
                accesskey="&saveImageCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-shareimage"
                label="&shareImageCmd.label;"
                accesskey="&shareImageCmd.accesskey;"
                oncommand="gContextMenu.shareImage();"/>
      <menuitem id="context-sendimage"
                label="&emailImageCmd.label;"
                accesskey="&emailImageCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-setDesktopBackground"
                label="&setDesktopBackgroundCmd.label;"
                accesskey="&setDesktopBackgroundCmd.accesskey;"
                oncommand="gContextMenu.setDesktopBackground();"/>
      <menuitem id="context-viewimageinfo"
                label="&viewImageInfoCmd.label;"
                accesskey="&viewImageInfoCmd.accesskey;"
                oncommand="gContextMenu.viewImageInfo();"/>
      <menuitem id="context-viewimagedesc"
                label="&viewImageDescCmd.label;"
                accesskey="&viewImageDescCmd.accesskey;"
                oncommand="gContextMenu.viewImageDesc(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-savevideo"
                label="&saveVideoCmd.label;"
                accesskey="&saveVideoCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-sharevideo"
                label="&shareVideoCmd.label;"
                accesskey="&shareVideoCmd.accesskey;"
                oncommand="gContextMenu.shareVideo();"/>
      <menuitem id="context-saveaudio"
                label="&saveAudioCmd.label;"
                accesskey="&saveAudioCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-video-saveimage"
                accesskey="&videoSaveImage.accesskey;"
                label="&videoSaveImage.label;"
                oncommand="gContextMenu.saveVideoFrameAsImage();"/>
      <menuitem id="context-sendvideo"
                label="&emailVideoCmd.label;"
                accesskey="&emailVideoCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-sendaudio"
                label="&emailAudioCmd.label;"
                accesskey="&emailAudioCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-ctp-play"
                label="&playPluginCmd.label;"
                accesskey="&playPluginCmd.accesskey;"
                oncommand="gContextMenu.playPlugin();"/>
      <menuitem id="context-ctp-hide"
                label="&hidePluginCmd.label;"
                accesskey="&hidePluginCmd.accesskey;"
                oncommand="gContextMenu.hidePlugin();"/>
      <menuseparator id="context-sep-ctp"/>
      <menuitem id="context-sharepage"
                label="&sharePageCmd.label;"
                accesskey="&sharePageCmd.accesskey;"
                oncommand="SocialShare.sharePage();"/>
      <menuitem id="context-savepage"
                label="&savePageCmd.label;"
                accesskey="&savePageCmd.accesskey2;"
                oncommand="gContextMenu.savePageAs();"/>
      <menu id="context-markpageMenu" label="&social.markpageMenu.label;"
            accesskey="&social.markpageMenu.accesskey;">
        <menupopup/>
      </menu>
      <menuseparator id="context-sep-viewbgimage"/>
      <menuitem id="context-viewbgimage"
                label="&viewBGImageCmd.label;"
                accesskey="&viewBGImageCmd.accesskey;"
                oncommand="gContextMenu.viewBGImage(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-undo"
                label="&undoCmd.label;"
                accesskey="&undoCmd.accesskey;"
                command="cmd_undo"/>
      <menuseparator id="context-sep-undo"/>
      <menuitem id="context-cut"
                label="&cutCmd.label;"
                accesskey="&cutCmd.accesskey;"
                command="cmd_cut"/>
      <menuitem id="context-copy"
                label="&copyCmd.label;"
                accesskey="&copyCmd.accesskey;"
                command="cmd_copy"/>
      <menuitem id="context-paste"
                label="&pasteCmd.label;"
                accesskey="&pasteCmd.accesskey;"
                command="cmd_paste"/>
      <menuitem id="context-delete"
                label="&deleteCmd.label;"
                accesskey="&deleteCmd.accesskey;"
                command="cmd_delete"/>
      <menuseparator id="context-sep-paste"/>
      <menuitem id="context-selectall"
                label="&selectAllCmd.label;"
                accesskey="&selectAllCmd.accesskey;"
                command="cmd_selectAll"/>
      <menuseparator id="context-sep-selectall"/>
      <menuitem id="context-keywordfield"
                label="&keywordfield.label;"
                accesskey="&keywordfield.accesskey;"
                oncommand="AddKeywordForSearchField();"/>
      <menuitem id="context-searchselect"
                oncommand="BrowserSearch.loadSearchFromContext(this.searchTerms);"/>
      <menuitem id="context-shareselect"
                label="&shareSelectCmd.label;"
                accesskey="&shareSelectCmd.accesskey;"
                oncommand="gContextMenu.shareSelect(getBrowserSelection());"/>
      <menuseparator id="frame-sep"/>
      <menu id="frame" label="&thisFrameMenu.label;" accesskey="&thisFrameMenu.accesskey;">
        <menupopup>
          <menuitem id="context-showonlythisframe"
                    label="&showOnlyThisFrameCmd.label;"
                    accesskey="&showOnlyThisFrameCmd.accesskey;"
                    oncommand="gContextMenu.showOnlyThisFrame();"/>
          <menuitem id="context-openframeintab"
                    label="&openFrameCmdInTab.label;"
                    accesskey="&openFrameCmdInTab.accesskey;"
                    oncommand="gContextMenu.openFrameInTab();"/>
          <menuitem id="context-openframe"
                    label="&openFrameCmd.label;"
                    accesskey="&openFrameCmd.accesskey;"
                    oncommand="gContextMenu.openFrame();"/>
          <menuseparator id="open-frame-sep"/>
          <menuitem id="context-reloadframe"
                    label="&reloadFrameCmd.label;"
                    accesskey="&reloadFrameCmd.accesskey;"
                    oncommand="gContextMenu.reloadFrame();"/>
          <menuseparator/>
          <menuitem id="context-bookmarkframe"
                    label="&bookmarkThisFrameCmd.label;"
                    accesskey="&bookmarkThisFrameCmd.accesskey;"
                    oncommand="gContextMenu.addBookmarkForFrame();"/>
          <menuitem id="context-saveframe"
                    label="&saveFrameCmd.label;"
                    accesskey="&saveFrameCmd.accesskey;"
                    oncommand="gContextMenu.saveFrame();"/>
          <menuseparator/>
          <menuitem id="context-printframe"
                    label="&printFrameCmd.label;"
                    accesskey="&printFrameCmd.accesskey;"
                    oncommand="gContextMenu.printFrame();"/>
          <menuseparator/>
          <menuitem id="context-viewframesource"
                    label="&viewFrameSourceCmd.label;"
                    accesskey="&viewFrameSourceCmd.accesskey;"
                    oncommand="gContextMenu.viewFrameSource();"
                    observes="isFrameImage"/>
          <menuitem id="context-viewframeinfo"
                    label="&viewFrameInfoCmd.label;"
                    accesskey="&viewFrameInfoCmd.accesskey;"
                    oncommand="gContextMenu.viewFrameInfo();"/>
        </menupopup>
      </menu>
      <menuitem id="context-viewpartialsource-selection"
                label="&viewPartialSourceForSelectionCmd.label;"
                accesskey="&viewPartialSourceCmd.accesskey;"
                oncommand="gContextMenu.viewPartialSource('selection');"
                observes="isImage"/>
      <menuitem id="context-viewpartialsource-mathml"
                label="&viewPartialSourceForMathMLCmd.label;"
                accesskey="&viewPartialSourceCmd.accesskey;"
                oncommand="gContextMenu.viewPartialSource('mathml');"
                observes="isImage"/>
      <menuseparator id="context-sep-viewsource"/>
      <menuitem id="context-viewsource"
                label="&viewPageSourceCmd.label;"
                accesskey="&viewPageSourceCmd.accesskey;"
                oncommand="BrowserViewSourceOfDocument(gContextMenu.browser.contentDocument);"
                observes="isImage"/>
      <menuitem id="context-viewinfo"
                label="&viewPageInfoCmd.label;"
                accesskey="&viewPageInfoCmd.accesskey;"
                oncommand="gContextMenu.viewInfo();"/>
      <menuseparator id="spell-separator"/>
      <menuitem id="spell-check-enabled"
                label="&spellCheckToggle.label;"
                type="checkbox"
                accesskey="&spellCheckToggle.accesskey;"
                oncommand="InlineSpellCheckerUI.toggleEnabled();"/>
      <menuitem id="spell-add-dictionaries-main"
                label="&spellAddDictionaries.label;"
                accesskey="&spellAddDictionaries.accesskey;"
                oncommand="gContextMenu.addDictionaries();"/>
      <menu id="spell-dictionaries"
            label="&spellDictionaries.label;"
            accesskey="&spellDictionaries.accesskey;">
          <menupopup id="spell-dictionaries-menu">
              <menuseparator id="spell-language-separator"/>
              <menuitem id="spell-add-dictionaries"
                        label="&spellAddDictionaries.label;"
                        accesskey="&spellAddDictionaries.accesskey;"
                        oncommand="gContextMenu.addDictionaries();"/>
          </menupopup>
      </menu>
      <menuseparator hidden="true" id="context-sep-bidi"/>
      <menuitem hidden="true" id="context-bidi-text-direction-toggle"
                label="&bidiSwitchTextDirectionItem.label;"
                accesskey="&bidiSwitchTextDirectionItem.accesskey;"
                command="cmd_switchTextDirection"/>
      <menuitem hidden="true" id="context-bidi-page-direction-toggle"
                label="&bidiSwitchPageDirectionItem.label;"
                accesskey="&bidiSwitchPageDirectionItem.accesskey;"
                oncommand="gContextMenu.switchPageDirection();"/>
      <menuseparator id="inspect-separator" hidden="true"/>
      <menuitem id="context-inspect"
                hidden="true"
                label="&inspectContextMenu.label;"
                accesskey="&inspectContextMenu.accesskey;"
                oncommand="gContextMenu.inspectNode();"/>
