/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* PublicKeyPinningService.cpp, you shouldn't be #including it.              */
/*****************************************************************************/
#include <stdint.h>
/* AddTrust External Root */
static const char kAddTrust_External_RootFingerprint[] =
  "lCppFqbkrlJ3EcVFAkeip0+44VaoJUymbnOaEUk7tEU=";

/* AddTrust Low-Value Services Root */
static const char kAddTrust_Low_Value_Services_RootFingerprint[] =
  "BStocQfshOhzA4JFLsKidFF0XXSFpX1vRk4Np6G2ryo=";

/* AddTrust Public Services Root */
static const char kAddTrust_Public_Services_RootFingerprint[] =
  "OGHXtpYfzbISBFb/b8LrdwSxp0G0vZM6g3b14ZFcppg=";

/* AddTrust Qualified Certificates Root */
static const char kAddTrust_Qualified_Certificates_RootFingerprint[] =
  "xzr8Lrp3DQy8HuQfJStS6Kk9ErctzOwDHY2DnL+Bink=";

/* AffirmTrust Commercial */
static const char kAffirmTrust_CommercialFingerprint[] =
  "bEZLmlsjOl6HTadlwm8EUBDS3c/0V5TwtMfkqvpQFJU=";

/* AffirmTrust Networking */
static const char kAffirmTrust_NetworkingFingerprint[] =
  "lAcq0/WPcPkwmOWl9sBMlscQvYSdgxhJGa6Q64kK5AA=";

/* AffirmTrust Premium */
static const char kAffirmTrust_PremiumFingerprint[] =
  "x/Q7TPW3FWgpT4IrU3YmBfbd0Vyt7Oc56eLDy6YenWc=";

/* AffirmTrust Premium ECC */
static const char kAffirmTrust_Premium_ECCFingerprint[] =
  "MhmwkRT/SVo+tusAwu/qs0ACrl8KVsdnnqCHo/oDfk8=";

/* America Online Root Certification Authority 1 */
static const char kAmerica_Online_Root_Certification_Authority_1Fingerprint[] =
  "I4SdCUkj1EpIgbY6sYXpvhWqyO8sMETZNLx/JuLSzWk=";

/* America Online Root Certification Authority 2 */
static const char kAmerica_Online_Root_Certification_Authority_2Fingerprint[] =
  "/PfamDYD6IhiAw2WE32OEwMbrftNVsH9TKzDOfa9uyo=";

/* Baltimore CyberTrust Root */
static const char kBaltimore_CyberTrust_RootFingerprint[] =
  "Y9mvm0exBk1JoQ57f9Vm28jKo5lFm/woKcVxrYxu80o=";

/* COMODO Certification Authority */
static const char kCOMODO_Certification_AuthorityFingerprint[] =
  "AG1751Vd2CAmRCxPGieoDomhmJy4ezREjtIZTBgZbV4=";

/* COMODO ECC Certification Authority */
static const char kCOMODO_ECC_Certification_AuthorityFingerprint[] =
  "58qRu/uxh4gFezqAcERupSkRYBlBAvfcw7mEjGPLnNU=";

/* Comodo AAA Services root */
static const char kComodo_AAA_Services_rootFingerprint[] =
  "vRU+17BDT2iGsXvOi76E7TQMcTLXAqj0+jGPdW7L1vM=";

/* Comodo Secure Services root */
static const char kComodo_Secure_Services_rootFingerprint[] =
  "RpHL/ehKa2BS3b4VK7DCFq4lqG5XR4E9vA8UfzOFcL4=";

/* Comodo Trusted Services root */
static const char kComodo_Trusted_Services_rootFingerprint[] =
  "4tiR77c4ZpEF1TDeXtcuKyrD9KZweLU0mz/ayklvXrg=";

/* Cybertrust Global Root */
static const char kCybertrust_Global_RootFingerprint[] =
  "foeCwVDOOVL4AuY2AjpdPpW7XWjjPoWtsroXgSXOvxU=";

/* DigiCert Assured ID Root CA */
static const char kDigiCert_Assured_ID_Root_CAFingerprint[] =
  "I/Lt/z7ekCWanjD0Cvj5EqXls2lOaThEA0H2Bg4BT/o=";

/* DigiCert Global Root CA */
static const char kDigiCert_Global_Root_CAFingerprint[] =
  "r/mIkG3eEpVdm+u/ko/cwxzOMo1bk4TyHIlByibiA5E=";

/* DigiCert High Assurance EV Root CA */
static const char kDigiCert_High_Assurance_EV_Root_CAFingerprint[] =
  "WoiWRyIOVNa9ihaBciRSC7XHjliYS9VwUGOIud4PB18=";

/* End Entity Test Cert */
static const char kEnd_Entity_Test_CertFingerprint[] =
  "a08RrXscTn7kKTSPR8uZVrmc0o3ryPd+o3menqJHJBw=";

/* Entrust Root Certification Authority */
static const char kEntrust_Root_Certification_AuthorityFingerprint[] =
  "bb+uANN7nNc/j7R95lkXrwDg3d9C286sIMF8AnXuIJU=";

/* Entrust.net Premium 2048 Secure Server CA */
static const char kEntrust_net_Premium_2048_Secure_Server_CAFingerprint[] =
  "HqPF5D7WbC2imDpCpKebHpBnhs6fG1hiFBmgBGOofTg=";

/* Equifax Secure CA */
static const char kEquifax_Secure_CAFingerprint[] =
  "/1aAzXOlcD2gSBegdf1GJQanNQbEuBoVg+9UlHjSZHY=";

/* Equifax Secure Global eBusiness CA */
static const char kEquifax_Secure_Global_eBusiness_CAFingerprint[] =
  "pvH5v4oKndwID7SbHvw9GhwsMtwOE2pbAMlzFvKj3BE=";

/* Equifax Secure eBusiness CA 1 */
static const char kEquifax_Secure_eBusiness_CA_1Fingerprint[] =
  "JsGNxu6m9jL2drzrodjCtINS8pwtX82oeOCdy4Mt1uU=";

/* GOOGLE_PIN_AlphaSSL_G2 */
static const char kGOOGLE_PIN_AlphaSSL_G2Fingerprint[] =
  "yxgiWGK++SFB9ySwt3M3qpn5HO0ZLFY5D+h+G/vcT/c=";

/* GOOGLE_PIN_CryptoCat1 */
static const char kGOOGLE_PIN_CryptoCat1Fingerprint[] =
  "vKaqtTLWmVuXPVJE+0OqN5sRc4VCcSQHI/W3XTDVR24=";

/* GOOGLE_PIN_EntrustRootEC1 */
static const char kGOOGLE_PIN_EntrustRootEC1Fingerprint[] =
  "/qK31kX7pz11PB7Jp4cMQOH3sMVh6Se5hb9xGGbjbyI=";

/* GOOGLE_PIN_Entrust_G2 */
static const char kGOOGLE_PIN_Entrust_G2Fingerprint[] =
  "du6FkDdMcVQ3u8prumAo6t3i3G27uMP2EOhR8R0at/U=";

/* GOOGLE_PIN_Entrust_SSL */
static const char kGOOGLE_PIN_Entrust_SSLFingerprint[] =
  "nsxRNo6G40YPZsKV5JQt1TCA8nseQQr/LRqp1Oa8fnw=";

/* GOOGLE_PIN_GTECyberTrustGlobalRoot */
static const char kGOOGLE_PIN_GTECyberTrustGlobalRootFingerprint[] =
  "EGn6R6CqT4z3ERscrqNl7q7RC//zJmDe9uBhS/rnCHU=";

/* GOOGLE_PIN_GoDaddySecure */
static const char kGOOGLE_PIN_GoDaddySecureFingerprint[] =
  "MrZLZnJ6IGPkBm87lYywqu5Xal7O/ZUzmbuIdHMdlYc=";

/* GOOGLE_PIN_Libertylavabitcom */
static const char kGOOGLE_PIN_LibertylavabitcomFingerprint[] =
  "WnKzsDXgqPtS1KvtImrhQPqcxfpmfssuI2cSJt4LMks=";

/* GOOGLE_PIN_RapidSSL */
static const char kGOOGLE_PIN_RapidSSLFingerprint[] =
  "lT09gPUeQfbYrlxRtpsHrjDblj9Rpz+u7ajfCrg4qDM=";

/* GOOGLE_PIN_Tor2web */
static const char kGOOGLE_PIN_Tor2webFingerprint[] =
  "99ogQzjMuUTBkG1ZP7FME0K4kvBEti8Buzu4nZjRItM=";

/* GeoTrust Global CA */
static const char kGeoTrust_Global_CAFingerprint[] =
  "h6801m+z8v3zbgkRHpq6L29Esgfzhj89C1SyUCOQmqU=";

/* GeoTrust Global CA 2 */
static const char kGeoTrust_Global_CA_2Fingerprint[] =
  "F3VaXClfPS1y5vAxofB/QAxYi55YKyLxfq4xoVkNEYU=";

/* GeoTrust Primary Certification Authority */
static const char kGeoTrust_Primary_Certification_AuthorityFingerprint[] =
  "SQVGZiOrQXi+kqxcvWWE96HhfydlLVqFr4lQTqI5qqo=";

/* GeoTrust Primary Certification Authority - G2 */
static const char kGeoTrust_Primary_Certification_Authority___G2Fingerprint[] =
  "vPtEqrmtAhAVcGtBIep2HIHJ6IlnWQ9vlK50TciLePs=";

/* GeoTrust Primary Certification Authority - G3 */
static const char kGeoTrust_Primary_Certification_Authority___G3Fingerprint[] =
  "q5hJUnat8eyv8o81xTBIeB5cFxjaucjmelBPT2pRMo8=";

/* GeoTrust Universal CA */
static const char kGeoTrust_Universal_CAFingerprint[] =
  "lpkiXF3lLlbN0y3y6W0c/qWqPKC7Us2JM8I7XCdEOCA=";

/* GeoTrust Universal CA 2 */
static const char kGeoTrust_Universal_CA_2Fingerprint[] =
  "fKoDRlEkWQxgHlZ+UhSOlSwM/+iQAFMP4NlbbVDqrkE=";

/* GlobalSign Root CA */
static const char kGlobalSign_Root_CAFingerprint[] =
  "K87oWBWM9UZfyddvDfoxL+8lpNyoUB2ptGtn0fv6G2Q=";

/* GlobalSign Root CA - R2 */
static const char kGlobalSign_Root_CA___R2Fingerprint[] =
  "iie1VXtL7HzAMF+/PVPR9xzT80kQxdZeJ+zduCB3uj0=";

/* GlobalSign Root CA - R3 */
static const char kGlobalSign_Root_CA___R3Fingerprint[] =
  "cGuxAXyFXFkWm61cF4HPWX8S0srS9j0aSqN0k4AP+4A=";

/* Go Daddy Class 2 CA */
static const char kGo_Daddy_Class_2_CAFingerprint[] =
  "VjLZe/p3W/PJnd6lL8JVNBCGQBZynFLdZSTIqcO0SJ8=";

/* Go Daddy Root Certificate Authority - G2 */
static const char kGo_Daddy_Root_Certificate_Authority___G2Fingerprint[] =
  "Ko8tivDrEjiY90yGasP6ZpBU4jwXvHqVvQI0GS3GNdA=";

/* GoogleBackup2048 */
static const char kGoogleBackup2048Fingerprint[] =
  "vq7OyjSnqOco9nyMCDGdy77eijM=";

/* GoogleG2 */
static const char kGoogleG2Fingerprint[] =
  "Q9rWMO5T+KmAym79hfRqo3mQ4Oo=";

/* Network Solutions Certificate Authority */
static const char kNetwork_Solutions_Certificate_AuthorityFingerprint[] =
  "MtGA7THJNVieydu7ciEjuIO1/C3BD5/KOpXXfhv8tTQ=";

/* Starfield Class 2 CA */
static const char kStarfield_Class_2_CAFingerprint[] =
  "FfFKxFycfaIz00eRZOgTf+Ne4POK6FgYPwhBDqgqxLQ=";

/* Starfield Root Certificate Authority - G2 */
static const char kStarfield_Root_Certificate_Authority___G2Fingerprint[] =
  "gI1os/q0iEpflxrOfRBVDXqVoWN3Tz7Dav/7IT++THQ=";

/* Starfield Services Root Certificate Authority - G2 */
static const char kStarfield_Services_Root_Certificate_Authority___G2Fingerprint[] =
  "KwccWaCgrnaw6tsrrSO61FgLacNgG2MMLq8GE6+oP5I=";

/* StartCom Certification Authority */
static const char kStartCom_Certification_AuthorityFingerprint[] =
  "5C8kvU039KouVrl52D0eZSGf4Onjo4Khs8tmyTlV3nU=";

/* StartCom Certification Authority G2 */
static const char kStartCom_Certification_Authority_G2Fingerprint[] =
  "FSg5faISiQqDCwuVpZlozvI0dzd531GBzxD6ZHU0u2U=";

/* TC TrustCenter Class 2 CA II */
static const char kTC_TrustCenter_Class_2_CA_IIFingerprint[] =
  "rPZeHWLLWKK6/W/6tA+4hpnEc5fPXLSD1C1pytNM1Is=";

/* TC TrustCenter Class 3 CA II */
static const char kTC_TrustCenter_Class_3_CA_IIFingerprint[] =
  "k5KuIUmSSt435kXbof9L3dzaKykbYJdmnSr6XHo3Jhk=";

/* TC TrustCenter Universal CA I */
static const char kTC_TrustCenter_Universal_CA_IFingerprint[] =
  "st71NirT+s0EvSkEekOET3ZwNOpIkvgOVr7mkCQ+JQI=";

/* TC TrustCenter Universal CA III */
static const char kTC_TrustCenter_Universal_CA_IIIFingerprint[] =
  "q1zbM1Y5c1bW5pGXPCW4YYtl12qQSG6nqKXBd2f0Zzo=";

/* TestSPKI */
static const char kTestSPKIFingerprint[] =
  "AAAAAAAAAAAAAAAAAAAAAAAAAAA=";

/* Thawte Premium Server CA */
static const char kThawte_Premium_Server_CAFingerprint[] =
  "9TwiBZgX3Zb0AGUWOdL4V+IQcKWavtkHlADZ9pVQaQA=";

/* Thawte Server CA */
static const char kThawte_Server_CAFingerprint[] =
  "nG9qEjy6pO402+zu4kyX1ziHjLQj88InOQNCT10fbdU=";

/* Tor1 */
static const char kTor1Fingerprint[] =
  "juNxSTv9UANmpC9kF5GKpmWNx3Y=";

/* Tor2 */
static const char kTor2Fingerprint[] =
  "lia43lPolzSPVIq34Dw57uYcLD8=";

/* Tor3 */
static const char kTor3Fingerprint[] =
  "rzEyQIKOh77j87n5bjWUNguXF8Y=";

/* Twitter1 */
static const char kTwitter1Fingerprint[] =
  "Vv7zwhR9TtOIN/29MFI4cgHld40=";

/* UTN DATACorp SGC Root CA */
static const char kUTN_DATACorp_SGC_Root_CAFingerprint[] =
  "QAL80xHQczFWfnG82XHkYEjI3OjRZZcRdTs9qiommvo=";

/* UTN USERFirst Email Root CA */
static const char kUTN_USERFirst_Email_Root_CAFingerprint[] =
  "Laj56jRU0hFGRko/nQKNxMf7tXscUsc8KwVyovWZotM=";

/* UTN USERFirst Hardware Root CA */
static const char kUTN_USERFirst_Hardware_Root_CAFingerprint[] =
  "TUDnr0MEoJ3of7+YliBMBVFB4/gJsv5zO7IxD9+YoWI=";

/* UTN USERFirst Object Root CA */
static const char kUTN_USERFirst_Object_Root_CAFingerprint[] =
  "D+FMJksXu28NZT56cOs2Pb9UvhWAOe3a5cJXEd9IwQM=";

/* VeriSign Class 3 Public Primary Certification Authority - G4 */
static const char kVeriSign_Class_3_Public_Primary_Certification_Authority___G4Fingerprint[] =
  "UZJDjsNp1+4M5x9cbbdflB779y5YRBcV6Z6rBMLIrO4=";

/* VeriSign Class 3 Public Primary Certification Authority - G5 */
static const char kVeriSign_Class_3_Public_Primary_Certification_Authority___G5Fingerprint[] =
  "JbQbUG5JMJUoI6brnx0x3vZF6jilxsapbXGVfjhN8Fg=";

/* VeriSign Universal Root Certification Authority */
static const char kVeriSign_Universal_Root_Certification_AuthorityFingerprint[] =
  "lnsM2T/O9/J84sJFdnrpsFp3awZJ+ZZbYpCWhGloaHI=";

/* Verisign Class 1 Public Primary Certification Authority */
static const char kVerisign_Class_1_Public_Primary_Certification_AuthorityFingerprint[] =
  "LclHC+Y+9KzxvYKGCUArt7h72ZY4pkOTTohoLRvowwg=";

/* Verisign Class 1 Public Primary Certification Authority - G3 */
static const char kVerisign_Class_1_Public_Primary_Certification_Authority___G3Fingerprint[] =
  "IgduWu9Eu5pBaii30cRDItcFn2D+/6XK9sW+hEeJEwM=";

/* Verisign Class 2 Public Primary Certification Authority - G2 */
static const char kVerisign_Class_2_Public_Primary_Certification_Authority___G2Fingerprint[] =
  "2oALgLKofTmeZvoZ1y/fSZg7R9jPMix8eVA6DH4o/q8=";

/* Verisign Class 2 Public Primary Certification Authority - G3 */
static const char kVerisign_Class_2_Public_Primary_Certification_Authority___G3Fingerprint[] =
  "cAajgxHlj7GTSEIzIYIQxmEloOSoJq7VOaxWHfv72QM=";

/* Verisign Class 3 Public Primary Certification Authority */
static const char kVerisign_Class_3_Public_Primary_Certification_AuthorityFingerprint[] =
  "sRJBQqWhpaKIGcc1NA7/jJ4vgWj+47oYfyU7waOS1+I=";

/* Verisign Class 3 Public Primary Certification Authority - G2 */
static const char kVerisign_Class_3_Public_Primary_Certification_Authority___G2Fingerprint[] =
  "AjyBzOjnxk+pQtPBUEhwfTXZu1uH9PVExb8bxWQ68vo=";

/* Verisign Class 3 Public Primary Certification Authority - G3 */
static const char kVerisign_Class_3_Public_Primary_Certification_Authority___G3Fingerprint[] =
  "SVqWumuteCQHvVIaALrOZXuzVVVeS7f4FGxxu6V+es4=";

/* Verisign Class 4 Public Primary Certification Authority - G3 */
static const char kVerisign_Class_4_Public_Primary_Certification_Authority___G3Fingerprint[] =
  "VnuCEf0g09KD7gzXzgZyy52ZvFtIeljJ1U7Gf3fUqPU=";

/* XRamp Global CA Root */
static const char kXRamp_Global_CA_RootFingerprint[] =
  "BRz5+pXkDpuD7a7aaWH2Fox4ecRmAXJHnN1RqwPOpis=";

/* thawte Primary Root CA */
static const char kthawte_Primary_Root_CAFingerprint[] =
  "HXXQgxueCIU5TTLHob/bPbwcKOKw6DkfsTWYHbxbqTY=";

/* thawte Primary Root CA - G2 */
static const char kthawte_Primary_Root_CA___G2Fingerprint[] =
  "Z9xPMvoQ59AaeaBzqgyeAhLsL/w9d54Kp/nA8OHCyJM=";

/* thawte Primary Root CA - G3 */
static const char kthawte_Primary_Root_CA___G3Fingerprint[] =
  "GQbGEk27Q4V40A4GbVBUxsN/D6YCjAVUXgmU7drshik=";

/* Pinsets are each an ordered list by the actual value of the fingerprint */
struct StaticFingerprints {
  const size_t size;
  const char* const* data;
};

struct StaticPinset {
  const StaticFingerprints* sha1;
  const StaticFingerprints* sha256;
};

/* PreloadedHPKPins.json pinsets */
static const char* kPinset_google_root_pems_sha256_Data[] = {
  kEquifax_Secure_CAFingerprint,
  kAmerica_Online_Root_Certification_Authority_2Fingerprint,
  kComodo_Trusted_Services_rootFingerprint,
  kCOMODO_ECC_Certification_AuthorityFingerprint,
  kStartCom_Certification_AuthorityFingerprint,
  kStartCom_Certification_AuthorityFingerprint,
  kThawte_Premium_Server_CAFingerprint,
  kCOMODO_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G2Fingerprint,
  kXRamp_Global_CA_RootFingerprint,
  kAddTrust_Low_Value_Services_RootFingerprint,
  kGeoTrust_Global_CA_2Fingerprint,
  kStartCom_Certification_Authority_G2Fingerprint,
  kStarfield_Class_2_CAFingerprint,
  kthawte_Primary_Root_CA___G3Fingerprint,
  kthawte_Primary_Root_CAFingerprint,
  kEntrust_net_Premium_2048_Secure_Server_CAFingerprint,
  kDigiCert_Assured_ID_Root_CAFingerprint,
  kAmerica_Online_Root_Certification_Authority_1Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G5Fingerprint,
  kEquifax_Secure_eBusiness_CA_1Fingerprint,
  kGlobalSign_Root_CAFingerprint,
  kGo_Daddy_Root_Certificate_Authority___G2Fingerprint,
  kStarfield_Services_Root_Certificate_Authority___G2Fingerprint,
  kAffirmTrust_Premium_ECCFingerprint,
  kNetwork_Solutions_Certificate_AuthorityFingerprint,
  kAddTrust_Public_Services_RootFingerprint,
  kUTN_DATACorp_SGC_Root_CAFingerprint,
  kComodo_Secure_Services_rootFingerprint,
  kGeoTrust_Primary_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G3Fingerprint,
  kUTN_USERFirst_Hardware_Root_CAFingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G4Fingerprint,
  kGo_Daddy_Class_2_CAFingerprint,
  kVerisign_Class_4_Public_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kBaltimore_CyberTrust_RootFingerprint,
  kthawte_Primary_Root_CA___G2Fingerprint,
  kAffirmTrust_CommercialFingerprint,
  kEntrust_Root_Certification_AuthorityFingerprint,
  kGlobalSign_Root_CA___R3Fingerprint,
  kGeoTrust_Universal_CA_2Fingerprint,
  kCybertrust_Global_RootFingerprint,
  kStarfield_Root_Certificate_Authority___G2Fingerprint,
  kGeoTrust_Global_CAFingerprint,
  kGlobalSign_Root_CA___R2Fingerprint,
  kTC_TrustCenter_Class_3_CA_IIFingerprint,
  kAffirmTrust_NetworkingFingerprint,
  kAddTrust_External_RootFingerprint,
  kVeriSign_Universal_Root_Certification_AuthorityFingerprint,
  kGeoTrust_Universal_CAFingerprint,
  kThawte_Server_CAFingerprint,
  kEquifax_Secure_Global_eBusiness_CAFingerprint,
  kTC_TrustCenter_Universal_CA_IIIFingerprint,
  kGeoTrust_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_Global_Root_CAFingerprint,
  kTC_TrustCenter_Class_2_CA_IIFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_AuthorityFingerprint,
  kTC_TrustCenter_Universal_CA_IFingerprint,
  kGeoTrust_Primary_Certification_Authority___G2Fingerprint,
  kComodo_AAA_Services_rootFingerprint,
  kAffirmTrust_PremiumFingerprint,
  kAddTrust_Qualified_Certificates_RootFingerprint,
};
static const StaticFingerprints kPinset_google_root_pems_sha256 = { 64, kPinset_google_root_pems_sha256_Data };

static const StaticPinset kPinset_google_root_pems = {
  nullptr,
  &kPinset_google_root_pems_sha256
};

static const char* kPinset_mozilla_sha256_Data[] = {
  kGeoTrust_Global_CA_2Fingerprint,
  kthawte_Primary_Root_CA___G3Fingerprint,
  kthawte_Primary_Root_CAFingerprint,
  kDigiCert_Assured_ID_Root_CAFingerprint,
  kVerisign_Class_1_Public_Primary_Certification_Authority___G3Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G5Fingerprint,
  kGeoTrust_Primary_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G3Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G4Fingerprint,
  kVerisign_Class_4_Public_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kBaltimore_CyberTrust_RootFingerprint,
  kthawte_Primary_Root_CA___G2Fingerprint,
  kVerisign_Class_2_Public_Primary_Certification_Authority___G3Fingerprint,
  kGeoTrust_Universal_CA_2Fingerprint,
  kGeoTrust_Global_CAFingerprint,
  kVeriSign_Universal_Root_Certification_AuthorityFingerprint,
  kGeoTrust_Universal_CAFingerprint,
  kGeoTrust_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_Global_Root_CAFingerprint,
  kGeoTrust_Primary_Certification_Authority___G2Fingerprint,
};
static const StaticFingerprints kPinset_mozilla_sha256 = { 21, kPinset_mozilla_sha256_Data };

static const StaticPinset kPinset_mozilla = {
  nullptr,
  &kPinset_mozilla_sha256
};

static const char* kPinset_mozilla_fxa_sha256_Data[] = {
  kDigiCert_Global_Root_CAFingerprint,
};
static const StaticFingerprints kPinset_mozilla_fxa_sha256 = { 1, kPinset_mozilla_fxa_sha256_Data };

static const StaticPinset kPinset_mozilla_fxa = {
  nullptr,
  &kPinset_mozilla_fxa_sha256
};

static const char* kPinset_mozilla_test_sha256_Data[] = {
  kEnd_Entity_Test_CertFingerprint,
};
static const StaticFingerprints kPinset_mozilla_test_sha256 = { 1, kPinset_mozilla_test_sha256_Data };

static const StaticPinset kPinset_mozilla_test = {
  nullptr,
  &kPinset_mozilla_test_sha256
};

/* Chrome static pinsets */
static const char* kPinset_test_sha1_Data[] = {
  kTestSPKIFingerprint,
};
static const StaticFingerprints kPinset_test_sha1 = { 1, kPinset_test_sha1_Data };

static const StaticPinset kPinset_test = {
  &kPinset_test_sha1,
  nullptr
};

static const char* kPinset_google_sha1_Data[] = {
  kGoogleG2Fingerprint,
  kGoogleBackup2048Fingerprint,
};
static const StaticFingerprints kPinset_google_sha1 = { 2, kPinset_google_sha1_Data };

static const StaticPinset kPinset_google = {
  &kPinset_google_sha1,
  nullptr
};

static const char* kPinset_tor_sha1_Data[] = {
  kTor1Fingerprint,
  kTor2Fingerprint,
  kTor3Fingerprint,
};
static const StaticFingerprints kPinset_tor_sha1 = { 3, kPinset_tor_sha1_Data };

static const char* kPinset_tor_sha256_Data[] = {
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kGOOGLE_PIN_RapidSSLFingerprint,
};
static const StaticFingerprints kPinset_tor_sha256 = { 2, kPinset_tor_sha256_Data };

static const StaticPinset kPinset_tor = {
  &kPinset_tor_sha1,
  &kPinset_tor_sha256
};

static const char* kPinset_twitterCom_sha1_Data[] = {
  kTwitter1Fingerprint,
};
static const StaticFingerprints kPinset_twitterCom_sha1 = { 1, kPinset_twitterCom_sha1_Data };

static const char* kPinset_twitterCom_sha256_Data[] = {
  kVerisign_Class_2_Public_Primary_Certification_Authority___G2Fingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G2Fingerprint,
  kGeoTrust_Global_CA_2Fingerprint,
  kDigiCert_Assured_ID_Root_CAFingerprint,
  kVerisign_Class_1_Public_Primary_Certification_Authority___G3Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G5Fingerprint,
  kVerisign_Class_1_Public_Primary_Certification_AuthorityFingerprint,
  kGeoTrust_Primary_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G3Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G4Fingerprint,
  kVerisign_Class_4_Public_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kVerisign_Class_2_Public_Primary_Certification_Authority___G3Fingerprint,
  kGeoTrust_Universal_CA_2Fingerprint,
  kGeoTrust_Global_CAFingerprint,
  kVeriSign_Universal_Root_Certification_AuthorityFingerprint,
  kGeoTrust_Universal_CAFingerprint,
  kGeoTrust_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_Global_Root_CAFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_AuthorityFingerprint,
  kGeoTrust_Primary_Certification_Authority___G2Fingerprint,
};
static const StaticFingerprints kPinset_twitterCom_sha256 = { 21, kPinset_twitterCom_sha256_Data };

static const StaticPinset kPinset_twitterCom = {
  &kPinset_twitterCom_sha1,
  &kPinset_twitterCom_sha256
};

static const char* kPinset_twitterCDN_sha1_Data[] = {
  kTwitter1Fingerprint,
};
static const StaticFingerprints kPinset_twitterCDN_sha1 = { 1, kPinset_twitterCDN_sha1_Data };

static const char* kPinset_twitterCDN_sha256_Data[] = {
  kVerisign_Class_2_Public_Primary_Certification_Authority___G2Fingerprint,
  kComodo_Trusted_Services_rootFingerprint,
  kCOMODO_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G2Fingerprint,
  kAddTrust_Low_Value_Services_RootFingerprint,
  kUTN_USERFirst_Object_Root_CAFingerprint,
  kGOOGLE_PIN_GTECyberTrustGlobalRootFingerprint,
  kGeoTrust_Global_CA_2Fingerprint,
  kEntrust_net_Premium_2048_Secure_Server_CAFingerprint,
  kDigiCert_Assured_ID_Root_CAFingerprint,
  kVerisign_Class_1_Public_Primary_Certification_Authority___G3Fingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G5Fingerprint,
  kGlobalSign_Root_CAFingerprint,
  kUTN_USERFirst_Email_Root_CAFingerprint,
  kVerisign_Class_1_Public_Primary_Certification_AuthorityFingerprint,
  kAddTrust_Public_Services_RootFingerprint,
  kUTN_DATACorp_SGC_Root_CAFingerprint,
  kComodo_Secure_Services_rootFingerprint,
  kGeoTrust_Primary_Certification_AuthorityFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_Authority___G3Fingerprint,
  kUTN_USERFirst_Hardware_Root_CAFingerprint,
  kVeriSign_Class_3_Public_Primary_Certification_Authority___G4Fingerprint,
  kVerisign_Class_4_Public_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kBaltimore_CyberTrust_RootFingerprint,
  kEntrust_Root_Certification_AuthorityFingerprint,
  kVerisign_Class_2_Public_Primary_Certification_Authority___G3Fingerprint,
  kGlobalSign_Root_CA___R3Fingerprint,
  kGOOGLE_PIN_Entrust_G2Fingerprint,
  kGeoTrust_Universal_CA_2Fingerprint,
  kGeoTrust_Global_CAFingerprint,
  kGlobalSign_Root_CA___R2Fingerprint,
  kAddTrust_External_RootFingerprint,
  kVeriSign_Universal_Root_Certification_AuthorityFingerprint,
  kGeoTrust_Universal_CAFingerprint,
  kGOOGLE_PIN_Entrust_SSLFingerprint,
  kGeoTrust_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_Global_Root_CAFingerprint,
  kVerisign_Class_3_Public_Primary_Certification_AuthorityFingerprint,
  kGeoTrust_Primary_Certification_Authority___G2Fingerprint,
  kComodo_AAA_Services_rootFingerprint,
  kAddTrust_Qualified_Certificates_RootFingerprint,
};
static const StaticFingerprints kPinset_twitterCDN_sha256 = { 42, kPinset_twitterCDN_sha256_Data };

static const StaticPinset kPinset_twitterCDN = {
  &kPinset_twitterCDN_sha1,
  &kPinset_twitterCDN_sha256
};

static const char* kPinset_tor2web_sha256_Data[] = {
  kGOOGLE_PIN_Tor2webFingerprint,
  kGOOGLE_PIN_AlphaSSL_G2Fingerprint,
};
static const StaticFingerprints kPinset_tor2web_sha256 = { 2, kPinset_tor2web_sha256_Data };

static const StaticPinset kPinset_tor2web = {
  nullptr,
  &kPinset_tor2web_sha256
};

static const char* kPinset_cryptoCat_sha256_Data[] = {
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kGOOGLE_PIN_CryptoCat1Fingerprint,
};
static const StaticFingerprints kPinset_cryptoCat_sha256 = { 2, kPinset_cryptoCat_sha256_Data };

static const StaticPinset kPinset_cryptoCat = {
  nullptr,
  &kPinset_cryptoCat_sha256
};

static const char* kPinset_lavabit_sha256_Data[] = {
  kGOOGLE_PIN_LibertylavabitcomFingerprint,
};
static const StaticFingerprints kPinset_lavabit_sha256 = { 1, kPinset_lavabit_sha256_Data };

static const StaticPinset kPinset_lavabit = {
  nullptr,
  &kPinset_lavabit_sha256
};

static const char* kPinset_dropbox_sha256_Data[] = {
  kGOOGLE_PIN_EntrustRootEC1Fingerprint,
  kThawte_Premium_Server_CAFingerprint,
  kthawte_Primary_Root_CA___G3Fingerprint,
  kthawte_Primary_Root_CAFingerprint,
  kEntrust_net_Premium_2048_Secure_Server_CAFingerprint,
  kDigiCert_Assured_ID_Root_CAFingerprint,
  kGo_Daddy_Root_Certificate_Authority___G2Fingerprint,
  kGOOGLE_PIN_GoDaddySecureFingerprint,
  kGeoTrust_Primary_Certification_AuthorityFingerprint,
  kGo_Daddy_Class_2_CAFingerprint,
  kDigiCert_High_Assurance_EV_Root_CAFingerprint,
  kthawte_Primary_Root_CA___G2Fingerprint,
  kEntrust_Root_Certification_AuthorityFingerprint,
  kGOOGLE_PIN_Entrust_G2Fingerprint,
  kGeoTrust_Global_CAFingerprint,
  kGeoTrust_Primary_Certification_Authority___G3Fingerprint,
  kDigiCert_Global_Root_CAFingerprint,
  kGeoTrust_Primary_Certification_Authority___G2Fingerprint,
};
static const StaticFingerprints kPinset_dropbox_sha256 = { 18, kPinset_dropbox_sha256_Data };

static const StaticPinset kPinset_dropbox = {
  nullptr,
  &kPinset_dropbox_sha256
};

/* Domainlist */
struct TransportSecurityPreload {
  const char* mHost;
  const bool mIncludeSubdomains;
  const bool mTestMode;
  const bool mIsMoz;
  const int32_t mId;
  const StaticPinset *pinset;
};

/* Sort hostnames for binary search. */
static const TransportSecurityPreload kPublicKeyPinningPreloadList[] = {
  { "accounts.firefox.com", true, true, false, 4, &kPinset_mozilla_fxa },
  { "accounts.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "addons.mozilla.net", true, false, true, 2, &kPinset_mozilla },
  { "addons.mozilla.org", true, false, true, 1, &kPinset_mozilla },
  { "admin.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "android.com", true, true, false, -1, &kPinset_google_root_pems },
  { "api.twitter.com", true, false, false, -1, &kPinset_twitterCDN },
  { "apis.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "appengine.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "aus4.mozilla.org", true, true, true, 3, &kPinset_mozilla },
  { "blog.torproject.org", true, true, false, -1, &kPinset_tor },
  { "business.twitter.com", true, false, false, -1, &kPinset_twitterCom },
  { "cdn.mozilla.net", true, false, true, -1, &kPinset_mozilla },
  { "cdn.mozilla.org", true, false, true, -1, &kPinset_mozilla },
  { "chart.apis.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "check.torproject.org", true, true, false, -1, &kPinset_tor },
  { "checkout.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "chrome-devtools-frontend.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "chrome.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "chromiumcodereview.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "cloud.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "code.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "codereview.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "codereview.chromium.org", true, true, false, -1, &kPinset_google_root_pems },
  { "crypto.cat", false, true, false, -1, &kPinset_cryptoCat },
  { "dev.twitter.com", true, false, false, -1, &kPinset_twitterCom },
  { "dist.torproject.org", true, true, false, -1, &kPinset_tor },
  { "dl.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "docs.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "doubleclick.net", true, true, false, -1, &kPinset_google_root_pems },
  { "drive.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "dropbox.com", false, true, false, -1, &kPinset_dropbox },
  { "encrypted.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "exclude-subdomains.pinning.example.com", false, false, false, 0, &kPinset_mozilla_test },
  { "g.co", true, true, false, -1, &kPinset_google_root_pems },
  { "glass.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "gmail.com", false, true, false, -1, &kPinset_google_root_pems },
  { "goo.gl", true, true, false, -1, &kPinset_google_root_pems },
  { "google-analytics.com", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ac", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ad", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ae", true, true, false, -1, &kPinset_google_root_pems },
  { "google.af", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ag", true, true, false, -1, &kPinset_google_root_pems },
  { "google.am", true, true, false, -1, &kPinset_google_root_pems },
  { "google.as", true, true, false, -1, &kPinset_google_root_pems },
  { "google.at", true, true, false, -1, &kPinset_google_root_pems },
  { "google.az", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ba", true, true, false, -1, &kPinset_google_root_pems },
  { "google.be", true, true, false, -1, &kPinset_google_root_pems },
  { "google.bf", true, true, false, -1, &kPinset_google_root_pems },
  { "google.bg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.bi", true, true, false, -1, &kPinset_google_root_pems },
  { "google.bj", true, true, false, -1, &kPinset_google_root_pems },
  { "google.bs", true, true, false, -1, &kPinset_google_root_pems },
  { "google.by", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ca", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cat", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cc", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cd", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cf", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ch", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ci", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ao", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.bw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ck", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.cr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.hu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.id", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.il", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.im", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.in", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.je", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.jp", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ke", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.kr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ls", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ma", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.mz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.nz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.th", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.tz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ug", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.uk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.uz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.ve", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.vi", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.za", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.zm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.co.zw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.af", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ag", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ai", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ar", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.au", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.bd", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.bh", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.bn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.bo", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.br", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.by", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.bz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.cn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.co", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.cu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.cy", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.do", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ec", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.eg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.et", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.fj", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ge", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.gh", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.gi", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.gr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.gt", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.hk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.iq", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.jm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.jo", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.kh", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.kw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.lb", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ly", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.mt", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.mx", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.my", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.na", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.nf", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ng", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ni", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.np", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.nr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.om", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.pa", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.pe", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ph", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.pk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.pl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.pr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.py", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.qa", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ru", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.sa", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.sb", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.sg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.sl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.sv", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.tj", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.tn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.tr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.tw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ua", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.uy", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.vc", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.ve", true, true, false, -1, &kPinset_google_root_pems },
  { "google.com.vn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cv", true, true, false, -1, &kPinset_google_root_pems },
  { "google.cz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.de", true, true, false, -1, &kPinset_google_root_pems },
  { "google.dj", true, true, false, -1, &kPinset_google_root_pems },
  { "google.dk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.dm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.dz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ee", true, true, false, -1, &kPinset_google_root_pems },
  { "google.es", true, true, false, -1, &kPinset_google_root_pems },
  { "google.fi", true, true, false, -1, &kPinset_google_root_pems },
  { "google.fm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.fr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ga", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ge", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gp", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.gy", true, true, false, -1, &kPinset_google_root_pems },
  { "google.hk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.hn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.hr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ht", true, true, false, -1, &kPinset_google_root_pems },
  { "google.hu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ie", true, true, false, -1, &kPinset_google_root_pems },
  { "google.im", true, true, false, -1, &kPinset_google_root_pems },
  { "google.info", true, true, false, -1, &kPinset_google_root_pems },
  { "google.iq", true, true, false, -1, &kPinset_google_root_pems },
  { "google.is", true, true, false, -1, &kPinset_google_root_pems },
  { "google.it", true, true, false, -1, &kPinset_google_root_pems },
  { "google.it.ao", true, true, false, -1, &kPinset_google_root_pems },
  { "google.je", true, true, false, -1, &kPinset_google_root_pems },
  { "google.jo", true, true, false, -1, &kPinset_google_root_pems },
  { "google.jobs", true, true, false, -1, &kPinset_google_root_pems },
  { "google.jp", true, true, false, -1, &kPinset_google_root_pems },
  { "google.kg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ki", true, true, false, -1, &kPinset_google_root_pems },
  { "google.kz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.la", true, true, false, -1, &kPinset_google_root_pems },
  { "google.li", true, true, false, -1, &kPinset_google_root_pems },
  { "google.lk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.lt", true, true, false, -1, &kPinset_google_root_pems },
  { "google.lu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.lv", true, true, false, -1, &kPinset_google_root_pems },
  { "google.md", true, true, false, -1, &kPinset_google_root_pems },
  { "google.me", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ml", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ms", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mv", true, true, false, -1, &kPinset_google_root_pems },
  { "google.mw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ne", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ne.jp", true, true, false, -1, &kPinset_google_root_pems },
  { "google.net", true, true, false, -1, &kPinset_google_root_pems },
  { "google.nl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.no", true, true, false, -1, &kPinset_google_root_pems },
  { "google.nr", true, true, false, -1, &kPinset_google_root_pems },
  { "google.nu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.off.ai", true, true, false, -1, &kPinset_google_root_pems },
  { "google.pk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.pl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.pn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ps", true, true, false, -1, &kPinset_google_root_pems },
  { "google.pt", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ro", true, true, false, -1, &kPinset_google_root_pems },
  { "google.rs", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ru", true, true, false, -1, &kPinset_google_root_pems },
  { "google.rw", true, true, false, -1, &kPinset_google_root_pems },
  { "google.sc", true, true, false, -1, &kPinset_google_root_pems },
  { "google.se", true, true, false, -1, &kPinset_google_root_pems },
  { "google.sh", true, true, false, -1, &kPinset_google_root_pems },
  { "google.si", true, true, false, -1, &kPinset_google_root_pems },
  { "google.sk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.sm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.sn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.so", true, true, false, -1, &kPinset_google_root_pems },
  { "google.st", true, true, false, -1, &kPinset_google_root_pems },
  { "google.td", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tk", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tl", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tm", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tn", true, true, false, -1, &kPinset_google_root_pems },
  { "google.to", true, true, false, -1, &kPinset_google_root_pems },
  { "google.tt", true, true, false, -1, &kPinset_google_root_pems },
  { "google.us", true, true, false, -1, &kPinset_google_root_pems },
  { "google.uz", true, true, false, -1, &kPinset_google_root_pems },
  { "google.vg", true, true, false, -1, &kPinset_google_root_pems },
  { "google.vu", true, true, false, -1, &kPinset_google_root_pems },
  { "google.ws", true, true, false, -1, &kPinset_google_root_pems },
  { "googleadservices.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googleapis.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googlecode.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googlecommerce.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googlegroups.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googlemail.com", false, true, false, -1, &kPinset_google_root_pems },
  { "googleplex.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googlesyndication.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googletagmanager.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googletagservices.com", true, true, false, -1, &kPinset_google_root_pems },
  { "googleusercontent.com", true, true, false, -1, &kPinset_google_root_pems },
  { "goto.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "groups.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "gstatic.com", true, true, false, -1, &kPinset_google_root_pems },
  { "history.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "hostedtalkgadget.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "include-subdomains.pinning.example.com", true, false, false, -1, &kPinset_mozilla_test },
  { "liberty.lavabit.com", true, true, false, -1, &kPinset_lavabit },
  { "mail.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "market.android.com", true, true, false, -1, &kPinset_google_root_pems },
  { "media.mozilla.com", true, false, true, -1, &kPinset_mozilla },
  { "mobile.twitter.com", true, false, false, -1, &kPinset_twitterCom },
  { "oauth.twitter.com", true, false, false, -1, &kPinset_twitterCom },
  { "pinningtest.appspot.com", true, false, false, -1, &kPinset_test },
  { "platform.twitter.com", true, false, false, -1, &kPinset_twitterCDN },
  { "play.google.com", false, true, false, -1, &kPinset_google_root_pems },
  { "plus.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "plus.sandbox.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "profiles.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "script.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "security.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "sites.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "spreadsheets.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "ssl.google-analytics.com", true, true, false, -1, &kPinset_google_root_pems },
  { "talk.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "talkgadget.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "test-mode.pinning.example.com", true, true, false, -1, &kPinset_mozilla_test },
  { "tor2web.org", true, true, false, -1, &kPinset_tor2web },
  { "torproject.org", false, true, false, -1, &kPinset_tor },
  { "translate.googleapis.com", true, true, false, -1, &kPinset_google_root_pems },
  { "twimg.com", true, false, false, -1, &kPinset_twitterCDN },
  { "twitter.com", false, false, false, -1, &kPinset_twitterCom },
  { "urchin.com", true, true, false, -1, &kPinset_google_root_pems },
  { "w-spotlight.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wallet.google.com", true, true, false, -1, &kPinset_google_root_pems },
  { "webfilings-eu-mirror.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "webfilings-eu.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "webfilings-mirror-hrd.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "webfilings.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-bigsky-master.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-demo-eu.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-demo-hrd.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-dogfood-hrd.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-pentest.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-staging-hr.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-training-hrd.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-training-master.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "wf-trial-hrd.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "www.dropbox.com", true, true, false, -1, &kPinset_dropbox },
  { "www.gmail.com", false, true, false, -1, &kPinset_google_root_pems },
  { "www.googlemail.com", false, true, false, -1, &kPinset_google_root_pems },
  { "www.torproject.org", true, true, false, -1, &kPinset_tor },
  { "www.twitter.com", true, false, false, -1, &kPinset_twitterCom },
  { "xbrlsuccess.appspot.com", true, true, false, -1, &kPinset_google_root_pems },
  { "youtu.be", true, true, false, -1, &kPinset_google_root_pems },
  { "youtube.com", true, true, false, -1, &kPinset_google_root_pems },
  { "ytimg.com", true, true, false, -1, &kPinset_google_root_pems },
};

static const int kPublicKeyPinningPreloadListLength = 324;

static const int32_t kUnknownId = -1;

static const PRTime kPreloadPKPinsExpirationTime = INT64_C(1414231806296000);
