/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1427541074005000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "0x0a.net", true },
  { "17hats.com", true },
  { "18f.gsa.gov", true },
  { "1a-diamantscheiben.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "aclu.org", false },
  { "activiti.alfresco.com", false },
  { "adamkostecki.de", true },
  { "addvocate.com", true },
  { "admin.google.com", true },
  { "adsfund.org", true },
  { "ahoyconference.com", true },
  { "aie.de", true },
  { "aiticon.com", true },
  { "aladdinschools.appspot.com", false },
  { "alexsexton.com", true },
  { "alexyang.me", true },
  { "alpha.irccloud.com", false },
  { "andreasbreitenlohner.de", true },
  { "anetaben.nl", true },
  { "angularjs.org", true },
  { "animurecs.com", true },
  { "annahmeschluss.de", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "ansdell.net", true },
  { "anycoin.me", true },
  { "apadvantage.com", true },
  { "api.intercom.io", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apn-einstellungen.de", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", false },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appengine.google.com", true },
  { "aprz.de", true },
  { "archlinux.de", true },
  { "arendburgers.nl", true },
  { "arivo.com.br", true },
  { "arlen.io", true },
  { "auf-feindgebiet.de", true },
  { "baer.im", true },
  { "balcan-underground.net", true },
  { "baldwinkoo.com", true },
  { "bank.simple.com", false },
  { "barcodeberlin.com", true },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "baruch.me", true },
  { "bassh.net", true },
  { "bautied.de", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bccx.com", true },
  { "bcrook.com", false },
  { "beamitapp.com", true },
  { "beastowner.com", true },
  { "beastowner.li", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beneathvt.com", true },
  { "benjamins.com", true },
  { "best-wedding-quotes.com", true },
  { "big-andy.co.uk", true },
  { "bigbrownpromotions.com.au", true },
  { "bitbucket.org", false },
  { "bitfactory.ws", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blacklane.com", true },
  { "blessnet.jp", true },
  { "blocksatz-medien.de", true },
  { "blog.cyveillance.com", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "bodo-wolff.de", true },
  { "bohramt.de", true },
  { "bonigo.de", true },
  { "boxcryptor.com", true },
  { "brunosouza.org", true },
  { "buddhistische-weisheiten.org", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "bulktrade.de", true },
  { "business.lookout.com", false },
  { "buttercoin.com", true },
  { "buzzconcert.com", true },
  { "bytepark.de", false },
  { "ca.gparent.org", false },
  { "call.me", true },
  { "carezone.com", false },
  { "cartouche24.eu", true },
  { "cdnb.co", true },
  { "celltek-server.de", false },
  { "certible.com", true },
  { "certly.io", true },
  { "chainmonitor.com", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "chontalpa.pw", true },
  { "chrisjean.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.google.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chulado.com", true },
  { "cktennis.com", true },
  { "clapping-rhymes.com", true },
  { "clintwilson.technology", true },
  { "cloud.google.com", true },
  { "cloudcert.org", true },
  { "cloudns.com.au", true },
  { "cloudsecurityalliance.org", true },
  { "cloudstoragemaus.com", true },
  { "cloudup.com", true },
  { "code-poets.co.uk", true },
  { "code.google.com", true },
  { "codepref.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", true },
  { "coinapult.com", true },
  { "comdurav.com", true },
  { "comssa.org.au", true },
  { "config.schokokeks.org", false },
  { "conformal.com", true },
  { "conrad-kostecki.de", true },
  { "controlcenter.gigahost.dk", true },
  { "cotonea.de", true },
  { "crm.onlime.ch", false },
  { "crowdjuris.com", true },
  { "crypto.cat", false },
  { "cryptopartyatx.org", true },
  { "cspbuilder.info", true },
  { "cube.de", true },
  { "cujanovic.com", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curlybracket.co.uk", true },
  { "cyanogenmod.xxx", true },
  { "cybershambles.com", true },
  { "cybozu.com", true },
  { "cyphertite.com", true },
  { "czbix.com", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "data-abundance.com", true },
  { "data.qld.gov.au", false },
  { "datenkeks.de", true },
  { "davidlyness.com", true },
  { "deadbeef.ninja", true },
  { "dealcruiser.nl", true },
  { "debtkit.co.uk", true },
  { "dedimax.de", true },
  { "denh.am", true },
  { "depechemode-live.com", true },
  { "derevtsov.com", false },
  { "derhil.de", true },
  { "destinationbijoux.fr", true },
  { "detectify.com", false },
  { "developer.mydigipass.com", false },
  { "devh.de", true },
  { "diamante.ro", true },
  { "die-besten-weisheiten.de", true },
  { "dillonkorman.com", true },
  { "dinamoelektrik.com", true },
  { "dist.torproject.org", false },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "domains.google.com", true },
  { "domaris.de", true },
  { "donmez.ws", false },
  { "download.jitsi.org", false },
  { "drive.google.com", true },
  { "dropbox.com", false },
  { "dzlibs.io", true },
  { "easysimplecrm.com", false },
  { "ebanking.indovinabank.com.vn", false },
  { "ecosystem.atlassian.net", true },
  { "edit.yahoo.com", false },
  { "edyou.eu", true },
  { "eff.org", true },
  { "eldietista.es", true },
  { "elnutricionista.es", true },
  { "emailprivacytester.com", true },
  { "encircleapp.com", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "energy-drink-magazin.de", true },
  { "enorekcah.com", true },
  { "entropia.de", false },
  { "errors.zenpayroll.com", false },
  { "esec.rs", true },
  { "espra.com", true },
  { "ethack.org", true },
  { "ethitter.com", true },
  { "eurotramp.com", true },
  { "everhome.de", true },
  { "evstatus.com", true },
  { "explodie.org", true },
  { "f-droid.org", true },
  { "fabianfischer.de", true },
  { "factor.cc", false },
  { "fairbill.com", true },
  { "faq.lookout.com", false },
  { "fastcomcorp.net", true },
  { "fedorapeople.org", true },
  { "feedbin.com", false },
  { "ferienhaus-polchow-ruegen.de", false },
  { "fiken.no", true },
  { "firemail.io", true },
  { "fischer-its.com", true },
  { "fj.simple.com", false },
  { "flamer-scene.com", true },
  { "fleximus.org", false },
  { "floobits.com", true },
  { "flynn.io", true },
  { "forewordreviews.com", true },
  { "forodeespanol.com", true },
  { "forum.linode.com", false },
  { "forum.quantifiedself.com", true },
  { "fralef.me", false },
  { "frederik-braun.com", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "fronteers.nl", true },
  { "fundingempire.com", true },
  { "futos.de", true },
  { "gamercredo.com", true },
  { "garron.net", true },
  { "gemeinfreie-lieder.de", true },
  { "gerardozamudio.mx", true },
  { "gernert-server.de", true },
  { "getcloak.com", false },
  { "getdigitized.net", true },
  { "getssl.uz", true },
  { "giacomopelagatti.it", true },
  { "github.com", true },
  { "gizzo.sk", true },
  { "glass.google.com", true },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "gmail.com", false },
  { "gmantra.org", true },
  { "gmcd.co", true },
  { "go.xero.com", false },
  { "gocardless.com", true },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "goto.google.com", true },
  { "gplintegratedit.com", true },
  { "grc.com", false },
  { "greensolid.biz", true },
  { "grepular.com", true },
  { "groups.google.com", true },
  { "gtraxapp.com", true },
  { "gunnarhafdal.com", true },
  { "guphi.net", true },
  { "guthabenkarten-billiger.de", true },
  { "hack.li", true },
  { "hackerone.com", true },
  { "hansvaneijsden.com", true },
  { "harvestapp.com", true },
  { "hasilocke.de", true },
  { "haste.ch", true },
  { "haufschild.de", true },
  { "hausverbrauch.de", true },
  { "heha.co", true },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "helichat.de", true },
  { "help.simpletax.ca", false },
  { "helpium.de", true },
  { "hex2013.com", true },
  { "hexony.com", true },
  { "history.google.com", true },
  { "honeybadger.io", false },
  { "horseboners.xxx", true },
  { "horza.org", true },
  { "hostedtalkgadget.google.com", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hpac-portal.com", true },
  { "html5.org", true },
  { "iamcarrico.com", true },
  { "ian.sh", true },
  { "iban.is", true },
  { "id-co.in", true },
  { "id.atlassian.com", true },
  { "id.mayfirst.org", false },
  { "ideaweb.de", true },
  { "ihrlotto.de", true },
  { "ilikerainbows.co.uk", true },
  { "imouto.my", true },
  { "in.xero.com", false },
  { "inbox.google.com", true },
  { "inkbunny.net", true },
  { "inleaked.com", true },
  { "insouciant.org", true },
  { "irische-segenswuensche.info", true },
  { "ironfistdesign.com", true },
  { "isitchristmas.com", true },
  { "it-schwerin.de", true },
  { "itsamurai.ru", true },
  { "itshost.ru", true },
  { "jackyyf.com", false },
  { "janoberst.com", true },
  { "janus-engineering.de", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jfreitag.de", true },
  { "jitsi.org", false },
  { "jmedved.com", true },
  { "jonas-keidel.de", true },
  { "jonaswitmer.ch", true },
  { "jonnybarnes.uk", true },
  { "julian-kipka.de", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "k-dev.de", true },
  { "kaheim.de", true },
  { "kardize24.pl", true },
  { "kartonmodellbau.org", true },
  { "kdex.de", true },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "kernel-error.de", true },
  { "kevincox.ca", true },
  { "keycdn.com", true },
  { "keyerror.com", true },
  { "khmath.com", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kinogb.net", false },
  { "kinsights.com", false },
  { "kitsta.com", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", true },
  { "klaxn.com", true },
  { "kleidertauschpartys.de", true },
  { "knowledgehook.com", true },
  { "komandakovalchuk.com", true },
  { "konklone.com", true },
  { "koop-bremen.de", true },
  { "koordinate.net", true },
  { "kraken.io", true },
  { "kura.io", true },
  { "lagerauftrag.info", true },
  { "lasst-uns-beten.de", true },
  { "launchkey.com", true },
  { "lavalite.de", true },
  { "lb-toner.de", true },
  { "leonardcamacho.me", true },
  { "library.linode.com", false },
  { "liebel.org", true },
  { "limpid.nl", true },
  { "lingolia.com", true },
  { "linode.com", false },
  { "linx.net", true },
  { "ljs.io", true },
  { "lockify.com", true },
  { "lodash.com", true },
  { "loenshotel.de", true },
  { "loftboard.eu", true },
  { "logentries.com", false },
  { "login.corp.google.com", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "lolicore.ch", true },
  { "lookout.com", false },
  { "ludwig.im", true },
  { "lukonet.com", true },
  { "lumi.do", false },
  { "luneta.nearbuysystems.com", false },
  { "mach-politik.ch", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mailbox.org", true },
  { "makeyourlaws.org", true },
  { "malnex.de", true },
  { "man3s.jp", true },
  { "manage.zenpayroll.com", false },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "mandala-ausmalbilder.de", true },
  { "market.android.com", true },
  { "markusueberallassetmanagement.de", true },
  { "matatall.com", true },
  { "mathiasbynens.be", true },
  { "matteomarescotti.it", true },
  { "mattmccutchen.net", true },
  { "mbp.banking.co.at", false },
  { "md5file.com", true },
  { "mdfnet.se", true },
  { "mediacru.sh", true },
  { "medium.com", true },
  { "meetfinch.com", true },
  { "mega.co.nz", false },
  { "meinebo.it", true },
  { "members.mayfirst.org", false },
  { "members.nearlyfreespeech.net", false },
  { "miasarafina.de", true },
  { "michalspacek.cz", true },
  { "mig5.net", true },
  { "mike-bland.com", true },
  { "mikewest.org", true },
  { "miku.hatsune.my", true },
  { "minez-nightswatch.com", true },
  { "minikneet.com", true },
  { "minnesotadata.com", true },
  { "miskatonic.org", true },
  { "mkcert.org", true },
  { "mnsure.org", true },
  { "mobile.usaa.com", false },
  { "mondwandler.de", true },
  { "moriz.de", true },
  { "mothereff.in", true },
  { "mountainmusicpromotions.com", true },
  { "mountainroseherbs.com", true },
  { "movlib.org", true },
  { "mqas.net", true },
  { "msc-seereisen.net", true },
  { "mths.be", true },
  { "mudcrab.us", true },
  { "munich-rage.de", true },
  { "musicgamegalaxy.de", true },
  { "mutantmonkey.sexy", true },
  { "mwe.st", true },
  { "my.onlime.ch", false },
  { "my.usa.gov", true },
  { "my.xero.com", false },
  { "mygadgetguardian.lookout.com", false },
  { "mykreuzfahrt.de", true },
  { "mylookout.com", false },
  { "mynigma.org", true },
  { "myplaceonline.com", true },
  { "nachsenden.info", true },
  { "nectarleaf.com", true },
  { "neilwynne.com", false },
  { "net-safe.info", true },
  { "netzbit.de", true },
  { "newstarnootropics.com", true },
  { "ng-security.com", true },
  { "nmctest.net", true },
  { "nos-oignons.net", true },
  { "npw.net", true },
  { "oakslighting.co.uk", true },
  { "okmx.de", true },
  { "omitech.co.uk", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onsitemassageco.com", true },
  { "oplop.appspot.com", true },
  { "opsmate.com", false },
  { "optimus.io", true },
  { "orbograph-hrcm.com", true },
  { "oscarvk.ch", true },
  { "osterkraenzchen.de", true },
  { "otakuworld.de", true },
  { "oversight.io", true },
  { "p.linode.com", false },
  { "packagist.org", false },
  { "pajonzeck.de", true },
  { "palava.tv", true },
  { "parent5446.us", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passport.yandex.by", false },
  { "passport.yandex.com", false },
  { "passport.yandex.com.tr", false },
  { "passport.yandex.kz", false },
  { "passport.yandex.ru", false },
  { "passport.yandex.ua", false },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwords.google.com", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "patt.us", true },
  { "pay.gigahost.dk", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "paypal.com", false },
  { "pdf.yt", true },
  { "peercraft.com", true },
  { "phoenixlogan.com", true },
  { "picksin.club", true },
  { "pierre-schmitz.com", true },
  { "pixi.me", true },
  { "play.google.com", true },
  { "plothost.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "portal.tirol.gv.at", true },
  { "posteo.de", true },
  { "powerplannerapp.com", true },
  { "prakharprasad.com", true },
  { "prefontaine.name", true },
  { "profiles.google.com", true },
  { "projektzentrisch.de", true },
  { "propagandism.org", true },
  { "prowhisky.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "pult.co", false },
  { "pypi.python.org", true },
  { "python.org", false },
  { "qetesh.de", true },
  { "quuz.org", true },
  { "rad-route.de", true },
  { "raiseyourflag.com", true },
  { "ravchat.com", true },
  { "redports.org", true },
  { "redteam-pentesting.de", true },
  { "reedloden.com", true },
  { "reishunger.de", true },
  { "reserve-online.net", true },
  { "reviews.anime.my", true },
  { "riccy.org", true },
  { "riesenmagnete.de", true },
  { "rippleunion.com", true },
  { "robteix.com", true },
  { "roddis.net", false },
  { "roland.io", true },
  { "romab.com", true },
  { "room-checkin24.de", true },
  { "rosenkeller.org", true },
  { "roundcube.mayfirst.org", false },
  { "ru-sprachstudio.ch", true },
  { "rws-vertriebsportal.de", true },
  { "s-c.se", true },
  { "sakaki.anime.my", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "salserocafe.com", true },
  { "samizdat.cz", true },
  { "sandbox.mydigipass.com", false },
  { "schachburg.de", true },
  { "schokokeks.org", false },
  { "schwarzer.it", true },
  { "sciencex.com", true },
  { "scotthelme.co.uk", true },
  { "scrambl.is", true },
  { "script.google.com", true },
  { "sdsl-speedtest.de", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "secuvera.de", true },
  { "seifried.org", true },
  { "servergno.me", true },
  { "servethecity-karlsruhe.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "sherbers.de", true },
  { "shiinko.com", true },
  { "shipard.com", true },
  { "shodan.io", true },
  { "shohruh.uz", false },
  { "shopontarget.com", true },
  { "silentcircle.com", false },
  { "simbolo.co.uk", false },
  { "simple.com", false },
  { "simpletax.ca", false },
  { "simplystudio.com", true },
  { "siraweb.org", true },
  { "siriad.com", true },
  { "sites.google.com", true },
  { "skydrive.live.com", false },
  { "slattery.co", true },
  { "slevomat.cz", true },
  { "slidebatch.com", true },
  { "smartcoin.com.br", true },
  { "smartship.co.jp", true },
  { "sour.is", true },
  { "southside-crew.com", true },
  { "spartantheatre.org", true },
  { "spencerbaer.com", true },
  { "spideroak.com", true },
  { "spreadsheets.google.com", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "squareup.com", false },
  { "sro.center", true },
  { "ssl.google-analytics.com", true },
  { "sslmate.com", true },
  { "stage.wepay.com", false },
  { "standardssuck.org", true },
  { "static.wepay.com", false },
  { "stationary-traveller.eu", true },
  { "steventress.com", true },
  { "stocktrade.de", false },
  { "stretchmyan.us", true },
  { "stripe.com", true },
  { "strongest-privacy.com", true },
  { "studydrive.net", true },
  { "subrosa.io", true },
  { "suite73.org", true },
  { "sunjaydhama.com", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "surkatty.org", true },
  { "swehack.org", true },
  { "sylaps.com", true },
  { "sysctl.se", true },
  { "syss.de", true },
  { "tageau.com", true },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "taxsquirrel.com", true },
  { "techhipster.net", true },
  { "tekshrek.com", true },
  { "tent.io", true },
  { "testsuite.org", true },
  { "texte-zur-taufe.de", true },
  { "thecustomizewindows.com", true },
  { "thepaymentscompany.com", true },
  { "therapynotes.com", false },
  { "theshadestore.com", true },
  { "thorncreek.net", false },
  { "thusoy.com", true },
  { "tickopa.co.uk", true },
  { "timtaubert.de", true },
  { "tinfoilsecurity.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tittelbach.at", true },
  { "tls.li", true },
  { "tno.io", true },
  { "tobias-kluge.de", true },
  { "tollmanz.com", true },
  { "tomfisher.eu", true },
  { "tomvote.com", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "torproject.org", false },
  { "toshnix.com", true },
  { "translate.googleapis.com", true },
  { "translatoruk.co.uk", true },
  { "trauertexte.info", true },
  { "tresorit.com", true },
  { "tribut.de", true },
  { "tunebitfm.de", true },
  { "twentymilliseconds.com", true },
  { "twitter.com", false },
  { "ub3rk1tten.com", true },
  { "ubertt.org", true },
  { "ukdefencejournal.org.uk", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "unterfrankenclan.de", true },
  { "usaa.com", false },
  { "uzstyle.com", false },
  { "vaddder.com", true },
  { "vhost.co.id", true },
  { "viasinc.com", false },
  { "viennan.net", true },
  { "vmoagents.com", false },
  { "vocaloid.my", true },
  { "vortexhobbies.com", true },
  { "vpnzoom.com", true },
  { "w-spotlight.appspot.com", true },
  { "wallet.google.com", true },
  { "warrencreative.com", false },
  { "watsonhall.uk", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webcollect.org.uk", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "weblogzwolle.nl", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "websenat.de", true },
  { "webtiles.co.uk", true },
  { "weggeweest.nl", true },
  { "welches-kinderfahrrad.de", true },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "whatwg.org", true },
  { "when-release.ru", true },
  { "wieninternational.at", true },
  { "wiki.python.org", true },
  { "wildbee.org", true },
  { "willnorris.com", true },
  { "winhistory-forum.net", true },
  { "writeapp.me", false },
  { "wubthecaptain.eu", true },
  { "wunderlist.com", true },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.braintreepayments.com", false },
  { "www.capitainetrain.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.grc.com", false },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.schokokeks.org", false },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", false },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.wepay.com", false },
  { "www.zenpayroll.com", false },
  { "xbrlsuccess.appspot.com", true },
  { "xn--maraa-rta.org", true },
  { "xps2pdf.co.uk", true },
  { "y-o-w.com", true },
  { "yoursecondphone.co", true },
  { "ypart.eu", true },
  { "z.ai", true },
  { "zenpayroll.com", false },
  { "zeplin.io", false },
  { "zeropush.com", true },
  { "zixiao.wang", true },
  { "zlavomat.sk", true },
  { "zotero.org", true },
};
