//// AUTOGENERATED FILE, DO NOT EDIT
// -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

"use strict";

do_get_profile(); // must be called before getting nsIX509CertDB
const certdb = Cc["@mozilla.org/security/x509certdb;1"]
                 .getService(Ci.nsIX509CertDB);

function cert_from_file(filename) {
  let der = readFile(do_get_file("test_cert_eku/" + filename, false));
  return certdb.constructX509(der, der.length);
}

function load_cert(cert_name, trust_string) {
  var cert_filename = cert_name + ".der";
  addCertFromFile(certdb, "test_cert_eku/" + cert_filename, trust_string);
  return cert_from_file(cert_filename);
}

function run_test() {
  load_cert("ca", "CT,CT,CT");

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_EP', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_EP_NS_OS_SA_TS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_EP_NS_OS_SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_NS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_OS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_SA', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-CA_TS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-CA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-EP', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-EP_NS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-EP_OS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-EP_SA', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-EP_TS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-EP_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-NONE', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), 0, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), 0, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), 0, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NONE.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NONE.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-NS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-NS_OS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-NS_SA', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-NS_TS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-NS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-OS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-OS_SA', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_SA.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-OS_TS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-OS_TS.der'), 0, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-OS_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-SA', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-SA_TS', ',,'), 0, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), 0, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-SA_TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);

  checkCertErrorGeneric(certdb, load_cert('int-EKU-TS', ',,'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_EP_NS_OS_SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-CA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-EP_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NONE-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-NS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-OS_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-SA_TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLClient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageSSLServer);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_KEY_USAGE, certificateUsageSSLCA);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailSigner);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageEmailRecipient);
  checkCertErrorGeneric(certdb, cert_from_file('ee-EKU-TS-int-EKU-TS.der'), SEC_ERROR_INADEQUATE_CERT_TYPE, certificateUsageStatusResponder);
}
