/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_SecureElementBinding_h
#define mozilla_dom_SecureElementBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/TypedArray.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class Promise;
class ProtoAndIfaceCache;
class SEChannel;
struct SEChannelAtoms;
struct SECommand;
struct SECommandAtoms;
class SEReader;
struct SEReaderAtoms;
class SEResponse;
struct SEResponseAtoms;
class SESession;
struct SESessionAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class SEType : uint32_t {
  Uicc,
  ESE,
  EndGuard_
};

namespace SETypeValues {
extern const EnumEntry strings[3];
} // namespace SETypeValues


enum class SEError : uint32_t {
  SESecurityError,
  SEIoError,
  SEBadStateError,
  SEInvalidChannelError,
  SEInvalidApplicationError,
  SEGenericError,
  EndGuard_
};

namespace SEErrorValues {
extern const EnumEntry strings[7];
} // namespace SEErrorValues


enum class SEChannelType : uint32_t {
  Basic,
  Logical,
  EndGuard_
};

namespace SEChannelTypeValues {
extern const EnumEntry strings[3];
} // namespace SEChannelTypeValues


struct SECommand : public DictionaryBase
{
  uint8_t mCla;
  Nullable<Sequence<uint8_t>> mData;
  uint8_t mIns;
  int16_t mLe;
  uint8_t mP1;
  uint8_t mP2;

  SECommand();

  explicit inline SECommand(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline SECommand(const SECommand& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const SECommand& aOther);

private:
  static bool
  InitIds(JSContext* cx, SECommandAtoms* atomsCache);
};

namespace binding_detail {
struct FastSECommand : public SECommand
{
  inline FastSECommand()
    : SECommand(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace SEChannelBinding {

  typedef mozilla::dom::SEChannel NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::SEChannel* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace SEChannelBinding



namespace SEReaderBinding {

  typedef mozilla::dom::SEReader NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::SEReader* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace SEReaderBinding



namespace SEResponseBinding {

  typedef mozilla::dom::SEResponse NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::SEResponse* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedDataValue(mozilla::dom::SEResponse* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace SEResponseBinding



namespace SESessionBinding {

  typedef mozilla::dom::SESession NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::SESession* aObject, nsWrapperCache* aCache, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace SESessionBinding



class SEChannelJSImpl : public CallbackInterface
{
public:
  explicit inline SEChannelJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Transmit(const SECommand& command, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const SEChannelJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<SESession> GetSession(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetOpenResponse(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetIsClosed(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  SEChannelType GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, SEChannelAtoms* atomsCache);
};


class SEChannel final : public nsSupportsWeakReference,
                        public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(SEChannel)

private:
  nsRefPtr<SEChannelJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  SEChannel(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~SEChannel();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) override;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<SESession> GetSession(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetOpenResponse(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetIsClosed(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  SEChannelType GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Transmit(const SECommand& command, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Close(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class SEReaderJSImpl : public CallbackInterface
{
public:
  explicit inline SEReaderJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> OpenSession(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CloseAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const SEReaderJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  bool GetIsSEPresent(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  SEType GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, SEReaderAtoms* atomsCache);
};


class SEReader final : public nsSupportsWeakReference,
                       public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(SEReader)

private:
  nsRefPtr<SEReaderJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  SEReader(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~SEReader();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) override;

  bool GetIsSEPresent(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  SEType GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> OpenSession(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CloseAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class SEResponseJSImpl : public CallbackInterface
{
public:
  explicit inline SEResponseJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  inline bool
  operator==(const SEResponseJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<SEChannel> GetChannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  uint8_t GetSw1(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  uint8_t GetSw2(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetData(Nullable<nsTArray<uint8_t>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, SEResponseAtoms* atomsCache);
};


class SEResponse final : public nsSupportsWeakReference,
                         public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(SEResponse)

private:
  nsRefPtr<SEResponseJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  SEResponse(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~SEResponse();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) override;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<SEChannel> GetChannel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  uint8_t GetSw1(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  uint8_t GetSw2(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetData(Nullable<nsTArray<uint8_t>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class SESessionJSImpl : public CallbackInterface
{
public:
  explicit inline SESessionJSImpl(JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> OpenLogicalChannel(const Nullable<Uint8Array>& aid, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> CloseAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const SESessionJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  already_AddRefed<SEReader> GetReader(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  bool GetIsClosed(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, SESessionAtoms* atomsCache);
};


class SESession final : public nsSupportsWeakReference,
                        public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(SESession)

private:
  nsRefPtr<SESessionJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  SESession(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~SESession();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx) override;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<SEReader> GetReader(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  bool GetIsClosed(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> OpenLogicalChannel(const Nullable<Uint8Array>& aid, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> CloseAll(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SecureElementBinding_h
