/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 *
 */

[Exposed=ServiceWorker]
interface Client {
  readonly attribute DOMString id;
  readonly attribute USVString url;

  [Throws]
  void postMessage(any message, optional sequence<Transferable> transfer);
};

[Exposed=ServiceWorker]
interface WindowClient : Client {
  readonly attribute VisibilityState visibilityState;
  readonly attribute boolean focused;
  readonly attribute FrameType frameType;
  Promise<WindowClient> focus();
};

enum FrameType {
  "auxiliary",
  "top-level",
  "nested",
  "none"
};
