/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* nsSiteSecurityService.cpp, you shouldn't be #including it.     */
/*****************************************************************************/

#include <stdint.h>
const PRTime gPreloadListExpirationTime = INT64_C(1442053319375000);

class nsSTSPreload
{
  public:
    const char *mHost;
    const bool mIncludeSubdomains;
};

static const nsSTSPreload kSTSPreloadList[] = {
  { "007sascha.de", true },
  { "0x0a.net", true },
  { "1000minds.com", true },
  { "17hats.com", true },
  { "188trafalgar.ca", true },
  { "18f.gsa.gov", true },
  { "1a-diamantscheiben.de", true },
  { "1a-jva.de", true },
  { "1a-vermessung.at", true },
  { "1a-werkstattgeraete.de", true },
  { "2048game.co.uk", true },
  { "2600hq.com", true },
  { "301.website", true },
  { "302.nyc", true },
  { "314chan.org", true },
  { "3do3dont.com", true },
  { "47ronin.com", false },
  { "4g-server.eu", true },
  { "5apps.com", false },
  { "7183.org", true },
  { "8ack.de", true },
  { "abmahnhelfer.de", true },
  { "accounts.firefox.com", true },
  { "accounts.google.com", true },
  { "aclu.org", false },
  { "activiti.alfresco.com", false },
  { "acuica.co.uk", false },
  { "acus.gov", true },
  { "adamkostecki.de", true },
  { "adamstas.com", true },
  { "addvocate.com", true },
  { "adlershop.ch", true },
  { "admin.fedoraproject.org", true },
  { "admin.google.com", true },
  { "admin.stg.fedoraproject.org", true },
  { "adorai.tk", true },
  { "adsfund.org", true },
  { "advanced-online.eu", true },
  { "aerolog.co", true },
  { "aeyoun.com", true },
  { "afp548.com", true },
  { "afrodigital.uk", true },
  { "agrimap.com", true },
  { "agrios.de", true },
  { "ahoyconference.com", true },
  { "ahwatukeefoothillsmontessori.com", true },
  { "aids.gov", true },
  { "aie.de", true },
  { "aircomms.com", true },
  { "airlea.com", true },
  { "aiticon.com", true },
  { "ajouin.com", true },
  { "akachanikuji.com", true },
  { "akselinurmio.fi", true },
  { "al-shami.net", true },
  { "aladdinschools.appspot.com", true },
  { "alainwolf.net", true },
  { "alanrickmanflipstable.com", true },
  { "alecvannoten.be", true },
  { "alexgaynor.net", true },
  { "alexsexton.com", true },
  { "alexyang.me", true },
  { "allinonecyprus.com", true },
  { "alpha.irccloud.com", false },
  { "alza.cz", true },
  { "alza.de", true },
  { "alza.sk", true },
  { "alzashop.com", true },
  { "amaforums.org", false },
  { "amdouglas.uk", true },
  { "anadoluefessk.org", true },
  { "anadoluefessporkulubu.org", true },
  { "andere-gedanken.net", true },
  { "andreasbreitenlohner.de", true },
  { "andymartin.cc", true },
  { "anetaben.nl", true },
  { "angularjs.org", true },
  { "anime.my", false },
  { "animurecs.com", true },
  { "ankakaak.com", true },
  { "ankarakart.com.tr", true },
  { "annahmeschluss.de", true },
  { "annevankesteren.com", true },
  { "annevankesteren.nl", true },
  { "annevankesteren.org", true },
  { "anonym-surfen.de", true },
  { "ansdell.net", true },
  { "antipolygraph.org", true },
  { "anycoin.me", true },
  { "apadvantage.com", true },
  { "api.intercom.io", false },
  { "api.lookout.com", false },
  { "api.simple.com", false },
  { "api.xero.com", false },
  { "apis.google.com", true },
  { "apn-einstellungen.de", true },
  { "app.lookout.com", false },
  { "app.manilla.com", true },
  { "app.recurly.com", true },
  { "app.simpletax.ca", false },
  { "app.yinxiang.com", false },
  { "appengine.google.com", true },
  { "apple-watch-zubehoer.de", true },
  { "apps-for-fishing.com", true },
  { "apps.facebook.com", false },
  { "apps.fedoraproject.org", true },
  { "apps.stg.fedoraproject.org", true },
  { "aprz.de", true },
  { "arbitrary.ch", true },
  { "archlinux.de", true },
  { "areafiftylan.nl", true },
  { "arendburgers.nl", true },
  { "arguggi.co.uk", true },
  { "arivo.com.br", true },
  { "arlen.io", true },
  { "armytricka.cz", true },
  { "aroonchande.com", true },
  { "arteseideias.com.pt", true },
  { "arty.name", true },
  { "ask.fedoraproject.org", true },
  { "ask.stg.fedoraproject.org", true },
  { "atc.io", true },
  { "athenelive.com", true },
  { "atishchenko.com", true },
  { "atlantischild.hu", true },
  { "atlassian.net", true },
  { "atte.fi", true },
  { "auf-feindgebiet.de", true },
  { "aurainfosec.com", true },
  { "aurainfosec.com.au", true },
  { "auraredeye.com", true },
  { "auraredshield.com", true },
  { "authentication.io", true },
  { "autoledky.sk", true },
  { "axka.com", false },
  { "badges.fedoraproject.org", true },
  { "badges.stg.fedoraproject.org", true },
  { "baer.im", true },
  { "baff.lu", true },
  { "bagelsbakery.com", true },
  { "balcan-underground.net", true },
  { "balikonos.cz", true },
  { "bank.simple.com", false },
  { "barslecht.com", true },
  { "barslecht.nl", true },
  { "baruch.me", true },
  { "bassh.net", true },
  { "bautied.de", true },
  { "bayrisch-fuer-anfaenger.de", true },
  { "bccx.com", true },
  { "bcrook.com", false },
  { "beamitapp.com", true },
  { "beastowner.com", true },
  { "beastowner.li", true },
  { "bedeta.de", true },
  { "bedreid.dk", true },
  { "beercandle.com", true },
  { "ben-energy.com", true },
  { "benchling.com", true },
  { "beneathvt.com", true },
  { "benjamin.pe", true },
  { "benjamins.com", true },
  { "bentertain.de", true },
  { "best-wedding-quotes.com", true },
  { "bfelob.gov", true },
  { "bgneuesheim.de", true },
  { "bhatia.at", true },
  { "biathloncup.ru", true },
  { "big-andy.co.uk", true },
  { "bigbrownpromotions.com.au", true },
  { "billigssl.dk", true },
  { "bit-sentinel.com", true },
  { "bit.voyage", true },
  { "bitbucket.org", false },
  { "bitchan.it", true },
  { "bitcoin.de", true },
  { "bitcoinx.ro", true },
  { "bitfactory.ws", true },
  { "bitmex.com", true },
  { "bitmon.net", true },
  { "bitnet.io", true },
  { "bitpod.de", true },
  { "bjornjohansen.no", true },
  { "bl4ckb0x.com", true },
  { "bl4ckb0x.de", true },
  { "bl4ckb0x.info", true },
  { "bl4ckb0x.net", true },
  { "bl4ckb0x.org", true },
  { "blablacar.co.uk", true },
  { "blablacar.com", true },
  { "blablacar.com.tr", true },
  { "blablacar.com.ua", true },
  { "blablacar.de", true },
  { "blablacar.es", true },
  { "blablacar.fr", true },
  { "blablacar.hr", true },
  { "blablacar.hu", true },
  { "blablacar.in", true },
  { "blablacar.it", true },
  { "blablacar.mx", true },
  { "blablacar.nl", true },
  { "blablacar.pl", true },
  { "blablacar.pt", true },
  { "blablacar.ro", true },
  { "blablacar.rs", true },
  { "blablacar.ru", true },
  { "blackberrycentral.com", true },
  { "blessnet.jp", true },
  { "blockchain.info", true },
  { "blocksatz-medien.de", true },
  { "bloemendal.me", true },
  { "blog.cyveillance.com", true },
  { "blog.gparent.org", true },
  { "blog.linode.com", false },
  { "blog.torproject.org", false },
  { "blubbablasen.de", true },
  { "bodo-wolff.de", true },
  { "bohramt.de", true },
  { "boiseonlinemall.com", true },
  { "bonigo.de", true },
  { "bonitabrazilian.co.nz", true },
  { "bookingapp.nl", true },
  { "boxcryptor.com", true },
  { "boypoint.de", true },
  { "bradkovach.com", true },
  { "brage.info", false },
  { "braintreegateway.com", true },
  { "brakemanpro.com", true },
  { "bran.cc", true },
  { "brandbuilderwebsites.com", true },
  { "breeswish.org", true },
  { "broeselei.at", true },
  { "brossmanit.com", true },
  { "brunosouza.org", true },
  { "buddhistische-weisheiten.org", true },
  { "bugzil.la", true },
  { "bugzilla.mozilla.org", true },
  { "buiko.com", true },
  { "buildkite.com", true },
  { "bulktrade.de", true },
  { "bundaberg.com", true },
  { "burtrum.org", true },
  { "business.facebook.com", false },
  { "business.lookout.com", false },
  { "bustimes.org", true },
  { "buzzconcert.com", true },
  { "bytepark.de", false },
  { "bzv-fr.eu", true },
  { "ca.gparent.org", true },
  { "cackette.com", true },
  { "call.me", true },
  { "calomel.org", true },
  { "calories.org", true },
  { "calvin.me", true },
  { "camolist.com", true },
  { "canhazip.com", true },
  { "cao.gov", true },
  { "capitaltg.com", true },
  { "caremad.io", true },
  { "carezone.com", false },
  { "cartouche24.eu", true },
  { "cartucce24.it", true },
  { "casa-su.casa", true },
  { "cbhq.net", true },
  { "cdlcenter.com", true },
  { "cdnb.co", true },
  { "cdt.org", true },
  { "certible.com", true },
  { "certly.io", true },
  { "cfo.gov", true },
  { "chahub.com", true },
  { "chainmonitor.com", true },
  { "chartstoffarm.de", false },
  { "chatbot.me", true },
  { "check.torproject.org", false },
  { "checkout.google.com", true },
  { "cheesetart.my", true },
  { "chrisirwin.ca", true },
  { "chrisjean.com", true },
  { "chrome-devtools-frontend.appspot.com", true },
  { "chrome.com", false },
  { "chrome.google.com", true },
  { "chromiumcodereview.appspot.com", false },
  { "chulado.com", true },
  { "cio.gov", true },
  { "cklie.de", true },
  { "ckliemann.com", true },
  { "ckliemann.net", true },
  { "cktennis.com", true },
  { "clan-ww.com", true },
  { "clapping-rhymes.com", true },
  { "classdojo.com", true },
  { "clerkendweller.uk", true },
  { "climateinteractive.org", true },
  { "clintwilson.technology", true },
  { "cloud.google.com", true },
  { "cloudcert.org", true },
  { "cloudns.com.au", true },
  { "cloudsecurityalliance.org", true },
  { "cloudstoragemaus.com", true },
  { "cloudup.com", true },
  { "code-poets.co.uk", true },
  { "code.facebook.com", false },
  { "code.google.com", true },
  { "codepoints.net", true },
  { "codepref.com", true },
  { "codepx.com", true },
  { "codereview.appspot.com", false },
  { "codereview.chromium.org", true },
  { "coinapult.com", true },
  { "coinbase.com", true },
  { "collinmbarrett.com", true },
  { "coloradocomputernetworking.net", true },
  { "comdurav.com", true },
  { "commencepayments.com", true },
  { "comssa.org.au", true },
  { "config.schokokeks.org", false },
  { "conformal.com", true },
  { "conrad-kostecki.de", true },
  { "console.support", true },
  { "consumersentinel.gov", true },
  { "controlcenter.gigahost.dk", true },
  { "copperhead.co", true },
  { "cor-ser.es", true },
  { "cordial-restaurant.com", true },
  { "costablancavoorjou.com", true },
  { "cotonea.de", true },
  { "courtlistener.com", true },
  { "covenantoftheriver.org", true },
  { "covoiturage.fr", true },
  { "cracker.in.th", true },
  { "crm.onlime.ch", false },
  { "crowdjuris.com", true },
  { "crute.me", true },
  { "crypto.cat", false },
  { "crypto.graphics", true },
  { "cryptobin.org", true },
  { "cryptography.io", true },
  { "cryptopartyatx.org", true },
  { "cryptopush.com", true },
  { "csacongress.org", true },
  { "cspbuilder.info", true },
  { "csuw.net", true },
  { "cube.de", true },
  { "cupcake.io", true },
  { "cupcake.is", true },
  { "curiosity-driven.org", true },
  { "curlybracket.co.uk", true },
  { "curtacircuitos.com.br", false },
  { "cyanogenmod.xxx", true },
  { "cybershambles.com", true },
  { "cybozu.com", true },
  { "cybozulive.com", true },
  { "cycleluxembourg.lu", true },
  { "cyon.ch", true },
  { "cyphertite.com", true },
  { "cyprus-company-service.com", true },
  { "czakey.net", true },
  { "czbix.com", true },
  { "czk.mk", true },
  { "danielalvarez.net", true },
  { "danonsecurity.com", true },
  { "danskoferie.dk", true },
  { "danw.io", true },
  { "daphne.informatik.uni-freiburg.de", true },
  { "darchoods.net", false },
  { "darknode.in", true },
  { "darkpony.ru", true },
  { "darkserver.fedoraproject.org", true },
  { "darkserver.stg.fedoraproject.org", true },
  { "darlo.co.uk", true },
  { "darom.jp", true },
  { "dash-board.jp", false },
  { "data-abundance.com", true },
  { "data.qld.gov.au", false },
  { "datasnitch.co.uk", true },
  { "datenkeks.de", true },
  { "daveoc64.co.uk", true },
  { "davidlyness.com", true },
  { "davidmcevoy.org.uk", true },
  { "davidnoren.com", true },
  { "daylightpirates.org", true },
  { "dccode.gov", true },
  { "deadbeef.ninja", true },
  { "dealcruiser.nl", true },
  { "debtkit.co.uk", true },
  { "dedimax.de", true },
  { "dee.pe", true },
  { "defcon.org", true },
  { "dekasan.ru", true },
  { "deliverance.co.uk", true },
  { "denh.am", true },
  { "depechemode-live.com", true },
  { "derevtsov.com", false },
  { "derhil.de", true },
  { "detectify.com", false },
  { "developer.mydigipass.com", false },
  { "developers.facebook.com", false },
  { "devinfo.net", false },
  { "diamante.ro", true },
  { "die-besten-weisheiten.de", true },
  { "digital1st.co.uk", true },
  { "dillonkorman.com", true },
  { "dinamoelektrik.com", true },
  { "disking.co.uk", true },
  { "dist.torproject.org", false },
  { "dixmag.com", false },
  { "dl.google.com", true },
  { "dlc.viasinc.com", true },
  { "dm.lookout.com", false },
  { "dm.mylookout.com", false },
  { "dn42.us", true },
  { "dnsman.se", true },
  { "doc.python.org", true },
  { "docs.google.com", true },
  { "docs.python.org", true },
  { "dohosting.ru", true },
  { "domainkauf.de", true },
  { "domains.google.com", true },
  { "donmez.uk", true },
  { "donmez.ws", true },
  { "donotcall.gov", true },
  { "doridian.com", true },
  { "doridian.de", true },
  { "doridian.net", true },
  { "doridian.org", true },
  { "dpsg-roden.de", true },
  { "dragons-of-highlands.cz", true },
  { "dreadbyte.com", true },
  { "dreamsforabetterworld.com.au", true },
  { "drive.google.com", true },
  { "dropbox.com", true },
  { "drtroyhendrickson.com", true },
  { "dubrovskiy.net", true },
  { "ducohosting.com", true },
  { "dyeager.org", true },
  { "dylanscott.com.au", true },
  { "dynaloop.net", true },
  { "dzlibs.io", true },
  { "e-kontakti.fi", true },
  { "e.mail.ru", true },
  { "earmarks.gov", true },
  { "easysimplecrm.com", false },
  { "eatsleeprepeat.net", true },
  { "ebanking.indovinabank.com.vn", true },
  { "ecake.in", true },
  { "ecdn.cz", true },
  { "ecfs.link", true },
  { "ecg.fr", false },
  { "ecosystem.atlassian.net", true },
  { "ectora.com", true },
  { "ed.gs", true },
  { "edelsteincosmetic.com", true },
  { "edge-cloud.net", true },
  { "edit.yahoo.com", false },
  { "edix.ru", true },
  { "eduroam.no", true },
  { "edyou.eu", true },
  { "ef.gy", true },
  { "eff.org", true },
  { "egfl.org.uk", true },
  { "egit.co", true },
  { "ego4u.com", true },
  { "ego4u.de", true },
  { "eksisozluk.com", true },
  { "electronic-ignition-system.com", true },
  { "ellegaard.dk", true },
  { "elliquiy.com", true },
  { "emailprivacytester.com", true },
  { "emptypath.com", true },
  { "encircleapp.com", true },
  { "encryptallthethings.net", true },
  { "encrypted.google.com", true },
  { "energy-drink-magazin.de", true },
  { "enigmail.net", true },
  { "enorekcah.com", true },
  { "enskat.de", true },
  { "enskatson-sippe.de", true },
  { "entropia.de", false },
  { "eromixx.com", true },
  { "erotische-aanbiedingen.nl", true },
  { "errors.zenpayroll.com", false },
  { "eru.me", true },
  { "esoa.net", true },
  { "espra.com", true },
  { "ethack.org", true },
  { "ethercalc.com", true },
  { "ethercalc.org", true },
  { "ethitter.com", true },
  { "etoprekrasno.ru", true },
  { "eurotramp.com", true },
  { "eva.cz", true },
  { "evalesc.com", true },
  { "everhome.de", true },
  { "eveshamglass.co.uk", true },
  { "evstatus.com", true },
  { "exiahost.com", false },
  { "exon.io", true },
  { "expatads.com", true },
  { "explodie.org", true },
  { "extendwings.com", true },
  { "ezequiel-garzon.com", true },
  { "ezequiel-garzon.net", true },
  { "f-droid.org", true },
  { "fa-works.com", true },
  { "fabhub.io", true },
  { "facebook.com", false },
  { "factor.cc", false },
  { "fairbill.com", true },
  { "fakturoid.cz", true },
  { "fant.dk", true },
  { "faq.lookout.com", false },
  { "fassadenverkleidung24.de", true },
  { "fastcomcorp.net", true },
  { "faucetbox.com", true },
  { "federalregister.gov", true },
  { "fedorahosted.org", true },
  { "fedorapeople.org", true },
  { "feedbin.com", false },
  { "feedthebot.com", true },
  { "feminists.co", true },
  { "ferienhaus-polchow-ruegen.de", false },
  { "festember.com", true },
  { "fewo-thueringer-wald.de", true },
  { "fidelapp.com", true },
  { "fiken.no", true },
  { "filedir.com", false },
  { "filip-prochazka.com", true },
  { "finn.io", true },
  { "firebaseio-demo.com", true },
  { "firebaseio.com", true },
  { "firebirdrangecookers.com", true },
  { "firefart.at", true },
  { "firemail.io", true },
  { "firma-offshore.com", true },
  { "firstlook.org", true },
  { "fischer-its.com", true },
  { "fish-hook.ru", true },
  { "fitkram.cz", true },
  { "fj.simple.com", false },
  { "flagspot.net", true },
  { "flamer-scene.com", true },
  { "fleximus.org", false },
  { "floobits.com", true },
  { "florian-lillpopp.de", true },
  { "florianlillpopp.de", true },
  { "florianmitrea.uk", true },
  { "floweslawncare.com", true },
  { "fluxfingers.net", true },
  { "flynn.io", true },
  { "fniephaus.com", true },
  { "food4health.guide", true },
  { "forewordreviews.com", true },
  { "forgix.com", true },
  { "forodeespanol.com", true },
  { "forum.linode.com", false },
  { "forum.quantifiedself.com", true },
  { "foxelbox.com", true },
  { "fralef.me", false },
  { "frederik-braun.com", true },
  { "freenetproject.org", true },
  { "freeshell.de", true },
  { "freesounding.com", true },
  { "freesounding.ru", true },
  { "freethought.org.au", true },
  { "froggstack.de", true },
  { "fronteers.nl", true },
  { "ftccomplaintassistant.gov", true },
  { "fundingempire.com", true },
  { "futos.de", true },
  { "fuzzing-project.org", true },
  { "fx5.de", true },
  { "gallery44.org", true },
  { "gambit.pro", true },
  { "gambitnash.co.uk", true },
  { "gambitnash.com", true },
  { "gamercredo.com", true },
  { "gameserver-sponsor.de", true },
  { "garron.net", true },
  { "gavick.com", true },
  { "gaytorrent.ru", true },
  { "gc.net", true },
  { "ge3k.net", true },
  { "gemeinfreie-lieder.de", true },
  { "genuxtsg.com", true },
  { "geoip.fedoraproject.org", true },
  { "geoip.stg.fedoraproject.org", true },
  { "gerardozamudio.mx", true },
  { "gernert-server.de", true },
  { "get.zenpayroll.com", false },
  { "getable.com", true },
  { "getbambu.com", false },
  { "getcloak.com", false },
  { "getcolor.com", true },
  { "getdigitized.net", true },
  { "getfedora.org", true },
  { "getfittedstore.com", true },
  { "getmango.com", true },
  { "getsello.com", true },
  { "getssl.uz", true },
  { "gheorghesarcov.ga", true },
  { "giacomopelagatti.it", true },
  { "github.com", true },
  { "gizzo.sk", true },
  { "glass.google.com", true },
  { "globalittech.com", false },
  { "globuli-info.de", true },
  { "glossopnorthendafc.co.uk", true },
  { "gmail.com", false },
  { "gmantra.org", true },
  { "gmcd.co", true },
  { "gnetwork.eu", true },
  { "go.xero.com", false },
  { "gocardless.com", true },
  { "gokmenguresci.com", true },
  { "goldendata.io", true },
  { "golfscape.com", false },
  { "googlemail.com", false },
  { "googleplex.com", true },
  { "gothamlimo.com", true },
  { "goto.google.com", true },
  { "gotowned.org", true },
  { "gotspot.com", true },
  { "gplintegratedit.com", true },
  { "gpsfix.cz", true },
  { "gra2.com", true },
  { "grandcapital.id", true },
  { "grandcapital.ru", true },
  { "grc.com", false },
  { "greensolid.biz", true },
  { "gregorytlee.me", true },
  { "grepular.com", true },
  { "grocock.me.uk", true },
  { "groetzner.net", true },
  { "groszek.pl", true },
  { "groups.google.com", true },
  { "gtraxapp.com", true },
  { "gudini.net", true },
  { "gugga.dk", false },
  { "gunnarhafdal.com", true },
  { "guphi.net", true },
  { "guru-naradi.cz", true },
  { "gurusupe.com", true },
  { "guthabenkarten-billiger.de", true },
  { "gw2treasures.com", true },
  { "haber1903.com", true },
  { "hachre.de", false },
  { "hack.li", true },
  { "hackerone.com", true },
  { "hangouts.google.com", true },
  { "hansvaneijsden.com", true },
  { "happylifestyle.com", true },
  { "harvestapp.com", true },
  { "hash-list.com", true },
  { "hasilocke.de", true },
  { "haste.ch", true },
  { "haufschild.de", true },
  { "hausverbrauch.de", true },
  { "hboeck.de", true },
  { "hda.me", true },
  { "healthcare.gov", false },
  { "heartlandrentals.com", true },
  { "heavystresser.com", true },
  { "heha.co", false },
  { "heid.ws", true },
  { "heijblok.com", true },
  { "helichat.de", true },
  { "help.simpletax.ca", false },
  { "helpadmin.net", true },
  { "helpium.de", true },
  { "hemlockhillscabinrentals.com", true },
  { "henriknoerr.com", true },
  { "heppler.net", true },
  { "herbert.io", true },
  { "herocentral.de", true },
  { "heute-kaufen.de", true },
  { "hex2013.com", true },
  { "hexony.com", true },
  { "hg.python.org", true },
  { "hicn.gq", true },
  { "hicoria.com", true },
  { "history.google.com", true },
  { "hledejpravnika.cz", true },
  { "hobbyspeed.com", true },
  { "holymoly.lu", true },
  { "honeybadger.io", false },
  { "horza.org", true },
  { "hostedtalkgadget.google.com", true },
  { "hostinginnederland.nl", true },
  { "hostix.de", true },
  { "howrandom.org", true },
  { "howsmyssl.com", true },
  { "howsmytls.com", true },
  { "hozana.si", true },
  { "hpac-portal.com", true },
  { "hrackydomino.cz", true },
  { "hsmr.cc", true },
  { "hsr.gov", true },
  { "hstsfail.appspot.com", true },
  { "html5.org", true },
  { "httpswatch.com", true },
  { "hushfile.it", true },
  { "i10z.com", true },
  { "i5y.co.uk", true },
  { "iamcarrico.com", true },
  { "ian.sh", true },
  { "iban.is", true },
  { "id-co.in", true },
  { "id-conf.com", true },
  { "id.atlassian.com", true },
  { "id.mayfirst.org", false },
  { "ideaweb.de", true },
  { "ieval.ro", true },
  { "ihrlotto.de", true },
  { "ijohan.nl", true },
  { "ikkatsu-satei.jp", true },
  { "ilbuongiorno.it", true },
  { "ilikerainbows.co", true },
  { "ilikerainbows.co.uk", false },
  { "imaginary.ca", true },
  { "imagr.io", true },
  { "imgg.es", true },
  { "imouto.my", false },
  { "in.xero.com", false },
  { "inb4.us", true },
  { "inbox.google.com", true },
  { "indiecert.net", true },
  { "indovinabank.com.vn", true },
  { "influxus.com", true },
  { "infogrfx.com", true },
  { "iniiter.com", true },
  { "initrd.net", true },
  { "inkbunny.net", true },
  { "inleaked.com", true },
  { "innophate-security.com", true },
  { "innophate-security.nl", true },
  { "insighti.org", true },
  { "insouciant.org", true },
  { "instasex.ch", true },
  { "integromat.com", true },
  { "interasistmen.se", true },
  { "iostips.ru", true },
  { "ipmimagazine.com", true },
  { "ipomue.com", false },
  { "ipsec.pl", true },
  { "iranianlawschool.com", true },
  { "iridiumbrowser.de", true },
  { "irische-segenswuensche.info", true },
  { "irmag.ru", true },
  { "ironfistdesign.com", true },
  { "isitchristmas.com", true },
  { "isogram.nl", false },
  { "it-schwerin.de", true },
  { "itdashboard.gov", true },
  { "itriskltd.com", true },
  { "itsamurai.ru", true },
  { "itshost.ru", true },
  { "izdiwho.com", true },
  { "j-lsolutions.com", true },
  { "jackyyf.com", false },
  { "jacobparry.ca", true },
  { "jacuzziprozone.com", true },
  { "jahliveradio.com", false },
  { "jakub-boucek.cz", true },
  { "janoberst.com", true },
  { "janus-engineering.de", true },
  { "jbn.mx", true },
  { "jelmer.co.uk", true },
  { "jelmer.uk", true },
  { "jeremyness.com", true },
  { "jetaprices.com", true },
  { "jettshome.org", true },
  { "jfreitag.de", true },
  { "jh-media.eu", true },
  { "jimshaver.net", true },
  { "jira.com", true },
  { "jitsi.org", false },
  { "jkb.pics", true },
  { "jkbuster.com", true },
  { "jmdekker.it", true },
  { "jmedved.com", true },
  { "johannes.io", true },
  { "johners.me", true },
  { "johnmichel.org", true },
  { "jonas-keidel.de", true },
  { "jonaswitmer.ch", true },
  { "jonathan.ir", true },
  { "jondevin.com", true },
  { "jonnybarnes.uk", true },
  { "jonpads.com", true },
  { "jpbike.cz", true },
  { "jrc9.ca", true },
  { "julianmeyer.de", true },
  { "jwilsson.com", true },
  { "jwilsson.me", true },
  { "jwnotifier.org", true },
  { "k-dev.de", true },
  { "kaheim.de", true },
  { "kalmar.com", true },
  { "kaneo-gmbh.de", true },
  { "kanzashi.com", true },
  { "karaoketonight.com", true },
  { "kardize24.pl", true },
  { "karmaspa.se", true },
  { "kartonmodellbau.org", true },
  { "kaufberatung.community", true },
  { "kavovary-kava.cz", true },
  { "kdex.de", true },
  { "kdyby.org", true },
  { "kedarastudios.com", true },
  { "keeleysam.com", true },
  { "keeleysam.me", true },
  { "keepa.com", true },
  { "keepclean.me", true },
  { "keeperapp.com", true },
  { "keepersecurity.com", true },
  { "kernel-error.de", true },
  { "kevincox.ca", true },
  { "keybase.io", true },
  { "keycdn.com", true },
  { "keycom.co.uk", true },
  { "keyerror.com", true },
  { "khanovaskola.cz", true },
  { "khipu.com", true },
  { "khmath.com", true },
  { "ki-on.net", true },
  { "kinderbuecher-kostenlos.de", true },
  { "kinganywhere.eu", true },
  { "kingmanhall.org", true },
  { "kinogb.net", false },
  { "kinsights.com", false },
  { "kintone.com", true },
  { "kirei.se", true },
  { "kissflow.com", true },
  { "kitsta.com", true },
  { "klarmobil-empfehlen.de", true },
  { "klatschreime.de", true },
  { "klausbrinch.dk", true },
  { "klaxn.com", true },
  { "kleidertauschpartys.de", true },
  { "kliemann.me", true },
  { "klingeletest.de", true },
  { "knip.ch", true },
  { "knowledgehook.com", true },
  { "koen.io", true },
  { "koenrouwhorst.nl", true },
  { "koenvdheuvel.me", true },
  { "kojipkgs.fedoraproject.org", true },
  { "kollawat.me", true },
  { "komandakovalchuk.com", false },
  { "konklone.com", true },
  { "koop-bremen.de", true },
  { "koordinate.net", true },
  { "kosho.org", true },
  { "kpebetka.net", true },
  { "kraken.io", true },
  { "kredite24.de", true },
  { "ks-watch.de", true },
  { "kuppingercole.com", true },
  { "kupschke.net", true },
  { "kura.io", true },
  { "labaia.info", true },
  { "laf.in.net", true },
  { "lagerauftrag.info", true },
  { "lancejames.com", true },
  { "lapetition.be", true },
  { "lasst-uns-beten.de", true },
  { "lastpass.com", false },
  { "laukstein.com", true },
  { "launchkey.com", true },
  { "lavalite.de", true },
  { "lavval.com", true },
  { "lb-toner.de", true },
  { "leadbook.ru", true },
  { "leakedminecraft.net", true },
  { "leanclub.org", true },
  { "ledgerscope.net", false },
  { "ledhouse.sk", true },
  { "leibniz-remscheid.de", true },
  { "leifdreizler.com", true },
  { "lence.net", true },
  { "leonardcamacho.me", true },
  { "leonax.net", true },
  { "leonklingele.de", true },
  { "les-corsaires.net", true },
  { "libraryfreedomproject.org", true },
  { "lichtspot.de", true },
  { "liebel.org", true },
  { "light.mail.ru", true },
  { "lighting-centres.co.uk", true },
  { "lillpopp.eu", true },
  { "lilpwny.com", true },
  { "limpid.nl", true },
  { "lingolia.com", true },
  { "linode.com", false },
  { "linorman1997.me", true },
  { "linux-admin-california.com", true },
  { "linx.li", true },
  { "linx.net", true },
  { "lists.mayfirst.org", false },
  { "lists.stg.fedoraproject.org", true },
  { "livej.am", true },
  { "livekaarten.nl", true },
  { "ljs.io", true },
  { "lmmtfy.io", true },
  { "lnx.li", true },
  { "lobste.rs", true },
  { "lockify.com", true },
  { "lodash.com", true },
  { "loenshotel.de", true },
  { "loftboard.eu", true },
  { "logentries.com", false },
  { "login.corp.google.com", true },
  { "login.launchpad.net", true },
  { "login.persona.org", true },
  { "login.sapo.pt", true },
  { "login.ubuntu.com", true },
  { "login.xero.com", false },
  { "login.yahoo.com", false },
  { "lolicore.ch", true },
  { "lookout.com", false },
  { "lookyman.net", true },
  { "lore.azurewebsites.net", true },
  { "ludwig.im", true },
  { "luelistan.net", true },
  { "lumi.do", false },
  { "luneta.nearbuysystems.com", false },
  { "m.facebook.com", false },
  { "m.mail.ru", true },
  { "m0wef.uk", true },
  { "maartenvandekamp.nl", true },
  { "mach-politik.ch", true },
  { "madars.org", true },
  { "madeitwor.se", true },
  { "mafamane.com", true },
  { "maff.scot", false },
  { "magneticanvil.com", true },
  { "mahamed91.pw", true },
  { "mail.de", true },
  { "mail.google.com", true },
  { "mail.yahoo.com", false },
  { "mailbox.org", true },
  { "mailmag.net", true },
  { "makeitdynamic.com", true },
  { "makeyourlaws.org", true },
  { "mall.cz", true },
  { "mall.hu", true },
  { "mall.pl", true },
  { "mall.sk", true },
  { "malnex.de", true },
  { "malwre.io", true },
  { "man3s.jp", true },
  { "manage.zenpayroll.com", false },
  { "manageprojects.com", true },
  { "manager.linode.com", false },
  { "mandala-ausmalbilder.de", true },
  { "manicode.com", true },
  { "markayapilandirma.com", true },
  { "market.android.com", true },
  { "markhaehnel.de", true },
  { "markusueberallassetmanagement.de", true },
  { "marshut.net", true },
  { "massivum.de", false },
  { "masters.black", true },
  { "matatall.com", true },
  { "mathiasbynens.be", true },
  { "matteomarescotti.it", true },
  { "mattfin.ch", true },
  { "mattmccutchen.net", true },
  { "mattsvensson.com", true },
  { "max.gov", true },
  { "mbasic.facebook.com", false },
  { "mbp.banking.co.at", false },
  { "mcard.vn", true },
  { "mccrypto.de", true },
  { "mcnext.net", true },
  { "md5file.com", true },
  { "mdfnet.se", true },
  { "meamod.com", true },
  { "medallia.io", true },
  { "mediacru.sh", true },
  { "medium.com", true },
  { "medovea.ru", true },
  { "meetfinch.com", true },
  { "mega.co.nz", false },
  { "megaplan.cz", true },
  { "megaplan.ru", true },
  { "mehmetince.net", true },
  { "meinebo.it", true },
  { "members.mayfirst.org", false },
  { "members.nearlyfreespeech.net", false },
  { "mercuryamericas.com", true },
  { "metrobriefs.com", true },
  { "mevs.cz", true },
  { "mh-bloemen.co.jp", true },
  { "miasarafina.de", true },
  { "michalspacek.cz", true },
  { "miconcinemas.com", true },
  { "mig5.net", true },
  { "mijn-email.org", true },
  { "mike-bland.com", true },
  { "miketabor.com", true },
  { "mikewest.org", true },
  { "miku.hatsune.my", false },
  { "mimeit.de", true },
  { "mimovrste.com", true },
  { "mindcoding.ro", true },
  { "mindoktor.se", true },
  { "minecraftvoter.com", true },
  { "mineover.es", true },
  { "minez-nightswatch.com", true },
  { "minikneet.com", true },
  { "minnesotadata.com", true },
  { "minora.io", true },
  { "mironet.cz", true },
  { "mirrorx.com", true },
  { "miskatonic.org", true },
  { "miss-inventory.co.uk", true },
  { "mister.hosting", true },
  { "mitell.jp", false },
  { "mittenhacks.com", true },
  { "mkcert.org", true },
  { "mkw.st", true },
  { "mnsure.org", true },
  { "mobilcom-debitel-empfehlen.de", true },
  { "mobile.usaa.com", false },
  { "mobilux.lv", true },
  { "mokote.com", true },
  { "mondwandler.de", true },
  { "morethanadream.lv", true },
  { "moriz.de", true },
  { "mothereff.in", true },
  { "mountainmusicpromotions.com", true },
  { "mountainroseherbs.com", true },
  { "movlib.org", true },
  { "mpreserver.com", true },
  { "mqas.net", true },
  { "mr-hosting.com", true },
  { "msa-aesch.ch", true },
  { "msc-seereisen.net", true },
  { "mtau.com", true },
  { "mths.be", true },
  { "mtouch.facebook.com", false },
  { "mudcrab.us", true },
  { "mujadin.se", true },
  { "munich-rage.de", true },
  { "munki.org", true },
  { "munuc.org", true },
  { "musi.cx", true },
  { "musicgamegalaxy.de", true },
  { "musmann.io", true },
  { "mustika.cf", true },
  { "mutamatic.com", true },
  { "mutantmonkey.in", true },
  { "mutantmonkey.info", true },
  { "mutantmonkey.sexy", true },
  { "mvno.io", true },
  { "mvsecurity.nl", true },
  { "mwe.st", true },
  { "my.onlime.ch", false },
  { "my.xero.com", false },
  { "mygadgetguardian.lookout.com", false },
  { "mykontool.de", true },
  { "mylookout.com", false },
  { "myni.io", true },
  { "mynigma.org", true },
  { "myplaceonline.com", true },
  { "myprintcard.de", true },
  { "myvirtualserver.com", true },
  { "nachsendeauftrag.net", true },
  { "nachsenden.info", true },
  { "nameid.org", true },
  { "namepros.com", true },
  { "nan.zone", true },
  { "nanderson.me", true },
  { "narodniki.com", true },
  { "nationalpriorities.org", true },
  { "nayahe.ru", true },
  { "nbl.org.tw", true },
  { "nctx.co.uk", true },
  { "nectarleaf.com", true },
  { "neg9.org", false },
  { "neilwynne.com", false },
  { "neko.li", true },
  { "nemovement.org", true },
  { "nerven.se", true },
  { "net-safe.info", true },
  { "netbox.cc", true },
  { "netera.se", true },
  { "netrider.net.au", true },
  { "netzbit.de", true },
  { "newstarnootropics.com", true },
  { "ng-security.com", true },
  { "nginxnudes.com", true },
  { "nicolaw.uk", true },
  { "nieselregen.com", true },
  { "niloxy.com", true },
  { "nmctest.net", true },
  { "nodari.com.ar", true },
  { "noemax.com", true },
  { "noob-box.net", true },
  { "noobs-r-us.co.uk", true },
  { "nopex.no", true },
  { "northernmuscle.ca", true },
  { "nos-oignons.net", true },
  { "nostraforma.com", false },
  { "notalone.gov", true },
  { "nouvelle-vague-saint-cast.fr", true },
  { "novacoast.com", true },
  { "nowhere.dk", true },
  { "npw.net", true },
  { "nsboutique.com", true },
  { "nu3.at", true },
  { "nu3.ch", true },
  { "nu3.co.uk", true },
  { "nu3.com", true },
  { "nu3.de", true },
  { "nu3.dk", true },
  { "nu3.fi", true },
  { "nu3.fr", true },
  { "nu3.no", true },
  { "nu3.se", true },
  { "null-sec.ru", true },
  { "nutsandboltsmedia.com", true },
  { "nuvini.com", true },
  { "nwa.xyz", true },
  { "nwgh.org", true },
  { "nymphetomania.net", true },
  { "oakslighting.co.uk", true },
  { "offshore-firma.org", true },
  { "ohling.org", true },
  { "ohnemusik.com", true },
  { "okmx.de", true },
  { "olivierlemoal.fr", true },
  { "omitech.co.uk", true },
  { "onedot.nl", true },
  { "onedrive.com", true },
  { "onedrive.live.com", false },
  { "onsitemassageco.com", true },
  { "ooonja.de", true },
  { "openacademies.com", true },
  { "oplop.appspot.com", true },
  { "opsmate.com", false },
  { "optimus.io", true },
  { "orbograph-hrcm.com", true },
  { "orcahq.com", true },
  { "orhideous.name", true },
  { "oscarvk.ch", true },
  { "osquery.io", true },
  { "osterkraenzchen.de", true },
  { "otakuworld.de", true },
  { "ouvirmusica.com.br", true },
  { "ovenapp.io", true },
  { "oversight.io", true },
  { "ownmovies.fr", true },
  { "p.linode.com", false },
  { "packagist.org", false },
  { "pactf.com", true },
  { "pajonzeck.de", true },
  { "palava.tv", true },
  { "pap.la", false },
  { "parent5446.us", true },
  { "partyvan.eu", true },
  { "partyvan.it", true },
  { "partyvan.nl", true },
  { "partyvan.se", true },
  { "passphrase.today", true },
  { "passport.yandex.by", true },
  { "passport.yandex.com", true },
  { "passport.yandex.com.tr", true },
  { "passport.yandex.kz", true },
  { "passport.yandex.ru", true },
  { "passport.yandex.ua", true },
  { "passwd.io", true },
  { "password.codes", true },
  { "passwords.google.com", true },
  { "pasta-factory.co.il", true },
  { "paste.linode.com", false },
  { "pastebin.linode.com", false },
  { "patriksimek.cz", true },
  { "patt.us", true },
  { "pauladamsmith.com", true },
  { "paulschreiber.com", true },
  { "pay.gigahost.dk", true },
  { "paymentaccuracy.gov", true },
  { "paymill.com", true },
  { "paymill.de", true },
  { "paypal.com", false },
  { "payroll.xero.com", false },
  { "pcel.com", true },
  { "pclob.gov", true },
  { "pdf.yt", true },
  { "peercraft.com", true },
  { "pentesterlab.com", true },
  { "perfectionis.me", true },
  { "personaldatabasen.no", true },
  { "pestici.de", true },
  { "petplum.com", true },
  { "petrolplus.ru", true },
  { "pharmaboard.de", true },
  { "phil.tw", true },
  { "philosopherswool.com", true },
  { "phoenix.dj", true },
  { "phoenixlogan.com", true },
  { "phryanjr.com", false },
  { "phurl.de", true },
  { "pi-supply.com", true },
  { "picksin.club", true },
  { "picsto.re", true },
  { "pieperhome.de", true },
  { "pierre-schmitz.com", true },
  { "pijuice.com", true },
  { "piratedb.com", true },
  { "piratedot.com", true },
  { "pirateproxy.sx", true },
  { "pixel.facebook.com", false },
  { "pixi.me", true },
  { "play.google.com", true },
  { "plothost.com", true },
  { "plus.google.com", false },
  { "plus.sandbox.google.com", false },
  { "plzenskybarcamp.cz", true },
  { "pmg-offshore-company.com", true },
  { "pmg-purchase.com", true },
  { "pmg-purchase.net", true },
  { "pollpodium.nl", true },
  { "polymathematician.com", true },
  { "polypho.nyc", true },
  { "ponythread.com", true },
  { "portal.tirol.gv.at", true },
  { "posteo.de", false },
  { "postfinance.ch", true },
  { "powerplannerapp.com", true },
  { "prakharprasad.com", true },
  { "prefontaine.name", true },
  { "preissler.co.uk", true },
  { "preloaded-hsts.badssl.com", true },
  { "privategiant.com", true },
  { "profiles.google.com", true },
  { "progressiveplanning.com", true },
  { "projektzentrisch.de", true },
  { "prontolight.com", true },
  { "proofwiki.org", true },
  { "propagandism.org", true },
  { "prowhisky.de", true },
  { "proximato.com", true },
  { "proxybay.club", true },
  { "proxybay.co", true },
  { "proxybay.info", true },
  { "ptn.moscow", true },
  { "puac.de", true },
  { "pubkey.is", true },
  { "publications.qld.gov.au", false },
  { "puiterwijk.org", true },
  { "pult.co", false },
  { "pwd.ovh", true },
  { "pypa.io", true },
  { "pypi.python.org", true },
  { "python.org", false },
  { "qa.fedoraproject.org", true },
  { "qa.stg.fedoraproject.org", true },
  { "qetesh.de", true },
  { "quebecmailbox.com", true },
  { "quuz.org", true },
  { "r3s1stanc3.me", true },
  { "rad-route.de", true },
  { "radiormi.com", true },
  { "rafaelcz.de", true },
  { "ragingserenity.com", true },
  { "raiseyourflag.com", true },
  { "ramsor-gaming.de", true },
  { "rasing.me", true },
  { "raspass.me", true },
  { "ravchat.com", true },
  { "rawstorieslondon.com", true },
  { "raymii.org", true },
  { "reaconverter.com", true },
  { "red-t-shirt.ru", true },
  { "redirect.fedoraproject.org", true },
  { "redirect.stg.fedoraproject.org", true },
  { "redletter.link", true },
  { "redteam-pentesting.de", true },
  { "reedloden.com", true },
  { "refundo.cz", true },
  { "refundo.sk", true },
  { "reg.ru", false },
  { "reishunger.de", true },
  { "release-monitoring.org", true },
  { "reliable-mail.de", true },
  { "renem.net", true },
  { "research.facebook.com", false },
  { "research.md", true },
  { "residentsinsurance.co.uk", true },
  { "resources.flowfinity.com", true },
  { "reviews.anime.my", true },
  { "riccy.org", true },
  { "richiemail.net", true },
  { "ricochet.im", true },
  { "rid-wan.com", true },
  { "riesenmagnete.de", true },
  { "rika.me", true },
  { "rippleunion.com", true },
  { "rischard.org", true },
  { "rlalique.com", true },
  { "roan24.pl", true },
  { "robertof.ovh", true },
  { "robinadr.com", true },
  { "robinsonyu.com", true },
  { "robteix.com", true },
  { "robtex.com", true },
  { "rodosto.com", true },
  { "roland.io", true },
  { "romab.com", true },
  { "roman-pavlik.cz", true },
  { "romans-place.me.uk", true },
  { "romulusapp.com", false },
  { "room-checkin24.de", true },
  { "roots.io", true },
  { "rosenkeller.org", true },
  { "rotunneling.net", true },
  { "roundcube.mayfirst.org", false },
  { "royalacademy.org.uk", true },
  { "rpavlik.cz", true },
  { "rpy.xyz", true },
  { "rssr.se", true },
  { "ru-sprachstudio.ch", true },
  { "rubecodeberg.com", true },
  { "rubendv.be", true },
  { "rudloff.pro", true },
  { "rusadmin.biz", true },
  { "ruudkoot.nl", true },
  { "rws-vertriebsportal.de", true },
  { "s-c.se", true },
  { "sabahattin-gucukoglu.com", true },
  { "sagerus.com", true },
  { "sageth.com", true },
  { "saintsrobotics.com", true },
  { "sakaki.anime.my", true },
  { "salaervergleich.com", true },
  { "sale4ru.ru", true },
  { "salserocafe.com", true },
  { "samba.org", true },
  { "samfunnet.no", true },
  { "samizdat.cz", true },
  { "samuelkeeley.com", true },
  { "sanatfilan.com", false },
  { "sandbox.mydigipass.com", false },
  { "saulchristie.com", true },
  { "save.gov", true },
  { "saveaward.gov", true },
  { "savvytime.com", true },
  { "schachburg.de", true },
  { "schokokeks.org", false },
  { "schreiber-netzwerk.eu", true },
  { "schwarzer.it", true },
  { "sciencex.com", true },
  { "scotthel.me", true },
  { "scotthelme.co.uk", true },
  { "scoutdb.ch", true },
  { "scrambl.is", true },
  { "scrambler.in", false },
  { "scrap.tf", true },
  { "scribe.systems", true },
  { "script.google.com", true },
  { "sdsl-speedtest.de", true },
  { "sec.gd", true },
  { "secretserveronline.com", true },
  { "secure.facebook.com", false },
  { "securedrop.org", true },
  { "securesuisse.ch", true },
  { "securify.nl", true },
  { "security-carpet.com", true },
  { "security.google.com", true },
  { "securityheaders.com", true },
  { "secuvera.de", true },
  { "seifried.org", true },
  { "sello.com", true },
  { "sellocdn.com", true },
  { "servergno.me", true },
  { "servertastic.com", true },
  { "servethecity-karlsruhe.de", false },
  { "setuid.io", true },
  { "seyahatsagliksigortalari.com", true },
  { "sh-network.de", true },
  { "shaaaaaaaaaaaaa.com", true },
  { "shadex.net", true },
  { "shakepeers.org", true },
  { "shellsec.pw", true },
  { "shenyuqi.com", true },
  { "sherbers.de", true },
  { "shiinko.com", false },
  { "shipard.com", true },
  { "shodan.io", true },
  { "shopontarget.com", true },
  { "shortdiary.me", true },
  { "sidium.de", true },
  { "siewert-kau.de", true },
  { "sigterm.sh", true },
  { "sikayetvar.com", true },
  { "silentcircle.com", false },
  { "simbolo.co.uk", false },
  { "simple.com", false },
  { "simpletax.ca", false },
  { "simplia.cz", true },
  { "simplystudio.com", true },
  { "siraweb.org", true },
  { "siriad.com", true },
  { "sites.google.com", true },
  { "sitesten.com", true },
  { "sjoorm.com", true },
  { "skeeley.com", true },
  { "skhosting.eu", true },
  { "skogsbruket.fi", true },
  { "skogskultur.fi", true },
  { "skydrive.live.com", false },
  { "slack-files.com", true },
  { "slack.com", true },
  { "slattery.co", true },
  { "sleio.com", true },
  { "slever.cz", true },
  { "slevomat.cz", true },
  { "slidebatch.com", true },
  { "slse.ca", true },
  { "smartcleaningcenter.nl", true },
  { "smartcoin.com.br", true },
  { "smartlend.se", true },
  { "smartship.co.jp", true },
  { "smith.is", true },
  { "snakehosting.dk", true },
  { "sneezry.com", true },
  { "snowflake.ch", false },
  { "sockeye.cc", true },
  { "soia.ca", true },
  { "sorz.org", true },
  { "souki.cz", true },
  { "soulogic.com", true },
  { "sour.is", true },
  { "sourceway.de", true },
  { "southside-crew.com", true },
  { "souvik.me", true },
  { "spartantheatre.org", true },
  { "spawn.cz", true },
  { "speedcounter.net", true },
  { "spencerbaer.com", true },
  { "spideroak.com", true },
  { "spongepowered.org", true },
  { "spreadsheets.google.com", true },
  { "spreed.me", true },
  { "sprueche-zum-valentinstag.de", true },
  { "sprueche-zur-geburt.info", true },
  { "sprueche-zur-hochzeit.de", true },
  { "sprueche-zur-konfirmation.de", true },
  { "squareup.com", false },
  { "srevilak.net", true },
  { "sro.center", true },
  { "ssl.google-analytics.com", true },
  { "sslmate.com", true },
  { "stage.wepay.com", false },
  { "standardssuck.org", true },
  { "starapple.nl", true },
  { "static.wepay.com", false },
  { "staticanime.net", false },
  { "stationary-traveller.eu", true },
  { "stereo.lu", true },
  { "stesti.cz", true },
  { "stevegrav.es", true },
  { "steventress.com", true },
  { "sticklerjs.org", true },
  { "stillyarts.com", true },
  { "stirling.co", true },
  { "stocktrade.de", false },
  { "storedsafe.com", true },
  { "stormhub.org", true },
  { "strasweb.fr", false },
  { "stretchmyan.us", true },
  { "stripe.com", true },
  { "strongest-privacy.com", true },
  { "stuartbaxter.co", false },
  { "studienportal.eu", true },
  { "studydrive.net", true },
  { "stulda.cz", true },
  { "subeesu.com", true },
  { "subrosa.io", true },
  { "sufix.cz", true },
  { "suite73.org", true },
  { "sunjaydhama.com", true },
  { "suos.io", true },
  { "supplies24.at", true },
  { "supplies24.es", true },
  { "support.mayfirst.org", false },
  { "surkatty.org", true },
  { "survivalmonkey.com", true },
  { "svager.cz", true },
  { "swehack.org", false },
  { "sychov.pro", true },
  { "sylaps.com", true },
  { "sysctl.se", true },
  { "sysdb.io", true },
  { "syss.de", true },
  { "syzygy-tables.info", true },
  { "t23m-navi.jp", false },
  { "tadigitalstore.com", true },
  { "tageau.com", true },
  { "taglondon.org", true },
  { "taken.pl", true },
  { "talk.google.com", true },
  { "talkgadget.google.com", true },
  { "tallr.se", true },
  { "tallshoe.com", true },
  { "tas2580.net", true },
  { "taskotron.fedoraproject.org", true },
  { "taskotron.stg.fedoraproject.org", true },
  { "tatort-fanpage.de", true },
  { "tauchkater.de", true },
  { "tbspace.de", true },
  { "tcgrepublic.com", true },
  { "tdrs.info", true },
  { "teachforcanada.ca", true },
  { "teamnorthgermany.de", true },
  { "teamupturn.com", true },
  { "techhipster.net", true },
  { "techllage.com", true },
  { "techloaner.com", true },
  { "technotonic.com.au", false },
  { "tegelsensanitaironline.nl", true },
  { "tekshrek.com", true },
  { "temp.pm", true },
  { "tempus-aquilae.de", true },
  { "tent.io", true },
  { "terraelectronica.ru", true },
  { "terraweb.net", true },
  { "terrax.info", true },
  { "terrax.net", true },
  { "terrty.net", true },
  { "testsuite.org", true },
  { "texte-zur-taufe.de", true },
  { "thca.ca", true },
  { "theamp.com", true },
  { "thebimhub.com", true },
  { "thecustomizewindows.com", true },
  { "theescapistswiki.com", true },
  { "thefrozenfire.com", true },
  { "thehiddenbay.net", true },
  { "themoep.at", true },
  { "thepaymentscompany.com", true },
  { "thepiratebay.al", true },
  { "therapynotes.com", true },
  { "therapyportal.com", true },
  { "theshadestore.com", true },
  { "thetomharling.com", true },
  { "theunitedstates.io", true },
  { "thomastimepieces.com.au", true },
  { "thouni.de", true },
  { "thumbtack.com", true },
  { "thusoy.com", true },
  { "thyngster.com", false },
  { "tickopa.co.uk", true },
  { "tid.jp", true },
  { "timmy.ws", true },
  { "timotrans.de", true },
  { "timotrans.eu", true },
  { "timtaubert.de", true },
  { "tinfoilsecurity.com", false },
  { "tinkertry.com", false },
  { "tinte24.de", true },
  { "tintenfix.net", true },
  { "tipps-fuer-den-haushalt.de", true },
  { "tipsyk.ru", true },
  { "tirex.media", true },
  { "tittelbach.at", true },
  { "titties.ml", true },
  { "tls.li", true },
  { "tmtopup.com", true },
  { "tno.io", true },
  { "tobias-kluge.de", true },
  { "todesschaf.org", true },
  { "todoist.com", true },
  { "tollmanz.com", true },
  { "tollsjekk.no", true },
  { "tom.horse", true },
  { "tomfisher.eu", true },
  { "tomharling.co.uk", true },
  { "tomharling.uk", true },
  { "tomrichards.net", true },
  { "tomvote.com", true },
  { "toner24.at", true },
  { "toner24.co.uk", true },
  { "toner24.es", true },
  { "toner24.fr", true },
  { "toner24.it", true },
  { "toner24.nl", true },
  { "toner24.pl", true },
  { "tonerdepot.de", true },
  { "tonerjet.at", true },
  { "tonerjet.co.uk", true },
  { "tonerklick.de", true },
  { "tonerkurier.de", true },
  { "tonermaus.de", true },
  { "tonermonster.de", true },
  { "tonex.de", true },
  { "tonex.nl", true },
  { "tonywebster.com", true },
  { "topodin.com", true },
  { "topshelfguild.com", true },
  { "toptexture.com", true },
  { "tor2web.org", true },
  { "tormentedradio.com", true },
  { "torproject.org", false },
  { "torquato.de", true },
  { "toshnix.com", true },
  { "touch.facebook.com", false },
  { "touch.mail.ru", true },
  { "tox.im", true },
  { "tpbproxy.co", true },
  { "traas.org", true },
  { "tracktivity.com.au", true },
  { "translate.fedoraproject.org", true },
  { "translate.googleapis.com", true },
  { "translate.stg.fedoraproject.org", true },
  { "trashnothing.com", true },
  { "trauertexte.info", true },
  { "tresorit.com", true },
  { "tribut.de", true },
  { "ts3.consulting", true },
  { "tuamoronline.com", true },
  { "tucuxi.org", true },
  { "tuitle.com", true },
  { "tunebitfm.de", true },
  { "tuturulianda.com", true },
  { "tuxplace.nl", true },
  { "twentymilliseconds.com", true },
  { "twisto.cz", true },
  { "twitter.com", false },
  { "twitteroauth.com", true },
  { "twofactorauth.org", true },
  { "twolinepassbrewing.com", true },
  { "typingrevolution.com", true },
  { "uae-company-service.com", true },
  { "ub3rk1tten.com", true },
  { "ubertt.org", true },
  { "ucfirst.nl", true },
  { "ukdefencejournal.org.uk", true },
  { "ukhas.net", true },
  { "ukrainians.ch", true },
  { "unbanthe.net", true },
  { "unison.com", true },
  { "unitedadmins.com", true },
  { "unknownphenomena.net", true },
  { "unravel.ie", true },
  { "unterfrankenclan.de", true },
  { "uonstaffhub.com", true },
  { "uow.ninja", true },
  { "upitnik.rs", true },
  { "upload.facebook.com", false },
  { "uptrends.com", true },
  { "uptrends.de", true },
  { "usaa.com", false },
  { "uscntalk.com", true },
  { "uspsoig.gov", true },
  { "utilityapi.com", true },
  { "utleieplassen.no", true },
  { "vaddder.com", true },
  { "vasanth.org", true },
  { "vechkasov.ru", true },
  { "venicerealdeal.com", true },
  { "vhost.co.id", true },
  { "viasinc.com", false },
  { "vijos.org", true },
  { "visionless.me", false },
  { "vitrado.de", true },
  { "vmoagents.com", false },
  { "vocaloid.my", true },
  { "voicesuk.co.uk", true },
  { "vomitb.in", true },
  { "vortexhobbies.com", true },
  { "vox.vg", true },
  { "vpnzoom.com", true },
  { "vrobert.fr", false },
  { "vserver-preis-vergleich.de", true },
  { "vyplnto.cz", true },
  { "w-spotlight.appspot.com", true },
  { "wallet.google.com", true },
  { "walnutgaming.co.uk", true },
  { "walnutgaming.com", true },
  { "warrencreative.com", false },
  { "watsonhall.uk", true },
  { "wbg-vs.de", true },
  { "webandmore.de", false },
  { "webandwords.com.au", true },
  { "webassadors.com", false },
  { "webcollect.org.uk", true },
  { "webeau.com", true },
  { "webfilings-eu-mirror.appspot.com", true },
  { "webfilings-eu.appspot.com", true },
  { "webfilings-mirror-hrd.appspot.com", true },
  { "webfilings.appspot.com", true },
  { "weblogzwolle.nl", true },
  { "webmail.gigahost.dk", false },
  { "webmail.onlime.ch", false },
  { "webmail.schokokeks.org", false },
  { "webmaniabr.com", true },
  { "webrebels.org", true },
  { "websenat.de", true },
  { "webtalis.nl", true },
  { "webtiles.co.uk", true },
  { "webtrh.cz", true },
  { "weggeweest.nl", true },
  { "welches-kinderfahrrad.de", true },
  { "welpy.com", false },
  { "wepay.com", false },
  { "wepay.in.th", true },
  { "wesleyharris.ca", true },
  { "wettertoertchen.com", true },
  { "wevahoo.com", true },
  { "wf-bigsky-master.appspot.com", true },
  { "wf-demo-eu.appspot.com", true },
  { "wf-demo-hrd.appspot.com", true },
  { "wf-dogfood-hrd.appspot.com", true },
  { "wf-pentest.appspot.com", true },
  { "wf-staging-hr.appspot.com", true },
  { "wf-training-hrd.appspot.com", true },
  { "wf-training-master.appspot.com", true },
  { "wf-trial-hrd.appspot.com", true },
  { "whatwg.org", true },
  { "whd-guide.de", true },
  { "when-release.ru", true },
  { "wherephoto.com", true },
  { "whitestagforge.com", true },
  { "whocalld.com", true },
  { "whonix.org", true },
  { "widememory.com", true },
  { "wieninternational.at", true },
  { "wifirst.net", true },
  { "wiki.python.org", true },
  { "wildbee.org", true },
  { "williamsonshore.com", true },
  { "willnorris.com", true },
  { "wills.co.tt", true },
  { "winhistory-forum.net", true },
  { "wisv.ch", true },
  { "wondershift.biz", true },
  { "wootton95.com", true },
  { "wownmedia.com", true },
  { "wpletter.de", true },
  { "writeapp.me", false },
  { "wtfismyip.com", true },
  { "wubthecaptain.eu", true },
  { "wunderlist.com", true },
  { "wundi.net", true },
  { "wvr-law.de", true },
  { "www.aclu.org", false },
  { "www.airbnb.com", true },
  { "www.apollo-auto.com", true },
  { "www.banking.co.at", false },
  { "www.braintreepayments.com", false },
  { "www.capitainetrain.com", false },
  { "www.cyveillance.com", true },
  { "www.dropbox.com", true },
  { "www.dropcam.com", false },
  { "www.entropia.de", false },
  { "www.eternalgoth.co.uk", true },
  { "www.etsy.com", true },
  { "www.evernote.com", false },
  { "www.facebook.com", false },
  { "www.gamesdepartment.co.uk", false },
  { "www.getcloak.com", false },
  { "www.gmail.com", false },
  { "www.googlemail.com", false },
  { "www.gov.uk", false },
  { "www.grc.com", false },
  { "www.healthcare.gov", false },
  { "www.heliosnet.com", true },
  { "www.honeybadger.io", false },
  { "www.intercom.io", false },
  { "www.irccloud.com", false },
  { "www.lastpass.com", false },
  { "www.ledgerscope.net", false },
  { "www.linode.com", false },
  { "www.lookout.com", false },
  { "www.makeyourlaws.org", true },
  { "www.mydigipass.com", false },
  { "www.mylookout.com", false },
  { "www.noisebridge.net", false },
  { "www.opsmate.com", true },
  { "www.paypal.com", false },
  { "www.python.org", true },
  { "www.roddis.net", true },
  { "www.schokokeks.org", false },
  { "www.simbolo.co.uk", false },
  { "www.simple.com", false },
  { "www.therapynotes.com", true },
  { "www.tinfoilsecurity.com", false },
  { "www.torproject.org", false },
  { "www.twitter.com", false },
  { "www.usaa.com", false },
  { "www.viasinc.com", true },
  { "www.wepay.com", false },
  { "www.zenpayroll.com", false },
  { "wzrd.in", true },
  { "wzyboy.org", true },
  { "x.io", true },
  { "xbrlsuccess.appspot.com", true },
  { "xenesisziarovky.sk", true },
  { "xf-liam.com", true },
  { "xn--maraa-rta.org", true },
  { "xpd.se", true },
  { "xps2pdf.co.uk", true },
  { "xtrim.ru", true },
  { "xuntier.ch", true },
  { "y-o-w.com", true },
  { "yafuoku.ru", true },
  { "yahvehyireh.com", true },
  { "yamaken.jp", true },
  { "yanovich.net", true },
  { "yaporn.tv", false },
  { "yenniferallulli.com", true },
  { "yenniferallulli.de", true },
  { "yenniferallulli.es", true },
  { "yenniferallulli.moda", true },
  { "yenniferallulli.nl", true },
  { "yetii.net", true },
  { "yksityisyydensuoja.fi", true },
  { "yokeepo.com", true },
  { "yorcom.nl", true },
  { "youdowell.com", true },
  { "yoursecondphone.co", true },
  { "ypart.eu", true },
  { "z.ai", true },
  { "zalan.do", true },
  { "zapier.com", true },
  { "zbasenem.pl", true },
  { "zenpayroll.com", false },
  { "zentralwolke.de", true },
  { "zeplin.io", false },
  { "zeropush.com", true },
  { "zhovner.com", true },
  { "zifb.in", true },
  { "zixiao.wang", true },
  { "zlatosnadno.cz", true },
  { "zlavomat.sk", true },
  { "zotero.org", true },
  { "zravypapir.cz", true },
};
