var browserTests = [
["foo[]bar",
    [["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["insertimage","/img/lion.svg"]],
    "<span>foo</span><img src=\"/img/lion.svg\">{}<span>bar</span>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
    [["insertimage","/img/lion.svg"]],
    "<span>foo<img src=\"/img/lion.svg\">{}</span><span>bar</span>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["insertimage",""]],
    "foo[bar]baz",
    [false],
    {"insertimage":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar]</span>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar}</span>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo{<span style=color:#aBcDeF>bar</span>}baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","true"],["insertimage","/img/lion.svg"]],
    "<img src=\"/img/lion.svg\">{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["[foo<span style=color:#aBcDeF>bar]</span>baz",
    [["stylewithcss","false"],["insertimage","/img/lion.svg"]],
    "<img src=\"/img/lion.svg\">{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","true"],["insertimage","/img/lion.svg"]],
    "<img src=\"/img/lion.svg\">{}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["{foo<span style=color:#aBcDeF>bar}</span>baz",
    [["stylewithcss","false"],["insertimage","/img/lion.svg"]],
    "<img src=\"/img/lion.svg\">{}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span>baz]",
    [["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>{bar</span>baz}",
    [["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","true"],["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertimage":[false,false,"",false,false,""]}],
["foo<span style=color:#aBcDeF>[bar</span><span style=color:#fEdCbA>baz]</span>quz",
    [["stylewithcss","false"],["insertimage","/img/lion.svg"]],
    "foo<span style=\"color:rgb(171, 205, 239)\"><img src=\"/img/lion.svg\">{}</span>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertimage":[false,false,"",false,false,""]}],
["foo<b>[bar]</b>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<b><img src=\"/img/lion.svg\">{}</b>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<b>{bar}</b>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<b><img src=\"/img/lion.svg\">{}</b>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo{<b>bar</b>}baz",
    [["insertimage","/img/lion.svg"]],
    "foo<b><img src=\"/img/lion.svg\">{}</b>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span>[bar]</span>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo<span>{bar}</span>baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo{<span>bar</span>}baz",
    [["insertimage","/img/lion.svg"]],
    "foo<span><img src=\"/img/lion.svg\">{}</span>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<b>foo[bar</b><i>baz]quz</i>",
    [["insertimage","/img/lion.svg"]],
    "<b>foo<img src=\"/img/lion.svg\">{}</b><i>quz</i>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p><p>[bar]</p><p>baz</p>",
    [["insertimage","/img/lion.svg"]],
    "<p>foo</p><p><img src=\"/img/lion.svg\">{}</p><p>baz</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p><p>{bar}</p><p>baz</p>",
    [["insertimage","/img/lion.svg"]],
    "<p>foo</p><p><img src=\"/img/lion.svg\">{}</p><p>baz</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo</p><img src=\"/img/lion.svg\">{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo</p>{<p>bar</p>}<p>baz</p>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo</p><img src=\"/img/lion.svg\">{}<p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p>baz]quz",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<div>baz]quz</div>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<h1>baz]quz</h1>",
    [["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<div>foo<img src=\"/img/lion.svg\">{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<div>foo<img src=\"/img/lion.svg\">{}quz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<blockquote>foo[bar</blockquote><pre>baz]quz</pre>",
    [["insertimage","/img/lion.svg"]],
    "<blockquote>foo<img src=\"/img/lion.svg\">{}quz</blockquote>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p><b>foo</b><img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p><b>foo[bar</b><p>baz]quz",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p><b>foo</b><img src=\"/img/lion.svg\">{}quz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<div><p>foo<img src=\"/img/lion.svg\">{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[bar</div><p>baz]quz",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<div><p>foo<img src=\"/img/lion.svg\">{}quz</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<blockquote><p>baz]quz<p>qoz</blockquote",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}quz</p><blockquote><p>qoz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<span style=\"color:rgb(0, 0, 255)\">quz</span></p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p style=color:blue>baz]quz",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<font color=\"#0000ff\">quz</font></p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[bar<p><b>baz]quz</b>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}<b>quz</b></p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<div><p>foo</p><p><img src=\"/img/lion.svg\">{}</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo<p>[bar<p>baz]</div>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<div><p>foo</p><p><img src=\"/img/lion.svg\">{}</p></div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<br>]bar",
    [["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar</p>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p><p>]bar<br>baz</p>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar<br>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar<br>baz</p>",
    [["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<p>baz</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<p>]bar</p>baz",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<br>baz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar",
    [["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<br>baz",
    [["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar</p>baz",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<p>foo[</p>]bar<p>baz</p>",
    [["insertimage","/img/lion.svg"]],
    "<p>foo<img src=\"/img/lion.svg\">{}bar</p><p>baz</p>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</div>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo[</p></div>]bar",
    [["insertimage","/img/lion.svg"]],
    "<div><p>foo<img src=\"/img/lion.svg\">{}bar</p></div>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","div"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div><p>]bar</p>baz</div>",
    [["defaultparagraphseparator","p"],["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<div>baz</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertimage":[false,false,"",false,false,""]}],
["foo[<div>]bar<p>baz</p></div>",
    [["insertimage","/img/lion.svg"]],
    "foo<img src=\"/img/lion.svg\">{}bar<div><p>baz</p></div>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<div><p>foo</p>bar[</div>]baz",
    [["insertimage","/img/lion.svg"]],
    "<div><p>foo</p>bar<img src=\"/img/lion.svg\">{}baz</div>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}],
["<div>foo<p>bar[</p></div>]baz",
    [["insertimage","/img/lion.svg"]],
    "<div>foo<p>bar<img src=\"/img/lion.svg\">{}baz</p></div>",
    [true],
    {"insertimage":[false,false,"",false,false,""]}]
]
