/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef SummaryFrame_h
#define SummaryFrame_h

#include "nsBlockFrame.h"

class nsStyleContext;

// SummaryFrame is generated by HTMLSummaryElement.
//
class SummaryFrame final : public nsBlockFrame
{
public:
  NS_DECL_FRAMEARENA_HELPERS

  explicit SummaryFrame(nsStyleContext* aContext);

  virtual ~SummaryFrame();

  nsIAtom* GetType() const override;

#ifdef DEBUG_FRAME_DUMP
  nsresult GetFrameName(nsAString& aResult) const override
  {
    return MakeFrameName(NS_LITERAL_STRING("Summary"), aResult);
  }
#endif

  void SetInitialChildList(ChildListID aListID,
                           nsFrameList& aChildList) override;
};

#endif // SummaryFrame_h
