/* THIS FILE IS AUTOGENERATED FROM MozPaymentProvider.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MozPaymentProviderBinding_h
#define mozilla_dom_MozPaymentProviderBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class DOMRequest;
struct NativePropertyHooks;
struct PaymentIccInfo;
struct PaymentIccInfoAtoms;
class PaymentProvider;
struct PaymentProviderAtoms;
struct PaymentSmsMessage;
struct PaymentSmsMessageAtoms;
class ProtoAndIfaceCache;
class SilentSmsCallback;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct PaymentIccInfo : public DictionaryBase
{
  Optional<bool> mDataPrimary;
  Optional<nsString> mIccId;
  Optional<nsString> mMcc;
  Optional<nsString> mMnc;

  PaymentIccInfo();

  explicit inline PaymentIccInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentIccInfo(const PaymentIccInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const PaymentIccInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, PaymentIccInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentIccInfo : public PaymentIccInfo
{
  inline FastPaymentIccInfo()
    : PaymentIccInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PaymentSmsMessage : public DictionaryBase
{
  Optional<nsString> mBody;
  Optional<nsString> mIccId;
  Optional<nsString> mSender;
  Optional<uint64_t> mSentTimestamp;
  Optional<uint64_t> mTimestamp;

  PaymentSmsMessage();

  explicit inline PaymentSmsMessage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline PaymentSmsMessage(const PaymentSmsMessage& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const PaymentSmsMessage& aOther);

private:
  static bool
  InitIds(JSContext* cx, PaymentSmsMessageAtoms* atomsCache);
};

namespace binding_detail {
struct FastPaymentSmsMessage : public PaymentSmsMessage
{
  inline FastPaymentSmsMessage()
    : PaymentSmsMessage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class SilentSmsCallback : public CallbackFunction
{
public:
  explicit inline SilentSmsCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SilentSmsCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SilentSmsCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Optional<PaymentSmsMessage>& message, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "SilentSmsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, message, aRv);
  }

  inline void
  Call(const Optional<PaymentSmsMessage>& message, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "SilentSmsCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, message, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, const Optional<PaymentSmsMessage>& message, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, message, rv, aExecutionReason);
  }

  inline void
  Call(const Optional<PaymentSmsMessage>& message, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(message, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const SilentSmsCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const Optional<PaymentSmsMessage>& message, ErrorResult& aRv);
};


namespace PaymentProviderBinding {

  typedef mozilla::dom::PaymentProvider NativeType;

  already_AddRefed<PaymentProvider>
  ConstructNavigatorObject(JSContext* cx, JS::Handle<JSObject*> obj, ErrorResult& aRv);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::PaymentProvider* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedIccInfoValue(mozilla::dom::PaymentProvider* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace PaymentProviderBinding



class PaymentProviderJSImpl : public CallbackInterface
{
public:
  explicit inline PaymentProviderJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline PaymentProviderJSImpl(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  void PaymentSuccess(const Optional<nsAString>& result, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void PaymentFailed(const Optional<nsAString>& error, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> SendSilentSms(const nsAString& number, const nsAString& message, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ObserveSilentSms(const nsAString& number, SilentSmsCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveSilentSmsObserver(const nsAString& number, SilentSmsCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const PaymentProviderJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  void GetPaymentServiceId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetIccInfo(Nullable<nsTArray<PaymentIccInfo>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, PaymentProviderAtoms* atomsCache);
};


class PaymentProvider final : public nsSupportsWeakReference,
                              public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(PaymentProvider)

private:
  RefPtr<PaymentProviderJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  PaymentProvider(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~PaymentProvider();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  void GetPaymentServiceId(nsString& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void GetIccInfo(Nullable<nsTArray<PaymentIccInfo>>& aRetVal, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void PaymentSuccess(const Optional<nsAString>& result, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void PaymentFailed(const Optional<nsAString>& error, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<DOMRequest> SendSilentSms(const nsAString& number, const nsAString& message, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void ObserveSilentSms(const nsAString& number, SilentSmsCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void RemoveSilentSmsObserver(const nsAString& number, SilentSmsCallback& callback, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MozPaymentProviderBinding_h
