/* THIS FILE IS AUTOGENERATED FROM PushManager.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_PushManagerBinding_h
#define mozilla_dom_PushManagerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionTypes.h"
#include "nsWeakReference.h"

namespace mozilla {
namespace dom {

class ArrayBufferViewOrArrayBuffer;
struct NativePropertyHooks;
class OwningArrayBufferViewOrArrayBuffer;
class Promise;
class ProtoAndIfaceCache;
class PushManager;
struct PushManagerAtoms;
class PushManagerImpl;
struct PushManagerImplAtoms;
struct PushSubscriptionOptionsInit;
struct PushSubscriptionOptionsInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class PushPermissionState : uint32_t {
  Granted,
  Denied,
  Prompt,
  EndGuard_
};

namespace PushPermissionStateValues {
extern const EnumEntry strings[4];
} // namespace PushPermissionStateValues

bool
ToJSValue(JSContext* aCx, PushPermissionState aArgument, JS::MutableHandle<JS::Value> aValue);


struct PushSubscriptionOptionsInit : public DictionaryBase
{
  Nullable<OwningArrayBufferViewOrArrayBuffer > mApplicationServerKey;

  PushSubscriptionOptionsInit();

  explicit inline PushSubscriptionOptionsInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  PushSubscriptionOptionsInit(const PushSubscriptionOptionsInit&) = delete;
  void operator=(const PushSubscriptionOptionsInit) = delete;

  static bool
  InitIds(JSContext* cx, PushSubscriptionOptionsInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastPushSubscriptionOptionsInit : public PushSubscriptionOptionsInit
{
  inline FastPushSubscriptionOptionsInit()
    : PushSubscriptionOptionsInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace PushManagerBinding {

  typedef mozilla::dom::PushManager NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::PushManager* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace PushManagerBinding



namespace PushManagerImplBinding {

  typedef mozilla::dom::PushManagerImpl NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::PushManagerImpl* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace PushManagerImplBinding



class PushManagerImplJSImpl : public CallbackInterface
{
public:
  explicit inline PushManagerImplJSImpl(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline PushManagerImplJSImpl(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  already_AddRefed<Promise> Subscribe(const PushSubscriptionOptionsInit& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> GetSubscription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<Promise> PermissionState(const PushSubscriptionOptionsInit& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const nsAString& scope, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const PushManagerImplJSImpl& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  static bool
  InitIds(JSContext* cx, PushManagerImplAtoms* atomsCache);
};


class PushManagerImpl final : public nsSupportsWeakReference,
                              public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(PushManagerImpl)

private:
  RefPtr<PushManagerImplJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  PushManagerImpl(JS::Handle<JSObject*> aJSImplObject, nsIGlobalObject* aParent);

private:
  ~PushManagerImpl();

public:
  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  static already_AddRefed<PushManagerImpl> Constructor(const GlobalObject& global, JSContext* cx, const nsAString& scope, ErrorResult& aRv);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> Subscribe(const PushSubscriptionOptionsInit& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> GetSubscription(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
  already_AddRefed<Promise> PermissionState(const PushSubscriptionOptionsInit& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_PushManagerBinding_h
