/* THIS FILE IS AUTOGENERATED FROM Directory.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_DirectoryBinding_h
#define mozilla_dom_DirectoryBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

struct CreateFileOptionsAtoms;
class Directory;
struct DirectoryAtoms;
class File;
struct NativePropertyHooks;
class OwningStringOrBlobOrArrayBufferOrArrayBufferView;
class OwningStringOrFileOrDirectory;
class ProtoAndIfaceCache;
class StringOrBlobOrArrayBufferOrArrayBufferView;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class CreateIfExistsMode : uint32_t {
  Replace,
  Fail,
  EndGuard_
};

namespace CreateIfExistsModeValues {
extern const EnumEntry strings[3];
} // namespace CreateIfExistsModeValues

bool
ToJSValue(JSContext* aCx, CreateIfExistsMode aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningStringOrFileOrDirectory& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningStringOrFileOrDirectory& aUnion);


struct CreateFileOptions : public DictionaryBase
{
  Optional<OwningStringOrBlobOrArrayBufferOrArrayBufferView> mData;
  CreateIfExistsMode mIfExists;

  CreateFileOptions();

  explicit inline CreateFileOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  CreateFileOptions(const CreateFileOptions&) = delete;
  void operator=(const CreateFileOptions) = delete;

  static bool
  InitIds(JSContext* cx, CreateFileOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastCreateFileOptions : public CreateFileOptions
{
  inline FastCreateFileOptions()
    : CreateFileOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrFileOrDirectory
{
  friend class StringOrFileOrDirectoryArgument;
  enum Type
  {
    eUninitialized,
    eString,
    eFile,
    eDirectory
  };

  union Value
  {
    UnionMember<binding_detail::FakeString > mString;
    UnionMember<NonNull<mozilla::dom::File> > mFile;
    UnionMember<NonNull<mozilla::dom::Directory> > mDirectory;

  };

  Type mType;
  Value mValue;

  StringOrFileOrDirectory(const StringOrFileOrDirectory&) = delete;
  void operator=(const StringOrFileOrDirectory) = delete;
public:
  explicit inline StringOrFileOrDirectory()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrFileOrDirectory()
  {
    Uninit();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline NonNull<mozilla::dom::File>&
  RawSetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline NonNull<mozilla::dom::File>&
  SetAsFile()
  {
    if (mType == eFile) {
      return mValue.mFile.Value();
    }
    Uninit();
    mType = eFile;
    return mValue.mFile.SetValue();
  }

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline NonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline mozilla::dom::File&
  GetAsFile() const
  {
    MOZ_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline NonNull<mozilla::dom::Directory>&
  RawSetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline NonNull<mozilla::dom::Directory>&
  SetAsDirectory()
  {
    if (mType == eDirectory) {
      return mValue.mDirectory.Value();
    }
    Uninit();
    mType = eDirectory;
    return mValue.mDirectory.SetValue();
  }

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline NonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline mozilla::dom::Directory&
  GetAsDirectory() const
  {
    MOZ_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eFile: {
        DestroyFile();
        break;
      }
      case eDirectory: {
        DestroyDirectory();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyFile()
  {
    MOZ_ASSERT(IsFile(), "Wrong type!");
    mValue.mFile.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDirectory()
  {
    MOZ_ASSERT(IsDirectory(), "Wrong type!");
    mValue.mDirectory.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrFileOrDirectory : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrFileOrDirectory& aUnion);
  enum Type
  {
    eUninitialized,
    eString,
    eFile,
    eDirectory
  };

  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<OwningNonNull<mozilla::dom::File> > mFile;
    UnionMember<OwningNonNull<mozilla::dom::Directory> > mDirectory;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningStringOrFileOrDirectory()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningStringOrFileOrDirectory(const OwningStringOrFileOrDirectory& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningStringOrFileOrDirectory()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  OwningNonNull<mozilla::dom::File>&
  RawSetAsFile();

  OwningNonNull<mozilla::dom::File>&
  SetAsFile();

  bool
  TrySetToFile(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsFile() const
  {
    return mType == eFile;
  }

  inline OwningNonNull<mozilla::dom::File>&
  GetAsFile()
  {
    MOZ_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  inline OwningNonNull<mozilla::dom::File> const &
  GetAsFile() const
  {
    MOZ_ASSERT(IsFile(), "Wrong type!");
    return mValue.mFile.Value();
  }

  OwningNonNull<mozilla::dom::Directory>&
  RawSetAsDirectory();

  OwningNonNull<mozilla::dom::Directory>&
  SetAsDirectory();

  bool
  TrySetToDirectory(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDirectory() const
  {
    return mType == eDirectory;
  }

  inline OwningNonNull<mozilla::dom::Directory>&
  GetAsDirectory()
  {
    MOZ_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  inline OwningNonNull<mozilla::dom::Directory> const &
  GetAsDirectory() const
  {
    MOZ_ASSERT(IsDirectory(), "Wrong type!");
    return mValue.mDirectory.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningStringOrFileOrDirectory& aOther);

private:
  void
  DestroyString();

  void
  DestroyFile();

  void
  DestroyDirectory();
};


namespace DirectoryBinding {

  typedef mozilla::dom::Directory NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Directory* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace DirectoryBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DirectoryBinding_h
