var browserTests = [
["foo[]bar",
    [["insertunorderedlist",""]],
    "<ul><li>foo[]bar</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["insertunorderedlist",""]],
    "<ul><li>foo[bar]baz</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<br>[bar]",
    [["insertunorderedlist",""]],
    "foo<ul><li>[bar]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["f[oo<br>b]ar<br>baz",
    [["insertunorderedlist",""]],
    "<ul><li>f[oo</li><li>b]ar</li></ul>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<br>bar</p>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><p>bar</p>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<ol><li>bar]</ol>baz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><li>bar]</li></ul>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>[bar</ol>baz]",
    [["insertunorderedlist",""]],
    "foo<ul><li>[bar</li><li>baz]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul>baz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><li>bar]</li></ul>baz",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar</ul>baz]",
    [["insertunorderedlist",""]],
    "foo<ul><li>[bar</li><li>baz]</li></ul>",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar</ul><ol><li>baz]</ol>quz",
    [["insertunorderedlist",""]],
    "foo<ul><li>[bar</li><li>baz]</li></ul>quz",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol><ul><li>baz]</ul>quz",
    [["insertunorderedlist",""]],
    "foo<ul><li>[bar</li><li>baz]</li></ul>quz",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["insertunorderedlist",""]],
    "<table><tbody><tr><td>foo</td><td><ul><li>b[a]r</li></ul></td><td>baz</td></tr></tbody></table>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>fo[o<td>b]ar<td>baz</table>",
    [["insertunorderedlist",""]],
    "<table><tbody><tr><td><ul><li>fo[o</li></ul></td><td><ul><li>b]ar</li></ul></td><td>baz</td></tr></tbody></table>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["insertunorderedlist",""]],
    "<ul><li>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<p>foo</p><ul><li>[bar]</li></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>foo</p><ul><li>[bar]</li></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote>[bar]</blockquote><p>baz",
    [["insertunorderedlist",""]],
    "<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar]<dt>baz<dd>quz</dl>",
    [["insertunorderedlist",""]],
    "<dl><dt>foo</dt><dd><ul><li>[bar]</li></ul></dd><dt>baz</dt><dd>quz</dd></dl>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>bar<dt>[baz]<dd>quz</dl>",
    [["insertunorderedlist",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dt><ul><li>[baz]</li></ul></dt><dd>quz</dd></dl>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><li>bar]</li></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><li>bar]</li></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>[foo<dd>bar]<dt>baz<dd>quz</dl>",
    [["insertunorderedlist",""]],
    "<dl><dt><ul><li>[foo</li></ul></dt><dd><ul><li>bar]</li></ul></dd><dt>baz</dt><dd>quz</dd></dl>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar<dt>baz]<dd>quz</dl>",
    [["insertunorderedlist",""]],
    "<dl><dt>foo</dt><dd><ul><li>[bar</li></ul></dd><dt><ul><li>baz]</li></ul></dt><dd>quz</dd></dl>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<ol><li>bar</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><ol><li>bar</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]<ol><li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><ol><li>[foo]</ol></ol>",
    [["insertunorderedlist",""]],
    "<ul><ul><li>[foo]</li></ul></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]<br>bar</li></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>foo<br>[bar]</li></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li><div>[foo]</div>bar</li></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ul><li>[bar]</li></ul><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><ul><li>[baz]</li></ul><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ul><li>[bar]</li></ul><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><ul><li>[baz]</li></ul><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar]</li></ul><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><ul><li>[quz]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><ul><li>[quz]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><li>[bar</li><li>baz]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><ul><ul><li>b[ar</li></ul><li>b]az</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar</li></ul><li>baz]</li></ul><p>extra</p>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ul><li>[bar]</li></ul><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol></ol><ul><li>[baz]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><ol><li>baz</li></ol>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><div>[bar]</div><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><p>[bar]</p><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</ul>[bar]",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><li>[bar]</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<ul><li>bar</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li><li>bar</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]<ul><li>baz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><li>[bar]</li><li>baz</li></ul>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><ul><li>[foo]</ul></ul>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]<br>bar</div><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]<br>bar</p><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>foo<br>[bar]</div><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>foo<br>[bar]</p><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><div>bar</div><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<div>[foo]</div><p>bar</p><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>[bar]<li>baz</ul><li>quz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><li>[bar]</li><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>[baz]</ul><li>quz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul><li>[baz]</li><li>quz</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo</li><ul><li>[bar]<li>baz</ul><li>quz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><li>[bar]</li><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>[baz]</ul><li>quz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul><li>[baz]</li><li>quz</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><div>[bar]</div><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><p>[bar]</p><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><div>[bar]</div><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><p>[bar]</p><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><div>[bar</div><div>baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li></ul><p>[bar</p><p>baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo</div><ul><li>bar]</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo</p><ul><li>bar]</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li><li>b[ar</li></ul><div>b]az</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li><li>b[ar</li></ul><p>b]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo</div><ul><li>bar</li></ul><div>baz]</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo</p><ul><li>bar</li></ul><p>baz]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>[bar]</ul>baz</ul>",
    [["insertunorderedlist",""]],
    "<ul><li>foo</li><li>[bar]</li><li>baz</li></ul>",
    [true],
    {"insertunorderedlist":[false,true,"",false,true,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul></ul><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul></ul><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo</div><ul><li>bar]</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",true,false,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo</p><ul><li>bar]</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",true,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "foo<ol><li>bar</li></ol><div>[baz]</div>quz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "foo<ol><li>bar</li></ol><p>[baz]</p>quz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ol><li>bar</ol><ul><li>[baz</ul>quz]",
    [["insertunorderedlist",""]],
    "foo<ol><li>bar</li></ol><ul><li>[baz</li><li>quz]</li></ul>",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "foo<div>[bar]</div><ol><li>baz</li></ol>quz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "foo<p>[bar]</p><ol><li>baz</li></ol>quz",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["[foo<ul><li>bar]</ul><ol><li>baz</ol>quz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><li>bar]</li></ul><ol><li>baz</li></ol>quz",
    [true],
    {"insertunorderedlist":[true,false,"",false,true,""]}],
["[foo]<blockquote>bar</blockquote>baz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><blockquote>bar</blockquote>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]</blockquote>baz",
    [["insertunorderedlist",""]],
    "foo<blockquote><ul><li>[bar]</li></ul></blockquote>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]</blockquote>baz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]</blockquote>baz",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote><ol><li>bar</ol></blockquote>baz",
    [["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><blockquote><ol><li>bar</li></ol></blockquote>baz",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]<br>baz</blockquote>",
    [["insertunorderedlist",""]],
    "foo<blockquote><ul><li>[bar]</li></ul>baz</blockquote>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]<br>baz</blockquote>",
    [["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><blockquote>baz</blockquote>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]<br>baz</blockquote>",
    [["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul>baz</blockquote>",
    [true],
    {"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><blockquote><p>bar</p></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo]</li></ul><blockquote><p>bar</p></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>foo</p><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo</li><ul><li>bar]</li></ul></ul><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ol><li>foo</li></ol><blockquote><ul><li>[bar]</li></ul></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li></ul><div>[bar]</div><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li></ul><p>[bar]</p><ul><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><div>[bar]</div><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><div>[bar]</div><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><p>[bar]</p><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><p>[bar]</p><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><div>[bar]</div><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><div>[bar]</div><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><p>[bar]</p><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><p>[bar]</p><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<div>[foo]</div><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<p>[foo]</p><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,true,"",false,false,""]}],
["<ul><li>foo</ul> <p>[bar]",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li> <li>[bar]</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li> <li>[bar]</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ul><li>bar</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>[foo]</li> <li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ul><li>bar</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>[foo]</li> <li>bar</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]</p> <ul><li>baz</ul>",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul><li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul> <p>[bar]</p> <ul><li>baz</ul>",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul><li>foo</li> <li>[bar]</li> <li>baz</li></ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}],
["{<div style=\"font-size: 1.3em\">1</div><div style=\"font-size: 1.1em\">2</div>}",
    [["defaultparagraphseparator","div"],["insertunorderedlist",""]],
    "<ul>{<li style=\"font-size:1.3em\">1</li><li style=\"font-size:1.1em\">2</li>}</ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertunorderedlist":[false,false,"",false,true,""]}],
["{<div style=\"font-size: 1.3em\">1</div><div style=\"font-size: 1.1em\">2</div>}",
    [["defaultparagraphseparator","p"],["insertunorderedlist",""]],
    "<ul>{<li style=\"font-size:1.3em\">1</li><li style=\"font-size:1.1em\">2</li>}</ul>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertunorderedlist":[false,false,"",false,true,""]}]
]
