/* THIS FILE IS AUTOGENERATED FROM FileSystem.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_FileSystemBinding_h
#define mozilla_dom_FileSystemBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {
namespace dom {

class DOMException;
class ErrorCallback;
struct ErrorCallbackAtoms;
class FileSystem;
struct FileSystemAtoms;
class FileSystemEntry;
class FileSystemEntryCallback;
struct FileSystemEntryCallbackAtoms;
struct FileSystemFlagsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
class VoidCallback;
struct VoidCallbackAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct FileSystemFlags : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCreate;
  MOZ_INIT_OUTSIDE_CTOR bool mExclusive;

  FileSystemFlags();

  explicit inline FileSystemFlags(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline FileSystemFlags(const FileSystemFlags& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const FileSystemFlags& aOther);

private:
  static bool
  InitIds(JSContext* cx, FileSystemFlagsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFileSystemFlags : public FileSystemFlags
{
  inline FastFileSystemFlags()
    : FileSystemFlags(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace FileSystemBinding {

  typedef mozilla::dom::FileSystem NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::FileSystem* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace FileSystemBinding



class ErrorCallback : public CallbackInterface
{
public:
  explicit inline ErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline ErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline ErrorCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, DOMException& err, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "ErrorCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return HandleEvent(s.GetContext(), thisValJS, err, aRv);
  }

  inline void
  HandleEvent(DOMException& err, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "ErrorCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return HandleEvent(s.GetContext(), JS::UndefinedHandleValue, err, aRv);
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, DOMException& err, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(thisVal, err, rv, aExecutionReason);
  }

  inline void
  HandleEvent(DOMException& err, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(err, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const ErrorCallback& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  void HandleEvent(JSContext* cx, JS::Handle<JS::Value> aThisVal, DOMException& err, ErrorResult& aRv);

  static bool
  InitIds(JSContext* cx, ErrorCallbackAtoms* atomsCache);
};


class FileSystemEntryCallback : public CallbackInterface
{
public:
  explicit inline FileSystemEntryCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline FileSystemEntryCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline FileSystemEntryCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, FileSystemEntry& entry, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "FileSystemEntryCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return HandleEvent(s.GetContext(), thisValJS, entry, aRv);
  }

  inline void
  HandleEvent(FileSystemEntry& entry, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "FileSystemEntryCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return HandleEvent(s.GetContext(), JS::UndefinedHandleValue, entry, aRv);
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, FileSystemEntry& entry, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(thisVal, entry, rv, aExecutionReason);
  }

  inline void
  HandleEvent(FileSystemEntry& entry, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(entry, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const FileSystemEntryCallback& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  void HandleEvent(JSContext* cx, JS::Handle<JS::Value> aThisVal, FileSystemEntry& entry, ErrorResult& aRv);

  static bool
  InitIds(JSContext* cx, FileSystemEntryCallbackAtoms* atomsCache);
};


class VoidCallback : public CallbackInterface
{
public:
  explicit inline VoidCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline VoidCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline VoidCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "VoidCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return HandleEvent(s.GetContext(), thisValJS, aRv);
  }

  inline void
  HandleEvent(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "VoidCallback.handleEvent";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return HandleEvent(s.GetContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  inline void
  HandleEvent(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(thisVal, rv, aExecutionReason);
  }

  inline void
  HandleEvent(const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return HandleEvent(rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const VoidCallback& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  void HandleEvent(JSContext* cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);

  static bool
  InitIds(JSContext* cx, VoidCallbackAtoms* atomsCache);
};


namespace binding_detail {
class FastErrorCallback : public ErrorCallback
{
public:
  explicit inline FastErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : ErrorCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    ErrorCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    ErrorCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastFileSystemEntryCallback : public FileSystemEntryCallback
{
public:
  explicit inline FastFileSystemEntryCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : FileSystemEntryCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    FileSystemEntryCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    FileSystemEntryCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastVoidCallback : public VoidCallback
{
public:
  explicit inline FastVoidCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : VoidCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    VoidCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    VoidCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_FileSystemBinding_h
