/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "ContentPrefs.h"

/************************************************************
 *    DO NOT ADD PREFS TO THIS LIST WITHOUT DOM PEER REVIEW *
 ************************************************************/

const char* mozilla::dom::ContentPrefs::gInitPrefs[] = {
  "accessibility.monoaudio.enable",
  "accessibility.mouse_focuses_formcontrol",
  "accessibility.tabfocus_applies_to_xul",
  "app.update.channel",
  "browser.dom.window.dump.enabled",
  "browser.sessionhistory.max_entries",
  "browser.sessionhistory.max_total_viewers",
  "content.cors.disable",
  "content.cors.no_private_data",
  "content.notify.backoffcount",
  "content.notify.interval",
  "content.notify.ontimer",
  "content.sink.enable_perf_mode",
  "content.sink.event_probe_rate",
  "content.sink.initial_perf_time",
  "content.sink.interactive_deflect_count",
  "content.sink.interactive_parse_time",
  "content.sink.interactive_time",
  "content.sink.pending_event_mode",
  "content.sink.perf_deflect_count",
  "content.sink.perf_parse_time",
  "device.storage.prompt.testing",
  "device.storage.writable.name",
  "dom.allow_XUL_XBL_for_file",
  "dom.allow_cut_copy",
  "dom.enable_frame_timing",
  "dom.enable_performance",
  "dom.enable_resource_timing",
  "dom.event.handling-user-input-time-limit",
  "dom.event.touch.coalescing.enabled",
  "dom.forms.autocomplete.experimental",
  "dom.ipc.processPriorityManager.backgroundGracePeriodMS",
  "dom.ipc.processPriorityManager.backgroundPerceivableGracePeriodMS",
  "dom.max_chrome_script_run_time",
  "dom.max_script_run_time",
  "dom.mozBrowserFramesEnabled",
  "dom.performance.enable_notify_performance_timing",
  "dom.performance.enable_user_timing_logging",
  "dom.storage.testing",
  "dom.url.encode_decode_hash",
  "dom.url.getters_decode_hash",
  "dom.use_watchdog",
  "dom.vibrator.enabled",
  "dom.vibrator.max_vibrate_list_len",
  "dom.vibrator.max_vibrate_ms",
  "dom.webcomponents.enabled",
  "focusmanager.testmode",
  "font.size.inflation.disabledInMasterProcess",
  "font.size.inflation.emPerLine",
  "font.size.inflation.forceEnabled",
  "font.size.inflation.lineThreshold",
  "font.size.inflation.mappingIntercept",
  "font.size.inflation.maxRatio",
  "font.size.inflation.minTwips",
  "full-screen-api.allow-trusted-requests-only",
  "full-screen-api.enabled",
  "full-screen-api.unprefix.enabled",
#ifdef FUZZING
  "fuzzing.enabled",
#endif
  "gfx.font_rendering.opentype_svg.enabled",
  "hangmonitor.timeout",
  "html5.flushtimer.initialdelay",
  "html5.flushtimer.subsequentdelay",
  "html5.offmainthread",
  "intl.charset.fallback.tld",
  "intl.ime.hack.on_ime_unaware_apps.fire_key_events_for_composition",
  "javascript.enabled",
  "javascript.options.asmjs",
  "javascript.options.asyncstack",
  "javascript.options.baselinejit",
  "javascript.options.baselinejit.threshold",
  "javascript.options.baselinejit.unsafe_eager_compilation",
  "javascript.options.discardSystemSource",
  "javascript.options.dump_stack_on_debuggee_would_run",
  "javascript.options.gczeal",
  "javascript.options.gczeal.frequency",
  "javascript.options.ion",
  "javascript.options.ion.offthread_compilation",
  "javascript.options.ion.threshold",
  "javascript.options.ion.unsafe_eager_compilation",
  "javascript.options.jit.full_debug_checks",
  "javascript.options.native_regexp",
  "javascript.options.parallel_parsing",
  "javascript.options.shared_memory",
  "javascript.options.strict",
  "javascript.options.strict.debug",
  "javascript.options.throw_on_asmjs_validation_failure",
  "javascript.options.throw_on_debuggee_would_run",
  "javascript.options.wasm",
  "javascript.options.wasm_baselinejit",
  "javascript.options.werror",
  "javascript.use_us_english_locale",
  "jsloader.reuseGlobal",
  "layout.css.all-shorthand.enabled",
  "layout.css.background-blend-mode.enabled",
  "layout.css.background-clip-text.enabled",
  "layout.css.box-decoration-break.enabled",
  "layout.css.color-adjust.enabled",
  "layout.css.contain.enabled",
  "layout.css.control-characters.visible",
  "layout.css.display-flow-root.enabled",
  "layout.css.expensive-style-struct-assertions.enabled",
  "layout.css.float-logical-values.enabled",
  "layout.css.font-variations.enabled",
  "layout.css.grid.enabled",
  "layout.css.image-orientation.enabled",
  "layout.css.initial-letter.enabled",
  "layout.css.isolation.enabled",
  "layout.css.mix-blend-mode.enabled",
  "layout.css.osx-font-smoothing.enabled",
  "layout.css.overflow-clip-box.enabled",
  "layout.css.prefixes.animations",
  "layout.css.prefixes.border-image",
  "layout.css.prefixes.box-sizing",
  "layout.css.prefixes.device-pixel-ratio-webkit",
  "layout.css.prefixes.font-features",
  "layout.css.prefixes.gradients",
  "layout.css.prefixes.transforms",
  "layout.css.prefixes.transitions",
  "layout.css.prefixes.webkit",
  "layout.css.scope-pseudo.enabled",
  "layout.css.scroll-behavior.property-enabled",
  "layout.css.scroll-snap.enabled",
  "layout.css.servo.enabled",
  "layout.css.shape-outside.enabled",
  "layout.css.text-align-unsafe-value.enabled",
  "layout.css.text-combine-upright-digits.enabled",
  "layout.css.text-combine-upright.enabled",
  "layout.css.text-justify.enabled",
  "layout.css.touch_action.enabled",
  "layout.css.unprefixing-service.enabled",
  "layout.css.unprefixing-service.globally-whitelisted",
  "layout.css.unprefixing-service.include-test-domains",
  "layout.css.variables.enabled",
  "layout.css.visited_links_enabled",
  "layout.idle_period.required_quiescent_frames",
  "layout.idle_period.time_limit",
  "layout.interruptible-reflow.enabled",
  "mathml.disabled",
  "media.apple.forcevda",
  "media.clearkey.persistent-license.enabled",
  "media.cubeb_latency_msg_frames",
  "media.cubeb_latency_playback_ms",
  "media.decoder-doctor.wmf-disabled-is-failure",
  "media.decoder.fuzzing.dont-delay-inputexhausted",
  "media.decoder.fuzzing.enabled",
  "media.decoder.fuzzing.video-output-minimum-interval-ms",
  "media.decoder.limit",
  "media.decoder.recycle.enabled",
  "media.dormant-on-pause-timeout-ms",
  "media.eme.audio.blank",
  "media.eme.enabled",
  "media.eme.video.blank",
  "media.ffmpeg.enabled",
  "media.ffvpx.enabled",
  "media.ffvpx.low-latency.enabled",
  "media.flac.enabled",
  "media.forcestereo.enabled",
  "media.gmp.async-shutdown-timeout",
  "media.gmp.decoder.aac",
  "media.gmp.decoder.enabled",
  "media.gmp.decoder.h264",
  "media.gmp.insecure.allow",
  "media.gpu-process-decoder",
  "media.libavcodec.allow-obsolete",
  "media.num-decode-threads",
  "media.ogg.enabled",
  "media.ogg.flac.enabled",
  "media.resampling.enabled",
  "media.resampling.rate",
  "media.ruin-av-sync.enabled",
  "media.rust.test_mode",
  "media.suspend-bkgnd-video.delay-ms",
  "media.suspend-bkgnd-video.enabled",
  "media.use-blank-decoder",
  "media.video_stats.enabled",
  "media.volume_scale",
  "media.webspeech.recognition.enable",
  "media.webspeech.recognition.force_enable",
  "media.webspeech.synth.force_global_queue",
  "media.webspeech.test.enable",
  "media.webspeech.test.fake_fsm_events",
  "media.webspeech.test.fake_recognition_service",
  "media.wmf.allow-unsupported-resolutions",
  "media.wmf.decoder.thread-count",
  "media.wmf.enabled",
  "media.wmf.skip-blacklist",
  "media.wmf.vp9.enabled",
  "memory.free_dirty_pages",
  "memory.low_commit_space_threshold_mb",
  "memory.low_memory_notification_interval_ms",
  "memory.low_physical_memory_threshold_mb",
  "memory.low_virtual_mem_threshold_mb",
  "network.IDN.blacklist_chars",
  "network.IDN.restriction_profile",
  "network.IDN.use_whitelist",
  "network.IDN_show_punycode",
  "network.buffer.cache.count",
  "network.buffer.cache.size",
  "network.captive-portal-service.enabled",
  "network.cookie.cookieBehavior",
  "network.cookie.lifetimePolicy",
  "network.dns.disablePrefetch",
  "network.dns.disablePrefetchFromHTTPS",
  "network.jar.block-remote-files",
  "network.loadinfo.skip_type_assertion",
  "network.notify.changed",
  "network.offline-mirrors-connectivity",
  "network.protocol-handler.external.jar",
  "network.proxy.type",
  "network.security.ports.banned",
  "network.security.ports.banned.override",
  "network.standard-url.enable-rust",
  "network.standard-url.max-length",
  "network.sts.max_time_for_events_between_two_polls",
  "network.sts.max_time_for_pr_close_during_shutdown",
  "network.tcp.keepalive.enabled",
  "network.tcp.keepalive.idle_time",
  "network.tcp.keepalive.probe_count",
  "network.tcp.keepalive.retry_interval",
  "network.tcp.sendbuffer",
  "nglayout.debug.invalidation",
  "privacy.donottrackheader.enabled",
  "privacy.firstparty.isolate",
  "privacy.firstparty.isolate.restrict_opener_access",
  "privacy.resistFingerprinting",
  "security.data_uri.inherit_security_context",
  "security.fileuri.strict_origin_policy",
  "security.sandbox.content.level",
  "security.sandbox.content.tempDirSuffix",
  "security.sandbox.logging.enabled",
  "security.sandbox.mac.track.violations",
  "security.sandbox.windows.log",
  "security.sandbox.windows.log.stackTraceDepth",
  "shutdown.watchdog.timeoutSecs",
  "signed.applets.codebase_principal_support",
  "svg.disabled",
  "svg.display-lists.hit-testing.enabled",
  "svg.display-lists.painting.enabled",
  "svg.new-getBBox.enabled",
  "svg.paint-order.enabled",
  "svg.path-caching.enabled",
  "svg.transform-box.enabled",
  "toolkit.asyncshutdown.crash_timeout",
  "toolkit.asyncshutdown.log",
  "toolkit.osfile.log",
  "toolkit.osfile.log.redirect",
  "toolkit.telemetry.enabled",
  "toolkit.telemetry.idleTimeout",
  "toolkit.telemetry.initDelay",
  "toolkit.telemetry.log.dump",
  "toolkit.telemetry.log.level",
  "toolkit.telemetry.minSubsessionLength",
  "toolkit.telemetry.scheduler.idleTickInterval",
  "toolkit.telemetry.scheduler.tickInterval",
  "toolkit.telemetry.unified",
  "ui.key.menuAccessKeyFocuses",
  "ui.popup.disable_autohide",
  "ui.use_activity_cursor",
  "view_source.editor.external"};

const char** mozilla::dom::ContentPrefs::GetContentPrefs(size_t* aCount)
{
  *aCount = ArrayLength(ContentPrefs::gInitPrefs);
  return gInitPrefs;
}

const char*  mozilla::dom::ContentPrefs::GetContentPref(size_t aIndex)
{
  MOZ_ASSERT(aIndex < ArrayLength(ContentPrefs::gInitPrefs));
  return gInitPrefs[aIndex];
}

