/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef EMEVideoDecoder_h_
#define EMEVideoDecoder_h_

#include "GMPVideoDecoder.h"

namespace mozilla {

class CDMProxy;
class MediaRawData;
class TaskQueue;

class EMEVideoDecoder : public GMPVideoDecoder
{
public:
  EMEVideoDecoder(CDMProxy* aProxy, const GMPVideoDecoderParams& aParams);

private:
  void InitTags(nsTArray<nsCString>& aTags) override;
  nsCString GetNodeId() override;
  uint32_t DecryptorId() const override { return mDecryptorId; }
  GMPUniquePtr<GMPVideoEncodedFrame>
  CreateFrame(MediaRawData* aSample) override;

  RefPtr<CDMProxy> mProxy;
  uint32_t mDecryptorId;
};

} // namespace mozilla

#endif // EMEVideoDecoder_h_
