/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_gfx_layers_d3d11_HelpersD3D11_h
#define mozilla_gfx_layers_d3d11_HelpersD3D11_h

#include <d3d11.h>
#include "mozilla/TimeStamp.h"

namespace mozilla {
namespace layers {

template <typename T> static inline bool
WaitForGPUQuery(ID3D11Device* aDevice, ID3D11DeviceContext* aContext, ID3D11Query* aQuery, T* aOut)
{
  TimeStamp start = TimeStamp::Now();
  while (aContext->GetData(aQuery, aOut, sizeof(*aOut), 0) != S_OK) {
    if (aDevice->GetDeviceRemovedReason() != S_OK) {
      return false;
    }
    if (TimeStamp::Now() - start > TimeDuration::FromSeconds(2)) {
      return false;
    }
    Sleep(0);
  }
  return true;
}

} // namespace layers
} // namespace gfx

#endif // mozilla_gfx_layers_d3d11_HelpersD3D11_h
