/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#include "./aom_config.h"
#include "aom/aom_integer.h"
#include "aom_mem/aom_mem.h"
#include "av1/common/blockd.h"
#include "av1/common/entropy.h"
#include "av1/common/entropymode.h"
#include "av1/common/onyxc_int.h"
#include "av1/common/scan.h"
#if CONFIG_Q_ADAPT_PROBS
#include "av1/common/token_cdfs.h"
#endif  // CONFIG_Q_ADAPT_PROBS
#if CONFIG_LV_MAP
#include "av1/common/txb_common.h"
#endif

// Unconstrained Node Tree
/* clang-format off */
const aom_tree_index av1_coef_con_tree[TREE_SIZE(ENTROPY_TOKENS)] = {
  2, 6,                                // 0 = LOW_VAL
  -TWO_TOKEN, 4,                       // 1 = TWO
  -THREE_TOKEN, -FOUR_TOKEN,           // 2 = THREE
  8, 10,                               // 3 = HIGH_LOW
  -CATEGORY1_TOKEN, -CATEGORY2_TOKEN,  // 4 = CAT_ONE
  12, 14,                              // 5 = CAT_THREEFOUR
  -CATEGORY3_TOKEN, -CATEGORY4_TOKEN,  // 6 = CAT_THREE
  -CATEGORY5_TOKEN, -CATEGORY6_TOKEN   // 7 = CAT_FIVE
};
/* clang-format on */

#if CONFIG_NEW_MULTISYMBOL
/* Extra bits coded from LSB to MSB */
const aom_cdf_prob av1_cat1_cdf0[CDF_SIZE(2)] = { AOM_ICDF(20352),
                                                  AOM_ICDF(32768), 0 };
const aom_cdf_prob *av1_cat1_cdf[] = { av1_cat1_cdf0 };

const aom_cdf_prob av1_cat2_cdf0[CDF_SIZE(4)] = {
  AOM_ICDF(11963), AOM_ICDF(21121), AOM_ICDF(27719), AOM_ICDF(32768), 0
};
const aom_cdf_prob *av1_cat2_cdf[] = { av1_cat2_cdf0 };
const aom_cdf_prob av1_cat3_cdf0[CDF_SIZE(8)] = {
  AOM_ICDF(7001),  AOM_ICDF(12802), AOM_ICDF(17911),
  AOM_ICDF(22144), AOM_ICDF(25503), AOM_ICDF(28286),
  AOM_ICDF(30737), AOM_ICDF(32768), 0
};
const aom_cdf_prob *av1_cat3_cdf[] = { av1_cat3_cdf0 };

const aom_cdf_prob av1_cat4_cdf0[CDF_SIZE(16)] = { AOM_ICDF(3934),
                                                   AOM_ICDF(7460),
                                                   AOM_ICDF(10719),
                                                   AOM_ICDF(13640),
                                                   AOM_ICDF(16203),
                                                   AOM_ICDF(18500),
                                                   AOM_ICDF(20624),
                                                   AOM_ICDF(22528),
                                                   AOM_ICDF(24316),
                                                   AOM_ICDF(25919),
                                                   AOM_ICDF(27401),
                                                   AOM_ICDF(28729),
                                                   AOM_ICDF(29894),
                                                   AOM_ICDF(30938),
                                                   AOM_ICDF(31903),
                                                   AOM_ICDF(32768),
                                                   0 };
const aom_cdf_prob *av1_cat4_cdf[] = { av1_cat4_cdf0 };

const aom_cdf_prob av1_cat5_cdf0[CDF_SIZE(16)] = { AOM_ICDF(2942),
                                                   AOM_ICDF(5794),
                                                   AOM_ICDF(8473),
                                                   AOM_ICDF(11069),
                                                   AOM_ICDF(13469),
                                                   AOM_ICDF(15795),
                                                   AOM_ICDF(17980),
                                                   AOM_ICDF(20097),
                                                   AOM_ICDF(21952),
                                                   AOM_ICDF(23750),
                                                   AOM_ICDF(25439),
                                                   AOM_ICDF(27076),
                                                   AOM_ICDF(28589),
                                                   AOM_ICDF(30056),
                                                   AOM_ICDF(31434),
                                                   AOM_ICDF(32768),
                                                   0 };
const aom_cdf_prob av1_cat5_cdf1[CDF_SIZE(2)] = { AOM_ICDF(23040),
                                                  AOM_ICDF(32768), 0 };
const aom_cdf_prob *av1_cat5_cdf[] = { av1_cat5_cdf0, av1_cat5_cdf1 };

const aom_cdf_prob av1_cat6_cdf0[CDF_SIZE(16)] = {
  AOM_ICDF(2382),  AOM_ICDF(4727),  AOM_ICDF(7036),  AOM_ICDF(9309),
  AOM_ICDF(11512), AOM_ICDF(13681), AOM_ICDF(15816), AOM_ICDF(17918),
  AOM_ICDF(19892), AOM_ICDF(21835), AOM_ICDF(23748), AOM_ICDF(25632),
  AOM_ICDF(27458), AOM_ICDF(29255), AOM_ICDF(31024), AOM_ICDF(32768)
};
const aom_cdf_prob av1_cat6_cdf1[CDF_SIZE(16)] = {
  AOM_ICDF(9314),  AOM_ICDF(15584), AOM_ICDF(19741), AOM_ICDF(22540),
  AOM_ICDF(25391), AOM_ICDF(27310), AOM_ICDF(28583), AOM_ICDF(29440),
  AOM_ICDF(30493), AOM_ICDF(31202), AOM_ICDF(31672), AOM_ICDF(31988),
  AOM_ICDF(32310), AOM_ICDF(32527), AOM_ICDF(32671), AOM_ICDF(32768)
};
const aom_cdf_prob av1_cat6_cdf2[CDF_SIZE(16)] = {
  AOM_ICDF(29548), AOM_ICDF(31129), AOM_ICDF(31960), AOM_ICDF(32004),
  AOM_ICDF(32473), AOM_ICDF(32498), AOM_ICDF(32511), AOM_ICDF(32512),
  AOM_ICDF(32745), AOM_ICDF(32757), AOM_ICDF(32763), AOM_ICDF(32764),
  AOM_ICDF(32765), AOM_ICDF(32766), AOM_ICDF(32767), AOM_ICDF(32768)
};
const aom_cdf_prob av1_cat6_cdf3[CDF_SIZE(16)] = {
  AOM_ICDF(32006), AOM_ICDF(32258), AOM_ICDF(32510), AOM_ICDF(32512),
  AOM_ICDF(32638), AOM_ICDF(32639), AOM_ICDF(32640), AOM_ICDF(32641),
  AOM_ICDF(32761), AOM_ICDF(32762), AOM_ICDF(32763), AOM_ICDF(32764),
  AOM_ICDF(32765), AOM_ICDF(32766), AOM_ICDF(32767), AOM_ICDF(32768)
};
const aom_cdf_prob av1_cat6_cdf4[CDF_SIZE(4)] = {
  AOM_ICDF(32513), AOM_ICDF(32641), AOM_ICDF(32767), AOM_ICDF(32768)
};
const aom_cdf_prob *av1_cat6_cdf[] = {
  av1_cat6_cdf0, av1_cat6_cdf1, av1_cat6_cdf2, av1_cat6_cdf3, av1_cat6_cdf4
};
#endif
/* Extra bits coded from MSB to LSB */
const aom_prob av1_cat1_prob[] = { 159 };
const aom_prob av1_cat2_prob[] = { 165, 145 };
const aom_prob av1_cat3_prob[] = { 173, 148, 140 };
const aom_prob av1_cat4_prob[] = { 176, 155, 140, 135 };
const aom_prob av1_cat5_prob[] = { 180, 157, 141, 134, 130 };
const aom_prob av1_cat6_prob[] = {
  255, 255, 255, 255, 254, 254, 254, 252, 249,
  243, 230, 196, 177, 153, 140, 133, 130, 129
};

const uint16_t band_count_table[TX_SIZES_ALL][8] = {
#if CONFIG_CHROMA_2X2
  { 1, 2, 2, 3, 0, 0, 0 },
#endif
  { 1, 2, 3, 4, 3, 16 - 13, 0 },    { 1, 2, 3, 4, 11, 64 - 21, 0 },
  { 1, 2, 3, 4, 11, 256 - 21, 0 },  { 1, 2, 3, 4, 11, 1024 - 21, 0 },
#if CONFIG_TX64X64
  { 1, 2, 3, 4, 11, 4096 - 21, 0 },
#endif  // CONFIG_TX64X64
  { 1, 2, 3, 4, 8, 32 - 18, 0 },    { 1, 2, 3, 4, 8, 32 - 18, 0 },
  { 1, 2, 3, 4, 11, 128 - 21, 0 },  { 1, 2, 3, 4, 11, 128 - 21, 0 },
  { 1, 2, 3, 4, 11, 512 - 21, 0 },  { 1, 2, 3, 4, 11, 512 - 21, 0 },
#if CONFIG_TX64X64
  { 1, 2, 3, 4, 11, 2048 - 21, 0 }, { 1, 2, 3, 4, 11, 2048 - 21, 0 },
#endif  // CONFIG_TX64X64
  { 1, 2, 3, 4, 11, 64 - 21, 0 },   { 1, 2, 3, 4, 11, 64 - 21, 0 },
  { 1, 2, 3, 4, 11, 256 - 21, 0 },  { 1, 2, 3, 4, 11, 256 - 21, 0 },
};

const uint16_t band_cum_count_table[TX_SIZES_ALL][8] = {
#if CONFIG_CHROMA_2X2
  { 0, 1, 3, 6, 10, 13, 16, 0 },
#endif
  { 0, 1, 3, 6, 10, 13, 16, 0 },   { 0, 1, 3, 6, 10, 21, 64, 0 },
  { 0, 1, 3, 6, 10, 21, 256, 0 },  { 0, 1, 3, 6, 10, 21, 1024, 0 },
#if CONFIG_TX64X64
  { 0, 1, 3, 6, 10, 21, 4096, 0 },
#endif  // CONFIG_TX64X64
  { 0, 1, 3, 6, 10, 18, 32, 0 },   { 0, 1, 3, 6, 10, 18, 32, 0 },
  { 0, 1, 3, 6, 10, 21, 128, 0 },  { 0, 1, 3, 6, 10, 21, 128, 0 },
  { 0, 1, 3, 6, 10, 21, 512, 0 },  { 0, 1, 3, 6, 10, 21, 512, 0 },
#if CONFIG_TX64X64
  { 0, 1, 3, 6, 10, 21, 2048, 0 }, { 0, 1, 3, 6, 10, 21, 2048, 0 },
#endif  // CONFIG_TX64X64
  { 0, 1, 3, 6, 10, 21, 64, 0 },   { 0, 1, 3, 6, 10, 21, 64, 0 },
  { 0, 1, 3, 6, 10, 21, 256, 0 },  { 0, 1, 3, 6, 10, 21, 256, 0 },
};

const uint8_t av1_coefband_trans_8x8plus[MAX_TX_SQUARE] = {
  0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5,
  // beyond MAXBAND_INDEX+1 all values are filled as 5
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
#if CONFIG_TX64X64
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5
#endif  // CONFIG_TX64X64
};

const uint8_t av1_coefband_trans_4x8_8x4[32] = {
  0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
  4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
};

const uint8_t av1_coefband_trans_4x4[16] = {
  0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5,
};

const uint8_t av1_pt_energy_class[ENTROPY_TOKENS] = { 0, 1, 2, 3, 3, 4,
                                                      4, 5, 5, 5, 5, 5 };

// Model obtained from a 2-sided zero-centered distribution derived
// from a Pareto distribution. The cdf of the distribution is:
// cdf(x) = 0.5 + 0.5 * sgn(x) * [1 - {alpha/(alpha + |x|)} ^ beta]
//
// For a given beta and a given probablity of the 1-node, the alpha
// is first solved, and then the {alpha, beta} pair is used to generate
// the probabilities for the rest of the nodes.

// beta = 8

// Every odd line in this table can be generated from the even lines
// by averaging :
// av1_pareto8_full[l][node] = (av1_pareto8_full[l-1][node] +
//                              av1_pareto8_full[l+1][node] ) >> 1;
// Values for tokens ONE_TOKEN through CATEGORY6_TOKEN included here.
const aom_prob av1_pareto8_full[COEFF_PROB_MODELS][MODEL_NODES] = {
  { 3, 86, 128, 6, 86, 23, 88, 29 },
  { 6, 86, 128, 11, 87, 42, 91, 52 },
  { 9, 86, 129, 17, 88, 61, 94, 76 },
  { 12, 86, 129, 22, 88, 77, 97, 93 },
  { 15, 87, 129, 28, 89, 93, 100, 110 },
  { 17, 87, 129, 33, 90, 105, 103, 123 },
  { 20, 88, 130, 38, 91, 118, 106, 136 },
  { 23, 88, 130, 43, 91, 128, 108, 146 },
  { 26, 89, 131, 48, 92, 139, 111, 156 },
  { 28, 89, 131, 53, 93, 147, 114, 163 },
  { 31, 90, 131, 58, 94, 156, 117, 171 },
  { 34, 90, 131, 62, 94, 163, 119, 177 },
  { 37, 90, 132, 66, 95, 171, 122, 184 },
  { 39, 90, 132, 70, 96, 177, 124, 189 },
  { 42, 91, 132, 75, 97, 183, 127, 194 },
  { 44, 91, 132, 79, 97, 188, 129, 198 },
  { 47, 92, 133, 83, 98, 193, 132, 202 },
  { 49, 92, 133, 86, 99, 197, 134, 205 },
  { 52, 93, 133, 90, 100, 201, 137, 208 },
  { 54, 93, 133, 94, 100, 204, 139, 211 },
  { 57, 94, 134, 98, 101, 208, 142, 214 },
  { 59, 94, 134, 101, 102, 211, 144, 216 },
  { 62, 94, 135, 105, 103, 214, 146, 218 },
  { 64, 94, 135, 108, 103, 216, 148, 220 },
  { 66, 95, 135, 111, 104, 219, 151, 222 },
  { 68, 95, 135, 114, 105, 221, 153, 223 },
  { 71, 96, 136, 117, 106, 224, 155, 225 },
  { 73, 96, 136, 120, 106, 225, 157, 226 },
  { 76, 97, 136, 123, 107, 227, 159, 228 },
  { 78, 97, 136, 126, 108, 229, 160, 229 },
  { 80, 98, 137, 129, 109, 231, 162, 231 },
  { 82, 98, 137, 131, 109, 232, 164, 232 },
  { 84, 98, 138, 134, 110, 234, 166, 233 },
  { 86, 98, 138, 137, 111, 235, 168, 234 },
  { 89, 99, 138, 140, 112, 236, 170, 235 },
  { 91, 99, 138, 142, 112, 237, 171, 235 },
  { 93, 100, 139, 145, 113, 238, 173, 236 },
  { 95, 100, 139, 147, 114, 239, 174, 237 },
  { 97, 101, 140, 149, 115, 240, 176, 238 },
  { 99, 101, 140, 151, 115, 241, 177, 238 },
  { 101, 102, 140, 154, 116, 242, 179, 239 },
  { 103, 102, 140, 156, 117, 242, 180, 239 },
  { 105, 103, 141, 158, 118, 243, 182, 240 },
  { 107, 103, 141, 160, 118, 243, 183, 240 },
  { 109, 104, 141, 162, 119, 244, 185, 241 },
  { 111, 104, 141, 164, 119, 244, 186, 241 },
  { 113, 104, 142, 166, 120, 245, 187, 242 },
  { 114, 104, 142, 168, 121, 245, 188, 242 },
  { 116, 105, 143, 170, 122, 246, 190, 243 },
  { 118, 105, 143, 171, 122, 246, 191, 243 },
  { 120, 106, 143, 173, 123, 247, 192, 244 },
  { 121, 106, 143, 175, 124, 247, 193, 244 },
  { 123, 107, 144, 177, 125, 248, 195, 244 },
  { 125, 107, 144, 178, 125, 248, 196, 244 },
  { 127, 108, 145, 180, 126, 249, 197, 245 },
  { 128, 108, 145, 181, 127, 249, 198, 245 },
  { 130, 109, 145, 183, 128, 249, 199, 245 },
  { 132, 109, 145, 184, 128, 249, 200, 245 },
  { 134, 110, 146, 186, 129, 250, 201, 246 },
  { 135, 110, 146, 187, 130, 250, 202, 246 },
  { 137, 111, 147, 189, 131, 251, 203, 246 },
  { 138, 111, 147, 190, 131, 251, 204, 246 },
  { 140, 112, 147, 192, 132, 251, 205, 247 },
  { 141, 112, 147, 193, 132, 251, 206, 247 },
  { 143, 113, 148, 194, 133, 251, 207, 247 },
  { 144, 113, 148, 195, 134, 251, 207, 247 },
  { 146, 114, 149, 197, 135, 252, 208, 248 },
  { 147, 114, 149, 198, 135, 252, 209, 248 },
  { 149, 115, 149, 199, 136, 252, 210, 248 },
  { 150, 115, 149, 200, 137, 252, 210, 248 },
  { 152, 115, 150, 201, 138, 252, 211, 248 },
  { 153, 115, 150, 202, 138, 252, 212, 248 },
  { 155, 116, 151, 204, 139, 253, 213, 249 },
  { 156, 116, 151, 205, 139, 253, 213, 249 },
  { 158, 117, 151, 206, 140, 253, 214, 249 },
  { 159, 117, 151, 207, 141, 253, 215, 249 },
  { 161, 118, 152, 208, 142, 253, 216, 249 },
  { 162, 118, 152, 209, 142, 253, 216, 249 },
  { 163, 119, 153, 210, 143, 253, 217, 249 },
  { 164, 119, 153, 211, 143, 253, 217, 249 },
  { 166, 120, 153, 212, 144, 254, 218, 250 },
  { 167, 120, 153, 212, 145, 254, 219, 250 },
  { 168, 121, 154, 213, 146, 254, 220, 250 },
  { 169, 121, 154, 214, 146, 254, 220, 250 },
  { 171, 122, 155, 215, 147, 254, 221, 250 },
  { 172, 122, 155, 216, 147, 254, 221, 250 },
  { 173, 123, 155, 217, 148, 254, 222, 250 },
  { 174, 123, 155, 217, 149, 254, 222, 250 },
  { 176, 124, 156, 218, 150, 254, 223, 250 },
  { 177, 124, 156, 219, 150, 254, 223, 250 },
  { 178, 125, 157, 220, 151, 254, 224, 251 },
  { 179, 125, 157, 220, 151, 254, 224, 251 },
  { 180, 126, 157, 221, 152, 254, 225, 251 },
  { 181, 126, 157, 221, 152, 254, 225, 251 },
  { 183, 127, 158, 222, 153, 254, 226, 251 },
  { 184, 127, 158, 223, 154, 254, 226, 251 },
  { 185, 128, 159, 224, 155, 255, 227, 251 },
  { 186, 128, 159, 224, 155, 255, 227, 251 },
  { 187, 129, 160, 225, 156, 255, 228, 251 },
  { 188, 130, 160, 225, 156, 255, 228, 251 },
  { 189, 131, 160, 226, 157, 255, 228, 251 },
  { 190, 131, 160, 226, 158, 255, 228, 251 },
  { 191, 132, 161, 227, 159, 255, 229, 251 },
  { 192, 132, 161, 227, 159, 255, 229, 251 },
  { 193, 133, 162, 228, 160, 255, 230, 252 },
  { 194, 133, 162, 229, 160, 255, 230, 252 },
  { 195, 134, 163, 230, 161, 255, 231, 252 },
  { 196, 134, 163, 230, 161, 255, 231, 252 },
  { 197, 135, 163, 231, 162, 255, 231, 252 },
  { 198, 135, 163, 231, 162, 255, 231, 252 },
  { 199, 136, 164, 232, 163, 255, 232, 252 },
  { 200, 136, 164, 232, 164, 255, 232, 252 },
  { 201, 137, 165, 233, 165, 255, 233, 252 },
  { 201, 137, 165, 233, 165, 255, 233, 252 },
  { 202, 138, 166, 233, 166, 255, 233, 252 },
  { 203, 138, 166, 233, 166, 255, 233, 252 },
  { 204, 139, 166, 234, 167, 255, 234, 252 },
  { 205, 139, 166, 234, 167, 255, 234, 252 },
  { 206, 140, 167, 235, 168, 255, 235, 252 },
  { 206, 140, 167, 235, 168, 255, 235, 252 },
  { 207, 141, 168, 236, 169, 255, 235, 252 },
  { 208, 141, 168, 236, 170, 255, 235, 252 },
  { 209, 142, 169, 237, 171, 255, 236, 252 },
  { 209, 143, 169, 237, 171, 255, 236, 252 },
  { 210, 144, 169, 237, 172, 255, 236, 252 },
  { 211, 144, 169, 237, 172, 255, 236, 252 },
  { 212, 145, 170, 238, 173, 255, 237, 252 },
  { 213, 145, 170, 238, 173, 255, 237, 252 },
  { 214, 146, 171, 239, 174, 255, 237, 253 },
  { 214, 146, 171, 239, 174, 255, 237, 253 },
  { 215, 147, 172, 240, 175, 255, 238, 253 },
  { 215, 147, 172, 240, 175, 255, 238, 253 },
  { 216, 148, 173, 240, 176, 255, 238, 253 },
  { 217, 148, 173, 240, 176, 255, 238, 253 },
  { 218, 149, 173, 241, 177, 255, 239, 253 },
  { 218, 149, 173, 241, 178, 255, 239, 253 },
  { 219, 150, 174, 241, 179, 255, 239, 253 },
  { 219, 151, 174, 241, 179, 255, 239, 253 },
  { 220, 152, 175, 242, 180, 255, 240, 253 },
  { 221, 152, 175, 242, 180, 255, 240, 253 },
  { 222, 153, 176, 242, 181, 255, 240, 253 },
  { 222, 153, 176, 242, 181, 255, 240, 253 },
  { 223, 154, 177, 243, 182, 255, 240, 253 },
  { 223, 154, 177, 243, 182, 255, 240, 253 },
  { 224, 155, 178, 244, 183, 255, 241, 253 },
  { 224, 155, 178, 244, 183, 255, 241, 253 },
  { 225, 156, 178, 244, 184, 255, 241, 253 },
  { 225, 157, 178, 244, 184, 255, 241, 253 },
  { 226, 158, 179, 244, 185, 255, 242, 253 },
  { 227, 158, 179, 244, 185, 255, 242, 253 },
  { 228, 159, 180, 245, 186, 255, 242, 253 },
  { 228, 159, 180, 245, 186, 255, 242, 253 },
  { 229, 160, 181, 245, 187, 255, 242, 253 },
  { 229, 160, 181, 245, 187, 255, 242, 253 },
  { 230, 161, 182, 246, 188, 255, 243, 253 },
  { 230, 162, 182, 246, 188, 255, 243, 253 },
  { 231, 163, 183, 246, 189, 255, 243, 253 },
  { 231, 163, 183, 246, 189, 255, 243, 253 },
  { 232, 164, 184, 247, 190, 255, 243, 253 },
  { 232, 164, 184, 247, 190, 255, 243, 253 },
  { 233, 165, 185, 247, 191, 255, 244, 253 },
  { 233, 165, 185, 247, 191, 255, 244, 253 },
  { 234, 166, 185, 247, 192, 255, 244, 253 },
  { 234, 167, 185, 247, 192, 255, 244, 253 },
  { 235, 168, 186, 248, 193, 255, 244, 253 },
  { 235, 168, 186, 248, 193, 255, 244, 253 },
  { 236, 169, 187, 248, 194, 255, 244, 253 },
  { 236, 169, 187, 248, 194, 255, 244, 253 },
  { 236, 170, 188, 248, 195, 255, 245, 253 },
  { 236, 170, 188, 248, 195, 255, 245, 253 },
  { 237, 171, 189, 249, 196, 255, 245, 254 },
  { 237, 172, 189, 249, 196, 255, 245, 254 },
  { 238, 173, 190, 249, 197, 255, 245, 254 },
  { 238, 173, 190, 249, 197, 255, 245, 254 },
  { 239, 174, 191, 249, 198, 255, 245, 254 },
  { 239, 174, 191, 249, 198, 255, 245, 254 },
  { 240, 175, 192, 249, 199, 255, 246, 254 },
  { 240, 176, 192, 249, 199, 255, 246, 254 },
  { 240, 177, 193, 250, 200, 255, 246, 254 },
  { 240, 177, 193, 250, 200, 255, 246, 254 },
  { 241, 178, 194, 250, 201, 255, 246, 254 },
  { 241, 178, 194, 250, 201, 255, 246, 254 },
  { 242, 179, 195, 250, 202, 255, 246, 254 },
  { 242, 180, 195, 250, 202, 255, 246, 254 },
  { 242, 181, 196, 250, 203, 255, 247, 254 },
  { 242, 181, 196, 250, 203, 255, 247, 254 },
  { 243, 182, 197, 251, 204, 255, 247, 254 },
  { 243, 183, 197, 251, 204, 255, 247, 254 },
  { 244, 184, 198, 251, 205, 255, 247, 254 },
  { 244, 184, 198, 251, 205, 255, 247, 254 },
  { 244, 185, 199, 251, 206, 255, 247, 254 },
  { 244, 185, 199, 251, 206, 255, 247, 254 },
  { 245, 186, 200, 251, 207, 255, 247, 254 },
  { 245, 187, 200, 251, 207, 255, 247, 254 },
  { 246, 188, 201, 252, 207, 255, 248, 254 },
  { 246, 188, 201, 252, 207, 255, 248, 254 },
  { 246, 189, 202, 252, 208, 255, 248, 254 },
  { 246, 190, 202, 252, 208, 255, 248, 254 },
  { 247, 191, 203, 252, 209, 255, 248, 254 },
  { 247, 191, 203, 252, 209, 255, 248, 254 },
  { 247, 192, 204, 252, 210, 255, 248, 254 },
  { 247, 193, 204, 252, 210, 255, 248, 254 },
  { 248, 194, 205, 252, 211, 255, 248, 254 },
  { 248, 194, 205, 252, 211, 255, 248, 254 },
  { 248, 195, 206, 252, 212, 255, 249, 254 },
  { 248, 196, 206, 252, 212, 255, 249, 254 },
  { 249, 197, 207, 253, 213, 255, 249, 254 },
  { 249, 197, 207, 253, 213, 255, 249, 254 },
  { 249, 198, 208, 253, 214, 255, 249, 254 },
  { 249, 199, 209, 253, 214, 255, 249, 254 },
  { 250, 200, 210, 253, 215, 255, 249, 254 },
  { 250, 200, 210, 253, 215, 255, 249, 254 },
  { 250, 201, 211, 253, 215, 255, 249, 254 },
  { 250, 202, 211, 253, 215, 255, 249, 254 },
  { 250, 203, 212, 253, 216, 255, 249, 254 },
  { 250, 203, 212, 253, 216, 255, 249, 254 },
  { 251, 204, 213, 253, 217, 255, 250, 254 },
  { 251, 205, 213, 253, 217, 255, 250, 254 },
  { 251, 206, 214, 254, 218, 255, 250, 254 },
  { 251, 206, 215, 254, 218, 255, 250, 254 },
  { 252, 207, 216, 254, 219, 255, 250, 254 },
  { 252, 208, 216, 254, 219, 255, 250, 254 },
  { 252, 209, 217, 254, 220, 255, 250, 254 },
  { 252, 210, 217, 254, 220, 255, 250, 254 },
  { 252, 211, 218, 254, 221, 255, 250, 254 },
  { 252, 212, 218, 254, 221, 255, 250, 254 },
  { 253, 213, 219, 254, 222, 255, 250, 254 },
  { 253, 213, 220, 254, 222, 255, 250, 254 },
  { 253, 214, 221, 254, 223, 255, 250, 254 },
  { 253, 215, 221, 254, 223, 255, 250, 254 },
  { 253, 216, 222, 254, 224, 255, 251, 254 },
  { 253, 217, 223, 254, 224, 255, 251, 254 },
  { 253, 218, 224, 254, 225, 255, 251, 254 },
  { 253, 219, 224, 254, 225, 255, 251, 254 },
  { 254, 220, 225, 254, 225, 255, 251, 254 },
  { 254, 221, 226, 254, 225, 255, 251, 254 },
  { 254, 222, 227, 255, 226, 255, 251, 254 },
  { 254, 223, 227, 255, 226, 255, 251, 254 },
  { 254, 224, 228, 255, 227, 255, 251, 254 },
  { 254, 225, 229, 255, 227, 255, 251, 254 },
  { 254, 226, 230, 255, 228, 255, 251, 254 },
  { 254, 227, 230, 255, 229, 255, 251, 254 },
  { 255, 228, 231, 255, 230, 255, 251, 254 },
  { 255, 229, 232, 255, 230, 255, 251, 254 },
  { 255, 230, 233, 255, 231, 255, 252, 254 },
  { 255, 231, 234, 255, 231, 255, 252, 254 },
  { 255, 232, 235, 255, 232, 255, 252, 254 },
  { 255, 233, 236, 255, 232, 255, 252, 254 },
  { 255, 235, 237, 255, 233, 255, 252, 254 },
  { 255, 236, 238, 255, 234, 255, 252, 254 },
  { 255, 238, 240, 255, 235, 255, 252, 255 },
  { 255, 239, 241, 255, 235, 255, 252, 254 },
  { 255, 241, 243, 255, 236, 255, 252, 254 },
  { 255, 243, 245, 255, 237, 255, 252, 254 },
  { 255, 246, 247, 255, 239, 255, 253, 255 },
};

// Model obtained from a 2-sided zero-centered distribution derived
// from a Pareto distribution. The cdf of the distribution is:
// cdf(x) = 0.5 + 0.5 * sgn(x) * [1 - {alpha/(alpha + |x|)} ^ beta]
//
// For a given beta and a given probability of the 1-node, the alpha
// is first solved, and then the {alpha, beta} pair is used to generate
// the probabilities for the rest of the nodes.
//
// The full source code of the generating program is available in:
// tools/gen_constrained_tokenset.py
//
// Values for tokens TWO_TOKEN through CATEGORY6_TOKEN included
// in the table here : the ONE_TOKEN probability is
// removed and the probabilities rescaled.
//
// ZERO_TOKEN and ONE_TOKEN are coded as one CDF,
// and EOB_TOKEN is coded as flags outside this coder.
const aom_cdf_prob av1_pareto8_tail_probs[COEFF_PROB_MODELS][TAIL_NODES] = {
  { 128, 127, 127, 252, 497, 969, 1839, 3318, 25511 },
  { 256, 254, 251, 496, 966, 1834, 3308, 5408, 19995 },
  { 383, 378, 373, 732, 1408, 2605, 4470, 6646, 15773 },
  { 511, 502, 493, 961, 1824, 3289, 5373, 7298, 12517 },
  { 638, 625, 611, 1182, 2215, 3894, 6064, 7548, 9991 },
  { 766, 746, 726, 1396, 2582, 4428, 6578, 7529, 8017 },
  { 893, 866, 839, 1603, 2927, 4896, 6945, 7332, 6467 },
  { 1020, 984, 950, 1803, 3250, 5305, 7191, 7022, 5243 },
  { 1147, 1102, 1059, 1996, 3552, 5659, 7338, 6646, 4269 },
  { 1274, 1218, 1166, 2183, 3835, 5963, 7403, 6234, 3492 },
  { 1400, 1334, 1270, 2363, 4099, 6223, 7401, 5809, 2869 },
  { 1527, 1447, 1372, 2537, 4345, 6442, 7346, 5386, 2366 },
  { 1654, 1560, 1473, 2704, 4574, 6624, 7247, 4973, 1959 },
  { 1780, 1672, 1571, 2866, 4787, 6771, 7114, 4579, 1628 },
  { 1906, 1782, 1667, 3022, 4984, 6889, 6954, 4206, 1358 },
  { 2032, 1891, 1762, 3172, 5167, 6979, 6773, 3856, 1136 },
  { 2158, 2000, 1854, 3316, 5335, 7044, 6577, 3530, 954 },
  { 2284, 2106, 1944, 3455, 5490, 7087, 6370, 3229, 803 },
  { 2410, 2212, 2032, 3588, 5632, 7109, 6155, 2951, 679 },
  { 2535, 2317, 2119, 3717, 5761, 7113, 5936, 2695, 575 },
  { 2661, 2420, 2203, 3840, 5880, 7101, 5714, 2461, 488 },
  { 2786, 2522, 2286, 3958, 5987, 7074, 5493, 2246, 416 },
  { 2911, 2624, 2367, 4072, 6083, 7033, 5273, 2050, 355 },
  { 3037, 2724, 2446, 4180, 6170, 6981, 5055, 1871, 304 },
  { 3162, 2822, 2523, 4284, 6247, 6919, 4842, 1708, 261 },
  { 3286, 2920, 2599, 4384, 6315, 6848, 4633, 1559, 224 },
  { 3411, 3017, 2672, 4478, 6374, 6768, 4430, 1424, 194 },
  { 3536, 3112, 2745, 4569, 6426, 6681, 4232, 1300, 167 },
  { 3660, 3207, 2815, 4656, 6469, 6588, 4040, 1188, 145 },
  { 3785, 3300, 2883, 4738, 6505, 6490, 3855, 1086, 126 },
  { 3909, 3392, 2950, 4817, 6534, 6387, 3677, 993, 109 },
  { 4033, 3483, 3015, 4891, 6557, 6281, 3505, 908, 95 },
  { 4157, 3573, 3079, 4962, 6573, 6170, 3340, 831, 83 },
  { 4281, 3662, 3141, 5029, 6584, 6058, 3181, 760, 72 },
  { 4405, 3750, 3201, 5093, 6588, 5943, 3029, 696, 63 },
  { 4529, 3837, 3260, 5152, 6587, 5826, 2883, 638, 56 },
  { 4652, 3922, 3317, 5209, 6582, 5709, 2744, 584, 49 },
  { 4775, 4007, 3373, 5262, 6572, 5590, 2610, 536, 43 },
  { 4899, 4090, 3427, 5312, 6557, 5470, 2483, 492, 38 },
  { 5022, 4173, 3480, 5359, 6538, 5351, 2361, 451, 33 },
  { 5145, 4254, 3531, 5403, 6515, 5231, 2246, 414, 29 },
  { 5268, 4334, 3581, 5443, 6489, 5112, 2135, 380, 26 },
  { 5391, 4414, 3629, 5481, 6458, 4993, 2029, 350, 23 },
  { 5514, 4492, 3676, 5515, 6425, 4875, 1929, 321, 21 },
  { 5637, 4569, 3721, 5548, 6388, 4758, 1833, 296, 18 },
  { 5759, 4645, 3766, 5577, 6349, 4642, 1742, 272, 16 },
  { 5881, 4720, 3808, 5604, 6307, 4528, 1656, 250, 14 },
  { 6004, 4794, 3849, 5628, 6262, 4414, 1573, 231, 13 },
  { 6126, 4867, 3890, 5649, 6215, 4302, 1495, 213, 11 },
  { 6248, 4939, 3928, 5669, 6166, 4192, 1420, 196, 10 },
  { 6370, 5010, 3966, 5686, 6114, 4083, 1349, 181, 9 },
  { 6492, 5080, 4002, 5700, 6061, 3976, 1282, 167, 8 },
  { 6614, 5149, 4037, 5712, 6006, 3871, 1218, 154, 7 },
  { 6735, 5217, 4070, 5723, 5950, 3767, 1157, 142, 7 },
  { 6857, 5284, 4103, 5731, 5891, 3666, 1099, 131, 6 },
  { 6978, 5351, 4134, 5737, 5832, 3566, 1044, 121, 5 },
  { 7099, 5415, 4164, 5741, 5771, 3469, 992, 112, 5 },
  { 7221, 5479, 4192, 5743, 5709, 3373, 943, 104, 4 },
  { 7342, 5542, 4220, 5743, 5646, 3279, 896, 96, 4 },
  { 7462, 5604, 4246, 5742, 5583, 3187, 851, 89, 4 },
  { 7584, 5665, 4272, 5739, 5518, 3097, 808, 82, 3 },
  { 7704, 5725, 4296, 5734, 5453, 3009, 768, 76, 3 },
  { 7825, 5784, 4318, 5727, 5386, 2924, 730, 71, 3 },
  { 7945, 5843, 4341, 5719, 5320, 2840, 693, 65, 2 },
  { 8066, 5900, 4361, 5709, 5252, 2758, 659, 61, 2 },
  { 8186, 5956, 4381, 5698, 5185, 2678, 626, 56, 2 },
  { 8306, 6011, 4400, 5685, 5117, 2600, 595, 52, 2 },
  { 8426, 6066, 4418, 5671, 5049, 2523, 565, 48, 2 },
  { 8547, 6119, 4434, 5655, 4981, 2449, 537, 45, 1 },
  { 8666, 6171, 4450, 5638, 4912, 2377, 511, 42, 1 },
  { 8786, 6223, 4465, 5620, 4843, 2306, 485, 39, 1 },
  { 8906, 6274, 4478, 5600, 4775, 2237, 461, 36, 1 },
  { 9025, 6323, 4491, 5580, 4706, 2170, 438, 34, 1 },
  { 9144, 6372, 4503, 5558, 4637, 2105, 417, 31, 1 },
  { 9264, 6420, 4514, 5535, 4568, 2041, 396, 29, 1 },
  { 9383, 6467, 4524, 5511, 4500, 1979, 376, 27, 1 },
  { 9502, 6513, 4532, 5486, 4432, 1919, 358, 25, 1 },
  { 9621, 6558, 4541, 5460, 4364, 1860, 340, 23, 1 },
  { 9740, 6602, 4548, 5433, 4296, 1803, 323, 22, 1 },
  { 9859, 6645, 4554, 5405, 4229, 1748, 307, 20, 1 },
  { 9978, 6688, 4559, 5376, 4161, 1694, 292, 19, 1 },
  { 10096, 6729, 4564, 5347, 4094, 1641, 278, 18, 1 },
  { 10215, 6770, 4568, 5316, 4028, 1590, 264, 16, 1 },
  { 10333, 6809, 4571, 5285, 3962, 1541, 251, 15, 1 },
  { 10452, 6848, 4573, 5253, 3896, 1492, 239, 14, 1 },
  { 10570, 6886, 4574, 5220, 3831, 1446, 227, 13, 1 },
  { 10688, 6923, 4575, 5186, 3767, 1400, 216, 12, 1 },
  { 10806, 6959, 4575, 5152, 3702, 1356, 205, 12, 1 },
  { 10924, 6994, 4574, 5117, 3639, 1313, 195, 11, 1 },
  { 11041, 7029, 4572, 5082, 3576, 1271, 186, 10, 1 },
  { 11159, 7062, 4570, 5046, 3513, 1231, 177, 9, 1 },
  { 11277, 7095, 4566, 5009, 3451, 1192, 168, 9, 1 },
  { 11394, 7127, 4563, 4972, 3390, 1153, 160, 8, 1 },
  { 11512, 7158, 4558, 4934, 3329, 1116, 152, 8, 1 },
  { 11629, 7188, 4553, 4896, 3269, 1080, 145, 7, 1 },
  { 11746, 7217, 4547, 4857, 3210, 1045, 138, 7, 1 },
  { 11864, 7245, 4540, 4818, 3151, 1012, 131, 6, 1 },
  { 11980, 7273, 4533, 4779, 3093, 979, 124, 6, 1 },
  { 12097, 7300, 4525, 4739, 3035, 947, 118, 6, 1 },
  { 12215, 7326, 4516, 4698, 2978, 916, 113, 5, 1 },
  { 12331, 7351, 4507, 4658, 2922, 886, 107, 5, 1 },
  { 12448, 7375, 4497, 4617, 2866, 857, 102, 5, 1 },
  { 12564, 7398, 4487, 4576, 2812, 829, 97, 4, 1 },
  { 12681, 7421, 4476, 4534, 2757, 802, 92, 4, 1 },
  { 12797, 7443, 4464, 4492, 2704, 775, 88, 4, 1 },
  { 12914, 7464, 4452, 4450, 2651, 749, 84, 3, 1 },
  { 13030, 7484, 4439, 4408, 2599, 725, 79, 3, 1 },
  { 13147, 7503, 4426, 4365, 2547, 700, 76, 3, 1 },
  { 13262, 7522, 4412, 4322, 2497, 677, 72, 3, 1 },
  { 13378, 7539, 4398, 4280, 2447, 654, 68, 3, 1 },
  { 13494, 7556, 4383, 4237, 2397, 632, 65, 3, 1 },
  { 13610, 7573, 4368, 4193, 2348, 611, 62, 2, 1 },
  { 13726, 7588, 4352, 4150, 2300, 590, 59, 2, 1 },
  { 13841, 7602, 4335, 4107, 2253, 571, 56, 2, 1 },
  { 13957, 7616, 4318, 4063, 2207, 551, 53, 2, 1 },
  { 14072, 7629, 4301, 4019, 2161, 532, 51, 2, 1 },
  { 14188, 7641, 4283, 3976, 2115, 514, 48, 2, 1 },
  { 14302, 7652, 4265, 3932, 2071, 497, 46, 2, 1 },
  { 14418, 7663, 4246, 3888, 2027, 480, 44, 1, 1 },
  { 14533, 7673, 4227, 3844, 1984, 463, 42, 1, 1 },
  { 14649, 7682, 4207, 3800, 1941, 447, 40, 1, 1 },
  { 14763, 7690, 4187, 3757, 1899, 432, 38, 1, 1 },
  { 14878, 7698, 4166, 3713, 1858, 417, 36, 1, 1 },
  { 14993, 7705, 4146, 3669, 1817, 402, 34, 1, 1 },
  { 15109, 7711, 4124, 3625, 1777, 388, 32, 1, 1 },
  { 15223, 7715, 4103, 3581, 1738, 375, 31, 1, 1 },
  { 15337, 7720, 4081, 3538, 1699, 362, 29, 1, 1 },
  { 15452, 7724, 4058, 3494, 1661, 349, 28, 1, 1 },
  { 15567, 7727, 4035, 3450, 1624, 337, 26, 1, 1 },
  { 15681, 7729, 4012, 3407, 1587, 325, 25, 1, 1 },
  { 15795, 7730, 3989, 3364, 1551, 313, 24, 1, 1 },
  { 15909, 7731, 3965, 3320, 1516, 302, 23, 1, 1 },
  { 16024, 7731, 3940, 3277, 1481, 291, 22, 1, 1 },
  { 16138, 7730, 3916, 3234, 1446, 281, 21, 1, 1 },
  { 16252, 7728, 3891, 3191, 1413, 271, 20, 1, 1 },
  { 16366, 7726, 3866, 3148, 1380, 261, 19, 1, 1 },
  { 16480, 7723, 3840, 3106, 1347, 252, 18, 1, 1 },
  { 16594, 7720, 3814, 3063, 1315, 243, 17, 1, 1 },
  { 16708, 7715, 3788, 3021, 1284, 234, 16, 1, 1 },
  { 16822, 7710, 3762, 2979, 1253, 225, 15, 1, 1 },
  { 16936, 7704, 3735, 2937, 1223, 217, 14, 1, 1 },
  { 17050, 7697, 3708, 2895, 1193, 209, 14, 1, 1 },
  { 17162, 7690, 3681, 2854, 1164, 202, 13, 1, 1 },
  { 17276, 7682, 3654, 2812, 1136, 194, 12, 1, 1 },
  { 17389, 7673, 3626, 2771, 1108, 187, 12, 1, 1 },
  { 17504, 7663, 3598, 2730, 1080, 180, 11, 1, 1 },
  { 17617, 7653, 3570, 2689, 1053, 173, 11, 1, 1 },
  { 17730, 7642, 3541, 2649, 1027, 167, 10, 1, 1 },
  { 17843, 7630, 3513, 2608, 1001, 161, 10, 1, 1 },
  { 17957, 7618, 3484, 2569, 975, 154, 9, 1, 1 },
  { 18069, 7605, 3455, 2529, 950, 149, 9, 1, 1 },
  { 18183, 7591, 3426, 2489, 926, 143, 8, 1, 1 },
  { 18296, 7576, 3396, 2450, 902, 138, 8, 1, 1 },
  { 18410, 7562, 3366, 2411, 878, 132, 7, 1, 1 },
  { 18523, 7545, 3337, 2372, 855, 127, 7, 1, 1 },
  { 18636, 7529, 3306, 2333, 833, 122, 7, 1, 1 },
  { 18749, 7511, 3276, 2295, 811, 118, 6, 1, 1 },
  { 18862, 7493, 3246, 2257, 789, 113, 6, 1, 1 },
  { 18975, 7474, 3215, 2219, 768, 109, 6, 1, 1 },
  { 19088, 7455, 3185, 2182, 747, 104, 5, 1, 1 },
  { 19201, 7435, 3154, 2144, 727, 100, 5, 1, 1 },
  { 19314, 7414, 3123, 2107, 707, 96, 5, 1, 1 },
  { 19427, 7392, 3092, 2071, 687, 92, 5, 1, 1 },
  { 19541, 7370, 3060, 2034, 668, 89, 4, 1, 1 },
  { 19654, 7347, 3029, 1998, 649, 85, 4, 1, 1 },
  { 19766, 7323, 2997, 1963, 631, 82, 4, 1, 1 },
  { 19878, 7299, 2966, 1927, 613, 79, 4, 1, 1 },
  { 19991, 7274, 2934, 1892, 596, 75, 4, 1, 1 },
  { 20105, 7248, 2902, 1857, 579, 72, 3, 1, 1 },
  { 20218, 7222, 2870, 1822, 562, 69, 3, 1, 1 },
  { 20331, 7195, 2838, 1788, 545, 66, 3, 1, 1 },
  { 20443, 7167, 2806, 1754, 529, 64, 3, 1, 1 },
  { 20556, 7138, 2774, 1720, 514, 61, 3, 1, 1 },
  { 20670, 7109, 2741, 1687, 498, 58, 3, 1, 1 },
  { 20783, 7079, 2709, 1654, 483, 56, 2, 1, 1 },
  { 20895, 7049, 2676, 1621, 469, 54, 2, 1, 1 },
  { 21008, 7017, 2644, 1589, 455, 51, 2, 1, 1 },
  { 21121, 6985, 2611, 1557, 441, 49, 2, 1, 1 },
  { 21234, 6953, 2578, 1525, 427, 47, 2, 1, 1 },
  { 21347, 6919, 2545, 1494, 414, 45, 2, 1, 1 },
  { 21460, 6885, 2513, 1462, 401, 43, 2, 1, 1 },
  { 21573, 6850, 2480, 1432, 388, 41, 2, 1, 1 },
  { 21687, 6815, 2447, 1401, 375, 39, 2, 1, 1 },
  { 21801, 6778, 2414, 1371, 363, 38, 1, 1, 1 },
  { 21914, 6741, 2381, 1341, 352, 36, 1, 1, 1 },
  { 22028, 6704, 2348, 1311, 340, 34, 1, 1, 1 },
  { 22141, 6665, 2315, 1282, 329, 33, 1, 1, 1 },
  { 22255, 6626, 2282, 1253, 318, 31, 1, 1, 1 },
  { 22368, 6586, 2249, 1225, 307, 30, 1, 1, 1 },
  { 22482, 6546, 2216, 1196, 297, 28, 1, 1, 1 },
  { 22595, 6505, 2183, 1169, 286, 27, 1, 1, 1 },
  { 22709, 6463, 2149, 1141, 277, 26, 1, 1, 1 },
  { 22823, 6420, 2116, 1114, 267, 25, 1, 1, 1 },
  { 22938, 6377, 2083, 1087, 257, 23, 1, 1, 1 },
  { 23053, 6332, 2050, 1060, 248, 22, 1, 1, 1 },
  { 23167, 6287, 2017, 1034, 239, 21, 1, 1, 1 },
  { 23280, 6242, 1984, 1008, 231, 20, 1, 1, 1 },
  { 23396, 6195, 1951, 982, 222, 19, 1, 1, 1 },
  { 23510, 6148, 1918, 957, 214, 18, 1, 1, 1 },
  { 23625, 6100, 1885, 932, 206, 17, 1, 1, 1 },
  { 23741, 6051, 1852, 907, 198, 16, 1, 1, 1 },
  { 23855, 6002, 1819, 883, 190, 16, 1, 1, 1 },
  { 23971, 5951, 1786, 859, 183, 15, 1, 1, 1 },
  { 24087, 5900, 1753, 835, 176, 14, 1, 1, 1 },
  { 24203, 5848, 1720, 812, 169, 13, 1, 1, 1 },
  { 24318, 5796, 1687, 789, 162, 13, 1, 1, 1 },
  { 24435, 5742, 1655, 766, 155, 12, 1, 1, 1 },
  { 24552, 5688, 1622, 743, 149, 11, 1, 1, 1 },
  { 24669, 5632, 1589, 721, 143, 11, 1, 1, 1 },
  { 24786, 5576, 1557, 699, 137, 10, 1, 1, 1 },
  { 24903, 5519, 1524, 678, 131, 10, 1, 1, 1 },
  { 25021, 5462, 1491, 657, 125, 9, 1, 1, 1 },
  { 25139, 5403, 1459, 636, 120, 8, 1, 1, 1 },
  { 25258, 5343, 1427, 615, 114, 8, 1, 1, 1 },
  { 25376, 5283, 1394, 595, 109, 8, 1, 1, 1 },
  { 25496, 5221, 1362, 575, 104, 7, 1, 1, 1 },
  { 25614, 5159, 1330, 556, 99, 7, 1, 1, 1 },
  { 25735, 5096, 1298, 536, 94, 6, 1, 1, 1 },
  { 25856, 5031, 1265, 517, 90, 6, 1, 1, 1 },
  { 25977, 4966, 1233, 499, 85, 5, 1, 1, 1 },
  { 26098, 4899, 1202, 480, 81, 5, 1, 1, 1 },
  { 26220, 4831, 1170, 462, 77, 5, 1, 1, 1 },
  { 26343, 4763, 1138, 444, 73, 4, 1, 1, 1 },
  { 26466, 4693, 1106, 427, 69, 4, 1, 1, 1 },
  { 26589, 4622, 1075, 410, 65, 4, 1, 1, 1 },
  { 26713, 4550, 1043, 393, 62, 4, 1, 1, 1 },
  { 26840, 4476, 1012, 376, 58, 3, 1, 1, 1 },
  { 26966, 4401, 980, 360, 55, 3, 1, 1, 1 },
  { 27092, 4325, 949, 344, 52, 3, 1, 1, 1 },
  { 27220, 4248, 918, 328, 48, 3, 1, 1, 1 },
  { 27350, 4169, 886, 313, 45, 2, 1, 1, 1 },
  { 27480, 4088, 855, 298, 42, 2, 1, 1, 1 },
  { 27610, 4006, 824, 283, 40, 2, 1, 1, 1 },
  { 27743, 3922, 793, 268, 37, 2, 1, 1, 1 },
  { 27876, 3837, 762, 254, 34, 2, 1, 1, 1 },
  { 28011, 3749, 731, 240, 32, 2, 1, 1, 1 },
  { 28147, 3659, 701, 227, 30, 1, 1, 1, 1 },
  { 28286, 3568, 670, 213, 27, 1, 1, 1, 1 },
  { 28426, 3474, 639, 200, 25, 1, 1, 1, 1 },
  { 28569, 3377, 608, 187, 23, 1, 1, 1, 1 },
  { 28714, 3278, 577, 174, 21, 1, 1, 1, 1 },
  { 28860, 3176, 547, 162, 19, 1, 1, 1, 1 },
  { 29010, 3071, 516, 150, 17, 1, 1, 1, 1 },
  { 29163, 2962, 485, 138, 16, 1, 1, 1, 1 },
  { 29320, 2849, 454, 127, 14, 1, 1, 1, 1 },
  { 29483, 2731, 423, 115, 12, 1, 1, 1, 1 },
  { 29650, 2608, 391, 104, 11, 1, 1, 1, 1 },
  { 29823, 2479, 360, 93, 9, 1, 1, 1, 1 },
  { 30002, 2343, 328, 83, 8, 1, 1, 1, 1 },
  { 30192, 2198, 295, 72, 7, 1, 1, 1, 1 },
  { 30393, 2041, 262, 62, 6, 1, 1, 1, 1 },
  { 30612, 1869, 227, 52, 4, 1, 1, 1, 1 },
  { 30853, 1676, 191, 41, 3, 1, 1, 1, 1 },
  { 31131, 1448, 152, 31, 2, 1, 1, 1, 1 },
  { 31486, 1150, 107, 20, 1, 1, 1, 1, 1 },
};

#if !CONFIG_Q_ADAPT_PROBS
static const coeff_cdf_model default_coef_head_cdf_4x4[PLANE_TYPES] = {
  {     // Y plane
    {   // Intra
      { // Band 0
        { AOM_ICDF(25024), AOM_ICDF(25863), AOM_ICDF(27361), AOM_ICDF(29796),
          AOM_ICDF(30374), AOM_ICDF(32768) },
        { AOM_ICDF(10816), AOM_ICDF(14127), AOM_ICDF(17116), AOM_ICDF(23516),
          AOM_ICDF(24999), AOM_ICDF(32768) },
        { AOM_ICDF(1088), AOM_ICDF(6358), AOM_ICDF(8428), AOM_ICDF(16648),
          AOM_ICDF(18276), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(14529), AOM_ICDF(18769), AOM_ICDF(29100), AOM_ICDF(29634),
          AOM_ICDF(32768) },
        { AOM_ICDF(12993), AOM_ICDF(17117), AOM_ICDF(28404), AOM_ICDF(28988),
          AOM_ICDF(32768) },
        { AOM_ICDF(11201), AOM_ICDF(14084), AOM_ICDF(25818), AOM_ICDF(26504),
          AOM_ICDF(32768) },
        { AOM_ICDF(9793), AOM_ICDF(11267), AOM_ICDF(21775), AOM_ICDF(22451),
          AOM_ICDF(32768) },
        { AOM_ICDF(7105), AOM_ICDF(7562), AOM_ICDF(15777), AOM_ICDF(16225),
          AOM_ICDF(32768) },
        { AOM_ICDF(3905), AOM_ICDF(3966), AOM_ICDF(8359), AOM_ICDF(8526),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(20033), AOM_ICDF(23643), AOM_ICDF(31102), AOM_ICDF(31374),
          AOM_ICDF(32768) },
        { AOM_ICDF(16321), AOM_ICDF(20350), AOM_ICDF(30167), AOM_ICDF(30546),
          AOM_ICDF(32768) },
        { AOM_ICDF(12993), AOM_ICDF(15512), AOM_ICDF(26859), AOM_ICDF(27396),
          AOM_ICDF(32768) },
        { AOM_ICDF(10305), AOM_ICDF(11659), AOM_ICDF(21669), AOM_ICDF(22330),
          AOM_ICDF(32768) },
        { AOM_ICDF(7361), AOM_ICDF(7819), AOM_ICDF(15450), AOM_ICDF(15940),
          AOM_ICDF(32768) },
        { AOM_ICDF(3521), AOM_ICDF(3580), AOM_ICDF(7805), AOM_ICDF(7976),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(21057), AOM_ICDF(25460), AOM_ICDF(31740), AOM_ICDF(31952),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(21173), AOM_ICDF(30761), AOM_ICDF(31092),
          AOM_ICDF(32768) },
        { AOM_ICDF(11841), AOM_ICDF(14615), AOM_ICDF(26188), AOM_ICDF(26824),
          AOM_ICDF(32768) },
        { AOM_ICDF(7745), AOM_ICDF(8991), AOM_ICDF(18937), AOM_ICDF(19707),
          AOM_ICDF(32768) },
        { AOM_ICDF(4417), AOM_ICDF(4706), AOM_ICDF(10342), AOM_ICDF(10890),
          AOM_ICDF(32768) },
        { AOM_ICDF(7617), AOM_ICDF(8392), AOM_ICDF(17295), AOM_ICDF(17915),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(20417), AOM_ICDF(26452), AOM_ICDF(32166), AOM_ICDF(32321),
          AOM_ICDF(32768) },
        { AOM_ICDF(15809), AOM_ICDF(21634), AOM_ICDF(30947), AOM_ICDF(31298),
          AOM_ICDF(32768) },
        { AOM_ICDF(10049), AOM_ICDF(12176), AOM_ICDF(23495), AOM_ICDF(24229),
          AOM_ICDF(32768) },
        { AOM_ICDF(5953), AOM_ICDF(6731), AOM_ICDF(16166), AOM_ICDF(16798),
          AOM_ICDF(32768) },
        { AOM_ICDF(6081), AOM_ICDF(6188), AOM_ICDF(8114), AOM_ICDF(8764),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2291), AOM_ICDF(4448), AOM_ICDF(5527),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(9153), AOM_ICDF(25905), AOM_ICDF(31431), AOM_ICDF(31934),
          AOM_ICDF(32768) },
        { AOM_ICDF(9025), AOM_ICDF(23345), AOM_ICDF(30033), AOM_ICDF(30965),
          AOM_ICDF(32768) },
        { AOM_ICDF(5953), AOM_ICDF(13835), AOM_ICDF(22032), AOM_ICDF(24664),
          AOM_ICDF(32768) },
        { AOM_ICDF(6337), AOM_ICDF(11435), AOM_ICDF(18366), AOM_ICDF(21418),
          AOM_ICDF(32768) },
        { AOM_ICDF(3137), AOM_ICDF(4871), AOM_ICDF(8519), AOM_ICDF(12426),
          AOM_ICDF(32768) },
        { AOM_ICDF(1857), AOM_ICDF(2727), AOM_ICDF(5540), AOM_ICDF(8757),
          AOM_ICDF(32768) } } },
    {   // Intra
      { // Band 0
        { AOM_ICDF(24512), AOM_ICDF(26673), AOM_ICDF(28962), AOM_ICDF(31929),
          AOM_ICDF(32126), AOM_ICDF(32768) },
        { AOM_ICDF(15936), AOM_ICDF(21711), AOM_ICDF(25569), AOM_ICDF(30899),
          AOM_ICDF(31305), AOM_ICDF(32768) },
        { AOM_ICDF(3264), AOM_ICDF(14756), AOM_ICDF(20107), AOM_ICDF(29407),
          AOM_ICDF(30032), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(21313), AOM_ICDF(26020), AOM_ICDF(32523), AOM_ICDF(32575),
          AOM_ICDF(32768) },
        { AOM_ICDF(18369), AOM_ICDF(24215), AOM_ICDF(32291), AOM_ICDF(32391),
          AOM_ICDF(32768) },
        { AOM_ICDF(15297), AOM_ICDF(19637), AOM_ICDF(30414), AOM_ICDF(30752),
          AOM_ICDF(32768) },
        { AOM_ICDF(11713), AOM_ICDF(14040), AOM_ICDF(25408), AOM_ICDF(26033),
          AOM_ICDF(32768) },
        { AOM_ICDF(9537), AOM_ICDF(10173), AOM_ICDF(18839), AOM_ICDF(19315),
          AOM_ICDF(32768) },
        { AOM_ICDF(9025), AOM_ICDF(9093), AOM_ICDF(13987), AOM_ICDF(14115),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(22721), AOM_ICDF(27599), AOM_ICDF(32592), AOM_ICDF(32636),
          AOM_ICDF(32768) },
        { AOM_ICDF(19009), AOM_ICDF(24676), AOM_ICDF(32258), AOM_ICDF(32367),
          AOM_ICDF(32768) },
        { AOM_ICDF(12737), AOM_ICDF(16769), AOM_ICDF(28739), AOM_ICDF(29247),
          AOM_ICDF(32768) },
        { AOM_ICDF(8769), AOM_ICDF(10956), AOM_ICDF(21941), AOM_ICDF(22840),
          AOM_ICDF(32768) },
        { AOM_ICDF(6721), AOM_ICDF(7678), AOM_ICDF(15319), AOM_ICDF(16290),
          AOM_ICDF(32768) },
        { AOM_ICDF(4417), AOM_ICDF(4430), AOM_ICDF(4583), AOM_ICDF(5712),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(22849), AOM_ICDF(28333), AOM_ICDF(32633), AOM_ICDF(32671),
          AOM_ICDF(32768) },
        { AOM_ICDF(18497), AOM_ICDF(24619), AOM_ICDF(32184), AOM_ICDF(32315),
          AOM_ICDF(32768) },
        { AOM_ICDF(11841), AOM_ICDF(14640), AOM_ICDF(27251), AOM_ICDF(27752),
          AOM_ICDF(32768) },
        { AOM_ICDF(8385), AOM_ICDF(10154), AOM_ICDF(18339), AOM_ICDF(19621),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(6977), AOM_ICDF(13787), AOM_ICDF(15289),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(20417), AOM_ICDF(28167), AOM_ICDF(32552), AOM_ICDF(32621),
          AOM_ICDF(32768) },
        { AOM_ICDF(16833), AOM_ICDF(23968), AOM_ICDF(31991), AOM_ICDF(32174),
          AOM_ICDF(32768) },
        { AOM_ICDF(10433), AOM_ICDF(13387), AOM_ICDF(26356), AOM_ICDF(26951),
          AOM_ICDF(32768) },
        { AOM_ICDF(5057), AOM_ICDF(6823), AOM_ICDF(18967), AOM_ICDF(19843),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(6479), AOM_ICDF(11672), AOM_ICDF(13052),
          AOM_ICDF(32768) },
        { AOM_ICDF(2241), AOM_ICDF(2265), AOM_ICDF(6355), AOM_ICDF(6432),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(12097), AOM_ICDF(28717), AOM_ICDF(32406), AOM_ICDF(32555),
          AOM_ICDF(32768) },
        { AOM_ICDF(10433), AOM_ICDF(26113), AOM_ICDF(31504), AOM_ICDF(31975),
          AOM_ICDF(32768) },
        { AOM_ICDF(5825), AOM_ICDF(14284), AOM_ICDF(21349), AOM_ICDF(24461),
          AOM_ICDF(32768) },
        { AOM_ICDF(4545), AOM_ICDF(8454), AOM_ICDF(12648), AOM_ICDF(17501),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(7173), AOM_ICDF(15272), AOM_ICDF(19322),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2183), AOM_ICDF(7202), AOM_ICDF(7377),
          AOM_ICDF(32768) } } } },
  {     // UV plane
    {   // Inter
      { // Band 0
        { AOM_ICDF(27456), AOM_ICDF(28244), AOM_ICDF(31289), AOM_ICDF(32358),
          AOM_ICDF(32534), AOM_ICDF(32768) },
        { AOM_ICDF(16960), AOM_ICDF(21207), AOM_ICDF(26511), AOM_ICDF(30539),
          AOM_ICDF(31190), AOM_ICDF(32768) },
        { AOM_ICDF(5440), AOM_ICDF(13412), AOM_ICDF(18469), AOM_ICDF(26423),
          AOM_ICDF(27669), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(17857), AOM_ICDF(26327), AOM_ICDF(31983), AOM_ICDF(32219),
          AOM_ICDF(32768) },
        { AOM_ICDF(16065), AOM_ICDF(24198), AOM_ICDF(31431), AOM_ICDF(31785),
          AOM_ICDF(32768) },
        { AOM_ICDF(12865), AOM_ICDF(18011), AOM_ICDF(28454), AOM_ICDF(29166),
          AOM_ICDF(32768) },
        { AOM_ICDF(9665), AOM_ICDF(12501), AOM_ICDF(24331), AOM_ICDF(25147),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(3121), AOM_ICDF(12661), AOM_ICDF(13034),
          AOM_ICDF(32768) },
        { AOM_ICDF(4033), AOM_ICDF(4140), AOM_ICDF(11834), AOM_ICDF(11977),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(21185), AOM_ICDF(28338), AOM_ICDF(32249), AOM_ICDF(32417),
          AOM_ICDF(32768) },
        { AOM_ICDF(18497), AOM_ICDF(25227), AOM_ICDF(31905), AOM_ICDF(32122),
          AOM_ICDF(32768) },
        { AOM_ICDF(12097), AOM_ICDF(16516), AOM_ICDF(28610), AOM_ICDF(29166),
          AOM_ICDF(32768) },
        { AOM_ICDF(9281), AOM_ICDF(11157), AOM_ICDF(21438), AOM_ICDF(22312),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(6566), AOM_ICDF(15585), AOM_ICDF(16340),
          AOM_ICDF(32768) },
        { AOM_ICDF(9409), AOM_ICDF(9659), AOM_ICDF(11827), AOM_ICDF(12911),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(22337), AOM_ICDF(29459), AOM_ICDF(32382), AOM_ICDF(32519),
          AOM_ICDF(32768) },
        { AOM_ICDF(16961), AOM_ICDF(25262), AOM_ICDF(31874), AOM_ICDF(32123),
          AOM_ICDF(32768) },
        { AOM_ICDF(12353), AOM_ICDF(17748), AOM_ICDF(29300), AOM_ICDF(29852),
          AOM_ICDF(32768) },
        { AOM_ICDF(9025), AOM_ICDF(11528), AOM_ICDF(24468), AOM_ICDF(25141),
          AOM_ICDF(32768) },
        { AOM_ICDF(6209), AOM_ICDF(6565), AOM_ICDF(15806), AOM_ICDF(16121),
          AOM_ICDF(32768) },
        { AOM_ICDF(2497), AOM_ICDF(2524), AOM_ICDF(7050), AOM_ICDF(7125),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(20417), AOM_ICDF(29779), AOM_ICDF(32552), AOM_ICDF(32636),
          AOM_ICDF(32768) },
        { AOM_ICDF(15553), AOM_ICDF(26420), AOM_ICDF(32063), AOM_ICDF(32295),
          AOM_ICDF(32768) },
        { AOM_ICDF(9665), AOM_ICDF(17946), AOM_ICDF(29385), AOM_ICDF(30096),
          AOM_ICDF(32768) },
        { AOM_ICDF(5569), AOM_ICDF(10207), AOM_ICDF(22410), AOM_ICDF(23836),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(16450), AOM_ICDF(16545), AOM_ICDF(16593),
          AOM_ICDF(32768) },
        { AOM_ICDF(2369), AOM_ICDF(2395), AOM_ICDF(6822), AOM_ICDF(6898),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(10177), AOM_ICDF(30567), AOM_ICDF(32725), AOM_ICDF(32745),
          AOM_ICDF(32768) },
        { AOM_ICDF(9537), AOM_ICDF(28243), AOM_ICDF(32179), AOM_ICDF(32423),
          AOM_ICDF(32768) },
        { AOM_ICDF(13377), AOM_ICDF(23187), AOM_ICDF(29322), AOM_ICDF(30382),
          AOM_ICDF(32768) },
        { AOM_ICDF(13121), AOM_ICDF(21346), AOM_ICDF(29507), AOM_ICDF(30326),
          AOM_ICDF(32768) },
        { AOM_ICDF(4417), AOM_ICDF(4939), AOM_ICDF(15104), AOM_ICDF(15535),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2680), AOM_ICDF(8218), AOM_ICDF(8338),
          AOM_ICDF(32768) } } },
    {   // Inter
      { // Band 0
        { AOM_ICDF(29376), AOM_ICDF(30098), AOM_ICDF(32421), AOM_ICDF(32766),
          AOM_ICDF(32767), AOM_ICDF(32768) },
        { AOM_ICDF(18368), AOM_ICDF(22916), AOM_ICDF(30116), AOM_ICDF(32541),
          AOM_ICDF(32650), AOM_ICDF(32768) },
        { AOM_ICDF(5952), AOM_ICDF(16505), AOM_ICDF(25955), AOM_ICDF(32163),
          AOM_ICDF(32365), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(19649), AOM_ICDF(30160), AOM_ICDF(32743), AOM_ICDF(32753),
          AOM_ICDF(32768) },
        { AOM_ICDF(18881), AOM_ICDF(28724), AOM_ICDF(32688), AOM_ICDF(32717),
          AOM_ICDF(32768) },
        { AOM_ICDF(16833), AOM_ICDF(23053), AOM_ICDF(31244), AOM_ICDF(31573),
          AOM_ICDF(32768) },
        { AOM_ICDF(14657), AOM_ICDF(17714), AOM_ICDF(26083), AOM_ICDF(26978),
          AOM_ICDF(32768) },
        { AOM_ICDF(14657), AOM_ICDF(16618), AOM_ICDF(24597), AOM_ICDF(25403),
          AOM_ICDF(32768) },
        { AOM_ICDF(4289), AOM_ICDF(4326), AOM_ICDF(10686), AOM_ICDF(10751),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(21953), AOM_ICDF(30956), AOM_ICDF(32748), AOM_ICDF(32757),
          AOM_ICDF(32768) },
        { AOM_ICDF(20929), AOM_ICDF(29412), AOM_ICDF(32700), AOM_ICDF(32725),
          AOM_ICDF(32768) },
        { AOM_ICDF(13377), AOM_ICDF(21495), AOM_ICDF(31216), AOM_ICDF(31569),
          AOM_ICDF(32768) },
        { AOM_ICDF(9153), AOM_ICDF(15097), AOM_ICDF(28295), AOM_ICDF(28990),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5363), AOM_ICDF(13839), AOM_ICDF(13894),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2652), AOM_ICDF(7276), AOM_ICDF(7351),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(20289), AOM_ICDF(31164), AOM_ICDF(32745), AOM_ICDF(32755),
          AOM_ICDF(32768) },
        { AOM_ICDF(17601), AOM_ICDF(29635), AOM_ICDF(32739), AOM_ICDF(32751),
          AOM_ICDF(32768) },
        { AOM_ICDF(18241), AOM_ICDF(24284), AOM_ICDF(32116), AOM_ICDF(32258),
          AOM_ICDF(32768) },
        { AOM_ICDF(32705), AOM_ICDF(32706), AOM_ICDF(32739), AOM_ICDF(32740),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(5750), AOM_ICDF(14739), AOM_ICDF(14792),
          AOM_ICDF(32768) },
        { AOM_ICDF(2881), AOM_ICDF(2913), AOM_ICDF(8427), AOM_ICDF(8498),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(19009), AOM_ICDF(31481), AOM_ICDF(32742), AOM_ICDF(32754),
          AOM_ICDF(32768) },
        { AOM_ICDF(15809), AOM_ICDF(30521), AOM_ICDF(32736), AOM_ICDF(32750),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(32705), AOM_ICDF(32737), AOM_ICDF(32753),
          AOM_ICDF(32768) },
        { AOM_ICDF(7873), AOM_ICDF(8039), AOM_ICDF(19981), AOM_ICDF(20068),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5366), AOM_ICDF(14376), AOM_ICDF(14430),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(2789), AOM_ICDF(8909), AOM_ICDF(8979),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(11841), AOM_ICDF(32116), AOM_ICDF(32728), AOM_ICDF(32748),
          AOM_ICDF(32768) },
        { AOM_ICDF(12353), AOM_ICDF(32132), AOM_ICDF(32729), AOM_ICDF(32748),
          AOM_ICDF(32768) },
        { AOM_ICDF(7489), AOM_ICDF(12435), AOM_ICDF(25708), AOM_ICDF(26666),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(7486), AOM_ICDF(20238), AOM_ICDF(21009),
          AOM_ICDF(32768) },
        { AOM_ICDF(4929), AOM_ICDF(5579), AOM_ICDF(16402), AOM_ICDF(16866),
          AOM_ICDF(32768) },
        { AOM_ICDF(3009), AOM_ICDF(3246), AOM_ICDF(10158), AOM_ICDF(10533),
          AOM_ICDF(32768) } } } }
};
static const coeff_cdf_model default_coef_head_cdf_8x8[PLANE_TYPES] = {
  {     // Y plane
    {   // Intra
      { // Band 0
        { AOM_ICDF(16064), AOM_ICDF(18127), AOM_ICDF(22153), AOM_ICDF(27289),
          AOM_ICDF(28507), AOM_ICDF(32768) },
        { AOM_ICDF(6720), AOM_ICDF(10545), AOM_ICDF(13491), AOM_ICDF(20948),
          AOM_ICDF(22631), AOM_ICDF(32768) },
        { AOM_ICDF(832), AOM_ICDF(5270), AOM_ICDF(5918), AOM_ICDF(12645),
          AOM_ICDF(13532), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(14017), AOM_ICDF(16139), AOM_ICDF(26799), AOM_ICDF(27295),
          AOM_ICDF(32768) },
        { AOM_ICDF(12737), AOM_ICDF(15136), AOM_ICDF(26235), AOM_ICDF(26816),
          AOM_ICDF(32768) },
        { AOM_ICDF(10817), AOM_ICDF(12445), AOM_ICDF(23637), AOM_ICDF(24217),
          AOM_ICDF(32768) },
        { AOM_ICDF(8897), AOM_ICDF(9702), AOM_ICDF(20040), AOM_ICDF(20500),
          AOM_ICDF(32768) },
        { AOM_ICDF(5953), AOM_ICDF(6156), AOM_ICDF(13966), AOM_ICDF(14205),
          AOM_ICDF(32768) },
        { AOM_ICDF(2497), AOM_ICDF(2519), AOM_ICDF(6222), AOM_ICDF(6300),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(19777), AOM_ICDF(21403), AOM_ICDF(30054), AOM_ICDF(30269),
          AOM_ICDF(32768) },
        { AOM_ICDF(16193), AOM_ICDF(17913), AOM_ICDF(28593), AOM_ICDF(28883),
          AOM_ICDF(32768) },
        { AOM_ICDF(12609), AOM_ICDF(13572), AOM_ICDF(25248), AOM_ICDF(25534),
          AOM_ICDF(32768) },
        { AOM_ICDF(9665), AOM_ICDF(10118), AOM_ICDF(20721), AOM_ICDF(20968),
          AOM_ICDF(32768) },
        { AOM_ICDF(6849), AOM_ICDF(7028), AOM_ICDF(15202), AOM_ICDF(15391),
          AOM_ICDF(32768) },
        { AOM_ICDF(3009), AOM_ICDF(3036), AOM_ICDF(7601), AOM_ICDF(7675),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(22593), AOM_ICDF(23915), AOM_ICDF(31159), AOM_ICDF(31283),
          AOM_ICDF(32768) },
        { AOM_ICDF(17345), AOM_ICDF(18690), AOM_ICDF(29425), AOM_ICDF(29611),
          AOM_ICDF(32768) },
        { AOM_ICDF(11969), AOM_ICDF(12540), AOM_ICDF(24685), AOM_ICDF(24867),
          AOM_ICDF(32768) },
        { AOM_ICDF(8129), AOM_ICDF(8355), AOM_ICDF(18668), AOM_ICDF(18819),
          AOM_ICDF(32768) },
        { AOM_ICDF(4673), AOM_ICDF(4714), AOM_ICDF(11752), AOM_ICDF(11814),
          AOM_ICDF(32768) },
        { AOM_ICDF(1857), AOM_ICDF(1876), AOM_ICDF(5057), AOM_ICDF(5138),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(24513), AOM_ICDF(25718), AOM_ICDF(31947), AOM_ICDF(32014),
          AOM_ICDF(32768) },
        { AOM_ICDF(18881), AOM_ICDF(20029), AOM_ICDF(30409), AOM_ICDF(30527),
          AOM_ICDF(32768) },
        { AOM_ICDF(12481), AOM_ICDF(12953), AOM_ICDF(25201), AOM_ICDF(25341),
          AOM_ICDF(32768) },
        { AOM_ICDF(8385), AOM_ICDF(8528), AOM_ICDF(18815), AOM_ICDF(18910),
          AOM_ICDF(32768) },
        { AOM_ICDF(4289), AOM_ICDF(4327), AOM_ICDF(10797), AOM_ICDF(10861),
          AOM_ICDF(32768) },
        { AOM_ICDF(1857), AOM_ICDF(1872), AOM_ICDF(4332), AOM_ICDF(4415),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(26049), AOM_ICDF(27752), AOM_ICDF(32415), AOM_ICDF(32462),
          AOM_ICDF(32768) },
        { AOM_ICDF(20417), AOM_ICDF(22100), AOM_ICDF(31056), AOM_ICDF(31192),
          AOM_ICDF(32768) },
        { AOM_ICDF(12481), AOM_ICDF(13075), AOM_ICDF(24646), AOM_ICDF(24844),
          AOM_ICDF(32768) },
        { AOM_ICDF(7489), AOM_ICDF(7696), AOM_ICDF(17117), AOM_ICDF(17285),
          AOM_ICDF(32768) },
        { AOM_ICDF(3777), AOM_ICDF(3814), AOM_ICDF(10062), AOM_ICDF(10129),
          AOM_ICDF(32768) },
        { AOM_ICDF(1473), AOM_ICDF(1486), AOM_ICDF(3735), AOM_ICDF(3820),
          AOM_ICDF(32768) } } },
    {   // Intra
      { // Band 0
        { AOM_ICDF(25920), AOM_ICDF(27743), AOM_ICDF(29455), AOM_ICDF(32147),
          AOM_ICDF(32280), AOM_ICDF(32768) },
        { AOM_ICDF(13888), AOM_ICDF(19845), AOM_ICDF(23350), AOM_ICDF(30219),
          AOM_ICDF(30660), AOM_ICDF(32768) },
        { AOM_ICDF(2368), AOM_ICDF(12781), AOM_ICDF(16196), AOM_ICDF(27232),
          AOM_ICDF(27894), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(21697), AOM_ICDF(24758), AOM_ICDF(32358), AOM_ICDF(32417),
          AOM_ICDF(32768) },
        { AOM_ICDF(20289), AOM_ICDF(23960), AOM_ICDF(32111), AOM_ICDF(32213),
          AOM_ICDF(32768) },
        { AOM_ICDF(17345), AOM_ICDF(19966), AOM_ICDF(30630), AOM_ICDF(30841),
          AOM_ICDF(32768) },
        { AOM_ICDF(14529), AOM_ICDF(16070), AOM_ICDF(27461), AOM_ICDF(27777),
          AOM_ICDF(32768) },
        { AOM_ICDF(9793), AOM_ICDF(10613), AOM_ICDF(21146), AOM_ICDF(21566),
          AOM_ICDF(32768) },
        { AOM_ICDF(6977), AOM_ICDF(7162), AOM_ICDF(15591), AOM_ICDF(15776),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(23617), AOM_ICDF(26783), AOM_ICDF(32572), AOM_ICDF(32607),
          AOM_ICDF(32768) },
        { AOM_ICDF(20801), AOM_ICDF(24292), AOM_ICDF(32185), AOM_ICDF(32275),
          AOM_ICDF(32768) },
        { AOM_ICDF(15169), AOM_ICDF(17905), AOM_ICDF(29916), AOM_ICDF(30181),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(12972), AOM_ICDF(25565), AOM_ICDF(26064),
          AOM_ICDF(32768) },
        { AOM_ICDF(6849), AOM_ICDF(8334), AOM_ICDF(18543), AOM_ICDF(19446),
          AOM_ICDF(32768) },
        { AOM_ICDF(3649), AOM_ICDF(4346), AOM_ICDF(12351), AOM_ICDF(13169),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(25281), AOM_ICDF(28440), AOM_ICDF(32667), AOM_ICDF(32689),
          AOM_ICDF(32768) },
        { AOM_ICDF(22081), AOM_ICDF(25694), AOM_ICDF(32414), AOM_ICDF(32476),
          AOM_ICDF(32768) },
        { AOM_ICDF(15297), AOM_ICDF(18341), AOM_ICDF(30141), AOM_ICDF(30410),
          AOM_ICDF(32768) },
        { AOM_ICDF(10305), AOM_ICDF(12381), AOM_ICDF(24477), AOM_ICDF(25084),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(6673), AOM_ICDF(16325), AOM_ICDF(17080),
          AOM_ICDF(32768) },
        { AOM_ICDF(2369), AOM_ICDF(2393), AOM_ICDF(6466), AOM_ICDF(6543),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(25921), AOM_ICDF(29445), AOM_ICDF(32729), AOM_ICDF(32739),
          AOM_ICDF(32768) },
        { AOM_ICDF(22465), AOM_ICDF(26834), AOM_ICDF(32588), AOM_ICDF(32627),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(20062), AOM_ICDF(31016), AOM_ICDF(31233),
          AOM_ICDF(32768) },
        { AOM_ICDF(11073), AOM_ICDF(13165), AOM_ICDF(25353), AOM_ICDF(25896),
          AOM_ICDF(32768) },
        { AOM_ICDF(11713), AOM_ICDF(13837), AOM_ICDF(20144), AOM_ICDF(21734),
          AOM_ICDF(32768) },
        { AOM_ICDF(2241), AOM_ICDF(2265), AOM_ICDF(6355), AOM_ICDF(6432),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(26177), AOM_ICDF(29403), AOM_ICDF(32705), AOM_ICDF(32721),
          AOM_ICDF(32768) },
        { AOM_ICDF(22337), AOM_ICDF(26344), AOM_ICDF(32545), AOM_ICDF(32589),
          AOM_ICDF(32768) },
        { AOM_ICDF(19009), AOM_ICDF(21527), AOM_ICDF(31775), AOM_ICDF(31873),
          AOM_ICDF(32768) },
        { AOM_ICDF(11585), AOM_ICDF(12685), AOM_ICDF(22632), AOM_ICDF(23137),
          AOM_ICDF(32768) },
        { AOM_ICDF(8257), AOM_ICDF(8305), AOM_ICDF(16444), AOM_ICDF(16492),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2183), AOM_ICDF(7202), AOM_ICDF(7377),
          AOM_ICDF(32768) } } } },
  {     // UV plane
    {   // Inter
      { // Band 0
        { AOM_ICDF(27200), AOM_ICDF(27981), AOM_ICDF(31389), AOM_ICDF(32444),
          AOM_ICDF(32592), AOM_ICDF(32768) },
        { AOM_ICDF(14528), AOM_ICDF(19068), AOM_ICDF(24887), AOM_ICDF(29901),
          AOM_ICDF(30688), AOM_ICDF(32768) },
        { AOM_ICDF(3776), AOM_ICDF(11778), AOM_ICDF(14700), AOM_ICDF(23745),
          AOM_ICDF(24854), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(20289), AOM_ICDF(25202), AOM_ICDF(31672), AOM_ICDF(31909),
          AOM_ICDF(32768) },
        { AOM_ICDF(18369), AOM_ICDF(23493), AOM_ICDF(31166), AOM_ICDF(31487),
          AOM_ICDF(32768) },
        { AOM_ICDF(15425), AOM_ICDF(18619), AOM_ICDF(28941), AOM_ICDF(29393),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(12535), AOM_ICDF(24287), AOM_ICDF(24792),
          AOM_ICDF(32768) },
        { AOM_ICDF(6465), AOM_ICDF(6810), AOM_ICDF(15764), AOM_ICDF(16080),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2137), AOM_ICDF(6125), AOM_ICDF(6203),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(23745), AOM_ICDF(27041), AOM_ICDF(31976), AOM_ICDF(32135),
          AOM_ICDF(32768) },
        { AOM_ICDF(19521), AOM_ICDF(22766), AOM_ICDF(31139), AOM_ICDF(31367),
          AOM_ICDF(32768) },
        { AOM_ICDF(14273), AOM_ICDF(15834), AOM_ICDF(27820), AOM_ICDF(28105),
          AOM_ICDF(32768) },
        { AOM_ICDF(9537), AOM_ICDF(10445), AOM_ICDF(22106), AOM_ICDF(22491),
          AOM_ICDF(32768) },
        { AOM_ICDF(7233), AOM_ICDF(7386), AOM_ICDF(15961), AOM_ICDF(16109),
          AOM_ICDF(32768) },
        { AOM_ICDF(2369), AOM_ICDF(2401), AOM_ICDF(7891), AOM_ICDF(7964),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(26305), AOM_ICDF(28703), AOM_ICDF(32352), AOM_ICDF(32435),
          AOM_ICDF(32768) },
        { AOM_ICDF(20673), AOM_ICDF(23490), AOM_ICDF(31517), AOM_ICDF(31680),
          AOM_ICDF(32768) },
        { AOM_ICDF(14017), AOM_ICDF(15251), AOM_ICDF(27458), AOM_ICDF(27702),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(11374), AOM_ICDF(22496), AOM_ICDF(22687),
          AOM_ICDF(32768) },
        { AOM_ICDF(9153), AOM_ICDF(9435), AOM_ICDF(22299), AOM_ICDF(22411),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(269), AOM_ICDF(13236), AOM_ICDF(13293),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(27713), AOM_ICDF(29770), AOM_ICDF(32522), AOM_ICDF(32575),
          AOM_ICDF(32768) },
        { AOM_ICDF(21569), AOM_ICDF(24342), AOM_ICDF(31785), AOM_ICDF(31919),
          AOM_ICDF(32768) },
        { AOM_ICDF(15297), AOM_ICDF(16497), AOM_ICDF(28367), AOM_ICDF(28569),
          AOM_ICDF(32768) },
        { AOM_ICDF(17601), AOM_ICDF(17828), AOM_ICDF(24444), AOM_ICDF(24582),
          AOM_ICDF(32768) },
        { AOM_ICDF(6977), AOM_ICDF(7035), AOM_ICDF(16901), AOM_ICDF(16947),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(384), AOM_ICDF(32706), AOM_ICDF(32707),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(28737), AOM_ICDF(30879), AOM_ICDF(32667), AOM_ICDF(32695),
          AOM_ICDF(32768) },
        { AOM_ICDF(22593), AOM_ICDF(26241), AOM_ICDF(32073), AOM_ICDF(32207),
          AOM_ICDF(32768) },
        { AOM_ICDF(16577), AOM_ICDF(19148), AOM_ICDF(28436), AOM_ICDF(28906),
          AOM_ICDF(32768) },
        { AOM_ICDF(12993), AOM_ICDF(14005), AOM_ICDF(23151), AOM_ICDF(23630),
          AOM_ICDF(32768) },
        { AOM_ICDF(7617), AOM_ICDF(9188), AOM_ICDF(22797), AOM_ICDF(23313),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2680), AOM_ICDF(8218), AOM_ICDF(8338),
          AOM_ICDF(32768) } } },
    {   // Inter
      { // Band 0
        { AOM_ICDF(28864), AOM_ICDF(29988), AOM_ICDF(32423), AOM_ICDF(32766),
          AOM_ICDF(32767), AOM_ICDF(32768) },
        { AOM_ICDF(18496), AOM_ICDF(24572), AOM_ICDF(30167), AOM_ICDF(32687),
          AOM_ICDF(32737), AOM_ICDF(32768) },
        { AOM_ICDF(5440), AOM_ICDF(19618), AOM_ICDF(25332), AOM_ICDF(32393),
          AOM_ICDF(32491), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(23745), AOM_ICDF(29427), AOM_ICDF(32751), AOM_ICDF(32757),
          AOM_ICDF(32768) },
        { AOM_ICDF(23745), AOM_ICDF(28704), AOM_ICDF(32716), AOM_ICDF(32731),
          AOM_ICDF(32768) },
        { AOM_ICDF(23105), AOM_ICDF(27943), AOM_ICDF(32524), AOM_ICDF(32587),
          AOM_ICDF(32768) },
        { AOM_ICDF(21057), AOM_ICDF(24773), AOM_ICDF(29589), AOM_ICDF(30282),
          AOM_ICDF(32768) },
        { AOM_ICDF(12609), AOM_ICDF(14823), AOM_ICDF(23831), AOM_ICDF(24713),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(16450), AOM_ICDF(16545), AOM_ICDF(16593),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(25025), AOM_ICDF(30203), AOM_ICDF(32754), AOM_ICDF(32759),
          AOM_ICDF(32768) },
        { AOM_ICDF(23617), AOM_ICDF(28361), AOM_ICDF(32715), AOM_ICDF(32729),
          AOM_ICDF(32768) },
        { AOM_ICDF(17985), AOM_ICDF(21562), AOM_ICDF(31354), AOM_ICDF(31543),
          AOM_ICDF(32768) },
        { AOM_ICDF(12353), AOM_ICDF(18915), AOM_ICDF(28742), AOM_ICDF(29548),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(289), AOM_ICDF(16545), AOM_ICDF(16593),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2652), AOM_ICDF(7276), AOM_ICDF(7351),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(26433), AOM_ICDF(30892), AOM_ICDF(32757), AOM_ICDF(32761),
          AOM_ICDF(32768) },
        { AOM_ICDF(24513), AOM_ICDF(29274), AOM_ICDF(32721), AOM_ICDF(32735),
          AOM_ICDF(32768) },
        { AOM_ICDF(20161), AOM_ICDF(24040), AOM_ICDF(32055), AOM_ICDF(32171),
          AOM_ICDF(32768) },
        { AOM_ICDF(21953), AOM_ICDF(24678), AOM_ICDF(27382), AOM_ICDF(28734),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(5750), AOM_ICDF(14739), AOM_ICDF(14792),
          AOM_ICDF(32768) },
        { AOM_ICDF(2881), AOM_ICDF(2913), AOM_ICDF(8427), AOM_ICDF(8498),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(27457), AOM_ICDF(31485), AOM_ICDF(32759), AOM_ICDF(32763),
          AOM_ICDF(32768) },
        { AOM_ICDF(24129), AOM_ICDF(29502), AOM_ICDF(32752), AOM_ICDF(32757),
          AOM_ICDF(32768) },
        { AOM_ICDF(19009), AOM_ICDF(25452), AOM_ICDF(32473), AOM_ICDF(32544),
          AOM_ICDF(32768) },
        { AOM_ICDF(32705), AOM_ICDF(32706), AOM_ICDF(32737), AOM_ICDF(32738),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5366), AOM_ICDF(14376), AOM_ICDF(14430),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(2789), AOM_ICDF(8909), AOM_ICDF(8979),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(27841), AOM_ICDF(32288), AOM_ICDF(32759), AOM_ICDF(32764),
          AOM_ICDF(32768) },
        { AOM_ICDF(19137), AOM_ICDF(30271), AOM_ICDF(32742), AOM_ICDF(32753),
          AOM_ICDF(32768) },
        { AOM_ICDF(18625), AOM_ICDF(27739), AOM_ICDF(29979), AOM_ICDF(31099),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(7486), AOM_ICDF(20238), AOM_ICDF(21009),
          AOM_ICDF(32768) },
        { AOM_ICDF(4929), AOM_ICDF(5579), AOM_ICDF(16402), AOM_ICDF(16866),
          AOM_ICDF(32768) },
        { AOM_ICDF(3009), AOM_ICDF(3246), AOM_ICDF(10158), AOM_ICDF(10533),
          AOM_ICDF(32768) } } } }
};
static const coeff_cdf_model default_coef_head_cdf_16x16[PLANE_TYPES] = {
  {     // Y plane
    {   // Intra
      { // Band 0
        { AOM_ICDF(960), AOM_ICDF(4882), AOM_ICDF(9467), AOM_ICDF(17710),
          AOM_ICDF(20412), AOM_ICDF(32768) },
        { AOM_ICDF(704), AOM_ICDF(4657), AOM_ICDF(6561), AOM_ICDF(14507),
          AOM_ICDF(16279), AOM_ICDF(32768) },
        { AOM_ICDF(192), AOM_ICDF(3443), AOM_ICDF(3759), AOM_ICDF(9011),
          AOM_ICDF(9685), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(12481), AOM_ICDF(13958), AOM_ICDF(24487), AOM_ICDF(24997),
          AOM_ICDF(32768) },
        { AOM_ICDF(11457), AOM_ICDF(13075), AOM_ICDF(23820), AOM_ICDF(24406),
          AOM_ICDF(32768) },
        { AOM_ICDF(9793), AOM_ICDF(11127), AOM_ICDF(21775), AOM_ICDF(22387),
          AOM_ICDF(32768) },
        { AOM_ICDF(7745), AOM_ICDF(8457), AOM_ICDF(18155), AOM_ICDF(18655),
          AOM_ICDF(32768) },
        { AOM_ICDF(5441), AOM_ICDF(5668), AOM_ICDF(13180), AOM_ICDF(13467),
          AOM_ICDF(32768) },
        { AOM_ICDF(2497), AOM_ICDF(2520), AOM_ICDF(6340), AOM_ICDF(6417),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(19521), AOM_ICDF(20572), AOM_ICDF(28965), AOM_ICDF(29177),
          AOM_ICDF(32768) },
        { AOM_ICDF(15425), AOM_ICDF(16741), AOM_ICDF(27247), AOM_ICDF(27554),
          AOM_ICDF(32768) },
        { AOM_ICDF(11969), AOM_ICDF(12690), AOM_ICDF(23872), AOM_ICDF(24141),
          AOM_ICDF(32768) },
        { AOM_ICDF(9281), AOM_ICDF(9678), AOM_ICDF(19970), AOM_ICDF(20207),
          AOM_ICDF(32768) },
        { AOM_ICDF(6081), AOM_ICDF(6266), AOM_ICDF(14682), AOM_ICDF(14876),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(2779), AOM_ICDF(7150), AOM_ICDF(7225),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(22337), AOM_ICDF(23293), AOM_ICDF(30630), AOM_ICDF(30753),
          AOM_ICDF(32768) },
        { AOM_ICDF(16321), AOM_ICDF(17427), AOM_ICDF(28368), AOM_ICDF(28570),
          AOM_ICDF(32768) },
        { AOM_ICDF(11457), AOM_ICDF(11907), AOM_ICDF(23570), AOM_ICDF(23741),
          AOM_ICDF(32768) },
        { AOM_ICDF(7233), AOM_ICDF(7331), AOM_ICDF(17258), AOM_ICDF(17334),
          AOM_ICDF(32768) },
        { AOM_ICDF(4033), AOM_ICDF(4070), AOM_ICDF(10375), AOM_ICDF(10441),
          AOM_ICDF(32768) },
        { AOM_ICDF(1601), AOM_ICDF(1619), AOM_ICDF(4706), AOM_ICDF(4788),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(24769), AOM_ICDF(25536), AOM_ICDF(31660), AOM_ICDF(31722),
          AOM_ICDF(32768) },
        { AOM_ICDF(18113), AOM_ICDF(18886), AOM_ICDF(29420), AOM_ICDF(29534),
          AOM_ICDF(32768) },
        { AOM_ICDF(11201), AOM_ICDF(11412), AOM_ICDF(23207), AOM_ICDF(23291),
          AOM_ICDF(32768) },
        { AOM_ICDF(6977), AOM_ICDF(7033), AOM_ICDF(16599), AOM_ICDF(16646),
          AOM_ICDF(32768) },
        { AOM_ICDF(4033), AOM_ICDF(4070), AOM_ICDF(10375), AOM_ICDF(10441),
          AOM_ICDF(32768) },
        { AOM_ICDF(1601), AOM_ICDF(1620), AOM_ICDF(4827), AOM_ICDF(4909),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(28353), AOM_ICDF(28831), AOM_ICDF(32502), AOM_ICDF(32517),
          AOM_ICDF(32768) },
        { AOM_ICDF(21441), AOM_ICDF(21869), AOM_ICDF(30977), AOM_ICDF(31017),
          AOM_ICDF(32768) },
        { AOM_ICDF(11969), AOM_ICDF(12088), AOM_ICDF(24116), AOM_ICDF(24158),
          AOM_ICDF(32768) },
        { AOM_ICDF(7489), AOM_ICDF(7547), AOM_ICDF(17413), AOM_ICDF(17458),
          AOM_ICDF(32768) },
        { AOM_ICDF(4545), AOM_ICDF(4585), AOM_ICDF(11325), AOM_ICDF(11388),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2133), AOM_ICDF(5526), AOM_ICDF(5606),
          AOM_ICDF(32768) } } },
    {   // Intra
      { // Band 0
        { AOM_ICDF(2496), AOM_ICDF(8717), AOM_ICDF(17280), AOM_ICDF(28922),
          AOM_ICDF(29751), AOM_ICDF(32768) },
        { AOM_ICDF(2496), AOM_ICDF(9665), AOM_ICDF(15235), AOM_ICDF(26542),
          AOM_ICDF(27580), AOM_ICDF(32768) },
        { AOM_ICDF(448), AOM_ICDF(9240), AOM_ICDF(11886), AOM_ICDF(24124),
          AOM_ICDF(24898), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(21057), AOM_ICDF(22896), AOM_ICDF(31877), AOM_ICDF(31953),
          AOM_ICDF(32768) },
        { AOM_ICDF(20673), AOM_ICDF(23151), AOM_ICDF(31706), AOM_ICDF(31825),
          AOM_ICDF(32768) },
        { AOM_ICDF(18753), AOM_ICDF(20519), AOM_ICDF(30497), AOM_ICDF(30668),
          AOM_ICDF(32768) },
        { AOM_ICDF(15425), AOM_ICDF(16608), AOM_ICDF(27789), AOM_ICDF(28027),
          AOM_ICDF(32768) },
        { AOM_ICDF(10305), AOM_ICDF(10977), AOM_ICDF(21405), AOM_ICDF(21749),
          AOM_ICDF(32768) },
        { AOM_ICDF(3649), AOM_ICDF(3812), AOM_ICDF(11213), AOM_ICDF(11445),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(24001), AOM_ICDF(25899), AOM_ICDF(32307), AOM_ICDF(32360),
          AOM_ICDF(32768) },
        { AOM_ICDF(20929), AOM_ICDF(22941), AOM_ICDF(31775), AOM_ICDF(31867),
          AOM_ICDF(32768) },
        { AOM_ICDF(15169), AOM_ICDF(16734), AOM_ICDF(29228), AOM_ICDF(29425),
          AOM_ICDF(32768) },
        { AOM_ICDF(10561), AOM_ICDF(12047), AOM_ICDF(24918), AOM_ICDF(25324),
          AOM_ICDF(32768) },
        { AOM_ICDF(6977), AOM_ICDF(7929), AOM_ICDF(18311), AOM_ICDF(18918),
          AOM_ICDF(32768) },
        { AOM_ICDF(3649), AOM_ICDF(3760), AOM_ICDF(9962), AOM_ICDF(10162),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(25793), AOM_ICDF(27526), AOM_ICDF(32565), AOM_ICDF(32591),
          AOM_ICDF(32768) },
        { AOM_ICDF(21825), AOM_ICDF(23885), AOM_ICDF(32064), AOM_ICDF(32135),
          AOM_ICDF(32768) },
        { AOM_ICDF(15041), AOM_ICDF(16286), AOM_ICDF(29203), AOM_ICDF(29360),
          AOM_ICDF(32768) },
        { AOM_ICDF(10433), AOM_ICDF(11058), AOM_ICDF(24349), AOM_ICDF(24538),
          AOM_ICDF(32768) },
        { AOM_ICDF(5569), AOM_ICDF(6016), AOM_ICDF(16460), AOM_ICDF(16794),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(26433), AOM_ICDF(28398), AOM_ICDF(32682), AOM_ICDF(32696),
          AOM_ICDF(32768) },
        { AOM_ICDF(22977), AOM_ICDF(25086), AOM_ICDF(32367), AOM_ICDF(32412),
          AOM_ICDF(32768) },
        { AOM_ICDF(16577), AOM_ICDF(17928), AOM_ICDF(30144), AOM_ICDF(30275),
          AOM_ICDF(32768) },
        { AOM_ICDF(12481), AOM_ICDF(13352), AOM_ICDF(25993), AOM_ICDF(26211),
          AOM_ICDF(32768) },
        { AOM_ICDF(7745), AOM_ICDF(8069), AOM_ICDF(20501), AOM_ICDF(20657),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(16450), AOM_ICDF(16545), AOM_ICDF(16593),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(27841), AOM_ICDF(29700), AOM_ICDF(32721), AOM_ICDF(32730),
          AOM_ICDF(32768) },
        { AOM_ICDF(23873), AOM_ICDF(26202), AOM_ICDF(32578), AOM_ICDF(32604),
          AOM_ICDF(32768) },
        { AOM_ICDF(17729), AOM_ICDF(19046), AOM_ICDF(30448), AOM_ICDF(30568),
          AOM_ICDF(32768) },
        { AOM_ICDF(13505), AOM_ICDF(14508), AOM_ICDF(26034), AOM_ICDF(26304),
          AOM_ICDF(32768) },
        { AOM_ICDF(10049), AOM_ICDF(10494), AOM_ICDF(19945), AOM_ICDF(20233),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2183), AOM_ICDF(7202), AOM_ICDF(7377),
          AOM_ICDF(32768) } } } },
  {     // UV plane
    {   // Inter
      { // Band 0
        { AOM_ICDF(27072), AOM_ICDF(27916), AOM_ICDF(31095), AOM_ICDF(32400),
          AOM_ICDF(32553), AOM_ICDF(32768) },
        { AOM_ICDF(12352), AOM_ICDF(16792), AOM_ICDF(22516), AOM_ICDF(28853),
          AOM_ICDF(29797), AOM_ICDF(32768) },
        { AOM_ICDF(2880), AOM_ICDF(9023), AOM_ICDF(11126), AOM_ICDF(20602),
          AOM_ICDF(21713), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(20161), AOM_ICDF(24785), AOM_ICDF(31070), AOM_ICDF(31430),
          AOM_ICDF(32768) },
        { AOM_ICDF(17985), AOM_ICDF(22773), AOM_ICDF(30430), AOM_ICDF(30880),
          AOM_ICDF(32768) },
        { AOM_ICDF(15937), AOM_ICDF(18802), AOM_ICDF(28265), AOM_ICDF(28788),
          AOM_ICDF(32768) },
        { AOM_ICDF(11841), AOM_ICDF(13587), AOM_ICDF(24798), AOM_ICDF(25335),
          AOM_ICDF(32768) },
        { AOM_ICDF(8769), AOM_ICDF(9160), AOM_ICDF(19316), AOM_ICDF(19566),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5357), AOM_ICDF(12874), AOM_ICDF(12932),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(24129), AOM_ICDF(26501), AOM_ICDF(31672), AOM_ICDF(31844),
          AOM_ICDF(32768) },
        { AOM_ICDF(19649), AOM_ICDF(21553), AOM_ICDF(30130), AOM_ICDF(30370),
          AOM_ICDF(32768) },
        { AOM_ICDF(11713), AOM_ICDF(13134), AOM_ICDF(25983), AOM_ICDF(26321),
          AOM_ICDF(32768) },
        { AOM_ICDF(9409), AOM_ICDF(9948), AOM_ICDF(21408), AOM_ICDF(21663),
          AOM_ICDF(32768) },
        { AOM_ICDF(5569), AOM_ICDF(5757), AOM_ICDF(14335), AOM_ICDF(14533),
          AOM_ICDF(32768) },
        { AOM_ICDF(2241), AOM_ICDF(2305), AOM_ICDF(13152), AOM_ICDF(13209),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(26817), AOM_ICDF(28135), AOM_ICDF(32130), AOM_ICDF(32209),
          AOM_ICDF(32768) },
        { AOM_ICDF(20161), AOM_ICDF(21412), AOM_ICDF(30331), AOM_ICDF(30481),
          AOM_ICDF(32768) },
        { AOM_ICDF(13377), AOM_ICDF(13798), AOM_ICDF(26065), AOM_ICDF(26176),
          AOM_ICDF(32768) },
        { AOM_ICDF(8129), AOM_ICDF(8290), AOM_ICDF(19920), AOM_ICDF(20008),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(5751), AOM_ICDF(14950), AOM_ICDF(15002),
          AOM_ICDF(32768) },
        { AOM_ICDF(5569), AOM_ICDF(5601), AOM_ICDF(11041), AOM_ICDF(11105),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(28225), AOM_ICDF(29079), AOM_ICDF(32387), AOM_ICDF(32426),
          AOM_ICDF(32768) },
        { AOM_ICDF(21185), AOM_ICDF(22046), AOM_ICDF(30982), AOM_ICDF(31061),
          AOM_ICDF(32768) },
        { AOM_ICDF(13377), AOM_ICDF(13595), AOM_ICDF(25762), AOM_ICDF(25824),
          AOM_ICDF(32768) },
        { AOM_ICDF(8001), AOM_ICDF(8123), AOM_ICDF(20530), AOM_ICDF(20590),
          AOM_ICDF(32768) },
        { AOM_ICDF(4289), AOM_ICDF(4322), AOM_ICDF(9907), AOM_ICDF(9974),
          AOM_ICDF(32768) },
        { AOM_ICDF(3393), AOM_ICDF(3412), AOM_ICDF(6663), AOM_ICDF(6739),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(30529), AOM_ICDF(31014), AOM_ICDF(32651), AOM_ICDF(32664),
          AOM_ICDF(32768) },
        { AOM_ICDF(23489), AOM_ICDF(24268), AOM_ICDF(31627), AOM_ICDF(31682),
          AOM_ICDF(32768) },
        { AOM_ICDF(14017), AOM_ICDF(14239), AOM_ICDF(26653), AOM_ICDF(26707),
          AOM_ICDF(32768) },
        { AOM_ICDF(11201), AOM_ICDF(11317), AOM_ICDF(23122), AOM_ICDF(23169),
          AOM_ICDF(32768) },
        { AOM_ICDF(6721), AOM_ICDF(6768), AOM_ICDF(14810), AOM_ICDF(14863),
          AOM_ICDF(32768) },
        { AOM_ICDF(6593), AOM_ICDF(6632), AOM_ICDF(13188), AOM_ICDF(13245),
          AOM_ICDF(32768) } } },
    {   // Inter
      { // Band 0
        { AOM_ICDF(29888), AOM_ICDF(30492), AOM_ICDF(32500), AOM_ICDF(32766),
          AOM_ICDF(32767), AOM_ICDF(32768) },
        { AOM_ICDF(18752), AOM_ICDF(23235), AOM_ICDF(29846), AOM_ICDF(32214),
          AOM_ICDF(32442), AOM_ICDF(32768) },
        { AOM_ICDF(5568), AOM_ICDF(17762), AOM_ICDF(25039), AOM_ICDF(31213),
          AOM_ICDF(31651), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(26433), AOM_ICDF(29681), AOM_ICDF(32757), AOM_ICDF(32760),
          AOM_ICDF(32768) },
        { AOM_ICDF(24769), AOM_ICDF(28761), AOM_ICDF(32722), AOM_ICDF(32734),
          AOM_ICDF(32768) },
        { AOM_ICDF(22209), AOM_ICDF(26975), AOM_ICDF(32418), AOM_ICDF(32500),
          AOM_ICDF(32768) },
        { AOM_ICDF(16321), AOM_ICDF(21333), AOM_ICDF(28368), AOM_ICDF(29283),
          AOM_ICDF(32768) },
        { AOM_ICDF(12865), AOM_ICDF(14775), AOM_ICDF(22545), AOM_ICDF(23553),
          AOM_ICDF(32768) },
        { AOM_ICDF(12353), AOM_ICDF(12354), AOM_ICDF(12473), AOM_ICDF(12532),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(27457), AOM_ICDF(30005), AOM_ICDF(32738), AOM_ICDF(32745),
          AOM_ICDF(32768) },
        { AOM_ICDF(24897), AOM_ICDF(27541), AOM_ICDF(32723), AOM_ICDF(32731),
          AOM_ICDF(32768) },
        { AOM_ICDF(15297), AOM_ICDF(19106), AOM_ICDF(30414), AOM_ICDF(30711),
          AOM_ICDF(32768) },
        { AOM_ICDF(6593), AOM_ICDF(8826), AOM_ICDF(19732), AOM_ICDF(20840),
          AOM_ICDF(32768) },
        { AOM_ICDF(4161), AOM_ICDF(4233), AOM_ICDF(16509), AOM_ICDF(16557),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2652), AOM_ICDF(7276), AOM_ICDF(7351),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(28609), AOM_ICDF(30482), AOM_ICDF(32761), AOM_ICDF(32763),
          AOM_ICDF(32768) },
        { AOM_ICDF(25665), AOM_ICDF(27830), AOM_ICDF(32727), AOM_ICDF(32733),
          AOM_ICDF(32768) },
        { AOM_ICDF(21057), AOM_ICDF(23803), AOM_ICDF(30367), AOM_ICDF(30721),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(21878), AOM_ICDF(32726), AOM_ICDF(32737),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(5750), AOM_ICDF(14739), AOM_ICDF(14792),
          AOM_ICDF(32768) },
        { AOM_ICDF(2881), AOM_ICDF(2913), AOM_ICDF(8427), AOM_ICDF(8498),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(28993), AOM_ICDF(30944), AOM_ICDF(32762), AOM_ICDF(32764),
          AOM_ICDF(32768) },
        { AOM_ICDF(26561), AOM_ICDF(28695), AOM_ICDF(32733), AOM_ICDF(32739),
          AOM_ICDF(32768) },
        { AOM_ICDF(17985), AOM_ICDF(19028), AOM_ICDF(31008), AOM_ICDF(31079),
          AOM_ICDF(32768) },
        { AOM_ICDF(7873), AOM_ICDF(8039), AOM_ICDF(19981), AOM_ICDF(20068),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5366), AOM_ICDF(14376), AOM_ICDF(14430),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(2789), AOM_ICDF(8909), AOM_ICDF(8979),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(30273), AOM_ICDF(32029), AOM_ICDF(32764), AOM_ICDF(32766),
          AOM_ICDF(32768) },
        { AOM_ICDF(28609), AOM_ICDF(30847), AOM_ICDF(32745), AOM_ICDF(32751),
          AOM_ICDF(32768) },
        { AOM_ICDF(21313), AOM_ICDF(24377), AOM_ICDF(31986), AOM_ICDF(32098),
          AOM_ICDF(32768) },
        { AOM_ICDF(32705), AOM_ICDF(32709), AOM_ICDF(32739), AOM_ICDF(32741),
          AOM_ICDF(32768) },
        { AOM_ICDF(4929), AOM_ICDF(5579), AOM_ICDF(16402), AOM_ICDF(16866),
          AOM_ICDF(32768) },
        { AOM_ICDF(3009), AOM_ICDF(3246), AOM_ICDF(10158), AOM_ICDF(10533),
          AOM_ICDF(32768) } } } }
};
static const coeff_cdf_model default_coef_head_cdf_32x32[PLANE_TYPES] = {
  {     // Y plane
    {   // Intra
      { // Band 0
        { AOM_ICDF(2240), AOM_ICDF(5407), AOM_ICDF(18304), AOM_ICDF(25601),
          AOM_ICDF(27911), AOM_ICDF(32768) },
        { AOM_ICDF(960), AOM_ICDF(4633), AOM_ICDF(8197), AOM_ICDF(16254),
          AOM_ICDF(18796), AOM_ICDF(32768) },
        { AOM_ICDF(192), AOM_ICDF(3061), AOM_ICDF(3557), AOM_ICDF(8701),
          AOM_ICDF(9762), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(11969), AOM_ICDF(15846), AOM_ICDF(25660), AOM_ICDF(26667),
          AOM_ICDF(32768) },
        { AOM_ICDF(11713), AOM_ICDF(15794), AOM_ICDF(25737), AOM_ICDF(26760),
          AOM_ICDF(32768) },
        { AOM_ICDF(9281), AOM_ICDF(12675), AOM_ICDF(23181), AOM_ICDF(24351),
          AOM_ICDF(32768) },
        { AOM_ICDF(7105), AOM_ICDF(8757), AOM_ICDF(18383), AOM_ICDF(19437),
          AOM_ICDF(32768) },
        { AOM_ICDF(4289), AOM_ICDF(4579), AOM_ICDF(11353), AOM_ICDF(11792),
          AOM_ICDF(32768) },
        { AOM_ICDF(1857), AOM_ICDF(1874), AOM_ICDF(4695), AOM_ICDF(4777),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(20929), AOM_ICDF(22297), AOM_ICDF(29370), AOM_ICDF(29646),
          AOM_ICDF(32768) },
        { AOM_ICDF(17473), AOM_ICDF(18985), AOM_ICDF(28079), AOM_ICDF(28413),
          AOM_ICDF(32768) },
        { AOM_ICDF(13121), AOM_ICDF(14064), AOM_ICDF(24902), AOM_ICDF(25217),
          AOM_ICDF(32768) },
        { AOM_ICDF(9793), AOM_ICDF(10214), AOM_ICDF(20069), AOM_ICDF(20329),
          AOM_ICDF(32768) },
        { AOM_ICDF(5825), AOM_ICDF(5987), AOM_ICDF(13350), AOM_ICDF(13559),
          AOM_ICDF(32768) },
        { AOM_ICDF(2241), AOM_ICDF(2260), AOM_ICDF(5520), AOM_ICDF(5600),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(25921), AOM_ICDF(26891), AOM_ICDF(31632), AOM_ICDF(31729),
          AOM_ICDF(32768) },
        { AOM_ICDF(18241), AOM_ICDF(19463), AOM_ICDF(29222), AOM_ICDF(29419),
          AOM_ICDF(32768) },
        { AOM_ICDF(11585), AOM_ICDF(12065), AOM_ICDF(23294), AOM_ICDF(23488),
          AOM_ICDF(32768) },
        { AOM_ICDF(6593), AOM_ICDF(6686), AOM_ICDF(16153), AOM_ICDF(16234),
          AOM_ICDF(32768) },
        { AOM_ICDF(3137), AOM_ICDF(3170), AOM_ICDF(8751), AOM_ICDF(8821),
          AOM_ICDF(32768) },
        { AOM_ICDF(1345), AOM_ICDF(1359), AOM_ICDF(3739), AOM_ICDF(3824),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(27713), AOM_ICDF(28504), AOM_ICDF(32068), AOM_ICDF(32132),
          AOM_ICDF(32768) },
        { AOM_ICDF(19265), AOM_ICDF(20354), AOM_ICDF(29789), AOM_ICDF(29943),
          AOM_ICDF(32768) },
        { AOM_ICDF(11201), AOM_ICDF(11538), AOM_ICDF(22701), AOM_ICDF(22848),
          AOM_ICDF(32768) },
        { AOM_ICDF(6337), AOM_ICDF(6424), AOM_ICDF(15268), AOM_ICDF(15353),
          AOM_ICDF(32768) },
        { AOM_ICDF(3649), AOM_ICDF(3681), AOM_ICDF(9052), AOM_ICDF(9121),
          AOM_ICDF(32768) },
        { AOM_ICDF(1601), AOM_ICDF(1618), AOM_ICDF(4584), AOM_ICDF(4667),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(30913), AOM_ICDF(31044), AOM_ICDF(32635), AOM_ICDF(32640),
          AOM_ICDF(32768) },
        { AOM_ICDF(22081), AOM_ICDF(22261), AOM_ICDF(30452), AOM_ICDF(30477),
          AOM_ICDF(32768) },
        { AOM_ICDF(10561), AOM_ICDF(10625), AOM_ICDF(21535), AOM_ICDF(21568),
          AOM_ICDF(32768) },
        { AOM_ICDF(6081), AOM_ICDF(6130), AOM_ICDF(14369), AOM_ICDF(14423),
          AOM_ICDF(32768) },
        { AOM_ICDF(3777), AOM_ICDF(3809), AOM_ICDF(9156), AOM_ICDF(9225),
          AOM_ICDF(32768) },
        { AOM_ICDF(1857), AOM_ICDF(1875), AOM_ICDF(4936), AOM_ICDF(5018),
          AOM_ICDF(32768) } } },
    {   // Intra
      { // Band 0
        { AOM_ICDF(4672), AOM_ICDF(6927), AOM_ICDF(23534), AOM_ICDF(29846),
          AOM_ICDF(30928), AOM_ICDF(32768) },
        { AOM_ICDF(3776), AOM_ICDF(6784), AOM_ICDF(18075), AOM_ICDF(25863),
          AOM_ICDF(27926), AOM_ICDF(32768) },
        { AOM_ICDF(1344), AOM_ICDF(5588), AOM_ICDF(12166), AOM_ICDF(20966),
          AOM_ICDF(23504), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(19393), AOM_ICDF(22016), AOM_ICDF(31280), AOM_ICDF(31444),
          AOM_ICDF(32768) },
        { AOM_ICDF(21185), AOM_ICDF(24329), AOM_ICDF(31706), AOM_ICDF(31865),
          AOM_ICDF(32768) },
        { AOM_ICDF(20673), AOM_ICDF(23240), AOM_ICDF(31186), AOM_ICDF(31379),
          AOM_ICDF(32768) },
        { AOM_ICDF(17857), AOM_ICDF(20035), AOM_ICDF(29594), AOM_ICDF(29889),
          AOM_ICDF(32768) },
        { AOM_ICDF(13633), AOM_ICDF(14929), AOM_ICDF(24883), AOM_ICDF(25337),
          AOM_ICDF(32768) },
        { AOM_ICDF(7873), AOM_ICDF(8416), AOM_ICDF(17452), AOM_ICDF(17886),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(25665), AOM_ICDF(27145), AOM_ICDF(32256), AOM_ICDF(32314),
          AOM_ICDF(32768) },
        { AOM_ICDF(21057), AOM_ICDF(22826), AOM_ICDF(31465), AOM_ICDF(31576),
          AOM_ICDF(32768) },
        { AOM_ICDF(13633), AOM_ICDF(14885), AOM_ICDF(27873), AOM_ICDF(28088),
          AOM_ICDF(32768) },
        { AOM_ICDF(8769), AOM_ICDF(9515), AOM_ICDF(21941), AOM_ICDF(22248),
          AOM_ICDF(32768) },
        { AOM_ICDF(6209), AOM_ICDF(6594), AOM_ICDF(15598), AOM_ICDF(15950),
          AOM_ICDF(32768) },
        { AOM_ICDF(1985), AOM_ICDF(2014), AOM_ICDF(6855), AOM_ICDF(6931),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(26817), AOM_ICDF(27824), AOM_ICDF(32362), AOM_ICDF(32399),
          AOM_ICDF(32768) },
        { AOM_ICDF(21185), AOM_ICDF(22321), AOM_ICDF(31389), AOM_ICDF(31466),
          AOM_ICDF(32768) },
        { AOM_ICDF(13761), AOM_ICDF(14154), AOM_ICDF(27163), AOM_ICDF(27245),
          AOM_ICDF(32768) },
        { AOM_ICDF(8897), AOM_ICDF(9011), AOM_ICDF(20600), AOM_ICDF(20659),
          AOM_ICDF(32768) },
        { AOM_ICDF(4673), AOM_ICDF(4774), AOM_ICDF(15044), AOM_ICDF(15131),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(28865), AOM_ICDF(29687), AOM_ICDF(32655), AOM_ICDF(32667),
          AOM_ICDF(32768) },
        { AOM_ICDF(23233), AOM_ICDF(24218), AOM_ICDF(32080), AOM_ICDF(32118),
          AOM_ICDF(32768) },
        { AOM_ICDF(15041), AOM_ICDF(15444), AOM_ICDF(28787), AOM_ICDF(28845),
          AOM_ICDF(32768) },
        { AOM_ICDF(9921), AOM_ICDF(10248), AOM_ICDF(22818), AOM_ICDF(22944),
          AOM_ICDF(32768) },
        { AOM_ICDF(7745), AOM_ICDF(7866), AOM_ICDF(16591), AOM_ICDF(16702),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(31169), AOM_ICDF(31559), AOM_ICDF(32741), AOM_ICDF(32744),
          AOM_ICDF(32768) },
        { AOM_ICDF(24769), AOM_ICDF(25583), AOM_ICDF(32347), AOM_ICDF(32370),
          AOM_ICDF(32768) },
        { AOM_ICDF(15937), AOM_ICDF(16169), AOM_ICDF(29120), AOM_ICDF(29152),
          AOM_ICDF(32768) },
        { AOM_ICDF(7489), AOM_ICDF(7578), AOM_ICDF(22647), AOM_ICDF(22677),
          AOM_ICDF(32768) },
        { AOM_ICDF(7617), AOM_ICDF(7689), AOM_ICDF(19849), AOM_ICDF(19887),
          AOM_ICDF(32768) },
        { AOM_ICDF(2113), AOM_ICDF(2183), AOM_ICDF(7202), AOM_ICDF(7377),
          AOM_ICDF(32768) } } } },
  {     // UV plane
    {   // Inter
      { // Band 0
        { AOM_ICDF(23232), AOM_ICDF(24301), AOM_ICDF(30231), AOM_ICDF(31582),
          AOM_ICDF(32091), AOM_ICDF(32768) },
        { AOM_ICDF(7872), AOM_ICDF(11041), AOM_ICDF(22542), AOM_ICDF(27086),
          AOM_ICDF(29145), AOM_ICDF(32768) },
        { AOM_ICDF(1344), AOM_ICDF(3989), AOM_ICDF(18125), AOM_ICDF(25340),
          AOM_ICDF(27820), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(15937), AOM_ICDF(29000), AOM_ICDF(32210), AOM_ICDF(32434),
          AOM_ICDF(32768) },
        { AOM_ICDF(12353), AOM_ICDF(26626), AOM_ICDF(31533), AOM_ICDF(31993),
          AOM_ICDF(32768) },
        { AOM_ICDF(11457), AOM_ICDF(29187), AOM_ICDF(30896), AOM_ICDF(31750),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(21278), AOM_ICDF(28169), AOM_ICDF(29764),
          AOM_ICDF(32768) },
        { AOM_ICDF(7489), AOM_ICDF(8855), AOM_ICDF(13365), AOM_ICDF(15620),
          AOM_ICDF(32768) },
        { AOM_ICDF(4289), AOM_ICDF(4833), AOM_ICDF(8572), AOM_ICDF(10108),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(25025), AOM_ICDF(30783), AOM_ICDF(32603), AOM_ICDF(32666),
          AOM_ICDF(32768) },
        { AOM_ICDF(24385), AOM_ICDF(29586), AOM_ICDF(31803), AOM_ICDF(32142),
          AOM_ICDF(32768) },
        { AOM_ICDF(22337), AOM_ICDF(23002), AOM_ICDF(27573), AOM_ICDF(27903),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(12336), AOM_ICDF(21900), AOM_ICDF(22590),
          AOM_ICDF(32768) },
        { AOM_ICDF(8257), AOM_ICDF(8830), AOM_ICDF(19986), AOM_ICDF(20298),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(10990), AOM_ICDF(18660), AOM_ICDF(18701),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(29761), AOM_ICDF(31473), AOM_ICDF(32693), AOM_ICDF(32715),
          AOM_ICDF(32768) },
        { AOM_ICDF(20417), AOM_ICDF(24512), AOM_ICDF(31394), AOM_ICDF(31650),
          AOM_ICDF(32768) },
        { AOM_ICDF(11713), AOM_ICDF(13283), AOM_ICDF(25819), AOM_ICDF(26206),
          AOM_ICDF(32768) },
        { AOM_ICDF(13121), AOM_ICDF(14099), AOM_ICDF(21909), AOM_ICDF(22514),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(248), AOM_ICDF(9546), AOM_ICDF(9614),
          AOM_ICDF(32768) },
        { AOM_ICDF(2497), AOM_ICDF(2524), AOM_ICDF(7050), AOM_ICDF(7125),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(30657), AOM_ICDF(31885), AOM_ICDF(32691), AOM_ICDF(32715),
          AOM_ICDF(32768) },
        { AOM_ICDF(19393), AOM_ICDF(26050), AOM_ICDF(31698), AOM_ICDF(31988),
          AOM_ICDF(32768) },
        { AOM_ICDF(15809), AOM_ICDF(15863), AOM_ICDF(24985), AOM_ICDF(25008),
          AOM_ICDF(32768) },
        { AOM_ICDF(23489), AOM_ICDF(28138), AOM_ICDF(32751), AOM_ICDF(32756),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(16450), AOM_ICDF(16545), AOM_ICDF(16593),
          AOM_ICDF(32768) },
        { AOM_ICDF(2369), AOM_ICDF(2395), AOM_ICDF(6822), AOM_ICDF(6898),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(32705), AOM_ICDF(32744), AOM_ICDF(32766), AOM_ICDF(32767),
          AOM_ICDF(32768) },
        { AOM_ICDF(21953), AOM_ICDF(24962), AOM_ICDF(32156), AOM_ICDF(32246),
          AOM_ICDF(32768) },
        { AOM_ICDF(13121), AOM_ICDF(15358), AOM_ICDF(26284), AOM_ICDF(26835),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(7417), AOM_ICDF(20132), AOM_ICDF(20885),
          AOM_ICDF(32768) },
        { AOM_ICDF(4417), AOM_ICDF(4939), AOM_ICDF(15104), AOM_ICDF(15535),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2680), AOM_ICDF(8218), AOM_ICDF(8338),
          AOM_ICDF(32768) } } },
    {   // Inter
      { // Band 0
        { AOM_ICDF(25280), AOM_ICDF(25678), AOM_ICDF(32446), AOM_ICDF(32622),
          AOM_ICDF(32724), AOM_ICDF(32768) },
        { AOM_ICDF(10560), AOM_ICDF(11822), AOM_ICDF(28682), AOM_ICDF(29919),
          AOM_ICDF(31276), AOM_ICDF(32768) },
        { AOM_ICDF(3264), AOM_ICDF(5170), AOM_ICDF(21779), AOM_ICDF(24026),
          AOM_ICDF(27905), AOM_ICDF(32768) } },
      { // Band 1
        { AOM_ICDF(24257), AOM_ICDF(30554), AOM_ICDF(32719), AOM_ICDF(32738),
          AOM_ICDF(32768) },
        { AOM_ICDF(17217), AOM_ICDF(27413), AOM_ICDF(32617), AOM_ICDF(32667),
          AOM_ICDF(32768) },
        { AOM_ICDF(22977), AOM_ICDF(27600), AOM_ICDF(32482), AOM_ICDF(32552),
          AOM_ICDF(32768) },
        { AOM_ICDF(16833), AOM_ICDF(24360), AOM_ICDF(30746), AOM_ICDF(31293),
          AOM_ICDF(32768) },
        { AOM_ICDF(17089), AOM_ICDF(20060), AOM_ICDF(28880), AOM_ICDF(29370),
          AOM_ICDF(32768) },
        { AOM_ICDF(10945), AOM_ICDF(11009), AOM_ICDF(21900), AOM_ICDF(21932),
          AOM_ICDF(32768) } },
      { // Band 2
        { AOM_ICDF(27201), AOM_ICDF(30217), AOM_ICDF(32736), AOM_ICDF(32745),
          AOM_ICDF(32768) },
        { AOM_ICDF(22721), AOM_ICDF(27676), AOM_ICDF(32749), AOM_ICDF(32754),
          AOM_ICDF(32768) },
        { AOM_ICDF(5057), AOM_ICDF(12431), AOM_ICDF(25246), AOM_ICDF(26620),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(321), AOM_ICDF(22016), AOM_ICDF(22048),
          AOM_ICDF(32768) },
        { AOM_ICDF(5313), AOM_ICDF(5363), AOM_ICDF(13839), AOM_ICDF(13894),
          AOM_ICDF(32768) },
        { AOM_ICDF(2625), AOM_ICDF(2652), AOM_ICDF(7276), AOM_ICDF(7351),
          AOM_ICDF(32768) } },
      { // Band 3
        { AOM_ICDF(27713), AOM_ICDF(30739), AOM_ICDF(32759), AOM_ICDF(32762),
          AOM_ICDF(32768) },
        { AOM_ICDF(26177), AOM_ICDF(30430), AOM_ICDF(32756), AOM_ICDF(32760),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(384), AOM_ICDF(32706), AOM_ICDF(32707),
          AOM_ICDF(32768) },
        { AOM_ICDF(9409), AOM_ICDF(9528), AOM_ICDF(21591), AOM_ICDF(21646),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) },
        { AOM_ICDF(2881), AOM_ICDF(2913), AOM_ICDF(8427), AOM_ICDF(8498),
          AOM_ICDF(32768) } },
      { // Band 4
        { AOM_ICDF(28993), AOM_ICDF(31156), AOM_ICDF(32747), AOM_ICDF(32753),
          AOM_ICDF(32768) },
        { AOM_ICDF(25153), AOM_ICDF(28701), AOM_ICDF(32754), AOM_ICDF(32758),
          AOM_ICDF(32768) },
        { AOM_ICDF(16449), AOM_ICDF(16544), AOM_ICDF(32737), AOM_ICDF(32738),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(321), AOM_ICDF(22016), AOM_ICDF(22048),
          AOM_ICDF(32768) },
        { AOM_ICDF(193), AOM_ICDF(194), AOM_ICDF(384), AOM_ICDF(479),
          AOM_ICDF(32768) },
        { AOM_ICDF(2753), AOM_ICDF(2789), AOM_ICDF(8909), AOM_ICDF(8979),
          AOM_ICDF(32768) } },
      { // Band 5
        { AOM_ICDF(30785), AOM_ICDF(32088), AOM_ICDF(32765), AOM_ICDF(32766),
          AOM_ICDF(32768) },
        { AOM_ICDF(22977), AOM_ICDF(26623), AOM_ICDF(32750), AOM_ICDF(32754),
          AOM_ICDF(32768) },
        { AOM_ICDF(21953), AOM_ICDF(21954), AOM_ICDF(22017), AOM_ICDF(22049),
          AOM_ICDF(32768) },
        { AOM_ICDF(5697), AOM_ICDF(7486), AOM_ICDF(20238), AOM_ICDF(21009),
          AOM_ICDF(32768) },
        { AOM_ICDF(4929), AOM_ICDF(5579), AOM_ICDF(16402), AOM_ICDF(16866),
          AOM_ICDF(32768) },
        { AOM_ICDF(3009), AOM_ICDF(3246), AOM_ICDF(10158), AOM_ICDF(10533),
          AOM_ICDF(32768) } } } }
};

/* clang-format on */
#endif  // !CONFIG_Q_ADAPT_PROBS

static void build_tail_cdfs(aom_cdf_prob cdf_tail[CDF_SIZE(ENTROPY_TOKENS)],
                            aom_cdf_prob cdf_head[CDF_SIZE(ENTROPY_TOKENS)],
                            int band_zero) {
  int probNZ, prob1, prob_idx, i;
  int phead[HEAD_TOKENS + 1], sum;
  const int is_dc = !!band_zero;
  aom_cdf_prob prev_cdf;
  prev_cdf = 0;
  for (i = 0; i < HEAD_TOKENS + is_dc; ++i) {
    phead[i] = AOM_ICDF(cdf_head[i]) - prev_cdf;
    prev_cdf = AOM_ICDF(cdf_head[i]);
  }
  // Do the tail
  probNZ = CDF_PROB_TOP - phead[ZERO_TOKEN + is_dc] - (is_dc ? phead[0] : 0);
  prob1 = phead[is_dc + ONE_TOKEN_EOB] + phead[is_dc + ONE_TOKEN_NEOB];
  prob_idx =
      AOMMIN(COEFF_PROB_MODELS - 1, AOMMAX(0, ((256 * prob1) / probNZ) - 1));

  sum = 0;
  for (i = 0; i < TAIL_TOKENS; ++i) {
    sum += av1_pareto8_tail_probs[prob_idx][i];
    cdf_tail[i] = AOM_ICDF(sum);
  }
}

#if !CONFIG_Q_ADAPT_PROBS
// FIXME. Optimize for TX_2X2 and TX_64X64.
static void av1_default_coef_cdfs(FRAME_CONTEXT *fc) {
#if CONFIG_CHROMA_2X2
  av1_copy(fc->coef_head_cdfs[TX_2X2], default_coef_head_cdf_4x4);
#endif  // CONFIG_CHROMA_2X2
  av1_copy(fc->coef_head_cdfs[TX_4X4], default_coef_head_cdf_4x4);
  av1_copy(fc->coef_head_cdfs[TX_8X8], default_coef_head_cdf_8x8);
  av1_copy(fc->coef_head_cdfs[TX_16X16], default_coef_head_cdf_16x16);
  av1_copy(fc->coef_head_cdfs[TX_32X32], default_coef_head_cdf_32x32);
#if CONFIG_TX64X64
  av1_copy(fc->coef_head_cdfs[TX_64X64], default_coef_head_cdf_32x32);
#endif  // CONFIG_TX64X64
}
#endif  // !CONFIG_Q_ADAPT_PROBS

void av1_coef_pareto_cdfs(FRAME_CONTEXT *fc) {
  /* Build the tail based on a Pareto distribution */
  TX_SIZE t;
  int i, j, k, l;
  for (t = 0; t < TX_SIZES; ++t)
    for (i = 0; i < PLANE_TYPES; ++i)
      for (j = 0; j < REF_TYPES; ++j)
        for (k = 0; k < COEF_BANDS; ++k)
          for (l = 0; l < BAND_COEFF_CONTEXTS(k); ++l)
            build_tail_cdfs(fc->coef_tail_cdfs[t][i][j][k][l],
                            fc->coef_head_cdfs[t][i][j][k][l], k == 0);
}

void av1_default_coef_probs(AV1_COMMON *cm) {
#if CONFIG_Q_ADAPT_PROBS
  const int index = AOMMIN(TOKEN_CDF_Q_CTXS - 1, cm->base_qindex / 64);
#if CONFIG_CHROMA_2X2
  av1_copy(cm->fc->coef_head_cdfs[TX_2X2],
           (*av1_default_qctx_coef_cdfs[index])[TX_4X4]);
#endif  // CONFIG_CHROMA_2X2
  av1_copy(cm->fc->coef_head_cdfs[TX_4X4],
           (*av1_default_qctx_coef_cdfs[index])[TX_4X4]);
  av1_copy(cm->fc->coef_head_cdfs[TX_8X8],
           (*av1_default_qctx_coef_cdfs[index])[TX_8X8]);
  av1_copy(cm->fc->coef_head_cdfs[TX_16X16],
           (*av1_default_qctx_coef_cdfs[index])[TX_16X16]);
  av1_copy(cm->fc->coef_head_cdfs[TX_32X32],
           (*av1_default_qctx_coef_cdfs[index])[TX_32X32]);
#if CONFIG_TX64X64
  av1_copy(cm->fc->coef_head_cdfs[TX_64X64],
           (*av1_default_qctx_coef_cdfs[index])[TX_32X32]);
#endif  // CONFIG_TX64X64
#else
  /* Load the head tokens */
  av1_default_coef_cdfs(cm->fc);
#endif  // CONFIG_Q_ADAPT_PROBS
  av1_coef_pareto_cdfs(cm->fc);
}

#if CONFIG_LV_MAP
void av1_adapt_coef_probs(AV1_COMMON *cm) {
  unsigned int count_sat, update_factor;
  if (!frame_is_intra_only(cm) && cm->last_frame_type == KEY_FRAME) {
    update_factor = COEF_MAX_UPDATE_FACTOR_AFTER_KEY; /* adapt quickly */
    count_sat = COEF_COUNT_SAT_AFTER_KEY;
  } else {
    update_factor = COEF_MAX_UPDATE_FACTOR;
    count_sat = COEF_COUNT_SAT;
  }
  av1_adapt_txb_probs(cm, count_sat, update_factor);
}
#endif  // CONFIG_LV_MAP

static void av1_average_cdf(aom_cdf_prob *cdf_ptr[], aom_cdf_prob *fc_cdf_ptr,
                            int cdf_size, const int num_tiles) {
  int i;
  for (i = 0; i < cdf_size;) {
    do {
      int sum = 0;
      int j;
      assert(i < cdf_size);
      for (j = 0; j < num_tiles; ++j) sum += AOM_ICDF(cdf_ptr[j][i]);
      fc_cdf_ptr[i] = AOM_ICDF(sum / num_tiles);
    } while (fc_cdf_ptr[i++] != AOM_ICDF(CDF_PROB_TOP));
    // Zero symbol counts for the next frame
    assert(i < cdf_size);
    fc_cdf_ptr[i++] = 0;
    // Skip trailing zeros until the start of the next CDF.
    for (; i < cdf_size && fc_cdf_ptr[i] == 0; ++i) {
    }
  }
}

#define AVERAGE_TILE_CDFS(cname)                            \
  for (i = 0; i < num_tiles; ++i)                           \
    cdf_ptr[i] = (aom_cdf_prob *)&ec_ctxs[i]->cname;        \
  fc_cdf_ptr = (aom_cdf_prob *)&fc->cname;                  \
  cdf_size = (int)sizeof(fc->cname) / sizeof(aom_cdf_prob); \
  av1_average_cdf(cdf_ptr, fc_cdf_ptr, cdf_size, num_tiles);

void av1_average_tile_coef_cdfs(FRAME_CONTEXT *fc, FRAME_CONTEXT *ec_ctxs[],
                                aom_cdf_prob *cdf_ptr[], int num_tiles) {
  int i, cdf_size;

  aom_cdf_prob *fc_cdf_ptr;

#if CONFIG_LV_MAP
  AVERAGE_TILE_CDFS(txb_skip_cdf)
  AVERAGE_TILE_CDFS(nz_map_cdf)
  AVERAGE_TILE_CDFS(eob_flag_cdf)
  AVERAGE_TILE_CDFS(dc_sign_cdf)
  AVERAGE_TILE_CDFS(coeff_base_cdf)
  AVERAGE_TILE_CDFS(coeff_lps_cdf)
#if BR_NODE
  AVERAGE_TILE_CDFS(coeff_br_cdf)
#endif
#if CONFIG_CTX1D
  AVERAGE_TILE_CDFS(eob_mode_cdf)
  AVERAGE_TILE_CDFS(empty_line_cdf)
  AVERAGE_TILE_CDFS(hv_eob_cdf)
#endif
#else
  AVERAGE_TILE_CDFS(coef_head_cdfs)
  AVERAGE_TILE_CDFS(coef_tail_cdfs)
#endif
}

void av1_average_tile_mv_cdfs(FRAME_CONTEXT *fc, FRAME_CONTEXT *ec_ctxs[],
                              aom_cdf_prob *cdf_ptr[], int num_tiles) {
  int i, k, cdf_size;

  aom_cdf_prob *fc_cdf_ptr;

  int j;
  for (j = 0; j < NMV_CONTEXTS; ++j) {
    AVERAGE_TILE_CDFS(nmvc[j].joint_cdf)

    for (k = 0; k < 2; ++k) {
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].class_cdf)
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].class0_fp_cdf)
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].fp_cdf)
#if CONFIG_NEW_MULTISYMBOL
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].hp_cdf)
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].class0_hp_cdf)
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].class0_cdf)
      AVERAGE_TILE_CDFS(nmvc[j].comps[k].bits_cdf)
#endif
    }
  }
}

void av1_average_tile_intra_cdfs(FRAME_CONTEXT *fc, FRAME_CONTEXT *ec_ctxs[],
                                 aom_cdf_prob *cdf_ptr[], int num_tiles) {
  int i, cdf_size;

  aom_cdf_prob *fc_cdf_ptr;

  AVERAGE_TILE_CDFS(tx_size_cdf)

  AVERAGE_TILE_CDFS(intra_ext_tx_cdf)
  AVERAGE_TILE_CDFS(inter_ext_tx_cdf)

  AVERAGE_TILE_CDFS(seg.tree_cdf)
#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(seg.pred_cdf)
#endif
  AVERAGE_TILE_CDFS(uv_mode_cdf)

#if CONFIG_CFL
  AVERAGE_TILE_CDFS(cfl_sign_cdf)
  AVERAGE_TILE_CDFS(cfl_alpha_cdf)
#endif

  AVERAGE_TILE_CDFS(partition_cdf)

  AVERAGE_TILE_CDFS(delta_q_cdf)
#if CONFIG_EXT_DELTA_Q
  AVERAGE_TILE_CDFS(delta_lf_cdf)
#endif
#if CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP
  AVERAGE_TILE_CDFS(intra_filter_cdf)
#endif  // CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP

#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(skip_cdfs)
#if CONFIG_VAR_TX
  AVERAGE_TILE_CDFS(txfm_partition_cdf)
#endif
#endif  // CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(palette_y_size_cdf)
  AVERAGE_TILE_CDFS(palette_uv_size_cdf)
  AVERAGE_TILE_CDFS(palette_y_color_index_cdf)
  AVERAGE_TILE_CDFS(palette_uv_color_index_cdf)
#if CONFIG_MRC_TX
  AVERAGE_TILE_CDFS(mrc_mask_intra_cdf)
#endif  // CONFIG_MRC_TX
#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(palette_y_mode_cdf)
  AVERAGE_TILE_CDFS(palette_uv_mode_cdf)
#if CONFIG_RECT_TX_EXT && (CONFIG_EXT_TX || CONFIG_VAR_TX)
  AVERAGE_TILE_CDFS(quarter_tx_size_cdf)
#endif
#endif
#if CONFIG_LPF_SB
  AVERAGE_TILE_CDFS(lpf_reuse_cdf);
  AVERAGE_TILE_CDFS(lpf_delta_cdf);
  AVERAGE_TILE_CDFS(lpf_sign_cdf);
#endif  // CONFIG_LPF_SB
}

void av1_average_tile_inter_cdfs(AV1_COMMON *cm, FRAME_CONTEXT *fc,
                                 FRAME_CONTEXT *ec_ctxs[],
                                 aom_cdf_prob *cdf_ptr[], int num_tiles) {
  int i, cdf_size;

  aom_cdf_prob *fc_cdf_ptr;

#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(comp_inter_cdf)
#if CONFIG_EXT_REFS
  AVERAGE_TILE_CDFS(comp_ref_cdf)
  AVERAGE_TILE_CDFS(comp_bwdref_cdf)
#endif
#endif

#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(single_ref_cdf)

  AVERAGE_TILE_CDFS(newmv_cdf)
  AVERAGE_TILE_CDFS(zeromv_cdf)
  AVERAGE_TILE_CDFS(refmv_cdf)
  AVERAGE_TILE_CDFS(drl_cdf)
#if CONFIG_EXT_COMP_REFS
  AVERAGE_TILE_CDFS(uni_comp_ref_cdf)
  AVERAGE_TILE_CDFS(comp_ref_type_cdf)
#endif
#endif

  // FIXME: cdfs not defined for super_tx

  AVERAGE_TILE_CDFS(inter_compound_mode_cdf)

#if CONFIG_WEDGE || CONFIG_COMPOUND_SEGMENT
  AVERAGE_TILE_CDFS(compound_type_cdf)
#endif  // CONFIG_WEDGE || CONFIG_COMPOUND_SEGMENT
#if CONFIG_COMPOUND_SINGLEREF
  AVERAGE_TILE_CDFS(inter_singleref_comp_mode_cdf)
#endif

#if CONFIG_INTERINTRA
#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(interintra_cdf)
  AVERAGE_TILE_CDFS(wedge_interintra_cdf)
#endif
  AVERAGE_TILE_CDFS(interintra_mode_cdf)
#endif

  /* NB: kf_y_cdf is discarded after use, so no need
     for backwards update */
  AVERAGE_TILE_CDFS(y_mode_cdf)

  if (cm->interp_filter == SWITCHABLE) {
    AVERAGE_TILE_CDFS(switchable_interp_cdf)
  }
#if CONFIG_NEW_MULTISYMBOL
  AVERAGE_TILE_CDFS(intra_inter_cdf)
#if CONFIG_MOTION_VAR || CONFIG_WARPED_MOTION
  AVERAGE_TILE_CDFS(motion_mode_cdf)
#if CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
  AVERAGE_TILE_CDFS(obmc_cdf)
#endif
#endif
#endif
#if CONFIG_MRC_TX
  AVERAGE_TILE_CDFS(mrc_mask_inter_cdf)
#endif  // CONFIG_MRC_TX
#if CONFIG_LPF_SB
  AVERAGE_TILE_CDFS(lpf_reuse_cdf);
  AVERAGE_TILE_CDFS(lpf_delta_cdf);
  AVERAGE_TILE_CDFS(lpf_sign_cdf);
#endif  // CONFIG_LPF_SB
}

#if CONFIG_PVQ
// Averaging PVQ's expected values for symbol coding
static void av1_average_pvq_ex(int *cxt_ptr[], int *fc_cxt_ptr, int cxt_size,
                               const int num_tiles) {
  int i, j;
  for (i = 0; i < cxt_size; ++i) {
    int sum = 0;
    for (j = 0; j < num_tiles; ++j) sum += cxt_ptr[j][i];
    fc_cxt_ptr[i] = sum / num_tiles;
  }
}

#define AVERAGE_TILE_PVQ_EX(cname)                                        \
  for (i = 0; i < num_tiles; ++i) cxt_ptr[i] = (int *)&ec_ctxs[i]->cname; \
  fc_cxt_ptr = (int *)&fc->cname;                                         \
  cxt_size = (int)sizeof(fc->cname) / sizeof(int);                        \
  av1_average_pvq_ex(cxt_ptr, fc_cxt_ptr, cxt_size, num_tiles);

void av1_default_pvq_probs(AV1_COMMON *cm) {
  od_adapt_ctx *adapt = &cm->fc->pvq_context;

  // Init with flat probabilities.
  od_adapt_ctx_reset(adapt, 0);

  // TODO(yushin): Prepare offline cdf and context table for PVQ,
  // i.e. od_adapt_ctx, then load them from table,
  // for example od_adapt_ctx default_pvq_context.
  // Then do sth like this:
  // av1_copy(cm->fc->pvq_context, default_pvq_context);
}

void av1_average_tile_pvq_cdfs(FRAME_CONTEXT *fc, FRAME_CONTEXT *ec_ctxs[],
                               const int num_tiles) {
  int i, j, cdf_size, cxt_size;

  aom_cdf_prob *cdf_ptr[MAX_TILE_ROWS * MAX_TILE_COLS];
  aom_cdf_prob *fc_cdf_ptr;
  int *cxt_ptr[MAX_TILE_ROWS * MAX_TILE_COLS];
  int *fc_cxt_ptr;

  AVERAGE_TILE_PVQ_EX(pvq_context.ex_dc)
  AVERAGE_TILE_PVQ_EX(pvq_context.ex_g)

  for (j = 0; j < OD_NPLANES_MAX; j++) {
    AVERAGE_TILE_CDFS(pvq_context.model_dc[j].cdf)
  }

  AVERAGE_TILE_CDFS(pvq_context.skip_cdf)

  AVERAGE_TILE_PVQ_EX(pvq_context.pvq.pvq_codeword_ctx.pvq_adapt)
  AVERAGE_TILE_CDFS(pvq_context.pvq.pvq_codeword_ctx.pvq_k1_cdf)
  AVERAGE_TILE_CDFS(pvq_context.pvq.pvq_codeword_ctx.pvq_split_cdf)

  for (j = 0; j < 3; j++) {
    AVERAGE_TILE_CDFS(pvq_context.pvq.pvq_param_model[j].cdf)
  }

  AVERAGE_TILE_PVQ_EX(pvq_context.pvq.pvq_ext)
  AVERAGE_TILE_PVQ_EX(pvq_context.pvq.pvq_exg)
  AVERAGE_TILE_CDFS(pvq_context.pvq.pvq_gaintheta_cdf)
  AVERAGE_TILE_CDFS(pvq_context.pvq.pvq_skip_dir_cdf)
}
#endif  // CONFIG_PVQ
