/*
 * Copyright (c) 2016, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#include "aom_mem/aom_mem.h"

#include "av1/common/reconinter.h"
#include "av1/common/scan.h"
#include "av1/common/onyxc_int.h"
#include "av1/common/seg_common.h"
#if CONFIG_LV_MAP
#include "av1/common/txb_common.h"
#endif

#if CONFIG_LV_MAP
#include "av1/common/txb_common.h"
const aom_prob default_txb_skip[TX_SIZES][TXB_SKIP_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
  { 252, 71, 126, 184, 178, 218, 251, 49, 133, 221, 27, 92, 197 },
#endif
  { 252, 71, 126, 184, 178, 218, 251, 49, 133, 221, 27, 92, 197 },
  { 252, 71, 126, 184, 178, 218, 251, 49, 133, 221, 27, 92, 197 },
  { 252, 71, 126, 184, 178, 218, 251, 49, 133, 221, 27, 92, 197 },
  { 252, 71, 126, 184, 178, 218, 251, 49, 133, 221, 27, 92, 197 },
};
const aom_prob default_dc_sign[PLANE_TYPES][DC_SIGN_CONTEXTS] = {
  { 125, 102, 147 }, { 119, 101, 135 },
};

const aom_prob default_coeff_base
    [TX_SIZES][PLANE_TYPES][NUM_BASE_LEVELS][COEFF_BASE_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
      { // TX_2X2
        {
            { 73,  128, 131, 204, 165, 226, 169, 236, 18,  128, 51,
              153, 97,  179, 123, 201, 145, 226, 20,  128, 59,  153,
              107, 181, 129, 201, 142, 226, 3,   128, 19,  99,  46,
              135, 92,  166, 129, 190, 157, 217, 128, 128 },

            { 128, 128, 178, 218, 192, 236, 186, 243, 55,  128, 110,
              183, 151, 205, 168, 221, 180, 238, 65,  128, 116, 178,
              157, 206, 172, 222, 183, 238, 24,  128, 65,  127, 104,
              164, 154, 195, 187, 216, 205, 230, 128, 128 },
        },
        {
            { 73,  128, 131, 204, 165, 226, 169, 236, 18,  128, 51,
              153, 97,  179, 123, 201, 145, 226, 20,  128, 59,  153,
              107, 181, 129, 201, 142, 226, 3,   128, 19,  99,  46,
              135, 92,  166, 129, 190, 157, 217, 128, 128 },

            { 128, 128, 178, 218, 192, 236, 186, 243, 55,  128, 110,
              183, 151, 205, 168, 221, 180, 238, 65,  128, 116, 178,
              157, 206, 172, 222, 183, 238, 24,  128, 65,  127, 104,
              164, 154, 195, 187, 216, 205, 230, 128, 128 },
        } },
#endif
      { // TX_4X4
        {
            // PLANE_Y
            { 73,  128, 131, 204, 165, 226, 169, 236, 18,  128, 51,
              153, 97,  179, 123, 201, 145, 226, 20,  128, 59,  153,
              107, 181, 129, 201, 142, 226, 3,   128, 19,  99,  46,
              135, 92,  166, 129, 190, 157, 217, 128, 128 },

            { 128, 128, 178, 218, 192, 236, 186, 243, 55,  128, 110,
              183, 151, 205, 168, 221, 180, 238, 65,  128, 116, 178,
              157, 206, 172, 222, 183, 238, 24,  128, 65,  127, 104,
              164, 154, 195, 187, 216, 205, 230, 128, 128 },
        },
        {
            // PLANE_UV
            { 47,  128, 100, 176, 140, 207, 150, 223, 11,  128, 35,
              133, 79,  165, 115, 186, 129, 210, 8,   128, 30,  114,
              80,  159, 116, 187, 146, 214, 2,   128, 9,   59,  28,
              86,  71,  131, 117, 165, 149, 188, 128, 128 },

            { 83,  128, 152, 205, 168, 227, 192, 238, 42,  128, 92,
              169, 138, 193, 165, 209, 128, 206, 36,  128, 86,  159,
              141, 198, 181, 213, 102, 223, 18,  128, 50,  132, 90,
              144, 141, 169, 180, 191, 128, 217, 128, 128 },
        } },
      {
          // TX_8X8
          {
              // PLANE_Y
              { 82,  128, 143, 203, 177, 225, 186, 237, 7,   128, 37,
                109, 78,  151, 110, 182, 139, 213, 25,  128, 51,  115,
                86,  146, 111, 175, 125, 205, 3,   128, 12,  55,  32,
                78,  63,  111, 96,  148, 123, 185, 146, 206 },

              { 136, 128, 182, 220, 201, 236, 205, 243, 46,  128, 101,
                164, 147, 194, 170, 218, 177, 234, 62,  128, 104, 146,
                143, 183, 165, 207, 183, 228, 30,  128, 60,  95,  95,
                128, 135, 163, 166, 196, 175, 219, 192, 231 },
          },
          {
              // PLANE_UV
              { 47,  128, 112, 189, 164, 202, 163, 218, 8,   128, 32,
                110, 68,  151, 102, 179, 134, 195, 5,   128, 22,  76,
                54,  103, 80,  146, 101, 182, 1,   128, 5,   39,  17,
                53,  46,  93,  79,  127, 112, 161, 64,  195 },

              { 90,  128, 156, 210, 183, 225, 128, 236, 39,  128, 98,
                164, 146, 201, 209, 219, 171, 208, 32,  128, 68,  123,
                119, 169, 154, 184, 128, 213, 15,  128, 38,  111, 83,
                112, 120, 163, 180, 170, 154, 213, 128, 205 },
          },
      },

      {
          // TX_16X16
          {
              // PLANE_Y
              { 96,  128, 169, 218, 208, 233, 187, 244, 10,  128, 34,
                101, 82,  153, 113, 184, 137, 212, 6,   128, 34,  104,
                81,  145, 109, 176, 147, 202, 1,   128, 3,   43,  15,
                53,  43,  89,  79,  129, 108, 168, 110, 194 },

              { 156, 128, 206, 232, 218, 240, 128, 251, 39,  128, 108,
                161, 156, 202, 187, 216, 179, 234, 40,  128, 103, 152,
                144, 185, 159, 208, 205, 227, 14,  128, 39,  84,  76,
                110, 121, 151, 157, 187, 201, 206, 64,  216 },
          },
          {
              // PLANE_UV
              { 42, 128, 139, 211, 180, 230, 199, 238, 3,   128, 32,
                96, 69,  145, 102, 186, 117, 212, 4,   128, 25,  72,
                55, 111, 81,  159, 116, 198, 1,   128, 4,   22,  16,
                34, 35,  68,  63,  116, 89,  165, 102, 199 },

              { 135, 128, 193, 227, 182, 239, 128, 246, 42,  128, 115,
                156, 146, 203, 188, 216, 128, 229, 32,  128, 82,  127,
                120, 178, 165, 203, 213, 229, 11,  128, 32,  73,  79,
                111, 129, 158, 162, 187, 156, 209, 85,  222 },
          },
      },

      {
          // TX_32X32
          {
              // PLANE_Y
              { 97,  128, 163, 232, 191, 246, 219, 252, 3,   128, 41,
                108, 91,  147, 104, 183, 118, 225, 6,   128, 45,  91,
                83,  125, 92,  160, 99,  215, 1,   128, 11,  36,  28,
                46,  43,  59,  57,  86,  73,  145, 91,  210 },

              { 127, 128, 201, 239, 247, 248, 128, 254, 40,  128, 103,
                152, 158, 199, 186, 225, 181, 242, 38,  128, 92,  112,
                146, 189, 162, 217, 112, 239, 17,  128, 30,  47,  63,
                89,  113, 146, 147, 187, 168, 217, 150, 233 },
          },
          {
              // PLANE_UV
              { 65,  128, 155, 223, 166, 235, 154, 244, 15,  128, 57,
                154, 110, 199, 159, 224, 149, 239, 9,   128, 57,  140,
                97,  185, 148, 218, 176, 236, 1,   128, 3,   43,  19,
                42,  64,  98,  117, 167, 154, 199, 128, 158 },

              { 130, 128, 189, 231, 171, 247, 128, 246, 63,  128, 132,
                222, 186, 224, 199, 244, 128, 247, 55,  128, 113, 211,
                164, 230, 225, 243, 128, 239, 7,   128, 31,  102, 106,
                138, 147, 183, 171, 223, 171, 224, 128, 128 },
          },
      },
    };

const aom_prob default_nz_map[TX_SIZES][PLANE_TYPES][SIG_COEF_CONTEXTS] = {
#if CONFIG_EXT_TX
#if CONFIG_CHROMA_2X2
  { { 56,  137, 82,  136, 83,  187, 124, 65,
      215, 118, 155, 97,  160, 111, 71,  55,

      142, 156, 91,  226, 107, 231, 146, 65,
      105, 91,  232, 97,  185, 121, 90,  74,

      153, 195, 123, 154, 106, 196, 143, 67,
      232, 125, 121, 105, 159, 113, 88,  66 },
    { 50,  124, 89,  135, 116, 189, 150, 81,
      202, 126, 130, 107, 149, 110, 85,  67,

      139, 174, 112, 200, 94,  206, 146, 71,
      163, 164, 212, 99,  177, 143, 125, 85,

      151, 181, 126, 168, 135, 186, 143, 94,
      207, 129, 142, 135, 145, 112, 98,  81 } },
#endif
  { { 56,  137, 82,  136, 83,  187, 124, 65,
      215, 118, 155, 97,  160, 111, 71,  55,

      142, 156, 91,  226, 107, 231, 146, 65,
      105, 91,  232, 97,  185, 121, 90,  74,

      153, 195, 123, 154, 106, 196, 143, 67,
      232, 125, 121, 105, 159, 113, 88,  66 },
    { 50,  124, 89,  135, 116, 189, 150, 81,
      202, 126, 130, 107, 149, 110, 85,  67,

      139, 174, 112, 200, 94,  206, 146, 71,
      163, 164, 212, 99,  177, 143, 125, 85,

      151, 181, 126, 168, 135, 186, 143, 94,
      207, 129, 142, 135, 145, 112, 98,  81 } },
  { { 57,  156, 91,  162, 99,  212, 149, 81,
      223, 128, 182, 121, 216, 163, 119, 94,

      139, 183, 100, 206, 98,  242, 163, 79,
      200, 127, 234, 112, 230, 169, 115, 90,

      156, 190, 130, 172, 117, 209, 163, 80,
      217, 145, 182, 135, 204, 163, 120, 88 },
    { 48,  133, 102, 143, 119, 190, 170, 109,
      197, 127, 176, 137, 214, 168, 130, 119,

      139, 185, 129, 210, 84,  237, 177, 75,
      182, 165, 216, 121, 206, 177, 147, 102,

      159, 192, 153, 182, 139, 203, 160, 125,
      193, 161, 176, 142, 173, 145, 131, 114 } },
  { { 33,  148, 81,  149, 84,  219, 152, 76,
      229, 127, 205, 120, 234, 170, 123, 88,

      134, 197, 101, 213, 91,  244, 169, 85,
      220, 141, 234, 123, 242, 183, 130, 94,

      141, 184, 121, 173, 98,  213, 156, 85,
      204, 156, 197, 119, 212, 174, 127, 92 },
    { 14,  75,  45,  98,  83,  197, 150, 90,
      235, 124, 242, 155, 246, 187, 143, 103,

      78,  185, 111, 255, 116, 255, 224, 171,
      185, 157, 255, 85,  219, 122, 128, 128,

      117, 187, 102, 181, 132, 233, 197, 93,
      207, 135, 191, 107, 222, 175, 130, 47 } },
  {
      { 14,  79,  44,  86,  59,  178, 124, 63,
        244, 106, 233, 117, 252, 185, 132, 92,

        85,  225, 47,  236, 103, 255, 190, 116,
        235, 114, 247, 123, 250, 174, 122, 110,

        109, 197, 78,  177, 76,  242, 148, 68,
        236, 123, 231, 103, 247, 171, 122, 91 },
      { 11,  40,  27,  92,  78,  183, 171, 70,
        216, 74,  251, 146, 252, 213, 171, 148,

        85,  225, 47,  236, 103, 255, 190, 116,
        235, 114, 247, 123, 250, 174, 122, 110,

        109, 197, 78,  177, 76,  242, 148, 68,
        236, 123, 231, 103, 247, 171, 122, 91 },
  },
#else  // CONFIG_EXT_TX
#if CONFIG_CHROMA_2X2
  {
      {
          34, 103, 61, 106, 62, 160, 112, 54, 173, 121, 157, 92, 157, 129, 94,
          65,
      },

      {
          52, 124, 84, 136, 107, 197, 161, 82, 183, 151, 153, 140, 152, 134,
          109, 81,
      },
  },
#endif
  {
      {
          34, 103, 61, 106, 62, 160, 112, 54, 173, 121, 157, 92, 157, 129, 94,
          65,
      },

      {
          52, 124, 84, 136, 107, 197, 161, 82, 183, 151, 153, 140, 152, 134,
          109, 81,
      },
  },
  {
      {
          34, 127, 74, 124, 74, 204, 153, 76, 226, 162, 207, 126, 227, 192, 149,
          108,
      },

      {
          43, 136, 115, 158, 130, 212, 187, 112, 231, 180, 202, 164, 236, 204,
          168, 139,
      },
  },
  {
      {
          25, 117, 70, 120, 77, 215, 171, 102, 234, 156, 235, 155, 247, 220,
          176, 127,
      },

      {
          24, 88, 49, 100, 62, 202, 148, 62, 237, 178, 233, 168, 244, 198, 162,
          127,
      },
  },
  {
      {
          11, 54, 17, 69, 26, 128, 125, 56, 232, 130, 237, 121, 250, 168, 134,
          114,
      },

      {
          21, 52, 32, 95, 64, 171, 152, 70, 247, 159, 252, 177, 252, 221, 192,
          143,
      },
  },
#endif  // CONFIG_EXT_TX
};

#if CONFIG_CTX1D
const aom_prob default_eob_flag[TX_SIZES][PLANE_TYPES][EOB_COEF_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
  { { 220, 225, 220, 216, 233, 225, 189, 178, 222, 199, 164, 112, 207,
      171, 115, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      147, 125, 104, 36,  117, 107, 26,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      156, 124, 128, 128, 146, 68,  128, 128, 131, 17,  128, 128, 64,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },

    { 146, 150, 142, 144, 178, 167, 131, 116, 150, 123, 107, 63,  119,
      89,  74,  128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      117, 127, 105, 69,  53,  56,  30,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      128, 86,  128, 128, 140, 72,  128, 128, 120, 44,  128, 128, 80,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } },
  { { 237, 242, 242, 219, 192, 246, 246, 243, 233, 184, 155, 234, 217,
      188, 152, 195, 167, 114, 89,  128, 128, 128, 128, 128, 128,

      180, 173, 154, 133, 112, 147, 145, 142, 102, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      198, 173, 130, 200, 128, 208, 182, 160, 106, 171, 128, 144, 128,
      128, 128, 124, 128, 128, 128, 128, 128, 128, 128, 128, 128 },

    { 140, 170, 162, 111, 94,  182, 195, 165, 153, 110, 81,  178, 169,
      158, 83,  133, 85,  85,  38,  128, 128, 128, 128, 128, 128,

      112, 127, 107, 87,  31,  57,  49,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      160, 143, 99,  126, 128, 164, 133, 126, 59,  71,  128, 138, 128,
      128, 128, 99,  128, 128, 128, 128, 128, 128, 128, 128, 128 } },
#endif
  { { 220, 225, 220, 216, 233, 225, 189, 178, 222, 199, 164, 112, 207,
      171, 115, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      147, 125, 104, 36,  117, 107, 26,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      156, 124, 128, 128, 146, 68,  128, 128, 131, 17,  128, 128, 64,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },

    { 146, 150, 142, 144, 178, 167, 131, 116, 150, 123, 107, 63,  119,
      89,  74,  128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      117, 127, 105, 69,  53,  56,  30,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      128, 86,  128, 128, 140, 72,  128, 128, 120, 44,  128, 128, 80,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } },
  { { 237, 242, 242, 219, 192, 246, 246, 243, 233, 184, 155, 234, 217,
      188, 152, 195, 167, 114, 89,  128, 128, 128, 128, 128, 128,

      180, 173, 154, 133, 112, 147, 145, 142, 102, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      198, 173, 130, 200, 128, 208, 182, 160, 106, 171, 128, 144, 128,
      128, 128, 124, 128, 128, 128, 128, 128, 128, 128, 128, 128 },

    { 140, 170, 162, 111, 94,  182, 195, 165, 153, 110, 81,  178, 169,
      158, 83,  133, 85,  85,  38,  128, 128, 128, 128, 128, 128,

      112, 127, 107, 87,  31,  57,  49,  128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      160, 143, 99,  126, 128, 164, 133, 126, 59,  71,  128, 138, 128,
      128, 128, 99,  128, 128, 128, 128, 128, 128, 128, 128, 128 } },
  { { 229, 241, 243, 245, 247, 247, 251, 248, 235, 210, 247, 235, 208,
      166, 245, 247, 244, 182, 236, 229, 180, 136, 128, 128, 128,

      191, 197, 96,  70,  199, 128, 128, 191, 174, 117, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      211, 183, 215, 188, 138, 209, 136, 128, 170, 128, 191, 128, 161,
      128, 182, 128, 128, 128, 164, 128, 128, 128, 128, 128, 128 },

    { 106, 153, 182, 191, 186, 202, 211, 203, 166, 147, 205, 205, 195,
      128, 206, 212, 182, 109, 192, 154, 139, 79,  128, 128, 128,

      112, 133, 128, 255, 128, 128, 128, 130, 154, 98,  128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      144, 185, 169, 199, 85,  183, 128, 128, 64,  128, 146, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } },
  { { 169, 203, 224, 222, 220, 228, 229, 223, 234, 247, 242, 230, 222,
      238, 246, 234, 196, 245, 249, 245, 192, 240, 235, 199, 161,

      176, 148, 158, 77,  178, 128, 128, 158, 128, 128, 196, 208, 155,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      232, 187, 191, 221, 116, 217, 154, 128, 203, 128, 128, 192, 128,
      201, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },

    { 133, 182, 215, 204, 176, 220, 182, 168, 187, 197, 181, 145, 75,
      164, 136, 51,  57,  156, 128, 128, 128, 85,  128, 128, 128,

      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,

      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
      128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } },
};
#else  // CONFIG_CTX1D
const aom_prob default_eob_flag[TX_SIZES][PLANE_TYPES][EOB_COEF_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
  {
      { 229, 236, 231, 222, 239, 236, 214, 201, 236, 226, 195, 134, 228,
        210, 150, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
      { 182, 186, 172, 176, 207, 213, 152, 122, 187, 171, 131, 65, 170,
        134, 101, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
  },
#endif
  {
      { 229, 236, 231, 222, 239, 236, 214, 201, 236, 226, 195, 134, 228,
        210, 150, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
      { 182, 186, 172, 176, 207, 213, 152, 122, 187, 171, 131, 65, 170,
        134, 101, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
  },
  {
      { 225, 234, 244, 236, 205, 242, 246, 247, 246, 234, 191, 242, 237,
        215, 142, 224, 206, 142, 73,  128, 128, 128, 128, 128, 128 },
      { 154, 171, 187, 175, 62,  199, 202, 206, 215, 200, 111, 197, 199,
        174, 100, 135, 105, 104, 45,  128, 128, 128, 128, 128, 128 },
  },
  {
      { 180, 213, 216, 229, 233, 232, 240, 235, 220, 178, 239, 238, 225,
        187, 229, 214, 226, 200, 183, 141, 158, 179, 128, 128, 128 },
      { 190, 225, 234, 248, 249, 248, 253, 251, 232, 110, 254, 252, 236,
        57,  253, 248, 232, 85,  244, 189, 112, 64,  128, 128, 128 },
  },
  {
      { 248, 224, 246, 244, 239, 245, 251, 246, 251, 255, 255, 255, 249,
        255, 255, 255, 229, 255, 255, 255, 228, 255, 255, 247, 137 },
      { 204, 207, 233, 215, 193, 228, 239, 221, 227, 250, 236, 207, 135,
        236, 186, 182, 57,  209, 140, 128, 85,  184, 110, 128, 128 },
  },
};
#endif  // CONFIG_CTX1D

const aom_prob default_coeff_lps[TX_SIZES][PLANE_TYPES][LEVEL_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
  { { 96,  128, 86,  122, 128, 84,  125, 128, 88,  99,  126, 128,
      135, 159, 99,  130, 134, 100, 128, 144, 70,  97,  128, 139,
      157, 168, 127, 148, 162, 121, 149, 157, 118, 127, 143, 157,
      178, 186, 168, 171, 183, 165, 169, 180, 180, 169, 166, 177 },
    { 81,  128, 72,  95,  128, 64,  98,  128, 42,  66,  101, 128,
      129, 163, 97,  122, 130, 91,  119, 141, 70,  94,  118, 166,
      157, 168, 117, 143, 151, 111, 144, 154, 76,  113, 128, 158,
      177, 185, 165, 167, 179, 155, 166, 179, 110, 137, 115, 165 } },
#endif
  { { 96,  128, 86,  122, 128, 84,  125, 128, 88,  99,  126, 128,
      135, 159, 99,  130, 134, 100, 128, 144, 70,  97,  128, 139,
      157, 168, 127, 148, 162, 121, 149, 157, 118, 127, 143, 157,
      178, 186, 168, 171, 183, 165, 169, 180, 180, 169, 166, 177 },
    { 81,  128, 72,  95,  128, 64,  98,  128, 42,  66,  101, 128,
      129, 163, 97,  122, 130, 91,  119, 141, 70,  94,  118, 166,
      157, 168, 117, 143, 151, 111, 144, 154, 76,  113, 128, 158,
      177, 185, 165, 167, 179, 155, 166, 179, 110, 137, 115, 165 } },
  { { 102, 128, 79,  125, 128, 74,  121, 128, 61,  98,  128, 128,
      141, 164, 96,  132, 150, 90,  128, 153, 62,  100, 128, 153,
      162, 172, 120, 146, 162, 113, 142, 154, 96,  113, 138, 155,
      181, 188, 151, 170, 179, 147, 167, 181, 158, 157, 163, 176 },
    { 103, 128, 80,  116, 128, 66,  94,  128, 35,  65,  109, 128,
      134, 163, 104, 137, 154, 92,  128, 104, 58,  94,  129, 132,
      156, 173, 137, 149, 165, 104, 143, 143, 112, 101, 133, 159,
      176, 186, 134, 172, 175, 155, 169, 177, 255, 107, 137, 168 } },
  { { 125, 128, 85,  157, 128, 82,  155, 128, 42,  83,  116, 128,
      155, 174, 101, 144, 155, 93,  140, 155, 57,  92,  124, 149,
      173, 178, 114, 148, 161, 111, 145, 161, 77,  101, 131, 153,
      190, 191, 140, 169, 183, 140, 169, 179, 108, 122, 150, 171 },
    { 136, 128, 108, 163, 128, 96,  140, 128, 48,  90,  85,  128,
      144, 164, 113, 158, 179, 107, 159, 128, 43,  75,  133, 160,
      157, 184, 144, 160, 189, 154, 152, 184, 128, 124, 137, 140,
      188, 196, 148, 170, 178, 128, 177, 159, 128, 179, 135, 135 } },
  { { 133, 128, 110, 153, 128, 101, 157, 128, 49,  91,  134, 128,
      151, 168, 129, 158, 162, 112, 154, 168, 63,  99,  130, 158,
      171, 178, 128, 160, 173, 111, 155, 171, 86,  108, 143, 159,
      194, 196, 162, 177, 185, 123, 172, 181, 101, 132, 156, 178 },
    { 133, 128, 129, 144, 128, 116, 135, 128, 43,  101, 100, 128,
      140, 163, 158, 173, 205, 128, 165, 171, 128, 128, 210, 163,
      172, 184, 192, 176, 201, 183, 177, 190, 128, 192, 199, 144,
      192, 192, 1,   196, 192, 255, 171, 178, 255, 128, 171, 179 } }
};
#if BR_NODE
const aom_prob
    default_coeff_br[TX_SIZES][PLANE_TYPES][BASE_RANGE_SETS][LEVEL_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
      { { { 62,  128, 54,  116, 128, 51,  97,  128, 59,  68,  107, 128,
            119, 158, 68,  115, 131, 65,  112, 138, 34,  71,  118, 137,
            171, 184, 110, 152, 178, 105, 146, 172, 89,  111, 145, 173,
            214, 226, 201, 198, 214, 196, 193, 210, 239, 196, 186, 202 },
          { 41,  128, 58,  52,  128, 51,  61,  128, 92,  54,  48,  128,
            67,  113, 36,  55,  75,  30,  56,  72,  12,  25,  50,  79,
            94,  131, 37,  75,  108, 42,  78,  103, 5,   31,  67,  103,
            172, 192, 131, 135, 167, 129, 136, 165, 149, 144, 120, 149 },
          { 35, 128, 74, 50, 128, 63, 59, 128, 87,  74,  38, 128,
            32, 53,  23, 34, 50,  18, 30, 41,  15,  13,  18, 18,
            52, 74,  18, 29, 36,  18, 31, 47,  51,  9,   15, 27,
            96, 134, 85, 70, 93,  96, 79, 100, 108, 100, 55, 65 } },
        { { 52,  128, 35,  79,  128, 29,  66,  128, 12,  30, 57,  128,
            113, 156, 64,  107, 172, 54,  103, 145, 23,  57, 96,  110,
            165, 184, 95,  138, 166, 95,  141, 184, 55,  80, 133, 165,
            212, 222, 134, 175, 206, 158, 177, 197, 102, 61, 154, 190 },
          { 36,  128, 18, 26,  128, 15, 29,  128, 4, 6,  30, 128,
            63,  113, 25, 44,  66,  22, 40,  67,  9, 14, 34, 55,
            90,  125, 26, 66,  82,  29, 73,  88,  1, 26, 34, 67,
            158, 179, 70, 121, 134, 69, 111, 129, 1, 85, 54, 105 },
          { 24, 128, 8,  31, 128, 15, 16, 128, 1,   1, 1,  128,
            32, 39,  16, 18, 43,  5,  17, 13,  1,   1, 22, 1,
            37, 65,  26, 20, 28,  16, 15, 24,  128, 1, 1,  1,
            83, 107, 57, 56, 74,  34, 29, 73,  128, 1, 37, 47 } } },
#endif
      { { { 62,  128, 54,  116, 128, 51,  97,  128, 59,  68,  107, 128,
            119, 158, 68,  115, 131, 65,  112, 138, 34,  71,  118, 137,
            171, 184, 110, 152, 178, 105, 146, 172, 89,  111, 145, 173,
            214, 226, 201, 198, 214, 196, 193, 210, 239, 196, 186, 202 },
          { 41,  128, 58,  52,  128, 51,  61,  128, 92,  54,  48,  128,
            67,  113, 36,  55,  75,  30,  56,  72,  12,  25,  50,  79,
            94,  131, 37,  75,  108, 42,  78,  103, 5,   31,  67,  103,
            172, 192, 131, 135, 167, 129, 136, 165, 149, 144, 120, 149 },
          { 35, 128, 74, 50, 128, 63, 59, 128, 87,  74,  38, 128,
            32, 53,  23, 34, 50,  18, 30, 41,  15,  13,  18, 18,
            52, 74,  18, 29, 36,  18, 31, 47,  51,  9,   15, 27,
            96, 134, 85, 70, 93,  96, 79, 100, 108, 100, 55, 65 } },
        { { 52,  128, 35,  79,  128, 29,  66,  128, 12,  30, 57,  128,
            113, 156, 64,  107, 172, 54,  103, 145, 23,  57, 96,  110,
            165, 184, 95,  138, 166, 95,  141, 184, 55,  80, 133, 165,
            212, 222, 134, 175, 206, 158, 177, 197, 102, 61, 154, 190 },
          { 36,  128, 18, 26,  128, 15, 29,  128, 4, 6,  30, 128,
            63,  113, 25, 44,  66,  22, 40,  67,  9, 14, 34, 55,
            90,  125, 26, 66,  82,  29, 73,  88,  1, 26, 34, 67,
            158, 179, 70, 121, 134, 69, 111, 129, 1, 85, 54, 105 },
          { 24, 128, 8,  31, 128, 15, 16, 128, 1,   1, 1,  128,
            32, 39,  16, 18, 43,  5,  17, 13,  1,   1, 22, 1,
            37, 65,  26, 20, 28,  16, 15, 24,  128, 1, 1,  1,
            83, 107, 57, 56, 74,  34, 29, 73,  128, 1, 37, 47 } } },
      { { { 72,  128, 45,  113, 128, 38,  100, 128, 26,  63,  112, 128,
            134, 177, 65,  121, 148, 57,  111, 143, 27,  68,  116, 152,
            181, 198, 98,  148, 173, 84,  136, 168, 53,  89,  134, 170,
            218, 230, 173, 194, 216, 160, 188, 213, 199, 177, 183, 204 },
          { 54,  128, 34,  55,  128, 32,  53,  128, 66,  45,  54,  128,
            81,  128, 33,  59,  102, 26,  55,  80,  7,   23,  49,  91,
            116, 145, 36,  79,  107, 35,  73,  102, 12,  28,  57,  95,
            170, 201, 102, 133, 173, 105, 127, 173, 166, 132, 114, 149 },
          { 40,  128, 25, 30, 128, 21, 31, 128, 24, 17, 24, 128,
            51,  67,  19, 28, 40,  17, 25, 42,  15, 13, 19, 19,
            61,  77,  19, 30, 48,  13, 33, 50,  11, 15, 21, 30,
            103, 147, 37, 69, 111, 37, 66, 105, 18, 18, 36, 76 } },
        { { 74,  128, 42,  99,  128, 32,  57,  128, 9,  28, 76,  128,
            115, 187, 70,  118, 120, 52,  109, 128, 19, 60, 93,  100,
            178, 197, 119, 147, 179, 92,  137, 178, 37, 87, 110, 158,
            216, 227, 169, 186, 201, 128, 178, 204, 1,  96, 155, 217 },
          { 59,  128, 26, 34,  128, 11, 20,  128, 7,   8, 24, 128,
            73,  125, 38, 74,  96,  23, 61,  79,  15,  9, 23, 110,
            96,  151, 49, 79,  164, 22, 70,  65,  1,   1, 9,  69,
            156, 196, 73, 105, 181, 17, 126, 155, 128, 1, 90, 111 },
          { 42, 128, 10, 11, 128, 13, 1,  128, 1,   1,   1, 128,
            55, 63,  13, 17, 85,  1,  16, 64,  1,   1,   1, 1,
            62, 58,  32, 21, 53,  1,  37, 91,  128, 128, 1, 1,
            81, 133, 51, 48, 79,  1,  25, 81,  128, 128, 1, 54 } } },
      { { { 103, 128, 52,  163, 128, 46,  155, 128, 12, 45,  97,  128,
            162, 196, 69,  140, 170, 60,  130, 158, 21, 58,  109, 150,
            205, 214, 93,  149, 178, 79,  143, 179, 38, 71,  120, 159,
            231, 240, 150, 192, 218, 140, 188, 220, 84, 112, 159, 196 },
          { 93,  128, 42, 143, 128, 41, 132, 128, 6,  15, 40, 128,
            113, 172, 39, 99,  113, 33, 91,  94,  5,  15, 42, 83,
            148, 172, 37, 91,  130, 28, 81,  121, 9,  20, 47, 87,
            201, 223, 75, 139, 183, 77, 132, 176, 23, 41, 82, 147 },
          { 92,  128, 45, 123, 128, 28, 88, 128, 1,  8,  20, 128,
            85,  94,  39, 95,  83,  33, 81, 61,  4,  5,  17, 25,
            84,  109, 17, 59,  76,  11, 46, 62,  1,  4,  13, 35,
            139, 184, 25, 86,  129, 25, 71, 123, 26, 13, 31, 84 } },
        { { 123, 128, 82,  169, 128, 62,  139, 128, 1,   28,  77,  128,
            139, 167, 92,  170, 146, 76,  149, 255, 19,  68,  160, 73,
            190, 209, 171, 165, 218, 57,  152, 209, 128, 61,  122, 164,
            237, 240, 146, 210, 227, 128, 224, 220, 128, 128, 196, 199 },
          { 130, 128, 52,  141, 128, 32,  101, 128, 128, 1,  85,  128,
            94,  155, 71,  121, 255, 30,  116, 85,  1,   8,  58,  255,
            105, 169, 110, 101, 132, 1,   77,  142, 128, 1,  54,  96,
            166, 214, 224, 154, 198, 255, 153, 230, 128, 85, 100, 146 },
          { 103, 128, 26, 83, 128, 20,  47,  128, 128, 128, 1,  128,
            91,  90,  19, 76, 128, 1,   42,  1,   128, 255, 64, 128,
            74,  77,  1,  72, 68,  128, 13,  77,  128, 128, 64, 1,
            71,  147, 37, 99, 171, 1,   104, 151, 128, 1,   1,  96 } } },
      { { { 113, 128, 79,  165, 128, 69,  149, 128, 14, 55,  116, 128,
            163, 202, 104, 169, 205, 82,  159, 180, 22, 64,  121, 165,
            207, 216, 113, 177, 215, 95,  166, 195, 35, 77,  132, 179,
            241, 244, 173, 207, 233, 128, 202, 227, 92, 121, 169, 209 },
          { 114, 128, 67, 136, 128, 54, 132, 128, 6,  26, 62,  128,
            85,  129, 85, 146, 173, 64, 129, 140, 7,  19, 65,  92,
            139, 169, 42, 147, 186, 40, 129, 170, 18, 18, 65,  117,
            213, 230, 74, 172, 213, 69, 165, 196, 1,  40, 103, 170 },
          { 101, 128, 61, 134, 128, 52, 97,  128, 1,   14, 26, 128,
            79,  72,  71, 135, 152, 56, 114, 117, 1,   10, 24, 58,
            64,  66,  60, 133, 148, 16, 126, 123, 1,   32, 26, 56,
            143, 197, 51, 141, 176, 59, 132, 162, 128, 17, 47, 106 } },
        { { 115, 128, 112, 135, 128, 89,  130, 128, 15,  49,  89,  128,
            143, 238, 154, 203, 255, 138, 172, 255, 1,   98,  196, 255,
            185, 203, 255, 211, 255, 192, 217, 235, 128, 128, 171, 255,
            233, 233, 255, 247, 255, 1,   239, 245, 1,   128, 255, 255 },
          { 75,  128, 76,  118, 128, 35,  74,  128, 1,   13,  23,  128,
            63,  138, 114, 164, 140, 91,  128, 128, 128, 1,   138, 64,
            96,  128, 255, 175, 236, 85,  166, 209, 128, 1,   128, 146,
            196, 217, 1,   204, 206, 128, 212, 221, 128, 128, 128, 219 },
          { 49,  128, 36,  62,  128, 37,  56, 128, 128, 1,   1,   128,
            45,  37,  68,  102, 128, 90,  56, 1,   128, 128, 37,  1,
            26,  27,  128, 126, 128, 255, 63, 142, 128, 128, 1,   1,
            125, 159, 128, 173, 212, 128, 85, 189, 128, 128, 255, 171 } } }
    };
#endif  // BR_NODE
#if CONFIG_CTX1D
static const aom_prob default_eob_mode[TX_SIZES][PLANE_TYPES][TX_CLASSES] = {
#if CONFIG_CHROMA_2X2
  { { 128, 176, 157 }, { 128, 222, 198 } },
#endif
  { { 128, 176, 157 }, { 128, 222, 198 } },
  { { 128, 35, 56 }, { 128, 203, 225 } },
  { { 128, 55, 136 }, { 128, 230, 253 } },
  { { 128, 101, 188 }, { 128, 128, 128 } }
};
static const aom_prob default_empty_line[TX_SIZES][PLANE_TYPES][TX_CLASSES]
                                        [EMPTY_LINE_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
                                          { { { 128, 128, 128, 128, 128 },
                                              { 142, 153, 211, 205, 128 },
                                              { 162, 142, 203, 197, 128 } },
                                            { { 128, 128, 128, 128, 128 },
                                              { 133, 116, 178, 123, 128 },
                                              { 139, 109, 159, 115, 128 } } },
#endif
                                          { { { 128, 128, 128, 128, 128 },
                                              { 142, 153, 211, 205, 128 },
                                              { 162, 142, 203, 197, 128 } },
                                            { { 128, 128, 128, 128, 128 },
                                              { 133, 116, 178, 123, 128 },
                                              { 139, 109, 159, 115, 128 } } },
                                          { { { 128, 128, 128, 128, 128 },
                                              { 185, 130, 183, 204, 227 },
                                              { 171, 81, 177, 200, 221 } },
                                            { { 128, 128, 128, 128, 128 },
                                              { 180, 127, 175, 189, 213 },
                                              { 120, 74, 129, 134, 156 } } },
                                          { { { 128, 128, 128, 128, 128 },
                                              { 202, 82, 183, 214, 248 },
                                              { 144, 41, 163, 185, 203 } },
                                            { { 128, 128, 128, 128, 128 },
                                              { 151, 93, 171, 224, 160 },
                                              { 128, 51, 171, 128, 1 } } },
                                          { { { 128, 128, 128, 128, 128 },
                                              { 154, 48, 174, 210, 233 },
                                              { 123, 16, 148, 189, 197 } },
                                            { { 128, 128, 128, 128, 128 },
                                              { 128, 128, 128, 128, 128 },
                                              { 128, 128, 128, 128, 128 } } }
                                        };
static const aom_prob
    default_hv_eob[TX_SIZES][PLANE_TYPES][TX_CLASSES][HV_EOB_CONTEXTS] = {
#if CONFIG_CHROMA_2X2
      { { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 151, 173, 114, 128, 128, 128, 128, 128, 128, 162, 198, 128,
            128, 128, 128, 128, 182, 198, 109, 128, 128, 128, 128, 128 },
          { 152, 173, 119, 128, 128, 128, 128, 128, 128, 164, 193, 128,
            128, 128, 128, 128, 198, 209, 121, 128, 128, 128, 128, 128 } },
        { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 123, 143, 70,  128, 128, 128, 128, 128, 128, 127, 154, 128,
            128, 128, 128, 128, 176, 148, 36,  128, 128, 128, 128, 128 },
          { 132, 152, 73,  128, 128, 128, 128, 128, 128, 127, 159, 128,
            128, 128, 128, 128, 186, 181, 48,  128, 128, 128, 128, 128 } } },
#endif
      { { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 151, 173, 114, 128, 128, 128, 128, 128, 128, 162, 198, 128,
            128, 128, 128, 128, 182, 198, 109, 128, 128, 128, 128, 128 },
          { 152, 173, 119, 128, 128, 128, 128, 128, 128, 164, 193, 128,
            128, 128, 128, 128, 198, 209, 121, 128, 128, 128, 128, 128 } },
        { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 123, 143, 70,  128, 128, 128, 128, 128, 128, 127, 154, 128,
            128, 128, 128, 128, 176, 148, 36,  128, 128, 128, 128, 128 },
          { 132, 152, 73,  128, 128, 128, 128, 128, 128, 127, 159, 128,
            128, 128, 128, 128, 186, 181, 48,  128, 128, 128, 128, 128 } } },
      { { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 109, 105, 78,  44,  128, 128, 128, 128, 128, 146, 185, 221,
            128, 128, 128, 128, 199, 188, 134, 69,  128, 128, 128, 128 },
          { 124, 127, 115, 82,  128, 128, 128, 128, 128, 162, 198, 224,
            128, 128, 128, 128, 206, 214, 177, 135, 128, 128, 128, 128 } },
        { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 95,  102, 65,  14,  128, 128, 128, 128, 128, 132, 164, 199,
            128, 128, 128, 128, 162, 163, 66,  27,  128, 128, 128, 128 },
          { 83,  141, 97,  38,  128, 128, 128, 128, 128, 154, 132, 184,
            128, 128, 128, 128, 194, 218, 112, 63,  128, 128, 128, 128 } } },
      { { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 117, 107, 86,  61,  51,  104, 128, 128, 128, 160, 198, 238,
            252, 251, 128, 128, 221, 223, 209, 186, 99,  81,  128, 128 },
          { 118, 122, 121, 100, 91,  97,  128, 128, 128, 168, 190, 214,
            233, 235, 128, 128, 197, 216, 177, 165, 147, 126, 128, 128 } },
        { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 109, 102, 63,  51,  255, 85,  128, 128, 128, 163, 131, 175,
            128, 128, 128, 128, 183, 102, 40,  1,   128, 128, 128, 128 },
          { 255, 255, 1,   1,   128, 1, 128, 128, 128, 1,   128, 128,
            128, 128, 128, 128, 255, 1, 128, 128, 128, 128, 128, 128 } } },
      { { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 114, 108, 83,  61,  53,  28,  77,  177, 128, 161, 187, 218,
            240, 237, 228, 234, 200, 207, 167, 136, 98,  78,  183, 128 },
          { 117, 138, 116, 77,  75,  85,  26,  1,   128, 197, 162, 200,
            184, 212, 225, 236, 189, 225, 168, 124, 144, 171, 128, 128 } },
        { { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 },
          { 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
            128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128 } } }
    };
#endif  // CONFIG_CTX1D
#endif  // CONFIG_LV_MAP

#if CONFIG_EXT_PARTITION_TYPES
static const aom_prob
    default_partition_probs[PARTITION_CONTEXTS][EXT_PARTITION_TYPES - 1] = {
      // 8x8 -> 4x4
      { 199, 122, 141, 128, 128, 128, 255, 128, 255 },  // a/l both not split
      { 147, 63, 159, 128, 128, 128, 255, 128, 255 },   // a split, l not split
      { 148, 133, 118, 128, 128, 128, 255, 128, 255 },  // l split, a not split
      { 121, 104, 114, 128, 128, 128, 255, 128, 255 },  // a/l both split
      // 16x16 -> 8x8
      { 174, 73, 87, 128, 128, 128, 255, 128, 255 },  // a/l both not split
      { 92, 41, 83, 128, 128, 128, 255, 128, 255 },   // a split, l not split
      { 82, 99, 50, 128, 128, 128, 255, 128, 255 },   // l split, a not split
      { 53, 39, 39, 128, 128, 128, 255, 128, 255 },   // a/l both split
      // 32x32 -> 16x16
      { 177, 58, 59, 128, 128, 85, 128, 85, 128 },  // a/l both not split
      { 68, 26, 63, 128, 128, 85, 128, 85, 128 },   // a split, l not split
      { 52, 79, 25, 128, 128, 85, 128, 85, 128 },   // l split, a not split
      { 17, 14, 12, 128, 128, 85, 128, 85, 128 },   // a/l both split
      // 64x64 -> 32x32
      { 222, 34, 30, 128, 128, 85, 128, 85, 128 },  // a/l both not split
      { 72, 16, 44, 128, 128, 85, 128, 85, 128 },   // a split, l not split
      { 58, 32, 12, 128, 128, 85, 128, 85, 128 },   // l split, a not split
      { 10, 7, 6, 128, 128, 85, 128, 85, 128 },     // a/l both split
#if CONFIG_EXT_PARTITION
      // 128x128 -> 64x64
      { 222, 34, 30, 128, 128, 128, 255, 128, 255 },  // a/l both not split
      { 72, 16, 44, 128, 128, 128, 255, 128, 255 },   // a split, l not split
      { 58, 32, 12, 128, 128, 128, 255, 128, 255 },   // l split, a not split
      { 10, 7, 6, 128, 128, 128, 255, 128, 255 },     // a/l both split
#endif                                                // CONFIG_EXT_PARTITION
#if CONFIG_UNPOISON_PARTITION_CTX
      { 0, 0, 141, 0, 0, 0, 0, 0, 0 },  // 8x8 -> 4x4
      { 0, 0, 87, 0, 0, 0, 0, 0, 0 },   // 16x16 -> 8x8
      { 0, 0, 59, 0, 0, 0, 0, 0, 0 },   // 32x32 -> 16x16
      { 0, 0, 30, 0, 0, 0, 0, 0, 0 },   // 64x64 -> 32x32
#if CONFIG_EXT_PARTITION
      { 0, 0, 30, 0, 0, 0, 0, 0, 0 },   // 128x128 -> 64x64
#endif                                  // CONFIG_EXT_PARTITION
      { 0, 122, 0, 0, 0, 0, 0, 0, 0 },  // 8x8 -> 4x4
      { 0, 73, 0, 0, 0, 0, 0, 0, 0 },   // 16x16 -> 8x8
      { 0, 58, 0, 0, 0, 0, 0, 0, 0 },   // 32x32 -> 16x16
      { 0, 34, 0, 0, 0, 0, 0, 0, 0 },   // 64x64 -> 32x32
#if CONFIG_EXT_PARTITION
      { 0, 34, 0, 0, 0, 0, 0, 0, 0 },  // 128x128 -> 64x64
#endif                                 // CONFIG_EXT_PARTITION
#endif                                 // CONFIG_UNPOISON_PARTITION_CTX
    };
#else
static const aom_prob
    default_partition_probs[PARTITION_CONTEXTS][PARTITION_TYPES - 1] = {
      // 8x8 -> 4x4
      { 199, 122, 141 },  // a/l both not split
      { 147, 63, 159 },   // a split, l not split
      { 148, 133, 118 },  // l split, a not split
      { 121, 104, 114 },  // a/l both split
      // 16x16 -> 8x8
      { 174, 73, 87 },  // a/l both not split
      { 92, 41, 83 },   // a split, l not split
      { 82, 99, 50 },   // l split, a not split
      { 53, 39, 39 },   // a/l both split
      // 32x32 -> 16x16
      { 177, 58, 59 },  // a/l both not split
      { 68, 26, 63 },   // a split, l not split
      { 52, 79, 25 },   // l split, a not split
      { 17, 14, 12 },   // a/l both split
      // 64x64 -> 32x32
      { 222, 34, 30 },  // a/l both not split
      { 72, 16, 44 },   // a split, l not split
      { 58, 32, 12 },   // l split, a not split
      { 10, 7, 6 },     // a/l both split
#if CONFIG_EXT_PARTITION
      // 128x128 -> 64x64
      { 222, 34, 30 },  // a/l both not split
      { 72, 16, 44 },   // a split, l not split
      { 58, 32, 12 },   // l split, a not split
      { 10, 7, 6 },     // a/l both split
#endif  // CONFIG_EXT_PARTITION
#if CONFIG_UNPOISON_PARTITION_CTX
      { 0, 0, 141 },    // 8x8 -> 4x4
      { 0, 0, 87 },     // 16x16 -> 8x8
      { 0, 0, 59 },     // 32x32 -> 16x16
      { 0, 0, 30 },     // 64x64 -> 32x32
#if CONFIG_EXT_PARTITION
      { 0, 0, 30 },     // 128x128 -> 64x64
#endif  // CONFIG_EXT_PARTITION
      { 0, 122, 0 },    // 8x8 -> 4x4
      { 0, 73, 0 },     // 16x16 -> 8x8
      { 0, 58, 0 },     // 32x32 -> 16x16
      { 0, 34, 0 },     // 64x64 -> 32x32
#if CONFIG_EXT_PARTITION
      { 0, 34, 0 },     // 128x128 -> 64x64
#endif  // CONFIG_EXT_PARTITION
#endif  // CONFIG_UNPOISON_PARTITION_CTX
    };
#endif  // CONFIG_EXT_PARTITION_TYPES

static const aom_prob default_newmv_prob[NEWMV_MODE_CONTEXTS] = {
  155, 116, 94, 32, 96, 56, 30,
};

static const aom_prob default_zeromv_prob[ZEROMV_MODE_CONTEXTS] = {
  45, 13,
};

static const aom_prob default_refmv_prob[REFMV_MODE_CONTEXTS] = {
  178, 212, 135, 244, 203, 122, 128, 128, 128,
};

static const aom_prob default_drl_prob[DRL_MODE_CONTEXTS] = {
  119, 128, 189, 134, 128,
};
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob default_newmv_cdf[NEWMV_MODE_CONTEXTS][CDF_SIZE(2)] =
    { { AOM_ICDF(128 * 155), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 116), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 94), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 32), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 96), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 56), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 30), AOM_ICDF(32768), 0 } };
static const aom_cdf_prob default_zeromv_cdf[ZEROMV_MODE_CONTEXTS][CDF_SIZE(
    2)] = { { AOM_ICDF(128 * 45), AOM_ICDF(32768), 0 },
            { AOM_ICDF(128 * 13), AOM_ICDF(32768), 0 } };
static const aom_cdf_prob default_refmv_cdf[REFMV_MODE_CONTEXTS][CDF_SIZE(2)] =
    { { AOM_ICDF(128 * 178), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 212), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 135), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 244), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 203), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 122), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 } };
static const aom_cdf_prob default_drl_cdf[DRL_MODE_CONTEXTS][CDF_SIZE(2)] = {
  { AOM_ICDF(128 * 119), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 189), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 134), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 }
};
#endif

static const aom_prob default_inter_compound_mode_probs
    [INTER_MODE_CONTEXTS][INTER_COMPOUND_MODES - 1] = {
      { 154, 167, 233, 165, 143, 170, 167 },  // 0 = both zero mv
      { 75, 168, 237, 155, 135, 176, 172 },   // 1 = 1 zero + 1 predicted
      { 7, 173, 227, 128, 153, 188, 189 },    // 2 = two predicted mvs
      { 8, 120, 214, 113, 154, 178, 174 },    // 3 = 1 pred/zero, 1 new
      { 4, 85, 194, 94, 155, 173, 167 },      // 4 = two new mvs
      { 23, 89, 180, 73, 157, 151, 155 },     // 5 = one intra neighbour
      { 27, 49, 152, 91, 134, 153, 142 },     // 6 = two intra neighbours
    };

static const aom_cdf_prob
    default_inter_compound_mode_cdf[INTER_MODE_CONTEXTS][CDF_SIZE(
        INTER_COMPOUND_MODES)] = {
      { AOM_ICDF(19712), AOM_ICDF(28229), AOM_ICDF(30892), AOM_ICDF(31437),
        AOM_ICDF(31712), AOM_ICDF(32135), AOM_ICDF(32360), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9600), AOM_ICDF(24804), AOM_ICDF(29268), AOM_ICDF(30323),
        AOM_ICDF(30802), AOM_ICDF(31726), AOM_ICDF(32177), AOM_ICDF(32768), 0 },
      { AOM_ICDF(896), AOM_ICDF(22434), AOM_ICDF(27015), AOM_ICDF(29026),
        AOM_ICDF(29753), AOM_ICDF(31114), AOM_ICDF(31597), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1024), AOM_ICDF(15904), AOM_ICDF(22127), AOM_ICDF(25421),
        AOM_ICDF(26864), AOM_ICDF(28996), AOM_ICDF(30001), AOM_ICDF(32768), 0 },
      { AOM_ICDF(512), AOM_ICDF(11222), AOM_ICDF(17217), AOM_ICDF(21445),
        AOM_ICDF(23473), AOM_ICDF(26133), AOM_ICDF(27550), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2944), AOM_ICDF(13313), AOM_ICDF(17214), AOM_ICDF(20751),
        AOM_ICDF(23211), AOM_ICDF(25500), AOM_ICDF(26992), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3456), AOM_ICDF(9067), AOM_ICDF(14069), AOM_ICDF(16907),
        AOM_ICDF(18817), AOM_ICDF(21214), AOM_ICDF(23139), AOM_ICDF(32768), 0 }
    };

#if CONFIG_COMPOUND_SINGLEREF
// TODO(zoeliu): Default values to be further adjusted based on the collected
//               stats.
/*
static const aom_prob default_inter_singleref_comp_mode_probs
    [INTER_MODE_CONTEXTS][INTER_SINGLEREF_COMP_MODES - 1] = {
      { 2, 173, 68, 180 },   // 0 = both zero mv
      { 7, 145, 160, 180 },  // 1 = 1 zero + 1 predicted
      { 7, 166, 126, 180 },  // 2 = two predicted mvs
      { 7, 94, 132, 180 },   // 3 = 1 pred/zero, 1 new
      { 8, 64, 64, 180 },    // 4 = two new mvs
      { 17, 81, 52, 180 },   // 5 = one intra neighbour
      { 25, 29, 50, 180 },   // 6 = two intra neighbours
    };*/
static const aom_prob default_inter_singleref_comp_mode_probs
    [INTER_MODE_CONTEXTS][INTER_SINGLEREF_COMP_MODES - 1] = {
      { 2, 173, 68 },   // 0 = both zero mv
      { 7, 145, 160 },  // 1 = 1 zero + 1 predicted
      { 7, 166, 126 },  // 2 = two predicted mvs
      { 7, 94, 132 },   // 3 = 1 pred/zero, 1 new
      { 8, 64, 64 },    // 4 = two new mvs
      { 17, 81, 52 },   // 5 = one intra neighbour
      { 25, 29, 50 },   // 6 = two intra neighbours
    };

static const aom_cdf_prob
    default_inter_singleref_comp_mode_cdf[INTER_MODE_CONTEXTS][CDF_SIZE(
        INTER_SINGLEREF_COMP_MODES)] = {
      { AOM_ICDF(21971), AOM_ICDF(24771), AOM_ICDF(25027), AOM_ICDF(32768), 0 },
      { AOM_ICDF(18053), AOM_ICDF(26690), AOM_ICDF(27586), AOM_ICDF(32768), 0 },
      { AOM_ICDF(20667), AOM_ICDF(26182), AOM_ICDF(27078), AOM_ICDF(32768), 0 },
      { AOM_ICDF(11703), AOM_ICDF(22103), AOM_ICDF(22999), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7936), AOM_ICDF(13888), AOM_ICDF(14912), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9679), AOM_ICDF(13927), AOM_ICDF(16103), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3349), AOM_ICDF(8470), AOM_ICDF(11670), AOM_ICDF(32768), 0 }
    };
#endif  // CONFIG_COMPOUND_SINGLEREF

#if CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
static const aom_prob
    default_compound_type_probs[BLOCK_SIZES_ALL][COMPOUND_TYPES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 128, 128 }, { 128, 128 }, { 128, 128 },
#endif
      { 128, 128 }, { 255, 128 }, { 255, 128 }, { 66, 51 },   { 72, 35 },
      { 79, 29 },   { 71, 18 },   { 81, 29 },   { 81, 26 },   { 69, 19 },
      { 104, 1 },   { 99, 1 },    { 75, 1 },
#if CONFIG_EXT_PARTITION
      { 255, 1 },   { 255, 1 },   { 255, 1 },
#endif  // CONFIG_EXT_PARTITION
      { 208, 128 }, { 208, 128 }, { 208, 128 }, { 208, 128 }, { 208, 1 },
      { 208, 1 },
#if CONFIG_EXT_PARTITION
      { 208, 1 },   { 208, 1 }
#endif  // CONFIG_EXT_PARTITION
    };
#elif !CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
static const aom_prob
    default_compound_type_probs[BLOCK_SIZES_ALL][COMPOUND_TYPES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 255 }, { 255 }, { 255 },
#endif
      { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 216 },
      { 216 }, { 216 }, { 224 }, { 224 }, { 240 }, { 240 },
#if CONFIG_EXT_PARTITION
      { 255 }, { 255 }, { 255 },
#endif  // CONFIG_EXT_PARTITION
      { 208 }, { 208 }, { 208 }, { 208 }, { 255 }, { 255 },
#if CONFIG_EXT_PARTITION
      { 255 }, { 255 }
#endif  // CONFIG_EXT_PARTITION
    };
#elif CONFIG_COMPOUND_SEGMENT && !CONFIG_WEDGE
static const aom_prob
    default_compound_type_probs[BLOCK_SIZES_ALL][COMPOUND_TYPES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 255 }, { 255 }, { 255 },
#endif
      { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 216 },
      { 216 }, { 216 }, { 224 }, { 224 }, { 240 }, { 240 },
#if CONFIG_EXT_PARTITION
      { 255 }, { 255 }, { 255 },
#endif  // CONFIG_EXT_PARTITION
      { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 208 },
#if CONFIG_EXT_PARTITION
      { 208 }, { 208 }
#endif  // CONFIG_EXT_PARTITION
    };
#else
static const aom_prob default_compound_type_probs[BLOCK_SIZES_ALL]
                                                 [COMPOUND_TYPES - 1];
#endif  // CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE

#if CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
static const aom_cdf_prob
    default_compound_type_cdf[BLOCK_SIZES_ALL][CDF_SIZE(COMPOUND_TYPES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32704), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32704), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8448), AOM_ICDF(13293), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(12436), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10112), AOM_ICDF(12679), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9088), AOM_ICDF(10753), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10368), AOM_ICDF(12906), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10368), AOM_ICDF(12643), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8832), AOM_ICDF(10609), AOM_ICDF(32768), 0 },
      { AOM_ICDF(13312), AOM_ICDF(13388), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12672), AOM_ICDF(12751), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9600), AOM_ICDF(9691), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32641), AOM_ICDF(32768), 0 },  // 255, 1
      { AOM_ICDF(32640), AOM_ICDF(32641), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32641), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(26648), AOM_ICDF(32768), 0 },  // 208, 1
      { AOM_ICDF(26624), AOM_ICDF(26648), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(26624), AOM_ICDF(26648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(26648), AOM_ICDF(32768), 0 },
#endif
    };
#elif !CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
static const aom_cdf_prob
    default_compound_type_cdf[BLOCK_SIZES_ALL][CDF_SIZE(COMPOUND_TYPES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },  // 255
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },  // 208
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },  // 216
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28672), AOM_ICDF(32768), 0 },  // 224
      { AOM_ICDF(28672), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30720), AOM_ICDF(32768), 0 },  // 240
      { AOM_ICDF(30720), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },  // 255
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
    };
#elif CONFIG_COMPOUND_SEGMENT && !CONFIG_WEDGE
static const aom_cdf_prob
    default_compound_type_cdf[BLOCK_SIZES_ALL][CDF_SIZE(COMPOUND_TYPES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },  // 255
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },  // 208
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },  // 216
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(27648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28672), AOM_ICDF(32768), 0 },  // 224
      { AOM_ICDF(28672), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30720), AOM_ICDF(32768), 0 },  // 240
      { AOM_ICDF(30720), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },  // 255
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },  // 208
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26624), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
    };
#endif  // CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE

#if CONFIG_INTERINTRA
static const aom_prob default_interintra_prob[BLOCK_SIZE_GROUPS] = {
  128, 226, 244, 254,
};
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob default_interintra_cdf[BLOCK_SIZE_GROUPS][CDF_SIZE(
    2)] = { { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
            { AOM_ICDF(226 * 128), AOM_ICDF(32768), 0 },
            { AOM_ICDF(244 * 128), AOM_ICDF(32768), 0 },
            { AOM_ICDF(254 * 128), AOM_ICDF(32768), 0 } };
#endif

static const aom_prob
    default_interintra_mode_prob[BLOCK_SIZE_GROUPS][INTERINTRA_MODES - 1] = {
      { 128, 128, 128 },  // block_size < 8x8
      { 24, 34, 119 },    // block_size < 16x16
      { 38, 33, 95 },     // block_size < 32x32
      { 51, 21, 110 },    // block_size >= 32x32
    };
static const aom_cdf_prob
    default_interintra_mode_cdf[BLOCK_SIZE_GROUPS][CDF_SIZE(
        INTERINTRA_MODES)] = {
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(28672), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3072), AOM_ICDF(7016), AOM_ICDF(18987), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4864), AOM_ICDF(8461), AOM_ICDF(17481), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6528), AOM_ICDF(8681), AOM_ICDF(19031), AOM_ICDF(32768), 0 }
    };

static const aom_prob default_wedge_interintra_prob[BLOCK_SIZES_ALL] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
  128, 128, 128,
#endif
  128, 128, 128, 194, 213, 217, 222, 224, 226, 220, 128, 128, 128,
#if CONFIG_EXT_PARTITION
  255, 255, 255,
#endif  // CONFIG_EXT_PARTITION
  208, 208, 208, 208, 255, 255,
#if CONFIG_EXT_PARTITION
  255, 255
#endif  // CONFIG_EXT_PARTITION
};

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_wedge_interintra_cdf[BLOCK_SIZES_ALL][CDF_SIZE(2)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(194 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(213 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(217 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(222 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(224 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(226 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(220 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
    };
#endif  // CONFIG_NEW_MULTISYMBOL

#endif  // CONFIG_INTERINTRA

#if CONFIG_NCOBMC_ADAPT_WEIGHT
#ifdef TWO_MODE
const aom_tree_index av1_ncobmc_mode_tree[TREE_SIZE(MAX_NCOBMC_MODES)] = {
  -NCOBMC_MODE_0, -NCOBMC_MODE_1
};
#else
const aom_tree_index av1_ncobmc_mode_tree[TREE_SIZE(MAX_NCOBMC_MODES)] = {
  -NCOBMC_MODE_0, 2,
  -NCOBMC_MODE_1, 4,
  -NCOBMC_MODE_2, 6,
  -NCOBMC_MODE_3, 8,
  -NCOBMC_MODE_4, 10,
  -NCOBMC_MODE_5, 12,
  -NCOBMC_MODE_6, -NCOBMC_MODE_7
};
#endif  // TWO_MODE

// TODO(weitinglin): find default prob
//                   right now setting the first mode with probability 1/255,
//                   the last eight modes with equal probabilities
static const aom_prob
    default_ncobmc_mode_prob[ADAPT_OVERLAP_BLOCKS][MAX_NCOBMC_MODES - 1] = {
#ifdef TWO_MODE
      { 127 }, { 127 }, { 127 }, { 127 }
#else
      { 32, 36, 43, 51, 64, 85, 128 },  // 8x8
      { 32, 36, 43, 51, 64, 85, 128 },  // 16X16
      { 32, 36, 43, 51, 64, 85, 128 },  // 32X32
      { 32, 36, 43, 51, 64, 85, 128 }   // 64X64
#endif  // TWO_MODE
    };
static const aom_cdf_prob
    default_ncobmc_mode_cdf[ADAPT_OVERLAP_BLOCKS][CDF_SIZE(MAX_NCOBMC_MODES)] =
#ifdef TWO_MODE
        { { AOM_ICDF(16256), AOM_ICDF(32768), 0 },
          { AOM_ICDF(16256), AOM_ICDF(32768), 0 },
          { AOM_ICDF(16256), AOM_ICDF(32768), 0 },
          { AOM_ICDF(16256), AOM_ICDF(32768), 0 } };
#else
        { { AOM_ICDF(4096), AOM_ICDF(8192), AOM_ICDF(12288), AOM_ICDF(16384),
            AOM_ICDF(20480), AOM_ICDF(24576), AOM_ICDF(28672), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(4096), AOM_ICDF(8192), AOM_ICDF(12288), AOM_ICDF(16384),
            AOM_ICDF(20480), AOM_ICDF(24576), AOM_ICDF(28672), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(4096), AOM_ICDF(8192), AOM_ICDF(12288), AOM_ICDF(16384),
            AOM_ICDF(20480), AOM_ICDF(24576), AOM_ICDF(28672), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(4096), AOM_ICDF(8192), AOM_ICDF(12288), AOM_ICDF(16384),
            AOM_ICDF(20480), AOM_ICDF(24576), AOM_ICDF(28672), AOM_ICDF(32768),
            0 } };
#endif  // TWO_MODEE
#endif  // CONFIG_NCOBMC_ADAPT_WEIGHT
// Change this section appropriately once warped motion is supported
#if CONFIG_MOTION_VAR && !CONFIG_WARPED_MOTION
#if CONFIG_NCOBMC_ADAPT_WEIGHT
const aom_tree_index av1_motion_mode_tree[TREE_SIZE(MOTION_MODES)] = {
  -SIMPLE_TRANSLATION, 2, -OBMC_CAUSAL, -NCOBMC_ADAPT_WEIGHT,
};
static const aom_prob
    default_motion_mode_prob[BLOCK_SIZES_ALL][MOTION_MODES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 255, 255 },
      { 255, 255 },
      { 255, 255 },
#endif
      { 255, 255 },
      { 255, 255 },
      { 255, 255 },
      /** Only these nine block sizes allow ncobmc_adapt_weight **/
      { 45, 207 },
      { 42, 211 },
      { 34, 207 },
      { 181, 123 },
      { 129, 141 },
      { 15, 209 },
      { 231, 122 },
      { 195, 190 },
      { 168, 190 },
      /** ----------------------------------------------------- **/
      { 244, 255 },
#if CONFIG_EXT_PARTITION
      { 252, 255 },
      { 252, 255 },
      { 252, 255 },
#endif  // CONFIG_EXT_PARTITION
      { 255, 200 },
      { 255, 200 },
      { 255, 200 },
      { 255, 200 },
#if CONFIG_EXT_PARTITION
      { 252, 255 },
      { 252, 200 },
      { 252, 200 },
#endif  // CONFIG_EXT_PARTITION
    };
static const aom_cdf_prob
    default_motion_mode_cdf[BLOCK_SIZES_ALL][CDF_SIZE(MOTION_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
#endif
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0, 0 },
      /** Only these seven block sizes allow ncobmc_adapt_weight **/
      { AOM_ICDF(5702), AOM_ICDF(27555), AOM_ICDF(32768), 0 },
      { AOM_ICDF(5408), AOM_ICDF(27964), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4330), AOM_ICDF(27298), AOM_ICDF(32768), 0 },
      { AOM_ICDF(23107), AOM_ICDF(27760), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16490), AOM_ICDF(25461), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1959), AOM_ICDF(27153), AOM_ICDF(32768), 0 },
      { AOM_ICDF(29530), AOM_ICDF(31073), AOM_ICDF(32768), 0 },
      { AOM_ICDF(25057), AOM_ICDF(30840), AOM_ICDF(32768), 0 },
      { AOM_ICDF(21588), AOM_ICDF(29940), AOM_ICDF(32768), 0 },
      /** ----------------------------------------------------- **/
      { AOM_ICDF(244 * 128), AOM_ICDF(32768), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32256), AOM_ICDF(32768), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32768), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32768), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 }
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
#endif
    };
#else  // CONFIG_NCOBMC_ADAPT_WEIGHT
const aom_tree_index av1_motion_mode_tree[TREE_SIZE(MOTION_MODES)] = {
  -SIMPLE_TRANSLATION, -OBMC_CAUSAL
};

static const aom_prob
    default_motion_mode_prob[BLOCK_SIZES_ALL][MOTION_MODES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 255 }, { 255 }, { 255 },
#endif
      { 255 }, { 255 }, { 255 }, { 151 }, { 153 }, { 144 }, { 178 },
      { 165 }, { 160 }, { 207 }, { 195 }, { 168 }, { 244 },
#if CONFIG_EXT_PARTITION
      { 252 }, { 252 }, { 252 },
#endif  // CONFIG_EXT_PARTITION
      { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 208 },
#if CONFIG_EXT_PARTITION
      { 208 }, { 208 }
#endif  // CONFIG_EXT_PARTITION
    };

static const aom_cdf_prob
    default_motion_mode_cdf[BLOCK_SIZES_ALL][CDF_SIZE(MOTION_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(151 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(153 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(144 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(178 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(165 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(160 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(207 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(195 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(168 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(244 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
    };
#endif  // CONFIG_NCOBMC_ADAPT_WEIGHT
#elif !CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION

const aom_tree_index av1_motion_mode_tree[TREE_SIZE(MOTION_MODES)] = {
  -SIMPLE_TRANSLATION, -WARPED_CAUSAL
};

static const aom_prob
    default_motion_mode_prob[BLOCK_SIZES_ALL][MOTION_MODES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 255 }, { 255 }, { 255 },
#endif
      { 255 }, { 255 }, { 255 }, { 151 }, { 153 }, { 144 }, { 178 },
      { 165 }, { 160 }, { 207 }, { 195 }, { 168 }, { 244 },
#if CONFIG_EXT_PARTITION
      { 252 }, { 252 }, { 252 },
#endif  // CONFIG_EXT_PARTITION
      { 208 }, { 208 }, { 208 }, { 208 }, { 208 }, { 208 },
#if CONFIG_EXT_PARTITION
      { 252 }, { 252 }
#endif  // CONFIG_EXT_PARTITION
    };

static const aom_cdf_prob
    default_motion_mode_cdf[BLOCK_SIZES_ALL][CDF_SIZE(MOTION_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(151 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(153 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(144 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(178 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(165 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(160 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(207 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(195 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(168 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(244 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(255 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
    };

#elif CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
#if CONFIG_NCOBMC_ADAPT_WEIGHT
const aom_tree_index av1_motion_mode_tree[TREE_SIZE(MOTION_MODES)] = {
  -SIMPLE_TRANSLATION, 2, -OBMC_CAUSAL, 4, -NCOBMC_ADAPT_WEIGHT, -WARPED_CAUSAL
};

static const aom_prob default_motion_mode_prob[BLOCK_SIZES_ALL][MOTION_MODES -
                                                                1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
  { 128, 128, 255 }, { 128, 128, 128 }, { 128, 128, 128 },
#endif
  { 128, 128, 128 }, { 128, 128, 128 }, { 128, 128, 128 }, { 62, 115, 128 },
  { 39, 131, 128 },  { 39, 132, 128 },  { 118, 94, 128 },  { 77, 125, 128 },
  { 100, 121, 128 }, { 190, 66, 128 },  { 207, 102, 128 }, { 197, 100, 128 },
  { 239, 76, 128 },
#if CONFIG_EXT_PARTITION
  { 252, 200, 128 }, { 252, 200, 128 }, { 252, 200, 128 },
#endif  // CONFIG_EXT_PARTITION
  { 208, 200, 128 }, { 208, 200, 128 }, { 208, 200, 128 }, { 208, 200, 128 }
};
static const aom_cdf_prob
    default_motion_mode_cdf[BLOCK_SIZES_ALL][CDF_SIZE(MOTION_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      /** Only these nine block sizes allow ncobmc_adapt_weight **/
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8192), AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      /***********************************************************/
      { AOM_ICDF(30592), AOM_ICDF(31238), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32767), AOM_ICDF(32768), 0 }
    };

const aom_tree_index av1_ncobmc_tree[TREE_SIZE(OBMC_FAMILY_MODES)] = {
  -SIMPLE_TRANSLATION, 2, -OBMC_CAUSAL, -NCOBMC_ADAPT_WEIGHT
};

static const aom_prob
    default_ncobmc_prob[BLOCK_SIZES_ALL][OBMC_FAMILY_MODES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 128, 255 }, { 128, 255 }, { 128, 255 },
#endif
      { 128, 255 }, { 128, 255 }, { 128, 255 }, { 45, 255 },  { 79, 255 },
      { 75, 255 },  { 130, 255 }, { 141, 255 }, { 144, 255 }, { 208, 255 },
      { 201, 255 }, { 186, 255 }, { 231, 255 },
#if CONFIG_EXT_PARTITION
      { 252, 255 }, { 252, 255 }, { 252, 255 },
#endif  // CONFIG_EXT_PARTITION
      { 208, 255 }, { 208, 255 }, { 208, 255 }, { 208, 255 }
    };

static const aom_cdf_prob
    default_ncobmc_cdf[BLOCK_SIZES_ALL][CDF_SIZE(OBMC_FAMILY_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      /** Only these nine block sizes allow ncobmc_adapt_weight **/
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10922), AOM_ICDF(21845), AOM_ICDF(32768), 0 },
      /***********************************************************/
      { AOM_ICDF(231 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(252 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(252 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32767), AOM_ICDF(32768), 0 }
    };
#else
const aom_tree_index av1_motion_mode_tree[TREE_SIZE(MOTION_MODES)] = {
  -SIMPLE_TRANSLATION, 2, -OBMC_CAUSAL, -WARPED_CAUSAL,
};

static const aom_prob
    default_motion_mode_prob[BLOCK_SIZES_ALL][MOTION_MODES - 1] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { 128, 128 }, { 128, 128 }, { 128, 128 },
#endif
      { 128, 128 }, { 128, 128 }, { 128, 128 }, { 62, 115 },  { 39, 131 },
      { 39, 132 },  { 118, 94 },  { 77, 125 },  { 100, 121 }, { 190, 66 },
      { 207, 102 }, { 197, 100 }, { 239, 76 },
#if CONFIG_EXT_PARTITION
      { 252, 200 }, { 252, 200 }, { 252, 200 },
#endif  // CONFIG_EXT_PARTITION
      { 208, 200 }, { 208, 200 }, { 208, 200 }, { 208, 200 }, { 208, 200 },
      { 208, 200 },
#if CONFIG_EXT_PARTITION
      { 252, 200 }, { 252, 200 }
#endif  // CONFIG_EXT_PARTITION
    };
static const aom_cdf_prob
    default_motion_mode_cdf[BLOCK_SIZES_ALL][CDF_SIZE(MOTION_MODES)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(16384), AOM_ICDF(24576), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7936), AOM_ICDF(19091), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4991), AOM_ICDF(19205), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4992), AOM_ICDF(19314), AOM_ICDF(32768), 0 },
      { AOM_ICDF(15104), AOM_ICDF(21590), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9855), AOM_ICDF(21043), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12800), AOM_ICDF(22238), AOM_ICDF(32768), 0 },
      { AOM_ICDF(24320), AOM_ICDF(26498), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26496), AOM_ICDF(28995), AOM_ICDF(32768), 0 },
      { AOM_ICDF(25216), AOM_ICDF(28166), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30592), AOM_ICDF(31238), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32640), AOM_ICDF(32740), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32256), AOM_ICDF(32656), AOM_ICDF(32768), 0 },
#endif
    };
#endif  // CONFIG_NCOBMC_ADAPT_WEIGHT
// Probability for the case that only 1 additional motion mode is allowed
static const aom_prob default_obmc_prob[BLOCK_SIZES_ALL] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
  128, 128, 128,
#endif
  128, 128, 128, 45,  79,  75,  130, 141, 144, 208, 201, 186, 231,
#if CONFIG_EXT_PARTITION
  252, 252, 252,
#endif  // CONFIG_EXT_PARTITION
  208, 208, 208, 208, 208, 208,
#if CONFIG_EXT_PARTITION
  252, 252
#endif  // CONFIG_EXT_PARTITION
};

#if CONFIG_NEW_MULTISYMBOL || CONFIG_NCOBMC_ADAPT_WEIGHT
static const aom_cdf_prob default_obmc_cdf[BLOCK_SIZES_ALL][CDF_SIZE(2)] = {
#if CONFIG_CHROMA_2X2 || CONFIG_CHROMA_SUB8X8
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
#endif
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(45 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(79 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(75 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(130 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(141 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(144 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(201 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(186 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(231 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
  { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
  { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
  { AOM_ICDF(252 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_EXT_PARTITION
};
#endif  // CONFIG_NEW_MULTISYMBOL
#endif

static const aom_prob default_delta_q_probs[DELTA_Q_PROBS] = { 220, 220, 220 };
static const aom_cdf_prob default_delta_q_cdf[CDF_SIZE(DELTA_Q_PROBS + 1)] = {
  AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0
};
#if CONFIG_EXT_DELTA_Q
#if CONFIG_LOOPFILTER_LEVEL
static const aom_prob
    default_delta_lf_multi_probs[FRAME_LF_COUNT][DELTA_LF_PROBS] = {
      { 220, 220, 220 }, { 220, 220, 220 }, { 220, 220, 220 }, { 220, 220, 220 }
    };
static const aom_cdf_prob
    default_delta_lf_multi_cdf[FRAME_LF_COUNT][CDF_SIZE(DELTA_LF_PROBS + 1)] = {
      { AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0 }
    };
#endif  // CONFIG_LOOPFILTER_LEVEL
static const aom_prob default_delta_lf_probs[DELTA_LF_PROBS] = { 220, 220,
                                                                 220 };
static const aom_cdf_prob default_delta_lf_cdf[CDF_SIZE(DELTA_LF_PROBS + 1)] = {
  AOM_ICDF(28160), AOM_ICDF(32120), AOM_ICDF(32677), AOM_ICDF(32768), 0
};
#endif

/* clang-format off */
#if CONFIG_INTERINTRA
const aom_tree_index av1_interintra_mode_tree[TREE_SIZE(INTERINTRA_MODES)] = {
  -II_DC_PRED, 2,        /* 0 = II_DC_NODE     */
  -II_SMOOTH_PRED, 4,    /* 1 = II_SMOOTH_PRED */
  -II_V_PRED, -II_H_PRED /* 2 = II_V_NODE      */
};
#endif  // CONFIG_INTERINTRA

const aom_tree_index av1_inter_compound_mode_tree
    [TREE_SIZE(INTER_COMPOUND_MODES)] = {
  -INTER_COMPOUND_OFFSET(ZERO_ZEROMV), 2,
  -INTER_COMPOUND_OFFSET(NEAREST_NEARESTMV), 4,
  6, -INTER_COMPOUND_OFFSET(NEW_NEWMV),
  -INTER_COMPOUND_OFFSET(NEAR_NEARMV), 8,
  10, 12,
  -INTER_COMPOUND_OFFSET(NEAREST_NEWMV), -INTER_COMPOUND_OFFSET(NEW_NEARESTMV),
  -INTER_COMPOUND_OFFSET(NEAR_NEWMV), -INTER_COMPOUND_OFFSET(NEW_NEARMV)
};

#if CONFIG_COMPOUND_SINGLEREF
// TODO(zoeliu): To redesign the tree structure once the number of mode changes.
/*
const aom_tree_index av1_inter_singleref_comp_mode_tree
    [TREE_SIZE(INTER_SINGLEREF_COMP_MODES)] = {
  -INTER_SINGLEREF_COMP_OFFSET(SR_ZERO_NEWMV), 2,
  -INTER_SINGLEREF_COMP_OFFSET(SR_NEAREST_NEARMV), 4,
  6, -INTER_SINGLEREF_COMP_OFFSET(SR_NEW_NEWMV),
  -INTER_SINGLEREF_COMP_OFFSET(SR_NEAREST_NEWMV),
  -INTER_SINGLEREF_COMP_OFFSET(SR_NEAR_NEWMV)
};*/

const aom_tree_index av1_inter_singleref_comp_mode_tree
    [TREE_SIZE(INTER_SINGLEREF_COMP_MODES)] = {
  -INTER_SINGLEREF_COMP_OFFSET(SR_ZERO_NEWMV), 2,
  -INTER_SINGLEREF_COMP_OFFSET(SR_NEAREST_NEARMV), 4,
  -INTER_SINGLEREF_COMP_OFFSET(SR_NEAR_NEWMV),
      -INTER_SINGLEREF_COMP_OFFSET(SR_NEW_NEWMV)
};
#endif  // CONFIG_COMPOUND_SINGLEREF

#if CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
const aom_tree_index av1_compound_type_tree[TREE_SIZE(COMPOUND_TYPES)] = {
  -COMPOUND_AVERAGE, 2, -COMPOUND_WEDGE, -COMPOUND_SEG
};
#elif !CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
const aom_tree_index av1_compound_type_tree[TREE_SIZE(COMPOUND_TYPES)] = {
  -COMPOUND_AVERAGE, -COMPOUND_WEDGE
};
#elif CONFIG_COMPOUND_SEGMENT && !CONFIG_WEDGE
const aom_tree_index av1_compound_type_tree[TREE_SIZE(COMPOUND_TYPES)] = {
  -COMPOUND_AVERAGE, -COMPOUND_SEG
};
#else
const aom_tree_index av1_compound_type_tree[TREE_SIZE(COMPOUND_TYPES)] = {};
#endif  // CONFIG_COMPOUND_SEGMENT && CONFIG_WEDGE
/* clang-format on */

const aom_tree_index av1_partition_tree[TREE_SIZE(PARTITION_TYPES)] = {
  -PARTITION_NONE, 2, -PARTITION_HORZ, 4, -PARTITION_VERT, -PARTITION_SPLIT
};

#if CONFIG_EXT_PARTITION_TYPES
/* clang-format off */
const aom_tree_index av1_ext_partition_tree[TREE_SIZE(EXT_PARTITION_TYPES)] = {
  -PARTITION_NONE, 2,
  6, 4,
  8, -PARTITION_SPLIT,
  -PARTITION_HORZ, 10,
  -PARTITION_VERT, 14,

  -PARTITION_HORZ_A, 12,
  -PARTITION_HORZ_B, -PARTITION_HORZ_4,

  -PARTITION_VERT_A, 16,
  -PARTITION_VERT_B, -PARTITION_VERT_4
};
/* clang-format on */
#endif  // CONFIG_EXT_PARTITION_TYPES

static const aom_prob default_intra_inter_p[INTRA_INTER_CONTEXTS] = {
  6, 97, 151, 205,
};

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_intra_inter_cdf[INTRA_INTER_CONTEXTS][CDF_SIZE(2)] = {
      { AOM_ICDF(768), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12416), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19328), AOM_ICDF(32768), 0 },
      { AOM_ICDF(26240), AOM_ICDF(32768), 0 }
    };
#endif

static const aom_prob default_comp_inter_p[COMP_INTER_CONTEXTS] = {
  190, 156, 91, 77, 22
};

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob default_comp_inter_cdf[COMP_INTER_CONTEXTS][CDF_SIZE(
    2)] = { { AOM_ICDF(24290), AOM_ICDF(32768), 0 },
            { AOM_ICDF(19956), AOM_ICDF(32768), 0 },
            { AOM_ICDF(11641), AOM_ICDF(32768), 0 },
            { AOM_ICDF(9804), AOM_ICDF(32768), 0 },
            { AOM_ICDF(2842), AOM_ICDF(32768), 0 } };
#endif  // CONFIG_NEW_MULTISYMBOL

#if CONFIG_EXT_COMP_REFS
static const aom_prob default_comp_ref_type_p[COMP_REF_TYPE_CONTEXTS] = {
  8, 20, 78, 91, 194
};
static const aom_prob
    default_uni_comp_ref_p[UNI_COMP_REF_CONTEXTS][UNIDIR_COMP_REFS - 1] = {
      { 88, 30, 28 }, { 218, 97, 105 }, { 254, 180, 196 }
    };

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_comp_ref_type_cdf[COMP_REF_TYPE_CONTEXTS][CDF_SIZE(2)] = {
      { AOM_ICDF(8 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(20 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(78 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(91 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(194 * 128), AOM_ICDF(32768), 0 }
    };
static const aom_cdf_prob
    default_uni_comp_ref_cdf[UNI_COMP_REF_CONTEXTS][UNIDIR_COMP_REFS - 1]
                            [CDF_SIZE(2)] = {
                              { { AOM_ICDF(88 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(30 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(28 * 128), AOM_ICDF(32768), 0 } },
                              { { AOM_ICDF(218 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(97 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(105 * 128), AOM_ICDF(32768), 0 } },
                              { { AOM_ICDF(254 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(180 * 128), AOM_ICDF(32768), 0 },
                                { AOM_ICDF(196 * 128), AOM_ICDF(32768), 0 } }
                            };
#endif  // CONFIG_NEW_MULTISYMBOL
#endif  // CONFIG_EXT_COMP_REFS

#if CONFIG_EXT_REFS
static const aom_prob default_comp_ref_p[REF_CONTEXTS][FWD_REFS - 1] = {
  { 28, 10, 8 },
  { 77, 27, 26 },
  { 127, 62, 56 },
  { 186, 126, 160 },
  { 236, 143, 172 }
};

static const aom_prob default_comp_bwdref_p[REF_CONTEXTS][BWD_REFS - 1] = {
  { 22, 13 }, { 140, 124 }, { 241, 239 }, { 128, 128 }, { 128, 128 }
};

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_comp_ref_cdf[REF_CONTEXTS][FWD_REFS - 1][CDF_SIZE(2)] = {
      { { AOM_ICDF(3556), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1217), AOM_ICDF(32768), 0 },
        { AOM_ICDF(988), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(9857), AOM_ICDF(32768), 0 },
        { AOM_ICDF(3394), AOM_ICDF(32768), 0 },
        { AOM_ICDF(3303), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(16237), AOM_ICDF(32768), 0 },
        { AOM_ICDF(7946), AOM_ICDF(32768), 0 },
        { AOM_ICDF(7195), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(23826), AOM_ICDF(32768), 0 },
        { AOM_ICDF(16124), AOM_ICDF(32768), 0 },
        { AOM_ICDF(20536), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(30195), AOM_ICDF(32768), 0 },
        { AOM_ICDF(18344), AOM_ICDF(32768), 0 },
        { AOM_ICDF(21980), AOM_ICDF(32768), 0 } }
    };

static const aom_cdf_prob
    default_comp_bwdref_cdf[REF_CONTEXTS][BWD_REFS - 1][CDF_SIZE(2)] = {
      { { AOM_ICDF(2762), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1614), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(17976), AOM_ICDF(32768), 0 },
        { AOM_ICDF(15912), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(30894), AOM_ICDF(32768), 0 },
        { AOM_ICDF(30639), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(32768), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(32768), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 } }
    };
#endif  // CONFIG_NEW_MULTISYMBOL

#else  // !CONFIG_EXT_REFS

static const aom_prob default_comp_ref_p[REF_CONTEXTS][COMP_REFS - 1] = {
  { 43 }, { 100 }, { 137 }, { 212 }, { 229 },
};
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_comp_ref_cdf[REF_CONTEXTS][COMP_REFS - 1][CDF_SIZE(2)] = {
      { { AOM_ICDF(43 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(100 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(137 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(212 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(229 * 128), AOM_ICDF(32768), 0 } }
    };
#endif  // CONFIG_NEW_MULTISYMBOL
#endif  // CONFIG_EXT_REFS

static const aom_prob default_single_ref_p[REF_CONTEXTS][SINGLE_REFS - 1] = {
#if CONFIG_EXT_REFS
  { 36, 16, 32, 57, 11, 14 },
  { 68, 128, 73, 128, 49, 124 },
  { 136, 236, 127, 170, 81, 238 },
  { 128, 128, 191, 211, 115, 128 },
  { 224, 128, 230, 242, 208, 128 }
#else   // !CONFIG_EXT_REFS
  { 31, 25 }, { 72, 80 }, { 147, 148 }, { 197, 191 }, { 235, 247 },
#endif  // CONFIG_EXT_REFS
};

#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_single_ref_cdf[REF_CONTEXTS][SINGLE_REFS - 1][CDF_SIZE(2)] = {
#if CONFIG_EXT_REFS
      { { AOM_ICDF(4623), AOM_ICDF(32768), 0 },
        { AOM_ICDF(2110), AOM_ICDF(32768), 0 },
        { AOM_ICDF(4132), AOM_ICDF(32768), 0 },
        { AOM_ICDF(7309), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1392), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1781), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(8659), AOM_ICDF(32768), 0 },
        { AOM_ICDF(16372), AOM_ICDF(32768), 0 },
        { AOM_ICDF(9371), AOM_ICDF(32768), 0 },
        { AOM_ICDF(16322), AOM_ICDF(32768), 0 },
        { AOM_ICDF(6216), AOM_ICDF(32768), 0 },
        { AOM_ICDF(15834), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(17353), AOM_ICDF(32768), 0 },
        { AOM_ICDF(30182), AOM_ICDF(32768), 0 },
        { AOM_ICDF(16300), AOM_ICDF(32768), 0 },
        { AOM_ICDF(21702), AOM_ICDF(32768), 0 },
        { AOM_ICDF(10365), AOM_ICDF(32768), 0 },
        { AOM_ICDF(30486), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(32768), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 },
        { AOM_ICDF(24426), AOM_ICDF(32768), 0 },
        { AOM_ICDF(26972), AOM_ICDF(32768), 0 },
        { AOM_ICDF(14760), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(28634), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 },
        { AOM_ICDF(29425), AOM_ICDF(32768), 0 },
        { AOM_ICDF(30969), AOM_ICDF(32768), 0 },
        { AOM_ICDF(26676), AOM_ICDF(32768), 0 },
        { AOM_ICDF(32768), AOM_ICDF(32768), 0 } }
#else   // !CONFIG_EXT_REFS
      { { AOM_ICDF(31 * 128), AOM_ICDF(32768), 0 },
        { AOM_ICDF(25 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(72 * 128), AOM_ICDF(32768), 0 },
        { AOM_ICDF(80 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(147 * 128), AOM_ICDF(32768), 0 },
        { AOM_ICDF(148 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(197 * 128), AOM_ICDF(32768), 0 },
        { AOM_ICDF(191 * 128), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(235 * 128), AOM_ICDF(32768), 0 },
        { AOM_ICDF(247 * 128), AOM_ICDF(32768), 0 } }
#endif  // CONFIG_EXT_REFS
    };
#endif  // CONFIG_NEW_MULTISYMBOL

#if CONFIG_COMPOUND_SINGLEREF
// TODO(zoeliu): Default values to be further adjusted based on the collected
//               stats.
static const aom_prob default_comp_inter_mode_p[COMP_INTER_MODE_CONTEXTS] = {
  40, 110, 160, 220
};
#endif  // CONFIG_COMPOUND_SINGLEREF

// TODO(huisu): tune these cdfs
const aom_cdf_prob
    default_palette_y_size_cdf[PALETTE_BLOCK_SIZES][CDF_SIZE(PALETTE_SIZES)] = {
      { AOM_ICDF(12288), AOM_ICDF(19408), AOM_ICDF(24627), AOM_ICDF(26662),
        AOM_ICDF(28499), AOM_ICDF(30667), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2815), AOM_ICDF(4570), AOM_ICDF(9416), AOM_ICDF(10875),
        AOM_ICDF(13782), AOM_ICDF(19863), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3839), AOM_ICDF(5986), AOM_ICDF(11949), AOM_ICDF(13413),
        AOM_ICDF(16286), AOM_ICDF(21823), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12032), AOM_ICDF(14948), AOM_ICDF(22187), AOM_ICDF(23138),
        AOM_ICDF(24756), AOM_ICDF(27635), AOM_ICDF(32768), 0 },
      { AOM_ICDF(14847), AOM_ICDF(20167), AOM_ICDF(25433), AOM_ICDF(26751),
        AOM_ICDF(28278), AOM_ICDF(30119), AOM_ICDF(32768), 0 },
      { AOM_ICDF(14336), AOM_ICDF(20240), AOM_ICDF(24840), AOM_ICDF(26079),
        AOM_ICDF(27908), AOM_ICDF(30034), AOM_ICDF(32768), 0 },
      { AOM_ICDF(18816), AOM_ICDF(25574), AOM_ICDF(29030), AOM_ICDF(29877),
        AOM_ICDF(30656), AOM_ICDF(31506), AOM_ICDF(32768), 0 },
      { AOM_ICDF(23039), AOM_ICDF(27333), AOM_ICDF(30220), AOM_ICDF(30708),
        AOM_ICDF(31070), AOM_ICDF(31826), AOM_ICDF(32768), 0 },
      { AOM_ICDF(13696), AOM_ICDF(18911), AOM_ICDF(23620), AOM_ICDF(25371),
        AOM_ICDF(29821), AOM_ICDF(31617), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12543), AOM_ICDF(20838), AOM_ICDF(27455), AOM_ICDF(28762),
        AOM_ICDF(29763), AOM_ICDF(31546), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(12543), AOM_ICDF(20838), AOM_ICDF(27455), AOM_ICDF(28762),
        AOM_ICDF(29763), AOM_ICDF(31546), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12543), AOM_ICDF(20838), AOM_ICDF(27455), AOM_ICDF(28762),
        AOM_ICDF(29763), AOM_ICDF(31546), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12543), AOM_ICDF(20838), AOM_ICDF(27455), AOM_ICDF(28762),
        AOM_ICDF(29763), AOM_ICDF(31546), AOM_ICDF(32768), 0 },
#endif
    };

const aom_cdf_prob default_palette_uv_size_cdf[PALETTE_BLOCK_SIZES][CDF_SIZE(
    PALETTE_SIZES)] = {
  { AOM_ICDF(20480), AOM_ICDF(29888), AOM_ICDF(32453), AOM_ICDF(32715),
    AOM_ICDF(32751), AOM_ICDF(32766), AOM_ICDF(32768), 0 },
  { AOM_ICDF(11135), AOM_ICDF(23641), AOM_ICDF(31056), AOM_ICDF(31998),
    AOM_ICDF(32496), AOM_ICDF(32668), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9216), AOM_ICDF(23108), AOM_ICDF(30806), AOM_ICDF(31871),
    AOM_ICDF(32414), AOM_ICDF(32637), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9984), AOM_ICDF(21999), AOM_ICDF(29192), AOM_ICDF(30645),
    AOM_ICDF(31640), AOM_ICDF(32402), AOM_ICDF(32768), 0 },
  { AOM_ICDF(7552), AOM_ICDF(16614), AOM_ICDF(24880), AOM_ICDF(27283),
    AOM_ICDF(29254), AOM_ICDF(31203), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9600), AOM_ICDF(20279), AOM_ICDF(27548), AOM_ICDF(29261),
    AOM_ICDF(30494), AOM_ICDF(31631), AOM_ICDF(32768), 0 },
  { AOM_ICDF(11391), AOM_ICDF(18656), AOM_ICDF(23727), AOM_ICDF(26058),
    AOM_ICDF(27788), AOM_ICDF(30278), AOM_ICDF(32768), 0 },
  { AOM_ICDF(8576), AOM_ICDF(13585), AOM_ICDF(17632), AOM_ICDF(20884),
    AOM_ICDF(23948), AOM_ICDF(27152), AOM_ICDF(32768), 0 },
  { AOM_ICDF(15360), AOM_ICDF(24200), AOM_ICDF(26978), AOM_ICDF(30846),
    AOM_ICDF(31409), AOM_ICDF(32545), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9216), AOM_ICDF(14276), AOM_ICDF(19043), AOM_ICDF(22689),
    AOM_ICDF(25799), AOM_ICDF(28712), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
  { AOM_ICDF(9216), AOM_ICDF(14276), AOM_ICDF(19043), AOM_ICDF(22689),
    AOM_ICDF(25799), AOM_ICDF(28712), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9216), AOM_ICDF(14276), AOM_ICDF(19043), AOM_ICDF(22689),
    AOM_ICDF(25799), AOM_ICDF(28712), AOM_ICDF(32768), 0 },
  { AOM_ICDF(9216), AOM_ICDF(14276), AOM_ICDF(19043), AOM_ICDF(22689),
    AOM_ICDF(25799), AOM_ICDF(28712), AOM_ICDF(32768), 0 },
#endif
};

// When palette mode is enabled, following probability tables indicate the
// probabilities to code the "is_palette" bit (i.e. the bit that indicates
// if this block uses palette mode or DC_PRED mode).
const aom_prob av1_default_palette_y_mode_prob
    [PALETTE_BLOCK_SIZES][PALETTE_Y_MODE_CONTEXTS] = {
      { 240, 180, 100 }, { 240, 180, 100 }, { 240, 180, 100 },
      { 240, 180, 100 }, { 240, 180, 100 }, { 240, 180, 100 },
      { 240, 180, 100 }, { 240, 180, 100 }, { 240, 180, 100 },
      { 240, 180, 100 },
#if CONFIG_EXT_PARTITION
      { 240, 180, 100 }, { 240, 180, 100 }, { 240, 180, 100 },
#endif  // CONFIG_EXT_PARTITION
    };

const aom_prob av1_default_palette_uv_mode_prob[PALETTE_UV_MODE_CONTEXTS] = {
  253, 229
};

#if CONFIG_NEW_MULTISYMBOL
const aom_cdf_prob
    default_palette_y_mode_cdf[PALETTE_BLOCK_SIZES][PALETTE_Y_MODE_CONTEXTS]
                              [CDF_SIZE(2)] = {
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
#if CONFIG_EXT_PARTITION
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
                                { { AOM_ICDF(128 * 240), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 180), AOM_ICDF(32768), 0 },
                                  { AOM_ICDF(128 * 100), AOM_ICDF(32768), 0 } },
#endif  // CONFIG_EXT_PARTITION
                              };

const aom_cdf_prob
    default_palette_uv_mode_cdf[PALETTE_UV_MODE_CONTEXTS][CDF_SIZE(2)] = {
      { AOM_ICDF(128 * 253), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 229), AOM_ICDF(32768), 0 }
    };

#endif

const aom_cdf_prob default_palette_y_color_index_cdf
    [PALETTE_SIZES][PALETTE_COLOR_INDEX_CONTEXTS][CDF_SIZE(PALETTE_COLORS)] = {
      {
          { AOM_ICDF(29568), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(16384), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(8832), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(28672), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(31872), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(28032), AOM_ICDF(30326), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(11647), AOM_ICDF(27405), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(4352), AOM_ICDF(30659), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(23552), AOM_ICDF(27800), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(32256), AOM_ICDF(32504), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
      },
      {
          { AOM_ICDF(26112), AOM_ICDF(28374), AOM_ICDF(30039), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(9472), AOM_ICDF(22576), AOM_ICDF(27712), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(26138), AOM_ICDF(29608), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(19328), AOM_ICDF(23791), AOM_ICDF(28946), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31984), AOM_ICDF(32336), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(27904), AOM_ICDF(29215), AOM_ICDF(30075), AOM_ICDF(31190),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(9728), AOM_ICDF(22598), AOM_ICDF(26134), AOM_ICDF(29425),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(2688), AOM_ICDF(30066), AOM_ICDF(31058), AOM_ICDF(31933),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(22015), AOM_ICDF(25039), AOM_ICDF(27726), AOM_ICDF(29932),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(32383), AOM_ICDF(32482), AOM_ICDF(32554), AOM_ICDF(32660),
            AOM_ICDF(32768), 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(24319), AOM_ICDF(26299), AOM_ICDF(27486), AOM_ICDF(28600),
            AOM_ICDF(29804), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(7935), AOM_ICDF(18217), AOM_ICDF(21116), AOM_ICDF(25440),
            AOM_ICDF(28589), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(25016), AOM_ICDF(27105), AOM_ICDF(28698),
            AOM_ICDF(30399), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(19967), AOM_ICDF(24117), AOM_ICDF(26550), AOM_ICDF(28566),
            AOM_ICDF(30224), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(31359), AOM_ICDF(31607), AOM_ICDF(31775), AOM_ICDF(31977),
            AOM_ICDF(32258), AOM_ICDF(32768), 0, 0, 0 },
      },
      {
          { AOM_ICDF(26368), AOM_ICDF(27768), AOM_ICDF(28588), AOM_ICDF(29274),
            AOM_ICDF(29997), AOM_ICDF(30917), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(8960), AOM_ICDF(18260), AOM_ICDF(20810), AOM_ICDF(23986),
            AOM_ICDF(26627), AOM_ICDF(28882), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(7295), AOM_ICDF(24111), AOM_ICDF(25836), AOM_ICDF(27515),
            AOM_ICDF(29033), AOM_ICDF(30769), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(22016), AOM_ICDF(25208), AOM_ICDF(27305), AOM_ICDF(28159),
            AOM_ICDF(29221), AOM_ICDF(30274), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31932), AOM_ICDF(32050), AOM_ICDF(32199),
            AOM_ICDF(32335), AOM_ICDF(32521), AOM_ICDF(32768), 0, 0 },
      },
      {
          { AOM_ICDF(26624), AOM_ICDF(27872), AOM_ICDF(28599), AOM_ICDF(29153),
            AOM_ICDF(29633), AOM_ICDF(30172), AOM_ICDF(30841), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(6655), AOM_ICDF(17569), AOM_ICDF(19587), AOM_ICDF(23345),
            AOM_ICDF(25884), AOM_ICDF(28088), AOM_ICDF(29678), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(3584), AOM_ICDF(27296), AOM_ICDF(28429), AOM_ICDF(29158),
            AOM_ICDF(30032), AOM_ICDF(30780), AOM_ICDF(31572), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(23551), AOM_ICDF(25855), AOM_ICDF(27070), AOM_ICDF(27893),
            AOM_ICDF(28597), AOM_ICDF(29721), AOM_ICDF(30970), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(32128), AOM_ICDF(32173), AOM_ICDF(32245), AOM_ICDF(32337),
            AOM_ICDF(32416), AOM_ICDF(32500), AOM_ICDF(32609), AOM_ICDF(32768),
            0 },
      },
    };

const aom_cdf_prob default_palette_uv_color_index_cdf
    [PALETTE_SIZES][PALETTE_COLOR_INDEX_CONTEXTS][CDF_SIZE(PALETTE_COLORS)] = {
      {
          { AOM_ICDF(29824), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(16384), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(8832), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(30720), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(27648), AOM_ICDF(30208), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(14080), AOM_ICDF(26563), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(5120), AOM_ICDF(30932), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(24448), AOM_ICDF(27828), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(31616), AOM_ICDF(32219), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
      },
      {
          { AOM_ICDF(25856), AOM_ICDF(28259), AOM_ICDF(30584), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(11520), AOM_ICDF(22476), AOM_ICDF(27944), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(8064), AOM_ICDF(26882), AOM_ICDF(30308), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(19455), AOM_ICDF(23823), AOM_ICDF(29134), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(30848), AOM_ICDF(31501), AOM_ICDF(32174), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(26751), AOM_ICDF(28020), AOM_ICDF(29541), AOM_ICDF(31230),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(12032), AOM_ICDF(26045), AOM_ICDF(30772), AOM_ICDF(31497),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(1280), AOM_ICDF(32153), AOM_ICDF(32458), AOM_ICDF(32560),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(23424), AOM_ICDF(24154), AOM_ICDF(29201), AOM_ICDF(29856),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(32256), AOM_ICDF(32402), AOM_ICDF(32561), AOM_ICDF(32682),
            AOM_ICDF(32768), 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(24576), AOM_ICDF(26720), AOM_ICDF(28114), AOM_ICDF(28950),
            AOM_ICDF(31694), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(7551), AOM_ICDF(16613), AOM_ICDF(20462), AOM_ICDF(25269),
            AOM_ICDF(29077), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(6272), AOM_ICDF(23039), AOM_ICDF(25623), AOM_ICDF(28163),
            AOM_ICDF(30861), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(17024), AOM_ICDF(18808), AOM_ICDF(20771), AOM_ICDF(27941),
            AOM_ICDF(29845), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(31616), AOM_ICDF(31936), AOM_ICDF(32079), AOM_ICDF(32321),
            AOM_ICDF(32546), AOM_ICDF(32768), 0, 0, 0 },
      },
      {
          { AOM_ICDF(23296), AOM_ICDF(25590), AOM_ICDF(27833), AOM_ICDF(29337),
            AOM_ICDF(29954), AOM_ICDF(31229), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(7552), AOM_ICDF(13659), AOM_ICDF(16570), AOM_ICDF(21695),
            AOM_ICDF(24506), AOM_ICDF(27701), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(6911), AOM_ICDF(24788), AOM_ICDF(26284), AOM_ICDF(27753),
            AOM_ICDF(29575), AOM_ICDF(30872), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(17535), AOM_ICDF(22236), AOM_ICDF(24457), AOM_ICDF(26242),
            AOM_ICDF(27363), AOM_ICDF(30191), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(30592), AOM_ICDF(31289), AOM_ICDF(31745), AOM_ICDF(31921),
            AOM_ICDF(32149), AOM_ICDF(32321), AOM_ICDF(32768), 0, 0 },
      },
      {
          { AOM_ICDF(22016), AOM_ICDF(24242), AOM_ICDF(25141), AOM_ICDF(27137),
            AOM_ICDF(27797), AOM_ICDF(29331), AOM_ICDF(30848), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(8063), AOM_ICDF(13564), AOM_ICDF(16940), AOM_ICDF(21948),
            AOM_ICDF(24568), AOM_ICDF(25689), AOM_ICDF(26989), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(6528), AOM_ICDF(27028), AOM_ICDF(27835), AOM_ICDF(28741),
            AOM_ICDF(30031), AOM_ICDF(31795), AOM_ICDF(32285), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(18047), AOM_ICDF(23797), AOM_ICDF(25444), AOM_ICDF(26274),
            AOM_ICDF(27111), AOM_ICDF(27929), AOM_ICDF(30367), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(30208), AOM_ICDF(30628), AOM_ICDF(31046), AOM_ICDF(31658),
            AOM_ICDF(31762), AOM_ICDF(32367), AOM_ICDF(32469), AOM_ICDF(32768),
            0 },
      }
    };
#if CONFIG_MRC_TX
// TODO(sarahparker) Tune these cdfs
const aom_cdf_prob default_mrc_mask_intra_cdf
    [PALETTE_SIZES][PALETTE_COLOR_INDEX_CONTEXTS][CDF_SIZE(PALETTE_COLORS)] = {
      {
          { AOM_ICDF(29568), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(16384), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(8832), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(28672), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(31872), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(28032), AOM_ICDF(30326), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(11647), AOM_ICDF(27405), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(4352), AOM_ICDF(30659), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(23552), AOM_ICDF(27800), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(32256), AOM_ICDF(32504), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
      },
      {
          { AOM_ICDF(26112), AOM_ICDF(28374), AOM_ICDF(30039), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(9472), AOM_ICDF(22576), AOM_ICDF(27712), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(26138), AOM_ICDF(29608), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(19328), AOM_ICDF(23791), AOM_ICDF(28946), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31984), AOM_ICDF(32336), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(27904), AOM_ICDF(29215), AOM_ICDF(30075), AOM_ICDF(31190),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(9728), AOM_ICDF(22598), AOM_ICDF(26134), AOM_ICDF(29425),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(2688), AOM_ICDF(30066), AOM_ICDF(31058), AOM_ICDF(31933),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(22015), AOM_ICDF(25039), AOM_ICDF(27726), AOM_ICDF(29932),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(32383), AOM_ICDF(32482), AOM_ICDF(32554), AOM_ICDF(32660),
            AOM_ICDF(32768), 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(24319), AOM_ICDF(26299), AOM_ICDF(27486), AOM_ICDF(28600),
            AOM_ICDF(29804), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(7935), AOM_ICDF(18217), AOM_ICDF(21116), AOM_ICDF(25440),
            AOM_ICDF(28589), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(25016), AOM_ICDF(27105), AOM_ICDF(28698),
            AOM_ICDF(30399), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(19967), AOM_ICDF(24117), AOM_ICDF(26550), AOM_ICDF(28566),
            AOM_ICDF(30224), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(31359), AOM_ICDF(31607), AOM_ICDF(31775), AOM_ICDF(31977),
            AOM_ICDF(32258), AOM_ICDF(32768), 0, 0, 0 },
      },
      {
          { AOM_ICDF(26368), AOM_ICDF(27768), AOM_ICDF(28588), AOM_ICDF(29274),
            AOM_ICDF(29997), AOM_ICDF(30917), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(8960), AOM_ICDF(18260), AOM_ICDF(20810), AOM_ICDF(23986),
            AOM_ICDF(26627), AOM_ICDF(28882), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(7295), AOM_ICDF(24111), AOM_ICDF(25836), AOM_ICDF(27515),
            AOM_ICDF(29033), AOM_ICDF(30769), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(22016), AOM_ICDF(25208), AOM_ICDF(27305), AOM_ICDF(28159),
            AOM_ICDF(29221), AOM_ICDF(30274), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31932), AOM_ICDF(32050), AOM_ICDF(32199),
            AOM_ICDF(32335), AOM_ICDF(32521), AOM_ICDF(32768), 0, 0 },
      },
      {
          { AOM_ICDF(26624), AOM_ICDF(27872), AOM_ICDF(28599), AOM_ICDF(29153),
            AOM_ICDF(29633), AOM_ICDF(30172), AOM_ICDF(30841), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(6655), AOM_ICDF(17569), AOM_ICDF(19587), AOM_ICDF(23345),
            AOM_ICDF(25884), AOM_ICDF(28088), AOM_ICDF(29678), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(3584), AOM_ICDF(27296), AOM_ICDF(28429), AOM_ICDF(29158),
            AOM_ICDF(30032), AOM_ICDF(30780), AOM_ICDF(31572), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(23551), AOM_ICDF(25855), AOM_ICDF(27070), AOM_ICDF(27893),
            AOM_ICDF(28597), AOM_ICDF(29721), AOM_ICDF(30970), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(32128), AOM_ICDF(32173), AOM_ICDF(32245), AOM_ICDF(32337),
            AOM_ICDF(32416), AOM_ICDF(32500), AOM_ICDF(32609), AOM_ICDF(32768),
            0 },
      },
    };

const aom_cdf_prob default_mrc_mask_inter_cdf
    [PALETTE_SIZES][PALETTE_COLOR_INDEX_CONTEXTS][CDF_SIZE(PALETTE_COLORS)] = {
      {
          { AOM_ICDF(29568), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(16384), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(8832), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(28672), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
          { AOM_ICDF(31872), AOM_ICDF(32768), 0, 0, 0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(28032), AOM_ICDF(30326), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(11647), AOM_ICDF(27405), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(4352), AOM_ICDF(30659), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(23552), AOM_ICDF(27800), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
          { AOM_ICDF(32256), AOM_ICDF(32504), AOM_ICDF(32768), 0, 0, 0, 0, 0,
            0 },
      },
      {
          { AOM_ICDF(26112), AOM_ICDF(28374), AOM_ICDF(30039), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(9472), AOM_ICDF(22576), AOM_ICDF(27712), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(26138), AOM_ICDF(29608), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(19328), AOM_ICDF(23791), AOM_ICDF(28946), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31984), AOM_ICDF(32336), AOM_ICDF(32768),
            0, 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(27904), AOM_ICDF(29215), AOM_ICDF(30075), AOM_ICDF(31190),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(9728), AOM_ICDF(22598), AOM_ICDF(26134), AOM_ICDF(29425),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(2688), AOM_ICDF(30066), AOM_ICDF(31058), AOM_ICDF(31933),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(22015), AOM_ICDF(25039), AOM_ICDF(27726), AOM_ICDF(29932),
            AOM_ICDF(32768), 0, 0, 0, 0 },
          { AOM_ICDF(32383), AOM_ICDF(32482), AOM_ICDF(32554), AOM_ICDF(32660),
            AOM_ICDF(32768), 0, 0, 0, 0 },
      },
      {
          { AOM_ICDF(24319), AOM_ICDF(26299), AOM_ICDF(27486), AOM_ICDF(28600),
            AOM_ICDF(29804), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(7935), AOM_ICDF(18217), AOM_ICDF(21116), AOM_ICDF(25440),
            AOM_ICDF(28589), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(6656), AOM_ICDF(25016), AOM_ICDF(27105), AOM_ICDF(28698),
            AOM_ICDF(30399), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(19967), AOM_ICDF(24117), AOM_ICDF(26550), AOM_ICDF(28566),
            AOM_ICDF(30224), AOM_ICDF(32768), 0, 0, 0 },
          { AOM_ICDF(31359), AOM_ICDF(31607), AOM_ICDF(31775), AOM_ICDF(31977),
            AOM_ICDF(32258), AOM_ICDF(32768), 0, 0, 0 },
      },
      {
          { AOM_ICDF(26368), AOM_ICDF(27768), AOM_ICDF(28588), AOM_ICDF(29274),
            AOM_ICDF(29997), AOM_ICDF(30917), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(8960), AOM_ICDF(18260), AOM_ICDF(20810), AOM_ICDF(23986),
            AOM_ICDF(26627), AOM_ICDF(28882), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(7295), AOM_ICDF(24111), AOM_ICDF(25836), AOM_ICDF(27515),
            AOM_ICDF(29033), AOM_ICDF(30769), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(22016), AOM_ICDF(25208), AOM_ICDF(27305), AOM_ICDF(28159),
            AOM_ICDF(29221), AOM_ICDF(30274), AOM_ICDF(32768), 0, 0 },
          { AOM_ICDF(31744), AOM_ICDF(31932), AOM_ICDF(32050), AOM_ICDF(32199),
            AOM_ICDF(32335), AOM_ICDF(32521), AOM_ICDF(32768), 0, 0 },
      },
      {
          { AOM_ICDF(26624), AOM_ICDF(27872), AOM_ICDF(28599), AOM_ICDF(29153),
            AOM_ICDF(29633), AOM_ICDF(30172), AOM_ICDF(30841), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(6655), AOM_ICDF(17569), AOM_ICDF(19587), AOM_ICDF(23345),
            AOM_ICDF(25884), AOM_ICDF(28088), AOM_ICDF(29678), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(3584), AOM_ICDF(27296), AOM_ICDF(28429), AOM_ICDF(29158),
            AOM_ICDF(30032), AOM_ICDF(30780), AOM_ICDF(31572), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(23551), AOM_ICDF(25855), AOM_ICDF(27070), AOM_ICDF(27893),
            AOM_ICDF(28597), AOM_ICDF(29721), AOM_ICDF(30970), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(32128), AOM_ICDF(32173), AOM_ICDF(32245), AOM_ICDF(32337),
            AOM_ICDF(32416), AOM_ICDF(32500), AOM_ICDF(32609), AOM_ICDF(32768),
            0 },
      },
    };
#endif  // CONFIG_MRC_TX

#if CONFIG_INTRABC
static const aom_cdf_prob default_intrabc_cdf[CDF_SIZE(2)] = {
  AOM_ICDF(192 * 128), AOM_ICDF(32768), 0,
};
#endif  // CONFIG_INTRABC

#define MAX_COLOR_CONTEXT_HASH 8
// Negative values are invalid
static const int palette_color_index_context_lookup[MAX_COLOR_CONTEXT_HASH +
                                                    1] = { -1, -1, 0, -1, -1,
                                                           4,  3,  2, 1 };

#if CONFIG_RECT_TX_EXT && (CONFIG_EXT_TX || CONFIG_VAR_TX)
static const aom_prob default_quarter_tx_size_prob = 192;
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob default_quarter_tx_size_cdf[CDF_SIZE(2)] = {
  AOM_ICDF(192 * 128), AOM_ICDF(32768), 0
};
#endif
#endif

#if CONFIG_LOOP_RESTORATION
const aom_tree_index
    av1_switchable_restore_tree[TREE_SIZE(RESTORE_SWITCHABLE_TYPES)] = {
      -RESTORE_NONE, 2, -RESTORE_WIENER, -RESTORE_SGRPROJ,
    };

static const aom_prob
    default_switchable_restore_prob[RESTORE_SWITCHABLE_TYPES - 1] = {
      32, 128,
    };
#endif  // CONFIG_LOOP_RESTORATION

#define NUM_PALETTE_NEIGHBORS 3  // left, top-left and top.
int av1_get_palette_color_index_context(const uint8_t *color_map, int stride,
                                        int r, int c, int palette_size,
                                        uint8_t *color_order, int *color_idx) {
  int i;
  // The +10 below should not be needed. But we get a warning "array subscript
  // is above array bounds [-Werror=array-bounds]" without it, possibly due to
  // this (or similar) bug: https://gcc.gnu.org/bugzilla/show_bug.cgi?id=59124
  int scores[PALETTE_MAX_SIZE + 10];
  const int weights[NUM_PALETTE_NEIGHBORS] = { 2, 1, 2 };
  const int hash_multipliers[NUM_PALETTE_NEIGHBORS] = { 1, 2, 2 };
  int color_index_ctx_hash;
  int color_index_ctx;
  int color_neighbors[NUM_PALETTE_NEIGHBORS];
  int inverse_color_order[PALETTE_MAX_SIZE];
  assert(palette_size <= PALETTE_MAX_SIZE);
  assert(r > 0 || c > 0);

  // Get color indices of neighbors.
  color_neighbors[0] = (c - 1 >= 0) ? color_map[r * stride + c - 1] : -1;
  color_neighbors[1] =
      (c - 1 >= 0 && r - 1 >= 0) ? color_map[(r - 1) * stride + c - 1] : -1;
  color_neighbors[2] = (r - 1 >= 0) ? color_map[(r - 1) * stride + c] : -1;

  for (i = 0; i < PALETTE_MAX_SIZE; ++i) {
    color_order[i] = i;
    inverse_color_order[i] = i;
  }
  memset(scores, 0, PALETTE_MAX_SIZE * sizeof(scores[0]));
  for (i = 0; i < NUM_PALETTE_NEIGHBORS; ++i) {
    if (color_neighbors[i] >= 0) {
      scores[color_neighbors[i]] += weights[i];
    }
  }

  // Get the top NUM_PALETTE_NEIGHBORS scores (sorted from large to small).
  for (i = 0; i < NUM_PALETTE_NEIGHBORS; ++i) {
    int max = scores[i];
    int max_idx = i;
    int j;
    for (j = i + 1; j < palette_size; ++j) {
      if (scores[j] > max) {
        max = scores[j];
        max_idx = j;
      }
    }
    if (max_idx != i) {
      // Move the score at index 'max_idx' to index 'i', and shift the scores
      // from 'i' to 'max_idx - 1' by 1.
      const int max_score = scores[max_idx];
      const uint8_t max_color_order = color_order[max_idx];
      int k;
      for (k = max_idx; k > i; --k) {
        scores[k] = scores[k - 1];
        color_order[k] = color_order[k - 1];
        inverse_color_order[color_order[k]] = k;
      }
      scores[i] = max_score;
      color_order[i] = max_color_order;
      inverse_color_order[color_order[i]] = i;
    }
  }

  // Get hash value of context.
  color_index_ctx_hash = 0;
  for (i = 0; i < NUM_PALETTE_NEIGHBORS; ++i) {
    color_index_ctx_hash += scores[i] * hash_multipliers[i];
  }
  assert(color_index_ctx_hash > 0);
  assert(color_index_ctx_hash <= MAX_COLOR_CONTEXT_HASH);

  // Lookup context from hash.
  color_index_ctx = palette_color_index_context_lookup[color_index_ctx_hash];
  assert(color_index_ctx >= 0);
  assert(color_index_ctx < PALETTE_COLOR_INDEX_CONTEXTS);

  if (color_idx != NULL) {
    *color_idx = inverse_color_order[color_map[r * stride + c]];
  }
  return color_index_ctx;
}
#undef NUM_PALETTE_NEIGHBORS
#undef MAX_COLOR_CONTEXT_HASH

#if CONFIG_VAR_TX
static const aom_prob default_txfm_partition_probs[TXFM_PARTITION_CONTEXTS] = {
#if CONFIG_TX64X64
  249, 240, 223, 249, 229, 177, 250, 243, 208, 226, 187,
  145, 236, 204, 150, 183, 149, 125, 181, 146, 113, 128
#else
  250, 231, 212, 241, 166, 66, 241, 230, 135, 243, 154, 64, 248, 161, 63, 128
#endif  // CONFIG_TX64X64
};
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_txfm_partition_cdf[TXFM_PARTITION_CONTEXTS][CDF_SIZE(2)] = {
#if CONFIG_TX64X64
      { AOM_ICDF(249 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(240 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(223 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(249 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(229 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(177 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(250 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(243 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(208 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(226 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(187 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(145 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(236 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(204 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(150 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(183 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(149 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(125 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(181 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(146 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(113 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 }
#else
      { AOM_ICDF(250 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(231 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(212 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(241 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(166 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(66 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(241 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(230 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(135 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(243 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(154 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(64 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(248 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(161 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(63 * 128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0 },
#endif  // CONFIG_TX64X64
    };
#endif  // CONFIG_NEW_MULTISYMBOL
#endif  // CONFIG_VAR_TX

static const aom_prob default_skip_probs[SKIP_CONTEXTS] = { 192, 128, 64 };
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob default_skip_cdfs[SKIP_CONTEXTS][CDF_SIZE(2)] = {
  { AOM_ICDF(24576), AOM_ICDF(32768), 0 },
  { AOM_ICDF(16384), AOM_ICDF(32768), 0 },
  { AOM_ICDF(8192), AOM_ICDF(32768), 0 }
};
#endif

#if CONFIG_LGT_FROM_PRED
static const aom_prob default_intra_lgt_prob[LGT_SIZES][INTRA_MODES] = {
  { 255, 208, 208, 180, 230, 208, 194, 214, 220, 255,
#if CONFIG_SMOOTH_HV
    220, 220,
#endif
    230 },
  { 255, 192, 216, 180, 180, 180, 180, 200, 200, 255,
#if CONFIG_SMOOTH_HV
    220, 220,
#endif
    222 },
};

static const aom_prob default_inter_lgt_prob[LGT_SIZES] = { 230, 230 };
#endif  // CONFIG_LGT_FROM_PRED

#if CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP
static const aom_prob
    default_intra_filter_probs[INTRA_FILTERS + 1][INTRA_FILTERS - 1] = {
      { 98, 63, 60 }, { 98, 82, 80 }, { 94, 65, 103 },
      { 49, 25, 24 }, { 72, 38, 50 },
    };
const aom_tree_index av1_intra_filter_tree[TREE_SIZE(INTRA_FILTERS)] = {
  -INTRA_FILTER_LINEAR,      2, -INTRA_FILTER_8TAP, 4, -INTRA_FILTER_8TAP_SHARP,
  -INTRA_FILTER_8TAP_SMOOTH,
};
int av1_intra_filter_ind[INTRA_FILTERS];
int av1_intra_filter_inv[INTRA_FILTERS];
#endif  // CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP

#if CONFIG_FILTER_INTRA
static const aom_prob default_filter_intra_probs[2] = { 230, 230 };
#endif  // CONFIG_FILTER_INTRA

#if CONFIG_SUPERTX
static const aom_prob
    default_supertx_prob[PARTITION_SUPERTX_CONTEXTS][TX_SIZES] = {
#if CONFIG_CHROMA_2X2
#if CONFIG_TX64X64
      { 1, 1, 160, 160, 170, 180 }, { 1, 1, 200, 200, 210, 220 },
#else
      { 1, 1, 160, 160, 170 }, { 1, 1, 200, 200, 210 },
#endif  // CONFIG_TX64X64
#else
#if CONFIG_TX64X64
      { 1, 160, 160, 170, 180 }, { 1, 200, 200, 210, 220 },
#else
      { 1, 160, 160, 170 }, { 1, 200, 200, 210 },
#endif  // CONFIG_TX64X64
#endif  // CONFIG_CHROMA_2X2
    };
#endif  // CONFIG_SUPERTX

// FIXME(someone) need real defaults here
static const aom_prob default_segment_tree_probs[SEG_TREE_PROBS] = {
  128, 128, 128, 128, 128, 128, 128
};
// clang-format off
static const aom_prob default_segment_pred_probs[PREDICTION_PROBS] = {
  128, 128, 128
};
#if CONFIG_NEW_MULTISYMBOL
static const aom_cdf_prob
    default_segment_pred_cdf[PREDICTION_PROBS][CDF_SIZE(2)] = {
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0},
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0},
  { AOM_ICDF(128 * 128), AOM_ICDF(32768), 0}
};
#endif
// clang-format on
#if CONFIG_DUAL_FILTER
#if USE_EXTRA_FILTER
static const aom_cdf_prob
    default_switchable_interp_cdf[SWITCHABLE_FILTER_CONTEXTS][CDF_SIZE(
        SWITCHABLE_FILTERS)] = {
      { AOM_ICDF(30080), AOM_ICDF(31088), AOM_ICDF(31760), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4608), AOM_ICDF(9620), AOM_ICDF(11050), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19072), AOM_ICDF(23352), AOM_ICDF(28488), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30080), AOM_ICDF(31088), AOM_ICDF(31760), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4608), AOM_ICDF(9620), AOM_ICDF(11050), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19072), AOM_ICDF(23352), AOM_ICDF(28488), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30080), AOM_ICDF(31088), AOM_ICDF(31760), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4608), AOM_ICDF(9620), AOM_ICDF(11050), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19072), AOM_ICDF(23352), AOM_ICDF(28488), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30080), AOM_ICDF(31088), AOM_ICDF(31760), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4608), AOM_ICDF(9620), AOM_ICDF(11050), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(5240), AOM_ICDF(31880), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19072), AOM_ICDF(23352), AOM_ICDF(28488), AOM_ICDF(32768), 0 },
    };
#else   // USE_EXTRA_FILTER
static const aom_cdf_prob
    default_switchable_interp_cdf[SWITCHABLE_FILTER_CONTEXTS][CDF_SIZE(
        SWITCHABLE_FILTERS)] = {
      { AOM_ICDF(32256), AOM_ICDF(32654), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2816), AOM_ICDF(32651), AOM_ICDF(32768), 0 },
      { AOM_ICDF(512), AOM_ICDF(764), AOM_ICDF(32768), 0 },
      { AOM_ICDF(30464), AOM_ICDF(31778), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32384), AOM_ICDF(32483), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3072), AOM_ICDF(32652), AOM_ICDF(32768), 0 },
      { AOM_ICDF(256), AOM_ICDF(383), AOM_ICDF(32768), 0 },
      { AOM_ICDF(25344), AOM_ICDF(26533), AOM_ICDF(32768), 0 },
      { AOM_ICDF(32000), AOM_ICDF(32531), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2048), AOM_ICDF(32648), AOM_ICDF(32768), 0 },
      { AOM_ICDF(384), AOM_ICDF(890), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28928), AOM_ICDF(31358), AOM_ICDF(32768), 0 },
      { AOM_ICDF(31616), AOM_ICDF(31787), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4224), AOM_ICDF(32433), AOM_ICDF(32768), 0 },
      { AOM_ICDF(128), AOM_ICDF(256), AOM_ICDF(32768), 0 },
      { AOM_ICDF(17408), AOM_ICDF(18248), AOM_ICDF(32768), 0 }
    };
#endif  // USE_EXTRA_FILTER
#else   // CONFIG_DUAL_FILTER
static const aom_cdf_prob
    default_switchable_interp_cdf[SWITCHABLE_FILTER_CONTEXTS][CDF_SIZE(
        SWITCHABLE_FILTERS)] = {
      { AOM_ICDF(30080), AOM_ICDF(31781), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4608), AOM_ICDF(32658), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4352), AOM_ICDF(4685), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19072), AOM_ICDF(26776), AOM_ICDF(32768), 0 },
    };
#endif  // CONFIG_DUAL_FILTER

static const aom_cdf_prob default_seg_tree_cdf[CDF_SIZE(MAX_SEGMENTS)] = {
  AOM_ICDF(4096),  AOM_ICDF(8192),  AOM_ICDF(12288),
  AOM_ICDF(16384), AOM_ICDF(20480), AOM_ICDF(24576),
  AOM_ICDF(28672), AOM_ICDF(32768), 0
};

static const aom_cdf_prob
    default_tx_size_cdf[MAX_TX_DEPTH][TX_SIZE_CONTEXTS][CDF_SIZE(MAX_TX_DEPTH +
                                                                 1)] = {
      { { AOM_ICDF(12800), AOM_ICDF(32768), 0 },
        { AOM_ICDF(8448), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(2560), AOM_ICDF(20496), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1920), AOM_ICDF(14091), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(384), AOM_ICDF(17588), AOM_ICDF(19782), AOM_ICDF(32768), 0 },
        { AOM_ICDF(640), AOM_ICDF(7166), AOM_ICDF(8466), AOM_ICDF(32768), 0 } },
#if CONFIG_TX64X64
      { { AOM_ICDF(128), AOM_ICDF(8288), AOM_ICDF(21293), AOM_ICDF(26986),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(128), AOM_ICDF(4208), AOM_ICDF(10009), AOM_ICDF(15965),
          AOM_ICDF(32768), 0 } },
#endif
    };

#if CONFIG_SMOOTH_HV
static const aom_cdf_prob
    default_if_y_mode_cdf[BLOCK_SIZE_GROUPS][CDF_SIZE(INTRA_MODES)] = {
      {
          AOM_ICDF(7168), AOM_ICDF(10680), AOM_ICDF(13913), AOM_ICDF(16928),
          AOM_ICDF(20294), AOM_ICDF(22790), AOM_ICDF(24706), AOM_ICDF(26275),
          AOM_ICDF(28139), AOM_ICDF(29751), AOM_ICDF(30563), AOM_ICDF(31468),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11776), AOM_ICDF(13823), AOM_ICDF(15307), AOM_ICDF(15725),
          AOM_ICDF(16638), AOM_ICDF(17406), AOM_ICDF(17994), AOM_ICDF(18814),
          AOM_ICDF(19634), AOM_ICDF(21513), AOM_ICDF(22198), AOM_ICDF(22928),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(14720), AOM_ICDF(16459), AOM_ICDF(18091), AOM_ICDF(18299),
          AOM_ICDF(18757), AOM_ICDF(19125), AOM_ICDF(19423), AOM_ICDF(19924),
          AOM_ICDF(20504), AOM_ICDF(22922), AOM_ICDF(24063), AOM_ICDF(25577),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(18944), AOM_ICDF(19925), AOM_ICDF(20908), AOM_ICDF(20998),
          AOM_ICDF(21017), AOM_ICDF(21072), AOM_ICDF(21084), AOM_ICDF(21121),
          AOM_ICDF(21159), AOM_ICDF(22064), AOM_ICDF(22820), AOM_ICDF(24290),
          AOM_ICDF(32768), 0,
      },
    };

#if CONFIG_CFL
static const aom_cdf_prob
    default_uv_mode_cdf[INTRA_MODES][CDF_SIZE(UV_INTRA_MODES)] = {
      { AOM_ICDF(18377), AOM_ICDF(18815), AOM_ICDF(19743), AOM_ICDF(20178),
        AOM_ICDF(20560), AOM_ICDF(20889), AOM_ICDF(21359), AOM_ICDF(22098),
        AOM_ICDF(22481), AOM_ICDF(24563), AOM_ICDF(25781), AOM_ICDF(26662),
        AOM_ICDF(28396), AOM_ICDF(32768), 0 },
      { AOM_ICDF(5350), AOM_ICDF(16837), AOM_ICDF(17066), AOM_ICDF(17360),
        AOM_ICDF(17692), AOM_ICDF(18778), AOM_ICDF(18969), AOM_ICDF(19206),
        AOM_ICDF(20291), AOM_ICDF(22367), AOM_ICDF(23212), AOM_ICDF(24670),
        AOM_ICDF(27912), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6671), AOM_ICDF(6759), AOM_ICDF(17812), AOM_ICDF(17998),
        AOM_ICDF(18260), AOM_ICDF(18384), AOM_ICDF(19408), AOM_ICDF(20667),
        AOM_ICDF(20806), AOM_ICDF(22760), AOM_ICDF(24142), AOM_ICDF(24875),
        AOM_ICDF(28072), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7461), AOM_ICDF(8082), AOM_ICDF(8515), AOM_ICDF(15013),
        AOM_ICDF(15583), AOM_ICDF(16098), AOM_ICDF(16522), AOM_ICDF(18519),
        AOM_ICDF(20348), AOM_ICDF(22954), AOM_ICDF(24130), AOM_ICDF(25342),
        AOM_ICDF(26548), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3694), AOM_ICDF(4403), AOM_ICDF(5370), AOM_ICDF(5854),
        AOM_ICDF(17841), AOM_ICDF(19639), AOM_ICDF(21625), AOM_ICDF(22224),
        AOM_ICDF(22651), AOM_ICDF(24613), AOM_ICDF(25399), AOM_ICDF(26143),
        AOM_ICDF(26599), AOM_ICDF(32768), 0 },
      { AOM_ICDF(3700), AOM_ICDF(5651), AOM_ICDF(6112), AOM_ICDF(6541),
        AOM_ICDF(8929), AOM_ICDF(20623), AOM_ICDF(21213), AOM_ICDF(21640),
        AOM_ICDF(22214), AOM_ICDF(24306), AOM_ICDF(25412), AOM_ICDF(26406),
        AOM_ICDF(27249), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4649), AOM_ICDF(4947), AOM_ICDF(7128), AOM_ICDF(7432),
        AOM_ICDF(9439), AOM_ICDF(9903), AOM_ICDF(21163), AOM_ICDF(21774),
        AOM_ICDF(22056), AOM_ICDF(24426), AOM_ICDF(25403), AOM_ICDF(26324),
        AOM_ICDF(27128), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7208), AOM_ICDF(7375), AOM_ICDF(8779), AOM_ICDF(9683),
        AOM_ICDF(10072), AOM_ICDF(10284), AOM_ICDF(10796), AOM_ICDF(19786),
        AOM_ICDF(20152), AOM_ICDF(22955), AOM_ICDF(24246), AOM_ICDF(25165),
        AOM_ICDF(26589), AOM_ICDF(32768), 0 },
      { AOM_ICDF(5897), AOM_ICDF(7283), AOM_ICDF(7555), AOM_ICDF(8910),
        AOM_ICDF(9391), AOM_ICDF(9937), AOM_ICDF(10276), AOM_ICDF(11044),
        AOM_ICDF(19841), AOM_ICDF(22620), AOM_ICDF(23784), AOM_ICDF(25060),
        AOM_ICDF(26418), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12171), AOM_ICDF(12718), AOM_ICDF(13885), AOM_ICDF(14348),
        AOM_ICDF(14925), AOM_ICDF(15394), AOM_ICDF(16108), AOM_ICDF(17075),
        AOM_ICDF(17583), AOM_ICDF(21996), AOM_ICDF(23614), AOM_ICDF(25048),
        AOM_ICDF(27011), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10192), AOM_ICDF(11222), AOM_ICDF(12318), AOM_ICDF(12877),
        AOM_ICDF(13533), AOM_ICDF(14184), AOM_ICDF(14866), AOM_ICDF(15879),
        AOM_ICDF(16650), AOM_ICDF(20419), AOM_ICDF(23265), AOM_ICDF(24295),
        AOM_ICDF(26596), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10776), AOM_ICDF(11387), AOM_ICDF(12899), AOM_ICDF(13471),
        AOM_ICDF(14088), AOM_ICDF(14575), AOM_ICDF(15366), AOM_ICDF(16456),
        AOM_ICDF(17040), AOM_ICDF(20815), AOM_ICDF(22009), AOM_ICDF(24448),
        AOM_ICDF(26492), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4015), AOM_ICDF(6473), AOM_ICDF(9853), AOM_ICDF(10285),
        AOM_ICDF(10655), AOM_ICDF(11032), AOM_ICDF(11431), AOM_ICDF(12199),
        AOM_ICDF(12738), AOM_ICDF(14760), AOM_ICDF(16121), AOM_ICDF(17263),
        AOM_ICDF(28612), AOM_ICDF(32768), 0 },
    };
#else
static const aom_cdf_prob
    default_uv_mode_cdf[INTRA_MODES][CDF_SIZE(UV_INTRA_MODES)] = {
      {
          AOM_ICDF(23552), AOM_ICDF(25936), AOM_ICDF(28623), AOM_ICDF(29033),
          AOM_ICDF(29395), AOM_ICDF(29892), AOM_ICDF(30252), AOM_ICDF(30905),
          AOM_ICDF(31370), AOM_ICDF(31980), AOM_ICDF(32293), AOM_ICDF(32660),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2944), AOM_ICDF(26431), AOM_ICDF(27553), AOM_ICDF(27746),
          AOM_ICDF(28022), AOM_ICDF(29080), AOM_ICDF(29204), AOM_ICDF(29377),
          AOM_ICDF(30264), AOM_ICDF(31206), AOM_ICDF(31613), AOM_ICDF(32418),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4352), AOM_ICDF(5120), AOM_ICDF(27952), AOM_ICDF(28117),
          AOM_ICDF(28473), AOM_ICDF(28759), AOM_ICDF(29563), AOM_ICDF(30864),
          AOM_ICDF(31051), AOM_ICDF(31694), AOM_ICDF(32073), AOM_ICDF(32435),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(17664), AOM_ICDF(20288), AOM_ICDF(21839), AOM_ICDF(26072),
          AOM_ICDF(26420), AOM_ICDF(26972), AOM_ICDF(27240), AOM_ICDF(28565),
          AOM_ICDF(30914), AOM_ICDF(31694), AOM_ICDF(32083), AOM_ICDF(32591),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(16640), AOM_ICDF(18390), AOM_ICDF(20233), AOM_ICDF(20557),
          AOM_ICDF(25162), AOM_ICDF(27789), AOM_ICDF(29397), AOM_ICDF(29895),
          AOM_ICDF(30369), AOM_ICDF(31497), AOM_ICDF(32025), AOM_ICDF(32642),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(13952), AOM_ICDF(17947), AOM_ICDF(18918), AOM_ICDF(19206),
          AOM_ICDF(21131), AOM_ICDF(30668), AOM_ICDF(31061), AOM_ICDF(31317),
          AOM_ICDF(31838), AOM_ICDF(32137), AOM_ICDF(32342), AOM_ICDF(32547),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(15872), AOM_ICDF(16990), AOM_ICDF(21479), AOM_ICDF(21732),
          AOM_ICDF(24134), AOM_ICDF(24854), AOM_ICDF(30296), AOM_ICDF(30887),
          AOM_ICDF(31163), AOM_ICDF(31902), AOM_ICDF(32218), AOM_ICDF(32702),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(16256), AOM_ICDF(17280), AOM_ICDF(23081), AOM_ICDF(24039),
          AOM_ICDF(24457), AOM_ICDF(24838), AOM_ICDF(25346), AOM_ICDF(30329),
          AOM_ICDF(30908), AOM_ICDF(31746), AOM_ICDF(32206), AOM_ICDF(32639),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(14720), AOM_ICDF(19249), AOM_ICDF(20501), AOM_ICDF(22079),
          AOM_ICDF(22439), AOM_ICDF(23218), AOM_ICDF(23463), AOM_ICDF(24107),
          AOM_ICDF(30308), AOM_ICDF(31379), AOM_ICDF(31866), AOM_ICDF(32556),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(16768), AOM_ICDF(19967), AOM_ICDF(22374), AOM_ICDF(22976),
          AOM_ICDF(23836), AOM_ICDF(24050), AOM_ICDF(24642), AOM_ICDF(25760),
          AOM_ICDF(26653), AOM_ICDF(29585), AOM_ICDF(30937), AOM_ICDF(32518),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(16768), AOM_ICDF(20751), AOM_ICDF(23026), AOM_ICDF(23591),
          AOM_ICDF(24299), AOM_ICDF(24516), AOM_ICDF(24981), AOM_ICDF(25876),
          AOM_ICDF(26806), AOM_ICDF(29520), AOM_ICDF(31286), AOM_ICDF(32455),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(17536), AOM_ICDF(20055), AOM_ICDF(22965), AOM_ICDF(23507),
          AOM_ICDF(24210), AOM_ICDF(24398), AOM_ICDF(25098), AOM_ICDF(26366),
          AOM_ICDF(27033), AOM_ICDF(29674), AOM_ICDF(30689), AOM_ICDF(32530),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(17536), AOM_ICDF(22753), AOM_ICDF(27126), AOM_ICDF(27353),
          AOM_ICDF(27571), AOM_ICDF(28139), AOM_ICDF(28505), AOM_ICDF(29198),
          AOM_ICDF(29886), AOM_ICDF(30801), AOM_ICDF(31335), AOM_ICDF(32054),
          AOM_ICDF(32768), 0,
      },
    };
#endif  // CONFIG_CFL
#else   // !CONFIG_SMOOTH_HV
static const aom_cdf_prob
    default_if_y_mode_cdf[BLOCK_SIZE_GROUPS][CDF_SIZE(INTRA_MODES)] = {
      {
          AOM_ICDF(11264), AOM_ICDF(14965), AOM_ICDF(19742), AOM_ICDF(21904),
          AOM_ICDF(24115), AOM_ICDF(25678), AOM_ICDF(27210), AOM_ICDF(28705),
          AOM_ICDF(29782), AOM_ICDF(31424), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(13747), AOM_ICDF(18569), AOM_ICDF(20091),
          AOM_ICDF(21925), AOM_ICDF(23082), AOM_ICDF(24404), AOM_ICDF(26285),
          AOM_ICDF(27574), AOM_ICDF(30415), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9344), AOM_ICDF(14319), AOM_ICDF(19567), AOM_ICDF(20476),
          AOM_ICDF(21791), AOM_ICDF(22529), AOM_ICDF(23393), AOM_ICDF(24881),
          AOM_ICDF(26012), AOM_ICDF(30572), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12288), AOM_ICDF(15866), AOM_ICDF(21186), AOM_ICDF(21722),
          AOM_ICDF(22209), AOM_ICDF(22564), AOM_ICDF(22966), AOM_ICDF(24025),
          AOM_ICDF(24716), AOM_ICDF(30608), AOM_ICDF(32768), 0,
      },
    };

static const aom_cdf_prob
    default_uv_mode_cdf[INTRA_MODES][CDF_SIZE(UV_INTRA_MODES)] = {
      {
          AOM_ICDF(25472), AOM_ICDF(27697), AOM_ICDF(30693), AOM_ICDF(30916),
          AOM_ICDF(31125), AOM_ICDF(31406), AOM_ICDF(31679), AOM_ICDF(32085),
          AOM_ICDF(32334), AOM_ICDF(32682), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2176), AOM_ICDF(28142), AOM_ICDF(29335), AOM_ICDF(29504),
          AOM_ICDF(29762), AOM_ICDF(30642), AOM_ICDF(30741), AOM_ICDF(30902),
          AOM_ICDF(31683), AOM_ICDF(32529), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3328), AOM_ICDF(3901), AOM_ICDF(30984), AOM_ICDF(31068),
          AOM_ICDF(31241), AOM_ICDF(31389), AOM_ICDF(31697), AOM_ICDF(32379),
          AOM_ICDF(32483), AOM_ICDF(32653), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(23424), AOM_ICDF(25805), AOM_ICDF(27721), AOM_ICDF(29432),
          AOM_ICDF(29659), AOM_ICDF(30032), AOM_ICDF(30282), AOM_ICDF(31192),
          AOM_ICDF(32259), AOM_ICDF(32658), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(22784), AOM_ICDF(24177), AOM_ICDF(26209), AOM_ICDF(26476),
          AOM_ICDF(28679), AOM_ICDF(29698), AOM_ICDF(30786), AOM_ICDF(31257),
          AOM_ICDF(31596), AOM_ICDF(32690), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(19712), AOM_ICDF(22988), AOM_ICDF(24275), AOM_ICDF(24520),
          AOM_ICDF(25823), AOM_ICDF(31469), AOM_ICDF(31880), AOM_ICDF(32189),
          AOM_ICDF(32614), AOM_ICDF(32615), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(21376), AOM_ICDF(22085), AOM_ICDF(27643), AOM_ICDF(27799),
          AOM_ICDF(28596), AOM_ICDF(28890), AOM_ICDF(31767), AOM_ICDF(32255),
          AOM_ICDF(32405), AOM_ICDF(32723), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(19712), AOM_ICDF(20623), AOM_ICDF(28408), AOM_ICDF(28766),
          AOM_ICDF(29070), AOM_ICDF(29355), AOM_ICDF(29759), AOM_ICDF(32034),
          AOM_ICDF(32306), AOM_ICDF(32666), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(19584), AOM_ICDF(23437), AOM_ICDF(25295), AOM_ICDF(26200),
          AOM_ICDF(26612), AOM_ICDF(27372), AOM_ICDF(27704), AOM_ICDF(28319),
          AOM_ICDF(31664), AOM_ICDF(32562), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(20864), AOM_ICDF(23989), AOM_ICDF(26168), AOM_ICDF(26591),
          AOM_ICDF(27345), AOM_ICDF(27348), AOM_ICDF(27809), AOM_ICDF(28575),
          AOM_ICDF(29132), AOM_ICDF(32628), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(23680), AOM_ICDF(27582), AOM_ICDF(30197), AOM_ICDF(30312),
          AOM_ICDF(30464), AOM_ICDF(30995), AOM_ICDF(31208), AOM_ICDF(31574),
          AOM_ICDF(31985), AOM_ICDF(32519), AOM_ICDF(32768), 0,
      },
    };
#endif  // CONFIG_SMOOTH_HV

#if CONFIG_EXT_PARTITION_TYPES
static const aom_cdf_prob
    default_partition_cdf[PARTITION_CONTEXTS][CDF_SIZE(EXT_PARTITION_TYPES)] = {
      // 8x8 -> 4x4 only supports the four legacy partition types
      { AOM_ICDF(25472), AOM_ICDF(28949), AOM_ICDF(31052), AOM_ICDF(32768), 0,
        0, 0, 0, 0, 0, 0 },
      { AOM_ICDF(18816), AOM_ICDF(22250), AOM_ICDF(28783), AOM_ICDF(32768), 0,
        0, 0, 0, 0, 0, 0 },
      { AOM_ICDF(18944), AOM_ICDF(26126), AOM_ICDF(29188), AOM_ICDF(32768), 0,
        0, 0, 0, 0, 0, 0 },
      { AOM_ICDF(15488), AOM_ICDF(22508), AOM_ICDF(27077), AOM_ICDF(32768), 0,
        0, 0, 0, 0, 0, 0 },
      // 16x16 -> 8x8
      { AOM_ICDF(22272), AOM_ICDF(23768), AOM_ICDF(25043), AOM_ICDF(29996),
        AOM_ICDF(30495), AOM_ICDF(30994), AOM_ICDF(31419), AOM_ICDF(31844),
        AOM_ICDF(32343), AOM_ICDF(32768), 0 },
      { AOM_ICDF(11776), AOM_ICDF(13457), AOM_ICDF(16315), AOM_ICDF(28229),
        AOM_ICDF(28789), AOM_ICDF(29349), AOM_ICDF(30302), AOM_ICDF(31255),
        AOM_ICDF(31816), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10496), AOM_ICDF(14802), AOM_ICDF(16136), AOM_ICDF(27127),
        AOM_ICDF(28563), AOM_ICDF(29999), AOM_ICDF(30444), AOM_ICDF(30889),
        AOM_ICDF(32324), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6784), AOM_ICDF(8763), AOM_ICDF(10440), AOM_ICDF(29110),
        AOM_ICDF(29770), AOM_ICDF(30430), AOM_ICDF(30989), AOM_ICDF(31548),
        AOM_ICDF(32208), AOM_ICDF(32768), 0 },
      // 32x32 -> 16x16
      { AOM_ICDF(22656), AOM_ICDF(23801), AOM_ICDF(24702), AOM_ICDF(30721),
        AOM_ICDF(31103), AOM_ICDF(31485), AOM_ICDF(31785), AOM_ICDF(32085),
        AOM_ICDF(32467), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8704), AOM_ICDF(9926), AOM_ICDF(12586), AOM_ICDF(28885),
        AOM_ICDF(29292), AOM_ICDF(29699), AOM_ICDF(30586), AOM_ICDF(31473),
        AOM_ICDF(31881), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6656), AOM_ICDF(10685), AOM_ICDF(11566), AOM_ICDF(27857),
        AOM_ICDF(29200), AOM_ICDF(30543), AOM_ICDF(30837), AOM_ICDF(31131),
        AOM_ICDF(32474), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2176), AOM_ICDF(3012), AOM_ICDF(3690), AOM_ICDF(31253),
        AOM_ICDF(31532), AOM_ICDF(31811), AOM_ICDF(32037), AOM_ICDF(32263),
        AOM_ICDF(32542), AOM_ICDF(32768), 0 },
      // 64x64 -> 32x32
      { AOM_ICDF(28416), AOM_ICDF(28705), AOM_ICDF(28926), AOM_ICDF(32258),
        AOM_ICDF(32354), AOM_ICDF(32450), AOM_ICDF(32523), AOM_ICDF(32596),
        AOM_ICDF(32693), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(9952), AOM_ICDF(11849), AOM_ICDF(30134),
        AOM_ICDF(30379), AOM_ICDF(30624), AOM_ICDF(31256), AOM_ICDF(31888),
        AOM_ICDF(32134), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7424), AOM_ICDF(9008), AOM_ICDF(9528), AOM_ICDF(30664),
        AOM_ICDF(31192), AOM_ICDF(31720), AOM_ICDF(31893), AOM_ICDF(32066),
        AOM_ICDF(32594), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1280), AOM_ICDF(1710), AOM_ICDF(2069), AOM_ICDF(31978),
        AOM_ICDF(32121), AOM_ICDF(32264), AOM_ICDF(32383), AOM_ICDF(32502),
        AOM_ICDF(32647), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      // 128x128 -> 64x64
      { AOM_ICDF(28416), AOM_ICDF(28705), AOM_ICDF(28926), AOM_ICDF(32258),
        AOM_ICDF(32354), AOM_ICDF(32450), AOM_ICDF(32523), AOM_ICDF(32596),
        AOM_ICDF(32693), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(9952), AOM_ICDF(11849), AOM_ICDF(30134),
        AOM_ICDF(30379), AOM_ICDF(30624), AOM_ICDF(31256), AOM_ICDF(31888),
        AOM_ICDF(32134), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7424), AOM_ICDF(9008), AOM_ICDF(9528), AOM_ICDF(30664),
        AOM_ICDF(31192), AOM_ICDF(31720), AOM_ICDF(31893), AOM_ICDF(32066),
        AOM_ICDF(32594), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1280), AOM_ICDF(1710), AOM_ICDF(2069), AOM_ICDF(31978),
        AOM_ICDF(32121), AOM_ICDF(32264), AOM_ICDF(32383), AOM_ICDF(32502),
        AOM_ICDF(32647), AOM_ICDF(32768), 0 },
#endif
    };
#else
static const aom_cdf_prob
    default_partition_cdf[PARTITION_CONTEXTS][CDF_SIZE(PARTITION_TYPES)] = {
      { AOM_ICDF(25472), AOM_ICDF(28949), AOM_ICDF(31052), AOM_ICDF(32768), 0 },
      { AOM_ICDF(18816), AOM_ICDF(22250), AOM_ICDF(28783), AOM_ICDF(32768), 0 },
      { AOM_ICDF(18944), AOM_ICDF(26126), AOM_ICDF(29188), AOM_ICDF(32768), 0 },
      { AOM_ICDF(15488), AOM_ICDF(22508), AOM_ICDF(27077), AOM_ICDF(32768), 0 },
      { AOM_ICDF(22272), AOM_ICDF(25265), AOM_ICDF(27815), AOM_ICDF(32768), 0 },
      { AOM_ICDF(11776), AOM_ICDF(15138), AOM_ICDF(20854), AOM_ICDF(32768), 0 },
      { AOM_ICDF(10496), AOM_ICDF(19109), AOM_ICDF(21777), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6784), AOM_ICDF(10743), AOM_ICDF(14098), AOM_ICDF(32768), 0 },
      { AOM_ICDF(22656), AOM_ICDF(24947), AOM_ICDF(26749), AOM_ICDF(32768), 0 },
      { AOM_ICDF(8704), AOM_ICDF(11148), AOM_ICDF(16469), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6656), AOM_ICDF(14714), AOM_ICDF(16477), AOM_ICDF(32768), 0 },
      { AOM_ICDF(2176), AOM_ICDF(3849), AOM_ICDF(5205), AOM_ICDF(32768), 0 },
      { AOM_ICDF(28416), AOM_ICDF(28994), AOM_ICDF(29436), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(10688), AOM_ICDF(14483), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7424), AOM_ICDF(10592), AOM_ICDF(11632), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1280), AOM_ICDF(2141), AOM_ICDF(2859), AOM_ICDF(32768), 0 },
#if CONFIG_EXT_PARTITION
      { AOM_ICDF(28416), AOM_ICDF(28994), AOM_ICDF(29436), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(10688), AOM_ICDF(14483), AOM_ICDF(32768), 0 },
      { AOM_ICDF(7424), AOM_ICDF(10592), AOM_ICDF(11632), AOM_ICDF(32768), 0 },
      { AOM_ICDF(1280), AOM_ICDF(2141), AOM_ICDF(2859), AOM_ICDF(32768), 0 },
#endif
    };
#endif

#if CONFIG_EXT_TX
static const aom_cdf_prob default_intra_ext_tx_cdf
    [EXT_TX_SETS_INTRA][EXT_TX_SIZES][INTRA_MODES][CDF_SIZE(TX_TYPES)] = {
      {
// FIXME: unused zero positions, from uncoded trivial transform set
#if CONFIG_CHROMA_2X2
          {
              { 0 },
          },
#endif
          {
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
#if CONFIG_SMOOTH_HV
              { 0 },
              { 0 },
#endif  // CONFIG_SMOOTH_HV
              { 0 },
          },
          {
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
#if CONFIG_SMOOTH_HV
              { 0 },
              { 0 },
#endif  // CONFIG_SMOOTH_HV
              { 0 },
          },
          {
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
#if CONFIG_SMOOTH_HV
              { 0 },
              { 0 },
#endif  // CONFIG_SMOOTH_HV
              { 0 },
          },
          {
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
              { 0 },
#if CONFIG_SMOOTH_HV
              { 0 },
              { 0 },
#endif  // CONFIG_SMOOTH_HV
              { 0 },
          },
      },
      {
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29048),
                AOM_ICDF(29296), AOM_ICDF(30164), AOM_ICDF(31466),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(26284),
                AOM_ICDF(26717), AOM_ICDF(28230), AOM_ICDF(30499),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(3938), AOM_ICDF(5860),
                AOM_ICDF(29404), AOM_ICDF(31086), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29048),
                AOM_ICDF(29296), AOM_ICDF(30164), AOM_ICDF(31466),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(26284),
                AOM_ICDF(26717), AOM_ICDF(28230), AOM_ICDF(30499),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(3938), AOM_ICDF(5860),
                AOM_ICDF(29404), AOM_ICDF(31086), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29048),
                AOM_ICDF(29296), AOM_ICDF(30164), AOM_ICDF(31466),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(26284),
                AOM_ICDF(26717), AOM_ICDF(28230), AOM_ICDF(30499),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(3938), AOM_ICDF(5860),
                AOM_ICDF(29404), AOM_ICDF(31086), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29048),
                AOM_ICDF(29296), AOM_ICDF(30164), AOM_ICDF(31466),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(26284),
                AOM_ICDF(26717), AOM_ICDF(28230), AOM_ICDF(30499),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(3938), AOM_ICDF(5860),
                AOM_ICDF(29404), AOM_ICDF(31086), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(27118), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(5900), AOM_ICDF(7691),
                AOM_ICDF(15528), AOM_ICDF(27380), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(8660),
                AOM_ICDF(10167), AOM_ICDF(15817), AOM_ICDF(32768), 0 },
          },
      },
      {
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29792),
                AOM_ICDF(31280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(27581),
                AOM_ICDF(30174), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(28924),
                AOM_ICDF(30846), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29792),
                AOM_ICDF(31280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(27581),
                AOM_ICDF(30174), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(28924),
                AOM_ICDF(30846), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29792),
                AOM_ICDF(31280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(27581),
                AOM_ICDF(30174), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(28924),
                AOM_ICDF(30846), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(28800), AOM_ICDF(29792),
                AOM_ICDF(31280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(25852), AOM_ICDF(27581),
                AOM_ICDF(30174), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(2016), AOM_ICDF(28924),
                AOM_ICDF(30846), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(26310),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(4109), AOM_ICDF(13065),
                AOM_ICDF(26611), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(5216), AOM_ICDF(6938), AOM_ICDF(13396),
                AOM_ICDF(32768), 0 },
          },
      },
#if CONFIG_MRC_TX
      {
          {
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
          },
          {
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1152), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1024), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#if CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
#endif  // CONFIG_SMOOTH_HV
              { AOM_ICDF(1280), AOM_ICDF(32768), 0 },
          },
      }
#endif  // CONFIG_MRC_TX
    };
static const aom_cdf_prob
    default_inter_ext_tx_cdf[EXT_TX_SETS_INTER][EXT_TX_SIZES][CDF_SIZE(
        TX_TYPES)] = {
      {
#if CONFIG_CHROMA_2X2
          { 0 },
#endif
          { 0 },
          { 0 },
          { 0 },
          { 0 } },
      {
#if CONFIG_CHROMA_2X2
          { 0 },
#endif
          { AOM_ICDF(1280), AOM_ICDF(1453), AOM_ICDF(1626), AOM_ICDF(2277),
            AOM_ICDF(2929), AOM_ICDF(3580), AOM_ICDF(4232), AOM_ICDF(16717),
            AOM_ICDF(19225), AOM_ICDF(21733), AOM_ICDF(24241), AOM_ICDF(26749),
            AOM_ICDF(28253), AOM_ICDF(29758), AOM_ICDF(31263), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(1453), AOM_ICDF(1626), AOM_ICDF(2277),
            AOM_ICDF(2929), AOM_ICDF(3580), AOM_ICDF(4232), AOM_ICDF(16717),
            AOM_ICDF(19225), AOM_ICDF(21733), AOM_ICDF(24241), AOM_ICDF(26749),
            AOM_ICDF(28253), AOM_ICDF(29758), AOM_ICDF(31263), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(1453), AOM_ICDF(1626), AOM_ICDF(2277),
            AOM_ICDF(2929), AOM_ICDF(3580), AOM_ICDF(4232), AOM_ICDF(16717),
            AOM_ICDF(19225), AOM_ICDF(21733), AOM_ICDF(24241), AOM_ICDF(26749),
            AOM_ICDF(28253), AOM_ICDF(29758), AOM_ICDF(31263), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(1453), AOM_ICDF(1626), AOM_ICDF(2277),
            AOM_ICDF(2929), AOM_ICDF(3580), AOM_ICDF(4232), AOM_ICDF(16717),
            AOM_ICDF(19225), AOM_ICDF(21733), AOM_ICDF(24241), AOM_ICDF(26749),
            AOM_ICDF(28253), AOM_ICDF(29758), AOM_ICDF(31263), AOM_ICDF(32768),
            0 } },
      {
#if CONFIG_CHROMA_2X2
          { 0 },
#endif
          { AOM_ICDF(1280), AOM_ICDF(3125), AOM_ICDF(4970), AOM_ICDF(17132),
            AOM_ICDF(19575), AOM_ICDF(22018), AOM_ICDF(24461), AOM_ICDF(26904),
            AOM_ICDF(28370), AOM_ICDF(29836), AOM_ICDF(31302), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(3125), AOM_ICDF(4970), AOM_ICDF(17132),
            AOM_ICDF(19575), AOM_ICDF(22018), AOM_ICDF(24461), AOM_ICDF(26904),
            AOM_ICDF(28370), AOM_ICDF(29836), AOM_ICDF(31302), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(3125), AOM_ICDF(4970), AOM_ICDF(17132),
            AOM_ICDF(19575), AOM_ICDF(22018), AOM_ICDF(24461), AOM_ICDF(26904),
            AOM_ICDF(28370), AOM_ICDF(29836), AOM_ICDF(31302), AOM_ICDF(32768),
            0 },
          { AOM_ICDF(1280), AOM_ICDF(3125), AOM_ICDF(4970), AOM_ICDF(17132),
            AOM_ICDF(19575), AOM_ICDF(22018), AOM_ICDF(24461), AOM_ICDF(26904),
            AOM_ICDF(28370), AOM_ICDF(29836), AOM_ICDF(31302), AOM_ICDF(32768),
            0 } },
      {
#if CONFIG_CHROMA_2X2
          { 0 },
#endif
          { AOM_ICDF(1536), AOM_ICDF(32768), 0 },
          { AOM_ICDF(1536), AOM_ICDF(32768), 0 },
          { AOM_ICDF(1536), AOM_ICDF(32768), 0 },
          { AOM_ICDF(1536), AOM_ICDF(32768), 0 } },
#if CONFIG_MRC_TX
      {
#if CONFIG_CHROMA_2X2
          { 0 },
#endif
          { AOM_ICDF(30080), AOM_ICDF(31781), AOM_ICDF(32768), 0 },
          { AOM_ICDF(4608), AOM_ICDF(32658), AOM_ICDF(32768), 0 },
          { AOM_ICDF(4352), AOM_ICDF(4685), AOM_ICDF(32768), 0 },
          { AOM_ICDF(19072), AOM_ICDF(26776), AOM_ICDF(32768), 0 } },
#endif  // CONFIG_MRC_TX
    };
#else
#if CONFIG_MRC_TX
static const aom_cdf_prob
    default_intra_ext_tx_cdf[EXT_TX_SIZES][TX_TYPES][CDF_SIZE(TX_TYPES)] = {
#if CONFIG_CHROMA_2X2
      { { AOM_ICDF(30720), AOM_ICDF(31104), AOM_ICDF(31400), AOM_ICDF(32084),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(31764),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(1642),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(1642),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(1280), AOM_ICDF(31760), AOM_ICDF(32264),
          AOM_ICDF(32768), 0 } },
#endif
      { { AOM_ICDF(30720), AOM_ICDF(31104), AOM_ICDF(31400), AOM_ICDF(32084),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(31764),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(1642),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(582), AOM_ICDF(638), AOM_ICDF(1642),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(1280), AOM_ICDF(31760), AOM_ICDF(32264),
          AOM_ICDF(32768), 0 } },

      { { AOM_ICDF(31232), AOM_ICDF(31488), AOM_ICDF(31742), AOM_ICDF(32255),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(1152), AOM_ICDF(1272), AOM_ICDF(31784),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(1152), AOM_ICDF(1272), AOM_ICDF(2256),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(1052), AOM_ICDF(1272), AOM_ICDF(2256),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(1792), AOM_ICDF(31776), AOM_ICDF(32272),
          AOM_ICDF(32768), 0 } },

      { { AOM_ICDF(31744), AOM_ICDF(31940), AOM_ICDF(32084), AOM_ICDF(32426),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(2176), AOM_ICDF(2528), AOM_ICDF(31823),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(2176), AOM_ICDF(2528), AOM_ICDF(3473),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(2176), AOM_ICDF(2528), AOM_ICDF(3473),
          AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(28160), AOM_ICDF(31808), AOM_ICDF(32288),
          AOM_ICDF(32768), 0 } },
    };

static const aom_cdf_prob
    default_inter_ext_tx_cdf[EXT_TX_SIZES][CDF_SIZE(TX_TYPES)] = {
#if CONFIG_CHROMA_2X2
      { AOM_ICDF(20480), AOM_ICDF(23040), AOM_ICDF(24560), AOM_ICDF(28664),
        AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(20480), AOM_ICDF(23040), AOM_ICDF(24560), AOM_ICDF(28664),
        AOM_ICDF(32768), 0 },
      { AOM_ICDF(22528), AOM_ICDF(24320), AOM_ICDF(25928), AOM_ICDF(29348),
        AOM_ICDF(32768), 0 },
      { AOM_ICDF(24576), AOM_ICDF(25600), AOM_ICDF(27296), AOM_ICDF(30032),
        AOM_ICDF(32768), 0 },
    };
#else  // CONFIG_MRC_TX
static const aom_cdf_prob
    default_intra_ext_tx_cdf[EXT_TX_SIZES][TX_TYPES][CDF_SIZE(TX_TYPES)] = {
#if CONFIG_CHROMA_2X2
      { { AOM_ICDF(30720), AOM_ICDF(31400), AOM_ICDF(32084), AOM_ICDF(32768),
          0 },
        { AOM_ICDF(512), AOM_ICDF(638), AOM_ICDF(31764), AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(638), AOM_ICDF(1642), AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(31760), AOM_ICDF(32264), AOM_ICDF(32768),
          0 } },
#endif
      { { AOM_ICDF(30720), AOM_ICDF(31400), AOM_ICDF(32084), AOM_ICDF(32768),
          0 },
        { AOM_ICDF(512), AOM_ICDF(638), AOM_ICDF(31764), AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(638), AOM_ICDF(1642), AOM_ICDF(32768), 0 },
        { AOM_ICDF(512), AOM_ICDF(31760), AOM_ICDF(32264), AOM_ICDF(32768),
          0 } },

      { { AOM_ICDF(31232), AOM_ICDF(31742), AOM_ICDF(32255), AOM_ICDF(32768),
          0 },
        { AOM_ICDF(1024), AOM_ICDF(1272), AOM_ICDF(31784), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(1272), AOM_ICDF(2256), AOM_ICDF(32768), 0 },
        { AOM_ICDF(1024), AOM_ICDF(31776), AOM_ICDF(32272), AOM_ICDF(32768),
          0 } },
      { { AOM_ICDF(31744), AOM_ICDF(32084), AOM_ICDF(32426), AOM_ICDF(32768),
          0 },
        { AOM_ICDF(2048), AOM_ICDF(2528), AOM_ICDF(31823), AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(2528), AOM_ICDF(3473), AOM_ICDF(32768), 0 },
        { AOM_ICDF(2048), AOM_ICDF(31808), AOM_ICDF(32288), AOM_ICDF(32768),
          0 } },
    };

static const aom_cdf_prob
    default_inter_ext_tx_cdf[EXT_TX_SIZES][CDF_SIZE(TX_TYPES)] = {
#if CONFIG_CHROMA_2X2
      { AOM_ICDF(20480), AOM_ICDF(24560), AOM_ICDF(28664), AOM_ICDF(32768), 0 },
#endif
      { AOM_ICDF(20480), AOM_ICDF(24560), AOM_ICDF(28664), AOM_ICDF(32768), 0 },
      { AOM_ICDF(22528), AOM_ICDF(25928), AOM_ICDF(29348), AOM_ICDF(32768), 0 },
      { AOM_ICDF(24576), AOM_ICDF(27296), AOM_ICDF(30032), AOM_ICDF(32768), 0 },
    };
#endif  // CONFIG_MRC_TX
#endif  // !CONFIG_EXT_TX

#if CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP
static const aom_cdf_prob
    default_intra_filter_cdf[INTRA_FILTERS + 1][CDF_SIZE(INTRA_FILTERS)] = {
      { AOM_ICDF(12544), AOM_ICDF(17521), AOM_ICDF(21095), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12544), AOM_ICDF(19022), AOM_ICDF(23318), AOM_ICDF(32768), 0 },
      { AOM_ICDF(12032), AOM_ICDF(17297), AOM_ICDF(23522), AOM_ICDF(32768), 0 },
      { AOM_ICDF(6272), AOM_ICDF(8860), AOM_ICDF(11101), AOM_ICDF(32768), 0 },
      { AOM_ICDF(9216), AOM_ICDF(12712), AOM_ICDF(16629), AOM_ICDF(32768), 0 },
    };
#endif  // CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP

#if CONFIG_CFL
static const aom_cdf_prob default_cfl_sign_cdf[CDF_SIZE(CFL_JOINT_SIGNS)] = {
  AOM_ICDF(1892),  AOM_ICDF(2229),  AOM_ICDF(11464),
  AOM_ICDF(14116), AOM_ICDF(25661), AOM_ICDF(26409),
  AOM_ICDF(32508), AOM_ICDF(32768), 0
};

static const aom_cdf_prob
    default_cfl_alpha_cdf[CFL_ALPHA_CONTEXTS][CDF_SIZE(CFL_ALPHABET_SIZE)] = {
      { AOM_ICDF(16215), AOM_ICDF(27740), AOM_ICDF(31726), AOM_ICDF(32606),
        AOM_ICDF(32736), AOM_ICDF(32751), AOM_ICDF(32757), AOM_ICDF(32759),
        AOM_ICDF(32761), AOM_ICDF(32762), AOM_ICDF(32763), AOM_ICDF(32764),
        AOM_ICDF(32765), AOM_ICDF(32766), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(15213), AOM_ICDF(24615), AOM_ICDF(29704), AOM_ICDF(31974),
        AOM_ICDF(32545), AOM_ICDF(32673), AOM_ICDF(32713), AOM_ICDF(32746),
        AOM_ICDF(32753), AOM_ICDF(32756), AOM_ICDF(32758), AOM_ICDF(32761),
        AOM_ICDF(32763), AOM_ICDF(32764), AOM_ICDF(32766), AOM_ICDF(32768), 0 },
      { AOM_ICDF(13250), AOM_ICDF(24677), AOM_ICDF(29113), AOM_ICDF(31666),
        AOM_ICDF(32408), AOM_ICDF(32578), AOM_ICDF(32628), AOM_ICDF(32711),
        AOM_ICDF(32730), AOM_ICDF(32738), AOM_ICDF(32744), AOM_ICDF(32749),
        AOM_ICDF(32752), AOM_ICDF(32756), AOM_ICDF(32759), AOM_ICDF(32768), 0 },
      { AOM_ICDF(24593), AOM_ICDF(30787), AOM_ICDF(32062), AOM_ICDF(32495),
        AOM_ICDF(32656), AOM_ICDF(32707), AOM_ICDF(32735), AOM_ICDF(32747),
        AOM_ICDF(32752), AOM_ICDF(32757), AOM_ICDF(32760), AOM_ICDF(32763),
        AOM_ICDF(32764), AOM_ICDF(32765), AOM_ICDF(32767), AOM_ICDF(32768), 0 },
      { AOM_ICDF(19883), AOM_ICDF(27419), AOM_ICDF(30100), AOM_ICDF(31392),
        AOM_ICDF(31896), AOM_ICDF(32184), AOM_ICDF(32299), AOM_ICDF(32511),
        AOM_ICDF(32568), AOM_ICDF(32602), AOM_ICDF(32628), AOM_ICDF(32664),
        AOM_ICDF(32680), AOM_ICDF(32691), AOM_ICDF(32708), AOM_ICDF(32768), 0 },
      { AOM_ICDF(15939), AOM_ICDF(24151), AOM_ICDF(27754), AOM_ICDF(29680),
        AOM_ICDF(30651), AOM_ICDF(31267), AOM_ICDF(31527), AOM_ICDF(31868),
        AOM_ICDF(32001), AOM_ICDF(32090), AOM_ICDF(32181), AOM_ICDF(32284),
        AOM_ICDF(32314), AOM_ICDF(32366), AOM_ICDF(32486), AOM_ICDF(32768), 0 }
    };
#endif

#if CONFIG_KF_CTX
// TODO(jingning): This initial models are copied directly from the entries
// from the original table. The copied indexes are (0, 0), (0, 1), .. (4, 4).
// It is possible to re-train this model and bring back the 0.14% loss in CIF
// set key frame coding. This reduction in context model does not change the
// key frame coding stats for mid and high resolution sets.
const aom_cdf_prob
    default_kf_y_mode_cdf[KF_MODE_CONTEXTS][KF_MODE_CONTEXTS][CDF_SIZE(
        INTRA_MODES)] = {
      {
          {
              AOM_ICDF(14208), AOM_ICDF(17049), AOM_ICDF(20482),
              AOM_ICDF(21400), AOM_ICDF(22520), AOM_ICDF(23261),
              AOM_ICDF(23963), AOM_ICDF(25010), AOM_ICDF(25828),
              AOM_ICDF(28398), AOM_ICDF(29394), AOM_ICDF(30738),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(10496), AOM_ICDF(18295), AOM_ICDF(19872),
              AOM_ICDF(20945), AOM_ICDF(21933), AOM_ICDF(22818),
              AOM_ICDF(23334), AOM_ICDF(24033), AOM_ICDF(24996),
              AOM_ICDF(27652), AOM_ICDF(29060), AOM_ICDF(30071),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(5120), AOM_ICDF(6461), AOM_ICDF(19840), AOM_ICDF(20310),
              AOM_ICDF(21151), AOM_ICDF(21506), AOM_ICDF(22535),
              AOM_ICDF(23900), AOM_ICDF(24281), AOM_ICDF(26958),
              AOM_ICDF(27680), AOM_ICDF(29636), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(12544), AOM_ICDF(15177), AOM_ICDF(17666),
              AOM_ICDF(19855), AOM_ICDF(21147), AOM_ICDF(22017),
              AOM_ICDF(22797), AOM_ICDF(24514), AOM_ICDF(25779),
              AOM_ICDF(28716), AOM_ICDF(29772), AOM_ICDF(31267),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(7552), AOM_ICDF(9909), AOM_ICDF(11908), AOM_ICDF(13141),
              AOM_ICDF(18765), AOM_ICDF(22029), AOM_ICDF(23872),
              AOM_ICDF(24920), AOM_ICDF(25674), AOM_ICDF(29031),
              AOM_ICDF(30244), AOM_ICDF(31684), AOM_ICDF(32768), 0,
          },
      },
      {
          {
              AOM_ICDF(3968), AOM_ICDF(17613), AOM_ICDF(19125), AOM_ICDF(19550),
              AOM_ICDF(20305), AOM_ICDF(21908), AOM_ICDF(22274),
              AOM_ICDF(22719), AOM_ICDF(23959), AOM_ICDF(26970),
              AOM_ICDF(29013), AOM_ICDF(29843), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(3072), AOM_ICDF(21231), AOM_ICDF(21863), AOM_ICDF(22306),
              AOM_ICDF(22674), AOM_ICDF(23414), AOM_ICDF(23517),
              AOM_ICDF(23798), AOM_ICDF(24770), AOM_ICDF(27032),
              AOM_ICDF(29016), AOM_ICDF(29636), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(2560), AOM_ICDF(9825), AOM_ICDF(15681), AOM_ICDF(16370),
              AOM_ICDF(17054), AOM_ICDF(17687), AOM_ICDF(18236),
              AOM_ICDF(19273), AOM_ICDF(20311), AOM_ICDF(24863),
              AOM_ICDF(26825), AOM_ICDF(28756), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(6912), AOM_ICDF(15140), AOM_ICDF(16485), AOM_ICDF(18364),
              AOM_ICDF(19181), AOM_ICDF(20394), AOM_ICDF(20663),
              AOM_ICDF(22098), AOM_ICDF(23936), AOM_ICDF(27555),
              AOM_ICDF(29704), AOM_ICDF(30849), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(2944), AOM_ICDF(13101), AOM_ICDF(14006), AOM_ICDF(14974),
              AOM_ICDF(17818), AOM_ICDF(21093), AOM_ICDF(21930),
              AOM_ICDF(22566), AOM_ICDF(24137), AOM_ICDF(27732),
              AOM_ICDF(29814), AOM_ICDF(30904), AOM_ICDF(32768), 0,
          },
      },
      {
          {
              AOM_ICDF(11392), AOM_ICDF(12961), AOM_ICDF(20901),
              AOM_ICDF(21544), AOM_ICDF(22490), AOM_ICDF(22928),
              AOM_ICDF(23888), AOM_ICDF(25214), AOM_ICDF(25777),
              AOM_ICDF(28256), AOM_ICDF(29102), AOM_ICDF(30513),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(8064), AOM_ICDF(13595), AOM_ICDF(18888), AOM_ICDF(19616),
              AOM_ICDF(20765), AOM_ICDF(21454), AOM_ICDF(21990),
              AOM_ICDF(23103), AOM_ICDF(23980), AOM_ICDF(26772),
              AOM_ICDF(28070), AOM_ICDF(29197), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(4352), AOM_ICDF(5059), AOM_ICDF(21705), AOM_ICDF(22099),
              AOM_ICDF(22703), AOM_ICDF(22846), AOM_ICDF(23679),
              AOM_ICDF(25469), AOM_ICDF(25728), AOM_ICDF(27919),
              AOM_ICDF(28484), AOM_ICDF(30215), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(10752), AOM_ICDF(12277), AOM_ICDF(16471),
              AOM_ICDF(18276), AOM_ICDF(19443), AOM_ICDF(19917),
              AOM_ICDF(21158), AOM_ICDF(23881), AOM_ICDF(24892),
              AOM_ICDF(27709), AOM_ICDF(28771), AOM_ICDF(30274),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(8320), AOM_ICDF(10000), AOM_ICDF(14147), AOM_ICDF(15330),
              AOM_ICDF(19197), AOM_ICDF(20923), AOM_ICDF(22954),
              AOM_ICDF(24541), AOM_ICDF(25285), AOM_ICDF(28407),
              AOM_ICDF(29431), AOM_ICDF(30953), AOM_ICDF(32768), 0,
          },
      },
      {
          {
              AOM_ICDF(10240), AOM_ICDF(12819), AOM_ICDF(15545),
              AOM_ICDF(18248), AOM_ICDF(19779), AOM_ICDF(20932),
              AOM_ICDF(21899), AOM_ICDF(23377), AOM_ICDF(25448),
              AOM_ICDF(28730), AOM_ICDF(29936), AOM_ICDF(31536),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(7552), AOM_ICDF(15309), AOM_ICDF(16645), AOM_ICDF(19760),
              AOM_ICDF(20653), AOM_ICDF(21650), AOM_ICDF(22221),
              AOM_ICDF(23273), AOM_ICDF(25509), AOM_ICDF(28683),
              AOM_ICDF(30153), AOM_ICDF(31192), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(5248), AOM_ICDF(6840), AOM_ICDF(16129), AOM_ICDF(17940),
              AOM_ICDF(19069), AOM_ICDF(19660), AOM_ICDF(20588),
              AOM_ICDF(22760), AOM_ICDF(23927), AOM_ICDF(27538),
              AOM_ICDF(28397), AOM_ICDF(30725), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(11008), AOM_ICDF(11903), AOM_ICDF(13794),
              AOM_ICDF(21320), AOM_ICDF(21931), AOM_ICDF(22310),
              AOM_ICDF(22546), AOM_ICDF(25375), AOM_ICDF(27347),
              AOM_ICDF(29800), AOM_ICDF(30761), AOM_ICDF(31833),
              AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(6272), AOM_ICDF(8678), AOM_ICDF(10313), AOM_ICDF(13073),
              AOM_ICDF(16823), AOM_ICDF(19980), AOM_ICDF(21520),
              AOM_ICDF(23242), AOM_ICDF(25344), AOM_ICDF(28797),
              AOM_ICDF(30405), AOM_ICDF(31940), AOM_ICDF(32768), 0,
          },
      },
      {
          {
              AOM_ICDF(7296), AOM_ICDF(9304), AOM_ICDF(11772), AOM_ICDF(12529),
              AOM_ICDF(18014), AOM_ICDF(20418), AOM_ICDF(23076),
              AOM_ICDF(24662), AOM_ICDF(25549), AOM_ICDF(29074),
              AOM_ICDF(30392), AOM_ICDF(31773), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(7168), AOM_ICDF(11687), AOM_ICDF(13541), AOM_ICDF(14431),
              AOM_ICDF(18214), AOM_ICDF(20761), AOM_ICDF(22269),
              AOM_ICDF(23320), AOM_ICDF(24633), AOM_ICDF(28339),
              AOM_ICDF(30193), AOM_ICDF(31268), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(3584), AOM_ICDF(4428), AOM_ICDF(13496), AOM_ICDF(14189),
              AOM_ICDF(17372), AOM_ICDF(18617), AOM_ICDF(20609),
              AOM_ICDF(22615), AOM_ICDF(23270), AOM_ICDF(27280),
              AOM_ICDF(28305), AOM_ICDF(30602), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(7424), AOM_ICDF(8834), AOM_ICDF(10499), AOM_ICDF(14357),
              AOM_ICDF(17671), AOM_ICDF(19150), AOM_ICDF(20460),
              AOM_ICDF(23235), AOM_ICDF(24391), AOM_ICDF(28351),
              AOM_ICDF(29843), AOM_ICDF(31481), AOM_ICDF(32768), 0,
          },
          {
              AOM_ICDF(4480), AOM_ICDF(5888), AOM_ICDF(7093), AOM_ICDF(7902),
              AOM_ICDF(18290), AOM_ICDF(22123), AOM_ICDF(24511),
              AOM_ICDF(25532), AOM_ICDF(26360), AOM_ICDF(29653),
              AOM_ICDF(30954), AOM_ICDF(32215), AOM_ICDF(32768), 0,
          },
      },
    };
#else
const aom_cdf_prob default_kf_y_mode_cdf[INTRA_MODES][INTRA_MODES][CDF_SIZE(
    INTRA_MODES)] = {
#if CONFIG_SMOOTH_HV
  {
      {
          AOM_ICDF(14208), AOM_ICDF(17049), AOM_ICDF(20482), AOM_ICDF(21400),
          AOM_ICDF(22520), AOM_ICDF(23261), AOM_ICDF(23963), AOM_ICDF(25010),
          AOM_ICDF(25828), AOM_ICDF(28398), AOM_ICDF(29394), AOM_ICDF(30738),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10496), AOM_ICDF(18295), AOM_ICDF(19872), AOM_ICDF(20945),
          AOM_ICDF(21933), AOM_ICDF(22818), AOM_ICDF(23334), AOM_ICDF(24033),
          AOM_ICDF(24996), AOM_ICDF(27652), AOM_ICDF(29060), AOM_ICDF(30071),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(6461), AOM_ICDF(19840), AOM_ICDF(20310),
          AOM_ICDF(21151), AOM_ICDF(21506), AOM_ICDF(22535), AOM_ICDF(23900),
          AOM_ICDF(24281), AOM_ICDF(26958), AOM_ICDF(27680), AOM_ICDF(29636),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12544), AOM_ICDF(15177), AOM_ICDF(17666), AOM_ICDF(19855),
          AOM_ICDF(21147), AOM_ICDF(22017), AOM_ICDF(22797), AOM_ICDF(24514),
          AOM_ICDF(25779), AOM_ICDF(28716), AOM_ICDF(29772), AOM_ICDF(31267),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7552), AOM_ICDF(9909), AOM_ICDF(11908), AOM_ICDF(13141),
          AOM_ICDF(18765), AOM_ICDF(22029), AOM_ICDF(23872), AOM_ICDF(24920),
          AOM_ICDF(25674), AOM_ICDF(29031), AOM_ICDF(30244), AOM_ICDF(31684),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11008), AOM_ICDF(15004), AOM_ICDF(16534), AOM_ICDF(18158),
          AOM_ICDF(21515), AOM_ICDF(26668), AOM_ICDF(27834), AOM_ICDF(28735),
          AOM_ICDF(30471), AOM_ICDF(30839), AOM_ICDF(30969), AOM_ICDF(31068),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(7963), AOM_ICDF(11944), AOM_ICDF(12780),
          AOM_ICDF(17944), AOM_ICDF(19198), AOM_ICDF(24071), AOM_ICDF(25295),
          AOM_ICDF(25834), AOM_ICDF(29014), AOM_ICDF(29949), AOM_ICDF(31733),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8192), AOM_ICDF(10189), AOM_ICDF(14596), AOM_ICDF(15680),
          AOM_ICDF(17143), AOM_ICDF(17909), AOM_ICDF(19201), AOM_ICDF(23711),
          AOM_ICDF(24503), AOM_ICDF(28207), AOM_ICDF(29338), AOM_ICDF(31424),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10752), AOM_ICDF(13199), AOM_ICDF(15048), AOM_ICDF(17151),
          AOM_ICDF(18445), AOM_ICDF(19604), AOM_ICDF(20363), AOM_ICDF(21782),
          AOM_ICDF(24311), AOM_ICDF(28026), AOM_ICDF(29517), AOM_ICDF(30962),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(10301), AOM_ICDF(13245), AOM_ICDF(14307),
          AOM_ICDF(16021), AOM_ICDF(16257), AOM_ICDF(17265), AOM_ICDF(18739),
          AOM_ICDF(20080), AOM_ICDF(26066), AOM_ICDF(28325), AOM_ICDF(31184),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(10893), AOM_ICDF(13773), AOM_ICDF(14824),
          AOM_ICDF(16540), AOM_ICDF(16926), AOM_ICDF(17748), AOM_ICDF(18876),
          AOM_ICDF(20396), AOM_ICDF(25974), AOM_ICDF(28795), AOM_ICDF(30820),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(11005), AOM_ICDF(14320), AOM_ICDF(15349),
          AOM_ICDF(16746), AOM_ICDF(16884), AOM_ICDF(17887), AOM_ICDF(19304),
          AOM_ICDF(20265), AOM_ICDF(26115), AOM_ICDF(27672), AOM_ICDF(31358),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(9504), AOM_ICDF(15437), AOM_ICDF(16399),
          AOM_ICDF(17355), AOM_ICDF(17948), AOM_ICDF(18814), AOM_ICDF(20270),
          AOM_ICDF(21134), AOM_ICDF(23690), AOM_ICDF(24759), AOM_ICDF(26454),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(3968), AOM_ICDF(17613), AOM_ICDF(19125), AOM_ICDF(19550),
          AOM_ICDF(20305), AOM_ICDF(21908), AOM_ICDF(22274), AOM_ICDF(22719),
          AOM_ICDF(23959), AOM_ICDF(26970), AOM_ICDF(29013), AOM_ICDF(29843),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3072), AOM_ICDF(21231), AOM_ICDF(21863), AOM_ICDF(22306),
          AOM_ICDF(22674), AOM_ICDF(23414), AOM_ICDF(23517), AOM_ICDF(23798),
          AOM_ICDF(24770), AOM_ICDF(27032), AOM_ICDF(29016), AOM_ICDF(29636),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2560), AOM_ICDF(9825), AOM_ICDF(15681), AOM_ICDF(16370),
          AOM_ICDF(17054), AOM_ICDF(17687), AOM_ICDF(18236), AOM_ICDF(19273),
          AOM_ICDF(20311), AOM_ICDF(24863), AOM_ICDF(26825), AOM_ICDF(28756),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(15140), AOM_ICDF(16485), AOM_ICDF(18364),
          AOM_ICDF(19181), AOM_ICDF(20394), AOM_ICDF(20663), AOM_ICDF(22098),
          AOM_ICDF(23936), AOM_ICDF(27555), AOM_ICDF(29704), AOM_ICDF(30849),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2944), AOM_ICDF(13101), AOM_ICDF(14006), AOM_ICDF(14974),
          AOM_ICDF(17818), AOM_ICDF(21093), AOM_ICDF(21930), AOM_ICDF(22566),
          AOM_ICDF(24137), AOM_ICDF(27732), AOM_ICDF(29814), AOM_ICDF(30904),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4352), AOM_ICDF(17824), AOM_ICDF(18715), AOM_ICDF(19632),
          AOM_ICDF(21519), AOM_ICDF(26341), AOM_ICDF(26922), AOM_ICDF(27575),
          AOM_ICDF(29863), AOM_ICDF(30432), AOM_ICDF(30769), AOM_ICDF(30881),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2944), AOM_ICDF(11971), AOM_ICDF(13509), AOM_ICDF(14295),
          AOM_ICDF(17202), AOM_ICDF(19005), AOM_ICDF(21605), AOM_ICDF(22458),
          AOM_ICDF(23839), AOM_ICDF(27774), AOM_ICDF(29492), AOM_ICDF(30787),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4224), AOM_ICDF(13072), AOM_ICDF(15288), AOM_ICDF(16406),
          AOM_ICDF(17285), AOM_ICDF(18362), AOM_ICDF(19003), AOM_ICDF(21378),
          AOM_ICDF(22942), AOM_ICDF(27093), AOM_ICDF(29381), AOM_ICDF(30872),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(15375), AOM_ICDF(16188), AOM_ICDF(17415),
          AOM_ICDF(18183), AOM_ICDF(19756), AOM_ICDF(20030), AOM_ICDF(20883),
          AOM_ICDF(23935), AOM_ICDF(27428), AOM_ICDF(29627), AOM_ICDF(30608),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2816), AOM_ICDF(14999), AOM_ICDF(16352), AOM_ICDF(16969),
          AOM_ICDF(17836), AOM_ICDF(18125), AOM_ICDF(18514), AOM_ICDF(19181),
          AOM_ICDF(20650), AOM_ICDF(25773), AOM_ICDF(29172), AOM_ICDF(30662),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2560), AOM_ICDF(16158), AOM_ICDF(17320), AOM_ICDF(17839),
          AOM_ICDF(18545), AOM_ICDF(18848), AOM_ICDF(19130), AOM_ICDF(19599),
          AOM_ICDF(20863), AOM_ICDF(25449), AOM_ICDF(29304), AOM_ICDF(30408),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3328), AOM_ICDF(15146), AOM_ICDF(16880), AOM_ICDF(17523),
          AOM_ICDF(18340), AOM_ICDF(18563), AOM_ICDF(18896), AOM_ICDF(19582),
          AOM_ICDF(20944), AOM_ICDF(25914), AOM_ICDF(28759), AOM_ICDF(30583),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2560), AOM_ICDF(16618), AOM_ICDF(18460), AOM_ICDF(19207),
          AOM_ICDF(19654), AOM_ICDF(20276), AOM_ICDF(20529), AOM_ICDF(21179),
          AOM_ICDF(22355), AOM_ICDF(25423), AOM_ICDF(27696), AOM_ICDF(28638),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(11392), AOM_ICDF(12961), AOM_ICDF(20901), AOM_ICDF(21544),
          AOM_ICDF(22490), AOM_ICDF(22928), AOM_ICDF(23888), AOM_ICDF(25214),
          AOM_ICDF(25777), AOM_ICDF(28256), AOM_ICDF(29102), AOM_ICDF(30513),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8064), AOM_ICDF(13595), AOM_ICDF(18888), AOM_ICDF(19616),
          AOM_ICDF(20765), AOM_ICDF(21454), AOM_ICDF(21990), AOM_ICDF(23103),
          AOM_ICDF(23980), AOM_ICDF(26772), AOM_ICDF(28070), AOM_ICDF(29197),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4352), AOM_ICDF(5059), AOM_ICDF(21705), AOM_ICDF(22099),
          AOM_ICDF(22703), AOM_ICDF(22846), AOM_ICDF(23679), AOM_ICDF(25469),
          AOM_ICDF(25728), AOM_ICDF(27919), AOM_ICDF(28484), AOM_ICDF(30215),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10752), AOM_ICDF(12277), AOM_ICDF(16471), AOM_ICDF(18276),
          AOM_ICDF(19443), AOM_ICDF(19917), AOM_ICDF(21158), AOM_ICDF(23881),
          AOM_ICDF(24892), AOM_ICDF(27709), AOM_ICDF(28771), AOM_ICDF(30274),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8320), AOM_ICDF(10000), AOM_ICDF(14147), AOM_ICDF(15330),
          AOM_ICDF(19197), AOM_ICDF(20923), AOM_ICDF(22954), AOM_ICDF(24541),
          AOM_ICDF(25285), AOM_ICDF(28407), AOM_ICDF(29431), AOM_ICDF(30953),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11264), AOM_ICDF(14751), AOM_ICDF(18517), AOM_ICDF(20285),
          AOM_ICDF(23172), AOM_ICDF(25970), AOM_ICDF(27312), AOM_ICDF(28684),
          AOM_ICDF(29803), AOM_ICDF(30242), AOM_ICDF(30412), AOM_ICDF(30668),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(7509), AOM_ICDF(14190), AOM_ICDF(14953),
          AOM_ICDF(17905), AOM_ICDF(18452), AOM_ICDF(23074), AOM_ICDF(24910),
          AOM_ICDF(25374), AOM_ICDF(28605), AOM_ICDF(29542), AOM_ICDF(31640),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(7644), AOM_ICDF(15953), AOM_ICDF(17055),
          AOM_ICDF(17945), AOM_ICDF(18242), AOM_ICDF(19351), AOM_ICDF(24705),
          AOM_ICDF(25365), AOM_ICDF(28466), AOM_ICDF(29334), AOM_ICDF(31245),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8192), AOM_ICDF(9802), AOM_ICDF(14519), AOM_ICDF(15740),
          AOM_ICDF(17351), AOM_ICDF(18084), AOM_ICDF(18962), AOM_ICDF(20908),
          AOM_ICDF(22937), AOM_ICDF(26847), AOM_ICDF(28284), AOM_ICDF(29888),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5888), AOM_ICDF(7534), AOM_ICDF(14635), AOM_ICDF(15436),
          AOM_ICDF(16710), AOM_ICDF(16830), AOM_ICDF(18000), AOM_ICDF(19760),
          AOM_ICDF(20571), AOM_ICDF(25777), AOM_ICDF(27649), AOM_ICDF(30668),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5248), AOM_ICDF(7364), AOM_ICDF(14858), AOM_ICDF(15545),
          AOM_ICDF(16861), AOM_ICDF(17016), AOM_ICDF(17859), AOM_ICDF(19384),
          AOM_ICDF(20237), AOM_ICDF(25239), AOM_ICDF(27715), AOM_ICDF(29865),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(7989), AOM_ICDF(15472), AOM_ICDF(16265),
          AOM_ICDF(17271), AOM_ICDF(17334), AOM_ICDF(18563), AOM_ICDF(20327),
          AOM_ICDF(20916), AOM_ICDF(26173), AOM_ICDF(27350), AOM_ICDF(31034),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(6411), AOM_ICDF(17828), AOM_ICDF(18611),
          AOM_ICDF(19399), AOM_ICDF(19684), AOM_ICDF(20504), AOM_ICDF(21782),
          AOM_ICDF(22335), AOM_ICDF(25286), AOM_ICDF(26352), AOM_ICDF(28016),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(10240), AOM_ICDF(12819), AOM_ICDF(15545), AOM_ICDF(18248),
          AOM_ICDF(19779), AOM_ICDF(20932), AOM_ICDF(21899), AOM_ICDF(23377),
          AOM_ICDF(25448), AOM_ICDF(28730), AOM_ICDF(29936), AOM_ICDF(31536),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7552), AOM_ICDF(15309), AOM_ICDF(16645), AOM_ICDF(19760),
          AOM_ICDF(20653), AOM_ICDF(21650), AOM_ICDF(22221), AOM_ICDF(23273),
          AOM_ICDF(25509), AOM_ICDF(28683), AOM_ICDF(30153), AOM_ICDF(31192),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5248), AOM_ICDF(6840), AOM_ICDF(16129), AOM_ICDF(17940),
          AOM_ICDF(19069), AOM_ICDF(19660), AOM_ICDF(20588), AOM_ICDF(22760),
          AOM_ICDF(23927), AOM_ICDF(27538), AOM_ICDF(28397), AOM_ICDF(30725),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11008), AOM_ICDF(11903), AOM_ICDF(13794), AOM_ICDF(21320),
          AOM_ICDF(21931), AOM_ICDF(22310), AOM_ICDF(22546), AOM_ICDF(25375),
          AOM_ICDF(27347), AOM_ICDF(29800), AOM_ICDF(30761), AOM_ICDF(31833),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(8678), AOM_ICDF(10313), AOM_ICDF(13073),
          AOM_ICDF(16823), AOM_ICDF(19980), AOM_ICDF(21520), AOM_ICDF(23242),
          AOM_ICDF(25344), AOM_ICDF(28797), AOM_ICDF(30405), AOM_ICDF(31940),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(10835), AOM_ICDF(12653), AOM_ICDF(16345),
          AOM_ICDF(19574), AOM_ICDF(24868), AOM_ICDF(25937), AOM_ICDF(27299),
          AOM_ICDF(31104), AOM_ICDF(31448), AOM_ICDF(31580), AOM_ICDF(31679),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4992), AOM_ICDF(6458), AOM_ICDF(9945), AOM_ICDF(11961),
          AOM_ICDF(16136), AOM_ICDF(17677), AOM_ICDF(20946), AOM_ICDF(23042),
          AOM_ICDF(24475), AOM_ICDF(28304), AOM_ICDF(29748), AOM_ICDF(31791),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(11879), AOM_ICDF(14703), AOM_ICDF(17653),
          AOM_ICDF(19176), AOM_ICDF(20185), AOM_ICDF(20880), AOM_ICDF(25194),
          AOM_ICDF(26584), AOM_ICDF(29655), AOM_ICDF(30430), AOM_ICDF(32044),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9856), AOM_ICDF(11385), AOM_ICDF(13457), AOM_ICDF(18705),
          AOM_ICDF(19577), AOM_ICDF(20266), AOM_ICDF(20746), AOM_ICDF(22207),
          AOM_ICDF(26724), AOM_ICDF(29431), AOM_ICDF(30645), AOM_ICDF(31604),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(9318), AOM_ICDF(11569), AOM_ICDF(14812),
          AOM_ICDF(16351), AOM_ICDF(16619), AOM_ICDF(17537), AOM_ICDF(19596),
          AOM_ICDF(22025), AOM_ICDF(27384), AOM_ICDF(29277), AOM_ICDF(31422),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5888), AOM_ICDF(9348), AOM_ICDF(11416), AOM_ICDF(14690),
          AOM_ICDF(16254), AOM_ICDF(16633), AOM_ICDF(17457), AOM_ICDF(19031),
          AOM_ICDF(21875), AOM_ICDF(27080), AOM_ICDF(29442), AOM_ICDF(31193),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(9329), AOM_ICDF(12218), AOM_ICDF(15177),
          AOM_ICDF(16806), AOM_ICDF(16998), AOM_ICDF(17991), AOM_ICDF(20005),
          AOM_ICDF(21952), AOM_ICDF(27108), AOM_ICDF(28867), AOM_ICDF(31657),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(9098), AOM_ICDF(13132), AOM_ICDF(17701),
          AOM_ICDF(18739), AOM_ICDF(19534), AOM_ICDF(20415), AOM_ICDF(22136),
          AOM_ICDF(24213), AOM_ICDF(27199), AOM_ICDF(28504), AOM_ICDF(29960),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(7296), AOM_ICDF(9304), AOM_ICDF(11772), AOM_ICDF(12529),
          AOM_ICDF(18014), AOM_ICDF(20418), AOM_ICDF(23076), AOM_ICDF(24662),
          AOM_ICDF(25549), AOM_ICDF(29074), AOM_ICDF(30392), AOM_ICDF(31773),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(11687), AOM_ICDF(13541), AOM_ICDF(14431),
          AOM_ICDF(18214), AOM_ICDF(20761), AOM_ICDF(22269), AOM_ICDF(23320),
          AOM_ICDF(24633), AOM_ICDF(28339), AOM_ICDF(30193), AOM_ICDF(31268),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3584), AOM_ICDF(4428), AOM_ICDF(13496), AOM_ICDF(14189),
          AOM_ICDF(17372), AOM_ICDF(18617), AOM_ICDF(20609), AOM_ICDF(22615),
          AOM_ICDF(23270), AOM_ICDF(27280), AOM_ICDF(28305), AOM_ICDF(30602),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(8834), AOM_ICDF(10499), AOM_ICDF(14357),
          AOM_ICDF(17671), AOM_ICDF(19150), AOM_ICDF(20460), AOM_ICDF(23235),
          AOM_ICDF(24391), AOM_ICDF(28351), AOM_ICDF(29843), AOM_ICDF(31481),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(5888), AOM_ICDF(7093), AOM_ICDF(7902),
          AOM_ICDF(18290), AOM_ICDF(22123), AOM_ICDF(24511), AOM_ICDF(25532),
          AOM_ICDF(26360), AOM_ICDF(29653), AOM_ICDF(30954), AOM_ICDF(32215),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7296), AOM_ICDF(10176), AOM_ICDF(11780), AOM_ICDF(12824),
          AOM_ICDF(19608), AOM_ICDF(25882), AOM_ICDF(28520), AOM_ICDF(29445),
          AOM_ICDF(31106), AOM_ICDF(31573), AOM_ICDF(31775), AOM_ICDF(31872),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(4833), AOM_ICDF(7551), AOM_ICDF(8449),
          AOM_ICDF(16668), AOM_ICDF(18614), AOM_ICDF(23952), AOM_ICDF(25668),
          AOM_ICDF(26721), AOM_ICDF(29888), AOM_ICDF(30697), AOM_ICDF(32090),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(8011), AOM_ICDF(11083), AOM_ICDF(12427),
          AOM_ICDF(16188), AOM_ICDF(17548), AOM_ICDF(19625), AOM_ICDF(23787),
          AOM_ICDF(24792), AOM_ICDF(28649), AOM_ICDF(29872), AOM_ICDF(31845),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(9170), AOM_ICDF(10655), AOM_ICDF(12439),
          AOM_ICDF(15550), AOM_ICDF(18128), AOM_ICDF(19565), AOM_ICDF(21412),
          AOM_ICDF(23355), AOM_ICDF(28007), AOM_ICDF(30080), AOM_ICDF(31568),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5504), AOM_ICDF(7636), AOM_ICDF(10174), AOM_ICDF(11056),
          AOM_ICDF(15562), AOM_ICDF(16252), AOM_ICDF(17931), AOM_ICDF(19598),
          AOM_ICDF(20967), AOM_ICDF(26845), AOM_ICDF(29149), AOM_ICDF(31490),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5248), AOM_ICDF(7810), AOM_ICDF(10004), AOM_ICDF(11015),
          AOM_ICDF(15359), AOM_ICDF(16310), AOM_ICDF(17834), AOM_ICDF(19185),
          AOM_ICDF(20903), AOM_ICDF(26728), AOM_ICDF(29585), AOM_ICDF(31478),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(7322), AOM_ICDF(10592), AOM_ICDF(11694),
          AOM_ICDF(15586), AOM_ICDF(16103), AOM_ICDF(17999), AOM_ICDF(19740),
          AOM_ICDF(20950), AOM_ICDF(26894), AOM_ICDF(28912), AOM_ICDF(31591),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4608), AOM_ICDF(7276), AOM_ICDF(12153), AOM_ICDF(13388),
          AOM_ICDF(16091), AOM_ICDF(17970), AOM_ICDF(19548), AOM_ICDF(21175),
          AOM_ICDF(22481), AOM_ICDF(26543), AOM_ICDF(28212), AOM_ICDF(29908),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(6656), AOM_ICDF(12225), AOM_ICDF(14441), AOM_ICDF(15158),
          AOM_ICDF(19600), AOM_ICDF(27127), AOM_ICDF(28221), AOM_ICDF(29186),
          AOM_ICDF(30439), AOM_ICDF(30913), AOM_ICDF(31135), AOM_ICDF(31238),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6400), AOM_ICDF(14608), AOM_ICDF(15920), AOM_ICDF(16643),
          AOM_ICDF(20149), AOM_ICDF(27328), AOM_ICDF(27896), AOM_ICDF(28672),
          AOM_ICDF(30227), AOM_ICDF(30778), AOM_ICDF(31053), AOM_ICDF(31120),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(6925), AOM_ICDF(14671), AOM_ICDF(15709),
          AOM_ICDF(19830), AOM_ICDF(24216), AOM_ICDF(25507), AOM_ICDF(27459),
          AOM_ICDF(28552), AOM_ICDF(29569), AOM_ICDF(29808), AOM_ICDF(30169),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(13604), AOM_ICDF(15202), AOM_ICDF(17530),
          AOM_ICDF(20878), AOM_ICDF(24279), AOM_ICDF(25278), AOM_ICDF(28255),
          AOM_ICDF(30651), AOM_ICDF(31170), AOM_ICDF(31343), AOM_ICDF(31410),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4608), AOM_ICDF(8535), AOM_ICDF(9588), AOM_ICDF(10740),
          AOM_ICDF(18673), AOM_ICDF(27664), AOM_ICDF(28826), AOM_ICDF(29828),
          AOM_ICDF(31081), AOM_ICDF(31503), AOM_ICDF(31680), AOM_ICDF(31778),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4864), AOM_ICDF(10543), AOM_ICDF(11313), AOM_ICDF(12197),
          AOM_ICDF(16785), AOM_ICDF(27858), AOM_ICDF(28556), AOM_ICDF(29480),
          AOM_ICDF(30892), AOM_ICDF(31486), AOM_ICDF(31722), AOM_ICDF(31787),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3968), AOM_ICDF(7492), AOM_ICDF(10283), AOM_ICDF(11318),
          AOM_ICDF(18486), AOM_ICDF(24061), AOM_ICDF(26761), AOM_ICDF(28456),
          AOM_ICDF(30126), AOM_ICDF(30872), AOM_ICDF(31088), AOM_ICDF(31305),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(10246), AOM_ICDF(12999), AOM_ICDF(15083),
          AOM_ICDF(18769), AOM_ICDF(22398), AOM_ICDF(23584), AOM_ICDF(27098),
          AOM_ICDF(29574), AOM_ICDF(30609), AOM_ICDF(30898), AOM_ICDF(31200),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7808), AOM_ICDF(13404), AOM_ICDF(14723), AOM_ICDF(16413),
          AOM_ICDF(20186), AOM_ICDF(24739), AOM_ICDF(25407), AOM_ICDF(27106),
          AOM_ICDF(29929), AOM_ICDF(30507), AOM_ICDF(30827), AOM_ICDF(30915),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2816), AOM_ICDF(6530), AOM_ICDF(8123), AOM_ICDF(9240),
          AOM_ICDF(12536), AOM_ICDF(17593), AOM_ICDF(18754), AOM_ICDF(20319),
          AOM_ICDF(22070), AOM_ICDF(27037), AOM_ICDF(29332), AOM_ICDF(30779),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2432), AOM_ICDF(6577), AOM_ICDF(8010), AOM_ICDF(9215),
          AOM_ICDF(12657), AOM_ICDF(18898), AOM_ICDF(19588), AOM_ICDF(20953),
          AOM_ICDF(22766), AOM_ICDF(27231), AOM_ICDF(29927), AOM_ICDF(31109),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3200), AOM_ICDF(6974), AOM_ICDF(9162), AOM_ICDF(10450),
          AOM_ICDF(13818), AOM_ICDF(17757), AOM_ICDF(19119), AOM_ICDF(20842),
          AOM_ICDF(22269), AOM_ICDF(27170), AOM_ICDF(29271), AOM_ICDF(30804),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(10689), AOM_ICDF(15307), AOM_ICDF(16589),
          AOM_ICDF(19738), AOM_ICDF(24416), AOM_ICDF(25332), AOM_ICDF(26541),
          AOM_ICDF(28634), AOM_ICDF(29711), AOM_ICDF(29913), AOM_ICDF(30116),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(9600), AOM_ICDF(11066), AOM_ICDF(15832), AOM_ICDF(16515),
          AOM_ICDF(18844), AOM_ICDF(19883), AOM_ICDF(24302), AOM_ICDF(25759),
          AOM_ICDF(26358), AOM_ICDF(29290), AOM_ICDF(30262), AOM_ICDF(31682),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8832), AOM_ICDF(12814), AOM_ICDF(16171), AOM_ICDF(17041),
          AOM_ICDF(19066), AOM_ICDF(20145), AOM_ICDF(22933), AOM_ICDF(24074),
          AOM_ICDF(25006), AOM_ICDF(28115), AOM_ICDF(29722), AOM_ICDF(30991),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(4486), AOM_ICDF(15821), AOM_ICDF(16330),
          AOM_ICDF(18461), AOM_ICDF(18879), AOM_ICDF(22436), AOM_ICDF(25051),
          AOM_ICDF(25443), AOM_ICDF(28637), AOM_ICDF(29396), AOM_ICDF(31412),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9856), AOM_ICDF(10863), AOM_ICDF(14050), AOM_ICDF(15920),
          AOM_ICDF(18783), AOM_ICDF(19531), AOM_ICDF(22502), AOM_ICDF(24577),
          AOM_ICDF(25361), AOM_ICDF(28559), AOM_ICDF(29600), AOM_ICDF(31336),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(7620), AOM_ICDF(10182), AOM_ICDF(11199),
          AOM_ICDF(17281), AOM_ICDF(19946), AOM_ICDF(23885), AOM_ICDF(25333),
          AOM_ICDF(26130), AOM_ICDF(29425), AOM_ICDF(30332), AOM_ICDF(31948),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9728), AOM_ICDF(11821), AOM_ICDF(13954), AOM_ICDF(15233),
          AOM_ICDF(19855), AOM_ICDF(24478), AOM_ICDF(28675), AOM_ICDF(29878),
          AOM_ICDF(31238), AOM_ICDF(31741), AOM_ICDF(31874), AOM_ICDF(32048),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(5753), AOM_ICDF(9673), AOM_ICDF(10149),
          AOM_ICDF(14343), AOM_ICDF(15190), AOM_ICDF(24967), AOM_ICDF(26378),
          AOM_ICDF(26841), AOM_ICDF(29749), AOM_ICDF(30527), AOM_ICDF(32120),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5888), AOM_ICDF(6606), AOM_ICDF(11498), AOM_ICDF(12538),
          AOM_ICDF(14737), AOM_ICDF(15425), AOM_ICDF(19549), AOM_ICDF(24047),
          AOM_ICDF(24765), AOM_ICDF(28711), AOM_ICDF(29822), AOM_ICDF(32138),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10368), AOM_ICDF(11757), AOM_ICDF(14126), AOM_ICDF(15474),
          AOM_ICDF(18311), AOM_ICDF(19358), AOM_ICDF(21539), AOM_ICDF(23451),
          AOM_ICDF(25034), AOM_ICDF(28791), AOM_ICDF(30035), AOM_ICDF(31280),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(7623), AOM_ICDF(11378), AOM_ICDF(12248),
          AOM_ICDF(15171), AOM_ICDF(15459), AOM_ICDF(18958), AOM_ICDF(20875),
          AOM_ICDF(21955), AOM_ICDF(27411), AOM_ICDF(29196), AOM_ICDF(31723),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(7469), AOM_ICDF(11399), AOM_ICDF(12323),
          AOM_ICDF(15165), AOM_ICDF(15528), AOM_ICDF(18804), AOM_ICDF(20769),
          AOM_ICDF(21767), AOM_ICDF(27129), AOM_ICDF(29435), AOM_ICDF(31502),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7040), AOM_ICDF(8295), AOM_ICDF(12298), AOM_ICDF(13035),
          AOM_ICDF(15194), AOM_ICDF(15357), AOM_ICDF(18976), AOM_ICDF(21100),
          AOM_ICDF(21805), AOM_ICDF(26978), AOM_ICDF(28342), AOM_ICDF(31763),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5632), AOM_ICDF(7465), AOM_ICDF(14220), AOM_ICDF(15035),
          AOM_ICDF(17014), AOM_ICDF(18105), AOM_ICDF(21111), AOM_ICDF(23027),
          AOM_ICDF(23934), AOM_ICDF(27207), AOM_ICDF(28293), AOM_ICDF(30330),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(11008), AOM_ICDF(13089), AOM_ICDF(17144), AOM_ICDF(18425),
          AOM_ICDF(19954), AOM_ICDF(20624), AOM_ICDF(21658), AOM_ICDF(24229),
          AOM_ICDF(25290), AOM_ICDF(28803), AOM_ICDF(29938), AOM_ICDF(31493),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(14218), AOM_ICDF(16378), AOM_ICDF(17699),
          AOM_ICDF(18935), AOM_ICDF(19928), AOM_ICDF(20524), AOM_ICDF(22781),
          AOM_ICDF(24155), AOM_ICDF(27523), AOM_ICDF(29068), AOM_ICDF(30270),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6144), AOM_ICDF(7194), AOM_ICDF(17912), AOM_ICDF(18991),
          AOM_ICDF(19879), AOM_ICDF(20151), AOM_ICDF(21170), AOM_ICDF(23938),
          AOM_ICDF(24712), AOM_ICDF(27763), AOM_ICDF(28556), AOM_ICDF(30584),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10496), AOM_ICDF(11614), AOM_ICDF(13652), AOM_ICDF(16928),
          AOM_ICDF(18425), AOM_ICDF(18967), AOM_ICDF(19724), AOM_ICDF(23817),
          AOM_ICDF(25594), AOM_ICDF(28685), AOM_ICDF(29734), AOM_ICDF(30941),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7296), AOM_ICDF(8915), AOM_ICDF(11163), AOM_ICDF(13821),
          AOM_ICDF(16951), AOM_ICDF(18507), AOM_ICDF(20180), AOM_ICDF(22423),
          AOM_ICDF(24017), AOM_ICDF(28294), AOM_ICDF(29614), AOM_ICDF(31673),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9728), AOM_ICDF(13441), AOM_ICDF(15858), AOM_ICDF(18860),
          AOM_ICDF(21713), AOM_ICDF(24478), AOM_ICDF(25995), AOM_ICDF(28233),
          AOM_ICDF(30347), AOM_ICDF(30853), AOM_ICDF(31081), AOM_ICDF(31328),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6400), AOM_ICDF(7480), AOM_ICDF(11482), AOM_ICDF(13206),
          AOM_ICDF(16199), AOM_ICDF(16908), AOM_ICDF(20436), AOM_ICDF(23507),
          AOM_ICDF(24650), AOM_ICDF(28360), AOM_ICDF(29438), AOM_ICDF(31532),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9856), AOM_ICDF(10979), AOM_ICDF(13430), AOM_ICDF(15195),
          AOM_ICDF(15957), AOM_ICDF(16350), AOM_ICDF(16871), AOM_ICDF(26198),
          AOM_ICDF(26991), AOM_ICDF(29612), AOM_ICDF(30438), AOM_ICDF(31962),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(10529), AOM_ICDF(12640), AOM_ICDF(15350),
          AOM_ICDF(16987), AOM_ICDF(17859), AOM_ICDF(18590), AOM_ICDF(21400),
          AOM_ICDF(23812), AOM_ICDF(28188), AOM_ICDF(29589), AOM_ICDF(31280),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(8877), AOM_ICDF(12393), AOM_ICDF(14015),
          AOM_ICDF(15655), AOM_ICDF(15794), AOM_ICDF(16814), AOM_ICDF(19923),
          AOM_ICDF(21086), AOM_ICDF(26723), AOM_ICDF(28669), AOM_ICDF(31468),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6400), AOM_ICDF(8900), AOM_ICDF(12241), AOM_ICDF(13828),
          AOM_ICDF(15513), AOM_ICDF(15671), AOM_ICDF(16500), AOM_ICDF(19257),
          AOM_ICDF(20456), AOM_ICDF(25984), AOM_ICDF(28658), AOM_ICDF(31017),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7296), AOM_ICDF(8820), AOM_ICDF(12885), AOM_ICDF(14441),
          AOM_ICDF(15813), AOM_ICDF(15911), AOM_ICDF(16954), AOM_ICDF(20026),
          AOM_ICDF(20950), AOM_ICDF(26563), AOM_ICDF(28140), AOM_ICDF(31673),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(8455), AOM_ICDF(13328), AOM_ICDF(15907),
          AOM_ICDF(17026), AOM_ICDF(17464), AOM_ICDF(18267), AOM_ICDF(21436),
          AOM_ICDF(22712), AOM_ICDF(26403), AOM_ICDF(27660), AOM_ICDF(29559),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(6784), AOM_ICDF(11216), AOM_ICDF(13269), AOM_ICDF(15677),
          AOM_ICDF(16931), AOM_ICDF(18445), AOM_ICDF(19097), AOM_ICDF(20082),
          AOM_ICDF(24298), AOM_ICDF(28236), AOM_ICDF(30118), AOM_ICDF(31448),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(13240), AOM_ICDF(14110), AOM_ICDF(16966),
          AOM_ICDF(17743), AOM_ICDF(18916), AOM_ICDF(19281), AOM_ICDF(19848),
          AOM_ICDF(25552), AOM_ICDF(28646), AOM_ICDF(30444), AOM_ICDF(31291),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4352), AOM_ICDF(6870), AOM_ICDF(14660), AOM_ICDF(16597),
          AOM_ICDF(17361), AOM_ICDF(18126), AOM_ICDF(18852), AOM_ICDF(20765),
          AOM_ICDF(23526), AOM_ICDF(27670), AOM_ICDF(29096), AOM_ICDF(31214),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9472), AOM_ICDF(11736), AOM_ICDF(13172), AOM_ICDF(18192),
          AOM_ICDF(19070), AOM_ICDF(19651), AOM_ICDF(19991), AOM_ICDF(21793),
          AOM_ICDF(26005), AOM_ICDF(29291), AOM_ICDF(30500), AOM_ICDF(31767),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(7252), AOM_ICDF(8651), AOM_ICDF(12379),
          AOM_ICDF(14936), AOM_ICDF(17493), AOM_ICDF(18326), AOM_ICDF(19527),
          AOM_ICDF(23655), AOM_ICDF(28031), AOM_ICDF(29960), AOM_ICDF(31773),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(11561), AOM_ICDF(12864), AOM_ICDF(15793),
          AOM_ICDF(18765), AOM_ICDF(23040), AOM_ICDF(23640), AOM_ICDF(24415),
          AOM_ICDF(31040), AOM_ICDF(31473), AOM_ICDF(31740), AOM_ICDF(31827),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(6825), AOM_ICDF(8810), AOM_ICDF(11269),
          AOM_ICDF(14257), AOM_ICDF(15716), AOM_ICDF(18397), AOM_ICDF(20006),
          AOM_ICDF(24020), AOM_ICDF(28230), AOM_ICDF(29780), AOM_ICDF(31773),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(9466), AOM_ICDF(11717), AOM_ICDF(15159),
          AOM_ICDF(16237), AOM_ICDF(17145), AOM_ICDF(17814), AOM_ICDF(21258),
          AOM_ICDF(24754), AOM_ICDF(28864), AOM_ICDF(30313), AOM_ICDF(32061),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7680), AOM_ICDF(10517), AOM_ICDF(11381), AOM_ICDF(16202),
          AOM_ICDF(16809), AOM_ICDF(17425), AOM_ICDF(17774), AOM_ICDF(18764),
          AOM_ICDF(26842), AOM_ICDF(29600), AOM_ICDF(31073), AOM_ICDF(31886),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4992), AOM_ICDF(8626), AOM_ICDF(10531), AOM_ICDF(13103),
          AOM_ICDF(14495), AOM_ICDF(14784), AOM_ICDF(15365), AOM_ICDF(16657),
          AOM_ICDF(21051), AOM_ICDF(27011), AOM_ICDF(29685), AOM_ICDF(31574),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4736), AOM_ICDF(9433), AOM_ICDF(10981), AOM_ICDF(13494),
          AOM_ICDF(14644), AOM_ICDF(15043), AOM_ICDF(15396), AOM_ICDF(16378),
          AOM_ICDF(21506), AOM_ICDF(26869), AOM_ICDF(29824), AOM_ICDF(31454),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(9526), AOM_ICDF(11905), AOM_ICDF(14476),
          AOM_ICDF(15722), AOM_ICDF(16103), AOM_ICDF(16768), AOM_ICDF(18070),
          AOM_ICDF(21630), AOM_ICDF(27401), AOM_ICDF(29592), AOM_ICDF(31818),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(9947), AOM_ICDF(12386), AOM_ICDF(15909),
          AOM_ICDF(16496), AOM_ICDF(17397), AOM_ICDF(17866), AOM_ICDF(18927),
          AOM_ICDF(24408), AOM_ICDF(27750), AOM_ICDF(29614), AOM_ICDF(30889),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(7424), AOM_ICDF(10538), AOM_ICDF(14098), AOM_ICDF(14891),
          AOM_ICDF(16486), AOM_ICDF(16756), AOM_ICDF(17607), AOM_ICDF(18952),
          AOM_ICDF(20168), AOM_ICDF(26275), AOM_ICDF(28617), AOM_ICDF(31580),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(13070), AOM_ICDF(14969), AOM_ICDF(15848),
          AOM_ICDF(17197), AOM_ICDF(17447), AOM_ICDF(17954), AOM_ICDF(18747),
          AOM_ICDF(20137), AOM_ICDF(25628), AOM_ICDF(28753), AOM_ICDF(30628),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3584), AOM_ICDF(5287), AOM_ICDF(16141), AOM_ICDF(16840),
          AOM_ICDF(17670), AOM_ICDF(17760), AOM_ICDF(18532), AOM_ICDF(20387),
          AOM_ICDF(21102), AOM_ICDF(26118), AOM_ICDF(27535), AOM_ICDF(30830),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(9594), AOM_ICDF(11770), AOM_ICDF(14505),
          AOM_ICDF(16234), AOM_ICDF(16365), AOM_ICDF(17201), AOM_ICDF(20286),
          AOM_ICDF(22128), AOM_ICDF(27371), AOM_ICDF(29426), AOM_ICDF(31580),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5632), AOM_ICDF(8393), AOM_ICDF(10566), AOM_ICDF(11917),
          AOM_ICDF(16025), AOM_ICDF(16697), AOM_ICDF(18123), AOM_ICDF(19541),
          AOM_ICDF(21135), AOM_ICDF(27059), AOM_ICDF(29325), AOM_ICDF(31814),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(7916), AOM_ICDF(9526), AOM_ICDF(11010),
          AOM_ICDF(14114), AOM_ICDF(18169), AOM_ICDF(19510), AOM_ICDF(21031),
          AOM_ICDF(23083), AOM_ICDF(27769), AOM_ICDF(29782), AOM_ICDF(31299),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(7338), AOM_ICDF(10657), AOM_ICDF(11699),
          AOM_ICDF(14780), AOM_ICDF(15070), AOM_ICDF(18291), AOM_ICDF(20170),
          AOM_ICDF(21347), AOM_ICDF(26985), AOM_ICDF(28811), AOM_ICDF(31805),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5632), AOM_ICDF(7669), AOM_ICDF(11558), AOM_ICDF(12653),
          AOM_ICDF(13962), AOM_ICDF(14116), AOM_ICDF(15074), AOM_ICDF(19886),
          AOM_ICDF(21123), AOM_ICDF(26953), AOM_ICDF(28755), AOM_ICDF(31708),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(9739), AOM_ICDF(11612), AOM_ICDF(13211),
          AOM_ICDF(14992), AOM_ICDF(15237), AOM_ICDF(16016), AOM_ICDF(17677),
          AOM_ICDF(20588), AOM_ICDF(26647), AOM_ICDF(29116), AOM_ICDF(31435),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(8346), AOM_ICDF(11022), AOM_ICDF(11976),
          AOM_ICDF(13541), AOM_ICDF(13749), AOM_ICDF(14520), AOM_ICDF(16173),
          AOM_ICDF(17567), AOM_ICDF(25182), AOM_ICDF(28111), AOM_ICDF(31591),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4736), AOM_ICDF(8894), AOM_ICDF(11294), AOM_ICDF(12220),
          AOM_ICDF(13753), AOM_ICDF(14029), AOM_ICDF(14645), AOM_ICDF(16065),
          AOM_ICDF(17621), AOM_ICDF(24911), AOM_ICDF(28655), AOM_ICDF(31344),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(8193), AOM_ICDF(11667), AOM_ICDF(12461),
          AOM_ICDF(13880), AOM_ICDF(14040), AOM_ICDF(14946), AOM_ICDF(16537),
          AOM_ICDF(17642), AOM_ICDF(25117), AOM_ICDF(27333), AOM_ICDF(31713),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4096), AOM_ICDF(8479), AOM_ICDF(13751), AOM_ICDF(14813),
          AOM_ICDF(15994), AOM_ICDF(16157), AOM_ICDF(16905), AOM_ICDF(18314),
          AOM_ICDF(19575), AOM_ICDF(25132), AOM_ICDF(27445), AOM_ICDF(30192),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(7936), AOM_ICDF(12263), AOM_ICDF(15558), AOM_ICDF(16331),
          AOM_ICDF(17779), AOM_ICDF(18148), AOM_ICDF(18810), AOM_ICDF(19794),
          AOM_ICDF(21046), AOM_ICDF(26644), AOM_ICDF(29417), AOM_ICDF(31507),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(15025), AOM_ICDF(16457), AOM_ICDF(17074),
          AOM_ICDF(18079), AOM_ICDF(18299), AOM_ICDF(18648), AOM_ICDF(19240),
          AOM_ICDF(20612), AOM_ICDF(25687), AOM_ICDF(29392), AOM_ICDF(30842),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(6037), AOM_ICDF(17465), AOM_ICDF(18089),
          AOM_ICDF(18869), AOM_ICDF(18953), AOM_ICDF(19688), AOM_ICDF(21223),
          AOM_ICDF(21816), AOM_ICDF(26562), AOM_ICDF(28195), AOM_ICDF(30621),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(11255), AOM_ICDF(13307), AOM_ICDF(15676),
          AOM_ICDF(17392), AOM_ICDF(17603), AOM_ICDF(18268), AOM_ICDF(20783),
          AOM_ICDF(22646), AOM_ICDF(27628), AOM_ICDF(29737), AOM_ICDF(31628),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(9119), AOM_ICDF(11015), AOM_ICDF(12269),
          AOM_ICDF(16280), AOM_ICDF(17023), AOM_ICDF(18282), AOM_ICDF(19418),
          AOM_ICDF(21325), AOM_ICDF(27309), AOM_ICDF(30004), AOM_ICDF(31818),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3968), AOM_ICDF(9094), AOM_ICDF(10606), AOM_ICDF(12007),
          AOM_ICDF(14218), AOM_ICDF(18911), AOM_ICDF(20089), AOM_ICDF(20924),
          AOM_ICDF(23587), AOM_ICDF(27808), AOM_ICDF(30253), AOM_ICDF(31305),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(8627), AOM_ICDF(11201), AOM_ICDF(12200),
          AOM_ICDF(15305), AOM_ICDF(15671), AOM_ICDF(18639), AOM_ICDF(20185),
          AOM_ICDF(21627), AOM_ICDF(26990), AOM_ICDF(29449), AOM_ICDF(31723),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6272), AOM_ICDF(8768), AOM_ICDF(12320), AOM_ICDF(13296),
          AOM_ICDF(14643), AOM_ICDF(14970), AOM_ICDF(15760), AOM_ICDF(20545),
          AOM_ICDF(21863), AOM_ICDF(27473), AOM_ICDF(29535), AOM_ICDF(31836),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(10905), AOM_ICDF(12656), AOM_ICDF(14084),
          AOM_ICDF(15705), AOM_ICDF(16069), AOM_ICDF(16674), AOM_ICDF(17779),
          AOM_ICDF(21041), AOM_ICDF(26586), AOM_ICDF(29539), AOM_ICDF(31253),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5248), AOM_ICDF(9672), AOM_ICDF(12113), AOM_ICDF(12871),
          AOM_ICDF(14423), AOM_ICDF(14710), AOM_ICDF(15376), AOM_ICDF(16708),
          AOM_ICDF(18092), AOM_ICDF(25260), AOM_ICDF(28991), AOM_ICDF(31585),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4736), AOM_ICDF(10789), AOM_ICDF(13029), AOM_ICDF(13750),
          AOM_ICDF(15040), AOM_ICDF(15385), AOM_ICDF(15840), AOM_ICDF(16887),
          AOM_ICDF(18393), AOM_ICDF(25230), AOM_ICDF(29558), AOM_ICDF(31454),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(9916), AOM_ICDF(12938), AOM_ICDF(13741),
          AOM_ICDF(15030), AOM_ICDF(15297), AOM_ICDF(16116), AOM_ICDF(17333),
          AOM_ICDF(18672), AOM_ICDF(25954), AOM_ICDF(28498), AOM_ICDF(31618),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4608), AOM_ICDF(10266), AOM_ICDF(15450), AOM_ICDF(16299),
          AOM_ICDF(17114), AOM_ICDF(17288), AOM_ICDF(17775), AOM_ICDF(18835),
          AOM_ICDF(20227), AOM_ICDF(25199), AOM_ICDF(28098), AOM_ICDF(30018),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(7296), AOM_ICDF(9951), AOM_ICDF(14124), AOM_ICDF(14806),
          AOM_ICDF(16181), AOM_ICDF(16377), AOM_ICDF(17485), AOM_ICDF(19069),
          AOM_ICDF(20078), AOM_ICDF(26051), AOM_ICDF(27777), AOM_ICDF(31574),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(13823), AOM_ICDF(15889), AOM_ICDF(16620),
          AOM_ICDF(17709), AOM_ICDF(17881), AOM_ICDF(18327), AOM_ICDF(19140),
          AOM_ICDF(20374), AOM_ICDF(25685), AOM_ICDF(28160), AOM_ICDF(30521),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3200), AOM_ICDF(4602), AOM_ICDF(16404), AOM_ICDF(17042),
          AOM_ICDF(17780), AOM_ICDF(17829), AOM_ICDF(18706), AOM_ICDF(20608),
          AOM_ICDF(21115), AOM_ICDF(25884), AOM_ICDF(26960), AOM_ICDF(30804),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7040), AOM_ICDF(9444), AOM_ICDF(11770), AOM_ICDF(14321),
          AOM_ICDF(15951), AOM_ICDF(16074), AOM_ICDF(17033), AOM_ICDF(20352),
          AOM_ICDF(22301), AOM_ICDF(27567), AOM_ICDF(29151), AOM_ICDF(31662),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6016), AOM_ICDF(8316), AOM_ICDF(10849), AOM_ICDF(12136),
          AOM_ICDF(15860), AOM_ICDF(16430), AOM_ICDF(17935), AOM_ICDF(19659),
          AOM_ICDF(21083), AOM_ICDF(26968), AOM_ICDF(28839), AOM_ICDF(31618),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(7472), AOM_ICDF(9436), AOM_ICDF(11038),
          AOM_ICDF(13625), AOM_ICDF(17596), AOM_ICDF(18959), AOM_ICDF(20543),
          AOM_ICDF(22879), AOM_ICDF(27487), AOM_ICDF(29351), AOM_ICDF(31186),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(7117), AOM_ICDF(11424), AOM_ICDF(12381),
          AOM_ICDF(14823), AOM_ICDF(15053), AOM_ICDF(18656), AOM_ICDF(20818),
          AOM_ICDF(21722), AOM_ICDF(27042), AOM_ICDF(28233), AOM_ICDF(31591),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(7281), AOM_ICDF(11910), AOM_ICDF(12912),
          AOM_ICDF(14229), AOM_ICDF(14391), AOM_ICDF(15474), AOM_ICDF(20113),
          AOM_ICDF(21128), AOM_ICDF(26627), AOM_ICDF(28077), AOM_ICDF(31713),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(9452), AOM_ICDF(11526), AOM_ICDF(13288),
          AOM_ICDF(14861), AOM_ICDF(15062), AOM_ICDF(15909), AOM_ICDF(17695),
          AOM_ICDF(20429), AOM_ICDF(26225), AOM_ICDF(28603), AOM_ICDF(31340),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5376), AOM_ICDF(7722), AOM_ICDF(10921), AOM_ICDF(11813),
          AOM_ICDF(13222), AOM_ICDF(13348), AOM_ICDF(14211), AOM_ICDF(15976),
          AOM_ICDF(17110), AOM_ICDF(24634), AOM_ICDF(27176), AOM_ICDF(31484),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4736), AOM_ICDF(8226), AOM_ICDF(11137), AOM_ICDF(11988),
          AOM_ICDF(13518), AOM_ICDF(13706), AOM_ICDF(14332), AOM_ICDF(16016),
          AOM_ICDF(17301), AOM_ICDF(24641), AOM_ICDF(27704), AOM_ICDF(31016),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(7592), AOM_ICDF(11880), AOM_ICDF(12612),
          AOM_ICDF(13738), AOM_ICDF(13813), AOM_ICDF(14681), AOM_ICDF(16392),
          AOM_ICDF(17306), AOM_ICDF(24619), AOM_ICDF(26334), AOM_ICDF(31818),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4096), AOM_ICDF(8524), AOM_ICDF(14316), AOM_ICDF(15392),
          AOM_ICDF(16295), AOM_ICDF(16433), AOM_ICDF(17197), AOM_ICDF(18718),
          AOM_ICDF(19924), AOM_ICDF(25123), AOM_ICDF(26953), AOM_ICDF(29856),
          AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(6528), AOM_ICDF(13383), AOM_ICDF(17642), AOM_ICDF(18342),
          AOM_ICDF(19224), AOM_ICDF(20209), AOM_ICDF(20899), AOM_ICDF(21944),
          AOM_ICDF(23137), AOM_ICDF(25966), AOM_ICDF(27429), AOM_ICDF(28463),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4480), AOM_ICDF(16901), AOM_ICDF(18876), AOM_ICDF(19560),
          AOM_ICDF(20257), AOM_ICDF(20912), AOM_ICDF(21169), AOM_ICDF(21959),
          AOM_ICDF(23036), AOM_ICDF(25781), AOM_ICDF(27676), AOM_ICDF(28569),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2688), AOM_ICDF(5337), AOM_ICDF(18178), AOM_ICDF(18829),
          AOM_ICDF(19344), AOM_ICDF(19628), AOM_ICDF(20267), AOM_ICDF(22135),
          AOM_ICDF(22671), AOM_ICDF(25817), AOM_ICDF(26914), AOM_ICDF(28773),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8192), AOM_ICDF(11378), AOM_ICDF(14742), AOM_ICDF(17269),
          AOM_ICDF(18230), AOM_ICDF(19001), AOM_ICDF(19655), AOM_ICDF(22949),
          AOM_ICDF(24337), AOM_ICDF(28025), AOM_ICDF(29503), AOM_ICDF(30848),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(10133), AOM_ICDF(13144), AOM_ICDF(14374),
          AOM_ICDF(17020), AOM_ICDF(18920), AOM_ICDF(20235), AOM_ICDF(21677),
          AOM_ICDF(23142), AOM_ICDF(27131), AOM_ICDF(28671), AOM_ICDF(30284),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(15588), AOM_ICDF(18431), AOM_ICDF(19723),
          AOM_ICDF(21455), AOM_ICDF(24705), AOM_ICDF(25461), AOM_ICDF(26753),
          AOM_ICDF(28923), AOM_ICDF(29475), AOM_ICDF(29729), AOM_ICDF(29897),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4224), AOM_ICDF(8689), AOM_ICDF(13024), AOM_ICDF(13658),
          AOM_ICDF(16637), AOM_ICDF(17307), AOM_ICDF(20836), AOM_ICDF(22665),
          AOM_ICDF(23673), AOM_ICDF(27015), AOM_ICDF(28310), AOM_ICDF(30203),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5120), AOM_ICDF(7896), AOM_ICDF(13618), AOM_ICDF(14900),
          AOM_ICDF(15708), AOM_ICDF(16153), AOM_ICDF(16997), AOM_ICDF(23625),
          AOM_ICDF(24466), AOM_ICDF(27719), AOM_ICDF(28892), AOM_ICDF(30500),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5760), AOM_ICDF(11305), AOM_ICDF(13669), AOM_ICDF(15462),
          AOM_ICDF(16564), AOM_ICDF(17683), AOM_ICDF(18252), AOM_ICDF(20073),
          AOM_ICDF(22917), AOM_ICDF(27005), AOM_ICDF(28923), AOM_ICDF(30236),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4224), AOM_ICDF(9510), AOM_ICDF(13787), AOM_ICDF(14587),
          AOM_ICDF(15753), AOM_ICDF(15925), AOM_ICDF(16513), AOM_ICDF(18193),
          AOM_ICDF(19490), AOM_ICDF(24944), AOM_ICDF(27482), AOM_ICDF(29757),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3840), AOM_ICDF(10052), AOM_ICDF(14106), AOM_ICDF(14887),
          AOM_ICDF(15827), AOM_ICDF(15996), AOM_ICDF(16522), AOM_ICDF(17939),
          AOM_ICDF(19204), AOM_ICDF(24508), AOM_ICDF(27661), AOM_ICDF(29491),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(4736), AOM_ICDF(9676), AOM_ICDF(14492), AOM_ICDF(15163),
          AOM_ICDF(16179), AOM_ICDF(16390), AOM_ICDF(17133), AOM_ICDF(18905),
          AOM_ICDF(19864), AOM_ICDF(25185), AOM_ICDF(27191), AOM_ICDF(30030),
          AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(3584), AOM_ICDF(9370), AOM_ICDF(14746), AOM_ICDF(15820),
          AOM_ICDF(16708), AOM_ICDF(17224), AOM_ICDF(17718), AOM_ICDF(19329),
          AOM_ICDF(20405), AOM_ICDF(23541), AOM_ICDF(25258), AOM_ICDF(26726),
          AOM_ICDF(32768), 0,
      },
  },
#else
  {
      {
          AOM_ICDF(15488), AOM_ICDF(18706), AOM_ICDF(22561), AOM_ICDF(23619),
          AOM_ICDF(24954), AOM_ICDF(25782), AOM_ICDF(26710), AOM_ICDF(27861),
          AOM_ICDF(28656), AOM_ICDF(30743), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11648), AOM_ICDF(18744), AOM_ICDF(20846), AOM_ICDF(22100),
          AOM_ICDF(23332), AOM_ICDF(24337), AOM_ICDF(25093), AOM_ICDF(26104),
          AOM_ICDF(27097), AOM_ICDF(29633), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(10732), AOM_ICDF(22507), AOM_ICDF(23254),
          AOM_ICDF(24382), AOM_ICDF(24876), AOM_ICDF(25827), AOM_ICDF(27488),
          AOM_ICDF(28040), AOM_ICDF(30108), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(13568), AOM_ICDF(16981), AOM_ICDF(19885), AOM_ICDF(22014),
          AOM_ICDF(23543), AOM_ICDF(24658), AOM_ICDF(25641), AOM_ICDF(27378),
          AOM_ICDF(28625), AOM_ICDF(31043), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(12225), AOM_ICDF(14408), AOM_ICDF(16033),
          AOM_ICDF(19544), AOM_ICDF(22318), AOM_ICDF(23960), AOM_ICDF(25617),
          AOM_ICDF(26522), AOM_ICDF(30596), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12160), AOM_ICDF(15078), AOM_ICDF(16990), AOM_ICDF(18964),
          AOM_ICDF(22725), AOM_ICDF(25793), AOM_ICDF(27133), AOM_ICDF(28447),
          AOM_ICDF(30831), AOM_ICDF(30836), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(11274), AOM_ICDF(15818), AOM_ICDF(16940),
          AOM_ICDF(21178), AOM_ICDF(22338), AOM_ICDF(26171), AOM_ICDF(27754),
          AOM_ICDF(28503), AOM_ICDF(31473), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10880), AOM_ICDF(13846), AOM_ICDF(18649), AOM_ICDF(20252),
          AOM_ICDF(22157), AOM_ICDF(22992), AOM_ICDF(24396), AOM_ICDF(27581),
          AOM_ICDF(28501), AOM_ICDF(31400), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11008), AOM_ICDF(13462), AOM_ICDF(15747), AOM_ICDF(18378),
          AOM_ICDF(20085), AOM_ICDF(21663), AOM_ICDF(22766), AOM_ICDF(24635),
          AOM_ICDF(27476), AOM_ICDF(30643), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10112), AOM_ICDF(13147), AOM_ICDF(16135), AOM_ICDF(17577),
          AOM_ICDF(19681), AOM_ICDF(19689), AOM_ICDF(20856), AOM_ICDF(22374),
          AOM_ICDF(24454), AOM_ICDF(30555), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(12176), AOM_ICDF(17582), AOM_ICDF(18905),
          AOM_ICDF(19994), AOM_ICDF(20669), AOM_ICDF(21635), AOM_ICDF(23564),
          AOM_ICDF(24741), AOM_ICDF(27222), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(8448), AOM_ICDF(18738), AOM_ICDF(21694), AOM_ICDF(22413),
          AOM_ICDF(23358), AOM_ICDF(24675), AOM_ICDF(25193), AOM_ICDF(26119),
          AOM_ICDF(27310), AOM_ICDF(30773), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(22027), AOM_ICDF(23242), AOM_ICDF(23986),
          AOM_ICDF(24529), AOM_ICDF(25363), AOM_ICDF(25646), AOM_ICDF(26087),
          AOM_ICDF(27130), AOM_ICDF(30218), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(13862), AOM_ICDF(21137), AOM_ICDF(22124),
          AOM_ICDF(23036), AOM_ICDF(23803), AOM_ICDF(24458), AOM_ICDF(26390),
          AOM_ICDF(27342), AOM_ICDF(30968), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(17409), AOM_ICDF(19830), AOM_ICDF(21521),
          AOM_ICDF(22580), AOM_ICDF(23726), AOM_ICDF(24377), AOM_ICDF(25679),
          AOM_ICDF(27269), AOM_ICDF(30867), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(15832), AOM_ICDF(17559), AOM_ICDF(18777),
          AOM_ICDF(20425), AOM_ICDF(22719), AOM_ICDF(23447), AOM_ICDF(24952),
          AOM_ICDF(26527), AOM_ICDF(30950), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7808), AOM_ICDF(18730), AOM_ICDF(20143), AOM_ICDF(21445),
          AOM_ICDF(23347), AOM_ICDF(26267), AOM_ICDF(27229), AOM_ICDF(28315),
          AOM_ICDF(30911), AOM_ICDF(30915), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(14299), AOM_ICDF(17264), AOM_ICDF(18505),
          AOM_ICDF(20765), AOM_ICDF(22440), AOM_ICDF(24331), AOM_ICDF(26038),
          AOM_ICDF(27481), AOM_ICDF(31448), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8832), AOM_ICDF(15726), AOM_ICDF(19455), AOM_ICDF(20668),
          AOM_ICDF(21607), AOM_ICDF(22655), AOM_ICDF(23384), AOM_ICDF(26356),
          AOM_ICDF(27697), AOM_ICDF(31459), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8192), AOM_ICDF(17385), AOM_ICDF(18866), AOM_ICDF(20120),
          AOM_ICDF(21273), AOM_ICDF(22853), AOM_ICDF(23470), AOM_ICDF(24881),
          AOM_ICDF(27216), AOM_ICDF(31040), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(16341), AOM_ICDF(18497), AOM_ICDF(19439),
          AOM_ICDF(20706), AOM_ICDF(20711), AOM_ICDF(21234), AOM_ICDF(22307),
          AOM_ICDF(23950), AOM_ICDF(30728), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6400), AOM_ICDF(17625), AOM_ICDF(20326), AOM_ICDF(21821),
          AOM_ICDF(22568), AOM_ICDF(23415), AOM_ICDF(23854), AOM_ICDF(24896),
          AOM_ICDF(26171), AOM_ICDF(29575), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(12032), AOM_ICDF(14259), AOM_ICDF(22597), AOM_ICDF(23443),
          AOM_ICDF(24581), AOM_ICDF(25079), AOM_ICDF(26399), AOM_ICDF(27862),
          AOM_ICDF(28509), AOM_ICDF(30419), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9216), AOM_ICDF(14883), AOM_ICDF(20941), AOM_ICDF(21958),
          AOM_ICDF(23597), AOM_ICDF(24328), AOM_ICDF(25208), AOM_ICDF(26590),
          AOM_ICDF(27377), AOM_ICDF(29364), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(8088), AOM_ICDF(24407), AOM_ICDF(25006),
          AOM_ICDF(25777), AOM_ICDF(25950), AOM_ICDF(26882), AOM_ICDF(28811),
          AOM_ICDF(29159), AOM_ICDF(30636), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11904), AOM_ICDF(14425), AOM_ICDF(18729), AOM_ICDF(20730),
          AOM_ICDF(21998), AOM_ICDF(22686), AOM_ICDF(23856), AOM_ICDF(26580),
          AOM_ICDF(27613), AOM_ICDF(29834), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10752), AOM_ICDF(12784), AOM_ICDF(16305), AOM_ICDF(17624),
          AOM_ICDF(20320), AOM_ICDF(22450), AOM_ICDF(24380), AOM_ICDF(26773),
          AOM_ICDF(27837), AOM_ICDF(30016), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10496), AOM_ICDF(14090), AOM_ICDF(18314), AOM_ICDF(20621),
          AOM_ICDF(23539), AOM_ICDF(25261), AOM_ICDF(26953), AOM_ICDF(28692),
          AOM_ICDF(30064), AOM_ICDF(30071), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(10229), AOM_ICDF(16542), AOM_ICDF(17725),
          AOM_ICDF(21504), AOM_ICDF(22332), AOM_ICDF(26006), AOM_ICDF(27895),
          AOM_ICDF(28487), AOM_ICDF(31248), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9728), AOM_ICDF(11162), AOM_ICDF(19379), AOM_ICDF(20981),
          AOM_ICDF(22356), AOM_ICDF(22926), AOM_ICDF(24318), AOM_ICDF(28364),
          AOM_ICDF(29020), AOM_ICDF(31328), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9216), AOM_ICDF(10861), AOM_ICDF(14850), AOM_ICDF(16471),
          AOM_ICDF(18611), AOM_ICDF(19674), AOM_ICDF(21009), AOM_ICDF(23454),
          AOM_ICDF(26078), AOM_ICDF(29272), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7808), AOM_ICDF(10132), AOM_ICDF(17327), AOM_ICDF(18472),
          AOM_ICDF(20126), AOM_ICDF(20132), AOM_ICDF(21599), AOM_ICDF(23338),
          AOM_ICDF(24514), AOM_ICDF(29843), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(9210), AOM_ICDF(19309), AOM_ICDF(20715),
          AOM_ICDF(21833), AOM_ICDF(22262), AOM_ICDF(23353), AOM_ICDF(24942),
          AOM_ICDF(25800), AOM_ICDF(28200), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(12288), AOM_ICDF(15040), AOM_ICDF(18401), AOM_ICDF(21071),
          AOM_ICDF(22800), AOM_ICDF(23945), AOM_ICDF(25274), AOM_ICDF(26939),
          AOM_ICDF(28554), AOM_ICDF(31328), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9344), AOM_ICDF(17170), AOM_ICDF(19325), AOM_ICDF(22119),
          AOM_ICDF(23284), AOM_ICDF(24378), AOM_ICDF(24911), AOM_ICDF(26095),
          AOM_ICDF(27781), AOM_ICDF(31121), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9344), AOM_ICDF(11650), AOM_ICDF(19788), AOM_ICDF(21928),
          AOM_ICDF(22916), AOM_ICDF(23571), AOM_ICDF(24362), AOM_ICDF(26633),
          AOM_ICDF(27946), AOM_ICDF(31212), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12928), AOM_ICDF(14428), AOM_ICDF(17080), AOM_ICDF(20882),
          AOM_ICDF(22104), AOM_ICDF(23149), AOM_ICDF(23715), AOM_ICDF(27167),
          AOM_ICDF(28932), AOM_ICDF(31218), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(11962), AOM_ICDF(13849), AOM_ICDF(16880),
          AOM_ICDF(19818), AOM_ICDF(21895), AOM_ICDF(23000), AOM_ICDF(25923),
          AOM_ICDF(27961), AOM_ICDF(31380), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10240), AOM_ICDF(13336), AOM_ICDF(15505), AOM_ICDF(18844),
          AOM_ICDF(21646), AOM_ICDF(24723), AOM_ICDF(25832), AOM_ICDF(27802),
          AOM_ICDF(31088), AOM_ICDF(31096), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(10683), AOM_ICDF(14446), AOM_ICDF(17035),
          AOM_ICDF(20211), AOM_ICDF(21577), AOM_ICDF(24370), AOM_ICDF(26477),
          AOM_ICDF(28223), AOM_ICDF(31734), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12928), AOM_ICDF(17358), AOM_ICDF(19982), AOM_ICDF(22123),
          AOM_ICDF(23335), AOM_ICDF(23948), AOM_ICDF(24890), AOM_ICDF(28884),
          AOM_ICDF(30197), AOM_ICDF(32148), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10496), AOM_ICDF(12429), AOM_ICDF(16401), AOM_ICDF(20493),
          AOM_ICDF(21471), AOM_ICDF(22433), AOM_ICDF(23162), AOM_ICDF(24686),
          AOM_ICDF(29027), AOM_ICDF(31115), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(12157), AOM_ICDF(14796), AOM_ICDF(17676),
          AOM_ICDF(19754), AOM_ICDF(19762), AOM_ICDF(20641), AOM_ICDF(23274),
          AOM_ICDF(25569), AOM_ICDF(31058), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7296), AOM_ICDF(11083), AOM_ICDF(15313), AOM_ICDF(20550),
          AOM_ICDF(21783), AOM_ICDF(22727), AOM_ICDF(23461), AOM_ICDF(25072),
          AOM_ICDF(27195), AOM_ICDF(30380), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(10880), AOM_ICDF(13214), AOM_ICDF(15829), AOM_ICDF(16866),
          AOM_ICDF(20613), AOM_ICDF(22316), AOM_ICDF(24539), AOM_ICDF(27077),
          AOM_ICDF(28116), AOM_ICDF(31485), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(13868), AOM_ICDF(16397), AOM_ICDF(17486),
          AOM_ICDF(20011), AOM_ICDF(22071), AOM_ICDF(23357), AOM_ICDF(24990),
          AOM_ICDF(26336), AOM_ICDF(30276), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(8637), AOM_ICDF(17963), AOM_ICDF(18813),
          AOM_ICDF(21065), AOM_ICDF(22052), AOM_ICDF(23502), AOM_ICDF(25702),
          AOM_ICDF(26745), AOM_ICDF(30668), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(10682), AOM_ICDF(12496), AOM_ICDF(18240),
          AOM_ICDF(20500), AOM_ICDF(21585), AOM_ICDF(23387), AOM_ICDF(25795),
          AOM_ICDF(27119), AOM_ICDF(31001), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9856), AOM_ICDF(12056), AOM_ICDF(13722), AOM_ICDF(15196),
          AOM_ICDF(19276), AOM_ICDF(21891), AOM_ICDF(23643), AOM_ICDF(25538),
          AOM_ICDF(26854), AOM_ICDF(31515), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(12963), AOM_ICDF(14960), AOM_ICDF(16734),
          AOM_ICDF(21279), AOM_ICDF(25616), AOM_ICDF(27638), AOM_ICDF(28950),
          AOM_ICDF(31161), AOM_ICDF(31166), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(8604), AOM_ICDF(12044), AOM_ICDF(13632),
          AOM_ICDF(18931), AOM_ICDF(20553), AOM_ICDF(23452), AOM_ICDF(25800),
          AOM_ICDF(27754), AOM_ICDF(31668), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11520), AOM_ICDF(13372), AOM_ICDF(16642), AOM_ICDF(18137),
          AOM_ICDF(20232), AOM_ICDF(21510), AOM_ICDF(23052), AOM_ICDF(26792),
          AOM_ICDF(27974), AOM_ICDF(31274), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10240), AOM_ICDF(12483), AOM_ICDF(14364), AOM_ICDF(16168),
          AOM_ICDF(18668), AOM_ICDF(20707), AOM_ICDF(22158), AOM_ICDF(24410),
          AOM_ICDF(26370), AOM_ICDF(30744), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8064), AOM_ICDF(10798), AOM_ICDF(13829), AOM_ICDF(15128),
          AOM_ICDF(19136), AOM_ICDF(19152), AOM_ICDF(21057), AOM_ICDF(22583),
          AOM_ICDF(24513), AOM_ICDF(30645), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(11025), AOM_ICDF(16073), AOM_ICDF(17603),
          AOM_ICDF(20094), AOM_ICDF(21468), AOM_ICDF(22971), AOM_ICDF(24628),
          AOM_ICDF(26015), AOM_ICDF(29728), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(10368), AOM_ICDF(15372), AOM_ICDF(18442), AOM_ICDF(19576),
          AOM_ICDF(22674), AOM_ICDF(27128), AOM_ICDF(28232), AOM_ICDF(29624),
          AOM_ICDF(31363), AOM_ICDF(31368), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9472), AOM_ICDF(16687), AOM_ICDF(18957), AOM_ICDF(20272),
          AOM_ICDF(22852), AOM_ICDF(27082), AOM_ICDF(27839), AOM_ICDF(28995),
          AOM_ICDF(30943), AOM_ICDF(30948), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8064), AOM_ICDF(12334), AOM_ICDF(19197), AOM_ICDF(20956),
          AOM_ICDF(24804), AOM_ICDF(26553), AOM_ICDF(27556), AOM_ICDF(29877),
          AOM_ICDF(31311), AOM_ICDF(31320), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(14083), AOM_ICDF(16058), AOM_ICDF(19129),
          AOM_ICDF(21136), AOM_ICDF(23635), AOM_ICDF(24870), AOM_ICDF(27577),
          AOM_ICDF(31176), AOM_ICDF(31187), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(14208), AOM_ICDF(15589), AOM_ICDF(17640),
          AOM_ICDF(22080), AOM_ICDF(26660), AOM_ICDF(27947), AOM_ICDF(29400),
          AOM_ICDF(31605), AOM_ICDF(31611), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9216), AOM_ICDF(15167), AOM_ICDF(16263), AOM_ICDF(17767),
          AOM_ICDF(21531), AOM_ICDF(26689), AOM_ICDF(27607), AOM_ICDF(28880),
          AOM_ICDF(31291), AOM_ICDF(31296), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(12756), AOM_ICDF(15781), AOM_ICDF(17279),
          AOM_ICDF(21198), AOM_ICDF(24057), AOM_ICDF(26171), AOM_ICDF(29200),
          AOM_ICDF(31901), AOM_ICDF(31913), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(15074), AOM_ICDF(18244), AOM_ICDF(19878),
          AOM_ICDF(22246), AOM_ICDF(24436), AOM_ICDF(25560), AOM_ICDF(28991),
          AOM_ICDF(31687), AOM_ICDF(31700), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10496), AOM_ICDF(15128), AOM_ICDF(17012), AOM_ICDF(18989),
          AOM_ICDF(21294), AOM_ICDF(25011), AOM_ICDF(25999), AOM_ICDF(27784),
          AOM_ICDF(30934), AOM_ICDF(30941), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2944), AOM_ICDF(5875), AOM_ICDF(8846), AOM_ICDF(11817),
          AOM_ICDF(14806), AOM_ICDF(17795), AOM_ICDF(20769), AOM_ICDF(23761),
          AOM_ICDF(26747), AOM_ICDF(29739), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7424), AOM_ICDF(12915), AOM_ICDF(17544), AOM_ICDF(19392),
          AOM_ICDF(23074), AOM_ICDF(25635), AOM_ICDF(26431), AOM_ICDF(28241),
          AOM_ICDF(30088), AOM_ICDF(30095), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(11648), AOM_ICDF(13565), AOM_ICDF(18996), AOM_ICDF(19908),
          AOM_ICDF(21897), AOM_ICDF(22852), AOM_ICDF(26656), AOM_ICDF(28172),
          AOM_ICDF(28995), AOM_ICDF(31283), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10240), AOM_ICDF(14255), AOM_ICDF(18109), AOM_ICDF(19716),
          AOM_ICDF(21521), AOM_ICDF(22859), AOM_ICDF(24613), AOM_ICDF(26161),
          AOM_ICDF(27279), AOM_ICDF(30392), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(7848), AOM_ICDF(18820), AOM_ICDF(19447),
          AOM_ICDF(22335), AOM_ICDF(22733), AOM_ICDF(25112), AOM_ICDF(28427),
          AOM_ICDF(29013), AOM_ICDF(31550), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11904), AOM_ICDF(13581), AOM_ICDF(17695), AOM_ICDF(19311),
          AOM_ICDF(21698), AOM_ICDF(22562), AOM_ICDF(24391), AOM_ICDF(26559),
          AOM_ICDF(27779), AOM_ICDF(30567), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10624), AOM_ICDF(12334), AOM_ICDF(14643), AOM_ICDF(16255),
          AOM_ICDF(20783), AOM_ICDF(22767), AOM_ICDF(24929), AOM_ICDF(26876),
          AOM_ICDF(27998), AOM_ICDF(31470), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12032), AOM_ICDF(14415), AOM_ICDF(16715), AOM_ICDF(18712),
          AOM_ICDF(21557), AOM_ICDF(25332), AOM_ICDF(27840), AOM_ICDF(29663),
          AOM_ICDF(31708), AOM_ICDF(31715), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9728), AOM_ICDF(10683), AOM_ICDF(13955), AOM_ICDF(14786),
          AOM_ICDF(18481), AOM_ICDF(19492), AOM_ICDF(26749), AOM_ICDF(28483),
          AOM_ICDF(29116), AOM_ICDF(31958), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(10032), AOM_ICDF(15755), AOM_ICDF(16949),
          AOM_ICDF(19144), AOM_ICDF(19744), AOM_ICDF(22082), AOM_ICDF(27608),
          AOM_ICDF(28411), AOM_ICDF(31838), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(14592), AOM_ICDF(15937), AOM_ICDF(18518), AOM_ICDF(19566),
          AOM_ICDF(21817), AOM_ICDF(23102), AOM_ICDF(24436), AOM_ICDF(26651),
          AOM_ICDF(28100), AOM_ICDF(30993), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(10791), AOM_ICDF(14718), AOM_ICDF(16094),
          AOM_ICDF(18560), AOM_ICDF(18570), AOM_ICDF(22120), AOM_ICDF(24188),
          AOM_ICDF(25677), AOM_ICDF(31280), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11136), AOM_ICDF(13058), AOM_ICDF(19006), AOM_ICDF(20135),
          AOM_ICDF(21463), AOM_ICDF(22159), AOM_ICDF(24042), AOM_ICDF(26348),
          AOM_ICDF(27367), AOM_ICDF(30064), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(12544), AOM_ICDF(15384), AOM_ICDF(20327), AOM_ICDF(21555),
          AOM_ICDF(23456), AOM_ICDF(24144), AOM_ICDF(25421), AOM_ICDF(27884),
          AOM_ICDF(28875), AOM_ICDF(31188), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10368), AOM_ICDF(15009), AOM_ICDF(17631), AOM_ICDF(18970),
          AOM_ICDF(20691), AOM_ICDF(21850), AOM_ICDF(22749), AOM_ICDF(25280),
          AOM_ICDF(26570), AOM_ICDF(29530), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(10956), AOM_ICDF(21554), AOM_ICDF(22698),
          AOM_ICDF(23666), AOM_ICDF(24052), AOM_ICDF(25122), AOM_ICDF(27792),
          AOM_ICDF(28612), AOM_ICDF(30825), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11520), AOM_ICDF(12888), AOM_ICDF(16374), AOM_ICDF(19132),
          AOM_ICDF(21186), AOM_ICDF(21843), AOM_ICDF(22902), AOM_ICDF(26440),
          AOM_ICDF(27928), AOM_ICDF(29946), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(12199), AOM_ICDF(14625), AOM_ICDF(17321),
          AOM_ICDF(20195), AOM_ICDF(21574), AOM_ICDF(23010), AOM_ICDF(25688),
          AOM_ICDF(27600), AOM_ICDF(30988), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10112), AOM_ICDF(13705), AOM_ICDF(16847), AOM_ICDF(19242),
          AOM_ICDF(22011), AOM_ICDF(24064), AOM_ICDF(26481), AOM_ICDF(29125),
          AOM_ICDF(30545), AOM_ICDF(30555), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9344), AOM_ICDF(10994), AOM_ICDF(15018), AOM_ICDF(16915),
          AOM_ICDF(20471), AOM_ICDF(21334), AOM_ICDF(24577), AOM_ICDF(27472),
          AOM_ICDF(28592), AOM_ICDF(31578), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(12928), AOM_ICDF(14540), AOM_ICDF(18022), AOM_ICDF(19481),
          AOM_ICDF(21028), AOM_ICDF(21825), AOM_ICDF(22728), AOM_ICDF(28191),
          AOM_ICDF(29154), AOM_ICDF(31683), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10368), AOM_ICDF(12160), AOM_ICDF(14900), AOM_ICDF(17161),
          AOM_ICDF(19379), AOM_ICDF(20521), AOM_ICDF(21747), AOM_ICDF(24534),
          AOM_ICDF(26677), AOM_ICDF(30318), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(11488), AOM_ICDF(16197), AOM_ICDF(18030),
          AOM_ICDF(20010), AOM_ICDF(20018), AOM_ICDF(21347), AOM_ICDF(23948),
          AOM_ICDF(25016), AOM_ICDF(30536), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7808), AOM_ICDF(10310), AOM_ICDF(15420), AOM_ICDF(18961),
          AOM_ICDF(20114), AOM_ICDF(20772), AOM_ICDF(21721), AOM_ICDF(24599),
          AOM_ICDF(26237), AOM_ICDF(29160), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(9856), AOM_ICDF(13764), AOM_ICDF(16995), AOM_ICDF(19540),
          AOM_ICDF(20802), AOM_ICDF(22302), AOM_ICDF(23113), AOM_ICDF(24519),
          AOM_ICDF(27717), AOM_ICDF(31604), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(15725), AOM_ICDF(17309), AOM_ICDF(20296),
          AOM_ICDF(21257), AOM_ICDF(22573), AOM_ICDF(23165), AOM_ICDF(23893),
          AOM_ICDF(27755), AOM_ICDF(31170), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7936), AOM_ICDF(11343), AOM_ICDF(19355), AOM_ICDF(21223),
          AOM_ICDF(22121), AOM_ICDF(22978), AOM_ICDF(23703), AOM_ICDF(26079),
          AOM_ICDF(27978), AOM_ICDF(31507), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11264), AOM_ICDF(14823), AOM_ICDF(17314), AOM_ICDF(20715),
          AOM_ICDF(21999), AOM_ICDF(22982), AOM_ICDF(23728), AOM_ICDF(25229),
          AOM_ICDF(28593), AOM_ICDF(31508), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(11788), AOM_ICDF(13666), AOM_ICDF(16523),
          AOM_ICDF(18630), AOM_ICDF(20579), AOM_ICDF(21574), AOM_ICDF(23335),
          AOM_ICDF(26298), AOM_ICDF(31264), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(14031), AOM_ICDF(15766), AOM_ICDF(18533),
          AOM_ICDF(21457), AOM_ICDF(24078), AOM_ICDF(24973), AOM_ICDF(26102),
          AOM_ICDF(31284), AOM_ICDF(31288), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7040), AOM_ICDF(9648), AOM_ICDF(12140), AOM_ICDF(14601),
          AOM_ICDF(16742), AOM_ICDF(18070), AOM_ICDF(21154), AOM_ICDF(23582),
          AOM_ICDF(27647), AOM_ICDF(31763), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(10240), AOM_ICDF(13466), AOM_ICDF(16837), AOM_ICDF(19351),
          AOM_ICDF(20636), AOM_ICDF(21620), AOM_ICDF(22474), AOM_ICDF(25815),
          AOM_ICDF(28364), AOM_ICDF(31976), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(11008), AOM_ICDF(13682), AOM_ICDF(15127), AOM_ICDF(18779),
          AOM_ICDF(19841), AOM_ICDF(20792), AOM_ICDF(21954), AOM_ICDF(23365),
          AOM_ICDF(29100), AOM_ICDF(31748), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7168), AOM_ICDF(12260), AOM_ICDF(15037), AOM_ICDF(17152),
          AOM_ICDF(18730), AOM_ICDF(18736), AOM_ICDF(19436), AOM_ICDF(20484),
          AOM_ICDF(24465), AOM_ICDF(30868), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(12469), AOM_ICDF(15422), AOM_ICDF(19291),
          AOM_ICDF(20301), AOM_ICDF(21344), AOM_ICDF(21894), AOM_ICDF(23415),
          AOM_ICDF(27696), AOM_ICDF(31042), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(10112), AOM_ICDF(13929), AOM_ICDF(17880), AOM_ICDF(18857),
          AOM_ICDF(20955), AOM_ICDF(20963), AOM_ICDF(21974), AOM_ICDF(23273),
          AOM_ICDF(24734), AOM_ICDF(31352), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8064), AOM_ICDF(15826), AOM_ICDF(17929), AOM_ICDF(19017),
          AOM_ICDF(21016), AOM_ICDF(21024), AOM_ICDF(21687), AOM_ICDF(22701),
          AOM_ICDF(24242), AOM_ICDF(30645), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6528), AOM_ICDF(9196), AOM_ICDF(20118), AOM_ICDF(21101),
          AOM_ICDF(22227), AOM_ICDF(22231), AOM_ICDF(22997), AOM_ICDF(25070),
          AOM_ICDF(25919), AOM_ICDF(30923), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9600), AOM_ICDF(13218), AOM_ICDF(15898), AOM_ICDF(17780),
          AOM_ICDF(19991), AOM_ICDF(20000), AOM_ICDF(21196), AOM_ICDF(23912),
          AOM_ICDF(26044), AOM_ICDF(31139), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8960), AOM_ICDF(12037), AOM_ICDF(14178), AOM_ICDF(15681),
          AOM_ICDF(20126), AOM_ICDF(20143), AOM_ICDF(21435), AOM_ICDF(23083),
          AOM_ICDF(24675), AOM_ICDF(31466), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(2944), AOM_ICDF(5875), AOM_ICDF(8846), AOM_ICDF(11817),
          AOM_ICDF(14806), AOM_ICDF(17795), AOM_ICDF(20769), AOM_ICDF(23761),
          AOM_ICDF(26747), AOM_ICDF(29739), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9472), AOM_ICDF(12334), AOM_ICDF(15469), AOM_ICDF(16848),
          AOM_ICDF(19972), AOM_ICDF(19984), AOM_ICDF(22292), AOM_ICDF(24384),
          AOM_ICDF(25891), AOM_ICDF(31676), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(11176), AOM_ICDF(15497), AOM_ICDF(16676),
          AOM_ICDF(18528), AOM_ICDF(18535), AOM_ICDF(19595), AOM_ICDF(24334),
          AOM_ICDF(25725), AOM_ICDF(31723), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8704), AOM_ICDF(12141), AOM_ICDF(14313), AOM_ICDF(15828),
          AOM_ICDF(18358), AOM_ICDF(18368), AOM_ICDF(19469), AOM_ICDF(21089),
          AOM_ICDF(24027), AOM_ICDF(30700), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(7680), AOM_ICDF(11689), AOM_ICDF(14556), AOM_ICDF(15548),
          AOM_ICDF(17878), AOM_ICDF(17887), AOM_ICDF(18873), AOM_ICDF(20512),
          AOM_ICDF(22152), AOM_ICDF(31004), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(11476), AOM_ICDF(16600), AOM_ICDF(18052),
          AOM_ICDF(19683), AOM_ICDF(19689), AOM_ICDF(20509), AOM_ICDF(22077),
          AOM_ICDF(23496), AOM_ICDF(29504), AOM_ICDF(32768), 0,
      },
  },
  {
      {
          AOM_ICDF(9728), AOM_ICDF(14651), AOM_ICDF(19394), AOM_ICDF(20550),
          AOM_ICDF(21680), AOM_ICDF(22479), AOM_ICDF(23516), AOM_ICDF(24952),
          AOM_ICDF(26183), AOM_ICDF(28538), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8832), AOM_ICDF(18693), AOM_ICDF(20913), AOM_ICDF(21933),
          AOM_ICDF(22956), AOM_ICDF(23831), AOM_ICDF(24341), AOM_ICDF(25317),
          AOM_ICDF(26434), AOM_ICDF(29028), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(5888), AOM_ICDF(8413), AOM_ICDF(20542), AOM_ICDF(21609),
          AOM_ICDF(22437), AOM_ICDF(22864), AOM_ICDF(23663), AOM_ICDF(26329),
          AOM_ICDF(26900), AOM_ICDF(29828), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9984), AOM_ICDF(13134), AOM_ICDF(16328), AOM_ICDF(18267),
          AOM_ICDF(19814), AOM_ICDF(21461), AOM_ICDF(22393), AOM_ICDF(24944),
          AOM_ICDF(26320), AOM_ICDF(29653), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8448), AOM_ICDF(12425), AOM_ICDF(15474), AOM_ICDF(17031),
          AOM_ICDF(19216), AOM_ICDF(20889), AOM_ICDF(23077), AOM_ICDF(25108),
          AOM_ICDF(26548), AOM_ICDF(30108), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9856), AOM_ICDF(15675), AOM_ICDF(19169), AOM_ICDF(20837),
          AOM_ICDF(22638), AOM_ICDF(24556), AOM_ICDF(25438), AOM_ICDF(27114),
          AOM_ICDF(29449), AOM_ICDF(29456), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6784), AOM_ICDF(10294), AOM_ICDF(14542), AOM_ICDF(15724),
          AOM_ICDF(19109), AOM_ICDF(19972), AOM_ICDF(24084), AOM_ICDF(26329),
          AOM_ICDF(27637), AOM_ICDF(30433), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(8320), AOM_ICDF(10873), AOM_ICDF(17095), AOM_ICDF(18466),
          AOM_ICDF(19674), AOM_ICDF(20129), AOM_ICDF(21230), AOM_ICDF(27562),
          AOM_ICDF(28568), AOM_ICDF(30858), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(9088), AOM_ICDF(13196), AOM_ICDF(15898), AOM_ICDF(17566),
          AOM_ICDF(19210), AOM_ICDF(20354), AOM_ICDF(21186), AOM_ICDF(23647),
          AOM_ICDF(26235), AOM_ICDF(30548), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6912), AOM_ICDF(11512), AOM_ICDF(16390), AOM_ICDF(17479),
          AOM_ICDF(19065), AOM_ICDF(19071), AOM_ICDF(19740), AOM_ICDF(21715),
          AOM_ICDF(23208), AOM_ICDF(29132), AOM_ICDF(32768), 0,
      },
      {
          AOM_ICDF(6656), AOM_ICDF(11485), AOM_ICDF(16060), AOM_ICDF(17734),
          AOM_ICDF(19099), AOM_ICDF(19814), AOM_ICDF(21018), AOM_ICDF(23053),
          AOM_ICDF(24333), AOM_ICDF(27260), AOM_ICDF(32768), 0,
      },
  },
#endif  // CONFIG_SMOOTH_HV
};
#endif  // CONFIG_KF_CTX

#if CONFIG_LPF_SB
static const aom_cdf_prob default_lpf_reuse_cdf[LPF_REUSE_CONTEXT][CDF_SIZE(
    2)] = { { AOM_ICDF(8192), AOM_ICDF(32768), 0 },
            { AOM_ICDF(4096), AOM_ICDF(32768), 0 } };

static const aom_cdf_prob
    default_lpf_delta_cdf[LPF_DELTA_CONTEXT][CDF_SIZE(DELTA_RANGE)] = {
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 },
      { AOM_ICDF(4096), AOM_ICDF(7680), AOM_ICDF(10816), AOM_ICDF(13560),
        AOM_ICDF(15961), AOM_ICDF(18062), AOM_ICDF(19900), AOM_ICDF(32768), 0 }
    };

static const aom_cdf_prob
    default_lpf_sign_cdf[LPF_REUSE_CONTEXT][LPF_SIGN_CONTEXT][CDF_SIZE(2)] = {
      { { AOM_ICDF(6554), AOM_ICDF(32768), 0 },
        { AOM_ICDF(26214), AOM_ICDF(32768), 0 } },
      { { AOM_ICDF(16384), AOM_ICDF(32768), 0 },
        { AOM_ICDF(16384), AOM_ICDF(32768), 0 } }
    };
#endif  // CONFIG_LPF_SB

static void init_mode_probs(FRAME_CONTEXT *fc) {
  av1_copy(fc->partition_prob, default_partition_probs);
  av1_copy(fc->intra_inter_prob, default_intra_inter_p);
  av1_copy(fc->comp_inter_prob, default_comp_inter_p);
  av1_copy(fc->palette_y_size_cdf, default_palette_y_size_cdf);
  av1_copy(fc->palette_uv_size_cdf, default_palette_uv_size_cdf);
  av1_copy(fc->palette_y_color_index_cdf, default_palette_y_color_index_cdf);
  av1_copy(fc->palette_uv_color_index_cdf, default_palette_uv_color_index_cdf);
  av1_copy(fc->kf_y_cdf, default_kf_y_mode_cdf);
#if CONFIG_MRC_TX
  av1_copy(fc->mrc_mask_inter_cdf, default_mrc_mask_inter_cdf);
  av1_copy(fc->mrc_mask_intra_cdf, default_mrc_mask_intra_cdf);
#endif  // CONFIG_MRC_TX
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->comp_inter_cdf, default_comp_inter_cdf);
#endif  // CONFIG_NEW_MULTISYMBOL
#if CONFIG_EXT_COMP_REFS
  av1_copy(fc->comp_ref_type_prob, default_comp_ref_type_p);
  av1_copy(fc->uni_comp_ref_prob, default_uni_comp_ref_p);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->comp_ref_type_cdf, default_comp_ref_type_cdf);
  av1_copy(fc->uni_comp_ref_cdf, default_uni_comp_ref_cdf);
#endif  // CONFIG_NEW_MULTISYMBOL
#endif  // CONFIG_EXT_COMP_REFS
  av1_copy(fc->comp_ref_prob, default_comp_ref_p);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->palette_y_mode_cdf, default_palette_y_mode_cdf);
  av1_copy(fc->palette_uv_mode_cdf, default_palette_uv_mode_cdf);
  av1_copy(fc->comp_ref_cdf, default_comp_ref_cdf);
#endif
#if CONFIG_LV_MAP
  av1_copy(fc->txb_skip, default_txb_skip);
  av1_copy(fc->nz_map, default_nz_map);
  av1_copy(fc->eob_flag, default_eob_flag);
  av1_copy(fc->dc_sign, default_dc_sign);
  av1_copy(fc->coeff_base, default_coeff_base);
  av1_copy(fc->coeff_lps, default_coeff_lps);
#if BR_NODE
  av1_copy(fc->coeff_br, default_coeff_br);
#endif
#if CONFIG_CTX1D
  av1_copy(fc->eob_mode, default_eob_mode);
  av1_copy(fc->empty_line, default_empty_line);
  av1_copy(fc->hv_eob, default_hv_eob);
#endif  // CONFIG_CTX1D

#if LV_MAP_PROB
  av1_init_txb_probs(fc);
#endif  // LV_MAP_PROB
#endif
#if CONFIG_EXT_REFS
  av1_copy(fc->comp_bwdref_prob, default_comp_bwdref_p);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->comp_bwdref_cdf, default_comp_bwdref_cdf);
#endif
#endif  // CONFIG_EXT_REFS
  av1_copy(fc->single_ref_prob, default_single_ref_p);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->single_ref_cdf, default_single_ref_cdf);
#endif
#if CONFIG_COMPOUND_SINGLEREF
  av1_copy(fc->comp_inter_mode_prob, default_comp_inter_mode_p);
#endif  // CONFIG_COMPOUND_SINGLEREF
#if CONFIG_RECT_TX_EXT && (CONFIG_EXT_TX || CONFIG_VAR_TX)
  fc->quarter_tx_size_prob = default_quarter_tx_size_prob;
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->quarter_tx_size_cdf, default_quarter_tx_size_cdf);
#endif  // CONFIG_NEW_MULTISYMBOL
#endif
#if CONFIG_VAR_TX
  av1_copy(fc->txfm_partition_prob, default_txfm_partition_probs);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->txfm_partition_cdf, default_txfm_partition_cdf);
#endif
#endif
  av1_copy(fc->skip_probs, default_skip_probs);
  av1_copy(fc->newmv_prob, default_newmv_prob);
  av1_copy(fc->zeromv_prob, default_zeromv_prob);
  av1_copy(fc->refmv_prob, default_refmv_prob);
  av1_copy(fc->drl_prob, default_drl_prob);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->newmv_cdf, default_newmv_cdf);
  av1_copy(fc->zeromv_cdf, default_zeromv_cdf);
  av1_copy(fc->refmv_cdf, default_refmv_cdf);
  av1_copy(fc->drl_cdf, default_drl_cdf);
#endif
#if CONFIG_MOTION_VAR || CONFIG_WARPED_MOTION
  av1_copy(fc->motion_mode_prob, default_motion_mode_prob);
  av1_copy(fc->motion_mode_cdf, default_motion_mode_cdf);
#if CONFIG_NCOBMC_ADAPT_WEIGHT && CONFIG_MOTION_VAR
  av1_copy(fc->ncobmc_mode_prob, default_ncobmc_mode_prob);
  av1_copy(fc->ncobmc_mode_cdf, default_ncobmc_mode_cdf);
#endif
#if CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
  av1_copy(fc->obmc_prob, default_obmc_prob);
#if CONFIG_NEW_MULTISYMBOL || CONFIG_NCOBMC_ADAPT_WEIGHT
  av1_copy(fc->obmc_cdf, default_obmc_cdf);
#endif
#if CONFIG_NCOBMC_ADAPT_WEIGHT
  av1_copy(fc->ncobmc_prob, default_ncobmc_prob);
  av1_copy(fc->ncobmc_cdf, default_ncobmc_cdf);
#endif  // CONFIG_NCOBMC_ADAPT_WEIGHT
#endif  // CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
#endif  // CONFIG_MOTION_VAR || CONFIG_WARPED_MOTION
  av1_copy(fc->inter_compound_mode_probs, default_inter_compound_mode_probs);
  av1_copy(fc->inter_compound_mode_cdf, default_inter_compound_mode_cdf);
#if CONFIG_COMPOUND_SINGLEREF
  av1_copy(fc->inter_singleref_comp_mode_probs,
           default_inter_singleref_comp_mode_probs);
  av1_copy(fc->inter_singleref_comp_mode_cdf,
           default_inter_singleref_comp_mode_cdf);
#endif  // CONFIG_COMPOUND_SINGLEREF
  av1_copy(fc->compound_type_prob, default_compound_type_probs);
#if CONFIG_WEDGE || CONFIG_COMPOUND_SEGMENT
  av1_copy(fc->compound_type_cdf, default_compound_type_cdf);
#endif  // CONFIG_WEDGE || CONFIG_COMPOUND_SEGMENT
#if CONFIG_INTERINTRA
  av1_copy(fc->interintra_prob, default_interintra_prob);
  av1_copy(fc->wedge_interintra_prob, default_wedge_interintra_prob);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->interintra_cdf, default_interintra_cdf);
  av1_copy(fc->wedge_interintra_cdf, default_wedge_interintra_cdf);
#endif  // CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->interintra_mode_prob, default_interintra_mode_prob);
  av1_copy(fc->interintra_mode_cdf, default_interintra_mode_cdf);
#endif  // CONFIG_INTERINTRA
#if CONFIG_SUPERTX
  av1_copy(fc->supertx_prob, default_supertx_prob);
#endif  // CONFIG_SUPERTX
  av1_copy(fc->seg.tree_probs, default_segment_tree_probs);
  av1_copy(fc->seg.pred_probs, default_segment_pred_probs);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->seg.pred_cdf, default_segment_pred_cdf);
#endif
#if CONFIG_EXT_INTRA
#if CONFIG_INTRA_INTERP
  av1_copy(fc->intra_filter_probs, default_intra_filter_probs);
#endif  // CONFIG_INTRA_INTERP
#endif  // CONFIG_EXT_INTRA
#if CONFIG_FILTER_INTRA
  av1_copy(fc->filter_intra_probs, default_filter_intra_probs);
#endif  // CONFIG_FILTER_INTRA
#if CONFIG_LGT_FROM_PRED
  av1_copy(fc->intra_lgt_prob, default_intra_lgt_prob);
  av1_copy(fc->inter_lgt_prob, default_inter_lgt_prob);
#endif  // CONFIG_LGT_FROM_PRED
#if CONFIG_LOOP_RESTORATION
  av1_copy(fc->switchable_restore_prob, default_switchable_restore_prob);
#endif  // CONFIG_LOOP_RESTORATION
  av1_copy(fc->y_mode_cdf, default_if_y_mode_cdf);
  av1_copy(fc->uv_mode_cdf, default_uv_mode_cdf);
  av1_copy(fc->switchable_interp_cdf, default_switchable_interp_cdf);
  av1_copy(fc->partition_cdf, default_partition_cdf);
  av1_copy(fc->intra_ext_tx_cdf, default_intra_ext_tx_cdf);
  av1_copy(fc->inter_ext_tx_cdf, default_inter_ext_tx_cdf);
#if CONFIG_NEW_MULTISYMBOL
  av1_copy(fc->skip_cdfs, default_skip_cdfs);
  av1_copy(fc->intra_inter_cdf, default_intra_inter_cdf);
#endif
#if CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP
  av1_copy(fc->intra_filter_cdf, default_intra_filter_cdf);
#endif  // CONFIG_EXT_INTRA && CONFIG_INTRA_INTERP
  av1_copy(fc->seg.tree_cdf, default_seg_tree_cdf);
  av1_copy(fc->tx_size_cdf, default_tx_size_cdf);
  av1_copy(fc->delta_q_prob, default_delta_q_probs);
  av1_copy(fc->delta_q_cdf, default_delta_q_cdf);
#if CONFIG_EXT_DELTA_Q
  av1_copy(fc->delta_lf_prob, default_delta_lf_probs);
  av1_copy(fc->delta_lf_cdf, default_delta_lf_cdf);
#if CONFIG_LOOPFILTER_LEVEL
  av1_copy(fc->delta_lf_multi_cdf, default_delta_lf_multi_cdf);
#endif  // CONFIG_LOOPFILTER_LEVEL
#endif
#if CONFIG_CFL
  av1_copy(fc->cfl_sign_cdf, default_cfl_sign_cdf);
  av1_copy(fc->cfl_alpha_cdf, default_cfl_alpha_cdf);
#endif
#if CONFIG_INTRABC
  av1_copy(fc->intrabc_cdf, default_intrabc_cdf);
#endif
#if CONFIG_LPF_SB
  av1_copy(fc->lpf_reuse_cdf, default_lpf_reuse_cdf);
  av1_copy(fc->lpf_delta_cdf, default_lpf_delta_cdf);
  av1_copy(fc->lpf_sign_cdf, default_lpf_sign_cdf);
#endif  // CONFIG_LPF_SB
}

void av1_adapt_inter_frame_probs(AV1_COMMON *cm) {
  int i, j;
  FRAME_CONTEXT *fc = cm->fc;
  const FRAME_CONTEXT *pre_fc = cm->pre_fc;
  const FRAME_COUNTS *counts = &cm->counts;

  for (i = 0; i < INTRA_INTER_CONTEXTS; i++)
    fc->intra_inter_prob[i] = av1_mode_mv_merge_probs(
        pre_fc->intra_inter_prob[i], counts->intra_inter[i]);

  for (i = 0; i < COMP_INTER_CONTEXTS; i++)
    fc->comp_inter_prob[i] = av1_mode_mv_merge_probs(pre_fc->comp_inter_prob[i],
                                                     counts->comp_inter[i]);

#if CONFIG_EXT_COMP_REFS
  for (i = 0; i < COMP_REF_TYPE_CONTEXTS; i++)
    fc->comp_ref_type_prob[i] = av1_mode_mv_merge_probs(
        pre_fc->comp_ref_type_prob[i], counts->comp_ref_type[i]);

  for (i = 0; i < UNI_COMP_REF_CONTEXTS; i++)
    for (j = 0; j < (UNIDIR_COMP_REFS - 1); j++)
      fc->uni_comp_ref_prob[i][j] = av1_mode_mv_merge_probs(
          pre_fc->uni_comp_ref_prob[i][j], counts->uni_comp_ref[i][j]);
#endif  // CONFIG_EXT_COMP_REFS

#if CONFIG_EXT_REFS
  for (i = 0; i < REF_CONTEXTS; i++)
    for (j = 0; j < (FWD_REFS - 1); j++)
      fc->comp_ref_prob[i][j] = mode_mv_merge_probs(pre_fc->comp_ref_prob[i][j],
                                                    counts->comp_ref[i][j]);
  for (i = 0; i < REF_CONTEXTS; i++)
    for (j = 0; j < (BWD_REFS - 1); j++)
      fc->comp_bwdref_prob[i][j] = mode_mv_merge_probs(
          pre_fc->comp_bwdref_prob[i][j], counts->comp_bwdref[i][j]);
#else
  for (i = 0; i < REF_CONTEXTS; i++)
    for (j = 0; j < (COMP_REFS - 1); j++)
      fc->comp_ref_prob[i][j] = mode_mv_merge_probs(pre_fc->comp_ref_prob[i][j],
                                                    counts->comp_ref[i][j]);
#endif  // CONFIG_EXT_REFS

  for (i = 0; i < REF_CONTEXTS; i++)
    for (j = 0; j < (SINGLE_REFS - 1); j++)
      fc->single_ref_prob[i][j] = av1_mode_mv_merge_probs(
          pre_fc->single_ref_prob[i][j], counts->single_ref[i][j]);

#if CONFIG_COMPOUND_SINGLEREF
  for (i = 0; i < COMP_INTER_MODE_CONTEXTS; i++)
    fc->comp_inter_mode_prob[i] = av1_mode_mv_merge_probs(
        pre_fc->comp_inter_mode_prob[i], counts->comp_inter_mode[i]);

#endif  // CONFIG_COMPOUND_SINGLEREF

  for (i = 0; i < NEWMV_MODE_CONTEXTS; ++i)
    fc->newmv_prob[i] =
        av1_mode_mv_merge_probs(pre_fc->newmv_prob[i], counts->newmv_mode[i]);
  for (i = 0; i < ZEROMV_MODE_CONTEXTS; ++i)
    fc->zeromv_prob[i] =
        av1_mode_mv_merge_probs(pre_fc->zeromv_prob[i], counts->zeromv_mode[i]);
  for (i = 0; i < REFMV_MODE_CONTEXTS; ++i)
    fc->refmv_prob[i] =
        av1_mode_mv_merge_probs(pre_fc->refmv_prob[i], counts->refmv_mode[i]);

  for (i = 0; i < DRL_MODE_CONTEXTS; ++i)
    fc->drl_prob[i] =
        av1_mode_mv_merge_probs(pre_fc->drl_prob[i], counts->drl_mode[i]);

#if CONFIG_MOTION_VAR || CONFIG_WARPED_MOTION
  for (i = BLOCK_8X8; i < BLOCK_SIZES_ALL; ++i)
    aom_tree_merge_probs(av1_motion_mode_tree, pre_fc->motion_mode_prob[i],
                         counts->motion_mode[i], fc->motion_mode_prob[i]);
#if CONFIG_NCOBMC_ADAPT_WEIGHT
  for (i = 0; i < ADAPT_OVERLAP_BLOCKS; ++i)
    aom_tree_merge_probs(av1_ncobmc_mode_tree, pre_fc->ncobmc_mode_prob[i],
                         counts->ncobmc_mode[i], fc->ncobmc_mode_prob[i]);
#if CONFIG_WARPED_MOTION
  for (i = BLOCK_8X8; i < BLOCK_SIZES_ALL; ++i)
    aom_tree_merge_probs(av1_ncobmc_tree, pre_fc->ncobmc_prob[i],
                         counts->ncobmc[i], fc->ncobmc_prob[i]);
#endif
#endif  // CONFIG_NCOBMC_ADAPT_WEIGHT
#if CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
  for (i = BLOCK_8X8; i < BLOCK_SIZES_ALL; ++i)
    fc->obmc_prob[i] =
        av1_mode_mv_merge_probs(pre_fc->obmc_prob[i], counts->obmc[i]);
#endif  // CONFIG_MOTION_VAR && CONFIG_WARPED_MOTION
#endif  // CONFIG_MOTION_VAR || CONFIG_WARPED_MOTION

#if CONFIG_SUPERTX
  for (i = 0; i < PARTITION_SUPERTX_CONTEXTS; ++i) {
    for (j = TX_8X8; j < TX_SIZES; ++j) {
      fc->supertx_prob[i][j] = av1_mode_mv_merge_probs(
          pre_fc->supertx_prob[i][j], counts->supertx[i][j]);
    }
  }
#endif  // CONFIG_SUPERTX

  for (i = 0; i < INTER_MODE_CONTEXTS; i++)
    aom_tree_merge_probs(
        av1_inter_compound_mode_tree, pre_fc->inter_compound_mode_probs[i],
        counts->inter_compound_mode[i], fc->inter_compound_mode_probs[i]);
#if CONFIG_COMPOUND_SINGLEREF
  for (i = 0; i < INTER_MODE_CONTEXTS; i++)
    aom_tree_merge_probs(av1_inter_singleref_comp_mode_tree,
                         pre_fc->inter_singleref_comp_mode_probs[i],
                         counts->inter_singleref_comp_mode[i],
                         fc->inter_singleref_comp_mode_probs[i]);
#endif  // CONFIG_COMPOUND_SINGLEREF
#if CONFIG_INTERINTRA
  if (cm->allow_interintra_compound) {
    for (i = 0; i < BLOCK_SIZE_GROUPS; ++i) {
      if (is_interintra_allowed_bsize_group(i))
        fc->interintra_prob[i] = av1_mode_mv_merge_probs(
            pre_fc->interintra_prob[i], counts->interintra[i]);
    }
    for (i = 0; i < BLOCK_SIZE_GROUPS; i++) {
      aom_tree_merge_probs(
          av1_interintra_mode_tree, pre_fc->interintra_mode_prob[i],
          counts->interintra_mode[i], fc->interintra_mode_prob[i]);
    }
#if CONFIG_WEDGE
    for (i = 0; i < BLOCK_SIZES_ALL; ++i) {
      if (is_interintra_allowed_bsize(i) && is_interintra_wedge_used(i))
        fc->wedge_interintra_prob[i] = av1_mode_mv_merge_probs(
            pre_fc->wedge_interintra_prob[i], counts->wedge_interintra[i]);
    }
#endif  // CONFIG_WEDGE
  }
#endif  // CONFIG_INTERINTRA

#if CONFIG_COMPOUND_SEGMENT || CONFIG_WEDGE
  if (cm->allow_masked_compound) {
    for (i = 0; i < BLOCK_SIZES_ALL; ++i) {
      aom_tree_merge_probs(
          av1_compound_type_tree, pre_fc->compound_type_prob[i],
          counts->compound_interinter[i], fc->compound_type_prob[i]);
    }
  }
#endif  // CONFIG_COMPOUND_SEGMENT || CONFIG_WEDGE
}

void av1_adapt_intra_frame_probs(AV1_COMMON *cm) {
  int i;
  FRAME_CONTEXT *fc = cm->fc;
  const FRAME_CONTEXT *pre_fc = cm->pre_fc;
  const FRAME_COUNTS *counts = &cm->counts;

  if (cm->tx_mode == TX_MODE_SELECT) {
#if CONFIG_RECT_TX_EXT && (CONFIG_EXT_TX || CONFIG_VAR_TX)
    fc->quarter_tx_size_prob = av1_mode_mv_merge_probs(
        pre_fc->quarter_tx_size_prob, counts->quarter_tx_size);
#endif
  }

#if CONFIG_VAR_TX
  if (cm->tx_mode == TX_MODE_SELECT) {
    for (i = 0; i < TXFM_PARTITION_CONTEXTS; ++i)
      fc->txfm_partition_prob[i] = av1_mode_mv_merge_probs(
          pre_fc->txfm_partition_prob[i], counts->txfm_partition[i]);
  }
#endif

  for (i = 0; i < SKIP_CONTEXTS; ++i)
    fc->skip_probs[i] =
        av1_mode_mv_merge_probs(pre_fc->skip_probs[i], counts->skip[i]);

#if CONFIG_LGT_FROM_PRED
  int j;
  if (LGT_FROM_PRED_INTRA) {
    for (i = TX_4X4; i < LGT_SIZES; ++i) {
      for (j = 0; j < INTRA_MODES; ++j)
        fc->intra_lgt_prob[i][j] = av1_mode_mv_merge_probs(
            pre_fc->intra_lgt_prob[i][j], counts->intra_lgt[i][j]);
    }
  }
  if (LGT_FROM_PRED_INTER) {
    for (i = TX_4X4; i < LGT_SIZES; ++i) {
      fc->inter_lgt_prob[i] = av1_mode_mv_merge_probs(pre_fc->inter_lgt_prob[i],
                                                      counts->inter_lgt[i]);
    }
  }
#endif  // CONFIG_LGT_FROM_PRED

  if (cm->seg.temporal_update) {
    for (i = 0; i < PREDICTION_PROBS; i++)
      fc->seg.pred_probs[i] = av1_mode_mv_merge_probs(pre_fc->seg.pred_probs[i],
                                                      counts->seg.pred[i]);

    aom_tree_merge_probs(av1_segment_tree, pre_fc->seg.tree_probs,
                         counts->seg.tree_mispred, fc->seg.tree_probs);
  } else {
    aom_tree_merge_probs(av1_segment_tree, pre_fc->seg.tree_probs,
                         counts->seg.tree_total, fc->seg.tree_probs);
  }

#if CONFIG_EXT_PARTITION_TYPES
  for (i = 0; i < PARTITION_PLOFFSET; ++i)
    aom_tree_merge_probs(av1_partition_tree, pre_fc->partition_prob[i],
                         counts->partition[i], fc->partition_prob[i]);
  for (; i < PARTITION_CONTEXTS_PRIMARY; ++i)
    aom_tree_merge_probs(av1_ext_partition_tree, pre_fc->partition_prob[i],
                         counts->partition[i], fc->partition_prob[i]);
#else
  for (i = 0; i < PARTITION_CONTEXTS_PRIMARY; ++i) {
    aom_tree_merge_probs(av1_partition_tree, pre_fc->partition_prob[i],
                         counts->partition[i], fc->partition_prob[i]);
  }
#endif  // CONFIG_EXT_PARTITION_TYPES
#if CONFIG_UNPOISON_PARTITION_CTX
  for (i = PARTITION_CONTEXTS_PRIMARY;
       i < PARTITION_CONTEXTS_PRIMARY + PARTITION_BLOCK_SIZES; ++i) {
    unsigned int ct[2] = { counts->partition[i][PARTITION_VERT],
                           counts->partition[i][PARTITION_SPLIT] };
    assert(counts->partition[i][PARTITION_NONE] == 0);
    assert(counts->partition[i][PARTITION_HORZ] == 0);
    assert(fc->partition_prob[i][PARTITION_NONE] == 0);
    assert(fc->partition_prob[i][PARTITION_HORZ] == 0);
    fc->partition_prob[i][PARTITION_VERT] =
        av1_mode_mv_merge_probs(pre_fc->partition_prob[i][PARTITION_VERT], ct);
  }
  for (i = PARTITION_CONTEXTS_PRIMARY + PARTITION_BLOCK_SIZES;
       i < PARTITION_CONTEXTS_PRIMARY + 2 * PARTITION_BLOCK_SIZES; ++i) {
    unsigned int ct[2] = { counts->partition[i][PARTITION_HORZ],
                           counts->partition[i][PARTITION_SPLIT] };
    assert(counts->partition[i][PARTITION_NONE] == 0);
    assert(counts->partition[i][PARTITION_VERT] == 0);
    assert(fc->partition_prob[i][PARTITION_NONE] == 0);
    assert(fc->partition_prob[i][PARTITION_VERT] == 0);
    fc->partition_prob[i][PARTITION_HORZ] =
        av1_mode_mv_merge_probs(pre_fc->partition_prob[i][PARTITION_HORZ], ct);
  }
#endif
  for (i = 0; i < DELTA_Q_PROBS; ++i)
    fc->delta_q_prob[i] =
        mode_mv_merge_probs(pre_fc->delta_q_prob[i], counts->delta_q[i]);
#if CONFIG_EXT_DELTA_Q
#if CONFIG_LOOPFILTER_LEVEL
  for (i = 0; i < FRAME_LF_COUNT; ++i)
    for (int j = 0; j < DELTA_LF_PROBS; ++j)
      fc->delta_lf_multi_prob[i][j] = mode_mv_merge_probs(
          pre_fc->delta_lf_multi_prob[i][j], counts->delta_lf_multi[i][j]);
#endif  // CONFIG_LOOPFILTER_LEVEL
  for (i = 0; i < DELTA_LF_PROBS; ++i)
    fc->delta_lf_prob[i] =
        mode_mv_merge_probs(pre_fc->delta_lf_prob[i], counts->delta_lf[i]);
#endif  // CONFIG_EXT_DELTA_Q
#if CONFIG_EXT_INTRA
#if CONFIG_INTRA_INTERP
  for (i = 0; i < INTRA_FILTERS + 1; ++i) {
    aom_tree_merge_probs(av1_intra_filter_tree, pre_fc->intra_filter_probs[i],
                         counts->intra_filter[i], fc->intra_filter_probs[i]);
  }
#endif  // CONFIG_INTRA_INTERP
#endif  // CONFIG_EXT_INTRA
#if CONFIG_FILTER_INTRA
  for (i = 0; i < PLANE_TYPES; ++i) {
    fc->filter_intra_probs[i] = av1_mode_mv_merge_probs(
        pre_fc->filter_intra_probs[i], counts->filter_intra[i]);
  }
#endif  // CONFIG_FILTER_INTRA
}

static void set_default_lf_deltas(struct loopfilter *lf) {
  lf->mode_ref_delta_enabled = 1;
  lf->mode_ref_delta_update = 1;

  lf->ref_deltas[INTRA_FRAME] = 1;
  lf->ref_deltas[LAST_FRAME] = 0;
#if CONFIG_EXT_REFS
  lf->ref_deltas[LAST2_FRAME] = lf->ref_deltas[LAST_FRAME];
  lf->ref_deltas[LAST3_FRAME] = lf->ref_deltas[LAST_FRAME];
  lf->ref_deltas[BWDREF_FRAME] = lf->ref_deltas[LAST_FRAME];
#endif  // CONFIG_EXT_REFS
  lf->ref_deltas[GOLDEN_FRAME] = -1;
#if CONFIG_EXT_REFS
  lf->ref_deltas[ALTREF2_FRAME] = -1;
#endif  // CONFIG_EXT_REFS
  lf->ref_deltas[ALTREF_FRAME] = -1;

  lf->mode_deltas[0] = 0;
  lf->mode_deltas[1] = 0;

  av1_copy(lf->last_ref_deltas, lf->ref_deltas);
  av1_copy(lf->last_mode_deltas, lf->mode_deltas);
}

void av1_setup_past_independence(AV1_COMMON *cm) {
  // Reset the segment feature data to the default stats:
  // Features disabled, 0, with delta coding (Default state).
  struct loopfilter *const lf = &cm->lf;

  int i;
  av1_clearall_segfeatures(&cm->seg);
  cm->seg.abs_delta = SEGMENT_DELTADATA;

  if (cm->last_frame_seg_map && !cm->frame_parallel_decode)
    memset(cm->last_frame_seg_map, 0, (cm->mi_rows * cm->mi_cols));

  if (cm->current_frame_seg_map)
    memset(cm->current_frame_seg_map, 0, (cm->mi_rows * cm->mi_cols));

  // Reset the mode ref deltas for loop filter
  av1_zero(lf->last_ref_deltas);
  av1_zero(lf->last_mode_deltas);
  set_default_lf_deltas(lf);

  // To force update of the sharpness
  lf->last_sharpness_level = -1;

  av1_default_coef_probs(cm);
  init_mode_probs(cm->fc);
  av1_init_mv_probs(cm);
#if CONFIG_LV_MAP
  av1_init_lv_map(cm);
#endif
#if CONFIG_PVQ
  av1_default_pvq_probs(cm);
#endif  // CONFIG_PVQ
#if CONFIG_ADAPT_SCAN
  av1_init_scan_order(cm);
#endif
  av1_convolve_init(cm);
  cm->fc->initialized = 1;

#if CONFIG_NO_FRAME_CONTEXT_SIGNALING
  if (cm->frame_type == KEY_FRAME) {
    // Reset all frame contexts, as all reference frames will be lost.
    for (i = 0; i < FRAME_CONTEXTS; ++i) cm->frame_contexts[i] = *cm->fc;
  }
#else
  if (cm->frame_type == KEY_FRAME || cm->error_resilient_mode ||
      cm->reset_frame_context == RESET_FRAME_CONTEXT_ALL) {
    // Reset all frame contexts.
    for (i = 0; i < FRAME_CONTEXTS; ++i) cm->frame_contexts[i] = *cm->fc;
  } else if (cm->reset_frame_context == RESET_FRAME_CONTEXT_CURRENT) {
#if CONFIG_NO_FRAME_CONTEXT_SIGNALING
    // Reset the frame context of the first specified ref frame.
    if (cm->frame_refs[0].idx >= 0) {
      cm->frame_contexts[cm->frame_refs[0].idx] = *cm->fc;
    }
#else
    // Reset only the frame context specified in the frame header.
    cm->frame_contexts[cm->frame_context_idx] = *cm->fc;
#endif  // CONFIG_NO_FRAME_CONTEXT_SIGNALING
  }
#endif  // CONFIG_NO_FRAME_CONTEXT_SIGNALING

  // prev_mip will only be allocated in encoder.
  if (frame_is_intra_only(cm) && cm->prev_mip && !cm->frame_parallel_decode)
    memset(cm->prev_mip, 0,
           cm->mi_stride * (cm->mi_rows + 1) * sizeof(*cm->prev_mip));
#if !CONFIG_NO_FRAME_CONTEXT_SIGNALING
  cm->frame_context_idx = 0;
#endif  // !CONFIG_NO_FRAME_CONTEXT_SIGNALING
}
