# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate import COPY, CONCAT

def migrate(ctx):
    """Bug 1451992 - Migrate Preferences::Subdialogs::Languages to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/languages.ftl',
        'browser/browser/preferences/languages.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('languages-window'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.Header'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            FTL.TextElement('width: '),
                            COPY(
                                'browser/chrome/browser/preferences/languages.dtd',
                                'window.width'
                            )
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-close-key'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('key'),
                        COPY(
                            'toolkit/chrome/global/preferences.dtd',
                            'windowClose.key'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-description'),
                value=COPY(
                    'browser/chrome/browser/preferences/languages.dtd',
                    'languages.customize2.description'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-spoof-english'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.spoofEnglish'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-moveup'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.moveUp.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.moveUp.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-movedown'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.moveDown.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.moveDown.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-remove'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.deleteButton.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.deleteButton.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-select-language'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('placeholder'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.selectLanguage.label'
                        )
                    ),
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('languages-customize-add'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.addButton.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/languages.dtd',
                            'languages.customize.addButton.accesskey'
                        )
                    )
                ]
            )
        ]
    )
