# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate.helpers import MESSAGE_REFERENCE
from fluent.migrate import COPY, CONCAT

def migrate(ctx):
    """Bug 1451992 - Migrate Preferences::Subdialogs::Site Data to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/siteDataSettings.ftl',
        'browser/browser/preferences/siteDataSettings.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('site-data-settings-window'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'window2.title'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-search-textbox'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('placeholder'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'searchTextboxPlaceHolder'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'searchTextboxPlaceHolder.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-column-host'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'hostCol.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-column-cookies'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'cookiesCol.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-column-storage'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'usageCol.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-column-last-used'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'lastAccessedCol.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-remove-selected'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'removeSelected.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'removeSelected.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-button-cancel'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'cancel.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'cancel.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-button-save'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'save.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/siteDataSettings.dtd',
                            'save.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-removing-window'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        CONCAT(
                            MESSAGE_REFERENCE('site-data-removing-header'),
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-removing-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/siteDataSettings.dtd',
                    'removingDialog1.title'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-removing-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/siteDataSettings.dtd',
                    'removingSelected1.description'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('site-data-removing-table'),
                value=COPY(
                    'browser/chrome/browser/preferences/siteDataSettings.dtd',
                    'siteTree3.label'
                )
            )
        ]
    )
