# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate import COPY, CONCAT

def migrate(ctx):
    """Bug 1451992 - Migrate Preferences::Subdialogs::Translation to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/translation.ftl',
        'browser/browser/preferences/translation.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('translation-window'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'window.title'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            FTL.TextElement('width: '),
                            COPY(
                                'browser/chrome/browser/preferences/translation.dtd',
                                'window.width'
                            )
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-close-key'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('key'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'windowClose.key'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-languages-disabled-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/translation.dtd',
                    'noTranslationForLanguages2.label'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('translation-languages-column'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'treehead.languageName.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-languages-button-remove'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeLanguage.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeLanguage.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-languages-button-remove-all'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeAllLanguages.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeAllLanguages.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-sites-disabled-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/translation.dtd',
                    'noTranslationForSites2.label'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('translation-sites-column'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'treehead.siteName2.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-sites-button-remove'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeSite.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeSite.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-sites-button-remove-all'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeAllSites.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'removeAllSites.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('translation-button-close'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'button.close.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/translation.dtd',
                            'button.close.accesskey'
                        )
                    )
                ]
            )
        ]
    )
