import os

config = {
    "robocop_package_name": "org.mozilla.roboexample.test",
    "marionette_address": "%(device_ip)s:2828",
    "marionette_test_manifest": "unit-tests.ini",
    "exes": {},
    "log_tbpl_level": "info",
    "log_raw_level": "info",
    "env": {
        "DISPLAY": ":0.0",
        "PATH": "%(PATH)s",
        "MINIDUMP_SAVEPATH": "%(abs_work_dir)s/../minidumps"
    },
    "default_actions": [
        'clobber',
        'download-and-extract',
        'create-virtualenv',
        'verify-device',
        'install',
        'run-tests',
    ],
    # from android_common.py
    "download_tooltool": True,
    "download_minidump_stackwalk": True,
    # hostutils_manifest_path is relative to branch's root in hg.mozilla.org.
    "hostutils_manifest_path": "testing/config/tooltool-manifests/linux64/hostutils.manifest",
    "tooltool_cache": "/builds/worker/tooltool_cache",
    "tooltool_servers": ['https://api.pub.build.mozilla.org/tooltool/'],
    # minidump_tooltool_manifest_path is relative to workspace/build/tests/
    "minidump_tooltool_manifest_path": "config/tooltool-manifests/linux64/releng.manifest",
    "find_links": [
        "https://pypi.pub.build.mozilla.org/pub",
    ],
    "pip_index": False,
    "suite_definitions": {
        "mochitest": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--screenshot-on-fail",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-gl": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--subsuite=webgl",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-chrome": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--screenshot-on-fail",
                "--flavor=chrome",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-plain-gpu": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--subsuite=gpu",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-plain-clipboard": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--subsuite=clipboard",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "mochitest-media": {
            "run_filename": "runtestsremote.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--screenshot-on-fail",
                "--chunk-by-runtime",
                "--subsuite=media",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "robocop": {
            "run_filename": "runrobocop.py",
            "testsdir": "mochitest",
            "options": [
                "--app=%(app)s",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--certificate-path=%(certs_path)s",
                "--symbols-path=%(symbols_path)s",
                "--quiet",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--robocop-apk=../../robocop.apk",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "reftest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--httpd-path", "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--extra-profile-file=fonts",
                "--extra-profile-file=hyphenation",
                "--suite=reftest",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["tests/layout/reftests/reftest.list",],
        },
        "crashtest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s",
                "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s",
                "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s",
                "--httpd-path",
                "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--suite=crashtest",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["tests/testing/crashtest/crashtests.list",],
        },
        "jittest": {
            "run_filename": "jit_test.py",
            "testsdir": "jit-test/jit-test",
            "options": [
                "../../bin/js",
                "--remote",
                "-j",
                "1",
                "--localLib=../../bin",
                "--no-slow",
                "--no-progress",
                "--format=automation",
                "--jitflags=all",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "jsreftest": {
            "run_filename": "remotereftest.py",
            "testsdir": "reftest",
            "options": [
                "--app=%(app)s",
                "--ignore-window-size",
                "--remote-webserver=%(remote_webserver)s", "--xre-path=%(xre_path)s",
                "--utility-path=%(utility_path)s", "--http-port=%(http_port)s",
                "--ssl-port=%(ssl_port)s", "--httpd-path", "%(modules_dir)s",
                "--symbols-path=%(symbols_path)s",
                "--extra-profile-file=jsreftest/tests/user.js",
                "--suite=jstestbrowser",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--deviceSerial=%(device_serial)s",
            ],
            "tests": ["../jsreftest/tests/jstests.list",],
        },
        "xpcshell": {
            "run_filename": "remotexpcshelltests.py",
            "testsdir": "xpcshell",
            "install": False,
            "options": [
                "--xre-path=%(xre_path)s",
                "--testing-modules-dir=%(modules_dir)s",
                "--apk=%(installer_path)s",
                "--no-logfiles",
                "--symbols-path=%(symbols_path)s",
                "--manifest=tests/xpcshell.ini",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--test-plugin-path=none",
                "--deviceSerial=%(device_serial)s",
                "--remoteTestRoot=/data/local/tests",
            ],
        },
        "cppunittest": {
            "run_filename": "remotecppunittests.py",
            "testsdir": "cppunittest",
            "install": False,
            "options": [
                "--symbols-path=%(symbols_path)s",
                "--xre-path=%(xre_path)s",
                "--localBinDir=../bin",
                "--apk=%(installer_path)s",
                ".",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "marionette": {
            "run_filename": os.path.join("harness", "marionette_harness", "runtests.py"),
            "testsdir": "marionette",
            "options": [
                "--app=fennec",
                "--package=%(app)s",
                "--address=%(address)s",
                "%(test_manifest)s",
                "--disable-e10s",
                "--gecko-log=%(gecko_log)s",
                "--log-raw=%(raw_log_file)s",
                "--log-raw-level=%(log_raw_level)s",
                "--log-errorsummary=%(error_summary_file)s",
                "--log-tbpl-level=%(log_tbpl_level)s",
                "--symbols-path=%(symbols_path)s",
                "--startup-timeout=300",
                "--device=%(device_serial)s",
            ],
        },
        "geckoview": {
            "run_filename": "rungeckoview.py",
            "testsdir": "mochitest",
            "options": [
                "--utility-path=%(utility_path)s",
                "--symbols-path=%(symbols_path)s",
                "--deviceSerial=%(device_serial)s",
            ],
        },
        "geckoview-junit": {
            "run_filename": "runjunit.py",
            "testsdir": "mochitest",
            "options": [
                "--certificate-path=%(certs_path)s",
                "--remote-webserver=%(remote_webserver)s",
                "--symbols-path=%(symbols_path)s",
                "--utility-path=%(utility_path)s",
                "--deviceSerial=%(device_serial)s",
            ],
        },

    },  # end suite_definitions
}
