"""
/*
 * Copyright (c) 2018, Henry Corrigan-Gibbs
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. 
 */
"""


# Has a subgroup of order 2^19
modulus = int('0x8000000000000000080001', 16)
# Generates the subgroup of order 2^19
gen19 = int('0x2597c14f48d5b65ed8dcca', 16)

# We want a generator of order 2^12, so compute
#   gen19^(2^7) = gen19^128   (mod p)
gen12 = gen19
for i in range(7):
    gen12 *= gen12
    gen12 %= modulus
    #print gen12

# Sanity check
rootsL = [1] * 2**12
rootsInvL = [1] * 2**12
for i in range(1, 2**12):
    rootsL[i] = (rootsL[i-1] * gen12) % modulus

assert ((rootsL[2**12 - 1] * gen12) % modulus) == 1

gen12inv = rootsL[2**12 - 1]
for i in range(1, 2**12):
    rootsInvL[i] = (rootsInvL[i-1] * gen12inv) % modulus
    
    assert rootsInvL[i] != 1 
assert ((rootsInvL[2**12 - 1] * gen12inv) % modulus) == 1

rootsL = map(lambda x: '   "%x"' % x, rootsL)
rootsInvL = map(lambda x: '   "%x"' % x, rootsInvL)

roots = ",\n".join(rootsL)
rootsInv = ",\n".join(rootsInvL)

output = """
/*
 * Copyright (c) 2018, Henry Corrigan-Gibbs
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. 
 */

/****
 * NOTE: This file was auto-generated from gen_params.py.
 * Do not edit this file. Instead, edit the script.
 */

#ifndef __PARAMS_H__
#define __PARAMS_H__

// A prime modulus p.
static const char *Modulus = "%(modulus)x";

// A generator g of a subgroup of Z*_p.
// static const char *Generator = "%(generator)x";

// The generator g generates a subgroup of
// order 2^IntGen2Order in Z*_p.
static const int Generator2Order = %(twoorder)d;

static const char *Roots[] = {
    %(roots)s
};

static const char *RootsInv[] = {
    %(rootsInv)s
};

#endif /* __PARAMS_H__ */
""" % {
    'modulus': modulus,
    'generator': gen12,
    'twoorder': 12,
    'roots': roots, 
    'rootsInv': rootsInv, 
}

print output
