/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const actionTypes = {
  ADB_ADDON_INSTALL_START: "ADB_ADDON_INSTALL_START",
  ADB_ADDON_INSTALL_SUCCESS: "ADB_ADDON_INSTALL_SUCCESS",
  ADB_ADDON_INSTALL_FAILURE: "ADB_ADDON_INSTALL_FAILURE",
  ADB_ADDON_UNINSTALL_START: "ADB_ADDON_UNINSTALL_START",
  ADB_ADDON_UNINSTALL_SUCCESS: "ADB_ADDON_UNINSTALL_SUCCESS",
  ADB_ADDON_UNINSTALL_FAILURE: "ADB_ADDON_UNINSTALL_FAILURE",
  ADB_ADDON_STATUS_UPDATED: "ADB_ADDON_STATUS_UPDATED",
  CONNECT_RUNTIME_FAILURE: "CONNECT_RUNTIME_FAILURE",
  CONNECT_RUNTIME_START: "CONNECT_RUNTIME_START",
  CONNECT_RUNTIME_SUCCESS: "CONNECT_RUNTIME_SUCCESS",
  DEBUG_TARGET_COLLAPSIBILITY_UPDATED: "DEBUG_TARGET_COLLAPSIBILITY_UPDATED",
  DISCONNECT_RUNTIME_FAILURE: "DISCONNECT_RUNTIME_FAILURE",
  DISCONNECT_RUNTIME_START: "DISCONNECT_RUNTIME_START",
  DISCONNECT_RUNTIME_SUCCESS: "DISCONNECT_RUNTIME_SUCCESS",
  NETWORK_LOCATIONS_UPDATED: "NETWORK_LOCATIONS_UPDATED",
  PAGE_SELECTED: "PAGE_SELECTED",
  REQUEST_EXTENSIONS_FAILURE: "REQUEST_EXTENSIONS_FAILURE",
  REQUEST_EXTENSIONS_START: "REQUEST_EXTENSIONS_START",
  REQUEST_EXTENSIONS_SUCCESS: "REQUEST_EXTENSIONS_SUCCESS",
  REQUEST_TABS_FAILURE: "REQUEST_TABS_FAILURE",
  REQUEST_TABS_START: "REQUEST_TABS_START",
  REQUEST_TABS_SUCCESS: "REQUEST_TABS_SUCCESS",
  REQUEST_WORKERS_FAILURE: "REQUEST_WORKERS_FAILURE",
  REQUEST_WORKERS_START: "REQUEST_WORKERS_START",
  REQUEST_WORKERS_SUCCESS: "REQUEST_WORKERS_SUCCESS",
  UNWATCH_RUNTIME_FAILURE: "UNWATCH_RUNTIME_FAILURE",
  UNWATCH_RUNTIME_START: "UNWATCH_RUNTIME_START",
  UNWATCH_RUNTIME_SUCCESS: "UNWATCH_RUNTIME_SUCCESS",
  USB_RUNTIMES_UPDATED: "USB_RUNTIMES_UPDATED",
  WATCH_RUNTIME_FAILURE: "WATCH_RUNTIME_FAILURE",
  WATCH_RUNTIME_START: "WATCH_RUNTIME_START",
  WATCH_RUNTIME_SUCCESS: "WATCH_RUNTIME_SUCCESS",
};

const DEBUG_TARGETS = {
  EXTENSION: "EXTENSION",
  TAB: "TAB",
  WORKER: "WORKER",
};

const DEBUG_TARGET_PANE = {
  INSTALLED_EXTENSION: "installedExtension",
  OTHER_WORKER: "otherWorker",
  SERVICE_WORKER: "serviceWorker",
  SHARED_WORKER: "sharedWorker",
  TAB: "tab",
  TEMPORARY_EXTENSION: "temporaryExtension",
};

const PAGES = {
  THIS_FIREFOX: "this-firefox",
  CONNECT: "connect",
};

const RUNTIMES = {
  NETWORK: "network",
  THIS_FIREFOX: "this-firefox",
  USB: "usb",
};

const SERVICE_WORKER_FETCH_STATES = {
  LISTENING: "LISTENING",
  NOT_LISTENING: "NOT_LISTENING",
};

const SERVICE_WORKER_STATUSES = {
  RUNNING: "RUNNING",
  REGISTERING: "REGISTERING",
  STOPPED: "STOPPED",
};

const USB_STATES = {
  DISABLED_USB: "DISABLED_USB",
  ENABLED_USB: "ENABLED_USB",
  UPDATING_USB: "UPDATING_USB",
};

// flatten constants
module.exports = Object.assign({}, {
  DEBUG_TARGETS,
  DEBUG_TARGET_PANE,
  PAGES,
  RUNTIMES,
  SERVICE_WORKER_FETCH_STATES,
  SERVICE_WORKER_STATUSES,
  USB_STATES,
}, actionTypes);
