// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar<p>extra",
    [["justifyleft",""]],
    "foo[]bar<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<span>foo</span>{}<span>bar</span><p>extra",
    [["justifyleft",""]],
    "<span>foo</span>{}<span>bar</span><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<span>foo[</span><span>]bar</span><p>extra",
    [["justifyleft",""]],
    "<span>foo[</span><span>]bar</span><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[bar]baz<p>extra",
    [["justifyleft",""]],
    "foo[bar]baz<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["foo[bar<b>baz]qoz</b>quz<p>extra",
    [["justifyleft",""]],
    "foo[bar<b>baz]qoz</b>quz<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>foo[]bar<p>extra",
    [["justifyleft",""]],
    "<p>foo[]bar</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>foo[bar]baz<p>extra",
    [["justifyleft",""]],
    "<p>foo[bar]baz</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<h1>foo[bar]baz</h1><p>extra",
    [["justifyleft",""]],
    "<h1>foo[bar]baz</h1><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<pre>foo[bar]baz</pre><p>extra",
    [["justifyleft",""]],
    "<pre>foo[bar]baz</pre><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<xmp>foo[bar]baz</xmp><p>extra",
    [["justifyleft",""]],
    "<xmp>foo[bar]baz</xmp><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<center><p>[foo]<p>bar</center><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<center><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></center><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<center><p>[foo]<p>bar</center><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<center><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></center><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<center><p>[foo]<p>bar</center><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<center><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></center><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<center><p>[foo]<p>bar</center><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<center><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></center><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<center><p>[foo<p>bar]</center><p>extra",
    [["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true],
    {"justifyleft":[false,false,"center",false,true,"left"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr>{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}<p>extra",
    [["justifyleft",""]],
    "{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table align=left><tbody><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table align=\"left\"><tbody><tr><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table align=left><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table align=\"left\"><tbody><tr><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table align=left><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table align=\"left\"><tbody><tr>{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table align=left><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table align=left data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["{<table align=left><tr><td>foo<td>bar<td>baz</table>}<p>extra",
    [["justifyleft",""]],
    "{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody align=left><tr><td>foo<td>b[a]r<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody align=\"left\"><tr><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody align=left><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody align=\"left\"><tr><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody align=left><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody align=\"left\"><tr>{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody align=left data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table data-start=0 data-end=1><tbody align=left><tr><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["{<table><tbody align=left><tr><td>foo<td>bar<td>baz</table>}<p>extra",
    [["justifyleft",""]],
    "{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody><tr align=left><td>foo<td>b[a]r<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr align=\"left\"><td>foo</td><td>b[a]r</td><td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody><tr align=left data-start=1 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr align=\"left\"><td>foo</td>{<td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody><tr align=left data-start=0 data-end=2><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody><tr align=\"left\">{<td>foo</td><td>bar</td>}<td>baz</td></tr></tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table><tbody data-start=0 data-end=1><tr align=left><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table><tbody>{<tr><td>foo</td><td>bar</td><td>baz</td></tr>}</tbody></table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<table data-start=0 data-end=1><tbody><tr align=left><td>foo<td>bar<td>baz</table><p>extra",
    [["justifyleft",""]],
    "<table>{<tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody>}</table><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["{<table><tr align=left><td>foo<td>bar<td>baz</table>}<p>extra",
    [["justifyleft",""]],
    "{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=center><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=center><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:center\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div style=text-align:center><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"center",false,true,"left"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=justify><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=justify><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:justify\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div style=text-align:justify><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"justify",false,true,"left"]}],
["<div align=left><p>[foo]<p>bar</div><p>extra",
    [["justifyleft",""]],
    "<div align=\"left\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>[foo]<p>bar</div><p>extra",
    [["justifyleft",""]],
    "<div style=\"text-align:left\"><p>[foo]</p><p>bar</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div align=\"right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div align=\"right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=right><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=right><p>[foo<p>bar}</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar}</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo]<p>bar</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:right\"><div style=\"text-align:left\"><p>[foo]</p></div><p>bar</p></div><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:right><p>[foo<p>bar]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo</p><p>bar]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div align=left>foo</div>[bar]<p>extra",
    [["justifyleft",""]],
    "<div align=\"left\">foo</div>[bar]<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["[foo]<div align=left>bar</div><p>extra",
    [["justifyleft",""]],
    "[foo]<div align=\"left\">bar</div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left>foo</div>[bar]<div align=left>baz</div><p>extra",
    [["justifyleft",""]],
    "<div align=\"left\">foo</div>[bar]<div align=\"left\">baz</div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>foo</div><p>[bar]<p>extra",
    [["justifyleft",""]],
    "<div align=\"left\"><p>foo</p></div><p>[bar]</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>[foo]<div align=left><p>bar</div><p>extra",
    [["justifyleft",""]],
    "<p>[foo]</p><div align=\"left\"><p>bar</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>foo</div><p>[bar]<div align=left><p>baz</div><p>extra",
    [["justifyleft",""]],
    "<div align=\"left\"><p>foo</p></div><p>[bar]</p><div align=\"left\"><p>baz</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>foo</div>[bar]<p>extra",
    [["justifyleft",""]],
    "<div style=\"text-align:left\">foo</div>[bar]<p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["[foo]<div style=text-align:left>bar</div><p>extra",
    [["justifyleft",""]],
    "[foo]<div style=\"text-align:left\">bar</div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>foo</div>[bar]<div style=text-align:left>baz</div><p>extra",
    [["justifyleft",""]],
    "<div style=\"text-align:left\">foo</div>[bar]<div style=\"text-align:left\">baz</div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>foo</div><p>[bar]<p>extra",
    [["justifyleft",""]],
    "<div style=\"text-align:left\"><p>foo</p></div><p>[bar]</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>[foo]<div style=text-align:left><p>bar</div><p>extra",
    [["justifyleft",""]],
    "<p>[foo]</p><div style=\"text-align:left\"><p>bar</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>foo</div><p>[bar]<div style=text-align:left><p>baz</div><p>extra",
    [["justifyleft",""]],
    "<div style=\"text-align:left\"><p>foo</p></div><p>[bar]</p><div style=\"text-align:left\"><p>baz</p></div><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p align=left>foo<p>[bar]<p>extra",
    [["justifyleft",""]],
    "<p align=\"left\">foo</p><p>[bar]</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>[foo]<p align=left>bar<p>extra",
    [["justifyleft",""]],
    "<p>[foo]</p><p align=\"left\">bar</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p align=left>foo<p>[bar]<p align=left>baz<p>extra",
    [["justifyleft",""]],
    "<p align=\"left\">foo</p><p>[bar]</p><p align=\"left\">baz</p><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left>[foo</div>bar]<p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left>[foo</div>bar]<p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left>fo[o</div>b]ar<p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left>fo[o</div>b]ar<p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo</div>bar]<p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo</div>bar]<p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo</div>bar]<p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo</div>bar]<p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo<br>bar]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>fo[o</div>b]ar<p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>fo[o</div>b]ar<p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>fo[o</div>b]ar<p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>fo[o</div>b]ar<p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "fo[o<br>b]ar<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<span style=text-align:left>[foo]</span><p>extra",
    [["stylewithcss","true"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["<span style=text-align:left>[foo]</span><p>extra",
    [["stylewithcss","false"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["<span style=text-align:left>f[o]o</span><p>extra",
    [["stylewithcss","true"],["justifyleft",""]],
    "f[o]o<p>extra</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["<span style=text-align:left>f[o]o</span><p>extra",
    [["stylewithcss","false"],["justifyleft",""]],
    "f[o]o<p>extra</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo<div style=text-align:left contenteditable=false>bar</div>baz]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo<div style=\"text-align:left\" contenteditable=\"false\">bar</div>baz]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo<div style=text-align:left contenteditable=false>bar</div>baz]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo<div style=\"text-align:left\" contenteditable=\"false\">bar</div>baz]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo<div style=text-align:left contenteditable=false>bar</div>baz]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo<div style=\"text-align:left\" contenteditable=\"false\">bar</div>baz]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left>[foo<div style=text-align:left contenteditable=false>bar</div>baz]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo<div style=\"text-align:left\" contenteditable=\"false\">bar</div>baz]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=nonsense><p>[foo]</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=nonsense><p>[foo]</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:inherit><p>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:inherit><p>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:inherit><p>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:inherit><p>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "<p>[foo]</p><p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<quasit align=center><p>[foo]</p></quasit><p>extra",
    [["justifyleft",""]],
    "<quasit><p>[foo]</p></quasit><p>extra</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:start>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:start>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:start>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:start>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:end>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:end>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","div"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"div",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:end>[foo]</div><p>extra",
    [["stylewithcss","true"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,false,"",false,true,""],"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div style=text-align:end>[foo]</div><p>extra",
    [["stylewithcss","false"],["defaultparagraphseparator","p"],["justifyleft",""]],
    "[foo]<p>extra</p>",
    [true,true,true],
    {"stylewithcss":[false,true,"",false,false,""],"defaultparagraphseparator":[false,false,"p",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div dir=rtl style=text-align:start>[foo]</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:left\"><div dir=\"rtl\">[foo]</div></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div dir=rtl style=text-align:start>[foo]</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:left\"><div dir=\"rtl\">[foo]</div></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,false,"right",false,true,"left"]}],
["<div dir=rtl style=text-align:end>[foo]</div><p>extra",
    [["defaultparagraphseparator","div"],["justifyleft",""]],
    "<div style=\"text-align:left\"><div dir=\"rtl\">[foo]</div></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div dir=rtl style=text-align:end>[foo]</div><p>extra",
    [["defaultparagraphseparator","p"],["justifyleft",""]],
    "<div style=\"text-align:left\"><div dir=\"rtl\">[foo]</div></div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>foo</div> <p>[bar]",
    [["justifyleft",""]],
    "<div style=\"text-align:left\"><p>foo</p></div> <p>[bar]</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>foo</div> <p>[bar]",
    [["justifyleft",""]],
    "<div align=\"left\"><p>foo</p></div> <p>[bar]</p>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>[foo]</p> <div style=text-align:left><p>bar</div>",
    [["justifyleft",""]],
    "<p>[foo]</p> <div style=\"text-align:left\"><p>bar</p></div>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<p>[foo]</p> <div align=left><p>bar</div>",
    [["justifyleft",""]],
    "<p>[foo]</p> <div align=\"left\"><p>bar</p></div>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div style=text-align:left><p>foo</div> <p>[bar]</p> <div style=text-align:left><p>baz</div>",
    [["justifyleft",""]],
    "<div style=\"text-align:left\"><p>foo</p></div> <p>[bar]</p> <div style=\"text-align:left\"><p>baz</p></div>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}],
["<div align=left><p>foo</div> <p>[bar]</p> <div align=left><p>baz</div>",
    [["justifyleft",""]],
    "<div align=\"left\"><p>foo</p></div> <p>[bar]</p> <div align=\"left\"><p>baz</p></div>",
    [true],
    {"justifyleft":[false,true,"left",false,true,"left"]}]
]
