/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef GFX_VR_BLINDING_OPENVRCOSMOSBINDING_H
#define GFX_VR_BLINDING_OPENVRCOSMOSBINDING_H

namespace mozilla {
namespace gfx {

struct OpenVRCosmosBinding {
  const char* binding =
      // clang-format off
  "{\n"
    "  \"version\" : \"0.1\", \n"
    "  \"controller_type\" : \"vive_cosmos_controller\", \n"
    "  \"description\" : \"Bindings for Firefox OpenVR for the Vive Cosmos controller\", \n"
    "  \"name\" : \"Firefox bindings for Vive Cosmos Controller\", \n"
    "  \"bindings\" : { \n"
    "     \"/actions/firefox\" : { \n"
    "         \"poses\" : [        \n"
    "           {                \n"
    "             \"output\" : \"/actions/firefox/in/LHand_pose\", \n"
    "              \"path\" : \"/user/hand/left/pose/raw\"     \n"
    "            },\n"
    "            {                                             \n"
    "              \"output\" : \"/actions/firefox/in/RHand_pose\", \n"
    "              \"path\" : \"/user/hand/right/pose/raw\"    \n"
    "            }\n"
    "         ],\n"
    "         \"haptics\" : [ \n"
    "            {\n"
    "              \"output\" : \"/actions/firefox/out/LHand_haptic\",  \n"
    "              \"path\" : \"/user/hand/left/output/haptic\"     \n"
    "            },\n"
    "            { \n"
    "              \"output\" : \"/actions/firefox/out/RHand_haptic\", \n"
    "              \"path\" : \"/user/hand/right/output/haptic\"    \n"
    "            }\n"
    "		  ],\n"
    "       \"sources\" : [ \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"pull\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_trigger_value\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"trigger\", \n"
    "             \"path\" : \"/user/hand/left/input/trigger\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"pull\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_trigger_value\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"trigger\", \n"
    "             \"path\" : \"/user/hand/right/input/trigger\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "               \"click\" : { \n"
    "                \"output\" : \"/actions/firefox/in/LHand_grip_pressed\" \n"
    "              }, \n"
    "               \"touch\" : { \n"
    "                \"output\" : \"/actions/firefox/in/LHand_grip_touched\" \n"
    "              } \n"
    "             }, \n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/left/input/paddle_heavy\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "               \"click\" : { \n"
    "                \"output\" : \"/actions/firefox/in/RHand_grip_pressed\" \n"
    "              }, \n"
    "               \"touch\" : { \n"
    "                 \"output\" : \"/actions/firefox/in/RHand_grip_touched\" \n"
    "              } \n"
    "           }, \n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/right/input/paddle_heavy\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_system_pressed\"  \n"
    "                   }, \n"
    "                 \"touch\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_system_touched\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/left/input/system\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_system_pressed\"  \n"
    "                   }, \n"
    "                 \"touch\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_system_touched\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/right/input/system\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_a_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/left/input/a\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_a_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/right/input/a\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_b_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/left/input/b\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_b_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/right/input/b\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "               \"position\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/LHand_thumbstick_analog\" \n"
    "               }, \n"
    "               \"click\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/LHand_thumbstick_pressed\" \n"
    "               }, \n"
    "               \"touch\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/LHand_thumbstick_touched\" \n"
    "               } \n"
    "             }, \n"
    "             \"mode\" : \"joystick\", \n"
    "             \"path\" : \"/user/hand/left/input/joystick\" \n"
    "           },\n"
    "           {\n"
    "             \"inputs\" : { \n"
    "               \"position\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/RHand_thumbstick_analog\" \n"
    "               }, \n"
    "               \"click\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/RHand_thumbstick_pressed\" \n"
    "               }, \n"
    "               \"touch\" : { \n"
    "                   \"output\" : \"/actions/firefox/in/RHand_thumbstick_touched\" \n"
    "               } \n"
    "             }, \n"
    "             \"mode\" : \"joystick\", \n"
    "             \"path\" : \"/user/hand/right/input/joystick\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/LHand_bumper_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/left/input/bumper\" \n"
    "           }, \n"
    "           {\n"
    "             \"inputs\" : { \n"
    "                 \"click\" : { \n"
    "                    \"output\" : \"/actions/firefox/in/RHand_bumper_pressed\"  \n"
    "                   } \n"
    "              },\n"
    "             \"mode\" : \"button\", \n"
    "             \"path\" : \"/user/hand/right/input/bumper\" \n"
    "           } \n"
    "         ]\n"
    "     }\n"
    "  }\n"
    "}";
  // clang-format on
};

}  // namespace gfx
}  // namespace mozilla

#endif  // GFX_VR_BLINDING_OPENVRCOSMOSBINDING_H
