/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef GFX_VR_BLINDING_OPENVRWMRBINDING_H
#define GFX_VR_BLINDING_OPENVRWMRBINDING_H

namespace mozilla {
namespace gfx {

struct OpenVRWMRBinding {
  const char* binding =
      // clang-format off
  "{\n"
  "  \"version\" : \"0.1\", \n"
  "  \"controller_type\" : \"holographic_controller\", \n"
  "  \"description\" : \"Bindings for Firefox OpenVR for the Windows Mixed Reality controller\", \n"
  "  \"name\" : \"Firefox bindings for Mixed Reality Controller\", \n"
  "  \"bindings\" : { \n"
  "     \"/actions/firefox\" : { \n"
  "         \"poses\" : [        \n"
  "           {                \n"
  "             \"output\" : \"/actions/firefox/in/LHand_pose\", \n"
  "              \"path\" : \"/user/hand/left/pose/raw\"     \n"
  "            },\n"
  "            {                                             \n"
  "              \"output\" : \"/actions/firefox/in/RHand_pose\", \n"
  "              \"path\" : \"/user/hand/right/pose/raw\"    \n"
  "            }\n"
  "         ],\n"
  "         \"haptics\" : [ \n"
  "            {\n"
  "              \"output\" : \"/actions/firefox/out/LHand_haptic\",  \n"
  "              \"path\" : \"/user/hand/left/output/haptic\"     \n"
  "            },\n"
  "            { \n"
  "              \"output\" : \"/actions/firefox/out/RHand_haptic\", \n"
  "              \"path\" : \"/user/hand/right/output/haptic\"    \n"
  "            }\n"
  "		  ],\n"
  "       \"sources\" : [ \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"position\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/LHand_trackpad_analog\" \n"
  "               }, \n"
  "               \"click\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/LHand_trackpad_pressed\" \n"
  "               }, \n"
  "               \"touch\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/LHand_trackpad_touched\" \n"
  "               } \n"
  "             }, \n"
  "             \"mode\" : \"trackpad\", \n"
  "             \"path\" : \"/user/hand/left/input/trackpad\" \n"
  "           },\n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"position\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/RHand_trackpad_analog\" \n"
  "               }, \n"
  "               \"click\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/RHand_trackpad_pressed\" \n"
  "               }, \n"
  "               \"touch\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/RHand_trackpad_touched\" \n"
  "               } \n"
  "             }, \n"
  "             \"mode\" : \"trackpad\", \n"
  "             \"path\" : \"/user/hand/right/input/trackpad\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"pull\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/LHand_trigger_value\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"trigger\", \n"
  "             \"path\" : \"/user/hand/left/input/trigger\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"pull\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/RHand_trigger_value\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"trigger\", \n"
  "             \"path\" : \"/user/hand/right/input/trigger\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"click\" : { \n"
  "                \"output\" : \"/actions/firefox/in/LHand_grip_pressed\" \n"
  "              }, \n"
  "               \"touch\" : { \n"
  "                 \"output\" : \"/actions/firefox/in/LHand_grip_touched\" \n"
  "              } \n"
  "             }, \n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/left/input/grip\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"click\" : { \n"
  "                \"output\" : \"/actions/firefox/in/RHand_grip_pressed\" \n"
  "              }, \n"
  "               \"touch\" : { \n"
  "                 \"output\" : \"/actions/firefox/in/RHand_grip_touched\" \n"
  "              } \n"
  "             }, \n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/right/input/grip\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"click\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/LHand_menu_pressed\"  \n"
  "                   }, \n"
  "                 \"touch\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/LHand_menu_touched\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/left/input/application_menu\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"click\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/RHand_menu_pressed\"  \n"
  "                   }, \n"
  "                 \"touch\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/RHand_menu_touched\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/right/input/application_menu\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"click\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/LHand_system_pressed\"  \n"
  "                   }, \n"
  "                 \"touch\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/LHand_system_touched\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/left/input/system\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "                 \"click\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/RHand_system_pressed\"  \n"
  "                   }, \n"
  "                 \"touch\" : { \n"
  "                    \"output\" : \"/actions/firefox/in/RHand_system_touched\"  \n"
  "                   } \n"
  "              },\n"
  "             \"mode\" : \"button\", \n"
  "             \"path\" : \"/user/hand/right/input/system\" \n"
  "           }, \n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"position\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/LHand_thumbstick_analog\" \n"
  "               } \n"
  "             }, \n"
  "             \"mode\" : \"joystick\", \n"
  "             \"path\" : \"/user/hand/left/input/joystick\" \n"
  "           },\n"
  "           {\n"
  "             \"inputs\" : { \n"
  "               \"position\" : { \n"
  "                   \"output\" : \"/actions/firefox/in/RHand_thumbstick_analog\" \n"
  "               } \n"
  "             }, \n"
  "             \"mode\" : \"joystick\", \n"
  "             \"path\" : \"/user/hand/right/input/joystick\" \n"
  "           } \n"
  "         ]\n"
  "     }\n"
  "  }\n"
  "}";
  // clang-format on
};

}  // namespace gfx
}  // namespace mozilla

#endif  // GFX_VR_BLINDING_OPENVRWMRBINDING_H
