/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mozilla/ModuleUtils.h"

#include "nsShellService.h"

NS_GENERIC_FACTORY_CONSTRUCTOR(nsShellService)
NS_DEFINE_NAMED_CID(nsShellService_CID);

static const mozilla::Module::CIDEntry kBrowserCIDs[] = {
    {&knsShellService_CID, false, nullptr, nsShellServiceConstructor},
    {nullptr}};

static const mozilla::Module::ContractIDEntry kBrowserContracts[] = {
    {nsShellService_ContractID, &knsShellService_CID}, {nullptr}};

extern const mozilla::Module kBrowserModule = {mozilla::Module::kVersion,
                                               kBrowserCIDs, kBrowserContracts};
