/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

/* import-globals-from ../../mochitest/role.js */
/* import-globals-from ../../mochitest/states.js */
loadScripts(
  { name: "role.js", dir: MOCHITESTS_DIR },
  { name: "states.js", dir: MOCHITESTS_DIR }
);

/**
 * Test aria tabs
 */
addAccessibleTask("mac/doc_aria_tabs.html", async (browser, accDoc) => {
  let tablist = getNativeInterface(accDoc, "tablist");
  is(
    tablist.getAttributeValue("AXRole"),
    "AXTabGroup",
    "Correct role for tablist"
  );

  let tabMacAccs = tablist.getAttributeValue("AXTabs");
  is(tabMacAccs.length, 3, "3 items in AXTabs");

  let selectedTabs = tablist.getAttributeValue("AXSelectedChildren");
  is(selectedTabs.length, 1, "one selected tab");

  let tab = selectedTabs[0];
  is(tab.getAttributeValue("AXRole"), "AXRadioButton", "Correct role for tab");
  is(
    tab.getAttributeValue("AXSubrole"),
    "AXTabButton",
    "Correct subrole for tab"
  );
  is(tab.getAttributeValue("AXTitle"), "First Tab", "Correct title for tab");

  let tabToSelect = tabMacAccs[1];
  is(
    tabToSelect.getAttributeValue("AXTitle"),
    "Second Tab",
    "Correct title for tab"
  );

  let actions = tabToSelect.actionNames;
  ok(true, actions);
  ok(actions.includes("AXPress"), "Has switch action");

  let evt = waitForMacEvent("AXSelectedChildrenChanged");
  tabToSelect.performAction("AXPress");
  await evt;

  selectedTabs = tablist.getAttributeValue("AXSelectedChildren");
  is(selectedTabs.length, 1, "one selected tab");
  is(
    selectedTabs[0].getAttributeValue("AXTitle"),
    "Second Tab",
    "Correct title for tab"
  );
});

addAccessibleTask('<p id="p">hello</p>', async (browser, accDoc) => {
  let p = getNativeInterface(accDoc, "p");
  ok(
    p.attributeNames.includes("AXSelected"),
    "html element includes 'AXSelected' attribute"
  );
  is(p.getAttributeValue("AXSelected"), false, "AX selected is 'false'");
});
