// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_ext_autogen.cpp:
//   Defines the GLES extension entry points.

#include "libGLESv2/entry_points_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture_gles_ext_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationESEXT.h"
#include "libGLESv2/global_state.h"

#include "libANGLE/capture_gles_1_0_autogen.h"
#include "libANGLE/capture_gles_2_0_autogen.h"
#include "libANGLE/capture_gles_3_0_autogen.h"
#include "libANGLE/capture_gles_3_1_autogen.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"

namespace gl
{

// GL_ANGLE_copy_texture_3d
void GL_APIENTRY CopyTexture3DANGLE(GLuint sourceId,
                                    GLint sourceLevel,
                                    GLenum destTarget,
                                    GLuint destId,
                                    GLint destLevel,
                                    GLint internalFormat,
                                    GLenum destType,
                                    GLboolean unpackFlipY,
                                    GLboolean unpackPremultiplyAlpha,
                                    GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = 0x%X, GLboolean "
        "unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha "
        "= %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, internalFormat, destType, unpackFlipY,
        unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopyTexture3DANGLE, context, sourceId, sourceLevel, destTargetPacked, destId,
                      destLevel, internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopyTexture3DANGLE(context, sourceId, sourceLevel, destTargetPacked, destId,
                                       destLevel, internalFormat, destType, unpackFlipY,
                                       unpackPremultiplyAlpha, unpackUnmultiplyAlpha))
        {
            context->copyTexture3D(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                   internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                   unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY CopySubTexture3DANGLE(GLuint sourceId,
                                       GLint sourceLevel,
                                       GLenum destTarget,
                                       GLuint destId,
                                       GLint destLevel,
                                       GLint xoffset,
                                       GLint yoffset,
                                       GLint zoffset,
                                       GLint x,
                                       GLint y,
                                       GLint z,
                                       GLint width,
                                       GLint height,
                                       GLint depth,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint zoffset = %d, "
        "GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height = %d, GLint "
        "depth = %d, GLboolean unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean "
        "unpackUnmultiplyAlpha = %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, xoffset, yoffset, zoffset, x, y, z,
        width, height, depth, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopySubTexture3DANGLE, context, sourceId, sourceLevel, destTargetPacked,
                      destId, destLevel, xoffset, yoffset, zoffset, x, y, z, width, height, depth,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopySubTexture3DANGLE(context, sourceId, sourceLevel, destTargetPacked, destId,
                                          destLevel, xoffset, yoffset, zoffset, x, y, z, width,
                                          height, depth, unpackFlipY, unpackPremultiplyAlpha,
                                          unpackUnmultiplyAlpha))
        {
            context->copySubTexture3D(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                      xoffset, yoffset, zoffset, x, y, z, width, height, depth,
                                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
    }
}

// GL_ANGLE_framebuffer_blit
void GL_APIENTRY BlitFramebufferANGLE(GLint srcX0,
                                      GLint srcY0,
                                      GLint srcX1,
                                      GLint srcY1,
                                      GLint dstX0,
                                      GLint dstY0,
                                      GLint dstX1,
                                      GLint dstY1,
                                      GLbitfield mask,
                                      GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BlitFramebufferANGLE, context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0,
                      dstX1, dstY1, mask, filter);
        if (context->skipValidation() ||
            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                                         dstY1, mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

// GL_ANGLE_framebuffer_multisample
void GL_APIENTRY RenderbufferStorageMultisampleANGLE(GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderbufferStorageMultisampleANGLE, context, target, samples, internalformat,
                      width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisampleANGLE(context, target, samples, internalformat,
                                                        width, height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

// GL_ANGLE_instanced_arrays
void GL_APIENTRY DrawArraysInstancedANGLE(GLenum mode,
                                          GLint first,
                                          GLsizei count,
                                          GLsizei primcount)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d, GLsizei primcount = %d)",
          mode, first, count, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, context, modePacked, first, count, primcount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount))
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedANGLE(GLenum mode,
                                            GLsizei count,
                                            GLenum type,
                                            const void *indices,
                                            GLsizei primcount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei primcount = %d)",
        mode, count, type, (uintptr_t)indices, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, context, modePacked, count, typePacked, indices,
                      primcount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstancedANGLE(context, modePacked, count, typePacked, indices,
                                               primcount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorANGLE(GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribDivisorANGLE, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisorANGLE(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

// GL_ANGLE_multi_draw
void GL_APIENTRY MultiDrawArraysANGLE(GLenum mode,
                                      const GLint *firsts,
                                      const GLsizei *counts,
                                      GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)firsts, (uintptr_t)counts, drawcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(MultiDrawArraysANGLE, context, modePacked, firsts, counts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawArraysANGLE(context, modePacked, firsts, counts, drawcount))
        {
            context->multiDrawArrays(modePacked, firsts, counts, drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawArraysInstancedANGLE(GLenum mode,
                                               const GLint *firsts,
                                               const GLsizei *counts,
                                               const GLsizei *instanceCounts,
                                               GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR
          ", const GLsizei *instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)firsts, (uintptr_t)counts, (uintptr_t)instanceCounts, drawcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(MultiDrawArraysInstancedANGLE, context, modePacked, firsts, counts,
                      instanceCounts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawArraysInstancedANGLE(context, modePacked, firsts, counts,
                                                  instanceCounts, drawcount))
        {
            context->multiDrawArraysInstanced(modePacked, firsts, counts, instanceCounts,
                                              drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawElementsANGLE(GLenum mode,
                                        const GLsizei *counts,
                                        GLenum type,
                                        const GLvoid *const *indices,
                                        GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = 0x%X, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", GLsizei drawcount = %d)",
          mode, (uintptr_t)counts, type, (uintptr_t)indices, drawcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(MultiDrawElementsANGLE, context, modePacked, counts, typePacked, indices,
                      drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawElementsANGLE(context, modePacked, counts, typePacked, indices,
                                           drawcount))
        {
            context->multiDrawElements(modePacked, counts, typePacked, indices, drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawElementsInstancedANGLE(GLenum mode,
                                                 const GLsizei *counts,
                                                 GLenum type,
                                                 const GLvoid *const *indices,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = 0x%X, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", const GLsizei*instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)counts, type, (uintptr_t)indices, (uintptr_t)instanceCounts, drawcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(MultiDrawElementsInstancedANGLE, context, modePacked, counts, typePacked,
                      indices, instanceCounts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawElementsInstancedANGLE(context, modePacked, counts, typePacked,
                                                    indices, instanceCounts, drawcount))
        {
            context->multiDrawElementsInstanced(modePacked, counts, typePacked, indices,
                                                instanceCounts, drawcount);
        }
    }
}

// GL_ANGLE_provoking_vertex
void GL_APIENTRY ProvokingVertexANGLE(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ProvokingVertexConvention modePacked = FromGLenum<ProvokingVertexConvention>(mode);
        ANGLE_CAPTURE(ProvokingVertexANGLE, context, modePacked);
        if (context->skipValidation() || ValidateProvokingVertexANGLE(context, modePacked))
        {
            context->provokingVertex(modePacked);
        }
    }
}

// GL_ANGLE_request_extension
void GL_APIENTRY RequestExtensionANGLE(const GLchar *name)
{
    EVENT("(const GLchar * name = 0x%016" PRIxPTR ")", (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RequestExtensionANGLE, context, name);
        if (context->skipValidation() || ValidateRequestExtensionANGLE(context, name))
        {
            context->requestExtension(name);
        }
    }
}

// GL_ANGLE_robust_client_memory
void GL_APIENTRY GetBooleanvRobustANGLE(GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLboolean *params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLboolean * params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetBooleanvRobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetBooleanvRobustANGLE(context, pname, bufSize, length, params))
        {
            context->getBooleanvRobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetBufferParameterivRobustANGLE(GLenum target,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameterivRobustANGLE, context, targetPacked, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetBufferParameterivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFloatvRobustANGLE(GLenum pname,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLfloat * params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFloatvRobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetFloatvRobustANGLE(context, pname, bufSize, length, params))
        {
            context->getFloatvRobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivRobustANGLE(GLenum target,
                                                                GLenum attachment,
                                                                GLenum pname,
                                                                GLsizei bufSize,
                                                                GLsizei *length,
                                                                GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = "
        "%d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, attachment, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivRobustANGLE, context, target, attachment,
                      pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameterivRobustANGLE(context, target, attachment,
                                                                   pname, bufSize, length, params))
        {
            context->getFramebufferAttachmentParameterivRobust(target, attachment, pname, bufSize,
                                                               length, params);
        }
    }
}

void GL_APIENTRY GetIntegervRobustANGLE(GLenum pname, GLsizei bufSize, GLsizei *length, GLint *data)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * data = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetIntegervRobustANGLE, context, pname, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetIntegervRobustANGLE(context, pname, bufSize, length, data))
        {
            context->getIntegervRobust(pname, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetProgramivRobustANGLE(GLuint program,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramivRobustANGLE, context, program, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetProgramivRobustANGLE(context, program, pname, bufSize, length, params))
        {
            context->getProgramivRobust(program, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameterivRobustANGLE(GLenum target,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetRenderbufferParameterivRobustANGLE, context, target, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetRenderbufferParameterivRobustANGLE(
                                             context, target, pname, bufSize, length, params))
        {
            context->getRenderbufferParameterivRobust(target, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY
GetShaderivRobustANGLE(GLuint shader, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *params)
{
    EVENT(
        "(GLuint shader = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        shader, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetShaderivRobustANGLE, context, shader, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetShaderivRobustANGLE(context, shader, pname, bufSize, length, params))
        {
            context->getShaderivRobust(shader, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterfvRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterfvRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterfvRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterfvRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterivRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformfvRobustANGLE(GLuint program,
                                         GLint location,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformfvRobustANGLE, context, program, location, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetUniformfvRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformfvRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformivRobustANGLE(GLuint program,
                                         GLint location,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformivRobustANGLE, context, program, location, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetUniformivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribfvRobustANGLE(GLuint index,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLfloat *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribfvRobustANGLE, context, index, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribfvRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribfvRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribivRobustANGLE(GLuint index,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribivRobustANGLE, context, index, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointervRobustANGLE(GLuint index,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    void **pointer)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", void ** pointer = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribPointervRobustANGLE, context, index, pname, bufSize, length,
                      pointer);
        if (context->skipValidation() || ValidateGetVertexAttribPointervRobustANGLE(
                                             context, index, pname, bufSize, length, pointer))
        {
            context->getVertexAttribPointervRobust(index, pname, bufSize, length, pointer);
        }
    }
}

void GL_APIENTRY ReadPixelsRobustANGLE(GLint x,
                                       GLint y,
                                       GLsizei width,
                                       GLsizei height,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLsizei *columns,
                                       GLsizei *rows,
                                       void *pixels)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * pixels = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)length, (uintptr_t)columns,
        (uintptr_t)rows, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadPixelsRobustANGLE, context, x, y, width, height, format, type, bufSize,
                      length, columns, rows, pixels);
        if (context->skipValidation() ||
            ValidateReadPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                          length, columns, rows, pixels))
        {
            context->readPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                      rows, pixels);
        }
    }
}

void GL_APIENTRY TexImage2DRobustANGLE(GLenum target,
                                       GLint level,
                                       GLint internalformat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLint border,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, GLsizei "
        "bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2DRobustANGLE, context, targetPacked, level, internalformat, width,
                      height, border, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexImage2DRobustANGLE(context, targetPacked, level, internalformat, width,
                                          height, border, format, type, bufSize, pixels))
        {
            context->texImage2DRobust(targetPacked, level, internalformat, width, height, border,
                                      format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexParameterfvRobustANGLE(GLenum target,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLfloat * params "
        "= 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterfvRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterfvRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterfvRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexParameterivRobustANGLE(GLenum target,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexSubImage2DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, GLsizei "
        "bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, type, bufSize, (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage2DRobustANGLE, context, targetPacked, level, xoffset, yoffset,
                      width, height, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage2DRobustANGLE(context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, type, bufSize, pixels))
        {
            context->texSubImage2DRobust(targetPacked, level, xoffset, yoffset, width, height,
                                         format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexImage3DRobustANGLE(GLenum target,
                                       GLint level,
                                       GLint internalformat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       GLint border,
                                       GLenum format,
                                       GLenum type,
                                       GLsizei bufSize,
                                       const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, GLenum "
        "type = 0x%X, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3DRobustANGLE, context, targetPacked, level, internalformat, width,
                      height, depth, border, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3DRobustANGLE(context, targetPacked, level, internalformat, width,
                                          height, depth, border, format, type, bufSize, pixels))
        {
            context->texImage3DRobust(targetPacked, level, internalformat, width, height, depth,
                                      border, format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3DRobustANGLE(GLenum target,
                                          GLint level,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint zoffset,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR
        ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3DRobustANGLE, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset, yoffset,
                                             zoffset, width, height, depth, format, type, bufSize,
                                             pixels))
        {
            context->texSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset, width,
                                         height, depth, format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY CompressedTexImage2DRobustANGLE(GLenum target,
                                                 GLint level,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLint border,
                                                 GLsizei imageSize,
                                                 GLsizei dataSize,
                                                 const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, GLsizei dataSize = "
        "%d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, imageSize, dataSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage2DRobustANGLE, context, targetPacked, level, internalformat,
                      width, height, border, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexImage2DRobustANGLE(
                                             context, targetPacked, level, internalformat, width,
                                             height, border, imageSize, dataSize, data))
        {
            context->compressedTexImage2DRobust(targetPacked, level, internalformat, width, height,
                                                border, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage2DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLsizei xoffset,
                                                    GLsizei yoffset,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLenum format,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLsizei xoffset = %d, GLsizei yoffset = %d, "
        "GLsizei width = %d, GLsizei height = %d, GLenum format = 0x%X, GLsizei imageSize = %d, "
        "GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage2DRobustANGLE, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexSubImage2DRobustANGLE(
                                             context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, imageSize, dataSize, data))
        {
            context->compressedTexSubImage2DRobust(targetPacked, level, xoffset, yoffset, width,
                                                   height, format, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexImage3DRobustANGLE(GLenum target,
                                                 GLint level,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLint border,
                                                 GLsizei imageSize,
                                                 GLsizei dataSize,
                                                 const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3DRobustANGLE, context, targetPacked, level, internalformat,
                      width, height, depth, border, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexImage3DRobustANGLE(
                                             context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, dataSize, data))
        {
            context->compressedTexImage3DRobust(targetPacked, level, internalformat, width, height,
                                                depth, border, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3DRobustANGLE(GLenum target,
                                                    GLint level,
                                                    GLint xoffset,
                                                    GLint yoffset,
                                                    GLint zoffset,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLsizei depth,
                                                    GLenum format,
                                                    GLsizei imageSize,
                                                    GLsizei dataSize,
                                                    const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, GLsizei dataSize = %d, const GLvoid * data = "
        "0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3DRobustANGLE, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, imageSize, dataSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset,
                                                       yoffset, zoffset, width, height, depth,
                                                       format, imageSize, dataSize, data))
        {
            context->compressedTexSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset,
                                                   width, height, depth, format, imageSize,
                                                   dataSize, data);
        }
    }
}

void GL_APIENTRY
GetQueryivRobustANGLE(GLenum target, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryivRobustANGLE, context, targetPacked, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryivRobustANGLE(context, targetPacked, pname, bufSize, length, params))
        {
            context->getQueryivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivRobustANGLE(GLuint id,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLuint *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectuivRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectuivRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectuivRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetBufferPointervRobustANGLE(GLenum target,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              void **params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", void ** params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointervRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetBufferPointervRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferPointervRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY
GetIntegeri_vRobustANGLE(GLenum target, GLuint index, GLsizei bufSize, GLsizei *length, GLint *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetIntegeri_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetIntegeri_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getIntegeri_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetInternalformativRobustANGLE(GLenum target,
                                                GLenum internalformat,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, internalformat, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInternalformativRobustANGLE, context, target, internalformat, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetInternalformativRobustANGLE(context, target, internalformat, pname, bufSize,
                                                   length, params))
        {
            context->getInternalformativRobust(target, internalformat, pname, bufSize, length,
                                               params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIivRobustANGLE(GLuint index,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIivRobustANGLE, context, index, pname, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribIivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribIivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIuivRobustANGLE(GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetVertexAttribIuivRobustANGLE, context, index, pname, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribIuivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribIuivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformuivRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLuint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUniformuivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetUniformuivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformuivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockivRobustANGLE(GLuint program,
                                                    GLuint uniformBlockIndex,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, uniformBlockIndex, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetActiveUniformBlockivRobustANGLE, context, program, uniformBlockIndex,
                      pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockivRobustANGLE(context, program, uniformBlockIndex, pname,
                                                       bufSize, length, params))
        {
            context->getActiveUniformBlockivRobust(program, uniformBlockIndex, pname, bufSize,
                                                   length, params);
        }
    }
}

void GL_APIENTRY GetInteger64vRobustANGLE(GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint64 *data)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint64 * data = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInteger64vRobustANGLE, context, pname, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetInteger64vRobustANGLE(context, pname, bufSize, length, data))
        {
            context->getInteger64vRobust(pname, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetInteger64i_vRobustANGLE(GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetInteger64i_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetInteger64i_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getInteger64i_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetBufferParameteri64vRobustANGLE(GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint64 *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteri64vRobustANGLE, context, targetPacked, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetBufferParameteri64vRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferParameteri64vRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY SamplerParameterivRobustANGLE(GLuint sampler,
                                               GLuint pname,
                                               GLsizei bufSize,
                                               const GLint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLuint pname = %u, GLsizei bufSize = %d, const GLint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY SamplerParameterfvRobustANGLE(GLuint sampler,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLfloat *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLfloat * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterfvRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterfvRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterfvRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY GetSamplerParameterivRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterfvRobustANGLE(GLuint sampler,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLfloat *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterfvRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterfvRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterfvRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFramebufferParameterivRobustANGLE(GLuint sampler,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFramebufferParameterivRobustANGLE, context, sampler, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetFramebufferParameterivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getFramebufferParameterivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetProgramInterfaceivRobustANGLE(GLuint program,
                                                  GLenum programInterface,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLenum pname = 0x%X, GLsizei "
        "bufSize = %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, programInterface, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramInterfaceivRobustANGLE, context, program, programInterface, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetProgramInterfaceivRobustANGLE(context, program, programInterface, pname,
                                                     bufSize, length, params))
        {
            context->getProgramInterfaceivRobust(program, programInterface, pname, bufSize, length,
                                                 params);
        }
    }
}

void GL_APIENTRY GetBooleani_vRobustANGLE(GLenum target,
                                          GLuint index,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLboolean * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetBooleani_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetBooleani_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getBooleani_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetMultisamplefvRobustANGLE(GLenum pname,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLfloat *val)
{
    EVENT(
        "(GLenum pname = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * val = 0x%016" PRIxPTR ")",
        pname, index, bufSize, (uintptr_t)length, (uintptr_t)val);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMultisamplefvRobustANGLE, context, pname, index, bufSize, length, val);
        if (context->skipValidation() ||
            ValidateGetMultisamplefvRobustANGLE(context, pname, index, bufSize, length, val))
        {
            context->getMultisamplefvRobust(pname, index, bufSize, length, val);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterivRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLsizei bufSize = %d, "
        "GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, level, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterivRobustANGLE, context, targetPacked, level, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterivRobustANGLE(context, targetPacked, level, pname, bufSize,
                                                      length, params))
        {
            context->getTexLevelParameterivRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfvRobustANGLE(GLenum target,
                                                   GLint level,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLsizei bufSize = %d, "
        "GLsizei * length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        target, level, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfvRobustANGLE, context, targetPacked, level, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfvRobustANGLE(context, targetPacked, level, pname, bufSize,
                                                      length, params))
        {
            context->getTexLevelParameterfvRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
    }
}

void GL_APIENTRY GetPointervRobustANGLERobustANGLE(GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   void **params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", void ** params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPointervRobustANGLERobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetPointervRobustANGLERobustANGLE(context, pname, bufSize, length, params))
        {
            context->getPointervRobustANGLERobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY ReadnPixelsRobustANGLE(GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height,
                                        GLenum format,
                                        GLenum type,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLsizei *columns,
                                        GLsizei *rows,
                                        void *data)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * data = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)length, (uintptr_t)columns,
        (uintptr_t)rows, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadnPixelsRobustANGLE, context, x, y, width, height, format, type, bufSize,
                      length, columns, rows, data);
        if (context->skipValidation() ||
            ValidateReadnPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                           length, columns, rows, data))
        {
            context->readnPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                       rows, data);
        }
    }
}

void GL_APIENTRY GetnUniformfvRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetnUniformfvRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformfvRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformfvRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetnUniformivRobustANGLE(GLuint program,
                                          GLint location,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetnUniformivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetnUniformuivRobustANGLE(GLuint program,
                                           GLint location,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLuint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetnUniformuivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformuivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformuivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY TexParameterIivRobustANGLE(GLenum target,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterIivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterIivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexParameterIuivRobustANGLE(GLenum target,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLuint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLuint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIuivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterIuivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterIuivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIivRobustANGLE(GLenum target,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterIivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterIivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIuivRobustANGLE(GLenum target,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIuivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterIuivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterIuivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY SamplerParameterIivRobustANGLE(GLuint sampler,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterIivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterIivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY SamplerParameterIuivRobustANGLE(GLuint sampler,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLuint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLuint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterIuivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIuivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterIuivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIivRobustANGLE(GLuint sampler,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterIivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterIivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterIivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIuivRobustANGLE(GLuint sampler,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLuint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterIuivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterIuivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterIuivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectivRobustANGLE(GLuint id,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectivRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectivRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectivRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjecti64vRobustANGLE(GLuint id,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint64 *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjecti64vRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjecti64vRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjecti64vRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectui64vRobustANGLE(GLuint id,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint64 *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint64 * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectui64vRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectui64vRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectui64vRobust(id, pname, bufSize, length, params);
        }
    }
}

// GL_ANGLE_texture_external_update
void GL_APIENTRY TexImage2DExternalANGLE(GLenum target,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X)",
        target, level, internalformat, width, height, border, format, type);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2DExternalANGLE, context, targetPacked, level, internalformat, width,
                      height, border, format, type);
        if (context->skipValidation() ||
            ValidateTexImage2DExternalANGLE(context, targetPacked, level, internalformat, width,
                                            height, border, format, type))
        {
            context->texImage2DExternal(targetPacked, level, internalformat, width, height, border,
                                        format, type);
        }
    }
}

void GL_APIENTRY InvalidateTextureANGLE(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(InvalidateTextureANGLE, context, targetPacked);
        if (context->skipValidation() || ValidateInvalidateTextureANGLE(context, targetPacked))
        {
            context->invalidateTexture(targetPacked);
        }
    }
}

// GL_ANGLE_texture_multisample
void GL_APIENTRY TexStorage2DMultisampleANGLE(GLenum target,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, fixedsamplelocations);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2DMultisampleANGLE, context, targetPacked, samples, internalformat,
                      width, height, fixedsamplelocations);
        if (context->skipValidation() ||
            ValidateTexStorage2DMultisampleANGLE(context, targetPacked, samples, internalformat,
                                                 width, height, fixedsamplelocations))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterivANGLE(GLenum target,
                                             GLint level,
                                             GLenum pname,
                                             GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLint * params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterivANGLE, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterivANGLE(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfvANGLE(GLenum target,
                                             GLint level,
                                             GLenum pname,
                                             GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLfloat * params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfvANGLE, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfvANGLE(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetMultisamplefvANGLE(GLenum pname, GLuint index, GLfloat *val)
{
    EVENT("(GLenum pname = 0x%X, GLuint index = %u, GLfloat * val = 0x%016" PRIxPTR ")", pname,
          index, (uintptr_t)val);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMultisamplefvANGLE, context, pname, index, val);
        if (context->skipValidation() || ValidateGetMultisamplefvANGLE(context, pname, index, val))
        {
            context->getMultisamplefv(pname, index, val);
        }
    }
}

void GL_APIENTRY SampleMaskiANGLE(GLuint maskNumber, GLbitfield mask)
{
    EVENT("(GLuint maskNumber = %u, GLbitfield mask = 0x%X)", maskNumber, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SampleMaskiANGLE, context, maskNumber, mask);
        if (context->skipValidation() || ValidateSampleMaskiANGLE(context, maskNumber, mask))
        {
            context->sampleMaski(maskNumber, mask);
        }
    }
}

// GL_ANGLE_translated_shader_source
void GL_APIENTRY GetTranslatedShaderSourceANGLE(GLuint shader,
                                                GLsizei bufsize,
                                                GLsizei *length,
                                                GLchar *source)
{
    EVENT("(GLuint shader = %u, GLsizei bufsize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR ")",
          shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, context, shader, bufsize, length, source);
        if (context->skipValidation() ||
            ValidateGetTranslatedShaderSourceANGLE(context, shader, bufsize, length, source))
        {
            context->getTranslatedShaderSource(shader, bufsize, length, source);
        }
    }
}

// GL_CHROMIUM_bind_uniform_location
void GL_APIENTRY BindUniformLocationCHROMIUM(GLuint program, GLint location, const GLchar *name)
{
    EVENT("(GLuint program = %u, GLint location = %d, const GLchar* name = 0x%016" PRIxPTR ")",
          program, location, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindUniformLocationCHROMIUM, context, program, location, name);
        if (context->skipValidation() ||
            ValidateBindUniformLocationCHROMIUM(context, program, location, name))
        {
            context->bindUniformLocation(program, location, name);
        }
    }
}

// GL_CHROMIUM_copy_compressed_texture
void GL_APIENTRY CompressedCopyTextureCHROMIUM(GLuint sourceId, GLuint destId)
{
    EVENT("(GLuint sourceId = %u, GLuint destId = %u)", sourceId, destId);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CompressedCopyTextureCHROMIUM, context, sourceId, destId);
        if (context->skipValidation() ||
            ValidateCompressedCopyTextureCHROMIUM(context, sourceId, destId))
        {
            context->compressedCopyTexture(sourceId, destId);
        }
    }
}

// GL_CHROMIUM_copy_texture
void GL_APIENTRY CopyTextureCHROMIUM(GLuint sourceId,
                                     GLint sourceLevel,
                                     GLenum destTarget,
                                     GLuint destId,
                                     GLint destLevel,
                                     GLint internalFormat,
                                     GLenum destType,
                                     GLboolean unpackFlipY,
                                     GLboolean unpackPremultiplyAlpha,
                                     GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = 0x%X, GLboolean "
        "unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha "
        "= %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, internalFormat, destType, unpackFlipY,
        unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopyTextureCHROMIUM, context, sourceId, sourceLevel, destTargetPacked, destId,
                      destLevel, internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopyTextureCHROMIUM(context, sourceId, sourceLevel, destTargetPacked, destId,
                                        destLevel, internalFormat, destType, unpackFlipY,
                                        unpackPremultiplyAlpha, unpackUnmultiplyAlpha))
        {
            context->copyTexture(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                 internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                 unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY CopySubTextureCHROMIUM(GLuint sourceId,
                                        GLint sourceLevel,
                                        GLenum destTarget,
                                        GLuint destId,
                                        GLint destLevel,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint x,
                                        GLint y,
                                        GLint width,
                                        GLint height,
                                        GLboolean unpackFlipY,
                                        GLboolean unpackPremultiplyAlpha,
                                        GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint x = %d, GLint y = "
        "%d, GLint width = %d, GLint height = %d, GLboolean unpackFlipY = %u, GLboolean "
        "unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha = %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, xoffset, yoffset, x, y, width, height,
        unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopySubTextureCHROMIUM, context, sourceId, sourceLevel, destTargetPacked,
                      destId, destLevel, xoffset, yoffset, x, y, width, height, unpackFlipY,
                      unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopySubTextureCHROMIUM(context, sourceId, sourceLevel, destTargetPacked, destId,
                                           destLevel, xoffset, yoffset, x, y, width, height,
                                           unpackFlipY, unpackPremultiplyAlpha,
                                           unpackUnmultiplyAlpha))
        {
            context->copySubTexture(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                    xoffset, yoffset, x, y, width, height, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
    }
}

// GL_CHROMIUM_framebuffer_mixed_samples
void GL_APIENTRY CoverageModulationCHROMIUM(GLenum components)
{
    EVENT("(GLenum components = 0x%X)", components);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CoverageModulationCHROMIUM, context, components);
        if (context->skipValidation() || ValidateCoverageModulationCHROMIUM(context, components))
        {
            context->coverageModulation(components);
        }
    }
}

void GL_APIENTRY MatrixLoadfCHROMIUM(GLenum matrixMode, const GLfloat *matrix)
{
    EVENT("(GLenum matrixMode = 0x%X, const GLfloat * matrix = 0x%016" PRIxPTR ")", matrixMode,
          (uintptr_t)matrix);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MatrixLoadfCHROMIUM, context, matrixMode, matrix);
        if (context->skipValidation() || ValidateMatrixLoadfCHROMIUM(context, matrixMode, matrix))
        {
            context->matrixLoadf(matrixMode, matrix);
        }
    }
}

void GL_APIENTRY MatrixLoadIdentityCHROMIUM(GLenum matrixMode)
{
    EVENT("(GLenum matrixMode = 0x%X)", matrixMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MatrixLoadIdentityCHROMIUM, context, matrixMode);
        if (context->skipValidation() || ValidateMatrixLoadIdentityCHROMIUM(context, matrixMode))
        {
            context->matrixLoadIdentity(matrixMode);
        }
    }
}

// GL_CHROMIUM_lose_context
void GL_APIENTRY LoseContextCHROMIUM(GLenum current, GLenum other)
{
    EVENT("(GLenum current = 0x%X, GLenum other = 0x%X)", current, other);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        GraphicsResetStatus currentPacked = FromGLenum<GraphicsResetStatus>(current);
        GraphicsResetStatus otherPacked   = FromGLenum<GraphicsResetStatus>(other);
        ANGLE_CAPTURE(LoseContextCHROMIUM, context, currentPacked, otherPacked);
        if (context->skipValidation() ||
            ValidateLoseContextCHROMIUM(context, currentPacked, otherPacked))
        {
            context->loseContext(currentPacked, otherPacked);
        }
    }
}

// GL_CHROMIUM_path_rendering
GLuint GL_APIENTRY GenPathsCHROMIUM(GLsizei range)
{
    EVENT("(GLsizei range = %d)", range);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenPathsCHROMIUM, context, range);
        if (context->skipValidation() || ValidateGenPathsCHROMIUM(context, range))
        {
            return context->genPaths(range);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GenPathsCHROMIUM, GLuint>();
}

void GL_APIENTRY DeletePathsCHROMIUM(GLuint first, GLsizei range)
{
    EVENT("(GLuint first = %u, GLsizei range = %d)", first, range);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeletePathsCHROMIUM, context, first, range);
        if (context->skipValidation() || ValidateDeletePathsCHROMIUM(context, first, range))
        {
            context->deletePaths(first, range);
        }
    }
}

GLboolean GL_APIENTRY IsPathCHROMIUM(GLuint path)
{
    EVENT("(GLuint path = %u)", path);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsPathCHROMIUM, context, path);
        if (context->skipValidation() || ValidateIsPathCHROMIUM(context, path))
        {
            return context->isPath(path);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsPathCHROMIUM, GLboolean>();
}

void GL_APIENTRY PathCommandsCHROMIUM(GLuint path,
                                      GLsizei numCommands,
                                      const GLubyte *commands,
                                      GLsizei numCoords,
                                      GLenum coordType,
                                      const void *coords)
{
    EVENT("(GLuint path = %u, GLsizei numCommands = %d, const GLubyte * commands = 0x%016" PRIxPTR
          ", GLsizei numCoords = %d, GLenum coordType = 0x%X, const void* coords = 0x%016" PRIxPTR
          ")",
          path, numCommands, (uintptr_t)commands, numCoords, coordType, (uintptr_t)coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PathCommandsCHROMIUM, context, path, numCommands, commands, numCoords,
                      coordType, coords);
        if (context->skipValidation() ||
            ValidatePathCommandsCHROMIUM(context, path, numCommands, commands, numCoords, coordType,
                                         coords))
        {
            context->pathCommands(path, numCommands, commands, numCoords, coordType, coords);
        }
    }
}

void GL_APIENTRY PathParameterfCHROMIUM(GLuint path, GLenum pname, GLfloat value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLfloat value = %f)", path, pname, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PathParameterfCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidatePathParameterfCHROMIUM(context, path, pname, value))
        {
            context->pathParameterf(path, pname, value);
        }
    }
}

void GL_APIENTRY PathParameteriCHROMIUM(GLuint path, GLenum pname, GLint value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLint value = %d)", path, pname, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PathParameteriCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidatePathParameteriCHROMIUM(context, path, pname, value))
        {
            context->pathParameteri(path, pname, value);
        }
    }
}

void GL_APIENTRY GetPathParameterfvCHROMIUM(GLuint path, GLenum pname, GLfloat *value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLfloat * value = 0x%016" PRIxPTR ")", path,
          pname, (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPathParameterfvCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidateGetPathParameterfvCHROMIUM(context, path, pname, value))
        {
            context->getPathParameterfv(path, pname, value);
        }
    }
}

void GL_APIENTRY GetPathParameterivCHROMIUM(GLuint path, GLenum pname, GLint *value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLint * value = 0x%016" PRIxPTR ")", path, pname,
          (uintptr_t)value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPathParameterivCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidateGetPathParameterivCHROMIUM(context, path, pname, value))
        {
            context->getPathParameteriv(path, pname, value);
        }
    }
}

void GL_APIENTRY PathStencilFuncCHROMIUM(GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PathStencilFuncCHROMIUM, context, func, ref, mask);
        if (context->skipValidation() || ValidatePathStencilFuncCHROMIUM(context, func, ref, mask))
        {
            context->pathStencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilFillPathCHROMIUM(GLuint path, GLenum fillMode, GLuint mask)
{
    EVENT("(GLuint path = %u, GLenum fillMode = 0x%X, GLuint mask = %u)", path, fillMode, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilFillPathCHROMIUM, context, path, fillMode, mask);
        if (context->skipValidation() ||
            ValidateStencilFillPathCHROMIUM(context, path, fillMode, mask))
        {
            context->stencilFillPath(path, fillMode, mask);
        }
    }
}

void GL_APIENTRY StencilStrokePathCHROMIUM(GLuint path, GLint reference, GLuint mask)
{
    EVENT("(GLuint path = %u, GLint reference = %d, GLuint mask = %u)", path, reference, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilStrokePathCHROMIUM, context, path, reference, mask);
        if (context->skipValidation() ||
            ValidateStencilStrokePathCHROMIUM(context, path, reference, mask))
        {
            context->stencilStrokePath(path, reference, mask);
        }
    }
}

void GL_APIENTRY CoverFillPathCHROMIUM(GLuint path, GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum coverMode = 0x%X)", path, coverMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CoverFillPathCHROMIUM, context, path, coverMode);
        if (context->skipValidation() || ValidateCoverFillPathCHROMIUM(context, path, coverMode))
        {
            context->coverFillPath(path, coverMode);
        }
    }
}

void GL_APIENTRY CoverStrokePathCHROMIUM(GLuint path, GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum coverMode = 0x%X)", path, coverMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CoverStrokePathCHROMIUM, context, path, coverMode);
        if (context->skipValidation() || ValidateCoverStrokePathCHROMIUM(context, path, coverMode))
        {
            context->coverStrokePath(path, coverMode);
        }
    }
}

void GL_APIENTRY StencilThenCoverFillPathCHROMIUM(GLuint path,
                                                  GLenum fillMode,
                                                  GLuint mask,
                                                  GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum coverMode = 0x%X)",
          path, fillMode, mask, coverMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilThenCoverFillPathCHROMIUM, context, path, fillMode, mask, coverMode);
        if (context->skipValidation() ||
            ValidateStencilThenCoverFillPathCHROMIUM(context, path, fillMode, mask, coverMode))
        {
            context->stencilThenCoverFillPath(path, fillMode, mask, coverMode);
        }
    }
}

void GL_APIENTRY StencilThenCoverStrokePathCHROMIUM(GLuint path,
                                                    GLint reference,
                                                    GLuint mask,
                                                    GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLint reference = %d, GLuint mask = %u, GLenum coverMode = 0x%X)",
          path, reference, mask, coverMode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilThenCoverStrokePathCHROMIUM, context, path, reference, mask,
                      coverMode);
        if (context->skipValidation() ||
            ValidateStencilThenCoverStrokePathCHROMIUM(context, path, reference, mask, coverMode))
        {
            context->stencilThenCoverStrokePath(path, reference, mask, coverMode);
        }
    }
}

void GL_APIENTRY CoverFillPathInstancedCHROMIUM(GLsizei numPath,
                                                GLenum pathNameType,
                                                const void *paths,
                                                GLuint pathBase,
                                                GLenum coverMode,
                                                GLenum transformType,
                                                const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = 0x%X, GLenum transformType = 0x%X, const "
          "GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, coverMode, transformType,
          (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CoverFillPathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateCoverFillPathInstancedCHROMIUM(context, numPath, pathNameType, paths, pathBase,
                                                   coverMode, transformType, transformValues))
        {
            context->coverFillPathInstanced(numPath, pathNameType, paths, pathBase, coverMode,
                                            transformType, transformValues);
        }
    }
}

void GL_APIENTRY CoverStrokePathInstancedCHROMIUM(GLsizei numPath,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  GLuint pathBase,
                                                  GLenum coverMode,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = 0x%X, GLenum transformType = 0x%X, const "
          "GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, coverMode, transformType,
          (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CoverStrokePathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, coverMode, transformType, transformValues);
        if (context->skipValidation() || ValidateCoverStrokePathInstancedCHROMIUM(
                                             context, numPath, pathNameType, paths, pathBase,
                                             coverMode, transformType, transformValues))
        {
            context->coverStrokePathInstanced(numPath, pathNameType, paths, pathBase, coverMode,
                                              transformType, transformValues);
        }
    }
}

void GL_APIENTRY StencilStrokePathInstancedCHROMIUM(GLsizei numPath,
                                                    GLenum pathNameType,
                                                    const void *paths,
                                                    GLuint pathBase,
                                                    GLint reference,
                                                    GLuint mask,
                                                    GLenum transformType,
                                                    const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum transformType = "
          "0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, reference, mask, transformType,
          (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilStrokePathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, reference, mask, transformType, transformValues);
        if (context->skipValidation() || ValidateStencilStrokePathInstancedCHROMIUM(
                                             context, numPath, pathNameType, paths, pathBase,
                                             reference, mask, transformType, transformValues))
        {
            context->stencilStrokePathInstanced(numPath, pathNameType, paths, pathBase, reference,
                                                mask, transformType, transformValues);
        }
    }
}

void GL_APIENTRY StencilFillPathInstancedCHROMIUM(GLsizei numPaths,
                                                  GLenum pathNameType,
                                                  const void *paths,
                                                  GLuint pathBase,
                                                  GLenum fillMode,
                                                  GLuint mask,
                                                  GLenum transformType,
                                                  const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum transformType "
          "= 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, fillMode, mask, transformType,
          (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilFillPathInstancedCHROMIUM, context, numPaths, pathNameType, paths,
                      pathBase, fillMode, mask, transformType, transformValues);
        if (context->skipValidation() || ValidateStencilFillPathInstancedCHROMIUM(
                                             context, numPaths, pathNameType, paths, pathBase,
                                             fillMode, mask, transformType, transformValues))
        {
            context->stencilFillPathInstanced(numPaths, pathNameType, paths, pathBase, fillMode,
                                              mask, transformType, transformValues);
        }
    }
}

void GL_APIENTRY StencilThenCoverFillPathInstancedCHROMIUM(GLsizei numPaths,
                                                           GLenum pathNameType,
                                                           const void *paths,
                                                           GLuint pathBase,
                                                           GLenum fillMode,
                                                           GLuint mask,
                                                           GLenum coverMode,
                                                           GLenum transformType,
                                                           const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum coverMode = "
          "0x%X, GLenum transformType = 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, fillMode, mask, coverMode,
          transformType, (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilThenCoverFillPathInstancedCHROMIUM, context, numPaths, pathNameType,
                      paths, pathBase, fillMode, mask, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateStencilThenCoverFillPathInstancedCHROMIUM(
                context, numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode,
                transformType, transformValues))
        {
            context->stencilThenCoverFillPathInstanced(numPaths, pathNameType, paths, pathBase,
                                                       fillMode, mask, coverMode, transformType,
                                                       transformValues);
        }
    }
}

void GL_APIENTRY StencilThenCoverStrokePathInstancedCHROMIUM(GLsizei numPaths,
                                                             GLenum pathNameType,
                                                             const void *paths,
                                                             GLuint pathBase,
                                                             GLint reference,
                                                             GLuint mask,
                                                             GLenum coverMode,
                                                             GLenum transformType,
                                                             const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum coverMode = "
          "0x%X, GLenum transformType = 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, reference, mask, coverMode,
          transformType, (uintptr_t)transformValues);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(StencilThenCoverStrokePathInstancedCHROMIUM, context, numPaths, pathNameType,
                      paths, pathBase, reference, mask, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateStencilThenCoverStrokePathInstancedCHROMIUM(
                context, numPaths, pathNameType, paths, pathBase, reference, mask, coverMode,
                transformType, transformValues))
        {
            context->stencilThenCoverStrokePathInstanced(numPaths, pathNameType, paths, pathBase,
                                                         reference, mask, coverMode, transformType,
                                                         transformValues);
        }
    }
}

void GL_APIENTRY BindFragmentInputLocationCHROMIUM(GLuint programs,
                                                   GLint location,
                                                   const GLchar *name)
{
    EVENT("(GLuint programs = %u, GLint location = %d, const GLchar * name = 0x%016" PRIxPTR ")",
          programs, location, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFragmentInputLocationCHROMIUM, context, programs, location, name);
        if (context->skipValidation() ||
            ValidateBindFragmentInputLocationCHROMIUM(context, programs, location, name))
        {
            context->bindFragmentInputLocation(programs, location, name);
        }
    }
}

void GL_APIENTRY ProgramPathFragmentInputGenCHROMIUM(GLuint program,
                                                     GLint location,
                                                     GLenum genMode,
                                                     GLint components,
                                                     const GLfloat *coeffs)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLenum genMode = 0x%X, GLint components = %d, "
        "const GLfloat * coeffs = 0x%016" PRIxPTR ")",
        program, location, genMode, components, (uintptr_t)coeffs);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ProgramPathFragmentInputGenCHROMIUM, context, program, location, genMode,
                      components, coeffs);
        if (context->skipValidation() ||
            ValidateProgramPathFragmentInputGenCHROMIUM(context, program, location, genMode,
                                                        components, coeffs))
        {
            context->programPathFragmentInputGen(program, location, genMode, components, coeffs);
        }
    }
}

// GL_EXT_blend_func_extended
void GL_APIENTRY BindFragDataLocationEXT(GLuint program, GLuint color, const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint color = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, color, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFragDataLocationEXT, context, program, color, name);
        if (context->skipValidation() ||
            ValidateBindFragDataLocationEXT(context, program, color, name))
        {
            context->bindFragDataLocation(program, color, name);
        }
    }
}

void GL_APIENTRY BindFragDataLocationIndexedEXT(GLuint program,
                                                GLuint colorNumber,
                                                GLuint index,
                                                const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint colorNumber = %u, GLuint index = %u, const GLchar *name = "
        "0x%016" PRIxPTR ")",
        program, colorNumber, index, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, context, program, colorNumber, index, name);
        if (context->skipValidation() ||
            ValidateBindFragDataLocationIndexedEXT(context, program, colorNumber, index, name))
        {
            context->bindFragDataLocationIndexed(program, colorNumber, index, name);
        }
    }
}

GLint GL_APIENTRY GetFragDataIndexEXT(GLuint program, const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFragDataIndexEXT, context, program, name);
        if (context->skipValidation() || ValidateGetFragDataIndexEXT(context, program, name))
        {
            return context->getFragDataIndex(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
}

GLint GL_APIENTRY GetProgramResourceLocationIndexEXT(GLuint program,
                                                     GLenum programInterface,
                                                     const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%016" PRIxPTR
        ")",
        program, programInterface, (uintptr_t)name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, context, program, programInterface, name);
        if (context->skipValidation() ||
            ValidateGetProgramResourceLocationIndexEXT(context, program, programInterface, name))
        {
            return context->getProgramResourceLocationIndex(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
}

// GL_EXT_debug_marker
void GL_APIENTRY InsertEventMarkerEXT(GLsizei length, const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%016" PRIxPTR ")", length,
    // (uintptr_t)marker);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(InsertEventMarkerEXT, context, length, marker);
        if (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker))
        {
            context->insertEventMarker(length, marker);
        }
    }
}

void GL_APIENTRY PopGroupMarkerEXT()
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PopGroupMarkerEXT, context);
        if (context->skipValidation() || ValidatePopGroupMarkerEXT(context))
        {
            context->popGroupMarker();
        }
    }
}

void GL_APIENTRY PushGroupMarkerEXT(GLsizei length, const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%016" PRIxPTR ")", length,
    // (uintptr_t)marker);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PushGroupMarkerEXT, context, length, marker);
        if (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker))
        {
            context->pushGroupMarker(length, marker);
        }
    }
}

// GL_EXT_discard_framebuffer
void GL_APIENTRY DiscardFramebufferEXT(GLenum target,
                                       GLsizei numAttachments,
                                       const GLenum *attachments)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ")",
        target, numAttachments, (uintptr_t)attachments);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DiscardFramebufferEXT, context, target, numAttachments, attachments);
        if (context->skipValidation() ||
            ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments))
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
    }
}

// GL_EXT_disjoint_timer_query
void GL_APIENTRY BeginQueryEXT(GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(BeginQueryEXT, context, targetPacked, id);
        if (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, id))
        {
            context->beginQuery(targetPacked, id);
        }
    }
}

void GL_APIENTRY DeleteQueriesEXT(GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteQueriesEXT, context, n, ids);
        if (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY EndQueryEXT(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(EndQueryEXT, context, targetPacked);
        if (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked))
        {
            context->endQuery(targetPacked);
        }
    }
}

void GL_APIENTRY GenQueriesEXT(GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenQueriesEXT, context, n, ids);
        if (context->skipValidation() || ValidateGenQueriesEXT(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GetQueryObjecti64vEXT(GLuint id, GLenum pname, GLint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint64 *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjecti64vEXT(context, id, pname, params))
        {
            context->getQueryObjecti64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectivEXT(GLuint id, GLenum pname, GLint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectivEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectivEXT(context, id, pname, params))
        {
            context->getQueryObjectiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectui64vEXT(GLuint id, GLenum pname, GLuint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint64 *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectui64vEXT(context, id, pname, params))
        {
            context->getQueryObjectui64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivEXT(GLuint id, GLenum pname, GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetQueryObjectuivEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectuivEXT(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryivEXT(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryivEXT, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetQueryivEXT(context, targetPacked, pname, params))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsQueryEXT(GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsQueryEXT, context, id);
        if (context->skipValidation() || ValidateIsQueryEXT(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
}

void GL_APIENTRY QueryCounterEXT(GLuint id, GLenum target)
{
    EVENT("(GLuint id = %u, GLenum target = 0x%X)", id, target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(QueryCounterEXT, context, id, targetPacked);
        if (context->skipValidation() || ValidateQueryCounterEXT(context, id, targetPacked))
        {
            context->queryCounter(id, targetPacked);
        }
    }
}

// GL_EXT_draw_buffers
void GL_APIENTRY DrawBuffersEXT(GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR ")", n, (uintptr_t)bufs);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawBuffersEXT, context, n, bufs);
        if (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

// GL_EXT_geometry_shader
void GL_APIENTRY FramebufferTextureEXT(GLenum target,
                                       GLenum attachment,
                                       GLuint texture,
                                       GLint level)
{
    EVENT("(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d)",
          target, attachment, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferTextureEXT, context, target, attachment, texture, level);
        if (context->skipValidation() ||
            ValidateFramebufferTextureEXT(context, target, attachment, texture, level))
        {
            context->framebufferTexture(target, attachment, texture, level);
        }
    }
}

// GL_EXT_instanced_arrays
void GL_APIENTRY DrawArraysInstancedEXT(GLenum mode, GLint start, GLsizei count, GLsizei primcount)
{
    EVENT("(GLenum mode = 0x%X, GLint start = %d, GLsizei count = %d, GLsizei primcount = %d)",
          mode, start, count, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstancedEXT, context, modePacked, start, count, primcount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount))
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedEXT(GLenum mode,
                                          GLsizei count,
                                          GLenum type,
                                          const void *indices,
                                          GLsizei primcount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei primcount = %d)",
        mode, count, type, (uintptr_t)indices, primcount);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstancedEXT, context, modePacked, count, typePacked, indices,
                      primcount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked, indices,
                                             primcount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorEXT(GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(VertexAttribDivisorEXT, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisorEXT(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

// GL_EXT_map_buffer_range
void GL_APIENTRY FlushMappedBufferRangeEXT(GLenum target, GLintptr offset, GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu)", target,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, context, targetPacked, offset, length);
        if (context->skipValidation() ||
            ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void *GL_APIENTRY MapBufferRangeEXT(GLenum target,
                                    GLintptr offset,
                                    GLsizeiptr length,
                                    GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu, GLbitfield "
        "access = 0x%X)",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
        access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferRangeEXT, context, targetPacked, offset, length, access);
        if (context->skipValidation() ||
            ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
}

// GL_EXT_memory_object
void GL_APIENTRY BufferStorageMemEXT(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizeiptr size = %llu, GLuint memory = %u, GLuint64 offset = "
        "%llu)",
        target, static_cast<unsigned long long>(size), memory,
        static_cast<unsigned long long>(offset));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(BufferStorageMemEXT, context, targetPacked, size, memory, offset);
        if (context->skipValidation() ||
            ValidateBufferStorageMemEXT(context, targetPacked, size, memory, offset))
        {
            context->bufferStorageMem(targetPacked, size, memory, offset);
        }
    }
}

void GL_APIENTRY CreateMemoryObjectsEXT(GLsizei n, GLuint *memoryObjects)
{
    EVENT("(GLsizei n = %d, GLuint *memoryObjects = 0x%016" PRIxPTR ")", n,
          (uintptr_t)memoryObjects);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, context, n, memoryObjects);
        if (context->skipValidation() || ValidateCreateMemoryObjectsEXT(context, n, memoryObjects))
        {
            context->createMemoryObjects(n, memoryObjects);
        }
    }
}

void GL_APIENTRY DeleteMemoryObjectsEXT(GLsizei n, const GLuint *memoryObjects)
{
    EVENT("(GLsizei n = %d, const GLuint *memoryObjects = 0x%016" PRIxPTR ")", n,
          (uintptr_t)memoryObjects);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, context, n, memoryObjects);
        if (context->skipValidation() || ValidateDeleteMemoryObjectsEXT(context, n, memoryObjects))
        {
            context->deleteMemoryObjects(n, memoryObjects);
        }
    }
}

void GL_APIENTRY GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint *params)
{
    EVENT("(GLuint memoryObject = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")",
          memoryObject, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, context, memoryObject, pname, params);
        if (context->skipValidation() ||
            ValidateGetMemoryObjectParameterivEXT(context, memoryObject, pname, params))
        {
            context->getMemoryObjectParameteriv(memoryObject, pname, params);
        }
    }
}

void GL_APIENTRY GetUnsignedBytevEXT(GLenum pname, GLubyte *data)
{
    EVENT("(GLenum pname = 0x%X, GLubyte *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUnsignedBytevEXT, context, pname, data);
        if (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data))
        {
            context->getUnsignedBytev(pname, data);
        }
    }
}

void GL_APIENTRY GetUnsignedBytei_vEXT(GLenum target, GLuint index, GLubyte *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLubyte *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, context, target, index, data);
        if (context->skipValidation() ||
            ValidateGetUnsignedBytei_vEXT(context, target, index, data))
        {
            context->getUnsignedBytei_v(target, index, data);
        }
    }
}

GLboolean GL_APIENTRY IsMemoryObjectEXT(GLuint memoryObject)
{
    EVENT("(GLuint memoryObject = %u)", memoryObject);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsMemoryObjectEXT, context, memoryObject);
        if (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObject))
        {
            return context->isMemoryObject(memoryObject);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
}

void GL_APIENTRY MemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, const GLint *params)
{
    EVENT("(GLuint memoryObject = %u, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR
          ")",
          memoryObject, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, context, memoryObject, pname, params);
        if (context->skipValidation() ||
            ValidateMemoryObjectParameterivEXT(context, memoryObject, pname, params))
        {
            context->memoryObjectParameteriv(memoryObject, pname, params);
        }
    }
}

void GL_APIENTRY TexStorageMem2DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalFormat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLuint memory,
                                    GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalFormat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLuint memory = %u, GLuint64 offset = %llu)",
        target, levels, internalFormat, width, height, memory,
        static_cast<unsigned long long>(offset));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem2DEXT, context, targetPacked, levels, internalFormat, width,
                      height, memory, offset);
        if (context->skipValidation() ||
            ValidateTexStorageMem2DEXT(context, targetPacked, levels, internalFormat, width, height,
                                       memory, offset))
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height, memory,
                                     offset);
        }
    }
}

void GL_APIENTRY TexStorageMem2DMultisampleEXT(GLenum target,
                                               GLsizei samples,
                                               GLenum internalFormat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLboolean fixedSampleLocations,
                                               GLuint memory,
                                               GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalFormat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedSampleLocations = %u, GLuint memory = %u, "
        "GLuint64 offset = %llu)",
        target, samples, internalFormat, width, height, fixedSampleLocations, memory,
        static_cast<unsigned long long>(offset));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem2DMultisampleEXT, context, targetPacked, samples, internalFormat,
                      width, height, fixedSampleLocations, memory, offset);
        if (context->skipValidation() || ValidateTexStorageMem2DMultisampleEXT(
                                             context, targetPacked, samples, internalFormat, width,
                                             height, fixedSampleLocations, memory, offset))
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memory, offset);
        }
    }
}

void GL_APIENTRY TexStorageMem3DEXT(GLenum target,
                                    GLsizei levels,
                                    GLenum internalFormat,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLuint memory,
                                    GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalFormat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLuint memory = %u, GLuint64 offset = %llu)",
        target, levels, internalFormat, width, height, depth, memory,
        static_cast<unsigned long long>(offset));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem3DEXT, context, targetPacked, levels, internalFormat, width,
                      height, depth, memory, offset);
        if (context->skipValidation() ||
            ValidateTexStorageMem3DEXT(context, targetPacked, levels, internalFormat, width, height,
                                       depth, memory, offset))
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memory, offset);
        }
    }
}

void GL_APIENTRY TexStorageMem3DMultisampleEXT(GLenum target,
                                               GLsizei samples,
                                               GLenum internalFormat,
                                               GLsizei width,
                                               GLsizei height,
                                               GLsizei depth,
                                               GLboolean fixedSampleLocations,
                                               GLuint memory,
                                               GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalFormat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLsizei depth = %d, GLboolean fixedSampleLocations = %u, "
        "GLuint memory = %u, GLuint64 offset = %llu)",
        target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory,
        static_cast<unsigned long long>(offset));

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem3DMultisampleEXT, context, targetPacked, samples, internalFormat,
                      width, height, depth, fixedSampleLocations, memory, offset);
        if (context->skipValidation() || ValidateTexStorageMem3DMultisampleEXT(
                                             context, targetPacked, samples, internalFormat, width,
                                             height, depth, fixedSampleLocations, memory, offset))
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memory,
                                                offset);
        }
    }
}

// GL_EXT_memory_object_fd
void GL_APIENTRY ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
    EVENT("(GLuint memory = %u, GLuint64 size = %llu, GLenum handleType = 0x%X, GLint fd = %d)",
          memory, static_cast<unsigned long long>(size), handleType, fd);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        HandleType handleTypePacked = FromGLenum<HandleType>(handleType);
        ANGLE_CAPTURE(ImportMemoryFdEXT, context, memory, size, handleTypePacked, fd);
        if (context->skipValidation() ||
            ValidateImportMemoryFdEXT(context, memory, size, handleTypePacked, fd))
        {
            context->importMemoryFd(memory, size, handleTypePacked, fd);
        }
    }
}

// GL_EXT_occlusion_query_boolean
// BeginQueryEXT is already defined.

// DeleteQueriesEXT is already defined.

// EndQueryEXT is already defined.

// GenQueriesEXT is already defined.

// GetQueryObjectuivEXT is already defined.

// GetQueryivEXT is already defined.

// IsQueryEXT is already defined.

// GL_EXT_robustness
GLenum GL_APIENTRY GetGraphicsResetStatusEXT()
{
    EVENT("()");

    Context *context = GetGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, context);
        if (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context))
        {
            return context->getGraphicsResetStatus();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
}

void GL_APIENTRY GetnUniformfvEXT(GLuint program, GLint location, GLsizei bufSize, GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat *params = "
        "0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetnUniformfvEXT, context, program, location, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetnUniformfvEXT(context, program, location, bufSize, params))
        {
            context->getnUniformfv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY GetnUniformivEXT(GLuint program, GLint location, GLsizei bufSize, GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint *params = "
        "0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetnUniformivEXT, context, program, location, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetnUniformivEXT(context, program, location, bufSize, params))
        {
            context->getnUniformiv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY ReadnPixelsEXT(GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLenum format,
                                GLenum type,
                                GLsizei bufSize,
                                void *data)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ReadnPixelsEXT, context, x, y, width, height, format, type, bufSize, data);
        if (context->skipValidation() ||
            ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
    }
}

// GL_EXT_semaphore
void GL_APIENTRY DeleteSemaphoresEXT(GLsizei n, const GLuint *semaphores)
{
    EVENT("(GLsizei n = %d, const GLuint *semaphores = 0x%016" PRIxPTR ")", n,
          (uintptr_t)semaphores);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteSemaphoresEXT, context, n, semaphores);
        if (context->skipValidation() || ValidateDeleteSemaphoresEXT(context, n, semaphores))
        {
            context->deleteSemaphores(n, semaphores);
        }
    }
}

void GL_APIENTRY GenSemaphoresEXT(GLsizei n, GLuint *semaphores)
{
    EVENT("(GLsizei n = %d, GLuint *semaphores = 0x%016" PRIxPTR ")", n, (uintptr_t)semaphores);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenSemaphoresEXT, context, n, semaphores);
        if (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphores))
        {
            context->genSemaphores(n, semaphores);
        }
    }
}

void GL_APIENTRY GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 *params)
{
    EVENT("(GLuint semaphore = %u, GLenum pname = 0x%X, GLuint64 *params = 0x%016" PRIxPTR ")",
          semaphore, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, context, semaphore, pname, params);
        if (context->skipValidation() ||
            ValidateGetSemaphoreParameterui64vEXT(context, semaphore, pname, params))
        {
            context->getSemaphoreParameterui64v(semaphore, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsSemaphoreEXT(GLuint semaphore)
{
    EVENT("(GLuint semaphore = %u)", semaphore);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsSemaphoreEXT, context, semaphore);
        if (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphore))
        {
            return context->isSemaphore(semaphore);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
}

void GL_APIENTRY SemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, const GLuint64 *params)
{
    EVENT("(GLuint semaphore = %u, GLenum pname = 0x%X, const GLuint64 *params = 0x%016" PRIxPTR
          ")",
          semaphore, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SemaphoreParameterui64vEXT, context, semaphore, pname, params);
        if (context->skipValidation() ||
            ValidateSemaphoreParameterui64vEXT(context, semaphore, pname, params))
        {
            context->semaphoreParameterui64v(semaphore, pname, params);
        }
    }
}

void GL_APIENTRY SignalSemaphoreEXT(GLuint semaphore,
                                    GLuint numBufferBarriers,
                                    const GLuint *buffers,
                                    GLuint numTextureBarriers,
                                    const GLuint *textures,
                                    const GLenum *dstLayouts)
{
    EVENT(
        "(GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint *buffers = "
        "0x%016" PRIxPTR ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
        ", const GLenum *dstLayouts = 0x%016" PRIxPTR ")",
        semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers, (uintptr_t)textures,
        (uintptr_t)dstLayouts);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SignalSemaphoreEXT, context, semaphore, numBufferBarriers, buffers,
                      numTextureBarriers, textures, dstLayouts);
        if (context->skipValidation() ||
            ValidateSignalSemaphoreEXT(context, semaphore, numBufferBarriers, buffers,
                                       numTextureBarriers, textures, dstLayouts))
        {
            context->signalSemaphore(semaphore, numBufferBarriers, buffers, numTextureBarriers,
                                     textures, dstLayouts);
        }
    }
}

void GL_APIENTRY WaitSemaphoreEXT(GLuint semaphore,
                                  GLuint numBufferBarriers,
                                  const GLuint *buffers,
                                  GLuint numTextureBarriers,
                                  const GLuint *textures,
                                  const GLenum *srcLayouts)
{
    EVENT(
        "(GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint *buffers = "
        "0x%016" PRIxPTR ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
        ", const GLenum *srcLayouts = 0x%016" PRIxPTR ")",
        semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers, (uintptr_t)textures,
        (uintptr_t)srcLayouts);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(WaitSemaphoreEXT, context, semaphore, numBufferBarriers, buffers,
                      numTextureBarriers, textures, srcLayouts);
        if (context->skipValidation() ||
            ValidateWaitSemaphoreEXT(context, semaphore, numBufferBarriers, buffers,
                                     numTextureBarriers, textures, srcLayouts))
        {
            context->waitSemaphore(semaphore, numBufferBarriers, buffers, numTextureBarriers,
                                   textures, srcLayouts);
        }
    }
}

// GetUnsignedBytei_vEXT is already defined.

// GetUnsignedBytevEXT is already defined.

// GL_EXT_semaphore_fd
void GL_APIENTRY ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
    EVENT("(GLuint semaphore = %u, GLenum handleType = 0x%X, GLint fd = %d)", semaphore, handleType,
          fd);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        HandleType handleTypePacked = FromGLenum<HandleType>(handleType);
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, context, semaphore, handleTypePacked, fd);
        if (context->skipValidation() ||
            ValidateImportSemaphoreFdEXT(context, semaphore, handleTypePacked, fd))
        {
            context->importSemaphoreFd(semaphore, handleTypePacked, fd);
        }
    }
}

// GL_EXT_texture_storage
void GL_APIENTRY TexStorage1DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d)",
        target, levels, internalformat, width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexStorage1DEXT, context, target, levels, internalformat, width);
        if (context->skipValidation() ||
            ValidateTexStorage1DEXT(context, target, levels, internalformat, width))
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
    }
}

void GL_APIENTRY
TexStorage2DEXT(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d)",
        target, levels, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2DEXT, context, targetPacked, levels, internalformat, width,
                      height);
        if (context->skipValidation() ||
            ValidateTexStorage2DEXT(context, targetPacked, levels, internalformat, width, height))
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexStorage3DEXT(GLenum target,
                                 GLsizei levels,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d)",
        target, levels, internalformat, width, height, depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3DEXT, context, targetPacked, levels, internalformat, width, height,
                      depth);
        if (context->skipValidation() ||
            ValidateTexStorage3DEXT(context, targetPacked, levels, internalformat, width, height,
                                    depth))
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
    }
}

// GL_KHR_debug
void GL_APIENTRY DebugMessageCallbackKHR(GLDEBUGPROCKHR callback, const void *userParam)
{
    EVENT("(GLDEBUGPROCKHR callback = 0x%016" PRIxPTR ", const void *userParam = 0x%016" PRIxPTR
          ")",
          (uintptr_t)callback, (uintptr_t)userParam);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DebugMessageCallbackKHR, context, callback, userParam);
        if (context->skipValidation() ||
            ValidateDebugMessageCallbackKHR(context, callback, userParam))
        {
            context->debugMessageCallback(callback, userParam);
        }
    }
}

void GL_APIENTRY DebugMessageControlKHR(GLenum source,
                                        GLenum type,
                                        GLenum severity,
                                        GLsizei count,
                                        const GLuint *ids,
                                        GLboolean enabled)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLenum severity = 0x%X, GLsizei count = %d, "
        "const GLuint *ids = 0x%016" PRIxPTR ", GLboolean enabled = %u)",
        source, type, severity, count, (uintptr_t)ids, enabled);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DebugMessageControlKHR, context, source, type, severity, count, ids, enabled);
        if (context->skipValidation() ||
            ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled))
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
    }
}

void GL_APIENTRY DebugMessageInsertKHR(GLenum source,
                                       GLenum type,
                                       GLuint id,
                                       GLenum severity,
                                       GLsizei length,
                                       const GLchar *buf)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLuint id = %u, GLenum severity = 0x%X, "
        "GLsizei length = %d, const GLchar *buf = 0x%016" PRIxPTR ")",
        source, type, id, severity, length, (uintptr_t)buf);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DebugMessageInsertKHR, context, source, type, id, severity, length, buf);
        if (context->skipValidation() ||
            ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf))
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
    }
}

GLuint GL_APIENTRY GetDebugMessageLogKHR(GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog)
{
    EVENT("(GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%016" PRIxPTR
          ", GLenum *types = 0x%016" PRIxPTR ", GLuint *ids = 0x%016" PRIxPTR
          ", GLenum *severities = 0x%016" PRIxPTR ", GLsizei *lengths = 0x%016" PRIxPTR
          ", GLchar *messageLog = 0x%016" PRIxPTR ")",
          count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetDebugMessageLogKHR, context, count, bufSize, sources, types, ids,
                      severities, lengths, messageLog);
        if (context->skipValidation() ||
            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types, ids, severities,
                                          lengths, messageLog))
        {
            return context->getDebugMessageLog(count, bufSize, sources, types, ids, severities,
                                               lengths, messageLog);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
}

void GL_APIENTRY
GetObjectLabelKHR(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLchar *label = 0x%016" PRIxPTR ")",
        identifier, name, bufSize, (uintptr_t)length, (uintptr_t)label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetObjectLabelKHR, context, identifier, name, bufSize, length, label);
        if (context->skipValidation() ||
            ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label))
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetObjectPtrLabelKHR(const void *ptr,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *label)
{
    EVENT("(const void *ptr = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *label = 0x%016" PRIxPTR ")",
          (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, context, ptr, bufSize, length, label);
        if (context->skipValidation() ||
            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label))
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetPointervKHR(GLenum pname, void **params)
{
    EVENT("(GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetPointervKHR, context, pname, params);
        if (context->skipValidation() || ValidateGetPointervKHR(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

void GL_APIENTRY ObjectLabelKHR(GLenum identifier, GLuint name, GLsizei length, const GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei length = %d, const GLchar *label = "
        "0x%016" PRIxPTR ")",
        identifier, name, length, (uintptr_t)label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ObjectLabelKHR, context, identifier, name, length, label);
        if (context->skipValidation() ||
            ValidateObjectLabelKHR(context, identifier, name, length, label))
        {
            context->objectLabel(identifier, name, length, label);
        }
    }
}

void GL_APIENTRY ObjectPtrLabelKHR(const void *ptr, GLsizei length, const GLchar *label)
{
    EVENT("(const void *ptr = 0x%016" PRIxPTR
          ", GLsizei length = %d, const GLchar *label = 0x%016" PRIxPTR ")",
          (uintptr_t)ptr, length, (uintptr_t)label);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ObjectPtrLabelKHR, context, ptr, length, label);
        if (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label))
        {
            context->objectPtrLabel(ptr, length, label);
        }
    }
}

void GL_APIENTRY PopDebugGroupKHR()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PopDebugGroupKHR, context);
        if (context->skipValidation() || ValidatePopDebugGroupKHR(context))
        {
            context->popDebugGroup();
        }
    }
}

void GL_APIENTRY PushDebugGroupKHR(GLenum source, GLuint id, GLsizei length, const GLchar *message)
{
    EVENT(
        "(GLenum source = 0x%X, GLuint id = %u, GLsizei length = %d, const GLchar *message = "
        "0x%016" PRIxPTR ")",
        source, id, length, (uintptr_t)message);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(PushDebugGroupKHR, context, source, id, length, message);
        if (context->skipValidation() ||
            ValidatePushDebugGroupKHR(context, source, id, length, message))
        {
            context->pushDebugGroup(source, id, length, message);
        }
    }
}

// GL_KHR_parallel_shader_compile
void GL_APIENTRY MaxShaderCompilerThreadsKHR(GLuint count)
{
    EVENT("(GLuint count = %u)", count);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, context, count);
        if (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count))
        {
            context->maxShaderCompilerThreads(count);
        }
    }
}

// GL_NV_fence
void GL_APIENTRY DeleteFencesNV(GLsizei n, const GLuint *fences)
{
    EVENT("(GLsizei n = %d, const GLuint *fences = 0x%016" PRIxPTR ")", n, (uintptr_t)fences);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteFencesNV, context, n, fences);
        if (context->skipValidation() || ValidateDeleteFencesNV(context, n, fences))
        {
            context->deleteFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY FinishFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FinishFenceNV, context, fence);
        if (context->skipValidation() || ValidateFinishFenceNV(context, fence))
        {
            context->finishFenceNV(fence);
        }
    }
}

void GL_APIENTRY GenFencesNV(GLsizei n, GLuint *fences)
{
    EVENT("(GLsizei n = %d, GLuint *fences = 0x%016" PRIxPTR ")", n, (uintptr_t)fences);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenFencesNV, context, n, fences);
        if (context->skipValidation() || ValidateGenFencesNV(context, n, fences))
        {
            context->genFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY GetFenceivNV(GLuint fence, GLenum pname, GLint *params)
{
    EVENT("(GLuint fence = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", fence,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFenceivNV, context, fence, pname, params);
        if (context->skipValidation() || ValidateGetFenceivNV(context, fence, pname, params))
        {
            context->getFenceivNV(fence, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsFenceNV, context, fence);
        if (context->skipValidation() || ValidateIsFenceNV(context, fence))
        {
            return context->isFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
}

void GL_APIENTRY SetFenceNV(GLuint fence, GLenum condition)
{
    EVENT("(GLuint fence = %u, GLenum condition = 0x%X)", fence, condition);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SetFenceNV, context, fence, condition);
        if (context->skipValidation() || ValidateSetFenceNV(context, fence, condition))
        {
            context->setFenceNV(fence, condition);
        }
    }
}

GLboolean GL_APIENTRY TestFenceNV(GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TestFenceNV, context, fence);
        if (context->skipValidation() || ValidateTestFenceNV(context, fence))
        {
            return context->testFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
}

// GL_OES_EGL_image
void GL_APIENTRY EGLImageTargetRenderbufferStorageOES(GLenum target, GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%016" PRIxPTR ")", target,
          (uintptr_t)image);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, context, target, image);
        if (context->skipValidation() ||
            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image))
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
    }
}

void GL_APIENTRY EGLImageTargetTexture2DOES(GLenum target, GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%016" PRIxPTR ")", target,
          (uintptr_t)image);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, context, targetPacked, image);
        if (context->skipValidation() ||
            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image))
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
    }
}

// GL_OES_draw_texture
void GL_APIENTRY DrawTexfOES(GLfloat x, GLfloat y, GLfloat z, GLfloat width, GLfloat height)
{
    EVENT(
        "(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat width = %f, GLfloat height = %f)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexfOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height))
        {
            context->drawTexf(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexfvOES(const GLfloat *coords)
{
    EVENT("(const GLfloat *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexfvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexfvOES(context, coords))
        {
            context->drawTexfv(coords);
        }
    }
}

void GL_APIENTRY DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height = %d)", x, y,
          z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexiOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height))
        {
            context->drawTexi(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexivOES(const GLint *coords)
{
    EVENT("(const GLint *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexivOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexivOES(context, coords))
        {
            context->drawTexiv(coords);
        }
    }
}

void GL_APIENTRY DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
    EVENT(
        "(GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort width = %d, GLshort height = %d)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexsOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height))
        {
            context->drawTexs(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexsvOES(const GLshort *coords)
{
    EVENT("(const GLshort *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexsvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexsvOES(context, coords))
        {
            context->drawTexsv(coords);
        }
    }
}

void GL_APIENTRY DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
    EVENT(
        "(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X, GLfixed width = 0x%X, GLfixed "
        "height = 0x%X)",
        x, y, z, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexxOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height))
        {
            context->drawTexx(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexxvOES(const GLfixed *coords)
{
    EVENT("(const GLfixed *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DrawTexxvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexxvOES(context, coords))
        {
            context->drawTexxv(coords);
        }
    }
}

// GL_OES_framebuffer_object
void GL_APIENTRY BindFramebufferOES(GLenum target, GLuint framebuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindFramebufferOES, context, target, framebuffer);
        if (context->skipValidation() || ValidateBindFramebufferOES(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindRenderbufferOES(GLenum target, GLuint renderbuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindRenderbufferOES, context, target, renderbuffer);
        if (context->skipValidation() || ValidateBindRenderbufferOES(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

GLenum GL_APIENTRY CheckFramebufferStatusOES(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CheckFramebufferStatusOES, context, target);
        if (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
}

void GL_APIENTRY DeleteFramebuffersOES(GLsizei n, const GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteFramebuffersOES, context, n, framebuffers);
        if (context->skipValidation() || ValidateDeleteFramebuffersOES(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffersOES(GLsizei n, const GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteRenderbuffersOES, context, n, renderbuffers);
        if (context->skipValidation() || ValidateDeleteRenderbuffersOES(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY FramebufferRenderbufferOES(GLenum target,
                                            GLenum attachment,
                                            GLenum renderbuffertarget,
                                            GLuint renderbuffer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferRenderbufferOES, context, target, attachment, renderbuffertarget,
                      renderbuffer);
        if (context->skipValidation() ||
            ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                               renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferTexture2DOES(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture2DOES, context, target, attachment, textargetPacked,
                      texture, level);
        if (context->skipValidation() ||
            ValidateFramebufferTexture2DOES(context, target, attachment, textargetPacked, texture,
                                            level))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texture, level);
        }
    }
}

void GL_APIENTRY GenFramebuffersOES(GLsizei n, GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR ")", n, (uintptr_t)framebuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenFramebuffersOES, context, n, framebuffers);
        if (context->skipValidation() || ValidateGenFramebuffersOES(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenRenderbuffersOES(GLsizei n, GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenRenderbuffersOES, context, n, renderbuffers);
        if (context->skipValidation() || ValidateGenRenderbuffersOES(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenerateMipmapOES(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GenerateMipmapOES, context, targetPacked);
        if (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked))
        {
            context->generateMipmap(targetPacked);
        }
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivOES(GLenum target,
                                                        GLenum attachment,
                                                        GLenum pname,
                                                        GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, attachment, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, context, target, attachment, pname,
                      params);
        if (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                             context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameterivOES(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, context, target, pname, params);
        if (context->skipValidation() ||
            ValidateGetRenderbufferParameterivOES(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsFramebufferOES(GLuint framebuffer)
{
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsFramebufferOES, context, framebuffer);
        if (context->skipValidation() || ValidateIsFramebufferOES(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbufferOES(GLuint renderbuffer)
{
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsRenderbufferOES, context, renderbuffer);
        if (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
}

void GL_APIENTRY RenderbufferStorageOES(GLenum target,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(RenderbufferStorageOES, context, target, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageOES(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

// GL_OES_get_program_binary
void GL_APIENTRY GetProgramBinaryOES(GLuint program,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLenum *binaryFormat,
                                     void *binary)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat, (uintptr_t)binary);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetProgramBinaryOES, context, program, bufSize, length, binaryFormat, binary);
        if (context->skipValidation() ||
            ValidateGetProgramBinaryOES(context, program, bufSize, length, binaryFormat, binary))
        {
            context->getProgramBinary(program, bufSize, length, binaryFormat, binary);
        }
    }
}

void GL_APIENTRY ProgramBinaryOES(GLuint program,
                                  GLenum binaryFormat,
                                  const void *binary,
                                  GLint length)
{
    EVENT("(GLuint program = %u, GLenum binaryFormat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLint length = %d)",
          program, binaryFormat, (uintptr_t)binary, length);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(ProgramBinaryOES, context, program, binaryFormat, binary, length);
        if (context->skipValidation() ||
            ValidateProgramBinaryOES(context, program, binaryFormat, binary, length))
        {
            context->programBinary(program, binaryFormat, binary, length);
        }
    }
}

// GL_OES_mapbuffer
void GL_APIENTRY GetBufferPointervOES(GLenum target, GLenum pname, void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointervOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferPointervOES(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

void *GL_APIENTRY MapBufferOES(GLenum target, GLenum access)
{
    EVENT("(GLenum target = 0x%X, GLenum access = 0x%X)", target, access);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferOES, context, targetPacked, access);
        if (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access))
        {
            return context->mapBuffer(targetPacked, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
}

GLboolean GL_APIENTRY UnmapBufferOES(GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(UnmapBufferOES, context, targetPacked);
        if (context->skipValidation() || ValidateUnmapBufferOES(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBufferOES, GLboolean>();
}

// GL_OES_matrix_palette
void GL_APIENTRY CurrentPaletteMatrixOES(GLuint matrixpaletteindex)
{
    EVENT("(GLuint matrixpaletteindex = %u)", matrixpaletteindex);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, context, matrixpaletteindex);
        if (context->skipValidation() ||
            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex))
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
    }
}

void GL_APIENTRY LoadPaletteFromModelViewMatrixOES()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, context);
        if (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context))
        {
            context->loadPaletteFromModelViewMatrix();
        }
    }
}

void GL_APIENTRY MatrixIndexPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(MatrixIndexPointerOES, context, size, type, stride, pointer);
        if (context->skipValidation() ||
            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer))
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY WeightPointerOES(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(WeightPointerOES, context, size, type, stride, pointer);
        if (context->skipValidation() ||
            ValidateWeightPointerOES(context, size, type, stride, pointer))
        {
            context->weightPointer(size, type, stride, pointer);
        }
    }
}

// GL_OES_point_size_array
void GL_APIENTRY PointSizePointerOES(GLenum type, GLsizei stride, const void *pointer)
{
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
          type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(PointSizePointerOES, context, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidatePointSizePointerOES(context, typePacked, stride, pointer))
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
    }
}

// GL_OES_query_matrix
GLbitfield GL_APIENTRY QueryMatrixxOES(GLfixed *mantissa, GLint *exponent)
{
    EVENT("(GLfixed *mantissa = 0x%016" PRIxPTR ", GLint *exponent = 0x%016" PRIxPTR ")",
          (uintptr_t)mantissa, (uintptr_t)exponent);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(QueryMatrixxOES, context, mantissa, exponent);
        if (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent))
        {
            return context->queryMatrixx(mantissa, exponent);
        }
    }

    return GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
}

// GL_OES_texture_3D
void GL_APIENTRY CompressedTexImage3DOES(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "const void *data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3DOES, context, targetPacked, level, internalformat, width,
                      height, depth, border, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                            height, depth, border, imageSize, data))
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3DOES(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
        (uintptr_t)data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset,
                                               zoffset, width, height, depth, format, imageSize,
                                               data))
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
    }
}

void GL_APIENTRY CopyTexSubImage3DOES(GLenum target,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLint x,
                                      GLint y,
                                      GLsizei width,
                                      GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, zoffset, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage3DOES, context, targetPacked, level, xoffset, yoffset, zoffset,
                      x, y, width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset, x,
                                         y, width, height))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
    }
}

void GL_APIENTRY FramebufferTexture3DOES(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level,
                                         GLint zoffset)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d, GLint zoffset = %d)",
        target, attachment, textarget, texture, level, zoffset);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture3DOES, context, target, attachment, textargetPacked,
                      texture, level, zoffset);
        if (context->skipValidation() ||
            ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked, texture,
                                            level, zoffset))
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texture, level,
                                          zoffset);
        }
    }
}

void GL_APIENTRY TexImage3DOES(GLenum target,
                               GLint level,
                               GLenum internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLsizei depth,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, "
        "GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3DOES, context, targetPacked, level, internalformat, width, height,
                      depth, border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3DOES(context, targetPacked, level, internalformat, width, height,
                                  depth, border, format, type, pixels))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3DOES(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLint zoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLsizei depth,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type,
        (uintptr_t)pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3DOES, context, targetPacked, level, xoffset, yoffset, zoffset,
                      width, height, depth, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                     height, depth, format, type, pixels))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
    }
}

// GL_OES_texture_border_clamp
void GL_APIENTRY GetSamplerParameterIivOES(GLuint sampler, GLenum pname, GLint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterIivOES, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterIivOES(context, sampler, pname, params))
        {
            context->getSamplerParameterIiv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIuivOES(GLuint sampler, GLenum pname, GLuint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterIuivOES(context, sampler, pname, params))
        {
            context->getSamplerParameterIuiv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIivOES(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIivOES(context, targetPacked, pname, params))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIuivOES(GLenum target, GLenum pname, GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIuivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY SamplerParameterIivOES(GLuint sampler, GLenum pname, const GLint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterIivOES, context, sampler, pname, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIivOES(context, sampler, pname, param))
        {
            context->samplerParameterIiv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterIuivOES(GLuint sampler, GLenum pname, const GLuint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLuint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(SamplerParameterIuivOES, context, sampler, pname, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIuivOES(context, sampler, pname, param))
        {
            context->samplerParameterIuiv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterIivOES(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIivOES(context, targetPacked, pname, params))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterIuivOES(GLenum target, GLenum pname, const GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLuint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIuivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIuivOES(context, targetPacked, pname, params))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
    }
}

// GL_OES_texture_cube_map
void GL_APIENTRY GetTexGenfvOES(GLenum coord, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGenfvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params))
        {
            context->getTexGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGenivOES(GLenum coord, GLenum pname, GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGenivOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params))
        {
            context->getTexGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GetTexGenxvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params))
        {
            context->getTexGenxv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGenfOES(GLenum coord, GLenum pname, GLfloat param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenfOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGenfOES(context, coord, pname, param))
        {
            context->texGenf(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenfvOES(GLenum coord, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenfvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenfvOES(context, coord, pname, params))
        {
            context->texGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGeniOES(GLenum coord, GLenum pname, GLint param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint param = %d)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGeniOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGeniOES(context, coord, pname, param))
        {
            context->texGeni(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenivOES(GLenum coord, GLenum pname, const GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenivOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenivOES(context, coord, pname, params))
        {
            context->texGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGenxOES(GLenum coord, GLenum pname, GLfixed param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", coord, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenxOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGenxOES(context, coord, pname, param))
        {
            context->texGenx(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenxvOES(GLenum coord, GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(TexGenxvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenxvOES(context, coord, pname, params))
        {
            context->texGenxv(coord, pname, params);
        }
    }
}

// GL_OES_texture_storage_multisample_2d_array
void GL_APIENTRY TexStorage3DMultisampleOES(GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLsizei depth = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, depth, fixedsamplelocations);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3DMultisampleOES, context, targetPacked, samples, internalformat,
                      width, height, depth, fixedsamplelocations);
        if (context->skipValidation() ||
            ValidateTexStorage3DMultisampleOES(context, targetPacked, samples, internalformat,
                                               width, height, depth, fixedsamplelocations))
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
    }
}

// GL_OES_vertex_array_object
void GL_APIENTRY BindVertexArrayOES(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(BindVertexArrayOES, context, array);
        if (context->skipValidation() || ValidateBindVertexArrayOES(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY DeleteVertexArraysOES(GLsizei n, const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(DeleteVertexArraysOES, context, n, arrays);
        if (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GenVertexArraysOES(GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(GenVertexArraysOES, context, n, arrays);
        if (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

GLboolean GL_APIENTRY IsVertexArrayOES(GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(IsVertexArrayOES, context, array);
        if (context->skipValidation() || ValidateIsVertexArrayOES(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
}

// GL_OVR_multiview
void GL_APIENTRY FramebufferTextureMultiviewOVR(GLenum target,
                                                GLenum attachment,
                                                GLuint texture,
                                                GLint level,
                                                GLint baseViewIndex,
                                                GLsizei numViews)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d, "
        "GLint baseViewIndex = %d, GLsizei numViews = %d)",
        target, attachment, texture, level, baseViewIndex, numViews);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, context, target, attachment, texture, level,
                      baseViewIndex, numViews);
        if (context->skipValidation() ||
            ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texture, level,
                                                   baseViewIndex, numViews))
        {
            context->framebufferTextureMultiview(target, attachment, texture, level, baseViewIndex,
                                                 numViews);
        }
    }
}

// GL_OVR_multiview2

// EGL_ANGLE_explicit_context
void GL_APIENTRY ActiveShaderProgramContextANGLE(GLeglContext ctx, GLuint pipeline, GLuint program)
{
    EVENT("(GLuint pipeline = %u, GLuint program = %u)", pipeline, program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ActiveShaderProgram, context, pipeline, program);
        if (context->skipValidation() || ValidateActiveShaderProgram(context, pipeline, program))
        {
            context->activeShaderProgram(pipeline, program);
        }
    }
}

void GL_APIENTRY ActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ActiveTexture, context, texture);
        if (context->skipValidation() || ValidateActiveTexture(context, texture))
        {
            context->activeTexture(texture);
        }
    }
}

void GL_APIENTRY AlphaFuncContextANGLE(GLeglContext ctx, GLenum func, GLfloat ref)
{
    EVENT("(GLenum func = 0x%X, GLfloat ref = %f)", func, ref);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked = FromGLenum<AlphaTestFunc>(func);
        ANGLE_CAPTURE(AlphaFunc, context, funcPacked, ref);
        if (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref))
        {
            context->alphaFunc(funcPacked, ref);
        }
    }
}

void GL_APIENTRY AlphaFuncxContextANGLE(GLeglContext ctx, GLenum func, GLfixed ref)
{
    EVENT("(GLenum func = 0x%X, GLfixed ref = 0x%X)", func, ref);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        AlphaTestFunc funcPacked = FromGLenum<AlphaTestFunc>(func);
        ANGLE_CAPTURE(AlphaFuncx, context, funcPacked, ref);
        if (context->skipValidation() || ValidateAlphaFuncx(context, funcPacked, ref))
        {
            context->alphaFuncx(funcPacked, ref);
        }
    }
}

void GL_APIENTRY AttachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(AttachShader, context, program, shader);
        if (context->skipValidation() || ValidateAttachShader(context, program, shader))
        {
            context->attachShader(program, shader);
        }
    }
}

void GL_APIENTRY BeginQueryContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(BeginQuery, context, targetPacked, id);
        if (context->skipValidation() || ValidateBeginQuery(context, targetPacked, id))
        {
            context->beginQuery(targetPacked, id);
        }
    }
}

void GL_APIENTRY BeginQueryEXTContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(BeginQueryEXT, context, targetPacked, id);
        if (context->skipValidation() || ValidateBeginQueryEXT(context, targetPacked, id))
        {
            context->beginQuery(targetPacked, id);
        }
    }
}

void GL_APIENTRY BeginTransformFeedbackContextANGLE(GLeglContext ctx, GLenum primitiveMode)
{
    EVENT("(GLenum primitiveMode = 0x%X)", primitiveMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode primitiveModePacked = FromGLenum<PrimitiveMode>(primitiveMode);
        ANGLE_CAPTURE(BeginTransformFeedback, context, primitiveModePacked);
        if (context->skipValidation() ||
            ValidateBeginTransformFeedback(context, primitiveModePacked))
        {
            context->beginTransformFeedback(primitiveModePacked);
        }
    }
}

void GL_APIENTRY BindAttribLocationContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLuint index,
                                                const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint index = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, index, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindAttribLocation, context, program, index, name);
        if (context->skipValidation() || ValidateBindAttribLocation(context, program, index, name))
        {
            context->bindAttribLocation(program, index, name);
        }
    }
}

void GL_APIENTRY BindBufferContextANGLE(GLeglContext ctx, GLenum target, GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint buffer = %u)", target, buffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBuffer, context, targetPacked, buffer);
        if (context->skipValidation() || ValidateBindBuffer(context, targetPacked, buffer))
        {
            context->bindBuffer(targetPacked, buffer);
        }
    }
}

void GL_APIENTRY BindBufferBaseContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLuint index,
                                            GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u)", target, index, buffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferBase, context, targetPacked, index, buffer);
        if (context->skipValidation() ||
            ValidateBindBufferBase(context, targetPacked, index, buffer))
        {
            context->bindBufferBase(targetPacked, index, buffer);
        }
    }
}

void GL_APIENTRY BindBufferRangeContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLuint index,
                                             GLuint buffer,
                                             GLintptr offset,
                                             GLsizeiptr size)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLuint buffer = %u, GLintptr offset = %llu, "
        "GLsizeiptr size = %llu)",
        target, index, buffer, static_cast<unsigned long long>(offset),
        static_cast<unsigned long long>(size));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BindBufferRange, context, targetPacked, index, buffer, offset, size);
        if (context->skipValidation() ||
            ValidateBindBufferRange(context, targetPacked, index, buffer, offset, size))
        {
            context->bindBufferRange(targetPacked, index, buffer, offset, size);
        }
    }
}

void GL_APIENTRY BindFragDataLocationEXTContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLuint color,
                                                     const GLchar *name)
{
    EVENT("(GLuint program = %u, GLuint color = %u, const GLchar *name = 0x%016" PRIxPTR ")",
          program, color, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindFragDataLocationEXT, context, program, color, name);
        if (context->skipValidation() ||
            ValidateBindFragDataLocationEXT(context, program, color, name))
        {
            context->bindFragDataLocation(program, color, name);
        }
    }
}

void GL_APIENTRY BindFragDataLocationIndexedEXTContextANGLE(GLeglContext ctx,
                                                            GLuint program,
                                                            GLuint colorNumber,
                                                            GLuint index,
                                                            const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint colorNumber = %u, GLuint index = %u, const GLchar *name = "
        "0x%016" PRIxPTR ")",
        program, colorNumber, index, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindFragDataLocationIndexedEXT, context, program, colorNumber, index, name);
        if (context->skipValidation() ||
            ValidateBindFragDataLocationIndexedEXT(context, program, colorNumber, index, name))
        {
            context->bindFragDataLocationIndexed(program, colorNumber, index, name);
        }
    }
}

void GL_APIENTRY BindFramebufferContextANGLE(GLeglContext ctx, GLenum target, GLuint framebuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindFramebuffer, context, target, framebuffer);
        if (context->skipValidation() || ValidateBindFramebuffer(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindFramebufferOESContextANGLE(GLeglContext ctx, GLenum target, GLuint framebuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint framebuffer = %u)", target, framebuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindFramebufferOES, context, target, framebuffer);
        if (context->skipValidation() || ValidateBindFramebufferOES(context, target, framebuffer))
        {
            context->bindFramebuffer(target, framebuffer);
        }
    }
}

void GL_APIENTRY BindImageTextureContextANGLE(GLeglContext ctx,
                                              GLuint unit,
                                              GLuint texture,
                                              GLint level,
                                              GLboolean layered,
                                              GLint layer,
                                              GLenum access,
                                              GLenum format)
{
    EVENT(
        "(GLuint unit = %u, GLuint texture = %u, GLint level = %d, GLboolean layered = %u, GLint "
        "layer = %d, GLenum access = 0x%X, GLenum format = 0x%X)",
        unit, texture, level, layered, layer, access, format);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindImageTexture, context, unit, texture, level, layered, layer, access,
                      format);
        if (context->skipValidation() ||
            ValidateBindImageTexture(context, unit, texture, level, layered, layer, access, format))
        {
            context->bindImageTexture(unit, texture, level, layered, layer, access, format);
        }
    }
}

void GL_APIENTRY BindProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindProgramPipeline, context, pipeline);
        if (context->skipValidation() || ValidateBindProgramPipeline(context, pipeline))
        {
            context->bindProgramPipeline(pipeline);
        }
    }
}

void GL_APIENTRY BindRenderbufferContextANGLE(GLeglContext ctx, GLenum target, GLuint renderbuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindRenderbuffer, context, target, renderbuffer);
        if (context->skipValidation() || ValidateBindRenderbuffer(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

void GL_APIENTRY BindRenderbufferOESContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLuint renderbuffer)
{
    EVENT("(GLenum target = 0x%X, GLuint renderbuffer = %u)", target, renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindRenderbufferOES, context, target, renderbuffer);
        if (context->skipValidation() || ValidateBindRenderbufferOES(context, target, renderbuffer))
        {
            context->bindRenderbuffer(target, renderbuffer);
        }
    }
}

void GL_APIENTRY BindSamplerContextANGLE(GLeglContext ctx, GLuint unit, GLuint sampler)
{
    EVENT("(GLuint unit = %u, GLuint sampler = %u)", unit, sampler);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindSampler, context, unit, sampler);
        if (context->skipValidation() || ValidateBindSampler(context, unit, sampler))
        {
            context->bindSampler(unit, sampler);
        }
    }
}

void GL_APIENTRY BindTextureContextANGLE(GLeglContext ctx, GLenum target, GLuint texture)
{
    EVENT("(GLenum target = 0x%X, GLuint texture = %u)", target, texture);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(BindTexture, context, targetPacked, texture);
        if (context->skipValidation() || ValidateBindTexture(context, targetPacked, texture))
        {
            context->bindTexture(targetPacked, texture);
        }
    }
}

void GL_APIENTRY BindTransformFeedbackContextANGLE(GLeglContext ctx, GLenum target, GLuint id)
{
    EVENT("(GLenum target = 0x%X, GLuint id = %u)", target, id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindTransformFeedback, context, target, id);
        if (context->skipValidation() || ValidateBindTransformFeedback(context, target, id))
        {
            context->bindTransformFeedback(target, id);
        }
    }
}

void GL_APIENTRY BindVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindVertexArray, context, array);
        if (context->skipValidation() || ValidateBindVertexArray(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY BindVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindVertexArrayOES, context, array);
        if (context->skipValidation() || ValidateBindVertexArrayOES(context, array))
        {
            context->bindVertexArray(array);
        }
    }
}

void GL_APIENTRY BindVertexBufferContextANGLE(GLeglContext ctx,
                                              GLuint bindingindex,
                                              GLuint buffer,
                                              GLintptr offset,
                                              GLsizei stride)
{
    EVENT(
        "(GLuint bindingindex = %u, GLuint buffer = %u, GLintptr offset = %llu, GLsizei stride = "
        "%d)",
        bindingindex, buffer, static_cast<unsigned long long>(offset), stride);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindVertexBuffer, context, bindingindex, buffer, offset, stride);
        if (context->skipValidation() ||
            ValidateBindVertexBuffer(context, bindingindex, buffer, offset, stride))
        {
            context->bindVertexBuffer(bindingindex, buffer, offset, stride);
        }
    }
}

void GL_APIENTRY
BlendColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlendColor, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateBlendColor(context, red, green, blue, alpha))
        {
            context->blendColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY BlendEquationContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlendEquation, context, mode);
        if (context->skipValidation() || ValidateBlendEquation(context, mode))
        {
            context->blendEquation(mode);
        }
    }
}

void GL_APIENTRY BlendEquationSeparateContextANGLE(GLeglContext ctx,
                                                   GLenum modeRGB,
                                                   GLenum modeAlpha)
{
    EVENT("(GLenum modeRGB = 0x%X, GLenum modeAlpha = 0x%X)", modeRGB, modeAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlendEquationSeparate, context, modeRGB, modeAlpha);
        if (context->skipValidation() || ValidateBlendEquationSeparate(context, modeRGB, modeAlpha))
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
    }
}

void GL_APIENTRY BlendFuncContextANGLE(GLeglContext ctx, GLenum sfactor, GLenum dfactor)
{
    EVENT("(GLenum sfactor = 0x%X, GLenum dfactor = 0x%X)", sfactor, dfactor);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlendFunc, context, sfactor, dfactor);
        if (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor))
        {
            context->blendFunc(sfactor, dfactor);
        }
    }
}

void GL_APIENTRY BlendFuncSeparateContextANGLE(GLeglContext ctx,
                                               GLenum sfactorRGB,
                                               GLenum dfactorRGB,
                                               GLenum sfactorAlpha,
                                               GLenum dfactorAlpha)
{
    EVENT(
        "(GLenum sfactorRGB = 0x%X, GLenum dfactorRGB = 0x%X, GLenum sfactorAlpha = 0x%X, GLenum "
        "dfactorAlpha = 0x%X)",
        sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlendFuncSeparate, context, sfactorRGB, dfactorRGB, sfactorAlpha,
                      dfactorAlpha);
        if (context->skipValidation() ||
            ValidateBlendFuncSeparate(context, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha))
        {
            context->blendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
    }
}

void GL_APIENTRY BlitFramebufferContextANGLE(GLeglContext ctx,
                                             GLint srcX0,
                                             GLint srcY0,
                                             GLint srcX1,
                                             GLint srcY1,
                                             GLint dstX0,
                                             GLint dstY0,
                                             GLint dstX1,
                                             GLint dstY1,
                                             GLbitfield mask,
                                             GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlitFramebuffer, context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                      dstY1, mask, filter);
        if (context->skipValidation() ||
            ValidateBlitFramebuffer(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1,
                                    mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

void GL_APIENTRY BlitFramebufferANGLEContextANGLE(GLeglContext ctx,
                                                  GLint srcX0,
                                                  GLint srcY0,
                                                  GLint srcX1,
                                                  GLint srcY1,
                                                  GLint dstX0,
                                                  GLint dstY0,
                                                  GLint dstX1,
                                                  GLint dstY1,
                                                  GLbitfield mask,
                                                  GLenum filter)
{
    EVENT(
        "(GLint srcX0 = %d, GLint srcY0 = %d, GLint srcX1 = %d, GLint srcY1 = %d, GLint dstX0 = "
        "%d, GLint dstY0 = %d, GLint dstX1 = %d, GLint dstY1 = %d, GLbitfield mask = 0x%X, GLenum "
        "filter = 0x%X)",
        srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BlitFramebufferANGLE, context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0,
                      dstX1, dstY1, mask, filter);
        if (context->skipValidation() ||
            ValidateBlitFramebufferANGLE(context, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1,
                                         dstY1, mask, filter))
        {
            context->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask,
                                     filter);
        }
    }
}

void GL_APIENTRY BufferDataContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLsizeiptr size,
                                        const void *data,
                                        GLenum usage)
{
    EVENT("(GLenum target = 0x%X, GLsizeiptr size = %llu, const void *data = 0x%016" PRIxPTR
          ", GLenum usage = 0x%X)",
          target, static_cast<unsigned long long>(size), (uintptr_t)data, usage);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        BufferUsage usagePacked    = FromGLenum<BufferUsage>(usage);
        ANGLE_CAPTURE(BufferData, context, targetPacked, size, data, usagePacked);
        if (context->skipValidation() ||
            ValidateBufferData(context, targetPacked, size, data, usagePacked))
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
    }
}

void GL_APIENTRY BufferStorageMemEXTContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLsizeiptr size,
                                                 GLuint memory,
                                                 GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizeiptr size = %llu, GLuint memory = %u, GLuint64 offset = "
        "%llu)",
        target, static_cast<unsigned long long>(size), memory,
        static_cast<unsigned long long>(offset));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(BufferStorageMemEXT, context, targetPacked, size, memory, offset);
        if (context->skipValidation() ||
            ValidateBufferStorageMemEXT(context, targetPacked, size, memory, offset))
        {
            context->bufferStorageMem(targetPacked, size, memory, offset);
        }
    }
}

void GL_APIENTRY BufferSubDataContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLintptr offset,
                                           GLsizeiptr size,
                                           const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr size = %llu, const void *data = "
        "0x%016" PRIxPTR ")",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(BufferSubData, context, targetPacked, offset, size, data);
        if (context->skipValidation() ||
            ValidateBufferSubData(context, targetPacked, offset, size, data))
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
    }
}

GLenum GL_APIENTRY CheckFramebufferStatusContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CheckFramebufferStatus, context, target);
        if (context->skipValidation() || ValidateCheckFramebufferStatus(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatus, GLenum>();
}

GLenum GL_APIENTRY CheckFramebufferStatusOESContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CheckFramebufferStatusOES, context, target);
        if (context->skipValidation() || ValidateCheckFramebufferStatusOES(context, target))
        {
            return context->checkFramebufferStatus(target);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CheckFramebufferStatusOES, GLenum>();
}

void GL_APIENTRY ClearContextANGLE(GLeglContext ctx, GLbitfield mask)
{
    EVENT("(GLbitfield mask = 0x%X)", mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Clear, context, mask);
        if (context->skipValidation() || ValidateClear(context, mask))
        {
            context->clear(mask);
        }
    }
}

void GL_APIENTRY ClearBufferfiContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           GLfloat depth,
                                           GLint stencil)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, GLfloat depth = %f, GLint stencil = %d)",
          buffer, drawbuffer, depth, stencil);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearBufferfi, context, buffer, drawbuffer, depth, stencil);
        if (context->skipValidation() ||
            ValidateClearBufferfi(context, buffer, drawbuffer, depth, stencil))
        {
            context->clearBufferfi(buffer, drawbuffer, depth, stencil);
        }
    }
}

void GL_APIENTRY ClearBufferfvContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLfloat *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearBufferfv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferfv(context, buffer, drawbuffer, value))
        {
            context->clearBufferfv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferivContextANGLE(GLeglContext ctx,
                                           GLenum buffer,
                                           GLint drawbuffer,
                                           const GLint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearBufferiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferiv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY ClearBufferuivContextANGLE(GLeglContext ctx,
                                            GLenum buffer,
                                            GLint drawbuffer,
                                            const GLuint *value)
{
    EVENT("(GLenum buffer = 0x%X, GLint drawbuffer = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          buffer, drawbuffer, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearBufferuiv, context, buffer, drawbuffer, value);
        if (context->skipValidation() || ValidateClearBufferuiv(context, buffer, drawbuffer, value))
        {
            context->clearBufferuiv(buffer, drawbuffer, value);
        }
    }
}

void GL_APIENTRY
ClearColorContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearColor, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha))
        {
            context->clearColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY
ClearColorxContextANGLE(GLeglContext ctx, GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearColorx, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha))
        {
            context->clearColorx(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearDepthfContextANGLE(GLeglContext ctx, GLfloat d)
{
    EVENT("(GLfloat d = %f)", d);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearDepthf, context, d);
        if (context->skipValidation() || ValidateClearDepthf(context, d))
        {
            context->clearDepthf(d);
        }
    }
}

void GL_APIENTRY ClearDepthxContextANGLE(GLeglContext ctx, GLfixed depth)
{
    EVENT("(GLfixed depth = 0x%X)", depth);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearDepthx, context, depth);
        if (context->skipValidation() || ValidateClearDepthx(context, depth))
        {
            context->clearDepthx(depth);
        }
    }
}

void GL_APIENTRY ClearStencilContextANGLE(GLeglContext ctx, GLint s)
{
    EVENT("(GLint s = %d)", s);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClearStencil, context, s);
        if (context->skipValidation() || ValidateClearStencil(context, s))
        {
            context->clearStencil(s);
        }
    }
}

void GL_APIENTRY ClientActiveTextureContextANGLE(GLeglContext ctx, GLenum texture)
{
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClientActiveTexture, context, texture);
        if (context->skipValidation() || ValidateClientActiveTexture(context, texture))
        {
            context->clientActiveTexture(texture);
        }
    }
}

GLenum GL_APIENTRY ClientWaitSyncContextANGLE(GLeglContext ctx,
                                              GLsync sync,
                                              GLbitfield flags,
                                              GLuint64 timeout)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ", GLbitfield flags = 0x%X, GLuint64 timeout = %llu)",
          (uintptr_t)sync, flags, static_cast<unsigned long long>(timeout));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClientWaitSync, context, sync, flags, timeout);
        if (context->skipValidation() || ValidateClientWaitSync(context, sync, flags, timeout))
        {
            return context->clientWaitSync(sync, flags, timeout);
        }
    }

    return GetDefaultReturnValue<EntryPoint::ClientWaitSync, GLenum>();
}

void GL_APIENTRY ClipPlanefContextANGLE(GLeglContext ctx, GLenum p, const GLfloat *eqn)
{
    EVENT("(GLenum p = 0x%X, const GLfloat *eqn = 0x%016" PRIxPTR ")", p, (uintptr_t)eqn);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClipPlanef, context, p, eqn);
        if (context->skipValidation() || ValidateClipPlanef(context, p, eqn))
        {
            context->clipPlanef(p, eqn);
        }
    }
}

void GL_APIENTRY ClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, const GLfixed *equation)
{
    EVENT("(GLenum plane = 0x%X, const GLfixed *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ClipPlanex, context, plane, equation);
        if (context->skipValidation() || ValidateClipPlanex(context, plane, equation))
        {
            context->clipPlanex(plane, equation);
        }
    }
}

void GL_APIENTRY
Color4fContextANGLE(GLeglContext ctx, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Color4f, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha))
        {
            context->color4f(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY
Color4ubContextANGLE(GLeglContext ctx, GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    EVENT("(GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d, GLubyte alpha = %d)", red,
          green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Color4ub, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha))
        {
            context->color4ub(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY
Color4xContextANGLE(GLeglContext ctx, GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Color4x, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha))
        {
            context->color4x(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorMaskContextANGLE(GLeglContext ctx,
                                       GLboolean red,
                                       GLboolean green,
                                       GLboolean blue,
                                       GLboolean alpha)
{
    EVENT("(GLboolean red = %u, GLboolean green = %u, GLboolean blue = %u, GLboolean alpha = %u)",
          red, green, blue, alpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ColorMask, context, red, green, blue, alpha);
        if (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha))
        {
            context->colorMask(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorPointerContextANGLE(GLeglContext ctx,
                                          GLint size,
                                          GLenum type,
                                          GLsizei stride,
                                          const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(ColorPointer, context, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateColorPointer(context, size, typePacked, stride, pointer))
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY CompileShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CompileShader, context, shader);
        if (context->skipValidation() || ValidateCompileShader(context, shader))
        {
            context->compileShader(shader);
        }
    }
}

void GL_APIENTRY CompressedTexImage2DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLint border,
                                                  GLsizei imageSize,
                                                  const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, const void *data = "
        "0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, imageSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage2D, context, targetPacked, level, internalformat, width,
                      height, border, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexImage2D(context, targetPacked, level, internalformat, width,
                                         height, border, imageSize, data))
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexImage3DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLsizei depth,
                                                  GLint border,
                                                  GLsizei imageSize,
                                                  const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "const void *data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3D, context, targetPacked, level, internalformat, width,
                      height, depth, border, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexImage3D(context, targetPacked, level, internalformat, width,
                                         height, depth, border, imageSize, data))
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexImage3DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLint border,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "const void *data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3DOES, context, targetPacked, level, internalformat, width,
                      height, depth, border, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexImage3DOES(context, targetPacked, level, internalformat, width,
                                            height, depth, border, imageSize, data))
        {
            context->compressedTexImage3D(targetPacked, level, internalformat, width, height, depth,
                                          border, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage2DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint xoffset,
                                                     GLint yoffset,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLenum format,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLsizei imageSize = %d, const void "
        "*data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, imageSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage2D, context, targetPacked, level, xoffset, yoffset,
                      width, height, format, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width,
                                            height, format, imageSize, data))
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3DContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint xoffset,
                                                     GLint yoffset,
                                                     GLint zoffset,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLsizei depth,
                                                     GLenum format,
                                                     GLsizei imageSize,
                                                     const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3D, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset,
                                            width, height, depth, format, imageSize, data))
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLint level,
                                                        GLint xoffset,
                                                        GLint yoffset,
                                                        GLint zoffset,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLenum format,
                                                        GLsizei imageSize,
                                                        const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, const void *data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize,
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3DOES, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, imageSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset,
                                               zoffset, width, height, depth, format, imageSize,
                                               data))
        {
            context->compressedTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width,
                                             height, depth, format, imageSize, data);
        }
    }
}

void GL_APIENTRY CopyBufferSubDataContextANGLE(GLeglContext ctx,
                                               GLenum readTarget,
                                               GLenum writeTarget,
                                               GLintptr readOffset,
                                               GLintptr writeOffset,
                                               GLsizeiptr size)
{
    EVENT(
        "(GLenum readTarget = 0x%X, GLenum writeTarget = 0x%X, GLintptr readOffset = %llu, "
        "GLintptr writeOffset = %llu, GLsizeiptr size = %llu)",
        readTarget, writeTarget, static_cast<unsigned long long>(readOffset),
        static_cast<unsigned long long>(writeOffset), static_cast<unsigned long long>(size));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding readTargetPacked  = FromGLenum<BufferBinding>(readTarget);
        BufferBinding writeTargetPacked = FromGLenum<BufferBinding>(writeTarget);
        ANGLE_CAPTURE(CopyBufferSubData, context, readTargetPacked, writeTargetPacked, readOffset,
                      writeOffset, size);
        if (context->skipValidation() ||
            ValidateCopyBufferSubData(context, readTargetPacked, writeTargetPacked, readOffset,
                                      writeOffset, size))
        {
            context->copyBufferSubData(readTargetPacked, writeTargetPacked, readOffset, writeOffset,
                                       size);
        }
    }
}

void GL_APIENTRY CopyTexImage2DContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLint level,
                                            GLenum internalformat,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height,
                                            GLint border)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLint x = %d, "
        "GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLint border = %d)",
        target, level, internalformat, x, y, width, height, border);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexImage2D, context, targetPacked, level, internalformat, x, y, width,
                      height, border);
        if (context->skipValidation() ||
            ValidateCopyTexImage2D(context, targetPacked, level, internalformat, x, y, width,
                                   height, border))
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
    }
}

void GL_APIENTRY CopyTexSubImage2DContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint x,
                                               GLint y,
                                               GLsizei width,
                                               GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint x "
        "= %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, x, y, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage2D, context, targetPacked, level, xoffset, yoffset, x, y,
                      width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage2D(context, targetPacked, level, xoffset, yoffset, x, y, width,
                                      height))
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
    }
}

void GL_APIENTRY CopyTexSubImage3DContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLint level,
                                               GLint xoffset,
                                               GLint yoffset,
                                               GLint zoffset,
                                               GLint x,
                                               GLint y,
                                               GLsizei width,
                                               GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, zoffset, x, y, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, x,
                      y, width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, x, y,
                                      width, height))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
    }
}

void GL_APIENTRY CopyTexSubImage3DOESContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLint level,
                                                  GLint xoffset,
                                                  GLint yoffset,
                                                  GLint zoffset,
                                                  GLint x,
                                                  GLint y,
                                                  GLsizei width,
                                                  GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, zoffset, x, y, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CopyTexSubImage3DOES, context, targetPacked, level, xoffset, yoffset, zoffset,
                      x, y, width, height);
        if (context->skipValidation() ||
            ValidateCopyTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset, x,
                                         y, width, height))
        {
            context->copyTexSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, x, y, width,
                                       height);
        }
    }
}

void GL_APIENTRY CreateMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    GLuint *memoryObjects)
{
    EVENT("(GLsizei n = %d, GLuint *memoryObjects = 0x%016" PRIxPTR ")", n,
          (uintptr_t)memoryObjects);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CreateMemoryObjectsEXT, context, n, memoryObjects);
        if (context->skipValidation() || ValidateCreateMemoryObjectsEXT(context, n, memoryObjects))
        {
            context->createMemoryObjects(n, memoryObjects);
        }
    }
}

GLuint GL_APIENTRY CreateProgramContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CreateProgram, context);
        if (context->skipValidation() || ValidateCreateProgram(context))
        {
            return context->createProgram();
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateProgram, GLuint>();
}

GLuint GL_APIENTRY CreateShaderContextANGLE(GLeglContext ctx, GLenum type)
{
    EVENT("(GLenum type = 0x%X)", type);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked = FromGLenum<ShaderType>(type);
        ANGLE_CAPTURE(CreateShader, context, typePacked);
        if (context->skipValidation() || ValidateCreateShader(context, typePacked))
        {
            return context->createShader(typePacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShader, GLuint>();
}

GLuint GL_APIENTRY CreateShaderProgramvContextANGLE(GLeglContext ctx,
                                                    GLenum type,
                                                    GLsizei count,
                                                    const GLchar *const *strings)
{
    EVENT("(GLenum type = 0x%X, GLsizei count = %d, const GLchar *const*strings = 0x%016" PRIxPTR
          ")",
          type, count, (uintptr_t)strings);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShaderType typePacked = FromGLenum<ShaderType>(type);
        ANGLE_CAPTURE(CreateShaderProgramv, context, typePacked, count, strings);
        if (context->skipValidation() ||
            ValidateCreateShaderProgramv(context, typePacked, count, strings))
        {
            return context->createShaderProgramv(typePacked, count, strings);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
}

void GL_APIENTRY CullFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        CullFaceMode modePacked = FromGLenum<CullFaceMode>(mode);
        ANGLE_CAPTURE(CullFace, context, modePacked);
        if (context->skipValidation() || ValidateCullFace(context, modePacked))
        {
            context->cullFace(modePacked);
        }
    }
}

void GL_APIENTRY CurrentPaletteMatrixOESContextANGLE(GLeglContext ctx, GLuint matrixpaletteindex)
{
    EVENT("(GLuint matrixpaletteindex = %u)", matrixpaletteindex);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CurrentPaletteMatrixOES, context, matrixpaletteindex);
        if (context->skipValidation() ||
            ValidateCurrentPaletteMatrixOES(context, matrixpaletteindex))
        {
            context->currentPaletteMatrix(matrixpaletteindex);
        }
    }
}

void GL_APIENTRY DebugMessageCallbackKHRContextANGLE(GLeglContext ctx,
                                                     GLDEBUGPROCKHR callback,
                                                     const void *userParam)
{
    EVENT("(GLDEBUGPROCKHR callback = 0x%016" PRIxPTR ", const void *userParam = 0x%016" PRIxPTR
          ")",
          (uintptr_t)callback, (uintptr_t)userParam);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DebugMessageCallbackKHR, context, callback, userParam);
        if (context->skipValidation() ||
            ValidateDebugMessageCallbackKHR(context, callback, userParam))
        {
            context->debugMessageCallback(callback, userParam);
        }
    }
}

void GL_APIENTRY DebugMessageControlKHRContextANGLE(GLeglContext ctx,
                                                    GLenum source,
                                                    GLenum type,
                                                    GLenum severity,
                                                    GLsizei count,
                                                    const GLuint *ids,
                                                    GLboolean enabled)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLenum severity = 0x%X, GLsizei count = %d, "
        "const GLuint *ids = 0x%016" PRIxPTR ", GLboolean enabled = %u)",
        source, type, severity, count, (uintptr_t)ids, enabled);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DebugMessageControlKHR, context, source, type, severity, count, ids, enabled);
        if (context->skipValidation() ||
            ValidateDebugMessageControlKHR(context, source, type, severity, count, ids, enabled))
        {
            context->debugMessageControl(source, type, severity, count, ids, enabled);
        }
    }
}

void GL_APIENTRY DebugMessageInsertKHRContextANGLE(GLeglContext ctx,
                                                   GLenum source,
                                                   GLenum type,
                                                   GLuint id,
                                                   GLenum severity,
                                                   GLsizei length,
                                                   const GLchar *buf)
{
    EVENT(
        "(GLenum source = 0x%X, GLenum type = 0x%X, GLuint id = %u, GLenum severity = 0x%X, "
        "GLsizei length = %d, const GLchar *buf = 0x%016" PRIxPTR ")",
        source, type, id, severity, length, (uintptr_t)buf);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DebugMessageInsertKHR, context, source, type, id, severity, length, buf);
        if (context->skipValidation() ||
            ValidateDebugMessageInsertKHR(context, source, type, id, severity, length, buf))
        {
            context->debugMessageInsert(source, type, id, severity, length, buf);
        }
    }
}

void GL_APIENTRY DeleteBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *buffers)
{
    EVENT("(GLsizei n = %d, const GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteBuffers, context, n, buffers);
        if (context->skipValidation() || ValidateDeleteBuffers(context, n, buffers))
        {
            context->deleteBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY DeleteFencesNVContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *fences)
{
    EVENT("(GLsizei n = %d, const GLuint *fences = 0x%016" PRIxPTR ")", n, (uintptr_t)fences);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteFencesNV, context, n, fences);
        if (context->skipValidation() || ValidateDeleteFencesNV(context, n, fences))
        {
            context->deleteFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY DeleteFramebuffersContextANGLE(GLeglContext ctx,
                                                GLsizei n,
                                                const GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)framebuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteFramebuffers, context, n, framebuffers);
        if (context->skipValidation() || ValidateDeleteFramebuffers(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteFramebuffersOESContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *framebuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)framebuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteFramebuffersOES, context, n, framebuffers);
        if (context->skipValidation() || ValidateDeleteFramebuffersOES(context, n, framebuffers))
        {
            context->deleteFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY DeleteMemoryObjectsEXTContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *memoryObjects)
{
    EVENT("(GLsizei n = %d, const GLuint *memoryObjects = 0x%016" PRIxPTR ")", n,
          (uintptr_t)memoryObjects);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteMemoryObjectsEXT, context, n, memoryObjects);
        if (context->skipValidation() || ValidateDeleteMemoryObjectsEXT(context, n, memoryObjects))
        {
            context->deleteMemoryObjects(n, memoryObjects);
        }
    }
}

void GL_APIENTRY DeleteProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteProgram, context, program);
        if (context->skipValidation() || ValidateDeleteProgram(context, program))
        {
            context->deleteProgram(program);
        }
    }
}

void GL_APIENTRY DeleteProgramPipelinesContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *pipelines)
{
    EVENT("(GLsizei n = %d, const GLuint *pipelines = 0x%016" PRIxPTR ")", n, (uintptr_t)pipelines);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteProgramPipelines, context, n, pipelines);
        if (context->skipValidation() || ValidateDeleteProgramPipelines(context, n, pipelines))
        {
            context->deleteProgramPipelines(n, pipelines);
        }
    }
}

void GL_APIENTRY DeleteQueriesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteQueries, context, n, ids);
        if (context->skipValidation() || ValidateDeleteQueries(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY DeleteQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteQueriesEXT, context, n, ids);
        if (context->skipValidation() || ValidateDeleteQueriesEXT(context, n, ids))
        {
            context->deleteQueries(n, ids);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffersContextANGLE(GLeglContext ctx,
                                                 GLsizei n,
                                                 const GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteRenderbuffers, context, n, renderbuffers);
        if (context->skipValidation() || ValidateDeleteRenderbuffers(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY DeleteRenderbuffersOESContextANGLE(GLeglContext ctx,
                                                    GLsizei n,
                                                    const GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, const GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteRenderbuffersOES, context, n, renderbuffers);
        if (context->skipValidation() || ValidateDeleteRenderbuffersOES(context, n, renderbuffers))
        {
            context->deleteRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY DeleteSamplersContextANGLE(GLeglContext ctx, GLsizei count, const GLuint *samplers)
{
    EVENT("(GLsizei count = %d, const GLuint *samplers = 0x%016" PRIxPTR ")", count,
          (uintptr_t)samplers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteSamplers, context, count, samplers);
        if (context->skipValidation() || ValidateDeleteSamplers(context, count, samplers))
        {
            context->deleteSamplers(count, samplers);
        }
    }
}

void GL_APIENTRY DeleteSemaphoresEXTContextANGLE(GLeglContext ctx,
                                                 GLsizei n,
                                                 const GLuint *semaphores)
{
    EVENT("(GLsizei n = %d, const GLuint *semaphores = 0x%016" PRIxPTR ")", n,
          (uintptr_t)semaphores);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteSemaphoresEXT, context, n, semaphores);
        if (context->skipValidation() || ValidateDeleteSemaphoresEXT(context, n, semaphores))
        {
            context->deleteSemaphores(n, semaphores);
        }
    }
}

void GL_APIENTRY DeleteShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteShader, context, shader);
        if (context->skipValidation() || ValidateDeleteShader(context, shader))
        {
            context->deleteShader(shader);
        }
    }
}

void GL_APIENTRY DeleteSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ")", (uintptr_t)sync);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteSync, context, sync);
        if (context->skipValidation() || ValidateDeleteSync(context, sync))
        {
            context->deleteSync(sync);
        }
    }
}

void GL_APIENTRY DeleteTexturesContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *textures)
{
    EVENT("(GLsizei n = %d, const GLuint *textures = 0x%016" PRIxPTR ")", n, (uintptr_t)textures);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteTextures, context, n, textures);
        if (context->skipValidation() || ValidateDeleteTextures(context, n, textures))
        {
            context->deleteTextures(n, textures);
        }
    }
}

void GL_APIENTRY DeleteTransformFeedbacksContextANGLE(GLeglContext ctx,
                                                      GLsizei n,
                                                      const GLuint *ids)
{
    EVENT("(GLsizei n = %d, const GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteTransformFeedbacks, context, n, ids);
        if (context->skipValidation() || ValidateDeleteTransformFeedbacks(context, n, ids))
        {
            context->deleteTransformFeedbacks(n, ids);
        }
    }
}

void GL_APIENTRY DeleteVertexArraysContextANGLE(GLeglContext ctx, GLsizei n, const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateDeleteVertexArrays(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY DeleteVertexArraysOESContextANGLE(GLeglContext ctx,
                                                   GLsizei n,
                                                   const GLuint *arrays)
{
    EVENT("(GLsizei n = %d, const GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeleteVertexArraysOES, context, n, arrays);
        if (context->skipValidation() || ValidateDeleteVertexArraysOES(context, n, arrays))
        {
            context->deleteVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY DepthFuncContextANGLE(GLeglContext ctx, GLenum func)
{
    EVENT("(GLenum func = 0x%X)", func);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DepthFunc, context, func);
        if (context->skipValidation() || ValidateDepthFunc(context, func))
        {
            context->depthFunc(func);
        }
    }
}

void GL_APIENTRY DepthMaskContextANGLE(GLeglContext ctx, GLboolean flag)
{
    EVENT("(GLboolean flag = %u)", flag);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DepthMask, context, flag);
        if (context->skipValidation() || ValidateDepthMask(context, flag))
        {
            context->depthMask(flag);
        }
    }
}

void GL_APIENTRY DepthRangefContextANGLE(GLeglContext ctx, GLfloat n, GLfloat f)
{
    EVENT("(GLfloat n = %f, GLfloat f = %f)", n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DepthRangef, context, n, f);
        if (context->skipValidation() || ValidateDepthRangef(context, n, f))
        {
            context->depthRangef(n, f);
        }
    }
}

void GL_APIENTRY DepthRangexContextANGLE(GLeglContext ctx, GLfixed n, GLfixed f)
{
    EVENT("(GLfixed n = 0x%X, GLfixed f = 0x%X)", n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DepthRangex, context, n, f);
        if (context->skipValidation() || ValidateDepthRangex(context, n, f))
        {
            context->depthRangex(n, f);
        }
    }
}

void GL_APIENTRY DetachShaderContextANGLE(GLeglContext ctx, GLuint program, GLuint shader)
{
    EVENT("(GLuint program = %u, GLuint shader = %u)", program, shader);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DetachShader, context, program, shader);
        if (context->skipValidation() || ValidateDetachShader(context, program, shader))
        {
            context->detachShader(program, shader);
        }
    }
}

void GL_APIENTRY DisableContextANGLE(GLeglContext ctx, GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Disable, context, cap);
        if (context->skipValidation() || ValidateDisable(context, cap))
        {
            context->disable(cap);
        }
    }
}

void GL_APIENTRY DisableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked = FromGLenum<ClientVertexArrayType>(array);
        ANGLE_CAPTURE(DisableClientState, context, arrayPacked);
        if (context->skipValidation() || ValidateDisableClientState(context, arrayPacked))
        {
            context->disableClientState(arrayPacked);
        }
    }
}

void GL_APIENTRY DisableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DisableVertexAttribArray, context, index);
        if (context->skipValidation() || ValidateDisableVertexAttribArray(context, index))
        {
            context->disableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY DiscardFramebufferEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ")",
        target, numAttachments, (uintptr_t)attachments);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DiscardFramebufferEXT, context, target, numAttachments, attachments);
        if (context->skipValidation() ||
            ValidateDiscardFramebufferEXT(context, target, numAttachments, attachments))
        {
            context->discardFramebuffer(target, numAttachments, attachments);
        }
    }
}

void GL_APIENTRY DispatchComputeContextANGLE(GLeglContext ctx,
                                             GLuint num_groups_x,
                                             GLuint num_groups_y,
                                             GLuint num_groups_z)
{
    EVENT("(GLuint num_groups_x = %u, GLuint num_groups_y = %u, GLuint num_groups_z = %u)",
          num_groups_x, num_groups_y, num_groups_z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DispatchCompute, context, num_groups_x, num_groups_y, num_groups_z);
        if (context->skipValidation() ||
            ValidateDispatchCompute(context, num_groups_x, num_groups_y, num_groups_z))
        {
            context->dispatchCompute(num_groups_x, num_groups_y, num_groups_z);
        }
    }
}

void GL_APIENTRY DispatchComputeIndirectContextANGLE(GLeglContext ctx, GLintptr indirect)
{
    EVENT("(GLintptr indirect = %llu)", static_cast<unsigned long long>(indirect));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DispatchComputeIndirect, context, indirect);
        if (context->skipValidation() || ValidateDispatchComputeIndirect(context, indirect))
        {
            context->dispatchComputeIndirect(indirect);
        }
    }
}

void GL_APIENTRY DrawArraysContextANGLE(GLeglContext ctx, GLenum mode, GLint first, GLsizei count)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d)", mode, first, count);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArrays, context, modePacked, first, count);
        if (context->skipValidation() || ValidateDrawArrays(context, modePacked, first, count))
        {
            context->drawArrays(modePacked, first, count);
        }
    }
}

void GL_APIENTRY DrawArraysIndirectContextANGLE(GLeglContext ctx, GLenum mode, const void *indirect)
{
    EVENT("(GLenum mode = 0x%X, const void *indirect = 0x%016" PRIxPTR ")", mode,
          (uintptr_t)indirect);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysIndirect, context, modePacked, indirect);
        if (context->skipValidation() || ValidateDrawArraysIndirect(context, modePacked, indirect))
        {
            context->drawArraysIndirect(modePacked, indirect);
        }
    }
}

void GL_APIENTRY DrawArraysInstancedContextANGLE(GLeglContext ctx,
                                                 GLenum mode,
                                                 GLint first,
                                                 GLsizei count,
                                                 GLsizei instancecount)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d, GLsizei instancecount = %d)",
          mode, first, count, instancecount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstanced, context, modePacked, first, count, instancecount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstanced(context, modePacked, first, count, instancecount))
        {
            context->drawArraysInstanced(modePacked, first, count, instancecount);
        }
    }
}

void GL_APIENTRY DrawArraysInstancedANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum mode,
                                                      GLint first,
                                                      GLsizei count,
                                                      GLsizei primcount)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d, GLsizei primcount = %d)",
          mode, first, count, primcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstancedANGLE, context, modePacked, first, count, primcount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstancedANGLE(context, modePacked, first, count, primcount))
        {
            context->drawArraysInstanced(modePacked, first, count, primcount);
        }
    }
}

void GL_APIENTRY DrawArraysInstancedEXTContextANGLE(GLeglContext ctx,
                                                    GLenum mode,
                                                    GLint start,
                                                    GLsizei count,
                                                    GLsizei primcount)
{
    EVENT("(GLenum mode = 0x%X, GLint start = %d, GLsizei count = %d, GLsizei primcount = %d)",
          mode, start, count, primcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(DrawArraysInstancedEXT, context, modePacked, start, count, primcount);
        if (context->skipValidation() ||
            ValidateDrawArraysInstancedEXT(context, modePacked, start, count, primcount))
        {
            context->drawArraysInstanced(modePacked, start, count, primcount);
        }
    }
}

void GL_APIENTRY DrawBuffersContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR ")", n, (uintptr_t)bufs);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawBuffers, context, n, bufs);
        if (context->skipValidation() || ValidateDrawBuffers(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

void GL_APIENTRY DrawBuffersEXTContextANGLE(GLeglContext ctx, GLsizei n, const GLenum *bufs)
{
    EVENT("(GLsizei n = %d, const GLenum *bufs = 0x%016" PRIxPTR ")", n, (uintptr_t)bufs);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawBuffersEXT, context, n, bufs);
        if (context->skipValidation() || ValidateDrawBuffersEXT(context, n, bufs))
        {
            context->drawBuffers(n, bufs);
        }
    }
}

void GL_APIENTRY DrawElementsContextANGLE(GLeglContext ctx,
                                          GLenum mode,
                                          GLsizei count,
                                          GLenum type,
                                          const void *indices)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ")",
        mode, count, type, (uintptr_t)indices);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElements, context, modePacked, count, typePacked, indices);
        if (context->skipValidation() ||
            ValidateDrawElements(context, modePacked, count, typePacked, indices))
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
    }
}

void GL_APIENTRY DrawElementsIndirectContextANGLE(GLeglContext ctx,
                                                  GLenum mode,
                                                  GLenum type,
                                                  const void *indirect)
{
    EVENT("(GLenum mode = 0x%X, GLenum type = 0x%X, const void *indirect = 0x%016" PRIxPTR ")",
          mode, type, (uintptr_t)indirect);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsIndirect, context, modePacked, typePacked, indirect);
        if (context->skipValidation() ||
            ValidateDrawElementsIndirect(context, modePacked, typePacked, indirect))
        {
            context->drawElementsIndirect(modePacked, typePacked, indirect);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedContextANGLE(GLeglContext ctx,
                                                   GLenum mode,
                                                   GLsizei count,
                                                   GLenum type,
                                                   const void *indices,
                                                   GLsizei instancecount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei instancecount = %d)",
        mode, count, type, (uintptr_t)indices, instancecount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstanced, context, modePacked, count, typePacked, indices,
                      instancecount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstanced(context, modePacked, count, typePacked, indices,
                                          instancecount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, instancecount);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedANGLEContextANGLE(GLeglContext ctx,
                                                        GLenum mode,
                                                        GLsizei count,
                                                        GLenum type,
                                                        const void *indices,
                                                        GLsizei primcount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei primcount = %d)",
        mode, count, type, (uintptr_t)indices, primcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstancedANGLE, context, modePacked, count, typePacked, indices,
                      primcount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstancedANGLE(context, modePacked, count, typePacked, indices,
                                               primcount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
    }
}

void GL_APIENTRY DrawElementsInstancedEXTContextANGLE(GLeglContext ctx,
                                                      GLenum mode,
                                                      GLsizei count,
                                                      GLenum type,
                                                      const void *indices,
                                                      GLsizei primcount)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%016" PRIxPTR ", GLsizei primcount = %d)",
        mode, count, type, (uintptr_t)indices, primcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawElementsInstancedEXT, context, modePacked, count, typePacked, indices,
                      primcount);
        if (context->skipValidation() ||
            ValidateDrawElementsInstancedEXT(context, modePacked, count, typePacked, indices,
                                             primcount))
        {
            context->drawElementsInstanced(modePacked, count, typePacked, indices, primcount);
        }
    }
}

void GL_APIENTRY DrawRangeElementsContextANGLE(GLeglContext ctx,
                                               GLenum mode,
                                               GLuint start,
                                               GLuint end,
                                               GLsizei count,
                                               GLenum type,
                                               const void *indices)
{
    EVENT(
        "(GLenum mode = 0x%X, GLuint start = %u, GLuint end = %u, GLsizei count = %d, GLenum type "
        "= 0x%X, const void *indices = 0x%016" PRIxPTR ")",
        mode, start, end, count, type, (uintptr_t)indices);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(DrawRangeElements, context, modePacked, start, end, count, typePacked,
                      indices);
        if (context->skipValidation() ||
            ValidateDrawRangeElements(context, modePacked, start, end, count, typePacked, indices))
        {
            context->drawRangeElements(modePacked, start, end, count, typePacked, indices);
        }
    }
}

void GL_APIENTRY DrawTexfOESContextANGLE(GLeglContext ctx,
                                         GLfloat x,
                                         GLfloat y,
                                         GLfloat z,
                                         GLfloat width,
                                         GLfloat height)
{
    EVENT(
        "(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat width = %f, GLfloat height = %f)",
        x, y, z, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexfOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexfOES(context, x, y, z, width, height))
        {
            context->drawTexf(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexfvOESContextANGLE(GLeglContext ctx, const GLfloat *coords)
{
    EVENT("(const GLfloat *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexfvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexfvOES(context, coords))
        {
            context->drawTexfv(coords);
        }
    }
}

void GL_APIENTRY
DrawTexiOESContextANGLE(GLeglContext ctx, GLint x, GLint y, GLint z, GLint width, GLint height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height = %d)", x, y,
          z, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexiOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexiOES(context, x, y, z, width, height))
        {
            context->drawTexi(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexivOESContextANGLE(GLeglContext ctx, const GLint *coords)
{
    EVENT("(const GLint *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexivOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexivOES(context, coords))
        {
            context->drawTexiv(coords);
        }
    }
}

void GL_APIENTRY DrawTexsOESContextANGLE(GLeglContext ctx,
                                         GLshort x,
                                         GLshort y,
                                         GLshort z,
                                         GLshort width,
                                         GLshort height)
{
    EVENT(
        "(GLshort x = %d, GLshort y = %d, GLshort z = %d, GLshort width = %d, GLshort height = %d)",
        x, y, z, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexsOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexsOES(context, x, y, z, width, height))
        {
            context->drawTexs(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexsvOESContextANGLE(GLeglContext ctx, const GLshort *coords)
{
    EVENT("(const GLshort *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexsvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexsvOES(context, coords))
        {
            context->drawTexsv(coords);
        }
    }
}

void GL_APIENTRY DrawTexxOESContextANGLE(GLeglContext ctx,
                                         GLfixed x,
                                         GLfixed y,
                                         GLfixed z,
                                         GLfixed width,
                                         GLfixed height)
{
    EVENT(
        "(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X, GLfixed width = 0x%X, GLfixed "
        "height = 0x%X)",
        x, y, z, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexxOES, context, x, y, z, width, height);
        if (context->skipValidation() || ValidateDrawTexxOES(context, x, y, z, width, height))
        {
            context->drawTexx(x, y, z, width, height);
        }
    }
}

void GL_APIENTRY DrawTexxvOESContextANGLE(GLeglContext ctx, const GLfixed *coords)
{
    EVENT("(const GLfixed *coords = 0x%016" PRIxPTR ")", (uintptr_t)coords);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DrawTexxvOES, context, coords);
        if (context->skipValidation() || ValidateDrawTexxvOES(context, coords))
        {
            context->drawTexxv(coords);
        }
    }
}

void GL_APIENTRY EGLImageTargetRenderbufferStorageOESContextANGLE(GLeglContext ctx,
                                                                  GLenum target,
                                                                  GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%016" PRIxPTR ")", target,
          (uintptr_t)image);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(EGLImageTargetRenderbufferStorageOES, context, target, image);
        if (context->skipValidation() ||
            ValidateEGLImageTargetRenderbufferStorageOES(context, target, image))
        {
            context->eGLImageTargetRenderbufferStorage(target, image);
        }
    }
}

void GL_APIENTRY EGLImageTargetTexture2DOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLeglImageOES image)
{
    EVENT("(GLenum target = 0x%X, GLeglImageOES image = 0x%016" PRIxPTR ")", target,
          (uintptr_t)image);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(EGLImageTargetTexture2DOES, context, targetPacked, image);
        if (context->skipValidation() ||
            ValidateEGLImageTargetTexture2DOES(context, targetPacked, image))
        {
            context->eGLImageTargetTexture2D(targetPacked, image);
        }
    }
}

void GL_APIENTRY EnableContextANGLE(GLeglContext ctx, GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Enable, context, cap);
        if (context->skipValidation() || ValidateEnable(context, cap))
        {
            context->enable(cap);
        }
    }
}

void GL_APIENTRY EnableClientStateContextANGLE(GLeglContext ctx, GLenum array)
{
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ClientVertexArrayType arrayPacked = FromGLenum<ClientVertexArrayType>(array);
        ANGLE_CAPTURE(EnableClientState, context, arrayPacked);
        if (context->skipValidation() || ValidateEnableClientState(context, arrayPacked))
        {
            context->enableClientState(arrayPacked);
        }
    }
}

void GL_APIENTRY EnableVertexAttribArrayContextANGLE(GLeglContext ctx, GLuint index)
{
    EVENT("(GLuint index = %u)", index);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(EnableVertexAttribArray, context, index);
        if (context->skipValidation() || ValidateEnableVertexAttribArray(context, index))
        {
            context->enableVertexAttribArray(index);
        }
    }
}

void GL_APIENTRY EndQueryContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(EndQuery, context, targetPacked);
        if (context->skipValidation() || ValidateEndQuery(context, targetPacked))
        {
            context->endQuery(targetPacked);
        }
    }
}

void GL_APIENTRY EndQueryEXTContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(EndQueryEXT, context, targetPacked);
        if (context->skipValidation() || ValidateEndQueryEXT(context, targetPacked))
        {
            context->endQuery(targetPacked);
        }
    }
}

void GL_APIENTRY EndTransformFeedbackContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(EndTransformFeedback, context);
        if (context->skipValidation() || ValidateEndTransformFeedback(context))
        {
            context->endTransformFeedback();
        }
    }
}

GLsync GL_APIENTRY FenceSyncContextANGLE(GLeglContext ctx, GLenum condition, GLbitfield flags)
{
    EVENT("(GLenum condition = 0x%X, GLbitfield flags = 0x%X)", condition, flags);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FenceSync, context, condition, flags);
        if (context->skipValidation() || ValidateFenceSync(context, condition, flags))
        {
            return context->fenceSync(condition, flags);
        }
    }

    return GetDefaultReturnValue<EntryPoint::FenceSync, GLsync>();
}

void GL_APIENTRY FinishContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Finish, context);
        if (context->skipValidation() || ValidateFinish(context))
        {
            context->finish();
        }
    }
}

void GL_APIENTRY FinishFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FinishFenceNV, context, fence);
        if (context->skipValidation() || ValidateFinishFenceNV(context, fence))
        {
            context->finishFenceNV(fence);
        }
    }
}

void GL_APIENTRY FlushContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Flush, context);
        if (context->skipValidation() || ValidateFlush(context))
        {
            context->flush();
        }
    }
}

void GL_APIENTRY FlushMappedBufferRangeContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLintptr offset,
                                                    GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu)", target,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(FlushMappedBufferRange, context, targetPacked, offset, length);
        if (context->skipValidation() ||
            ValidateFlushMappedBufferRange(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void GL_APIENTRY FlushMappedBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLintptr offset,
                                                       GLsizeiptr length)
{
    EVENT("(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu)", target,
          static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(FlushMappedBufferRangeEXT, context, targetPacked, offset, length);
        if (context->skipValidation() ||
            ValidateFlushMappedBufferRangeEXT(context, targetPacked, offset, length))
        {
            context->flushMappedBufferRange(targetPacked, offset, length);
        }
    }
}

void GL_APIENTRY FogfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Fogf, context, pname, param);
        if (context->skipValidation() || ValidateFogf(context, pname, param))
        {
            context->fogf(pname, param);
        }
    }
}

void GL_APIENTRY FogfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Fogfv, context, pname, params);
        if (context->skipValidation() || ValidateFogfv(context, pname, params))
        {
            context->fogfv(pname, params);
        }
    }
}

void GL_APIENTRY FogxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Fogx, context, pname, param);
        if (context->skipValidation() || ValidateFogx(context, pname, param))
        {
            context->fogx(pname, param);
        }
    }
}

void GL_APIENTRY FogxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Fogxv, context, pname, param);
        if (context->skipValidation() || ValidateFogxv(context, pname, param))
        {
            context->fogxv(pname, param);
        }
    }
}

void GL_APIENTRY FramebufferParameteriContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferParameteri, context, target, pname, param);
        if (context->skipValidation() ||
            ValidateFramebufferParameteri(context, target, pname, param))
        {
            context->framebufferParameteri(target, pname, param);
        }
    }
}

void GL_APIENTRY FramebufferRenderbufferContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum renderbuffertarget,
                                                     GLuint renderbuffer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferRenderbuffer, context, target, attachment, renderbuffertarget,
                      renderbuffer);
        if (context->skipValidation() ||
            ValidateFramebufferRenderbuffer(context, target, attachment, renderbuffertarget,
                                            renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferRenderbufferOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum attachment,
                                                        GLenum renderbuffertarget,
                                                        GLuint renderbuffer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum renderbuffertarget = 0x%X, GLuint "
        "renderbuffer = %u)",
        target, attachment, renderbuffertarget, renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferRenderbufferOES, context, target, attachment, renderbuffertarget,
                      renderbuffer);
        if (context->skipValidation() ||
            ValidateFramebufferRenderbufferOES(context, target, attachment, renderbuffertarget,
                                               renderbuffer))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
        }
    }
}

void GL_APIENTRY FramebufferTexture2DContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  GLenum textarget,
                                                  GLuint texture,
                                                  GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture2D, context, target, attachment, textargetPacked, texture,
                      level);
        if (context->skipValidation() ||
            ValidateFramebufferTexture2D(context, target, attachment, textargetPacked, texture,
                                         level))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texture, level);
        }
    }
}

void GL_APIENTRY FramebufferTexture2DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum textarget,
                                                     GLuint texture,
                                                     GLint level)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d)",
        target, attachment, textarget, texture, level);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture2DOES, context, target, attachment, textargetPacked,
                      texture, level);
        if (context->skipValidation() ||
            ValidateFramebufferTexture2DOES(context, target, attachment, textargetPacked, texture,
                                            level))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texture, level);
        }
    }
}

void GL_APIENTRY FramebufferTexture3DOESContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLenum textarget,
                                                     GLuint texture,
                                                     GLint level,
                                                     GLint zoffset)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum textarget = 0x%X, GLuint texture "
        "= %u, GLint level = %d, GLint zoffset = %d)",
        target, attachment, textarget, texture, level, zoffset);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget textargetPacked = FromGLenum<TextureTarget>(textarget);
        ANGLE_CAPTURE(FramebufferTexture3DOES, context, target, attachment, textargetPacked,
                      texture, level, zoffset);
        if (context->skipValidation() ||
            ValidateFramebufferTexture3DOES(context, target, attachment, textargetPacked, texture,
                                            level, zoffset))
        {
            context->framebufferTexture3D(target, attachment, textargetPacked, texture, level,
                                          zoffset);
        }
    }
}

void GL_APIENTRY FramebufferTextureEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum attachment,
                                                   GLuint texture,
                                                   GLint level)
{
    EVENT("(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d)",
          target, attachment, texture, level);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferTextureEXT, context, target, attachment, texture, level);
        if (context->skipValidation() ||
            ValidateFramebufferTextureEXT(context, target, attachment, texture, level))
        {
            context->framebufferTexture(target, attachment, texture, level);
        }
    }
}

void GL_APIENTRY FramebufferTextureLayerContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLenum attachment,
                                                     GLuint texture,
                                                     GLint level,
                                                     GLint layer)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d, "
        "GLint layer = %d)",
        target, attachment, texture, level, layer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferTextureLayer, context, target, attachment, texture, level, layer);
        if (context->skipValidation() ||
            ValidateFramebufferTextureLayer(context, target, attachment, texture, level, layer))
        {
            context->framebufferTextureLayer(target, attachment, texture, level, layer);
        }
    }
}

void GL_APIENTRY FramebufferTextureMultiviewOVRContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLenum attachment,
                                                            GLuint texture,
                                                            GLint level,
                                                            GLint baseViewIndex,
                                                            GLsizei numViews)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLuint texture = %u, GLint level = %d, "
        "GLint baseViewIndex = %d, GLsizei numViews = %d)",
        target, attachment, texture, level, baseViewIndex, numViews);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FramebufferTextureMultiviewOVR, context, target, attachment, texture, level,
                      baseViewIndex, numViews);
        if (context->skipValidation() ||
            ValidateFramebufferTextureMultiviewOVR(context, target, attachment, texture, level,
                                                   baseViewIndex, numViews))
        {
            context->framebufferTextureMultiview(target, attachment, texture, level, baseViewIndex,
                                                 numViews);
        }
    }
}

void GL_APIENTRY FrontFaceContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(FrontFace, context, mode);
        if (context->skipValidation() || ValidateFrontFace(context, mode))
        {
            context->frontFace(mode);
        }
    }
}

void GL_APIENTRY FrustumfContextANGLE(GLeglContext ctx,
                                      GLfloat l,
                                      GLfloat r,
                                      GLfloat b,
                                      GLfloat t,
                                      GLfloat n,
                                      GLfloat f)
{
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Frustumf, context, l, r, b, t, n, f);
        if (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f))
        {
            context->frustumf(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY FrustumxContextANGLE(GLeglContext ctx,
                                      GLfixed l,
                                      GLfixed r,
                                      GLfixed b,
                                      GLfixed t,
                                      GLfixed n,
                                      GLfixed f)
{
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Frustumx, context, l, r, b, t, n, f);
        if (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f))
        {
            context->frustumx(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY GenBuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *buffers)
{
    EVENT("(GLsizei n = %d, GLuint *buffers = 0x%016" PRIxPTR ")", n, (uintptr_t)buffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenBuffers, context, n, buffers);
        if (context->skipValidation() || ValidateGenBuffers(context, n, buffers))
        {
            context->genBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY GenFencesNVContextANGLE(GLeglContext ctx, GLsizei n, GLuint *fences)
{
    EVENT("(GLsizei n = %d, GLuint *fences = 0x%016" PRIxPTR ")", n, (uintptr_t)fences);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenFencesNV, context, n, fences);
        if (context->skipValidation() || ValidateGenFencesNV(context, n, fences))
        {
            context->genFencesNV(n, fences);
        }
    }
}

void GL_APIENTRY GenFramebuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR ")", n, (uintptr_t)framebuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenFramebuffers, context, n, framebuffers);
        if (context->skipValidation() || ValidateGenFramebuffers(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenFramebuffersOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *framebuffers)
{
    EVENT("(GLsizei n = %d, GLuint *framebuffers = 0x%016" PRIxPTR ")", n, (uintptr_t)framebuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenFramebuffersOES, context, n, framebuffers);
        if (context->skipValidation() || ValidateGenFramebuffersOES(context, n, framebuffers))
        {
            context->genFramebuffers(n, framebuffers);
        }
    }
}

void GL_APIENTRY GenProgramPipelinesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *pipelines)
{
    EVENT("(GLsizei n = %d, GLuint *pipelines = 0x%016" PRIxPTR ")", n, (uintptr_t)pipelines);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenProgramPipelines, context, n, pipelines);
        if (context->skipValidation() || ValidateGenProgramPipelines(context, n, pipelines))
        {
            context->genProgramPipelines(n, pipelines);
        }
    }
}

void GL_APIENTRY GenQueriesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenQueries, context, n, ids);
        if (context->skipValidation() || ValidateGenQueries(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GenQueriesEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenQueriesEXT, context, n, ids);
        if (context->skipValidation() || ValidateGenQueriesEXT(context, n, ids))
        {
            context->genQueries(n, ids);
        }
    }
}

void GL_APIENTRY GenRenderbuffersContextANGLE(GLeglContext ctx, GLsizei n, GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenRenderbuffers, context, n, renderbuffers);
        if (context->skipValidation() || ValidateGenRenderbuffers(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenRenderbuffersOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *renderbuffers)
{
    EVENT("(GLsizei n = %d, GLuint *renderbuffers = 0x%016" PRIxPTR ")", n,
          (uintptr_t)renderbuffers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenRenderbuffersOES, context, n, renderbuffers);
        if (context->skipValidation() || ValidateGenRenderbuffersOES(context, n, renderbuffers))
        {
            context->genRenderbuffers(n, renderbuffers);
        }
    }
}

void GL_APIENTRY GenSamplersContextANGLE(GLeglContext ctx, GLsizei count, GLuint *samplers)
{
    EVENT("(GLsizei count = %d, GLuint *samplers = 0x%016" PRIxPTR ")", count, (uintptr_t)samplers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenSamplers, context, count, samplers);
        if (context->skipValidation() || ValidateGenSamplers(context, count, samplers))
        {
            context->genSamplers(count, samplers);
        }
    }
}

void GL_APIENTRY GenSemaphoresEXTContextANGLE(GLeglContext ctx, GLsizei n, GLuint *semaphores)
{
    EVENT("(GLsizei n = %d, GLuint *semaphores = 0x%016" PRIxPTR ")", n, (uintptr_t)semaphores);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenSemaphoresEXT, context, n, semaphores);
        if (context->skipValidation() || ValidateGenSemaphoresEXT(context, n, semaphores))
        {
            context->genSemaphores(n, semaphores);
        }
    }
}

void GL_APIENTRY GenTexturesContextANGLE(GLeglContext ctx, GLsizei n, GLuint *textures)
{
    EVENT("(GLsizei n = %d, GLuint *textures = 0x%016" PRIxPTR ")", n, (uintptr_t)textures);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenTextures, context, n, textures);
        if (context->skipValidation() || ValidateGenTextures(context, n, textures))
        {
            context->genTextures(n, textures);
        }
    }
}

void GL_APIENTRY GenTransformFeedbacksContextANGLE(GLeglContext ctx, GLsizei n, GLuint *ids)
{
    EVENT("(GLsizei n = %d, GLuint *ids = 0x%016" PRIxPTR ")", n, (uintptr_t)ids);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenTransformFeedbacks, context, n, ids);
        if (context->skipValidation() || ValidateGenTransformFeedbacks(context, n, ids))
        {
            context->genTransformFeedbacks(n, ids);
        }
    }
}

void GL_APIENTRY GenVertexArraysContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenVertexArrays, context, n, arrays);
        if (context->skipValidation() || ValidateGenVertexArrays(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GenVertexArraysOESContextANGLE(GLeglContext ctx, GLsizei n, GLuint *arrays)
{
    EVENT("(GLsizei n = %d, GLuint *arrays = 0x%016" PRIxPTR ")", n, (uintptr_t)arrays);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenVertexArraysOES, context, n, arrays);
        if (context->skipValidation() || ValidateGenVertexArraysOES(context, n, arrays))
        {
            context->genVertexArrays(n, arrays);
        }
    }
}

void GL_APIENTRY GenerateMipmapContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GenerateMipmap, context, targetPacked);
        if (context->skipValidation() || ValidateGenerateMipmap(context, targetPacked))
        {
            context->generateMipmap(targetPacked);
        }
    }
}

void GL_APIENTRY GenerateMipmapOESContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GenerateMipmapOES, context, targetPacked);
        if (context->skipValidation() || ValidateGenerateMipmapOES(context, targetPacked))
        {
            context->generateMipmap(targetPacked);
        }
    }
}

void GL_APIENTRY GetActiveAttribContextANGLE(GLeglContext ctx,
                                             GLuint program,
                                             GLuint index,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLint *size,
                                             GLenum *type,
                                             GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveAttrib, context, program, index, bufSize, length, size, type, name);
        if (context->skipValidation() ||
            ValidateGetActiveAttrib(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveAttrib(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetActiveUniformContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint *size,
                                              GLenum *type,
                                              GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLint *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveUniform, context, program, index, bufSize, length, size, type, name);
        if (context->skipValidation() ||
            ValidateGetActiveUniform(context, program, index, bufSize, length, size, type, name))
        {
            context->getActiveUniform(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockNameContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLuint uniformBlockIndex,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLchar *uniformBlockName)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLsizei bufSize = %d, GLsizei "
        "*length = 0x%016" PRIxPTR ", GLchar *uniformBlockName = 0x%016" PRIxPTR ")",
        program, uniformBlockIndex, bufSize, (uintptr_t)length, (uintptr_t)uniformBlockName);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveUniformBlockName, context, program, uniformBlockIndex, bufSize,
                      length, uniformBlockName);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockName(context, program, uniformBlockIndex, bufSize, length,
                                              uniformBlockName))
        {
            context->getActiveUniformBlockName(program, uniformBlockIndex, bufSize, length,
                                               uniformBlockName);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockivContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLuint uniformBlockIndex,
                                                     GLenum pname,
                                                     GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        program, uniformBlockIndex, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveUniformBlockiv, context, program, uniformBlockIndex, pname, params);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockiv(context, program, uniformBlockIndex, pname, params))
        {
            context->getActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
        }
    }
}

void GL_APIENTRY GetActiveUniformsivContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLsizei uniformCount,
                                                 const GLuint *uniformIndices,
                                                 GLenum pname,
                                                 GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLsizei uniformCount = %d, const GLuint *uniformIndices = "
        "0x%016" PRIxPTR ", GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")",
        program, uniformCount, (uintptr_t)uniformIndices, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveUniformsiv, context, program, uniformCount, uniformIndices, pname,
                      params);
        if (context->skipValidation() || ValidateGetActiveUniformsiv(context, program, uniformCount,
                                                                     uniformIndices, pname, params))
        {
            context->getActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
        }
    }
}

void GL_APIENTRY GetAttachedShadersContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLsizei maxCount,
                                                GLsizei *count,
                                                GLuint *shaders)
{
    EVENT("(GLuint program = %u, GLsizei maxCount = %d, GLsizei *count = 0x%016" PRIxPTR
          ", GLuint *shaders = 0x%016" PRIxPTR ")",
          program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetAttachedShaders, context, program, maxCount, count, shaders);
        if (context->skipValidation() ||
            ValidateGetAttachedShaders(context, program, maxCount, count, shaders))
        {
            context->getAttachedShaders(program, maxCount, count, shaders);
        }
    }
}

GLint GL_APIENTRY GetAttribLocationContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetAttribLocation, context, program, name);
        if (context->skipValidation() || ValidateGetAttribLocation(context, program, name))
        {
            return context->getAttribLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetAttribLocation, GLint>();
}

void GL_APIENTRY GetBooleani_vContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLuint index,
                                           GLboolean *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLboolean *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetBooleani_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data))
        {
            context->getBooleani_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetBooleanvContextANGLE(GLeglContext ctx, GLenum pname, GLboolean *data)
{
    EVENT("(GLenum pname = 0x%X, GLboolean *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetBooleanv, context, pname, data);
        if (context->skipValidation() || ValidateGetBooleanv(context, pname, data))
        {
            context->getBooleanv(pname, data);
        }
    }
}

void GL_APIENTRY GetBufferParameteri64vContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum pname,
                                                    GLint64 *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint64 *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteri64v, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferParameteri64v(context, targetPacked, pname, params))
        {
            context->getBufferParameteri64v(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferParameterivContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferParameteriv(context, targetPacked, pname, params))
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferPointervContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointerv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferPointerv(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetBufferPointervOESContextANGLE(GLeglContext ctx,
                                                  GLenum target,
                                                  GLenum pname,
                                                  void **params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointervOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetBufferPointervOES(context, targetPacked, pname, params))
        {
            context->getBufferPointerv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetClipPlanefContextANGLE(GLeglContext ctx, GLenum plane, GLfloat *equation)
{
    EVENT("(GLenum plane = 0x%X, GLfloat *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetClipPlanef, context, plane, equation);
        if (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation))
        {
            context->getClipPlanef(plane, equation);
        }
    }
}

void GL_APIENTRY GetClipPlanexContextANGLE(GLeglContext ctx, GLenum plane, GLfixed *equation)
{
    EVENT("(GLenum plane = 0x%X, GLfixed *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetClipPlanex, context, plane, equation);
        if (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation))
        {
            context->getClipPlanex(plane, equation);
        }
    }
}

GLuint GL_APIENTRY GetDebugMessageLogKHRContextANGLE(GLeglContext ctx,
                                                     GLuint count,
                                                     GLsizei bufSize,
                                                     GLenum *sources,
                                                     GLenum *types,
                                                     GLuint *ids,
                                                     GLenum *severities,
                                                     GLsizei *lengths,
                                                     GLchar *messageLog)
{
    EVENT("(GLuint count = %u, GLsizei bufSize = %d, GLenum *sources = 0x%016" PRIxPTR
          ", GLenum *types = 0x%016" PRIxPTR ", GLuint *ids = 0x%016" PRIxPTR
          ", GLenum *severities = 0x%016" PRIxPTR ", GLsizei *lengths = 0x%016" PRIxPTR
          ", GLchar *messageLog = 0x%016" PRIxPTR ")",
          count, bufSize, (uintptr_t)sources, (uintptr_t)types, (uintptr_t)ids,
          (uintptr_t)severities, (uintptr_t)lengths, (uintptr_t)messageLog);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetDebugMessageLogKHR, context, count, bufSize, sources, types, ids,
                      severities, lengths, messageLog);
        if (context->skipValidation() ||
            ValidateGetDebugMessageLogKHR(context, count, bufSize, sources, types, ids, severities,
                                          lengths, messageLog))
        {
            return context->getDebugMessageLog(count, bufSize, sources, types, ids, severities,
                                               lengths, messageLog);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetDebugMessageLogKHR, GLuint>();
}

GLenum GL_APIENTRY GetErrorContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetError, context);
        if (context->skipValidation() || ValidateGetError(context))
        {
            return context->getError();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
}

void GL_APIENTRY GetFenceivNVContextANGLE(GLeglContext ctx,
                                          GLuint fence,
                                          GLenum pname,
                                          GLint *params)
{
    EVENT("(GLuint fence = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", fence,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFenceivNV, context, fence, pname, params);
        if (context->skipValidation() || ValidateGetFenceivNV(context, fence, pname, params))
        {
            context->getFenceivNV(fence, pname, params);
        }
    }
}

void GL_APIENTRY GetFixedvContextANGLE(GLeglContext ctx, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFixedv, context, pname, params);
        if (context->skipValidation() || ValidateGetFixedv(context, pname, params))
        {
            context->getFixedv(pname, params);
        }
    }
}

void GL_APIENTRY GetFloatvContextANGLE(GLeglContext ctx, GLenum pname, GLfloat *data)
{
    EVENT("(GLenum pname = 0x%X, GLfloat *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFloatv, context, pname, data);
        if (context->skipValidation() || ValidateGetFloatv(context, pname, data))
        {
            context->getFloatv(pname, data);
        }
    }
}

GLint GL_APIENTRY GetFragDataIndexEXTContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFragDataIndexEXT, context, program, name);
        if (context->skipValidation() || ValidateGetFragDataIndexEXT(context, program, name))
        {
            return context->getFragDataIndex(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetFragDataIndexEXT, GLint>();
}

GLint GL_APIENTRY GetFragDataLocationContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFragDataLocation, context, program, name);
        if (context->skipValidation() || ValidateGetFragDataLocation(context, program, name))
        {
            return context->getFragDataLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetFragDataLocation, GLint>();
}

void GL_APIENTRY GetFramebufferAttachmentParameterivContextANGLE(GLeglContext ctx,
                                                                 GLenum target,
                                                                 GLenum attachment,
                                                                 GLenum pname,
                                                                 GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, attachment, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFramebufferAttachmentParameteriv, context, target, attachment, pname,
                      params);
        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameteriv(context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivOESContextANGLE(GLeglContext ctx,
                                                                    GLenum target,
                                                                    GLenum attachment,
                                                                    GLenum pname,
                                                                    GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, attachment, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivOES, context, target, attachment, pname,
                      params);
        if (context->skipValidation() || ValidateGetFramebufferAttachmentParameterivOES(
                                             context, target, attachment, pname, params))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
    }
}

void GL_APIENTRY GetFramebufferParameterivContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFramebufferParameteriv, context, target, pname, params);
        if (context->skipValidation() ||
            ValidateGetFramebufferParameteriv(context, target, pname, params))
        {
            context->getFramebufferParameteriv(target, pname, params);
        }
    }
}

GLenum GL_APIENTRY GetGraphicsResetStatusEXTContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetGraphicsResetStatusEXT, context);
        if (context->skipValidation() || ValidateGetGraphicsResetStatusEXT(context))
        {
            return context->getGraphicsResetStatus();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetGraphicsResetStatusEXT, GLenum>();
}

void GL_APIENTRY GetInteger64i_vContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLuint index,
                                             GLint64 *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLint64 *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInteger64i_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetInteger64i_v(context, target, index, data))
        {
            context->getInteger64i_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetInteger64vContextANGLE(GLeglContext ctx, GLenum pname, GLint64 *data)
{
    EVENT("(GLenum pname = 0x%X, GLint64 *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInteger64v, context, pname, data);
        if (context->skipValidation() || ValidateGetInteger64v(context, pname, data))
        {
            context->getInteger64v(pname, data);
        }
    }
}

void GL_APIENTRY GetIntegeri_vContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLuint index,
                                           GLint *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLint *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetIntegeri_v, context, target, index, data);
        if (context->skipValidation() || ValidateGetIntegeri_v(context, target, index, data))
        {
            context->getIntegeri_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetIntegervContextANGLE(GLeglContext ctx, GLenum pname, GLint *data)
{
    EVENT("(GLenum pname = 0x%X, GLint *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetIntegerv, context, pname, data);
        if (context->skipValidation() || ValidateGetIntegerv(context, pname, data))
        {
            context->getIntegerv(pname, data);
        }
    }
}

void GL_APIENTRY GetInternalformativContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum internalformat,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLint *params = 0x%016" PRIxPTR ")",
        target, internalformat, pname, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInternalformativ, context, target, internalformat, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetInternalformativ(context, target, internalformat, pname, bufSize, params))
        {
            context->getInternalformativ(target, internalformat, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY GetLightfvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(GetLightfv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params))
        {
            context->getLightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetLightxvContextANGLE(GLeglContext ctx,
                                        GLenum light,
                                        GLenum pname,
                                        GLfixed *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(GetLightxv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateGetLightxv(context, light, pnamePacked, params))
        {
            context->getLightxv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMaterialfvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(GetMaterialfv, context, face, pnamePacked, params);
        if (context->skipValidation() || ValidateGetMaterialfv(context, face, pnamePacked, params))
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMaterialxvContextANGLE(GLeglContext ctx,
                                           GLenum face,
                                           GLenum pname,
                                           GLfixed *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(GetMaterialxv, context, face, pnamePacked, params);
        if (context->skipValidation() || ValidateGetMaterialxv(context, face, pnamePacked, params))
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                           GLuint memoryObject,
                                                           GLenum pname,
                                                           GLint *params)
{
    EVENT("(GLuint memoryObject = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")",
          memoryObject, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetMemoryObjectParameterivEXT, context, memoryObject, pname, params);
        if (context->skipValidation() ||
            ValidateGetMemoryObjectParameterivEXT(context, memoryObject, pname, params))
        {
            context->getMemoryObjectParameteriv(memoryObject, pname, params);
        }
    }
}

void GL_APIENTRY GetMultisamplefvContextANGLE(GLeglContext ctx,
                                              GLenum pname,
                                              GLuint index,
                                              GLfloat *val)
{
    EVENT("(GLenum pname = 0x%X, GLuint index = %u, GLfloat *val = 0x%016" PRIxPTR ")", pname,
          index, (uintptr_t)val);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetMultisamplefv, context, pname, index, val);
        if (context->skipValidation() || ValidateGetMultisamplefv(context, pname, index, val))
        {
            context->getMultisamplefv(pname, index, val);
        }
    }
}

void GL_APIENTRY GetObjectLabelKHRContextANGLE(GLeglContext ctx,
                                               GLenum identifier,
                                               GLuint name,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLchar *label = 0x%016" PRIxPTR ")",
        identifier, name, bufSize, (uintptr_t)length, (uintptr_t)label);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetObjectLabelKHR, context, identifier, name, bufSize, length, label);
        if (context->skipValidation() ||
            ValidateGetObjectLabelKHR(context, identifier, name, bufSize, length, label))
        {
            context->getObjectLabel(identifier, name, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                                  const void *ptr,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLchar *label)
{
    EVENT("(const void *ptr = 0x%016" PRIxPTR
          ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *label = 0x%016" PRIxPTR ")",
          (uintptr_t)ptr, bufSize, (uintptr_t)length, (uintptr_t)label);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetObjectPtrLabelKHR, context, ptr, bufSize, length, label);
        if (context->skipValidation() ||
            ValidateGetObjectPtrLabelKHR(context, ptr, bufSize, length, label))
        {
            context->getObjectPtrLabel(ptr, bufSize, length, label);
        }
    }
}

void GL_APIENTRY GetPointervContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    EVENT("(GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetPointerv, context, pname, params);
        if (context->skipValidation() || ValidateGetPointerv(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

void GL_APIENTRY GetPointervKHRContextANGLE(GLeglContext ctx, GLenum pname, void **params)
{
    EVENT("(GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetPointervKHR, context, pname, params);
        if (context->skipValidation() || ValidateGetPointervKHR(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

void GL_APIENTRY GetProgramBinaryContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLenum *binaryFormat,
                                              void *binary)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat, (uintptr_t)binary);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramBinary, context, program, bufSize, length, binaryFormat, binary);
        if (context->skipValidation() ||
            ValidateGetProgramBinary(context, program, bufSize, length, binaryFormat, binary))
        {
            context->getProgramBinary(program, bufSize, length, binaryFormat, binary);
        }
    }
}

void GL_APIENTRY GetProgramBinaryOESContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLenum *binaryFormat,
                                                 void *binary)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLenum *binaryFormat = 0x%016" PRIxPTR ", void *binary = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat, (uintptr_t)binary);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramBinaryOES, context, program, bufSize, length, binaryFormat, binary);
        if (context->skipValidation() ||
            ValidateGetProgramBinaryOES(context, program, bufSize, length, binaryFormat, binary))
        {
            context->getProgramBinary(program, bufSize, length, binaryFormat, binary);
        }
    }
}

void GL_APIENTRY GetProgramInfoLogContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLchar *infoLog)
{
    EVENT("(GLuint program = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramInfoLog, context, program, bufSize, length, infoLog);
        if (context->skipValidation() ||
            ValidateGetProgramInfoLog(context, program, bufSize, length, infoLog))
        {
            context->getProgramInfoLog(program, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramInterfaceivContextANGLE(GLeglContext ctx,
                                                   GLuint program,
                                                   GLenum programInterface,
                                                   GLenum pname,
                                                   GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLenum pname = 0x%X, GLint *params "
        "= 0x%016" PRIxPTR ")",
        program, programInterface, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramInterfaceiv, context, program, programInterface, pname, params);
        if (context->skipValidation() ||
            ValidateGetProgramInterfaceiv(context, program, programInterface, pname, params))
        {
            context->getProgramInterfaceiv(program, programInterface, pname, params);
        }
    }
}

void GL_APIENTRY GetProgramPipelineInfoLogContextANGLE(GLeglContext ctx,
                                                       GLuint pipeline,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLchar *infoLog)
{
    EVENT("(GLuint pipeline = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramPipelineInfoLog, context, pipeline, bufSize, length, infoLog);
        if (context->skipValidation() ||
            ValidateGetProgramPipelineInfoLog(context, pipeline, bufSize, length, infoLog))
        {
            context->getProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramPipelineivContextANGLE(GLeglContext ctx,
                                                  GLuint pipeline,
                                                  GLenum pname,
                                                  GLint *params)
{
    EVENT("(GLuint pipeline = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")",
          pipeline, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramPipelineiv, context, pipeline, pname, params);
        if (context->skipValidation() ||
            ValidateGetProgramPipelineiv(context, pipeline, pname, params))
        {
            context->getProgramPipelineiv(pipeline, pname, params);
        }
    }
}

GLuint GL_APIENTRY GetProgramResourceIndexContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLenum programInterface,
                                                       const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%016" PRIxPTR
        ")",
        program, programInterface, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramResourceIndex, context, program, programInterface, name);
        if (context->skipValidation() ||
            ValidateGetProgramResourceIndex(context, program, programInterface, name))
        {
            return context->getProgramResourceIndex(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceIndex, GLuint>();
}

GLint GL_APIENTRY GetProgramResourceLocationContextANGLE(GLeglContext ctx,
                                                         GLuint program,
                                                         GLenum programInterface,
                                                         const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%016" PRIxPTR
        ")",
        program, programInterface, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramResourceLocation, context, program, programInterface, name);
        if (context->skipValidation() ||
            ValidateGetProgramResourceLocation(context, program, programInterface, name))
        {
            return context->getProgramResourceLocation(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceLocation, GLint>();
}

GLint GL_APIENTRY GetProgramResourceLocationIndexEXTContextANGLE(GLeglContext ctx,
                                                                 GLuint program,
                                                                 GLenum programInterface,
                                                                 const GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%016" PRIxPTR
        ")",
        program, programInterface, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramResourceLocationIndexEXT, context, program, programInterface, name);
        if (context->skipValidation() ||
            ValidateGetProgramResourceLocationIndexEXT(context, program, programInterface, name))
        {
            return context->getProgramResourceLocationIndex(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceLocationIndexEXT, GLint>();
}

void GL_APIENTRY GetProgramResourceNameContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    GLenum programInterface,
                                                    GLuint index,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLuint index = %u, GLsizei bufSize "
        "= %d, GLsizei *length = 0x%016" PRIxPTR ", GLchar *name = 0x%016" PRIxPTR ")",
        program, programInterface, index, bufSize, (uintptr_t)length, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramResourceName, context, program, programInterface, index, bufSize,
                      length, name);
        if (context->skipValidation() ||
            ValidateGetProgramResourceName(context, program, programInterface, index, bufSize,
                                           length, name))
        {
            context->getProgramResourceName(program, programInterface, index, bufSize, length,
                                            name);
        }
    }
}

void GL_APIENTRY GetProgramResourceivContextANGLE(GLeglContext ctx,
                                                  GLuint program,
                                                  GLenum programInterface,
                                                  GLuint index,
                                                  GLsizei propCount,
                                                  const GLenum *props,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLuint index = %u, GLsizei "
        "propCount = %d, const GLenum *props = 0x%016" PRIxPTR
        ", GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
        ", GLint *params = 0x%016" PRIxPTR ")",
        program, programInterface, index, propCount, (uintptr_t)props, bufSize, (uintptr_t)length,
        (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramResourceiv, context, program, programInterface, index, propCount,
                      props, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetProgramResourceiv(context, program, programInterface, index, propCount,
                                         props, bufSize, length, params))
        {
            context->getProgramResourceiv(program, programInterface, index, propCount, props,
                                          bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetProgramivContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLenum pname,
                                          GLint *params)
{
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", program,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramiv, context, program, pname, params);
        if (context->skipValidation() || ValidateGetProgramiv(context, program, pname, params))
        {
            context->getProgramiv(program, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjecti64vEXTContextANGLE(GLeglContext ctx,
                                                   GLuint id,
                                                   GLenum pname,
                                                   GLint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint64 *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjecti64vEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjecti64vEXT(context, id, pname, params))
        {
            context->getQueryObjecti64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectivEXTContextANGLE(GLeglContext ctx,
                                                 GLuint id,
                                                 GLenum pname,
                                                 GLint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectivEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectivEXT(context, id, pname, params))
        {
            context->getQueryObjectiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectui64vEXTContextANGLE(GLeglContext ctx,
                                                    GLuint id,
                                                    GLenum pname,
                                                    GLuint64 *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint64 *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectui64vEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectui64vEXT(context, id, pname, params))
        {
            context->getQueryObjectui64v(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivContextANGLE(GLeglContext ctx,
                                               GLuint id,
                                               GLenum pname,
                                               GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectuiv, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectuiv(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivEXTContextANGLE(GLeglContext ctx,
                                                  GLuint id,
                                                  GLenum pname,
                                                  GLuint *params)
{
    EVENT("(GLuint id = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", id, pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectuivEXT, context, id, pname, params);
        if (context->skipValidation() || ValidateGetQueryObjectuivEXT(context, id, pname, params))
        {
            context->getQueryObjectuiv(id, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryivContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLenum pname,
                                        GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryiv, context, targetPacked, pname, params);
        if (context->skipValidation() || ValidateGetQueryiv(context, targetPacked, pname, params))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetQueryivEXTContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryivEXT, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetQueryivEXT(context, targetPacked, pname, params))
        {
            context->getQueryiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameterivContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetRenderbufferParameteriv, context, target, pname, params);
        if (context->skipValidation() ||
            ValidateGetRenderbufferParameteriv(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameterivOESContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLenum pname,
                                                           GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetRenderbufferParameterivOES, context, target, pname, params);
        if (context->skipValidation() ||
            ValidateGetRenderbufferParameterivOES(context, target, pname, params))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIivOESContextANGLE(GLeglContext ctx,
                                                       GLuint sampler,
                                                       GLenum pname,
                                                       GLint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterIivOES, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterIivOES(context, sampler, pname, params))
        {
            context->getSamplerParameterIiv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIuivOESContextANGLE(GLeglContext ctx,
                                                        GLuint sampler,
                                                        GLenum pname,
                                                        GLuint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterIuivOES, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterIuivOES(context, sampler, pname, params))
        {
            context->getSamplerParameterIuiv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterfvContextANGLE(GLeglContext ctx,
                                                   GLuint sampler,
                                                   GLenum pname,
                                                   GLfloat *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterfv, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameterfv(context, sampler, pname, params))
        {
            context->getSamplerParameterfv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterivContextANGLE(GLeglContext ctx,
                                                   GLuint sampler,
                                                   GLenum pname,
                                                   GLint *params)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", sampler,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameteriv, context, sampler, pname, params);
        if (context->skipValidation() ||
            ValidateGetSamplerParameteriv(context, sampler, pname, params))
        {
            context->getSamplerParameteriv(sampler, pname, params);
        }
    }
}

void GL_APIENTRY GetSemaphoreParameterui64vEXTContextANGLE(GLeglContext ctx,
                                                           GLuint semaphore,
                                                           GLenum pname,
                                                           GLuint64 *params)
{
    EVENT("(GLuint semaphore = %u, GLenum pname = 0x%X, GLuint64 *params = 0x%016" PRIxPTR ")",
          semaphore, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSemaphoreParameterui64vEXT, context, semaphore, pname, params);
        if (context->skipValidation() ||
            ValidateGetSemaphoreParameterui64vEXT(context, semaphore, pname, params))
        {
            context->getSemaphoreParameterui64v(semaphore, pname, params);
        }
    }
}

void GL_APIENTRY GetShaderInfoLogContextANGLE(GLeglContext ctx,
                                              GLuint shader,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLchar *infoLog)
{
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *infoLog = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetShaderInfoLog, context, shader, bufSize, length, infoLog);
        if (context->skipValidation() ||
            ValidateGetShaderInfoLog(context, shader, bufSize, length, infoLog))
        {
            context->getShaderInfoLog(shader, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetShaderPrecisionFormatContextANGLE(GLeglContext ctx,
                                                      GLenum shadertype,
                                                      GLenum precisiontype,
                                                      GLint *range,
                                                      GLint *precision)
{
    EVENT("(GLenum shadertype = 0x%X, GLenum precisiontype = 0x%X, GLint *range = 0x%016" PRIxPTR
          ", GLint *precision = 0x%016" PRIxPTR ")",
          shadertype, precisiontype, (uintptr_t)range, (uintptr_t)precision);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetShaderPrecisionFormat, context, shadertype, precisiontype, range,
                      precision);
        if (context->skipValidation() ||
            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype, range, precision))
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
    }
}

void GL_APIENTRY GetShaderSourceContextANGLE(GLeglContext ctx,
                                             GLuint shader,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *source)
{
    EVENT("(GLuint shader = %u, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR ")",
          shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetShaderSource, context, shader, bufSize, length, source);
        if (context->skipValidation() ||
            ValidateGetShaderSource(context, shader, bufSize, length, source))
        {
            context->getShaderSource(shader, bufSize, length, source);
        }
    }
}

void GL_APIENTRY GetShaderivContextANGLE(GLeglContext ctx,
                                         GLuint shader,
                                         GLenum pname,
                                         GLint *params)
{
    EVENT("(GLuint shader = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", shader,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetShaderiv, context, shader, pname, params);
        if (context->skipValidation() || ValidateGetShaderiv(context, shader, pname, params))
        {
            context->getShaderiv(shader, pname, params);
        }
    }
}

const GLubyte *GL_APIENTRY GetStringContextANGLE(GLeglContext ctx, GLenum name)
{
    EVENT("(GLenum name = 0x%X)", name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetString, context, name);
        if (context->skipValidation() || ValidateGetString(context, name))
        {
            return context->getString(name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
}

const GLubyte *GL_APIENTRY GetStringiContextANGLE(GLeglContext ctx, GLenum name, GLuint index)
{
    EVENT("(GLenum name = 0x%X, GLuint index = %u)", name, index);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetStringi, context, name, index);
        if (context->skipValidation() || ValidateGetStringi(context, name, index))
        {
            return context->getStringi(name, index);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetStringi, const GLubyte *>();
}

void GL_APIENTRY GetSyncivContextANGLE(GLeglContext ctx,
                                       GLsync sync,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLint *values)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR
          ", GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLint *values = 0x%016" PRIxPTR ")",
          (uintptr_t)sync, pname, bufSize, (uintptr_t)length, (uintptr_t)values);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSynciv, context, sync, pname, bufSize, length, values);
        if (context->skipValidation() ||
            ValidateGetSynciv(context, sync, pname, bufSize, length, values))
        {
            context->getSynciv(sync, pname, bufSize, length, values);
        }
    }
}

void GL_APIENTRY GetTexEnvfvContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(GetTexEnvfv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexEnvivContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(GetTexEnviv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexEnvxvContextANGLE(GLeglContext ctx,
                                         GLenum target,
                                         GLenum pname,
                                         GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(GetTexEnvxv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateGetTexEnvxv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexGenfvOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetTexGenfvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenfvOES(context, coord, pname, params))
        {
            context->getTexGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGenivOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetTexGenivOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenivOES(context, coord, pname, params))
        {
            context->getTexGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexGenxvOESContextANGLE(GLeglContext ctx,
                                            GLenum coord,
                                            GLenum pname,
                                            GLfixed *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", coord,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetTexGenxvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateGetTexGenxvOES(context, coord, pname, params))
        {
            context->getTexGenxv(coord, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfvContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLint level,
                                                    GLenum pname,
                                                    GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLfloat *params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfv, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterivContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLint level,
                                                    GLenum pname,
                                                    GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLint *params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameteriv, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameteriv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIivOESContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIivOES(context, targetPacked, pname, params))
        {
            context->getTexParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIuivOESContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum pname,
                                                    GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIuivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterIuivOES(context, targetPacked, pname, params))
        {
            context->getTexParameterIuiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterfvContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterfv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterfv(context, targetPacked, pname, params))
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterivContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameteriv(context, targetPacked, pname, params))
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterxvContextANGLE(GLeglContext ctx,
                                               GLenum target,
                                               GLenum pname,
                                               GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterxv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexParameterxv(context, targetPacked, pname, params))
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetTransformFeedbackVaryingContextANGLE(GLeglContext ctx,
                                                         GLuint program,
                                                         GLuint index,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLsizei *size,
                                                         GLenum *type,
                                                         GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLuint index = %u, GLsizei bufSize = %d, GLsizei *length = "
        "0x%016" PRIxPTR ", GLsizei *size = 0x%016" PRIxPTR ", GLenum *type = 0x%016" PRIxPTR
        ", GLchar *name = 0x%016" PRIxPTR ")",
        program, index, bufSize, (uintptr_t)length, (uintptr_t)size, (uintptr_t)type,
        (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetTransformFeedbackVarying, context, program, index, bufSize, length, size,
                      type, name);
        if (context->skipValidation() ||
            ValidateGetTransformFeedbackVarying(context, program, index, bufSize, length, size,
                                                type, name))
        {
            context->getTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
        }
    }
}

void GL_APIENTRY GetTranslatedShaderSourceANGLEContextANGLE(GLeglContext ctx,
                                                            GLuint shader,
                                                            GLsizei bufsize,
                                                            GLsizei *length,
                                                            GLchar *source)
{
    EVENT("(GLuint shader = %u, GLsizei bufsize = %d, GLsizei *length = 0x%016" PRIxPTR
          ", GLchar *source = 0x%016" PRIxPTR ")",
          shader, bufsize, (uintptr_t)length, (uintptr_t)source);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetTranslatedShaderSourceANGLE, context, shader, bufsize, length, source);
        if (context->skipValidation() ||
            ValidateGetTranslatedShaderSourceANGLE(context, shader, bufsize, length, source))
        {
            context->getTranslatedShaderSource(shader, bufsize, length, source);
        }
    }
}

GLuint GL_APIENTRY GetUniformBlockIndexContextANGLE(GLeglContext ctx,
                                                    GLuint program,
                                                    const GLchar *uniformBlockName)
{
    EVENT("(GLuint program = %u, const GLchar *uniformBlockName = 0x%016" PRIxPTR ")", program,
          (uintptr_t)uniformBlockName);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformBlockIndex, context, program, uniformBlockName);
        if (context->skipValidation() ||
            ValidateGetUniformBlockIndex(context, program, uniformBlockName))
        {
            return context->getUniformBlockIndex(program, uniformBlockName);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformBlockIndex, GLuint>();
}

void GL_APIENTRY GetUniformIndicesContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLsizei uniformCount,
                                               const GLchar *const *uniformNames,
                                               GLuint *uniformIndices)
{
    EVENT(
        "(GLuint program = %u, GLsizei uniformCount = %d, const GLchar *const*uniformNames = "
        "0x%016" PRIxPTR ", GLuint *uniformIndices = 0x%016" PRIxPTR ")",
        program, uniformCount, (uintptr_t)uniformNames, (uintptr_t)uniformIndices);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformIndices, context, program, uniformCount, uniformNames,
                      uniformIndices);
        if (context->skipValidation() ||
            ValidateGetUniformIndices(context, program, uniformCount, uniformNames, uniformIndices))
        {
            context->getUniformIndices(program, uniformCount, uniformNames, uniformIndices);
        }
    }
}

GLint GL_APIENTRY GetUniformLocationContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 const GLchar *name)
{
    EVENT("(GLuint program = %u, const GLchar *name = 0x%016" PRIxPTR ")", program,
          (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformLocation, context, program, name);
        if (context->skipValidation() || ValidateGetUniformLocation(context, program, name))
        {
            return context->getUniformLocation(program, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetUniformLocation, GLint>();
}

void GL_APIENTRY GetUniformfvContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLint location,
                                          GLfloat *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat *params = 0x%016" PRIxPTR ")",
          program, location, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformfv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformfv(context, program, location, params))
        {
            context->getUniformfv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUniformivContextANGLE(GLeglContext ctx,
                                          GLuint program,
                                          GLint location,
                                          GLint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformiv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformiv(context, program, location, params))
        {
            context->getUniformiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUniformuivContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLint location,
                                           GLuint *params)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint *params = 0x%016" PRIxPTR ")", program,
          location, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformuiv, context, program, location, params);
        if (context->skipValidation() || ValidateGetUniformuiv(context, program, location, params))
        {
            context->getUniformuiv(program, location, params);
        }
    }
}

void GL_APIENTRY GetUnsignedBytevEXTContextANGLE(GLeglContext ctx, GLenum pname, GLubyte *data)
{
    EVENT("(GLenum pname = 0x%X, GLubyte *data = 0x%016" PRIxPTR ")", pname, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUnsignedBytevEXT, context, pname, data);
        if (context->skipValidation() || ValidateGetUnsignedBytevEXT(context, pname, data))
        {
            context->getUnsignedBytev(pname, data);
        }
    }
}

void GL_APIENTRY GetUnsignedBytei_vEXTContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLuint index,
                                                   GLubyte *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLubyte *data = 0x%016" PRIxPTR ")", target,
          index, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUnsignedBytei_vEXT, context, target, index, data);
        if (context->skipValidation() ||
            ValidateGetUnsignedBytei_vEXT(context, target, index, data))
        {
            context->getUnsignedBytei_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetVertexAttribIivContextANGLE(GLeglContext ctx,
                                                GLuint index,
                                                GLenum pname,
                                                GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribIiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIiv(context, index, pname, params))
        {
            context->getVertexAttribIiv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIuivContextANGLE(GLeglContext ctx,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLuint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLuint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribIuiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribIuiv(context, index, pname, params))
        {
            context->getVertexAttribIuiv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointervContextANGLE(GLeglContext ctx,
                                                     GLuint index,
                                                     GLenum pname,
                                                     void **pointer)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, void **pointer = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribPointerv, context, index, pname, pointer);
        if (context->skipValidation() ||
            ValidateGetVertexAttribPointerv(context, index, pname, pointer))
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
    }
}

void GL_APIENTRY GetVertexAttribfvContextANGLE(GLeglContext ctx,
                                               GLuint index,
                                               GLenum pname,
                                               GLfloat *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribfv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params))
        {
            context->getVertexAttribfv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribivContextANGLE(GLeglContext ctx,
                                               GLuint index,
                                               GLenum pname,
                                               GLint *params)
{
    EVENT("(GLuint index = %u, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", index,
          pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribiv, context, index, pname, params);
        if (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params))
        {
            context->getVertexAttribiv(index, pname, params);
        }
    }
}

void GL_APIENTRY GetnUniformfvEXTContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLfloat *params = "
        "0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetnUniformfvEXT, context, program, location, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetnUniformfvEXT(context, program, location, bufSize, params))
        {
            context->getnUniformfv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY GetnUniformivEXTContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLsizei bufSize,
                                              GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLint *params = "
        "0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetnUniformivEXT, context, program, location, bufSize, params);
        if (context->skipValidation() ||
            ValidateGetnUniformivEXT(context, program, location, bufSize, params))
        {
            context->getnUniformiv(program, location, bufSize, params);
        }
    }
}

void GL_APIENTRY HintContextANGLE(GLeglContext ctx, GLenum target, GLenum mode)
{
    EVENT("(GLenum target = 0x%X, GLenum mode = 0x%X)", target, mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Hint, context, target, mode);
        if (context->skipValidation() || ValidateHint(context, target, mode))
        {
            context->hint(target, mode);
        }
    }
}

void GL_APIENTRY ImportMemoryFdEXTContextANGLE(GLeglContext ctx,
                                               GLuint memory,
                                               GLuint64 size,
                                               GLenum handleType,
                                               GLint fd)
{
    EVENT("(GLuint memory = %u, GLuint64 size = %llu, GLenum handleType = 0x%X, GLint fd = %d)",
          memory, static_cast<unsigned long long>(size), handleType, fd);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        HandleType handleTypePacked = FromGLenum<HandleType>(handleType);
        ANGLE_CAPTURE(ImportMemoryFdEXT, context, memory, size, handleTypePacked, fd);
        if (context->skipValidation() ||
            ValidateImportMemoryFdEXT(context, memory, size, handleTypePacked, fd))
        {
            context->importMemoryFd(memory, size, handleTypePacked, fd);
        }
    }
}

void GL_APIENTRY ImportSemaphoreFdEXTContextANGLE(GLeglContext ctx,
                                                  GLuint semaphore,
                                                  GLenum handleType,
                                                  GLint fd)
{
    EVENT("(GLuint semaphore = %u, GLenum handleType = 0x%X, GLint fd = %d)", semaphore, handleType,
          fd);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        HandleType handleTypePacked = FromGLenum<HandleType>(handleType);
        ANGLE_CAPTURE(ImportSemaphoreFdEXT, context, semaphore, handleTypePacked, fd);
        if (context->skipValidation() ||
            ValidateImportSemaphoreFdEXT(context, semaphore, handleTypePacked, fd))
        {
            context->importSemaphoreFd(semaphore, handleTypePacked, fd);
        }
    }
}

void GL_APIENTRY InsertEventMarkerEXTContextANGLE(GLeglContext ctx,
                                                  GLsizei length,
                                                  const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%016" PRIxPTR ")", length,
    // (uintptr_t)marker);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(InsertEventMarkerEXT, context, length, marker);
        if (context->skipValidation() || ValidateInsertEventMarkerEXT(context, length, marker))
        {
            context->insertEventMarker(length, marker);
        }
    }
}

void GL_APIENTRY InvalidateFramebufferContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLsizei numAttachments,
                                                   const GLenum *attachments)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ")",
        target, numAttachments, (uintptr_t)attachments);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(InvalidateFramebuffer, context, target, numAttachments, attachments);
        if (context->skipValidation() ||
            ValidateInvalidateFramebuffer(context, target, numAttachments, attachments))
        {
            context->invalidateFramebuffer(target, numAttachments, attachments);
        }
    }
}

void GL_APIENTRY InvalidateSubFramebufferContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLsizei numAttachments,
                                                      const GLenum *attachments,
                                                      GLint x,
                                                      GLint y,
                                                      GLsizei width,
                                                      GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei numAttachments = %d, const GLenum *attachments = "
        "0x%016" PRIxPTR ", GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, numAttachments, (uintptr_t)attachments, x, y, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(InvalidateSubFramebuffer, context, target, numAttachments, attachments, x, y,
                      width, height);
        if (context->skipValidation() ||
            ValidateInvalidateSubFramebuffer(context, target, numAttachments, attachments, x, y,
                                             width, height))
        {
            context->invalidateSubFramebuffer(target, numAttachments, attachments, x, y, width,
                                              height);
        }
    }
}

GLboolean GL_APIENTRY IsBufferContextANGLE(GLeglContext ctx, GLuint buffer)
{
    EVENT("(GLuint buffer = %u)", buffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsBuffer, context, buffer);
        if (context->skipValidation() || ValidateIsBuffer(context, buffer))
        {
            return context->isBuffer(buffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsEnabledContextANGLE(GLeglContext ctx, GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsEnabled, context, cap);
        if (context->skipValidation() || ValidateIsEnabled(context, cap))
        {
            return context->isEnabled(cap);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
}

GLboolean GL_APIENTRY IsFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsFenceNV, context, fence);
        if (context->skipValidation() || ValidateIsFenceNV(context, fence))
        {
            return context->isFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFenceNV, GLboolean>();
}

GLboolean GL_APIENTRY IsFramebufferContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsFramebuffer, context, framebuffer);
        if (context->skipValidation() || ValidateIsFramebuffer(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsFramebufferOESContextANGLE(GLeglContext ctx, GLuint framebuffer)
{
    EVENT("(GLuint framebuffer = %u)", framebuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsFramebufferOES, context, framebuffer);
        if (context->skipValidation() || ValidateIsFramebufferOES(context, framebuffer))
        {
            return context->isFramebuffer(framebuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsFramebufferOES, GLboolean>();
}

GLboolean GL_APIENTRY IsMemoryObjectEXTContextANGLE(GLeglContext ctx, GLuint memoryObject)
{
    EVENT("(GLuint memoryObject = %u)", memoryObject);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsMemoryObjectEXT, context, memoryObject);
        if (context->skipValidation() || ValidateIsMemoryObjectEXT(context, memoryObject))
        {
            return context->isMemoryObject(memoryObject);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsMemoryObjectEXT, GLboolean>();
}

GLboolean GL_APIENTRY IsProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsProgram, context, program);
        if (context->skipValidation() || ValidateIsProgram(context, program))
        {
            return context->isProgram(program);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgram, GLboolean>();
}

GLboolean GL_APIENTRY IsProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsProgramPipeline, context, pipeline);
        if (context->skipValidation() || ValidateIsProgramPipeline(context, pipeline))
        {
            return context->isProgramPipeline(pipeline);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
}

GLboolean GL_APIENTRY IsQueryContextANGLE(GLeglContext ctx, GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsQuery, context, id);
        if (context->skipValidation() || ValidateIsQuery(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQuery, GLboolean>();
}

GLboolean GL_APIENTRY IsQueryEXTContextANGLE(GLeglContext ctx, GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsQueryEXT, context, id);
        if (context->skipValidation() || ValidateIsQueryEXT(context, id))
        {
            return context->isQuery(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsQueryEXT, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbufferContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsRenderbuffer, context, renderbuffer);
        if (context->skipValidation() || ValidateIsRenderbuffer(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsRenderbufferOESContextANGLE(GLeglContext ctx, GLuint renderbuffer)
{
    EVENT("(GLuint renderbuffer = %u)", renderbuffer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsRenderbufferOES, context, renderbuffer);
        if (context->skipValidation() || ValidateIsRenderbufferOES(context, renderbuffer))
        {
            return context->isRenderbuffer(renderbuffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsRenderbufferOES, GLboolean>();
}

GLboolean GL_APIENTRY IsSemaphoreEXTContextANGLE(GLeglContext ctx, GLuint semaphore)
{
    EVENT("(GLuint semaphore = %u)", semaphore);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsSemaphoreEXT, context, semaphore);
        if (context->skipValidation() || ValidateIsSemaphoreEXT(context, semaphore))
        {
            return context->isSemaphore(semaphore);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSemaphoreEXT, GLboolean>();
}

GLboolean GL_APIENTRY IsSamplerContextANGLE(GLeglContext ctx, GLuint sampler)
{
    EVENT("(GLuint sampler = %u)", sampler);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsSampler, context, sampler);
        if (context->skipValidation() || ValidateIsSampler(context, sampler))
        {
            return context->isSampler(sampler);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSampler, GLboolean>();
}

GLboolean GL_APIENTRY IsShaderContextANGLE(GLeglContext ctx, GLuint shader)
{
    EVENT("(GLuint shader = %u)", shader);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsShader, context, shader);
        if (context->skipValidation() || ValidateIsShader(context, shader))
        {
            return context->isShader(shader);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsShader, GLboolean>();
}

GLboolean GL_APIENTRY IsSyncContextANGLE(GLeglContext ctx, GLsync sync)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ")", (uintptr_t)sync);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsSync, context, sync);
        if (context->skipValidation() || ValidateIsSync(context, sync))
        {
            return context->isSync(sync);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsSync, GLboolean>();
}

GLboolean GL_APIENTRY IsTextureContextANGLE(GLeglContext ctx, GLuint texture)
{
    EVENT("(GLuint texture = %u)", texture);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsTexture, context, texture);
        if (context->skipValidation() || ValidateIsTexture(context, texture))
        {
            return context->isTexture(texture);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsTexture, GLboolean>();
}

GLboolean GL_APIENTRY IsTransformFeedbackContextANGLE(GLeglContext ctx, GLuint id)
{
    EVENT("(GLuint id = %u)", id);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsTransformFeedback, context, id);
        if (context->skipValidation() || ValidateIsTransformFeedback(context, id))
        {
            return context->isTransformFeedback(id);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsTransformFeedback, GLboolean>();
}

GLboolean GL_APIENTRY IsVertexArrayContextANGLE(GLeglContext ctx, GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsVertexArray, context, array);
        if (context->skipValidation() || ValidateIsVertexArray(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArray, GLboolean>();
}

GLboolean GL_APIENTRY IsVertexArrayOESContextANGLE(GLeglContext ctx, GLuint array)
{
    EVENT("(GLuint array = %u)", array);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsVertexArrayOES, context, array);
        if (context->skipValidation() || ValidateIsVertexArrayOES(context, array))
        {
            return context->isVertexArray(array);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsVertexArrayOES, GLboolean>();
}

void GL_APIENTRY LightModelfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LightModelf, context, pname, param);
        if (context->skipValidation() || ValidateLightModelf(context, pname, param))
        {
            context->lightModelf(pname, param);
        }
    }
}

void GL_APIENTRY LightModelfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LightModelfv, context, pname, params);
        if (context->skipValidation() || ValidateLightModelfv(context, pname, params))
        {
            context->lightModelfv(pname, params);
        }
    }
}

void GL_APIENTRY LightModelxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LightModelx, context, pname, param);
        if (context->skipValidation() || ValidateLightModelx(context, pname, param))
        {
            context->lightModelx(pname, param);
        }
    }
}

void GL_APIENTRY LightModelxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *param)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LightModelxv, context, pname, param);
        if (context->skipValidation() || ValidateLightModelxv(context, pname, param))
        {
            context->lightModelxv(pname, param);
        }
    }
}

void GL_APIENTRY LightfContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfloat param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", light, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightf, context, light, pnamePacked, param);
        if (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param))
        {
            context->lightf(light, pnamePacked, param);
        }
    }
}

void GL_APIENTRY LightfvContextANGLE(GLeglContext ctx,
                                     GLenum light,
                                     GLenum pname,
                                     const GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightfv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params))
        {
            context->lightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY LightxContextANGLE(GLeglContext ctx, GLenum light, GLenum pname, GLfixed param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", light, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightx, context, light, pnamePacked, param);
        if (context->skipValidation() || ValidateLightx(context, light, pnamePacked, param))
        {
            context->lightx(light, pnamePacked, param);
        }
    }
}

void GL_APIENTRY LightxvContextANGLE(GLeglContext ctx,
                                     GLenum light,
                                     GLenum pname,
                                     const GLfixed *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        ANGLE_CAPTURE(Lightxv, context, light, pnamePacked, params);
        if (context->skipValidation() || ValidateLightxv(context, light, pnamePacked, params))
        {
            context->lightxv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY LineWidthContextANGLE(GLeglContext ctx, GLfloat width)
{
    EVENT("(GLfloat width = %f)", width);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LineWidth, context, width);
        if (context->skipValidation() || ValidateLineWidth(context, width))
        {
            context->lineWidth(width);
        }
    }
}

void GL_APIENTRY LineWidthxContextANGLE(GLeglContext ctx, GLfixed width)
{
    EVENT("(GLfixed width = 0x%X)", width);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LineWidthx, context, width);
        if (context->skipValidation() || ValidateLineWidthx(context, width))
        {
            context->lineWidthx(width);
        }
    }
}

void GL_APIENTRY LinkProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LinkProgram, context, program);
        if (context->skipValidation() || ValidateLinkProgram(context, program))
        {
            context->linkProgram(program);
        }
    }
}

void GL_APIENTRY LoadIdentityContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LoadIdentity, context);
        if (context->skipValidation() || ValidateLoadIdentity(context))
        {
            context->loadIdentity();
        }
    }
}

void GL_APIENTRY LoadMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LoadMatrixf, context, m);
        if (context->skipValidation() || ValidateLoadMatrixf(context, m))
        {
            context->loadMatrixf(m);
        }
    }
}

void GL_APIENTRY LoadMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    EVENT("(const GLfixed *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LoadMatrixx, context, m);
        if (context->skipValidation() || ValidateLoadMatrixx(context, m))
        {
            context->loadMatrixx(m);
        }
    }
}

void GL_APIENTRY LoadPaletteFromModelViewMatrixOESContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(LoadPaletteFromModelViewMatrixOES, context);
        if (context->skipValidation() || ValidateLoadPaletteFromModelViewMatrixOES(context))
        {
            context->loadPaletteFromModelViewMatrix();
        }
    }
}

void GL_APIENTRY LogicOpContextANGLE(GLeglContext ctx, GLenum opcode)
{
    EVENT("(GLenum opcode = 0x%X)", opcode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        LogicalOperation opcodePacked = FromGLenum<LogicalOperation>(opcode);
        ANGLE_CAPTURE(LogicOp, context, opcodePacked);
        if (context->skipValidation() || ValidateLogicOp(context, opcodePacked))
        {
            context->logicOp(opcodePacked);
        }
    }
}

void *GL_APIENTRY MapBufferOESContextANGLE(GLeglContext ctx, GLenum target, GLenum access)
{
    EVENT("(GLenum target = 0x%X, GLenum access = 0x%X)", target, access);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferOES, context, targetPacked, access);
        if (context->skipValidation() || ValidateMapBufferOES(context, targetPacked, access))
        {
            return context->mapBuffer(targetPacked, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferOES, void *>();
}

void *GL_APIENTRY MapBufferRangeContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLintptr offset,
                                             GLsizeiptr length,
                                             GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu, GLbitfield "
        "access = 0x%X)",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
        access);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferRange, context, targetPacked, offset, length, access);
        if (context->skipValidation() ||
            ValidateMapBufferRange(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRange, void *>();
}

void *GL_APIENTRY MapBufferRangeEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLintptr offset,
                                                GLsizeiptr length,
                                                GLbitfield access)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %llu, GLsizeiptr length = %llu, GLbitfield "
        "access = 0x%X)",
        target, static_cast<unsigned long long>(offset), static_cast<unsigned long long>(length),
        access);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(MapBufferRangeEXT, context, targetPacked, offset, length, access);
        if (context->skipValidation() ||
            ValidateMapBufferRangeEXT(context, targetPacked, offset, length, access))
        {
            return context->mapBufferRange(targetPacked, offset, length, access);
        }
    }

    return GetDefaultReturnValue<EntryPoint::MapBufferRangeEXT, void *>();
}

void GL_APIENTRY MaterialfContextANGLE(GLeglContext ctx, GLenum face, GLenum pname, GLfloat param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", face, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialf, context, face, pnamePacked, param);
        if (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param))
        {
            context->materialf(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY MaterialfvContextANGLE(GLeglContext ctx,
                                        GLenum face,
                                        GLenum pname,
                                        const GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialfv, context, face, pnamePacked, params);
        if (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params))
        {
            context->materialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY MaterialxContextANGLE(GLeglContext ctx, GLenum face, GLenum pname, GLfixed param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", face, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialx, context, face, pnamePacked, param);
        if (context->skipValidation() || ValidateMaterialx(context, face, pnamePacked, param))
        {
            context->materialx(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY MaterialxvContextANGLE(GLeglContext ctx,
                                        GLenum face,
                                        GLenum pname,
                                        const GLfixed *param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        ANGLE_CAPTURE(Materialxv, context, face, pnamePacked, param);
        if (context->skipValidation() || ValidateMaterialxv(context, face, pnamePacked, param))
        {
            context->materialxv(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY MatrixIndexPointerOESContextANGLE(GLeglContext ctx,
                                                   GLint size,
                                                   GLenum type,
                                                   GLsizei stride,
                                                   const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MatrixIndexPointerOES, context, size, type, stride, pointer);
        if (context->skipValidation() ||
            ValidateMatrixIndexPointerOES(context, size, type, stride, pointer))
        {
            context->matrixIndexPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY MatrixModeContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        MatrixType modePacked = FromGLenum<MatrixType>(mode);
        ANGLE_CAPTURE(MatrixMode, context, modePacked);
        if (context->skipValidation() || ValidateMatrixMode(context, modePacked))
        {
            context->matrixMode(modePacked);
        }
    }
}

void GL_APIENTRY MaxShaderCompilerThreadsKHRContextANGLE(GLeglContext ctx, GLuint count)
{
    EVENT("(GLuint count = %u)", count);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MaxShaderCompilerThreadsKHR, context, count);
        if (context->skipValidation() || ValidateMaxShaderCompilerThreadsKHR(context, count))
        {
            context->maxShaderCompilerThreads(count);
        }
    }
}

void GL_APIENTRY MemoryBarrierContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    EVENT("(GLbitfield barriers = 0x%X)", barriers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MemoryBarrier, context, barriers);
        if (context->skipValidation() || ValidateMemoryBarrier(context, barriers))
        {
            context->memoryBarrier(barriers);
        }
    }
}

void GL_APIENTRY MemoryBarrierByRegionContextANGLE(GLeglContext ctx, GLbitfield barriers)
{
    EVENT("(GLbitfield barriers = 0x%X)", barriers);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MemoryBarrierByRegion, context, barriers);
        if (context->skipValidation() || ValidateMemoryBarrierByRegion(context, barriers))
        {
            context->memoryBarrierByRegion(barriers);
        }
    }
}

void GL_APIENTRY MemoryObjectParameterivEXTContextANGLE(GLeglContext ctx,
                                                        GLuint memoryObject,
                                                        GLenum pname,
                                                        const GLint *params)
{
    EVENT("(GLuint memoryObject = %u, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR
          ")",
          memoryObject, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MemoryObjectParameterivEXT, context, memoryObject, pname, params);
        if (context->skipValidation() ||
            ValidateMemoryObjectParameterivEXT(context, memoryObject, pname, params))
        {
            context->memoryObjectParameteriv(memoryObject, pname, params);
        }
    }
}

void GL_APIENTRY MultMatrixfContextANGLE(GLeglContext ctx, const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MultMatrixf, context, m);
        if (context->skipValidation() || ValidateMultMatrixf(context, m))
        {
            context->multMatrixf(m);
        }
    }
}

void GL_APIENTRY MultMatrixxContextANGLE(GLeglContext ctx, const GLfixed *m)
{
    EVENT("(const GLfixed *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MultMatrixx, context, m);
        if (context->skipValidation() || ValidateMultMatrixx(context, m))
        {
            context->multMatrixx(m);
        }
    }
}

void GL_APIENTRY MultiTexCoord4fContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLfloat s,
                                             GLfloat t,
                                             GLfloat r,
                                             GLfloat q)
{
    EVENT("(GLenum target = 0x%X, GLfloat s = %f, GLfloat t = %f, GLfloat r = %f, GLfloat q = %f)",
          target, s, t, r, q);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MultiTexCoord4f, context, target, s, t, r, q);
        if (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q))
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
    }
}

void GL_APIENTRY MultiTexCoord4xContextANGLE(GLeglContext ctx,
                                             GLenum texture,
                                             GLfixed s,
                                             GLfixed t,
                                             GLfixed r,
                                             GLfixed q)
{
    EVENT(
        "(GLenum texture = 0x%X, GLfixed s = 0x%X, GLfixed t = 0x%X, GLfixed r = 0x%X, GLfixed q = "
        "0x%X)",
        texture, s, t, r, q);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MultiTexCoord4x, context, texture, s, t, r, q);
        if (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q))
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
    }
}

void GL_APIENTRY Normal3fContextANGLE(GLeglContext ctx, GLfloat nx, GLfloat ny, GLfloat nz)
{
    EVENT("(GLfloat nx = %f, GLfloat ny = %f, GLfloat nz = %f)", nx, ny, nz);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Normal3f, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz))
        {
            context->normal3f(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3xContextANGLE(GLeglContext ctx, GLfixed nx, GLfixed ny, GLfixed nz)
{
    EVENT("(GLfixed nx = 0x%X, GLfixed ny = 0x%X, GLfixed nz = 0x%X)", nx, ny, nz);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Normal3x, context, nx, ny, nz);
        if (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz))
        {
            context->normal3x(nx, ny, nz);
        }
    }
}

void GL_APIENTRY NormalPointerContextANGLE(GLeglContext ctx,
                                           GLenum type,
                                           GLsizei stride,
                                           const void *pointer)
{
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
          type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(NormalPointer, context, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateNormalPointer(context, typePacked, stride, pointer))
        {
            context->normalPointer(typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY ObjectLabelKHRContextANGLE(GLeglContext ctx,
                                            GLenum identifier,
                                            GLuint name,
                                            GLsizei length,
                                            const GLchar *label)
{
    EVENT(
        "(GLenum identifier = 0x%X, GLuint name = %u, GLsizei length = %d, const GLchar *label = "
        "0x%016" PRIxPTR ")",
        identifier, name, length, (uintptr_t)label);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ObjectLabelKHR, context, identifier, name, length, label);
        if (context->skipValidation() ||
            ValidateObjectLabelKHR(context, identifier, name, length, label))
        {
            context->objectLabel(identifier, name, length, label);
        }
    }
}

void GL_APIENTRY ObjectPtrLabelKHRContextANGLE(GLeglContext ctx,
                                               const void *ptr,
                                               GLsizei length,
                                               const GLchar *label)
{
    EVENT("(const void *ptr = 0x%016" PRIxPTR
          ", GLsizei length = %d, const GLchar *label = 0x%016" PRIxPTR ")",
          (uintptr_t)ptr, length, (uintptr_t)label);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ObjectPtrLabelKHR, context, ptr, length, label);
        if (context->skipValidation() || ValidateObjectPtrLabelKHR(context, ptr, length, label))
        {
            context->objectPtrLabel(ptr, length, label);
        }
    }
}

void GL_APIENTRY OrthofContextANGLE(GLeglContext ctx,
                                    GLfloat l,
                                    GLfloat r,
                                    GLfloat b,
                                    GLfloat t,
                                    GLfloat n,
                                    GLfloat f)
{
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Orthof, context, l, r, b, t, n, f);
        if (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f))
        {
            context->orthof(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY OrthoxContextANGLE(GLeglContext ctx,
                                    GLfixed l,
                                    GLfixed r,
                                    GLfixed b,
                                    GLfixed t,
                                    GLfixed n,
                                    GLfixed f)
{
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Orthox, context, l, r, b, t, n, f);
        if (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f))
        {
            context->orthox(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY PauseTransformFeedbackContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PauseTransformFeedback, context);
        if (context->skipValidation() || ValidatePauseTransformFeedback(context))
        {
            context->pauseTransformFeedback();
        }
    }
}

void GL_APIENTRY PixelStoreiContextANGLE(GLeglContext ctx, GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PixelStorei, context, pname, param);
        if (context->skipValidation() || ValidatePixelStorei(context, pname, param))
        {
            context->pixelStorei(pname, param);
        }
    }
}

void GL_APIENTRY PointParameterfContextANGLE(GLeglContext ctx, GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        ANGLE_CAPTURE(PointParameterf, context, pnamePacked, param);
        if (context->skipValidation() || ValidatePointParameterf(context, pnamePacked, param))
        {
            context->pointParameterf(pnamePacked, param);
        }
    }
}

void GL_APIENTRY PointParameterfvContextANGLE(GLeglContext ctx, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        ANGLE_CAPTURE(PointParameterfv, context, pnamePacked, params);
        if (context->skipValidation() || ValidatePointParameterfv(context, pnamePacked, params))
        {
            context->pointParameterfv(pnamePacked, params);
        }
    }
}

void GL_APIENTRY PointParameterxContextANGLE(GLeglContext ctx, GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        ANGLE_CAPTURE(PointParameterx, context, pnamePacked, param);
        if (context->skipValidation() || ValidatePointParameterx(context, pnamePacked, param))
        {
            context->pointParameterx(pnamePacked, param);
        }
    }
}

void GL_APIENTRY PointParameterxvContextANGLE(GLeglContext ctx, GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        ANGLE_CAPTURE(PointParameterxv, context, pnamePacked, params);
        if (context->skipValidation() || ValidatePointParameterxv(context, pnamePacked, params))
        {
            context->pointParameterxv(pnamePacked, params);
        }
    }
}

void GL_APIENTRY PointSizeContextANGLE(GLeglContext ctx, GLfloat size)
{
    EVENT("(GLfloat size = %f)", size);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PointSize, context, size);
        if (context->skipValidation() || ValidatePointSize(context, size))
        {
            context->pointSize(size);
        }
    }
}

void GL_APIENTRY PointSizePointerOESContextANGLE(GLeglContext ctx,
                                                 GLenum type,
                                                 GLsizei stride,
                                                 const void *pointer)
{
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
          type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(PointSizePointerOES, context, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidatePointSizePointerOES(context, typePacked, stride, pointer))
        {
            context->pointSizePointer(typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY PointSizexContextANGLE(GLeglContext ctx, GLfixed size)
{
    EVENT("(GLfixed size = 0x%X)", size);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PointSizex, context, size);
        if (context->skipValidation() || ValidatePointSizex(context, size))
        {
            context->pointSizex(size);
        }
    }
}

void GL_APIENTRY PolygonOffsetContextANGLE(GLeglContext ctx, GLfloat factor, GLfloat units)
{
    EVENT("(GLfloat factor = %f, GLfloat units = %f)", factor, units);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PolygonOffset, context, factor, units);
        if (context->skipValidation() || ValidatePolygonOffset(context, factor, units))
        {
            context->polygonOffset(factor, units);
        }
    }
}

void GL_APIENTRY PolygonOffsetxContextANGLE(GLeglContext ctx, GLfixed factor, GLfixed units)
{
    EVENT("(GLfixed factor = 0x%X, GLfixed units = 0x%X)", factor, units);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PolygonOffsetx, context, factor, units);
        if (context->skipValidation() || ValidatePolygonOffsetx(context, factor, units))
        {
            context->polygonOffsetx(factor, units);
        }
    }
}

void GL_APIENTRY PopDebugGroupKHRContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PopDebugGroupKHR, context);
        if (context->skipValidation() || ValidatePopDebugGroupKHR(context))
        {
            context->popDebugGroup();
        }
    }
}

void GL_APIENTRY PopGroupMarkerEXTContextANGLE(GLeglContext ctx)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PopGroupMarkerEXT, context);
        if (context->skipValidation() || ValidatePopGroupMarkerEXT(context))
        {
            context->popGroupMarker();
        }
    }
}

void GL_APIENTRY PopMatrixContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PopMatrix, context);
        if (context->skipValidation() || ValidatePopMatrix(context))
        {
            context->popMatrix();
        }
    }
}

void GL_APIENTRY ProgramBinaryContextANGLE(GLeglContext ctx,
                                           GLuint program,
                                           GLenum binaryFormat,
                                           const void *binary,
                                           GLsizei length)
{
    EVENT("(GLuint program = %u, GLenum binaryFormat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLsizei length = %d)",
          program, binaryFormat, (uintptr_t)binary, length);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramBinary, context, program, binaryFormat, binary, length);
        if (context->skipValidation() ||
            ValidateProgramBinary(context, program, binaryFormat, binary, length))
        {
            context->programBinary(program, binaryFormat, binary, length);
        }
    }
}

void GL_APIENTRY ProgramBinaryOESContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLenum binaryFormat,
                                              const void *binary,
                                              GLint length)
{
    EVENT("(GLuint program = %u, GLenum binaryFormat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLint length = %d)",
          program, binaryFormat, (uintptr_t)binary, length);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramBinaryOES, context, program, binaryFormat, binary, length);
        if (context->skipValidation() ||
            ValidateProgramBinaryOES(context, program, binaryFormat, binary, length))
        {
            context->programBinary(program, binaryFormat, binary, length);
        }
    }
}

void GL_APIENTRY ProgramParameteriContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLenum pname,
                                               GLint value)
{
    EVENT("(GLuint program = %u, GLenum pname = 0x%X, GLint value = %d)", program, pname, value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramParameteri, context, program, pname, value);
        if (context->skipValidation() || ValidateProgramParameteri(context, program, pname, value))
        {
            context->programParameteri(program, pname, value);
        }
    }
}

void GL_APIENTRY ProgramUniform1fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat v0 = %f)", program, location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1f, context, program, location, v0);
        if (context->skipValidation() || ValidateProgramUniform1f(context, program, location, v0))
        {
            context->programUniform1f(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1fv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform1fv(context, program, location, count, value))
        {
            context->programUniform1fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform1iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d)", program, location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1i, context, program, location, v0);
        if (context->skipValidation() || ValidateProgramUniform1i(context, program, location, v0))
        {
            context->programUniform1i(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1iv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform1iv(context, program, location, count, value))
        {
            context->programUniform1iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform1uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint v0 = %u)", program, location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1ui, context, program, location, v0);
        if (context->skipValidation() || ValidateProgramUniform1ui(context, program, location, v0))
        {
            context->programUniform1ui(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform1uiv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform1uiv(context, program, location, count, value))
        {
            context->programUniform1uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform2fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", program,
          location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2f, context, program, location, v0, v1);
        if (context->skipValidation() ||
            ValidateProgramUniform2f(context, program, location, v0, v1))
        {
            context->programUniform2f(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2fv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform2fv(context, program, location, count, value))
        {
            context->programUniform2fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY
ProgramUniform2iContextANGLE(GLeglContext ctx, GLuint program, GLint location, GLint v0, GLint v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d)", program,
          location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2i, context, program, location, v0, v1);
        if (context->skipValidation() ||
            ValidateProgramUniform2i(context, program, location, v0, v1))
        {
            context->programUniform2i(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2iv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform2iv(context, program, location, count, value))
        {
            context->programUniform2iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform2uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u)", program,
          location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2ui, context, program, location, v0, v1);
        if (context->skipValidation() ||
            ValidateProgramUniform2ui(context, program, location, v0, v1))
        {
            context->programUniform2ui(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform2uiv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform2uiv(context, program, location, count, value))
        {
            context->programUniform2uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform3fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1,
                                              GLfloat v2)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = "
        "%f)",
        program, location, v0, v1, v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3f, context, program, location, v0, v1, v2);
        if (context->skipValidation() ||
            ValidateProgramUniform3f(context, program, location, v0, v1, v2))
        {
            context->programUniform3f(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3fv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform3fv(context, program, location, count, value))
        {
            context->programUniform3fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform3iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0,
                                              GLint v1,
                                              GLint v2)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)",
          program, location, v0, v1, v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3i, context, program, location, v0, v1, v2);
        if (context->skipValidation() ||
            ValidateProgramUniform3i(context, program, location, v0, v1, v2))
        {
            context->programUniform3i(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3iv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform3iv(context, program, location, count, value))
        {
            context->programUniform3iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform3uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1,
                                               GLuint v2)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = "
        "%u)",
        program, location, v0, v1, v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3ui, context, program, location, v0, v1, v2);
        if (context->skipValidation() ||
            ValidateProgramUniform3ui(context, program, location, v0, v1, v2))
        {
            context->programUniform3ui(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform3uiv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform3uiv(context, program, location, count, value))
        {
            context->programUniform3uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform4fContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLfloat v0,
                                              GLfloat v1,
                                              GLfloat v2,
                                              GLfloat v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = "
        "%f, GLfloat v3 = %f)",
        program, location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4f, context, program, location, v0, v1, v2, v3);
        if (context->skipValidation() ||
            ValidateProgramUniform4f(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4f(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4fvContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4fv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform4fv(context, program, location, count, value))
        {
            context->programUniform4fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform4iContextANGLE(GLeglContext ctx,
                                              GLuint program,
                                              GLint location,
                                              GLint v0,
                                              GLint v1,
                                              GLint v2,
                                              GLint v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, "
        "GLint v3 = %d)",
        program, location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4i, context, program, location, v0, v1, v2, v3);
        if (context->skipValidation() ||
            ValidateProgramUniform4i(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4i(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4ivContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLsizei count,
                                               const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4iv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform4iv(context, program, location, count, value))
        {
            context->programUniform4iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform4uiContextANGLE(GLeglContext ctx,
                                               GLuint program,
                                               GLint location,
                                               GLuint v0,
                                               GLuint v1,
                                               GLuint v2,
                                               GLuint v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = "
        "%u, GLuint v3 = %u)",
        program, location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4ui, context, program, location, v0, v1, v2, v3);
        if (context->skipValidation() ||
            ValidateProgramUniform4ui(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4ui(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4uivContextANGLE(GLeglContext ctx,
                                                GLuint program,
                                                GLint location,
                                                GLsizei count,
                                                const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%016" PRIxPTR ")",
        program, location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniform4uiv, context, program, location, count, value);
        if (context->skipValidation() ||
            ValidateProgramUniform4uiv(context, program, location, count, value))
        {
            context->programUniform4uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix2fv, context, program, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2x3fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix2x3fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2x3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2x3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2x4fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix2x4fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2x4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2x4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix3fv, context, program, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3x2fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix3x2fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3x2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3x2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3x4fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix3x4fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3x4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3x4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4fvContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei count,
                                                     GLboolean transpose,
                                                     const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix4fv, context, program, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4x2fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix4x2fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4x2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4x2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4x3fvContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei count,
                                                       GLboolean transpose,
                                                       const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%016" PRIxPTR ")",
        program, location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramUniformMatrix4x3fv, context, program, location, count, transpose,
                      value);
        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4x3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4x3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY PushDebugGroupKHRContextANGLE(GLeglContext ctx,
                                               GLenum source,
                                               GLuint id,
                                               GLsizei length,
                                               const GLchar *message)
{
    EVENT(
        "(GLenum source = 0x%X, GLuint id = %u, GLsizei length = %d, const GLchar *message = "
        "0x%016" PRIxPTR ")",
        source, id, length, (uintptr_t)message);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PushDebugGroupKHR, context, source, id, length, message);
        if (context->skipValidation() ||
            ValidatePushDebugGroupKHR(context, source, id, length, message))
        {
            context->pushDebugGroup(source, id, length, message);
        }
    }
}

void GL_APIENTRY PushGroupMarkerEXTContextANGLE(GLeglContext ctx,
                                                GLsizei length,
                                                const GLchar *marker)
{
    // Don't run an EVENT() macro on the EXT_debug_marker entry points.
    // It can interfere with the debug events being set by the caller.
    // EVENT("(GLsizei length = %d, const GLchar *marker = 0x%016" PRIxPTR ")", length,
    // (uintptr_t)marker);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PushGroupMarkerEXT, context, length, marker);
        if (context->skipValidation() || ValidatePushGroupMarkerEXT(context, length, marker))
        {
            context->pushGroupMarker(length, marker);
        }
    }
}

void GL_APIENTRY PushMatrixContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PushMatrix, context);
        if (context->skipValidation() || ValidatePushMatrix(context))
        {
            context->pushMatrix();
        }
    }
}

void GL_APIENTRY QueryCounterEXTContextANGLE(GLeglContext ctx, GLuint id, GLenum target)
{
    EVENT("(GLuint id = %u, GLenum target = 0x%X)", id, target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(QueryCounterEXT, context, id, targetPacked);
        if (context->skipValidation() || ValidateQueryCounterEXT(context, id, targetPacked))
        {
            context->queryCounter(id, targetPacked);
        }
    }
}

GLbitfield GL_APIENTRY QueryMatrixxOESContextANGLE(GLeglContext ctx,
                                                   GLfixed *mantissa,
                                                   GLint *exponent)
{
    EVENT("(GLfixed *mantissa = 0x%016" PRIxPTR ", GLint *exponent = 0x%016" PRIxPTR ")",
          (uintptr_t)mantissa, (uintptr_t)exponent);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(QueryMatrixxOES, context, mantissa, exponent);
        if (context->skipValidation() || ValidateQueryMatrixxOES(context, mantissa, exponent))
        {
            return context->queryMatrixx(mantissa, exponent);
        }
    }

    return GetDefaultReturnValue<EntryPoint::QueryMatrixxOES, GLbitfield>();
}

void GL_APIENTRY ReadBufferContextANGLE(GLeglContext ctx, GLenum src)
{
    EVENT("(GLenum src = 0x%X)", src);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReadBuffer, context, src);
        if (context->skipValidation() || ValidateReadBuffer(context, src))
        {
            context->readBuffer(src);
        }
    }
}

void GL_APIENTRY ReadPixelsContextANGLE(GLeglContext ctx,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height,
                                        GLenum format,
                                        GLenum type,
                                        void *pixels)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, void *pixels = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReadPixels, context, x, y, width, height, format, type, pixels);
        if (context->skipValidation() ||
            ValidateReadPixels(context, x, y, width, height, format, type, pixels))
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
    }
}

void GL_APIENTRY ReadnPixelsEXTContextANGLE(GLeglContext ctx,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            void *data)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, void *data = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReadnPixelsEXT, context, x, y, width, height, format, type, bufSize, data);
        if (context->skipValidation() ||
            ValidateReadnPixelsEXT(context, x, y, width, height, format, type, bufSize, data))
        {
            context->readnPixels(x, y, width, height, format, type, bufSize, data);
        }
    }
}

void GL_APIENTRY ReleaseShaderCompilerContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReleaseShaderCompiler, context);
        if (context->skipValidation() || ValidateReleaseShaderCompiler(context))
        {
            context->releaseShaderCompiler();
        }
    }
}

void GL_APIENTRY RenderbufferStorageContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(RenderbufferStorage, context, target, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorage(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLsizei samples,
                                                            GLenum internalformat,
                                                            GLsizei width,
                                                            GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(RenderbufferStorageMultisample, context, target, samples, internalformat,
                      width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisample(context, target, samples, internalformat, width,
                                                   height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

void GL_APIENTRY RenderbufferStorageMultisampleANGLEContextANGLE(GLeglContext ctx,
                                                                 GLenum target,
                                                                 GLsizei samples,
                                                                 GLenum internalformat,
                                                                 GLsizei width,
                                                                 GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d)",
        target, samples, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(RenderbufferStorageMultisampleANGLE, context, target, samples, internalformat,
                      width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageMultisampleANGLE(context, target, samples, internalformat,
                                                        width, height))
        {
            context->renderbufferStorageMultisample(target, samples, internalformat, width, height);
        }
    }
}

void GL_APIENTRY RenderbufferStorageOESContextANGLE(GLeglContext ctx,
                                                    GLenum target,
                                                    GLenum internalformat,
                                                    GLsizei width,
                                                    GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLsizei width = %d, GLsizei height = "
        "%d)",
        target, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(RenderbufferStorageOES, context, target, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateRenderbufferStorageOES(context, target, internalformat, width, height))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
    }
}

void GL_APIENTRY ResumeTransformFeedbackContextANGLE(GLeglContext ctx)
{
    EVENT("()");

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ResumeTransformFeedback, context);
        if (context->skipValidation() || ValidateResumeTransformFeedback(context))
        {
            context->resumeTransformFeedback();
        }
    }
}

void GL_APIENTRY
RotatefContextANGLE(GLeglContext ctx, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat angle = %f, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", angle, x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Rotatef, context, angle, x, y, z);
        if (context->skipValidation() || ValidateRotatef(context, angle, x, y, z))
        {
            context->rotatef(angle, x, y, z);
        }
    }
}

void GL_APIENTRY
RotatexContextANGLE(GLeglContext ctx, GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed angle = 0x%X, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", angle, x,
          y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Rotatex, context, angle, x, y, z);
        if (context->skipValidation() || ValidateRotatex(context, angle, x, y, z))
        {
            context->rotatex(angle, x, y, z);
        }
    }
}

void GL_APIENTRY SampleCoverageContextANGLE(GLeglContext ctx, GLfloat value, GLboolean invert)
{
    EVENT("(GLfloat value = %f, GLboolean invert = %u)", value, invert);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SampleCoverage, context, value, invert);
        if (context->skipValidation() || ValidateSampleCoverage(context, value, invert))
        {
            context->sampleCoverage(value, invert);
        }
    }
}

void GL_APIENTRY SampleCoveragexContextANGLE(GLeglContext ctx, GLclampx value, GLboolean invert)
{
    EVENT("(GLclampx value = 0x%X, GLboolean invert = %u)", value, invert);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SampleCoveragex, context, value, invert);
        if (context->skipValidation() || ValidateSampleCoveragex(context, value, invert))
        {
            context->sampleCoveragex(value, invert);
        }
    }
}

void GL_APIENTRY SampleMaskiContextANGLE(GLeglContext ctx, GLuint maskNumber, GLbitfield mask)
{
    EVENT("(GLuint maskNumber = %u, GLbitfield mask = 0x%X)", maskNumber, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SampleMaski, context, maskNumber, mask);
        if (context->skipValidation() || ValidateSampleMaski(context, maskNumber, mask))
        {
            context->sampleMaski(maskNumber, mask);
        }
    }
}

void GL_APIENTRY SamplerParameterIivOESContextANGLE(GLeglContext ctx,
                                                    GLuint sampler,
                                                    GLenum pname,
                                                    const GLint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterIivOES, context, sampler, pname, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIivOES(context, sampler, pname, param))
        {
            context->samplerParameterIiv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterIuivOESContextANGLE(GLeglContext ctx,
                                                     GLuint sampler,
                                                     GLenum pname,
                                                     const GLuint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLuint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterIuivOES, context, sampler, pname, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIuivOES(context, sampler, pname, param))
        {
            context->samplerParameterIuiv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterfContextANGLE(GLeglContext ctx,
                                               GLuint sampler,
                                               GLenum pname,
                                               GLfloat param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLfloat param = %f)", sampler, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterf, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameterf(context, sampler, pname, param))
        {
            context->samplerParameterf(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterfvContextANGLE(GLeglContext ctx,
                                                GLuint sampler,
                                                GLenum pname,
                                                const GLfloat *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLfloat *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterfv, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameterfv(context, sampler, pname, param))
        {
            context->samplerParameterfv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameteriContextANGLE(GLeglContext ctx,
                                               GLuint sampler,
                                               GLenum pname,
                                               GLint param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, GLint param = %d)", sampler, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameteri, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameteri(context, sampler, pname, param))
        {
            context->samplerParameteri(sampler, pname, param);
        }
    }
}

void GL_APIENTRY SamplerParameterivContextANGLE(GLeglContext ctx,
                                                GLuint sampler,
                                                GLenum pname,
                                                const GLint *param)
{
    EVENT("(GLuint sampler = %u, GLenum pname = 0x%X, const GLint *param = 0x%016" PRIxPTR ")",
          sampler, pname, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameteriv, context, sampler, pname, param);
        if (context->skipValidation() || ValidateSamplerParameteriv(context, sampler, pname, param))
        {
            context->samplerParameteriv(sampler, pname, param);
        }
    }
}

void GL_APIENTRY ScalefContextANGLE(GLeglContext ctx, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Scalef, context, x, y, z);
        if (context->skipValidation() || ValidateScalef(context, x, y, z))
        {
            context->scalef(x, y, z);
        }
    }
}

void GL_APIENTRY ScalexContextANGLE(GLeglContext ctx, GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Scalex, context, x, y, z);
        if (context->skipValidation() || ValidateScalex(context, x, y, z))
        {
            context->scalex(x, y, z);
        }
    }
}

void GL_APIENTRY
ScissorContextANGLE(GLeglContext ctx, GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Scissor, context, x, y, width, height);
        if (context->skipValidation() || ValidateScissor(context, x, y, width, height))
        {
            context->scissor(x, y, width, height);
        }
    }
}

void GL_APIENTRY SemaphoreParameterui64vEXTContextANGLE(GLeglContext ctx,
                                                        GLuint semaphore,
                                                        GLenum pname,
                                                        const GLuint64 *params)
{
    EVENT("(GLuint semaphore = %u, GLenum pname = 0x%X, const GLuint64 *params = 0x%016" PRIxPTR
          ")",
          semaphore, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SemaphoreParameterui64vEXT, context, semaphore, pname, params);
        if (context->skipValidation() ||
            ValidateSemaphoreParameterui64vEXT(context, semaphore, pname, params))
        {
            context->semaphoreParameterui64v(semaphore, pname, params);
        }
    }
}

void GL_APIENTRY SetFenceNVContextANGLE(GLeglContext ctx, GLuint fence, GLenum condition)
{
    EVENT("(GLuint fence = %u, GLenum condition = 0x%X)", fence, condition);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SetFenceNV, context, fence, condition);
        if (context->skipValidation() || ValidateSetFenceNV(context, fence, condition))
        {
            context->setFenceNV(fence, condition);
        }
    }
}

void GL_APIENTRY ShadeModelContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ShadingModel modePacked = FromGLenum<ShadingModel>(mode);
        ANGLE_CAPTURE(ShadeModel, context, modePacked);
        if (context->skipValidation() || ValidateShadeModel(context, modePacked))
        {
            context->shadeModel(modePacked);
        }
    }
}

void GL_APIENTRY ShaderBinaryContextANGLE(GLeglContext ctx,
                                          GLsizei count,
                                          const GLuint *shaders,
                                          GLenum binaryformat,
                                          const void *binary,
                                          GLsizei length)
{
    EVENT("(GLsizei count = %d, const GLuint *shaders = 0x%016" PRIxPTR
          ", GLenum binaryformat = 0x%X, const void *binary = 0x%016" PRIxPTR
          ", GLsizei length = %d)",
          count, (uintptr_t)shaders, binaryformat, (uintptr_t)binary, length);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ShaderBinary, context, count, shaders, binaryformat, binary, length);
        if (context->skipValidation() ||
            ValidateShaderBinary(context, count, shaders, binaryformat, binary, length))
        {
            context->shaderBinary(count, shaders, binaryformat, binary, length);
        }
    }
}

void GL_APIENTRY ShaderSourceContextANGLE(GLeglContext ctx,
                                          GLuint shader,
                                          GLsizei count,
                                          const GLchar *const *string,
                                          const GLint *length)
{
    EVENT("(GLuint shader = %u, GLsizei count = %d, const GLchar *const*string = 0x%016" PRIxPTR
          ", const GLint *length = 0x%016" PRIxPTR ")",
          shader, count, (uintptr_t)string, (uintptr_t)length);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ShaderSource, context, shader, count, string, length);
        if (context->skipValidation() ||
            ValidateShaderSource(context, shader, count, string, length))
        {
            context->shaderSource(shader, count, string, length);
        }
    }
}

void GL_APIENTRY SignalSemaphoreEXTContextANGLE(GLeglContext ctx,
                                                GLuint semaphore,
                                                GLuint numBufferBarriers,
                                                const GLuint *buffers,
                                                GLuint numTextureBarriers,
                                                const GLuint *textures,
                                                const GLenum *dstLayouts)
{
    EVENT(
        "(GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint *buffers = "
        "0x%016" PRIxPTR ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
        ", const GLenum *dstLayouts = 0x%016" PRIxPTR ")",
        semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers, (uintptr_t)textures,
        (uintptr_t)dstLayouts);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SignalSemaphoreEXT, context, semaphore, numBufferBarriers, buffers,
                      numTextureBarriers, textures, dstLayouts);
        if (context->skipValidation() ||
            ValidateSignalSemaphoreEXT(context, semaphore, numBufferBarriers, buffers,
                                       numTextureBarriers, textures, dstLayouts))
        {
            context->signalSemaphore(semaphore, numBufferBarriers, buffers, numTextureBarriers,
                                     textures, dstLayouts);
        }
    }
}

void GL_APIENTRY StencilFuncContextANGLE(GLeglContext ctx, GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilFunc, context, func, ref, mask);
        if (context->skipValidation() || ValidateStencilFunc(context, func, ref, mask))
        {
            context->stencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY
StencilFuncSeparateContextANGLE(GLeglContext ctx, GLenum face, GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", face, func,
          ref, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilFuncSeparate, context, face, func, ref, mask);
        if (context->skipValidation() ||
            ValidateStencilFuncSeparate(context, face, func, ref, mask))
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMaskContextANGLE(GLeglContext ctx, GLuint mask)
{
    EVENT("(GLuint mask = %u)", mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilMask, context, mask);
        if (context->skipValidation() || ValidateStencilMask(context, mask))
        {
            context->stencilMask(mask);
        }
    }
}

void GL_APIENTRY StencilMaskSeparateContextANGLE(GLeglContext ctx, GLenum face, GLuint mask)
{
    EVENT("(GLenum face = 0x%X, GLuint mask = %u)", face, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilMaskSeparate, context, face, mask);
        if (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask))
        {
            context->stencilMaskSeparate(face, mask);
        }
    }
}

void GL_APIENTRY StencilOpContextANGLE(GLeglContext ctx, GLenum fail, GLenum zfail, GLenum zpass)
{
    EVENT("(GLenum fail = 0x%X, GLenum zfail = 0x%X, GLenum zpass = 0x%X)", fail, zfail, zpass);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilOp, context, fail, zfail, zpass);
        if (context->skipValidation() || ValidateStencilOp(context, fail, zfail, zpass))
        {
            context->stencilOp(fail, zfail, zpass);
        }
    }
}

void GL_APIENTRY StencilOpSeparateContextANGLE(GLeglContext ctx,
                                               GLenum face,
                                               GLenum sfail,
                                               GLenum dpfail,
                                               GLenum dppass)
{
    EVENT("(GLenum face = 0x%X, GLenum sfail = 0x%X, GLenum dpfail = 0x%X, GLenum dppass = 0x%X)",
          face, sfail, dpfail, dppass);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilOpSeparate, context, face, sfail, dpfail, dppass);
        if (context->skipValidation() ||
            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass))
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
    }
}

GLboolean GL_APIENTRY TestFenceNVContextANGLE(GLeglContext ctx, GLuint fence)
{
    EVENT("(GLuint fence = %u)", fence);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TestFenceNV, context, fence);
        if (context->skipValidation() || ValidateTestFenceNV(context, fence))
        {
            return context->testFenceNV(fence);
        }
    }

    return GetDefaultReturnValue<EntryPoint::TestFenceNV, GLboolean>();
}

void GL_APIENTRY TexCoordPointerContextANGLE(GLeglContext ctx,
                                             GLint size,
                                             GLenum type,
                                             GLsizei stride,
                                             const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(TexCoordPointer, context, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateTexCoordPointer(context, size, typePacked, stride, pointer))
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY TexEnvfContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvf, context, targetPacked, pnamePacked, param);
        if (context->skipValidation() || ValidateTexEnvf(context, targetPacked, pnamePacked, param))
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvfvContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvfv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexEnviContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvi, context, targetPacked, pnamePacked, param);
        if (context->skipValidation() || ValidateTexEnvi(context, targetPacked, pnamePacked, param))
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvivContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnviv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexEnvxContextANGLE(GLeglContext ctx, GLenum target, GLenum pname, GLfixed param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvx, context, targetPacked, pnamePacked, param);
        if (context->skipValidation() || ValidateTexEnvx(context, targetPacked, pnamePacked, param))
        {
            context->texEnvx(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvxvContextANGLE(GLeglContext ctx,
                                      GLenum target,
                                      GLenum pname,
                                      const GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        ANGLE_CAPTURE(TexEnvxv, context, targetPacked, pnamePacked, params);
        if (context->skipValidation() ||
            ValidateTexEnvxv(context, targetPacked, pnamePacked, params))
        {
            context->texEnvxv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexGenfOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLfloat param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", coord, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGenfOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGenfOES(context, coord, pname, param))
        {
            context->texGenf(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenfvOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLfloat *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGenfvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenfvOES(context, coord, pname, params))
        {
            context->texGenfv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGeniOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLint param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLint param = %d)", coord, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGeniOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGeniOES(context, coord, pname, param))
        {
            context->texGeni(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenivOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLint *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGenivOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenivOES(context, coord, pname, params))
        {
            context->texGeniv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexGenxOESContextANGLE(GLeglContext ctx, GLenum coord, GLenum pname, GLfixed param)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", coord, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGenxOES, context, coord, pname, param);
        if (context->skipValidation() || ValidateTexGenxOES(context, coord, pname, param))
        {
            context->texGenx(coord, pname, param);
        }
    }
}

void GL_APIENTRY TexGenxvOESContextANGLE(GLeglContext ctx,
                                         GLenum coord,
                                         GLenum pname,
                                         const GLfixed *params)
{
    EVENT("(GLenum coord = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          coord, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexGenxvOES, context, coord, pname, params);
        if (context->skipValidation() || ValidateTexGenxvOES(context, coord, pname, params))
        {
            context->texGenxv(coord, pname, params);
        }
    }
}

void GL_APIENTRY TexImage2DContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLint level,
                                        GLint internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLenum format,
                                        GLenum type,
                                        const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, const "
        "void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, format, type, (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2D, context, targetPacked, level, internalformat, width, height,
                      border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage2D(context, targetPacked, level, internalformat, width, height, border,
                               format, type, pixels))
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
    }
}

void GL_APIENTRY TexImage3DContextANGLE(GLeglContext ctx,
                                        GLenum target,
                                        GLint level,
                                        GLint internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLint border,
                                        GLenum format,
                                        GLenum type,
                                        const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, GLenum "
        "type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3D, context, targetPacked, level, internalformat, width, height,
                      depth, border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3D(context, targetPacked, level, internalformat, width, height, depth,
                               border, format, type, pixels))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
    }
}

void GL_APIENTRY TexImage3DOESContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, "
        "GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3DOES, context, targetPacked, level, internalformat, width, height,
                      depth, border, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3DOES(context, targetPacked, level, internalformat, width, height,
                                  depth, border, format, type, pixels))
        {
            context->texImage3D(targetPacked, level, internalformat, width, height, depth, border,
                                format, type, pixels);
        }
    }
}

void GL_APIENTRY TexParameterIivOESContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLenum pname,
                                                const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIivOES(context, targetPacked, pname, params))
        {
            context->texParameterIiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterIuivOESContextANGLE(GLeglContext ctx,
                                                 GLenum target,
                                                 GLenum pname,
                                                 const GLuint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLuint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIuivOES, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterIuivOES(context, targetPacked, pname, params))
        {
            context->texParameterIuiv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterfContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterf, context, targetPacked, pname, param);
        if (context->skipValidation() || ValidateTexParameterf(context, targetPacked, pname, param))
        {
            context->texParameterf(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterfvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterfv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterfv(context, targetPacked, pname, params))
        {
            context->texParameterfv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameteriContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameteri, context, targetPacked, pname, param);
        if (context->skipValidation() || ValidateTexParameteri(context, targetPacked, pname, param))
        {
            context->texParameteri(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterivContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameteriv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameteriv(context, targetPacked, pname, params))
        {
            context->texParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterxContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLenum pname,
                                           GLfixed param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterx, context, targetPacked, pname, param);
        if (context->skipValidation() || ValidateTexParameterx(context, targetPacked, pname, param))
        {
            context->texParameterx(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterxvContextANGLE(GLeglContext ctx,
                                            GLenum target,
                                            GLenum pname,
                                            const GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterxv, context, targetPacked, pname, params);
        if (context->skipValidation() ||
            ValidateTexParameterxv(context, targetPacked, pname, params))
        {
            context->texParameterxv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY TexStorage1DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d)",
        target, levels, internalformat, width);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TexStorage1DEXT, context, target, levels, internalformat, width);
        if (context->skipValidation() ||
            ValidateTexStorage1DEXT(context, target, levels, internalformat, width))
        {
            context->texStorage1D(target, levels, internalformat, width);
        }
    }
}

void GL_APIENTRY TexStorage2DContextANGLE(GLeglContext ctx,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d)",
        target, levels, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2D, context, targetPacked, levels, internalformat, width, height);
        if (context->skipValidation() ||
            ValidateTexStorage2D(context, targetPacked, levels, internalformat, width, height))
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexStorage2DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d)",
        target, levels, internalformat, width, height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2DEXT, context, targetPacked, levels, internalformat, width,
                      height);
        if (context->skipValidation() ||
            ValidateTexStorage2DEXT(context, targetPacked, levels, internalformat, width, height))
        {
            context->texStorage2D(targetPacked, levels, internalformat, width, height);
        }
    }
}

void GL_APIENTRY TexStorage2DMultisampleContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, fixedsamplelocations);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2DMultisample, context, targetPacked, samples, internalformat,
                      width, height, fixedsamplelocations);
        if (context->skipValidation() ||
            ValidateTexStorage2DMultisample(context, targetPacked, samples, internalformat, width,
                                            height, fixedsamplelocations))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
    }
}

void GL_APIENTRY TexStorage3DContextANGLE(GLeglContext ctx,
                                          GLenum target,
                                          GLsizei levels,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLsizei depth)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d)",
        target, levels, internalformat, width, height, depth);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3D, context, targetPacked, levels, internalformat, width, height,
                      depth);
        if (context->skipValidation() || ValidateTexStorage3D(context, targetPacked, levels,
                                                              internalformat, width, height, depth))
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
    }
}

void GL_APIENTRY TexStorage3DEXTContextANGLE(GLeglContext ctx,
                                             GLenum target,
                                             GLsizei levels,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d)",
        target, levels, internalformat, width, height, depth);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3DEXT, context, targetPacked, levels, internalformat, width, height,
                      depth);
        if (context->skipValidation() ||
            ValidateTexStorage3DEXT(context, targetPacked, levels, internalformat, width, height,
                                    depth))
        {
            context->texStorage3D(targetPacked, levels, internalformat, width, height, depth);
        }
    }
}

void GL_APIENTRY TexStorage3DMultisampleOESContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLsizei samples,
                                                        GLenum internalformat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLsizei depth = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, depth, fixedsamplelocations);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage3DMultisampleOES, context, targetPacked, samples, internalformat,
                      width, height, depth, fixedsamplelocations);
        if (context->skipValidation() ||
            ValidateTexStorage3DMultisampleOES(context, targetPacked, samples, internalformat,
                                               width, height, depth, fixedsamplelocations))
        {
            context->texStorage3DMultisample(targetPacked, samples, internalformat, width, height,
                                             depth, fixedsamplelocations);
        }
    }
}

void GL_APIENTRY TexStorageMem2DEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLsizei levels,
                                                GLenum internalFormat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLuint memory,
                                                GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalFormat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLuint memory = %u, GLuint64 offset = %llu)",
        target, levels, internalFormat, width, height, memory,
        static_cast<unsigned long long>(offset));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem2DEXT, context, targetPacked, levels, internalFormat, width,
                      height, memory, offset);
        if (context->skipValidation() ||
            ValidateTexStorageMem2DEXT(context, targetPacked, levels, internalFormat, width, height,
                                       memory, offset))
        {
            context->texStorageMem2D(targetPacked, levels, internalFormat, width, height, memory,
                                     offset);
        }
    }
}

void GL_APIENTRY TexStorageMem2DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLsizei samples,
                                                           GLenum internalFormat,
                                                           GLsizei width,
                                                           GLsizei height,
                                                           GLboolean fixedSampleLocations,
                                                           GLuint memory,
                                                           GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalFormat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedSampleLocations = %u, GLuint memory = %u, "
        "GLuint64 offset = %llu)",
        target, samples, internalFormat, width, height, fixedSampleLocations, memory,
        static_cast<unsigned long long>(offset));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem2DMultisampleEXT, context, targetPacked, samples, internalFormat,
                      width, height, fixedSampleLocations, memory, offset);
        if (context->skipValidation() || ValidateTexStorageMem2DMultisampleEXT(
                                             context, targetPacked, samples, internalFormat, width,
                                             height, fixedSampleLocations, memory, offset))
        {
            context->texStorageMem2DMultisample(targetPacked, samples, internalFormat, width,
                                                height, fixedSampleLocations, memory, offset);
        }
    }
}

void GL_APIENTRY TexStorageMem3DEXTContextANGLE(GLeglContext ctx,
                                                GLenum target,
                                                GLsizei levels,
                                                GLenum internalFormat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLuint memory,
                                                GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei levels = %d, GLenum internalFormat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLuint memory = %u, GLuint64 offset = %llu)",
        target, levels, internalFormat, width, height, depth, memory,
        static_cast<unsigned long long>(offset));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem3DEXT, context, targetPacked, levels, internalFormat, width,
                      height, depth, memory, offset);
        if (context->skipValidation() ||
            ValidateTexStorageMem3DEXT(context, targetPacked, levels, internalFormat, width, height,
                                       depth, memory, offset))
        {
            context->texStorageMem3D(targetPacked, levels, internalFormat, width, height, depth,
                                     memory, offset);
        }
    }
}

void GL_APIENTRY TexStorageMem3DMultisampleEXTContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLsizei samples,
                                                           GLenum internalFormat,
                                                           GLsizei width,
                                                           GLsizei height,
                                                           GLsizei depth,
                                                           GLboolean fixedSampleLocations,
                                                           GLuint memory,
                                                           GLuint64 offset)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalFormat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLsizei depth = %d, GLboolean fixedSampleLocations = %u, "
        "GLuint memory = %u, GLuint64 offset = %llu)",
        target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory,
        static_cast<unsigned long long>(offset));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorageMem3DMultisampleEXT, context, targetPacked, samples, internalFormat,
                      width, height, depth, fixedSampleLocations, memory, offset);
        if (context->skipValidation() || ValidateTexStorageMem3DMultisampleEXT(
                                             context, targetPacked, samples, internalFormat, width,
                                             height, depth, fixedSampleLocations, memory, offset))
        {
            context->texStorageMem3DMultisample(targetPacked, samples, internalFormat, width,
                                                height, depth, fixedSampleLocations, memory,
                                                offset);
        }
    }
}

void GL_APIENTRY TexSubImage2DContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, const void "
        "*pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, type, (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage2D, context, targetPacked, level, xoffset, yoffset, width, height,
                      format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage2D(context, targetPacked, level, xoffset, yoffset, width, height,
                                  format, type, pixels))
        {
            context->texSubImage2D(targetPacked, level, xoffset, yoffset, width, height, format,
                                   type, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3DContextANGLE(GLeglContext ctx,
                                           GLenum target,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint zoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLenum format,
                                           GLenum type,
                                           const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3D, context, targetPacked, level, xoffset, yoffset, zoffset, width,
                      height, depth, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3D(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                  height, depth, format, type, pixels))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3DOESContextANGLE(GLeglContext ctx,
                                              GLenum target,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLenum type,
                                              const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, const void *pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3DOES, context, targetPacked, level, xoffset, yoffset, zoffset,
                      width, height, depth, format, type, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3DOES(context, targetPacked, level, xoffset, yoffset, zoffset, width,
                                     height, depth, format, type, pixels))
        {
            context->texSubImage3D(targetPacked, level, xoffset, yoffset, zoffset, width, height,
                                   depth, format, type, pixels);
        }
    }
}

void GL_APIENTRY TransformFeedbackVaryingsContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLsizei count,
                                                       const GLchar *const *varyings,
                                                       GLenum bufferMode)
{
    EVENT("(GLuint program = %u, GLsizei count = %d, const GLchar *const*varyings = 0x%016" PRIxPTR
          ", GLenum bufferMode = 0x%X)",
          program, count, (uintptr_t)varyings, bufferMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(TransformFeedbackVaryings, context, program, count, varyings, bufferMode);
        if (context->skipValidation() ||
            ValidateTransformFeedbackVaryings(context, program, count, varyings, bufferMode))
        {
            context->transformFeedbackVaryings(program, count, varyings, bufferMode);
        }
    }
}

void GL_APIENTRY TranslatefContextANGLE(GLeglContext ctx, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Translatef, context, x, y, z);
        if (context->skipValidation() || ValidateTranslatef(context, x, y, z))
        {
            context->translatef(x, y, z);
        }
    }
}

void GL_APIENTRY TranslatexContextANGLE(GLeglContext ctx, GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Translatex, context, x, y, z);
        if (context->skipValidation() || ValidateTranslatex(context, x, y, z))
        {
            context->translatex(x, y, z);
        }
    }
}

void GL_APIENTRY Uniform1fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f)", location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1f, context, location, v0);
        if (context->skipValidation() || ValidateUniform1f(context, location, v0))
        {
            context->uniform1f(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1fv(context, location, count, value))
        {
            context->uniform1fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform1iContextANGLE(GLeglContext ctx, GLint location, GLint v0)
{
    EVENT("(GLint location = %d, GLint v0 = %d)", location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1i, context, location, v0);
        if (context->skipValidation() || ValidateUniform1i(context, location, v0))
        {
            context->uniform1i(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1iv(context, location, count, value))
        {
            context->uniform1iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform1uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0)
{
    EVENT("(GLint location = %d, GLuint v0 = %u)", location, v0);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1ui, context, location, v0);
        if (context->skipValidation() || ValidateUniform1ui(context, location, v0))
        {
            context->uniform1ui(location, v0);
        }
    }
}

void GL_APIENTRY Uniform1uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform1uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform1uiv(context, location, count, value))
        {
            context->uniform1uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0, GLfloat v1)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2f, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2f(context, location, v0, v1))
        {
            context->uniform2f(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2fv(context, location, count, value))
        {
            context->uniform2fv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d)", location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2i, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2i(context, location, v0, v1))
        {
            context->uniform2i(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2iv(context, location, count, value))
        {
            context->uniform2iv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform2uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u)", location, v0, v1);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2ui, context, location, v0, v1);
        if (context->skipValidation() || ValidateUniform2ui(context, location, v0, v1))
        {
            context->uniform2ui(location, v0, v1);
        }
    }
}

void GL_APIENTRY Uniform2uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform2uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform2uiv(context, location, count, value))
        {
            context->uniform2uiv(location, count, value);
        }
    }
}

void GL_APIENTRY
Uniform3fContextANGLE(GLeglContext ctx, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    EVENT("(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f)", location, v0,
          v1, v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3f, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3f(context, location, v0, v1, v2))
        {
            context->uniform3f(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3fv(context, location, count, value))
        {
            context->uniform3fv(location, count, value);
        }
    }
}

void GL_APIENTRY
Uniform3iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1, GLint v2)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)", location, v0, v1,
          v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3i, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3i(context, location, v0, v1, v2))
        {
            context->uniform3i(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3iv(context, location, count, value))
        {
            context->uniform3iv(location, count, value);
        }
    }
}

void GL_APIENTRY
Uniform3uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u)", location, v0, v1,
          v2);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3ui, context, location, v0, v1, v2);
        if (context->skipValidation() || ValidateUniform3ui(context, location, v0, v1, v2))
        {
            context->uniform3ui(location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY Uniform3uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform3uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform3uiv(context, location, count, value))
        {
            context->uniform3uiv(location, count, value);
        }
    }
}

void GL_APIENTRY Uniform4fContextANGLE(GLeglContext ctx,
                                       GLint location,
                                       GLfloat v0,
                                       GLfloat v1,
                                       GLfloat v2,
                                       GLfloat v3)
{
    EVENT(
        "(GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = %f, GLfloat v3 = %f)",
        location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4f, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4f(context, location, v0, v1, v2, v3))
        {
            context->uniform4f(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4fvContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLfloat *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLfloat *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4fv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4fv(context, location, count, value))
        {
            context->uniform4fv(location, count, value);
        }
    }
}

void GL_APIENTRY
Uniform4iContextANGLE(GLeglContext ctx, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    EVENT("(GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, GLint v3 = %d)",
          location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4i, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4i(context, location, v0, v1, v2, v3))
        {
            context->uniform4i(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4ivContextANGLE(GLeglContext ctx,
                                        GLint location,
                                        GLsizei count,
                                        const GLint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4iv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4iv(context, location, count, value))
        {
            context->uniform4iv(location, count, value);
        }
    }
}

void GL_APIENTRY
Uniform4uiContextANGLE(GLeglContext ctx, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    EVENT("(GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = %u, GLuint v3 = %u)",
          location, v0, v1, v2, v3);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4ui, context, location, v0, v1, v2, v3);
        if (context->skipValidation() || ValidateUniform4ui(context, location, v0, v1, v2, v3))
        {
            context->uniform4ui(location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY Uniform4uivContextANGLE(GLeglContext ctx,
                                         GLint location,
                                         GLsizei count,
                                         const GLuint *value)
{
    EVENT("(GLint location = %d, GLsizei count = %d, const GLuint *value = 0x%016" PRIxPTR ")",
          location, count, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Uniform4uiv, context, location, count, value);
        if (context->skipValidation() || ValidateUniform4uiv(context, location, count, value))
        {
            context->uniform4uiv(location, count, value);
        }
    }
}

void GL_APIENTRY UniformBlockBindingContextANGLE(GLeglContext ctx,
                                                 GLuint program,
                                                 GLuint uniformBlockIndex,
                                                 GLuint uniformBlockBinding)
{
    EVENT("(GLuint program = %u, GLuint uniformBlockIndex = %u, GLuint uniformBlockBinding = %u)",
          program, uniformBlockIndex, uniformBlockBinding);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformBlockBinding, context, program, uniformBlockIndex,
                      uniformBlockBinding);
        if (context->skipValidation() ||
            ValidateUniformBlockBinding(context, program, uniformBlockIndex, uniformBlockBinding))
        {
            context->uniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
        }
    }
}

void GL_APIENTRY UniformMatrix2fvContextANGLE(GLeglContext ctx,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2x3fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix2x3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2x3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2x3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix2x4fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix2x4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix2x4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix2x4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3fvContextANGLE(GLeglContext ctx,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3x2fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix3x2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3x2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3x2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix3x4fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix3x4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix3x4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix3x4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4fvContextANGLE(GLeglContext ctx,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix4fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4x2fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix4x2fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4x2fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4x2fv(location, count, transpose, value);
        }
    }
}

void GL_APIENTRY UniformMatrix4x3fvContextANGLE(GLeglContext ctx,
                                                GLint location,
                                                GLsizei count,
                                                GLboolean transpose,
                                                const GLfloat *value)
{
    EVENT(
        "(GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, const GLfloat *value "
        "= 0x%016" PRIxPTR ")",
        location, count, transpose, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UniformMatrix4x3fv, context, location, count, transpose, value);
        if (context->skipValidation() ||
            ValidateUniformMatrix4x3fv(context, location, count, transpose, value))
        {
            context->uniformMatrix4x3fv(location, count, transpose, value);
        }
    }
}

GLboolean GL_APIENTRY UnmapBufferContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(UnmapBuffer, context, targetPacked);
        if (context->skipValidation() || ValidateUnmapBuffer(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBuffer, GLboolean>();
}

GLboolean GL_APIENTRY UnmapBufferOESContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(UnmapBufferOES, context, targetPacked);
        if (context->skipValidation() || ValidateUnmapBufferOES(context, targetPacked))
        {
            return context->unmapBuffer(targetPacked);
        }
    }

    return GetDefaultReturnValue<EntryPoint::UnmapBufferOES, GLboolean>();
}

void GL_APIENTRY UseProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UseProgram, context, program);
        if (context->skipValidation() || ValidateUseProgram(context, program))
        {
            context->useProgram(program);
        }
    }
}

void GL_APIENTRY UseProgramStagesContextANGLE(GLeglContext ctx,
                                              GLuint pipeline,
                                              GLbitfield stages,
                                              GLuint program)
{
    EVENT("(GLuint pipeline = %u, GLbitfield stages = 0x%X, GLuint program = %u)", pipeline, stages,
          program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(UseProgramStages, context, pipeline, stages, program);
        if (context->skipValidation() ||
            ValidateUseProgramStages(context, pipeline, stages, program))
        {
            context->useProgramStages(pipeline, stages, program);
        }
    }
}

void GL_APIENTRY ValidateProgramContextANGLE(GLeglContext ctx, GLuint program)
{
    EVENT("(GLuint program = %u)", program);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ValidateProgram, context, program);
        if (context->skipValidation() || ValidateValidateProgram(context, program))
        {
            context->validateProgram(program);
        }
    }
}

void GL_APIENTRY ValidateProgramPipelineContextANGLE(GLeglContext ctx, GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ValidateProgramPipeline, context, pipeline);
        if (context->skipValidation() || ValidateValidateProgramPipeline(context, pipeline))
        {
            context->validateProgramPipeline(pipeline);
        }
    }
}

void GL_APIENTRY VertexAttrib1fContextANGLE(GLeglContext ctx, GLuint index, GLfloat x)
{
    EVENT("(GLuint index = %u, GLfloat x = %f)", index, x);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib1f, context, index, x);
        if (context->skipValidation() || ValidateVertexAttrib1f(context, index, x))
        {
            context->vertexAttrib1f(index, x);
        }
    }
}

void GL_APIENTRY VertexAttrib1fvContextANGLE(GLeglContext ctx, GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib1fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v))
        {
            context->vertexAttrib1fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib2fContextANGLE(GLeglContext ctx, GLuint index, GLfloat x, GLfloat y)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f)", index, x, y);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib2f, context, index, x, y);
        if (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y))
        {
            context->vertexAttrib2f(index, x, y);
        }
    }
}

void GL_APIENTRY VertexAttrib2fvContextANGLE(GLeglContext ctx, GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib2fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v))
        {
            context->vertexAttrib2fv(index, v);
        }
    }
}

void GL_APIENTRY
VertexAttrib3fContextANGLE(GLeglContext ctx, GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", index, x, y, z);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib3f, context, index, x, y, z);
        if (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z))
        {
            context->vertexAttrib3f(index, x, y, z);
        }
    }
}

void GL_APIENTRY VertexAttrib3fvContextANGLE(GLeglContext ctx, GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib3fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v))
        {
            context->vertexAttrib3fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttrib4fContextANGLE(GLeglContext ctx,
                                            GLuint index,
                                            GLfloat x,
                                            GLfloat y,
                                            GLfloat z,
                                            GLfloat w)
{
    EVENT("(GLuint index = %u, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f, GLfloat w = %f)",
          index, x, y, z, w);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib4f, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w))
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttrib4fvContextANGLE(GLeglContext ctx, GLuint index, const GLfloat *v)
{
    EVENT("(GLuint index = %u, const GLfloat *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttrib4fv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v))
        {
            context->vertexAttrib4fv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribBindingContextANGLE(GLeglContext ctx,
                                                 GLuint attribindex,
                                                 GLuint bindingindex)
{
    EVENT("(GLuint attribindex = %u, GLuint bindingindex = %u)", attribindex, bindingindex);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribBinding, context, attribindex, bindingindex);
        if (context->skipValidation() ||
            ValidateVertexAttribBinding(context, attribindex, bindingindex))
        {
            context->vertexAttribBinding(attribindex, bindingindex);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorContextANGLE(GLeglContext ctx, GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribDivisor, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisor(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorANGLEContextANGLE(GLeglContext ctx,
                                                      GLuint index,
                                                      GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribDivisorANGLE, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisorANGLE(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

void GL_APIENTRY VertexAttribDivisorEXTContextANGLE(GLeglContext ctx, GLuint index, GLuint divisor)
{
    EVENT("(GLuint index = %u, GLuint divisor = %u)", index, divisor);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribDivisorEXT, context, index, divisor);
        if (context->skipValidation() || ValidateVertexAttribDivisorEXT(context, index, divisor))
        {
            context->vertexAttribDivisor(index, divisor);
        }
    }
}

void GL_APIENTRY VertexAttribFormatContextANGLE(GLeglContext ctx,
                                                GLuint attribindex,
                                                GLint size,
                                                GLenum type,
                                                GLboolean normalized,
                                                GLuint relativeoffset)
{
    EVENT(
        "(GLuint attribindex = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLuint relativeoffset = %u)",
        attribindex, size, type, normalized, relativeoffset);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribFormat, context, attribindex, size, typePacked, normalized,
                      relativeoffset);
        if (context->skipValidation() ||
            ValidateVertexAttribFormat(context, attribindex, size, typePacked, normalized,
                                       relativeoffset))
        {
            context->vertexAttribFormat(attribindex, size, typePacked, normalized, relativeoffset);
        }
    }
}

void GL_APIENTRY
VertexAttribI4iContextANGLE(GLeglContext ctx, GLuint index, GLint x, GLint y, GLint z, GLint w)
{
    EVENT("(GLuint index = %u, GLint x = %d, GLint y = %d, GLint z = %d, GLint w = %d)", index, x,
          y, z, w);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribI4i, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4i(context, index, x, y, z, w))
        {
            context->vertexAttribI4i(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4ivContextANGLE(GLeglContext ctx, GLuint index, const GLint *v)
{
    EVENT("(GLuint index = %u, const GLint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribI4iv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4iv(context, index, v))
        {
            context->vertexAttribI4iv(index, v);
        }
    }
}

void GL_APIENTRY
VertexAttribI4uiContextANGLE(GLeglContext ctx, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
    EVENT("(GLuint index = %u, GLuint x = %u, GLuint y = %u, GLuint z = %u, GLuint w = %u)", index,
          x, y, z, w);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribI4ui, context, index, x, y, z, w);
        if (context->skipValidation() || ValidateVertexAttribI4ui(context, index, x, y, z, w))
        {
            context->vertexAttribI4ui(index, x, y, z, w);
        }
    }
}

void GL_APIENTRY VertexAttribI4uivContextANGLE(GLeglContext ctx, GLuint index, const GLuint *v)
{
    EVENT("(GLuint index = %u, const GLuint *v = 0x%016" PRIxPTR ")", index, (uintptr_t)v);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexAttribI4uiv, context, index, v);
        if (context->skipValidation() || ValidateVertexAttribI4uiv(context, index, v))
        {
            context->vertexAttribI4uiv(index, v);
        }
    }
}

void GL_APIENTRY VertexAttribIFormatContextANGLE(GLeglContext ctx,
                                                 GLuint attribindex,
                                                 GLint size,
                                                 GLenum type,
                                                 GLuint relativeoffset)
{
    EVENT(
        "(GLuint attribindex = %u, GLint size = %d, GLenum type = 0x%X, GLuint relativeoffset = "
        "%u)",
        attribindex, size, type, relativeoffset);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribIFormat, context, attribindex, size, typePacked, relativeoffset);
        if (context->skipValidation() ||
            ValidateVertexAttribIFormat(context, attribindex, size, typePacked, relativeoffset))
        {
            context->vertexAttribIFormat(attribindex, size, typePacked, relativeoffset);
        }
    }
}

void GL_APIENTRY VertexAttribIPointerContextANGLE(GLeglContext ctx,
                                                  GLuint index,
                                                  GLint size,
                                                  GLenum type,
                                                  GLsizei stride,
                                                  const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void "
        "*pointer = 0x%016" PRIxPTR ")",
        index, size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribIPointer, context, index, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateVertexAttribIPointer(context, index, size, typePacked, stride, pointer))
        {
            context->vertexAttribIPointer(index, size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY VertexAttribPointerContextANGLE(GLeglContext ctx,
                                                 GLuint index,
                                                 GLint size,
                                                 GLenum type,
                                                 GLboolean normalized,
                                                 GLsizei stride,
                                                 const void *pointer)
{
    EVENT(
        "(GLuint index = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
        index, size, type, normalized, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexAttribPointer, context, index, size, typePacked, normalized, stride,
                      pointer);
        if (context->skipValidation() ||
            ValidateVertexAttribPointer(context, index, size, typePacked, normalized, stride,
                                        pointer))
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
    }
}

void GL_APIENTRY VertexBindingDivisorContextANGLE(GLeglContext ctx,
                                                  GLuint bindingindex,
                                                  GLuint divisor)
{
    EVENT("(GLuint bindingindex = %u, GLuint divisor = %u)", bindingindex, divisor);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(VertexBindingDivisor, context, bindingindex, divisor);
        if (context->skipValidation() ||
            ValidateVertexBindingDivisor(context, bindingindex, divisor))
        {
            context->vertexBindingDivisor(bindingindex, divisor);
        }
    }
}

void GL_APIENTRY VertexPointerContextANGLE(GLeglContext ctx,
                                           GLint size,
                                           GLenum type,
                                           GLsizei stride,
                                           const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        ANGLE_CAPTURE(VertexPointer, context, size, typePacked, stride, pointer);
        if (context->skipValidation() ||
            ValidateVertexPointer(context, size, typePacked, stride, pointer))
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY
ViewportContextANGLE(GLeglContext ctx, GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(Viewport, context, x, y, width, height);
        if (context->skipValidation() || ValidateViewport(context, x, y, width, height))
        {
            context->viewport(x, y, width, height);
        }
    }
}

void GL_APIENTRY WaitSemaphoreEXTContextANGLE(GLeglContext ctx,
                                              GLuint semaphore,
                                              GLuint numBufferBarriers,
                                              const GLuint *buffers,
                                              GLuint numTextureBarriers,
                                              const GLuint *textures,
                                              const GLenum *srcLayouts)
{
    EVENT(
        "(GLuint semaphore = %u, GLuint numBufferBarriers = %u, const GLuint *buffers = "
        "0x%016" PRIxPTR ", GLuint numTextureBarriers = %u, const GLuint *textures = 0x%016" PRIxPTR
        ", const GLenum *srcLayouts = 0x%016" PRIxPTR ")",
        semaphore, numBufferBarriers, (uintptr_t)buffers, numTextureBarriers, (uintptr_t)textures,
        (uintptr_t)srcLayouts);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(WaitSemaphoreEXT, context, semaphore, numBufferBarriers, buffers,
                      numTextureBarriers, textures, srcLayouts);
        if (context->skipValidation() ||
            ValidateWaitSemaphoreEXT(context, semaphore, numBufferBarriers, buffers,
                                     numTextureBarriers, textures, srcLayouts))
        {
            context->waitSemaphore(semaphore, numBufferBarriers, buffers, numTextureBarriers,
                                   textures, srcLayouts);
        }
    }
}

void GL_APIENTRY WaitSyncContextANGLE(GLeglContext ctx,
                                      GLsync sync,
                                      GLbitfield flags,
                                      GLuint64 timeout)
{
    EVENT("(GLsync sync = 0x%016" PRIxPTR ", GLbitfield flags = 0x%X, GLuint64 timeout = %llu)",
          (uintptr_t)sync, flags, static_cast<unsigned long long>(timeout));

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(WaitSync, context, sync, flags, timeout);
        if (context->skipValidation() || ValidateWaitSync(context, sync, flags, timeout))
        {
            context->waitSync(sync, flags, timeout);
        }
    }
}

void GL_APIENTRY WeightPointerOESContextANGLE(GLeglContext ctx,
                                              GLint size,
                                              GLenum type,
                                              GLsizei stride,
                                              const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(WeightPointerOES, context, size, type, stride, pointer);
        if (context->skipValidation() ||
            ValidateWeightPointerOES(context, size, type, stride, pointer))
        {
            context->weightPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY BindUniformLocationCHROMIUMContextANGLE(GLeglContext ctx,
                                                         GLuint program,
                                                         GLint location,
                                                         const GLchar *name)
{
    EVENT("(GLuint program = %u, GLint location = %d, const GLchar* name = 0x%016" PRIxPTR ")",
          program, location, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindUniformLocationCHROMIUM, context, program, location, name);
        if (context->skipValidation() ||
            ValidateBindUniformLocationCHROMIUM(context, program, location, name))
        {
            context->bindUniformLocation(program, location, name);
        }
    }
}

void GL_APIENTRY CoverageModulationCHROMIUMContextANGLE(GLeglContext ctx, GLenum components)
{
    EVENT("(GLenum components = 0x%X)", components);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CoverageModulationCHROMIUM, context, components);
        if (context->skipValidation() || ValidateCoverageModulationCHROMIUM(context, components))
        {
            context->coverageModulation(components);
        }
    }
}

void GL_APIENTRY MatrixLoadfCHROMIUMContextANGLE(GLeglContext ctx,
                                                 GLenum matrixMode,
                                                 const GLfloat *matrix)
{
    EVENT("(GLenum matrixMode = 0x%X, const GLfloat * matrix = 0x%016" PRIxPTR ")", matrixMode,
          (uintptr_t)matrix);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MatrixLoadfCHROMIUM, context, matrixMode, matrix);
        if (context->skipValidation() || ValidateMatrixLoadfCHROMIUM(context, matrixMode, matrix))
        {
            context->matrixLoadf(matrixMode, matrix);
        }
    }
}

void GL_APIENTRY MatrixLoadIdentityCHROMIUMContextANGLE(GLeglContext ctx, GLenum matrixMode)
{
    EVENT("(GLenum matrixMode = 0x%X)", matrixMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(MatrixLoadIdentityCHROMIUM, context, matrixMode);
        if (context->skipValidation() || ValidateMatrixLoadIdentityCHROMIUM(context, matrixMode))
        {
            context->matrixLoadIdentity(matrixMode);
        }
    }
}

GLuint GL_APIENTRY GenPathsCHROMIUMContextANGLE(GLeglContext ctx, GLsizei range)
{
    EVENT("(GLsizei range = %d)", range);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GenPathsCHROMIUM, context, range);
        if (context->skipValidation() || ValidateGenPathsCHROMIUM(context, range))
        {
            return context->genPaths(range);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GenPathsCHROMIUM, GLuint>();
}

void GL_APIENTRY DeletePathsCHROMIUMContextANGLE(GLeglContext ctx, GLuint first, GLsizei range)
{
    EVENT("(GLuint first = %u, GLsizei range = %d)", first, range);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(DeletePathsCHROMIUM, context, first, range);
        if (context->skipValidation() || ValidateDeletePathsCHROMIUM(context, first, range))
        {
            context->deletePaths(first, range);
        }
    }
}

GLboolean GL_APIENTRY IsPathCHROMIUMContextANGLE(GLeglContext ctx, GLuint path)
{
    EVENT("(GLuint path = %u)", path);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(IsPathCHROMIUM, context, path);
        if (context->skipValidation() || ValidateIsPathCHROMIUM(context, path))
        {
            return context->isPath(path);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsPathCHROMIUM, GLboolean>();
}

void GL_APIENTRY PathCommandsCHROMIUMContextANGLE(GLeglContext ctx,
                                                  GLuint path,
                                                  GLsizei numCommands,
                                                  const GLubyte *commands,
                                                  GLsizei numCoords,
                                                  GLenum coordType,
                                                  const void *coords)
{
    EVENT("(GLuint path = %u, GLsizei numCommands = %d, const GLubyte * commands = 0x%016" PRIxPTR
          ", GLsizei numCoords = %d, GLenum coordType = 0x%X, const void* coords = 0x%016" PRIxPTR
          ")",
          path, numCommands, (uintptr_t)commands, numCoords, coordType, (uintptr_t)coords);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PathCommandsCHROMIUM, context, path, numCommands, commands, numCoords,
                      coordType, coords);
        if (context->skipValidation() ||
            ValidatePathCommandsCHROMIUM(context, path, numCommands, commands, numCoords, coordType,
                                         coords))
        {
            context->pathCommands(path, numCommands, commands, numCoords, coordType, coords);
        }
    }
}

void GL_APIENTRY PathParameterfCHROMIUMContextANGLE(GLeglContext ctx,
                                                    GLuint path,
                                                    GLenum pname,
                                                    GLfloat value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLfloat value = %f)", path, pname, value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PathParameterfCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidatePathParameterfCHROMIUM(context, path, pname, value))
        {
            context->pathParameterf(path, pname, value);
        }
    }
}

void GL_APIENTRY PathParameteriCHROMIUMContextANGLE(GLeglContext ctx,
                                                    GLuint path,
                                                    GLenum pname,
                                                    GLint value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLint value = %d)", path, pname, value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PathParameteriCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidatePathParameteriCHROMIUM(context, path, pname, value))
        {
            context->pathParameteri(path, pname, value);
        }
    }
}

void GL_APIENTRY GetPathParameterfvCHROMIUMContextANGLE(GLeglContext ctx,
                                                        GLuint path,
                                                        GLenum pname,
                                                        GLfloat *value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLfloat * value = 0x%016" PRIxPTR ")", path,
          pname, (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetPathParameterfvCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidateGetPathParameterfvCHROMIUM(context, path, pname, value))
        {
            context->getPathParameterfv(path, pname, value);
        }
    }
}

void GL_APIENTRY GetPathParameterivCHROMIUMContextANGLE(GLeglContext ctx,
                                                        GLuint path,
                                                        GLenum pname,
                                                        GLint *value)
{
    EVENT("(GLuint path = %u, GLenum pname = 0x%X, GLint * value = 0x%016" PRIxPTR ")", path, pname,
          (uintptr_t)value);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetPathParameterivCHROMIUM, context, path, pname, value);
        if (context->skipValidation() ||
            ValidateGetPathParameterivCHROMIUM(context, path, pname, value))
        {
            context->getPathParameteriv(path, pname, value);
        }
    }
}

void GL_APIENTRY PathStencilFuncCHROMIUMContextANGLE(GLeglContext ctx,
                                                     GLenum func,
                                                     GLint ref,
                                                     GLuint mask)
{
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(PathStencilFuncCHROMIUM, context, func, ref, mask);
        if (context->skipValidation() || ValidatePathStencilFuncCHROMIUM(context, func, ref, mask))
        {
            context->pathStencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilFillPathCHROMIUMContextANGLE(GLeglContext ctx,
                                                     GLuint path,
                                                     GLenum fillMode,
                                                     GLuint mask)
{
    EVENT("(GLuint path = %u, GLenum fillMode = 0x%X, GLuint mask = %u)", path, fillMode, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilFillPathCHROMIUM, context, path, fillMode, mask);
        if (context->skipValidation() ||
            ValidateStencilFillPathCHROMIUM(context, path, fillMode, mask))
        {
            context->stencilFillPath(path, fillMode, mask);
        }
    }
}

void GL_APIENTRY StencilStrokePathCHROMIUMContextANGLE(GLeglContext ctx,
                                                       GLuint path,
                                                       GLint reference,
                                                       GLuint mask)
{
    EVENT("(GLuint path = %u, GLint reference = %d, GLuint mask = %u)", path, reference, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilStrokePathCHROMIUM, context, path, reference, mask);
        if (context->skipValidation() ||
            ValidateStencilStrokePathCHROMIUM(context, path, reference, mask))
        {
            context->stencilStrokePath(path, reference, mask);
        }
    }
}

void GL_APIENTRY CoverFillPathCHROMIUMContextANGLE(GLeglContext ctx, GLuint path, GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum coverMode = 0x%X)", path, coverMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CoverFillPathCHROMIUM, context, path, coverMode);
        if (context->skipValidation() || ValidateCoverFillPathCHROMIUM(context, path, coverMode))
        {
            context->coverFillPath(path, coverMode);
        }
    }
}

void GL_APIENTRY CoverStrokePathCHROMIUMContextANGLE(GLeglContext ctx,
                                                     GLuint path,
                                                     GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum coverMode = 0x%X)", path, coverMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CoverStrokePathCHROMIUM, context, path, coverMode);
        if (context->skipValidation() || ValidateCoverStrokePathCHROMIUM(context, path, coverMode))
        {
            context->coverStrokePath(path, coverMode);
        }
    }
}

void GL_APIENTRY StencilThenCoverFillPathCHROMIUMContextANGLE(GLeglContext ctx,
                                                              GLuint path,
                                                              GLenum fillMode,
                                                              GLuint mask,
                                                              GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum coverMode = 0x%X)",
          path, fillMode, mask, coverMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilThenCoverFillPathCHROMIUM, context, path, fillMode, mask, coverMode);
        if (context->skipValidation() ||
            ValidateStencilThenCoverFillPathCHROMIUM(context, path, fillMode, mask, coverMode))
        {
            context->stencilThenCoverFillPath(path, fillMode, mask, coverMode);
        }
    }
}

void GL_APIENTRY StencilThenCoverStrokePathCHROMIUMContextANGLE(GLeglContext ctx,
                                                                GLuint path,
                                                                GLint reference,
                                                                GLuint mask,
                                                                GLenum coverMode)
{
    EVENT("(GLuint path = %u, GLint reference = %d, GLuint mask = %u, GLenum coverMode = 0x%X)",
          path, reference, mask, coverMode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilThenCoverStrokePathCHROMIUM, context, path, reference, mask,
                      coverMode);
        if (context->skipValidation() ||
            ValidateStencilThenCoverStrokePathCHROMIUM(context, path, reference, mask, coverMode))
        {
            context->stencilThenCoverStrokePath(path, reference, mask, coverMode);
        }
    }
}

void GL_APIENTRY CoverFillPathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                            GLsizei numPath,
                                                            GLenum pathNameType,
                                                            const void *paths,
                                                            GLuint pathBase,
                                                            GLenum coverMode,
                                                            GLenum transformType,
                                                            const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = 0x%X, GLenum transformType = 0x%X, const "
          "GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, coverMode, transformType,
          (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CoverFillPathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateCoverFillPathInstancedCHROMIUM(context, numPath, pathNameType, paths, pathBase,
                                                   coverMode, transformType, transformValues))
        {
            context->coverFillPathInstanced(numPath, pathNameType, paths, pathBase, coverMode,
                                            transformType, transformValues);
        }
    }
}

void GL_APIENTRY CoverStrokePathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                              GLsizei numPath,
                                                              GLenum pathNameType,
                                                              const void *paths,
                                                              GLuint pathBase,
                                                              GLenum coverMode,
                                                              GLenum transformType,
                                                              const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum coverMode = 0x%X, GLenum transformType = 0x%X, const "
          "GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, coverMode, transformType,
          (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CoverStrokePathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, coverMode, transformType, transformValues);
        if (context->skipValidation() || ValidateCoverStrokePathInstancedCHROMIUM(
                                             context, numPath, pathNameType, paths, pathBase,
                                             coverMode, transformType, transformValues))
        {
            context->coverStrokePathInstanced(numPath, pathNameType, paths, pathBase, coverMode,
                                              transformType, transformValues);
        }
    }
}

void GL_APIENTRY StencilStrokePathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                                GLsizei numPath,
                                                                GLenum pathNameType,
                                                                const void *paths,
                                                                GLuint pathBase,
                                                                GLint reference,
                                                                GLuint mask,
                                                                GLenum transformType,
                                                                const GLfloat *transformValues)
{
    EVENT("(GLsizei numPath = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum transformType = "
          "0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPath, pathNameType, (uintptr_t)paths, pathBase, reference, mask, transformType,
          (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilStrokePathInstancedCHROMIUM, context, numPath, pathNameType, paths,
                      pathBase, reference, mask, transformType, transformValues);
        if (context->skipValidation() || ValidateStencilStrokePathInstancedCHROMIUM(
                                             context, numPath, pathNameType, paths, pathBase,
                                             reference, mask, transformType, transformValues))
        {
            context->stencilStrokePathInstanced(numPath, pathNameType, paths, pathBase, reference,
                                                mask, transformType, transformValues);
        }
    }
}

void GL_APIENTRY StencilFillPathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                              GLsizei numPaths,
                                                              GLenum pathNameType,
                                                              const void *paths,
                                                              GLuint pathBase,
                                                              GLenum fillMode,
                                                              GLuint mask,
                                                              GLenum transformType,
                                                              const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum transformType "
          "= 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, fillMode, mask, transformType,
          (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilFillPathInstancedCHROMIUM, context, numPaths, pathNameType, paths,
                      pathBase, fillMode, mask, transformType, transformValues);
        if (context->skipValidation() || ValidateStencilFillPathInstancedCHROMIUM(
                                             context, numPaths, pathNameType, paths, pathBase,
                                             fillMode, mask, transformType, transformValues))
        {
            context->stencilFillPathInstanced(numPaths, pathNameType, paths, pathBase, fillMode,
                                              mask, transformType, transformValues);
        }
    }
}

void GL_APIENTRY
StencilThenCoverFillPathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                      GLsizei numPaths,
                                                      GLenum pathNameType,
                                                      const void *paths,
                                                      GLuint pathBase,
                                                      GLenum fillMode,
                                                      GLuint mask,
                                                      GLenum coverMode,
                                                      GLenum transformType,
                                                      const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLenum fillMode = 0x%X, GLuint mask = %u, GLenum coverMode = "
          "0x%X, GLenum transformType = 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, fillMode, mask, coverMode,
          transformType, (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilThenCoverFillPathInstancedCHROMIUM, context, numPaths, pathNameType,
                      paths, pathBase, fillMode, mask, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateStencilThenCoverFillPathInstancedCHROMIUM(
                context, numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode,
                transformType, transformValues))
        {
            context->stencilThenCoverFillPathInstanced(numPaths, pathNameType, paths, pathBase,
                                                       fillMode, mask, coverMode, transformType,
                                                       transformValues);
        }
    }
}

void GL_APIENTRY
StencilThenCoverStrokePathInstancedCHROMIUMContextANGLE(GLeglContext ctx,
                                                        GLsizei numPaths,
                                                        GLenum pathNameType,
                                                        const void *paths,
                                                        GLuint pathBase,
                                                        GLint reference,
                                                        GLuint mask,
                                                        GLenum coverMode,
                                                        GLenum transformType,
                                                        const GLfloat *transformValues)
{
    EVENT("(GLsizei numPaths = %d, GLenum pathNameType = 0x%X, const void * paths = 0x%016" PRIxPTR
          ", GLuint pathBase = %u, GLint reference = %d, GLuint mask = %u, GLenum coverMode = "
          "0x%X, GLenum transformType = 0x%X, const GLfloat * transformValues = 0x%016" PRIxPTR ")",
          numPaths, pathNameType, (uintptr_t)paths, pathBase, reference, mask, coverMode,
          transformType, (uintptr_t)transformValues);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(StencilThenCoverStrokePathInstancedCHROMIUM, context, numPaths, pathNameType,
                      paths, pathBase, reference, mask, coverMode, transformType, transformValues);
        if (context->skipValidation() ||
            ValidateStencilThenCoverStrokePathInstancedCHROMIUM(
                context, numPaths, pathNameType, paths, pathBase, reference, mask, coverMode,
                transformType, transformValues))
        {
            context->stencilThenCoverStrokePathInstanced(numPaths, pathNameType, paths, pathBase,
                                                         reference, mask, coverMode, transformType,
                                                         transformValues);
        }
    }
}

void GL_APIENTRY BindFragmentInputLocationCHROMIUMContextANGLE(GLeglContext ctx,
                                                               GLuint programs,
                                                               GLint location,
                                                               const GLchar *name)
{
    EVENT("(GLuint programs = %u, GLint location = %d, const GLchar * name = 0x%016" PRIxPTR ")",
          programs, location, (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(BindFragmentInputLocationCHROMIUM, context, programs, location, name);
        if (context->skipValidation() ||
            ValidateBindFragmentInputLocationCHROMIUM(context, programs, location, name))
        {
            context->bindFragmentInputLocation(programs, location, name);
        }
    }
}

void GL_APIENTRY ProgramPathFragmentInputGenCHROMIUMContextANGLE(GLeglContext ctx,
                                                                 GLuint program,
                                                                 GLint location,
                                                                 GLenum genMode,
                                                                 GLint components,
                                                                 const GLfloat *coeffs)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLenum genMode = 0x%X, GLint components = %d, "
        "const GLfloat * coeffs = 0x%016" PRIxPTR ")",
        program, location, genMode, components, (uintptr_t)coeffs);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ProgramPathFragmentInputGenCHROMIUM, context, program, location, genMode,
                      components, coeffs);
        if (context->skipValidation() ||
            ValidateProgramPathFragmentInputGenCHROMIUM(context, program, location, genMode,
                                                        components, coeffs))
        {
            context->programPathFragmentInputGen(program, location, genMode, components, coeffs);
        }
    }
}

void GL_APIENTRY CopyTextureCHROMIUMContextANGLE(GLeglContext ctx,
                                                 GLuint sourceId,
                                                 GLint sourceLevel,
                                                 GLenum destTarget,
                                                 GLuint destId,
                                                 GLint destLevel,
                                                 GLint internalFormat,
                                                 GLenum destType,
                                                 GLboolean unpackFlipY,
                                                 GLboolean unpackPremultiplyAlpha,
                                                 GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = 0x%X, GLboolean "
        "unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha "
        "= %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, internalFormat, destType, unpackFlipY,
        unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopyTextureCHROMIUM, context, sourceId, sourceLevel, destTargetPacked, destId,
                      destLevel, internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopyTextureCHROMIUM(context, sourceId, sourceLevel, destTargetPacked, destId,
                                        destLevel, internalFormat, destType, unpackFlipY,
                                        unpackPremultiplyAlpha, unpackUnmultiplyAlpha))
        {
            context->copyTexture(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                 internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                 unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY CopySubTextureCHROMIUMContextANGLE(GLeglContext ctx,
                                                    GLuint sourceId,
                                                    GLint sourceLevel,
                                                    GLenum destTarget,
                                                    GLuint destId,
                                                    GLint destLevel,
                                                    GLint xoffset,
                                                    GLint yoffset,
                                                    GLint x,
                                                    GLint y,
                                                    GLint width,
                                                    GLint height,
                                                    GLboolean unpackFlipY,
                                                    GLboolean unpackPremultiplyAlpha,
                                                    GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint x = %d, GLint y = "
        "%d, GLint width = %d, GLint height = %d, GLboolean unpackFlipY = %u, GLboolean "
        "unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha = %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, xoffset, yoffset, x, y, width, height,
        unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopySubTextureCHROMIUM, context, sourceId, sourceLevel, destTargetPacked,
                      destId, destLevel, xoffset, yoffset, x, y, width, height, unpackFlipY,
                      unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopySubTextureCHROMIUM(context, sourceId, sourceLevel, destTargetPacked, destId,
                                           destLevel, xoffset, yoffset, x, y, width, height,
                                           unpackFlipY, unpackPremultiplyAlpha,
                                           unpackUnmultiplyAlpha))
        {
            context->copySubTexture(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                    xoffset, yoffset, x, y, width, height, unpackFlipY,
                                    unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY CompressedCopyTextureCHROMIUMContextANGLE(GLeglContext ctx,
                                                           GLuint sourceId,
                                                           GLuint destId)
{
    EVENT("(GLuint sourceId = %u, GLuint destId = %u)", sourceId, destId);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(CompressedCopyTextureCHROMIUM, context, sourceId, destId);
        if (context->skipValidation() ||
            ValidateCompressedCopyTextureCHROMIUM(context, sourceId, destId))
        {
            context->compressedCopyTexture(sourceId, destId);
        }
    }
}

void GL_APIENTRY RequestExtensionANGLEContextANGLE(GLeglContext ctx, const GLchar *name)
{
    EVENT("(const GLchar * name = 0x%016" PRIxPTR ")", (uintptr_t)name);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(RequestExtensionANGLE, context, name);
        if (context->skipValidation() || ValidateRequestExtensionANGLE(context, name))
        {
            context->requestExtension(name);
        }
    }
}

void GL_APIENTRY GetBooleanvRobustANGLEContextANGLE(GLeglContext ctx,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLboolean *params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLboolean * params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetBooleanvRobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetBooleanvRobustANGLE(context, pname, bufSize, length, params))
        {
            context->getBooleanvRobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetBufferParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                             GLenum target,
                                                             GLenum pname,
                                                             GLsizei bufSize,
                                                             GLsizei *length,
                                                             GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameterivRobustANGLE, context, targetPacked, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetBufferParameterivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFloatvRobustANGLEContextANGLE(GLeglContext ctx,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLfloat * params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFloatvRobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetFloatvRobustANGLE(context, pname, bufSize, length, params))
        {
            context->getFloatvRobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFramebufferAttachmentParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                                            GLenum target,
                                                                            GLenum attachment,
                                                                            GLenum pname,
                                                                            GLsizei bufSize,
                                                                            GLsizei *length,
                                                                            GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum attachment = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = "
        "%d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, attachment, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFramebufferAttachmentParameterivRobustANGLE, context, target, attachment,
                      pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetFramebufferAttachmentParameterivRobustANGLE(context, target, attachment,
                                                                   pname, bufSize, length, params))
        {
            context->getFramebufferAttachmentParameterivRobust(target, attachment, pname, bufSize,
                                                               length, params);
        }
    }
}

void GL_APIENTRY GetIntegervRobustANGLEContextANGLE(GLeglContext ctx,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *data)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint * data = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetIntegervRobustANGLE, context, pname, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetIntegervRobustANGLE(context, pname, bufSize, length, data))
        {
            context->getIntegervRobust(pname, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetProgramivRobustANGLEContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramivRobustANGLE, context, program, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetProgramivRobustANGLE(context, program, pname, bufSize, length, params))
        {
            context->getProgramivRobust(program, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetRenderbufferParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                                   GLenum target,
                                                                   GLenum pname,
                                                                   GLsizei bufSize,
                                                                   GLsizei *length,
                                                                   GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetRenderbufferParameterivRobustANGLE, context, target, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetRenderbufferParameterivRobustANGLE(
                                             context, target, pname, bufSize, length, params))
        {
            context->getRenderbufferParameterivRobust(target, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetShaderivRobustANGLEContextANGLE(GLeglContext ctx,
                                                    GLuint shader,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    EVENT(
        "(GLuint shader = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        shader, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetShaderivRobustANGLE, context, shader, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetShaderivRobustANGLE(context, shader, pname, bufSize, length, params))
        {
            context->getShaderivRobust(shader, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterfvRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterfvRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterfvRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformfvRobustANGLE, context, program, location, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetUniformfvRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformfvRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformivRobustANGLEContextANGLE(GLeglContext ctx,
                                                     GLuint program,
                                                     GLint location,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformivRobustANGLE, context, program, location, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetUniformivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLuint index,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLfloat *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribfvRobustANGLE, context, index, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribfvRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribfvRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribivRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLuint index,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribivRobustANGLE, context, index, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribPointervRobustANGLEContextANGLE(GLeglContext ctx,
                                                                GLuint index,
                                                                GLenum pname,
                                                                GLsizei bufSize,
                                                                GLsizei *length,
                                                                void **pointer)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", void ** pointer = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)pointer);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribPointervRobustANGLE, context, index, pname, bufSize, length,
                      pointer);
        if (context->skipValidation() || ValidateGetVertexAttribPointervRobustANGLE(
                                             context, index, pname, bufSize, length, pointer))
        {
            context->getVertexAttribPointervRobust(index, pname, bufSize, length, pointer);
        }
    }
}

void GL_APIENTRY ReadPixelsRobustANGLEContextANGLE(GLeglContext ctx,
                                                   GLint x,
                                                   GLint y,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLenum format,
                                                   GLenum type,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLsizei *columns,
                                                   GLsizei *rows,
                                                   void *pixels)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * pixels = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)length, (uintptr_t)columns,
        (uintptr_t)rows, (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReadPixelsRobustANGLE, context, x, y, width, height, format, type, bufSize,
                      length, columns, rows, pixels);
        if (context->skipValidation() ||
            ValidateReadPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                          length, columns, rows, pixels))
        {
            context->readPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                      rows, pixels);
        }
    }
}

void GL_APIENTRY TexImage2DRobustANGLEContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLint level,
                                                   GLint internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLenum format,
                                                   GLenum type,
                                                   GLsizei bufSize,
                                                   const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, GLsizei "
        "bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2DRobustANGLE, context, targetPacked, level, internalformat, width,
                      height, border, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexImage2DRobustANGLE(context, targetPacked, level, internalformat, width,
                                          height, border, format, type, bufSize, pixels))
        {
            context->texImage2DRobust(targetPacked, level, internalformat, width, height, border,
                                      format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexParameterfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       const GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLfloat * params "
        "= 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterfvRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterfvRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterfvRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                       GLenum target,
                                                       GLenum pname,
                                                       GLsizei bufSize,
                                                       const GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexSubImage2DRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLenum type,
                                                      GLsizei bufSize,
                                                      const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, GLsizei "
        "bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, type, bufSize, (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage2DRobustANGLE, context, targetPacked, level, xoffset, yoffset,
                      width, height, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage2DRobustANGLE(context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, type, bufSize, pixels))
        {
            context->texSubImage2DRobust(targetPacked, level, xoffset, yoffset, width, height,
                                         format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexImage3DRobustANGLEContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLint level,
                                                   GLint internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLenum format,
                                                   GLenum type,
                                                   GLsizei bufSize,
                                                   const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLenum format = 0x%X, GLenum "
        "type = 0x%X, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage3DRobustANGLE, context, targetPacked, level, internalformat, width,
                      height, depth, border, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexImage3DRobustANGLE(context, targetPacked, level, internalformat, width,
                                          height, depth, border, format, type, bufSize, pixels))
        {
            context->texImage3DRobust(targetPacked, level, internalformat, width, height, depth,
                                      border, format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY TexSubImage3DRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLenum type,
                                                      GLsizei bufSize,
                                                      const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, const void * pixels = 0x%016" PRIxPTR
        ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize,
        (uintptr_t)pixels);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexSubImage3DRobustANGLE, context, targetPacked, level, xoffset, yoffset,
                      zoffset, width, height, depth, format, type, bufSize, pixels);
        if (context->skipValidation() ||
            ValidateTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset, yoffset,
                                             zoffset, width, height, depth, format, type, bufSize,
                                             pixels))
        {
            context->texSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset, width,
                                         height, depth, format, type, bufSize, pixels);
        }
    }
}

void GL_APIENTRY CompressedTexImage2DRobustANGLEContextANGLE(GLeglContext ctx,
                                                             GLenum target,
                                                             GLint level,
                                                             GLenum internalformat,
                                                             GLsizei width,
                                                             GLsizei height,
                                                             GLint border,
                                                             GLsizei imageSize,
                                                             GLsizei dataSize,
                                                             const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, GLsizei dataSize = "
        "%d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, border, imageSize, dataSize, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage2DRobustANGLE, context, targetPacked, level, internalformat,
                      width, height, border, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexImage2DRobustANGLE(
                                             context, targetPacked, level, internalformat, width,
                                             height, border, imageSize, dataSize, data))
        {
            context->compressedTexImage2DRobust(targetPacked, level, internalformat, width, height,
                                                border, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage2DRobustANGLEContextANGLE(GLeglContext ctx,
                                                                GLenum target,
                                                                GLint level,
                                                                GLsizei xoffset,
                                                                GLsizei yoffset,
                                                                GLsizei width,
                                                                GLsizei height,
                                                                GLenum format,
                                                                GLsizei imageSize,
                                                                GLsizei dataSize,
                                                                const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLsizei xoffset = %d, GLsizei yoffset = %d, "
        "GLsizei width = %d, GLsizei height = %d, GLenum format = 0x%X, GLsizei imageSize = %d, "
        "GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, width, height, format, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage2DRobustANGLE, context, targetPacked, level, xoffset,
                      yoffset, width, height, format, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexSubImage2DRobustANGLE(
                                             context, targetPacked, level, xoffset, yoffset, width,
                                             height, format, imageSize, dataSize, data))
        {
            context->compressedTexSubImage2DRobust(targetPacked, level, xoffset, yoffset, width,
                                                   height, format, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexImage3DRobustANGLEContextANGLE(GLeglContext ctx,
                                                             GLenum target,
                                                             GLint level,
                                                             GLenum internalformat,
                                                             GLsizei width,
                                                             GLsizei height,
                                                             GLsizei depth,
                                                             GLint border,
                                                             GLsizei imageSize,
                                                             GLsizei dataSize,
                                                             const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLsizei depth = %d, GLint border = %d, GLsizei imageSize = %d, "
        "GLsizei dataSize = %d, const GLvoid * data = 0x%016" PRIxPTR ")",
        target, level, internalformat, width, height, depth, border, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexImage3DRobustANGLE, context, targetPacked, level, internalformat,
                      width, height, depth, border, imageSize, dataSize, data);
        if (context->skipValidation() || ValidateCompressedTexImage3DRobustANGLE(
                                             context, targetPacked, level, internalformat, width,
                                             height, depth, border, imageSize, dataSize, data))
        {
            context->compressedTexImage3DRobust(targetPacked, level, internalformat, width, height,
                                                depth, border, imageSize, dataSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage3DRobustANGLEContextANGLE(GLeglContext ctx,
                                                                GLenum target,
                                                                GLint level,
                                                                GLint xoffset,
                                                                GLint yoffset,
                                                                GLint zoffset,
                                                                GLsizei width,
                                                                GLsizei height,
                                                                GLsizei depth,
                                                                GLenum format,
                                                                GLsizei imageSize,
                                                                GLsizei dataSize,
                                                                const GLvoid *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint "
        "zoffset = %d, GLsizei width = %d, GLsizei height = %d, GLsizei depth = %d, GLenum format "
        "= 0x%X, GLsizei imageSize = %d, GLsizei dataSize = %d, const GLvoid * data = "
        "0x%016" PRIxPTR ")",
        target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataSize,
        (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(CompressedTexSubImage3DRobustANGLE, context, targetPacked, level, xoffset,
                      yoffset, zoffset, width, height, depth, format, imageSize, dataSize, data);
        if (context->skipValidation() ||
            ValidateCompressedTexSubImage3DRobustANGLE(context, targetPacked, level, xoffset,
                                                       yoffset, zoffset, width, height, depth,
                                                       format, imageSize, dataSize, data))
        {
            context->compressedTexSubImage3DRobust(targetPacked, level, xoffset, yoffset, zoffset,
                                                   width, height, depth, format, imageSize,
                                                   dataSize, data);
        }
    }
}

void GL_APIENTRY GetQueryivRobustANGLEContextANGLE(GLeglContext ctx,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        QueryType targetPacked = FromGLenum<QueryType>(target);
        ANGLE_CAPTURE(GetQueryivRobustANGLE, context, targetPacked, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryivRobustANGLE(context, targetPacked, pname, bufSize, length, params))
        {
            context->getQueryivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLuint id,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          GLuint *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectuivRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectuivRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectuivRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetBufferPointervRobustANGLEContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLenum pname,
                                                          GLsizei bufSize,
                                                          GLsizei *length,
                                                          void **params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", void ** params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferPointervRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetBufferPointervRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferPointervRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetIntegeri_vRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLuint index,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetIntegeri_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetIntegeri_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getIntegeri_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetInternalformativRobustANGLEContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLenum internalformat,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum internalformat = 0x%X, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, internalformat, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInternalformativRobustANGLE, context, target, internalformat, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetInternalformativRobustANGLE(context, target, internalformat, pname, bufSize,
                                                   length, params))
        {
            context->getInternalformativRobust(target, internalformat, pname, bufSize, length,
                                               params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIivRobustANGLEContextANGLE(GLeglContext ctx,
                                                           GLuint index,
                                                           GLenum pname,
                                                           GLsizei bufSize,
                                                           GLsizei *length,
                                                           GLint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribIivRobustANGLE, context, index, pname, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribIivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribIivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetVertexAttribIuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                            GLuint index,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLuint *params)
{
    EVENT(
        "(GLuint index = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        index, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetVertexAttribIuivRobustANGLE, context, index, pname, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetVertexAttribIuivRobustANGLE(context, index, pname, bufSize, length, params))
        {
            context->getVertexAttribIuivRobust(index, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetUniformuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLuint program,
                                                      GLint location,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetUniformuivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetUniformuivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getUniformuivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetActiveUniformBlockivRobustANGLEContextANGLE(GLeglContext ctx,
                                                                GLuint program,
                                                                GLuint uniformBlockIndex,
                                                                GLenum pname,
                                                                GLsizei bufSize,
                                                                GLsizei *length,
                                                                GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLuint uniformBlockIndex = %u, GLenum pname = 0x%X, GLsizei bufSize "
        "= %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, uniformBlockIndex, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetActiveUniformBlockivRobustANGLE, context, program, uniformBlockIndex,
                      pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetActiveUniformBlockivRobustANGLE(context, program, uniformBlockIndex, pname,
                                                       bufSize, length, params))
        {
            context->getActiveUniformBlockivRobust(program, uniformBlockIndex, pname, bufSize,
                                                   length, params);
        }
    }
}

void GL_APIENTRY GetInteger64vRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint64 *data)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", GLint64 * data = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInteger64vRobustANGLE, context, pname, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetInteger64vRobustANGLE(context, pname, bufSize, length, data))
        {
            context->getInteger64vRobust(pname, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetInteger64i_vRobustANGLEContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLuint index,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint64 *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetInteger64i_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetInteger64i_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getInteger64i_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetBufferParameteri64vRobustANGLEContextANGLE(GLeglContext ctx,
                                                               GLenum target,
                                                               GLenum pname,
                                                               GLsizei bufSize,
                                                               GLsizei *length,
                                                               GLint64 *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        ANGLE_CAPTURE(GetBufferParameteri64vRobustANGLE, context, targetPacked, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetBufferParameteri64vRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getBufferParameteri64vRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY SamplerParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                           GLuint sampler,
                                                           GLuint pname,
                                                           GLsizei bufSize,
                                                           const GLint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLuint pname = %u, GLsizei bufSize = %d, const GLint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY SamplerParameterfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                           GLuint sampler,
                                                           GLenum pname,
                                                           GLsizei bufSize,
                                                           const GLfloat *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLfloat * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterfvRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterfvRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterfvRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY GetSamplerParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                              GLuint sampler,
                                                              GLenum pname,
                                                              GLsizei bufSize,
                                                              GLsizei *length,
                                                              GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                              GLuint sampler,
                                                              GLenum pname,
                                                              GLsizei bufSize,
                                                              GLsizei *length,
                                                              GLfloat *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterfvRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterfvRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterfvRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetFramebufferParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                                  GLuint sampler,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetFramebufferParameterivRobustANGLE, context, sampler, pname, bufSize,
                      length, params);
        if (context->skipValidation() || ValidateGetFramebufferParameterivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getFramebufferParameterivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetProgramInterfaceivRobustANGLEContextANGLE(GLeglContext ctx,
                                                              GLuint program,
                                                              GLenum programInterface,
                                                              GLenum pname,
                                                              GLsizei bufSize,
                                                              GLsizei *length,
                                                              GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLenum pname = 0x%X, GLsizei "
        "bufSize = %d, GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, programInterface, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetProgramInterfaceivRobustANGLE, context, program, programInterface, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetProgramInterfaceivRobustANGLE(context, program, programInterface, pname,
                                                     bufSize, length, params))
        {
            context->getProgramInterfaceivRobust(program, programInterface, pname, bufSize, length,
                                                 params);
        }
    }
}

void GL_APIENTRY GetBooleani_vRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLenum target,
                                                      GLuint index,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLboolean *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLboolean * data = 0x%016" PRIxPTR ")",
        target, index, bufSize, (uintptr_t)length, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetBooleani_vRobustANGLE, context, target, index, bufSize, length, data);
        if (context->skipValidation() ||
            ValidateGetBooleani_vRobustANGLE(context, target, index, bufSize, length, data))
        {
            context->getBooleani_vRobust(target, index, bufSize, length, data);
        }
    }
}

void GL_APIENTRY GetMultisamplefvRobustANGLEContextANGLE(GLeglContext ctx,
                                                         GLenum pname,
                                                         GLuint index,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLfloat *val)
{
    EVENT(
        "(GLenum pname = 0x%X, GLuint index = %u, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * val = 0x%016" PRIxPTR ")",
        pname, index, bufSize, (uintptr_t)length, (uintptr_t)val);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetMultisamplefvRobustANGLE, context, pname, index, bufSize, length, val);
        if (context->skipValidation() ||
            ValidateGetMultisamplefvRobustANGLE(context, pname, index, bufSize, length, val))
        {
            context->getMultisamplefvRobust(pname, index, bufSize, length, val);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterivRobustANGLEContextANGLE(GLeglContext ctx,
                                                               GLenum target,
                                                               GLint level,
                                                               GLenum pname,
                                                               GLsizei bufSize,
                                                               GLsizei *length,
                                                               GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLsizei bufSize = %d, "
        "GLsizei * length = 0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, level, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterivRobustANGLE, context, targetPacked, level, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterivRobustANGLE(context, targetPacked, level, pname, bufSize,
                                                      length, params))
        {
            context->getTexLevelParameterivRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                               GLenum target,
                                                               GLint level,
                                                               GLenum pname,
                                                               GLsizei bufSize,
                                                               GLsizei *length,
                                                               GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLsizei bufSize = %d, "
        "GLsizei * length = 0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        target, level, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfvRobustANGLE, context, targetPacked, level, pname,
                      bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfvRobustANGLE(context, targetPacked, level, pname, bufSize,
                                                      length, params))
        {
            context->getTexLevelParameterfvRobust(targetPacked, level, pname, bufSize, length,
                                                  params);
        }
    }
}

void GL_APIENTRY GetPointervRobustANGLERobustANGLEContextANGLE(GLeglContext ctx,
                                                               GLenum pname,
                                                               GLsizei bufSize,
                                                               GLsizei *length,
                                                               void **params)
{
    EVENT("(GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
          ", void ** params = 0x%016" PRIxPTR ")",
          pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetPointervRobustANGLERobustANGLE, context, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetPointervRobustANGLERobustANGLE(context, pname, bufSize, length, params))
        {
            context->getPointervRobustANGLERobust(pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY ReadnPixelsRobustANGLEContextANGLE(GLeglContext ctx,
                                                    GLint x,
                                                    GLint y,
                                                    GLsizei width,
                                                    GLsizei height,
                                                    GLenum format,
                                                    GLenum type,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLsizei *columns,
                                                    GLsizei *rows,
                                                    void *data)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, GLsizei bufSize = %d, GLsizei * length = 0x%016" PRIxPTR
        ", GLsizei * columns = 0x%016" PRIxPTR ", GLsizei * rows = 0x%016" PRIxPTR
        ", void * data = 0x%016" PRIxPTR ")",
        x, y, width, height, format, type, bufSize, (uintptr_t)length, (uintptr_t)columns,
        (uintptr_t)rows, (uintptr_t)data);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(ReadnPixelsRobustANGLE, context, x, y, width, height, format, type, bufSize,
                      length, columns, rows, data);
        if (context->skipValidation() ||
            ValidateReadnPixelsRobustANGLE(context, x, y, width, height, format, type, bufSize,
                                           length, columns, rows, data))
        {
            context->readnPixelsRobust(x, y, width, height, format, type, bufSize, length, columns,
                                       rows, data);
        }
    }
}

void GL_APIENTRY GetnUniformfvRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLuint program,
                                                      GLint location,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLfloat *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLfloat * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetnUniformfvRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformfvRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformfvRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetnUniformivRobustANGLEContextANGLE(GLeglContext ctx,
                                                      GLuint program,
                                                      GLint location,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetnUniformivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetnUniformuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                       GLuint program,
                                                       GLint location,
                                                       GLsizei bufSize,
                                                       GLsizei *length,
                                                       GLuint *params)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        program, location, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetnUniformuivRobustANGLE, context, program, location, bufSize, length,
                      params);
        if (context->skipValidation() ||
            ValidateGetnUniformuivRobustANGLE(context, program, location, bufSize, length, params))
        {
            context->getnUniformuivRobust(program, location, bufSize, length, params);
        }
    }
}

void GL_APIENTRY TexParameterIivRobustANGLEContextANGLE(GLeglContext ctx,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        const GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterIivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterIivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY TexParameterIuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                         GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         const GLuint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLuint * params = "
        "0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexParameterIuivRobustANGLE, context, targetPacked, pname, bufSize, params);
        if (context->skipValidation() ||
            ValidateTexParameterIuivRobustANGLE(context, targetPacked, pname, bufSize, params))
        {
            context->texParameterIuivRobust(targetPacked, pname, bufSize, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIivRobustANGLEContextANGLE(GLeglContext ctx,
                                                           GLenum target,
                                                           GLenum pname,
                                                           GLsizei bufSize,
                                                           GLsizei *length,
                                                           GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterIivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterIivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexParameterIuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                            GLenum target,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLuint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        target, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(GetTexParameterIuivRobustANGLE, context, targetPacked, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetTexParameterIuivRobustANGLE(
                                             context, targetPacked, pname, bufSize, length, params))
        {
            context->getTexParameterIuivRobust(targetPacked, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY SamplerParameterIivRobustANGLEContextANGLE(GLeglContext ctx,
                                                            GLuint sampler,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            const GLint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterIivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterIivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY SamplerParameterIuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                             GLuint sampler,
                                                             GLenum pname,
                                                             GLsizei bufSize,
                                                             const GLuint *param)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, const GLuint * param = "
        "0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)param);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SamplerParameterIuivRobustANGLE, context, sampler, pname, bufSize, param);
        if (context->skipValidation() ||
            ValidateSamplerParameterIuivRobustANGLE(context, sampler, pname, bufSize, param))
        {
            context->samplerParameterIuivRobust(sampler, pname, bufSize, param);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIivRobustANGLEContextANGLE(GLeglContext ctx,
                                                               GLuint sampler,
                                                               GLenum pname,
                                                               GLsizei bufSize,
                                                               GLsizei *length,
                                                               GLint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterIivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterIivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterIivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetSamplerParameterIuivRobustANGLEContextANGLE(GLeglContext ctx,
                                                                GLuint sampler,
                                                                GLenum pname,
                                                                GLsizei bufSize,
                                                                GLsizei *length,
                                                                GLuint *params)
{
    EVENT(
        "(GLuint sampler = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint * params = 0x%016" PRIxPTR ")",
        sampler, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetSamplerParameterIuivRobustANGLE, context, sampler, pname, bufSize, length,
                      params);
        if (context->skipValidation() || ValidateGetSamplerParameterIuivRobustANGLE(
                                             context, sampler, pname, bufSize, length, params))
        {
            context->getSamplerParameterIuivRobust(sampler, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectivRobustANGLEContextANGLE(GLeglContext ctx,
                                                         GLuint id,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectivRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectivRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectivRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjecti64vRobustANGLEContextANGLE(GLeglContext ctx,
                                                           GLuint id,
                                                           GLenum pname,
                                                           GLsizei bufSize,
                                                           GLsizei *length,
                                                           GLint64 *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLint64 * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjecti64vRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjecti64vRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjecti64vRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetQueryObjectui64vRobustANGLEContextANGLE(GLeglContext ctx,
                                                            GLuint id,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            GLsizei *length,
                                                            GLuint64 *params)
{
    EVENT(
        "(GLuint id = %u, GLenum pname = 0x%X, GLsizei bufSize = %d, GLsizei * length = "
        "0x%016" PRIxPTR ", GLuint64 * params = 0x%016" PRIxPTR ")",
        id, pname, bufSize, (uintptr_t)length, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetQueryObjectui64vRobustANGLE, context, id, pname, bufSize, length, params);
        if (context->skipValidation() ||
            ValidateGetQueryObjectui64vRobustANGLE(context, id, pname, bufSize, length, params))
        {
            context->getQueryObjectui64vRobust(id, pname, bufSize, length, params);
        }
    }
}

void GL_APIENTRY CopyTexture3DANGLEContextANGLE(GLeglContext ctx,
                                                GLuint sourceId,
                                                GLint sourceLevel,
                                                GLenum destTarget,
                                                GLuint destId,
                                                GLint destLevel,
                                                GLint internalFormat,
                                                GLenum destType,
                                                GLboolean unpackFlipY,
                                                GLboolean unpackPremultiplyAlpha,
                                                GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint internalFormat = %d, GLenum destType = 0x%X, GLboolean "
        "unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean unpackUnmultiplyAlpha "
        "= %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, internalFormat, destType, unpackFlipY,
        unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopyTexture3DANGLE, context, sourceId, sourceLevel, destTargetPacked, destId,
                      destLevel, internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                      unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopyTexture3DANGLE(context, sourceId, sourceLevel, destTargetPacked, destId,
                                       destLevel, internalFormat, destType, unpackFlipY,
                                       unpackPremultiplyAlpha, unpackUnmultiplyAlpha))
        {
            context->copyTexture3D(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                   internalFormat, destType, unpackFlipY, unpackPremultiplyAlpha,
                                   unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY CopySubTexture3DANGLEContextANGLE(GLeglContext ctx,
                                                   GLuint sourceId,
                                                   GLint sourceLevel,
                                                   GLenum destTarget,
                                                   GLuint destId,
                                                   GLint destLevel,
                                                   GLint xoffset,
                                                   GLint yoffset,
                                                   GLint zoffset,
                                                   GLint x,
                                                   GLint y,
                                                   GLint z,
                                                   GLint width,
                                                   GLint height,
                                                   GLint depth,
                                                   GLboolean unpackFlipY,
                                                   GLboolean unpackPremultiplyAlpha,
                                                   GLboolean unpackUnmultiplyAlpha)
{
    EVENT(
        "(GLuint sourceId = %u, GLint sourceLevel = %d, GLenum destTarget = 0x%X, GLuint destId = "
        "%u, GLint destLevel = %d, GLint xoffset = %d, GLint yoffset = %d, GLint zoffset = %d, "
        "GLint x = %d, GLint y = %d, GLint z = %d, GLint width = %d, GLint height = %d, GLint "
        "depth = %d, GLboolean unpackFlipY = %u, GLboolean unpackPremultiplyAlpha = %u, GLboolean "
        "unpackUnmultiplyAlpha = %u)",
        sourceId, sourceLevel, destTarget, destId, destLevel, xoffset, yoffset, zoffset, x, y, z,
        width, height, depth, unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget destTargetPacked = FromGLenum<TextureTarget>(destTarget);
        ANGLE_CAPTURE(CopySubTexture3DANGLE, context, sourceId, sourceLevel, destTargetPacked,
                      destId, destLevel, xoffset, yoffset, zoffset, x, y, z, width, height, depth,
                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        if (context->skipValidation() ||
            ValidateCopySubTexture3DANGLE(context, sourceId, sourceLevel, destTargetPacked, destId,
                                          destLevel, xoffset, yoffset, zoffset, x, y, z, width,
                                          height, depth, unpackFlipY, unpackPremultiplyAlpha,
                                          unpackUnmultiplyAlpha))
        {
            context->copySubTexture3D(sourceId, sourceLevel, destTargetPacked, destId, destLevel,
                                      xoffset, yoffset, zoffset, x, y, z, width, height, depth,
                                      unpackFlipY, unpackPremultiplyAlpha, unpackUnmultiplyAlpha);
        }
    }
}

void GL_APIENTRY TexStorage2DMultisampleANGLEContextANGLE(GLeglContext ctx,
                                                          GLenum target,
                                                          GLsizei samples,
                                                          GLenum internalformat,
                                                          GLsizei width,
                                                          GLsizei height,
                                                          GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, fixedsamplelocations);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(TexStorage2DMultisampleANGLE, context, targetPacked, samples, internalformat,
                      width, height, fixedsamplelocations);
        if (context->skipValidation() ||
            ValidateTexStorage2DMultisampleANGLE(context, targetPacked, samples, internalformat,
                                                 width, height, fixedsamplelocations))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterivANGLEContextANGLE(GLeglContext ctx,
                                                         GLenum target,
                                                         GLint level,
                                                         GLenum pname,
                                                         GLint *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLint * params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterivANGLE, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterivANGLE(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfvANGLEContextANGLE(GLeglContext ctx,
                                                         GLenum target,
                                                         GLint level,
                                                         GLenum pname,
                                                         GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLfloat * params = "
        "0x%016" PRIxPTR ")",
        target, level, pname, (uintptr_t)params);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(GetTexLevelParameterfvANGLE, context, targetPacked, level, pname, params);
        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfvANGLE(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY MultiDrawArraysANGLEContextANGLE(GLeglContext ctx,
                                                  GLenum mode,
                                                  const GLint *firsts,
                                                  const GLsizei *counts,
                                                  GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)firsts, (uintptr_t)counts, drawcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(MultiDrawArraysANGLE, context, modePacked, firsts, counts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawArraysANGLE(context, modePacked, firsts, counts, drawcount))
        {
            context->multiDrawArrays(modePacked, firsts, counts, drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawArraysInstancedANGLEContextANGLE(GLeglContext ctx,
                                                           GLenum mode,
                                                           const GLint *firsts,
                                                           const GLsizei *counts,
                                                           const GLsizei *instanceCounts,
                                                           GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLint *firsts = 0x%016" PRIxPTR
          ", const GLsizei *counts = 0x%016" PRIxPTR
          ", const GLsizei *instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)firsts, (uintptr_t)counts, (uintptr_t)instanceCounts, drawcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked = FromGLenum<PrimitiveMode>(mode);
        ANGLE_CAPTURE(MultiDrawArraysInstancedANGLE, context, modePacked, firsts, counts,
                      instanceCounts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawArraysInstancedANGLE(context, modePacked, firsts, counts,
                                                  instanceCounts, drawcount))
        {
            context->multiDrawArraysInstanced(modePacked, firsts, counts, instanceCounts,
                                              drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawElementsANGLEContextANGLE(GLeglContext ctx,
                                                    GLenum mode,
                                                    const GLsizei *counts,
                                                    GLenum type,
                                                    const GLvoid *const *indices,
                                                    GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = 0x%X, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", GLsizei drawcount = %d)",
          mode, (uintptr_t)counts, type, (uintptr_t)indices, drawcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(MultiDrawElementsANGLE, context, modePacked, counts, typePacked, indices,
                      drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawElementsANGLE(context, modePacked, counts, typePacked, indices,
                                           drawcount))
        {
            context->multiDrawElements(modePacked, counts, typePacked, indices, drawcount);
        }
    }
}

void GL_APIENTRY MultiDrawElementsInstancedANGLEContextANGLE(GLeglContext ctx,
                                                             GLenum mode,
                                                             const GLsizei *counts,
                                                             GLenum type,
                                                             const GLvoid *const *indices,
                                                             const GLsizei *instanceCounts,
                                                             GLsizei drawcount)
{
    EVENT("(GLenum mode = 0x%X, const GLsizei *counts = 0x%016" PRIxPTR
          ", GLenum type = 0x%X, const GLvoid *const*indices = 0x%016" PRIxPTR
          ", const GLsizei*instanceCounts = 0x%016" PRIxPTR ", GLsizei drawcount = %d)",
          mode, (uintptr_t)counts, type, (uintptr_t)indices, (uintptr_t)instanceCounts, drawcount);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        PrimitiveMode modePacked    = FromGLenum<PrimitiveMode>(mode);
        DrawElementsType typePacked = FromGLenum<DrawElementsType>(type);
        ANGLE_CAPTURE(MultiDrawElementsInstancedANGLE, context, modePacked, counts, typePacked,
                      indices, instanceCounts, drawcount);
        if (context->skipValidation() ||
            ValidateMultiDrawElementsInstancedANGLE(context, modePacked, counts, typePacked,
                                                    indices, instanceCounts, drawcount))
        {
            context->multiDrawElementsInstanced(modePacked, counts, typePacked, indices,
                                                instanceCounts, drawcount);
        }
    }
}

void GL_APIENTRY GetMultisamplefvANGLEContextANGLE(GLeglContext ctx,
                                                   GLenum pname,
                                                   GLuint index,
                                                   GLfloat *val)
{
    EVENT("(GLenum pname = 0x%X, GLuint index = %u, GLfloat * val = 0x%016" PRIxPTR ")", pname,
          index, (uintptr_t)val);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(GetMultisamplefvANGLE, context, pname, index, val);
        if (context->skipValidation() || ValidateGetMultisamplefvANGLE(context, pname, index, val))
        {
            context->getMultisamplefv(pname, index, val);
        }
    }
}

void GL_APIENTRY SampleMaskiANGLEContextANGLE(GLeglContext ctx, GLuint maskNumber, GLbitfield mask)
{
    EVENT("(GLuint maskNumber = %u, GLbitfield mask = 0x%X)", maskNumber, mask);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ANGLE_CAPTURE(SampleMaskiANGLE, context, maskNumber, mask);
        if (context->skipValidation() || ValidateSampleMaskiANGLE(context, maskNumber, mask))
        {
            context->sampleMaski(maskNumber, mask);
        }
    }
}

void GL_APIENTRY ProvokingVertexANGLEContextANGLE(GLeglContext ctx, GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        ProvokingVertexConvention modePacked = FromGLenum<ProvokingVertexConvention>(mode);
        ANGLE_CAPTURE(ProvokingVertexANGLE, context, modePacked);
        if (context->skipValidation() || ValidateProvokingVertexANGLE(context, modePacked))
        {
            context->provokingVertex(modePacked);
        }
    }
}

void GL_APIENTRY LoseContextCHROMIUMContextANGLE(GLeglContext ctx, GLenum current, GLenum other)
{
    EVENT("(GLenum current = 0x%X, GLenum other = 0x%X)", current, other);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        GraphicsResetStatus currentPacked = FromGLenum<GraphicsResetStatus>(current);
        GraphicsResetStatus otherPacked   = FromGLenum<GraphicsResetStatus>(other);
        ANGLE_CAPTURE(LoseContextCHROMIUM, context, currentPacked, otherPacked);
        if (context->skipValidation() ||
            ValidateLoseContextCHROMIUM(context, currentPacked, otherPacked))
        {
            context->loseContext(currentPacked, otherPacked);
        }
    }
}

void GL_APIENTRY TexImage2DExternalANGLEContextANGLE(GLeglContext ctx,
                                                     GLenum target,
                                                     GLint level,
                                                     GLint internalformat,
                                                     GLsizei width,
                                                     GLsizei height,
                                                     GLint border,
                                                     GLenum format,
                                                     GLenum type)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X)",
        target, level, internalformat, width, height, border, format, type);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        ANGLE_CAPTURE(TexImage2DExternalANGLE, context, targetPacked, level, internalformat, width,
                      height, border, format, type);
        if (context->skipValidation() ||
            ValidateTexImage2DExternalANGLE(context, targetPacked, level, internalformat, width,
                                            height, border, format, type))
        {
            context->texImage2DExternal(targetPacked, level, internalformat, width, height, border,
                                        format, type);
        }
    }
}

void GL_APIENTRY InvalidateTextureANGLEContextANGLE(GLeglContext ctx, GLenum target)
{
    EVENT("(GLenum target = 0x%X)", target);

    Context *context = static_cast<gl::Context *>(ctx);
    if (context)
    {
        ASSERT(context == GetValidGlobalContext());
        TextureType targetPacked = FromGLenum<TextureType>(target);
        ANGLE_CAPTURE(InvalidateTextureANGLE, context, targetPacked);
        if (context->skipValidation() || ValidateInvalidateTextureANGLE(context, targetPacked))
        {
            context->invalidateTexture(targetPacked);
        }
    }
}
}  // namespace gl
