<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [JSHandle](./puppeteer.jshandle.md)

## JSHandle class

Represents an in-page JavaScript object. JSHandles can be created with the [page.evaluateHandle](./puppeteer.page.evaluatehandle.md) method.

<b>Signature:</b>

```typescript
export declare class JSHandle 
```

## Remarks

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `JSHandle` class.

## Example


```js
const windowHandle = await page.evaluateHandle(() => window);

```
JSHandle prevents the referenced JavaScript object from being garbage-collected unless the handle is [disposed](./puppeteer.jshandle.dispose.md)<!-- -->. JSHandles are auto- disposed when their origin frame gets navigated or the parent context gets destroyed.

JSHandle instances can be used as arguments for [Page.$eval()](./puppeteer.page._eval.md)<!-- -->, [Page.evaluate()](./puppeteer.page.evaluate.md)<!-- -->, and [Page.evaluateHandle()](./puppeteer.page.evaluatehandle.md)<!-- -->.

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [asElement()](./puppeteer.jshandle.aselement.md) |  | Returns either <code>null</code> or the object handle itself, if the object handle is an instance of [ElementHandle](./puppeteer.elementhandle.md)<!-- -->. |
|  [dispose()](./puppeteer.jshandle.dispose.md) |  | Stops referencing the element handle, and resolves when the object handle is successfully disposed of. |
|  [evaluate(pageFunction, args)](./puppeteer.jshandle.evaluate.md) |  | This method passes this handle as the first argument to <code>pageFunction</code>. If <code>pageFunction</code> returns a Promise, then <code>handle.evaluate</code> would wait for the promise to resolve and return its value. |
|  [evaluateHandle(pageFunction, args)](./puppeteer.jshandle.evaluatehandle.md) |  | This method passes this handle as the first argument to <code>pageFunction</code>. |
|  [executionContext()](./puppeteer.jshandle.executioncontext.md) |  | Returns the execution context the handle belongs to. |
|  [getProperties()](./puppeteer.jshandle.getproperties.md) |  | The method returns a map with property names as keys and JSHandle instances for the property values. |
|  [getProperty(propertyName)](./puppeteer.jshandle.getproperty.md) |  | Fetches a single property from the referenced object. |
|  [jsonValue()](./puppeteer.jshandle.jsonvalue.md) |  | Returns a JSON representation of the object. |
|  [toString()](./puppeteer.jshandle.tostring.md) |  | Returns a string representation of the JSHandle. |

