<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md)

## Page class

Page provides methods to interact with a single tab or \[extension background page\](https://developer.chrome.com/extensions/background\_pages) in Chromium. One \[Browser\] instance might have multiple \[Page\] instances.

<b>Signature:</b>

```typescript
export declare class Page extends EventEmitter 
```
<b>Extends:</b> [EventEmitter](./puppeteer.eventemitter.md)

## Remarks

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `Page` class.

## Example 1

This example creates a page, navigates it to a URL, and then \* saves a screenshot:

```js
const puppeteer = require('puppeteer');

(async () => {
  const browser = await puppeteer.launch();
  const page = await browser.newPage();
  await page.goto('https://example.com');
  await page.screenshot({path: 'screenshot.png'});
  await browser.close();
})();

```
The Page class extends from Puppeteer's [EventEmitter](./puppeteer.eventemitter.md) class and will emit various events which are documented in the [PageEmittedEvents](./puppeteer.pageemittedevents.md) enum.

## Example 2

This example logs a message for a single page `load` event:

```js
page.once('load', () => console.log('Page loaded!'));

```
To unsubscribe from events use the `off` method:

```js
function logRequest(interceptedRequest) {
  console.log('A request was made:', interceptedRequest.url());
}
page.on('request', logRequest);
// Sometime later...
page.off('request', logRequest);

```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [accessibility](./puppeteer.page.accessibility.md) |  | [Accessibility](./puppeteer.accessibility.md) |  |
|  [coverage](./puppeteer.page.coverage.md) |  | [Coverage](./puppeteer.coverage.md) |  |
|  [keyboard](./puppeteer.page.keyboard.md) |  | [Keyboard](./puppeteer.keyboard.md) |  |
|  [mouse](./puppeteer.page.mouse.md) |  | [Mouse](./puppeteer.mouse.md) |  |
|  [touchscreen](./puppeteer.page.touchscreen.md) |  | [Touchscreen](./puppeteer.touchscreen.md) |  |
|  [tracing](./puppeteer.page.tracing.md) |  | [Tracing](./puppeteer.tracing.md) |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [$(selector)](./puppeteer.page._.md) |  | Runs <code>document.querySelector</code> within the page. If no element matches the selector, the return value resolves to <code>null</code>. |
|  [$$(selector)](./puppeteer.page.__.md) |  |  |
|  [$$eval(selector, pageFunction, args)](./puppeteer.page.__eval.md) |  |  |
|  [$eval(selector, pageFunction, args)](./puppeteer.page._eval.md) |  | This method runs <code>document.querySelector</code> within the page and passes the result as the first argument to the <code>pageFunction</code>. |
|  [$x(expression)](./puppeteer.page._x.md) |  |  |
|  [addScriptTag(options)](./puppeteer.page.addscripttag.md) |  |  |
|  [addStyleTag(options)](./puppeteer.page.addstyletag.md) |  |  |
|  [authenticate(credentials)](./puppeteer.page.authenticate.md) |  |  |
|  [bringToFront()](./puppeteer.page.bringtofront.md) |  |  |
|  [browser()](./puppeteer.page.browser.md) |  |  |
|  [browserContext()](./puppeteer.page.browsercontext.md) |  |  |
|  [click(selector, options)](./puppeteer.page.click.md) |  |  |
|  [close(options)](./puppeteer.page.close.md) |  |  |
|  [content()](./puppeteer.page.content.md) |  |  |
|  [cookies(urls)](./puppeteer.page.cookies.md) |  |  |
|  [deleteCookie(cookies)](./puppeteer.page.deletecookie.md) |  |  |
|  [emulate(options)](./puppeteer.page.emulate.md) |  |  |
|  [emulateMediaFeatures(features)](./puppeteer.page.emulatemediafeatures.md) |  |  |
|  [emulateMediaType(type)](./puppeteer.page.emulatemediatype.md) |  |  |
|  [emulateTimezone(timezoneId)](./puppeteer.page.emulatetimezone.md) |  |  |
|  [emulateVisionDeficiency(type)](./puppeteer.page.emulatevisiondeficiency.md) |  |  |
|  [evaluate(pageFunction, args)](./puppeteer.page.evaluate.md) |  |  |
|  [evaluateHandle(pageFunction, args)](./puppeteer.page.evaluatehandle.md) |  |  |
|  [evaluateOnNewDocument(pageFunction, args)](./puppeteer.page.evaluateonnewdocument.md) |  |  |
|  [exposeFunction(name, puppeteerFunction)](./puppeteer.page.exposefunction.md) |  |  |
|  [focus(selector)](./puppeteer.page.focus.md) |  |  |
|  [frames()](./puppeteer.page.frames.md) |  |  |
|  [goBack(options)](./puppeteer.page.goback.md) |  |  |
|  [goForward(options)](./puppeteer.page.goforward.md) |  |  |
|  [goto(url, options)](./puppeteer.page.goto.md) |  |  |
|  [hover(selector)](./puppeteer.page.hover.md) |  |  |
|  [isClosed()](./puppeteer.page.isclosed.md) |  |  |
|  [isJavaScriptEnabled()](./puppeteer.page.isjavascriptenabled.md) |  |  |
|  [mainFrame()](./puppeteer.page.mainframe.md) |  |  |
|  [metrics()](./puppeteer.page.metrics.md) |  |  |
|  [pdf(options)](./puppeteer.page.pdf.md) |  |  |
|  [queryObjects(prototypeHandle)](./puppeteer.page.queryobjects.md) |  |  |
|  [reload(options)](./puppeteer.page.reload.md) |  |  |
|  [screenshot(options)](./puppeteer.page.screenshot.md) |  |  |
|  [select(selector, values)](./puppeteer.page.select.md) |  |  |
|  [setBypassCSP(enabled)](./puppeteer.page.setbypasscsp.md) |  |  |
|  [setCacheEnabled(enabled)](./puppeteer.page.setcacheenabled.md) |  |  |
|  [setContent(html, options)](./puppeteer.page.setcontent.md) |  |  |
|  [setCookie(cookies)](./puppeteer.page.setcookie.md) |  |  |
|  [setDefaultNavigationTimeout(timeout)](./puppeteer.page.setdefaultnavigationtimeout.md) |  |  |
|  [setDefaultTimeout(timeout)](./puppeteer.page.setdefaulttimeout.md) |  |  |
|  [setExtraHTTPHeaders(headers)](./puppeteer.page.setextrahttpheaders.md) |  |  |
|  [setGeolocation(options)](./puppeteer.page.setgeolocation.md) |  | Sets the page's geolocation. |
|  [setJavaScriptEnabled(enabled)](./puppeteer.page.setjavascriptenabled.md) |  |  |
|  [setOfflineMode(enabled)](./puppeteer.page.setofflinemode.md) |  |  |
|  [setRequestInterception(value)](./puppeteer.page.setrequestinterception.md) |  |  |
|  [setUserAgent(userAgent)](./puppeteer.page.setuseragent.md) |  |  |
|  [setViewport(viewport)](./puppeteer.page.setviewport.md) |  |  |
|  [tap(selector)](./puppeteer.page.tap.md) |  |  |
|  [target()](./puppeteer.page.target.md) |  |  |
|  [title()](./puppeteer.page.title.md) |  |  |
|  [type(selector, text, options)](./puppeteer.page.type.md) |  |  |
|  [url()](./puppeteer.page.url.md) |  |  |
|  [viewport()](./puppeteer.page.viewport.md) |  |  |
|  [waitFor(selectorOrFunctionOrTimeout, options, args)](./puppeteer.page.waitfor.md) |  |  |
|  [waitForFileChooser(options)](./puppeteer.page.waitforfilechooser.md) |  |  |
|  [waitForFunction(pageFunction, options, args)](./puppeteer.page.waitforfunction.md) |  |  |
|  [waitForNavigation(options)](./puppeteer.page.waitfornavigation.md) |  |  |
|  [waitForRequest(urlOrPredicate, options)](./puppeteer.page.waitforrequest.md) |  |  |
|  [waitForResponse(urlOrPredicate, options)](./puppeteer.page.waitforresponse.md) |  |  |
|  [waitForSelector(selector, options)](./puppeteer.page.waitforselector.md) |  |  |
|  [waitForXPath(xpath, options)](./puppeteer.page.waitforxpath.md) |  |  |
|  [workers()](./puppeteer.page.workers.md) |  |  |

