<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Puppeteer](./puppeteer.puppeteer.md)

## Puppeteer class

The main Puppeteer class Puppeteer module provides a method to launch a browser instance.

<b>Signature:</b>

```typescript
export declare class Puppeteer 
```

## Remarks

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `Puppeteer` class.

## Example

The following is a typical example of using Puppeteer to drive automation:

```js
const puppeteer = require('puppeteer');

(async () => {
  const browser = await puppeteer.launch();
  const page = await browser.newPage();
  await page.goto('https://www.google.com');
  // other actions...
  await browser.close();
})();

```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [\_\_productName](./puppeteer.puppeteer.__productname.md) |  | string |  |
|  [\_changedProduct](./puppeteer.puppeteer._changedproduct.md) |  | boolean |  |
|  [\_isPuppeteerCore](./puppeteer.puppeteer._ispuppeteercore.md) |  | boolean |  |
|  [\_lazyLauncher](./puppeteer.puppeteer._lazylauncher.md) |  | [ProductLauncher](./puppeteer.productlauncher.md) |  |
|  [\_preferredRevision](./puppeteer.puppeteer._preferredrevision.md) |  | string |  |
|  [devices](./puppeteer.puppeteer.devices.md) |  | [DevicesMap](./puppeteer.devicesmap.md) |  |
|  [errors](./puppeteer.puppeteer.errors.md) |  | [PuppeteerErrors](./puppeteer.puppeteererrors.md) |  |
|  [product](./puppeteer.puppeteer.product.md) |  | string |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [connect(options)](./puppeteer.puppeteer.connect.md) |  | This method attaches Puppeteer to an existing browser instance. |
|  [createBrowserFetcher(options)](./puppeteer.puppeteer.createbrowserfetcher.md) |  |  |
|  [defaultArgs(options)](./puppeteer.puppeteer.defaultargs.md) |  |  |
|  [executablePath()](./puppeteer.puppeteer.executablepath.md) |  |  |
|  [launch(options)](./puppeteer.puppeteer.launch.md) |  | Launches puppeteer and launches a browser instance with given arguments and options when specified. |

