#!/usr/bin/env python
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from __future__ import absolute_import

import re


def write_map(fd, name, text):
    matches = re.findall(r"^//\s(AX\w+)\n-\s?\(.*?\)([\w:]+)", text, re.MULTILINE)
    entries = ['  @"%s" : @"%s"' % (a, s) for [a, s] in matches]

    fd.write("static NSDictionary* g%s = @{\n" % name)
    fd.write(",\n".join(entries))
    fd.write("\n};\n\n")

    fd.write("NSDictionary* %s() {\n" % name)
    fd.write("  return g%s;\n" % name)
    fd.write("}\n\n")


def gen_mm(fd, protocol_file):
    protocol = open(protocol_file).read()
    fd.write("/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */\n\n")
    fd.write("#import <Foundation/Foundation.h>\n\n")
    fd.write("namespace mozilla {\nnamespace a11y {\nnamespace mac {\n\n")

    sections = re.findall(
        r"#pragma mark - (\w+)\n(.*?)(?=(?:#pragma mark|@end))", protocol, re.DOTALL
    )
    for name, text in sections:
        write_map(fd, name, text)

    fd.write("}\n}\n}\n")


def gen_h(fd, protocol_file):
    protocol = open(protocol_file).read()
    sections = re.findall(
        r"#pragma mark - (\w+)\n(.*?)(?=(?:#pragma mark|@end))", protocol, re.DOTALL
    )

    fd.write("/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */\n\n")
    fd.write("#ifndef _MacSelectorMap_H_\n")
    fd.write("#define _MacSelectorMap_H_\n")
    fd.write("\n@class NSDictionary;\n")
    fd.write("\nnamespace mozilla {\nnamespace a11y {\nnamespace mac {\n\n")
    for name, text in sections:
        fd.write("NSDictionary* %s();\n\n" % name)
    fd.write("}\n}\n}\n")
    fd.write("\n#endif\n")


# For debugging
if __name__ == "__main__":
    import sys

    gen_mm(sys.stdout, "accessible/mac/MOXAccessibleProtocol.h")

    gen_h(sys.stdout, "accessible/mac/MOXAccessibleProtocol.h")
