/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`new Date(0)`, {
  "resultID": "1573832025018-0",
  "hasException": false,
  "input": "new Date(0)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child1/obj23",
      "class": "Date",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "timestamp": 0
      }
    },
    "actorID": "server0.conn0.child1/obj23"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`asdf()`, {
  "resultID": "1573832025112-1",
  "errorMessageName": "JSMSG_NOT_DEFINED",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child1/obj25",
      "class": "ReferenceError",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "ReferenceError",
        "message": "asdf is not defined",
        "stack": "@debugger eval code:1:1\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 1
      }
    },
    "actorID": "server0.conn0.child1/obj25"
  },
  "exceptionMessage": "ReferenceError: asdf is not defined",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 1
  },
  "input": "asdf()",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`1 + @`, {
  "resultID": "1573832025117-2",
  "errorMessageName": "JSMSG_ILLEGAL_CHARACTER",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child1/obj26",
      "class": "SyntaxError",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "SyntaxError",
        "message": "illegal character U+0040",
        "stack": "",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 4
      }
    },
    "actorID": "server0.conn0.child1/obj26"
  },
  "exceptionMessage": "SyntaxError: illegal character U+0040",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Illegal_character?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 4
  },
  "input": "1 + @",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`inspect({a: 1})`, {
  "resultID": "1573832025122-3",
  "hasException": false,
  "helperResult": {
    "type": "inspectObject",
    "input": "inspect({a: 1})",
    "object": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn0.child1/obj28",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "a": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": 1
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      },
      "actorID": "server0.conn0.child1/obj28"
    },
    "forceExpandInConsole": false
  },
  "input": "inspect({a: 1})",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`undefined`, {
  "resultID": "1573832025127-5",
  "hasException": false,
  "input": "undefined",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`longString message Error`, {
  "resultID": "1573832025130-6",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child1/obj32",
      "class": "Error",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": {
          "_grip": {
            "type": "longString",
            "actor": "server0.conn0.child1/longstractor33",
            "length": 110000,
            "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
          },
          "actorID": "server0.conn0.child1/longstractor33"
        },
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7
      }
    },
    "actorID": "server0.conn0.child1/obj32"
  },
  "exceptionMessage": {
    "_grip": {
      "type": "longString",
      "actor": "server0.conn0.child1/longstractor34",
      "length": 110007,
      "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
    },
    "actorID": "server0.conn0.child1/longstractor34"
  },
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"Long error \".repeat(10000))",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw ""`, {
  "resultID": "1573832025134-7",
  "exception": "",
  "exceptionMessage": "",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"\"",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw "tomato"`, {
  "resultID": "1573832025137-8",
  "exception": "tomato",
  "exceptionMessage": "tomato",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"tomato\"",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw false`, {
  "resultID": "1588154002962-9",
  "exception": false,
  "exceptionMessage": "false",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw false",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw 0`, {
  "resultID": "1588154002979-10",
  "exception": 0,
  "exceptionMessage": "0",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw 0",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw null`, {
  "resultID": "1588154003064-11",
  "exception": {
    "type": "null"
  },
  "exceptionMessage": "null",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw null",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw undefined`, {
  "resultID": "1588154003073-12",
  "exception": {
    "type": "undefined"
  },
  "exceptionMessage": "undefined",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw undefined",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Symbol`, {
  "resultID": "1588154003077-13",
  "exception": {
    "type": "symbol",
    "actor": "server0.conn2.child2/symbol44",
    "name": "potato"
  },
  "exceptionMessage": "Symbol(potato)",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source33",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source33",
    "line": 1,
    "column": 7
  },
  "input": "throw Symbol(\"potato\")",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Object`, {
  "resultID": "1588154003082-14",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.child2/obj46",
      "class": "Object",
      "ownPropertyLength": 1,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "vegetable": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "cucumber"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    },
    "actorID": "server0.conn2.child2/obj46"
  },
  "exceptionMessage": "[object Object]",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw {vegetable: \"cucumber\"}",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object`, {
  "resultID": "1588154003093-15",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.child2/obj48",
      "class": "Error",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "pumpkin",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7
      }
    },
    "actorID": "server0.conn2.child2/obj48"
  },
  "exceptionMessage": "Error: pumpkin",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source33",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source33",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"pumpkin\")",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with custom name`, {
  "resultID": "1588154003097-16",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.child2/obj50",
      "class": "Error",
      "ownPropertyLength": 6,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "JuicyError",
        "message": "pineapple",
        "stack": "@debugger eval code:2:15\n",
        "fileName": "debugger eval code",
        "lineNumber": 2,
        "columnNumber": 15
      }
    },
    "actorID": "server0.conn2.child2/obj50"
  },
  "exceptionMessage": "JuicyError: pineapple",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source49",
      "lineNumber": 5,
      "columnNumber": 5,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source49",
    "line": 5,
    "column": 5
  },
  "input": "\n    var err = new Error(\"pineapple\");\n    err.name = \"JuicyError\";\n    err.flavor = \"delicious\";\n    throw err;\n  ",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval pending promise`, {
  "resultID": "1609858965386-17",
  "hasException": false,
  "input": "new Promise(() => {})",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child3/obj53",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "pending"
          }
        },
        "ownPropertiesLength": 1
      }
    },
    "actorID": "server0.conn0.child3/obj53"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval Promise.resolve`, {
  "resultID": "1609858965388-18",
  "hasException": false,
  "input": "Promise.resolve(123)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child3/obj55",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "fulfilled"
          },
          "<value>": {
            "value": 123
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn0.child3/obj55"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval Promise.reject`, {
  "resultID": "1609858965389-19",
  "hasException": false,
  "input": "Promise.reject(\"ouch\")",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child3/obj57",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "rejected"
          },
          "<reason>": {
            "value": "ouch"
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn0.child3/obj57"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval resolved promise`, {
  "resultID": "1609858965393-20",
  "hasException": false,
  "input": "Promise.resolve().then(() => 246)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child3/obj59",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "fulfilled"
          },
          "<value>": {
            "value": 246
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn0.child3/obj59"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval rejected promise`, {
  "resultID": "1609858965397-21",
  "hasException": false,
  "input": "Promise.resolve().then(() => a.b.c)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn0.child3/obj61",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "rejected"
          },
          "<reason>": {
            "value": {
              "type": "object",
              "actor": "server0.conn0.child3/obj62",
              "class": "ReferenceError",
              "ownPropertyLength": 4,
              "extensible": true,
              "frozen": false,
              "sealed": false,
              "isError": true,
              "preview": {
                "kind": "Error",
                "name": "ReferenceError",
                "message": "a is not defined",
                "stack": "@debugger eval code:1:30\npromise callback*@debugger eval code:1:19\n",
                "fileName": "debugger eval code",
                "lineNumber": 1,
                "columnNumber": 30
              }
            }
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn0.child3/obj61"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
