Usage
=====

When using the CDP-based remote agent in Firefox, there are
three different programs/components running simultaneously:

  * the __client__, being the out-of-process script or library
    (such as Puppeteer) or web inspector frontend you use to control
    and retrieve information out of Firefox;

  * the __agent__ that the client connects to which is an HTTPD living
    inside Firefox, facilitating communication between clients
    and targets;

  * and the __target__, which is the web document being debugging.

The remote agent ships in [Firefox Nightly] only.

To check if your Firefox binary has the remote agent enabled, you
can look in its help message for this:

	% ./firefox -h
	…
	  --remote-debugging-port [<port>] Start the Firefox remote agent, which is
	                     a low-level debugging interface based on the CDP protocol.
	                     Defaults to listen on localhost:9222.
	…

When used, the remote agent will start an HTTP server and print a
message on stderr with the location of the main target’s WebSocket
listener:

	% firefox --remote-debugging-port
	DevTools listening on ws://localhost:9222/devtools/browser/7b4e84a4-597f-4839-ac6d-c9e86d16fb83

`--remote-debugging-port` takes an optional port as input:

	[<port>]

You can use this to instruct the remote agent to bind to a particular
port on your system.  port is optional,
which means `firefox --remote-debugging-port` will bind the HTTPD to
the default `localhost:9222`.

If port has been specified the default port will be overridden:

	% firefox --remote-debugging-port 9989
    DevTools listening on ws://localhost:9989/devtools/browser/b49481af-8ad3-9b4d-b1bf-bb0cdb9a0620

When you ask the remote agent to listen on port 0,
the system will atomically allocate an arbitrary free port:

    % firefox --remote-debugging-port 0
    DevTools listening on ws://localhost:59982/devtools/browser/a12b22a9-1b8b-954a-b81f-bd31552d3f1c

Allocating an atomic port can be useful if you want to avoid race
conditions.  The atomically allocated port will be somewhere in the
ephemeral port range, which varies depending on your system and
system configuration, but is always guaranteed to be free thus
eliminating the risk of binding to a port that is already in use.

[Firefox Nightly]: https://www.mozilla.org/en-GB/firefox/channel/desktop/#nightly
