// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.drawing.style.spacing.measure
// Description:Testing letter spacing and word spacing
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Testing letter spacing and word spacing");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

var offscreenCanvas = new OffscreenCanvas(100, 50);
var ctx = offscreenCanvas.getContext('2d');

_assertSame(ctx.letterSpacing, 0, "ctx.letterSpacing", "0");
_assertSame(ctx.wordSpacing, 0, "ctx.wordSpacing", "0");
var width_normal = ctx.measureText('Hello World').width;

ctx.letterSpacing = 3;
_assertSame(ctx.letterSpacing, 3, "ctx.letterSpacing", "3");
_assertSame(ctx.wordSpacing, 0, "ctx.wordSpacing", "0");
var width_with_spacing = ctx.measureText('Hello World').width;
// Add letter spacing after each letter, so 11 * 3 = 33px longer.
_assertSame(width_with_spacing, width_normal + 33, "width_with_spacing", "width_normal + 33");

ctx.wordSpacing = 5;
ctx.letterSpacing = 0;
_assertSame(ctx.letterSpacing, 0, "ctx.letterSpacing", "0");
_assertSame(ctx.wordSpacing, 5, "ctx.wordSpacing", "5");
// Add Word Spacing between "Hello" and "World", so it's 5px longer.
width_with_spacing = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal + 5, "width_with_spacing", "width_normal + 5");

ctx.letterSpacing = -2;
ctx.wordSpacing = -1;
_assertSame(ctx.letterSpacing, -2, "ctx.letterSpacing", "-2");
_assertSame(ctx.wordSpacing, -1, "ctx.wordSpacing", "-1");
// Add Word Spacing and letter spacing, so it's -11*2 = -22px from
// letter spacing and -1px from word spacing.
width_with_spacing = ctx.measureText('Hello World').width;
_assertSame(width_with_spacing, width_normal - 23, "width_with_spacing", "width_normal - 23");
t.done();

});
done();
