/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. SEE devtools/client/webconsole/test/README.md.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`console.log('foobar', 'test')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "foobar",
      "test"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log(undefined)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.warn('danger, will robinson!')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "danger, will robinson!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "warn",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log(NaN)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log(null)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "type": "null"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('鼬')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "鼬"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.clear()`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "clear",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 1,
      "label": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.assert(false, {message: 'foobar'})`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj32",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "message": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "foobar"
              }
            },
            "ownSymbols": [],
            "privateProperties": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "privatePropertiesLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj32"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "assert",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source30",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('úṇĩçödê țĕșť')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.dirxml(window)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj35",
          "class": "Window",
          "ownPropertyLength": 818,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ObjectWithURL",
            "url": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html"
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj35"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "dirxml",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('myarray', ['red', 'green', 'blue'])`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "myarray",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj37",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 3,
            "items": [
              "red",
              "green",
              "blue"
            ]
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj37"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('myregex', /a.b.c/)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "myregex",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj39",
          "class": "RegExp",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "displayString": "/a.b.c/"
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj39"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.table(['red', 'green', 'blue']);`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj41",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": null,
          "ownProperties": {
            "0": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "red"
            },
            "1": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "green"
            },
            "2": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "blue"
            }
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj41"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "table",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "myobject",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj43",
          "class": "Object",
          "ownPropertyLength": 3,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "red": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "redValue"
              },
              "green": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "greenValue"
              },
              "blue": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "blueValue"
              }
            },
            "ownSymbols": [],
            "privateProperties": [],
            "ownPropertiesLength": 3,
            "ownSymbolsLength": 0,
            "privatePropertiesLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj43"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.debug('debug message');`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "debug message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "debug",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.info('info message');`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "info message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "info",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.error('error message');`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "error message"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "error",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source30",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "stacktrace": [
      {
        "columnNumber": 35,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1,
        "sourceId": "server0.conn0.child1/source30"
      }
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('mymap')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "mymap",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj48",
          "class": "Map",
          "ownPropertyLength": 0,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "MapLike",
            "size": 2,
            "entries": [
              [
                "key1",
                "value1"
              ],
              [
                "key2",
                "value2"
              ]
            ]
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj48"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 5,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source46",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log('myset')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "myset",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj50",
          "class": "Set",
          "ownPropertyLength": 0,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 2,
            "items": [
              "a",
              "b"
            ]
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj50"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.trace()`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 13,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "trace",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source50",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 5,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.trace('bar', {'foo': 'bar'}, [1,2,3])`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj53",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "foo": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "bar"
              }
            },
            "ownSymbols": [],
            "privateProperties": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "privatePropertiesLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj53"
      },
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj54",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "ArrayLike",
            "length": 3,
            "items": [
              1,
              2,
              3
            ]
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj54"
      }
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "trace",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source51",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "testStacktraceWithLog",
        "lineNumber": 3,
        "sourceId": "server0.conn0.child1/source51"
      },
      {
        "columnNumber": 5,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6,
        "sourceId": "server0.conn0.child1/source50"
      },
      {
        "columnNumber": 3,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9,
        "sourceId": "server0.conn0.child1/source50"
      }
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.trace("%cHello%c|%cWorld")`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "trace",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child3/source57",
    "category": "webdev",
    "innerWindowID": 10737418241,
    "stacktrace": [
      {
        "columnNumber": 13,
        "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 2,
        "sourceId": "server0.conn0.child3/source57"
      }
    ],
    "styles": [
      "color:red",
      "",
      "color: blue"
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.time('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "time",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`timerAlreadyExists`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "time",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "error": "timerAlreadyExists",
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.timeLog('bar') - 1`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "timeLog",
    "lineNumber": 4,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "duration": 4,
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.timeLog('bar') - 2`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar",
      "second call",
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj57",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "state": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": 1
              }
            },
            "ownSymbols": [],
            "privateProperties": [],
            "ownPropertiesLength": 1,
            "ownSymbolsLength": 0,
            "privatePropertiesLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj57"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "timeLog",
    "lineNumber": 5,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source46",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "duration": 5,
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.timeEnd('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "timeEnd",
    "lineNumber": 6,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "duration": 9,
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`timeEnd.timerDoesntExist`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "timeEnd",
    "lineNumber": 7,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`timeLog.timerDoesntExist`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "timeLog",
    "lineNumber": 8,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.table('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "table",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.table(['a', 'b', 'c'])`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj60",
          "class": "Array",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": null,
          "ownProperties": {
            "0": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "a"
            },
            "1": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "b"
            },
            "2": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "c"
            }
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj60"
      }
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "table",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.group('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "group",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupEnd('bar')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupEnd",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupCollapsed('foo')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "foo"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupEnd('foo')`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupEnd",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.group()`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "group",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupEnd()`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupEnd",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log(%cfoobar)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "styles": [
      "color:blue; font-size:1.3em; background:url('https://example.com/test'); position:absolute; top:10px; ",
      "color:red; line-height: 1.5; background:url('https://example.com/test')"
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log("%cHello%c|%cWorld")`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "chromeContext": false,
    "columnNumber": 13,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source63",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "styles": [
      "color:red",
      "",
      "color: blue"
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.group(%cfoo%cbar)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "foo",
      "bar"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "group",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "styles": [
      "color:blue;font-size:1.3em;background:url('https://example.com/test');position:absolute;top:10px",
      "color:red;background:url('https://example.com/test')"
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupEnd(%cfoo%cbar)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupEnd",
    "lineNumber": 6,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupCollapsed(%cfoo%cbaz)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "foo",
      "baz"
    ],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source48",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "styles": [
      "color:blue;font-size:1.3em;background:url('https://example.com/test');position:absolute;top:10px",
      "color:red;background:url('https://example.com/test')"
    ]
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.groupEnd(%cfoo%cbaz)`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 11,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "groupEnd",
    "lineNumber": 6,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source54",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.dir({C, M, Y, K})`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      {
        "_grip": {
          "type": "object",
          "actor": "server0.conn0.windowGlobal15032385537/obj69",
          "class": "Object",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false,
          "preview": {
            "kind": "Object",
            "ownProperties": {
              "cyan": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "C"
              },
              "magenta": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "M"
              },
              "yellow": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "Y"
              },
              "black": {
                "configurable": true,
                "enumerable": true,
                "writable": true,
                "value": "K"
              }
            },
            "ownSymbols": [],
            "privateProperties": [],
            "ownPropertiesLength": 4,
            "ownSymbolsLength": 0,
            "privatePropertiesLength": 0,
            "safeGetterValues": {}
          }
        },
        "actorID": "server0.conn0.windowGlobal15032385537/obj69"
      }
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "dir",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | default: 1`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 2,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 1,
      "label": "default"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | default: 2`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 3,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 2,
      "label": "default"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | test counter: 1`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 4,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 1,
      "label": "test counter"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | test counter: 2`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 5,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 2,
      "label": "test counter"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | default: 3`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 6,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 3,
      "label": "default"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | clear`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "clear",
    "lineNumber": 7,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | default: 4`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "default"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 8,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 4,
      "label": "default"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.count | test counter: 3`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "count",
    "lineNumber": 9,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 3,
      "label": "test counter"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.countReset | test counter: 0`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "countReset",
    "lineNumber": 10,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "count": 0,
      "label": "test counter"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.countReset | counterDoesntExist`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "test counter"
    ],
    "chromeContext": false,
    "columnNumber": 15,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "countReset",
    "lineNumber": 11,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source68",
    "category": "webdev",
    "innerWindowID": 8589934593,
    "counter": {
      "error": "counterDoesntExist",
      "label": "test counter"
    }
  },
  "isAlreadyExistingResource": false
});

rawPackets.set(`console.log escaped characters`, {
  "resourceType": "console-message",
  "message": {
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "chromeContext": false,
    "columnNumber": 35,
    "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/test-console-api.html",
    "level": "log",
    "lineNumber": 1,
    "timeStamp": 1572867483805,
    "sourceId": "server0.conn0.child1/source22",
    "category": "webdev",
    "innerWindowID": 8589934593
  },
  "isAlreadyExistingResource": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
