// set the state of components in Preferences-->Colors-->Text and Background
// and Preferences-->Colors-->Link Colors
// according to their locking state
function CheckLock(dataId,elementId)
{
  var data;
  var prefString;
  var isLocked;

  data = document.getElementById(dataId);
  prefString = data.getAttribute("prefstring");

  if(parent.hPrefWindow.getPrefIsLocked(prefString))
  {
    document.getElementById(elementId).setAttribute("disabled","true");
  }
}

function DoEnabling()
{
  CheckLock("foregroundText","foregroundtextmenu");
  CheckLock("background","backgroundmenu");
  CheckLock("unvisitedLinks","unvisitedlinkmenu");
  CheckLock("activeLinks","activelinkmenu");
  CheckLock("visitedLinks","visitedlinkmenu");
}

function setColorWell(aPicker)
{
  var colorRef = aPicker.nextSibling;                // colour value is held here
  colorRef.setAttribute( "value", aPicker.color );
}

  function setColorWellSr(menu,otherId,setbackground)
  {
    // Find the colorWell and colorPicker in the hierarchy.
    var colorWell = menu.firstChild;
    var colorPicker = menu.firstChild.nextSibling.nextSibling.firstChild;
    var colorRef = menu.nextSibling;                // colour value is held here
  
    // Extract color from colorPicker and assign to colorWell.
    var color = colorPicker.getAttribute('color');
    // set colour values in the display 
    setColorFromPicker( colorWell, color );
    // set the colour value internally for use in prefwindow
    colorRef.setAttribute( "value", color );
  }

  function getColorFromWellAndSetValue(aPickerId)
  {
    var picker = document.getElementById(aPickerId);
    var colorRef  = picker.nextSibling;
    var color = colorRef.getAttribute("value");
    picker.color = color;
    return color;
  }     

  function Startup()
  {
    getColorFromWellAndSetValue("foregroundtextmenu");
    getColorFromWellAndSetValue("backgroundmenu");
    getColorFromWellAndSetValue("unvisitedlinkmenu");
    getColorFromWellAndSetValue("activelinkmenu");
    getColorFromWellAndSetValue("visitedlinkmenu");

    return true;
  }                   
  
