/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * Original Author:
 *   Bolian Yin <bolian.yin@sun.com>
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsISimpleStreamListener.h"
#include "nsIOutputStream.h"
#include "nsCOMPtr.h"
#include "nsString.h"

class mozLDAPSimpleStreamListener : public nsISimpleStreamListener
{
public:
    NS_DECL_ISUPPORTS
    NS_DECL_NSIREQUESTOBSERVER
    NS_DECL_NSISTREAMLISTENER
    NS_DECL_NSISIMPLESTREAMLISTENER

    mozLDAPSimpleStreamListener() {mKey.Assign("");};
    virtual ~mozLDAPSimpleStreamListener() {}

protected:
    nsCOMPtr<nsIOutputStream>    mSink;
    nsCOMPtr<nsIRequestObserver> mObserver;
    nsCAutoString mKey;
};

class mozLDAPLIDataStreamListener : public mozLDAPSimpleStreamListener
{
public:
    mozLDAPLIDataStreamListener() {mKey.Assign("nslidata: ");};
};

class mozLDAPLIPrefsStreamListener : public mozLDAPSimpleStreamListener
{
public:
    mozLDAPLIPrefsStreamListener() {mKey.Assign("nsliprefs: ");};
};

#define NS_LDAP_LIDATA_STREAMLISTENER_CLASSNAME \
    "nsLDAPLIDataStreamListener"
#define NS_LDAP_LIDATA_STREAMLISTENER_CONTRACTID \
    "@mozilla.org/sroaming/ldap-lidata-stream-listener;1"
#define NS_LDAP_LIDATA_STREAMLISTENER_CID            \
{ /* fc49bc72-71a1-41f8-b65b-0ca21553f092 */         \
    0xfc49bc72,                                      \
    0x71a1,                                          \
    0x41f8,                                          \
    {0xb6, 0x5b, 0x0c, 0xa2, 0x15, 0x53, 0xf0, 0x92} \
}

#define NS_LDAP_LIPREFS_STREAMLISTENER_CLASSNAME \
    "nsLDAPPrefsStreamListener"
#define NS_LDAP_LIPREFS_STREAMLISTENER_CONTRACTID \
    "@mozilla.org/sroaming/ldap-liprefs-stream-listener;1"
#define NS_LDAP_LIPREFS_STREAMLISTENER_CID             \
{ /* 2b571449-0fa4-425c-abba-d4b2d50c23d8 */         \
    0x2b571449,                                      \
    0x0fa4,                                          \
    0x425c,                                          \
    {0xab, 0xba, 0xd4, 0xb2, 0xd5, 0x0c, 0x23, 0xd8} \
}
