/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Sun Microsystems, Inc.
 * Portions created by Sun Microsystems are Copyright (C) 2002 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Contributor(s):
 *   Louie Zhao (louie.zhao@sun.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsXULSelectAccessibleWrap.h"

#define FAKE_TEXT_INDEX_IN_COMBOBOX 0

NS_IMPL_ISUPPORTS_INHERITED1(nsXULComboboxAccessibleWrap, nsXULComboboxAccessible, nsIAccessibleText)

nsXULComboboxAccessibleWrap::nsXULComboboxAccessibleWrap(nsIDOMNode* aNode, nsIWeakReference* aShell):
nsXULComboboxAccessible(aNode, aShell)
{
}

nsXULComboboxAccessibleWrap::~nsXULComboboxAccessibleWrap()
{
}

NS_IMETHODIMP nsXULComboboxAccessibleWrap::GetChildAt(PRInt32 aChildNum, nsIAccessible **aChild)
{
  // Override of "GetChildAt" of nsXULComboboxAccessible is a workaround of
  // bug249973 - "Gnopernicus can't read the content of XUL textbox
  // (type=autocomplete)", whose fix should be in gnopernicus.
  // Gnopernicus assumes the index of atk textobject in combobox is constant.
  // This code will ignore the requested index and return atk textobject.
  if (aChildNum == FAKE_TEXT_INDEX_IN_COMBOBOX) {
    PRInt32 numChildren; // Make sure all children cached first
    GetChildCount(&numChildren);

    nsCOMPtr<nsIAccessible> current(mFirstChild), nextSibling;
    PRUint32 role;

    while (current) {
      nextSibling = current;
      nextSibling->GetRole(&role);
      if (role == ROLE_TEXT) {
        break;
      }
      nextSibling->GetNextSibling(getter_AddRefs(current));
    }
    NS_IF_ADDREF(*aChild = nextSibling);
    return NS_OK;
  } else
    return nsXULComboboxAccessible::GetChildAt(aChildNum, aChild);
}
