/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is SUN Microsystem code.
 *
 * The Initial Developer of the Original Code is
 * SUN Microsystem Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Robin Lu
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsW3CCompatManager.h"

#include "nsCOMPtr.h"
#include "nsCRT.h"
#include "nsPermission.h"
#include "nsIPermissionManager.h"
#include "nsIServiceManagerUtils.h"

#include "nsIURI.h"

/**
 * This is the interface to the W3C Compatible Manager: an object which
 * maintains W3C Incompatible websites.
 */

nsW3CCompatManager::nsW3CCompatManager()
{
}

nsW3CCompatManager::~nsW3CCompatManager()
{
}

NS_IMPL_ISUPPORTS2(nsW3CCompatManager, 
                   nsIW3CCompatManager,
                   nsSupportsWeakReference)

nsresult
nsW3CCompatManager::Init()
{
  mPermissionManager = do_GetService(NS_PERMISSIONMANAGER_CONTRACTID);
  return NS_OK;
}

NS_IMETHODIMP
nsW3CCompatManager::TestPermission(nsIURI *aURI, PRUint32 *aPermission)
{
  NS_ENSURE_ARG_POINTER(aURI);
  NS_ENSURE_ARG_POINTER(aPermission);

  nsresult rv;
  PRUint32 permit;

  if (mPermissionManager) {
    rv = mPermissionManager->TestPermission(aURI, "iecompat", &permit);

    if(permit == nsIPermissionManager::ALLOW_ACTION)
      *aPermission = nsIW3CCompatManager::ENABLE_IECOMPAT;
    else
      *aPermission = nsIW3CCompatManager::W3CCOMPAT;
  }

  return NS_OK;
}
