<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">

<html>
  <head>
   <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=$report-charset">
    <link rel="stylesheet" href="$css" type="text/css" media="screen">

    <title>Venkman 帮助系统</title>
    <script>
      function onLoad ()
      {
          var searchStart = document.location.href.indexOf("?");
          if (searchStart != -1)
          {
              var href = document.location.href;
              var result = parseSearch(href.substr(searchStart + 1));

              if ("search" in result)
              {
                  document.getElementById("search").value =
                      unescape(result.search);
              }

              if ("within" in result)
              {
                  var within = parseInt(result.within);
                  if (within & 0x01)
                      document.getElementById("command-names").checked = true;
                  if (within & 0x02)
                      document.getElementById("ui-labels").checked = true;
                  if (within & 0x04)
                      document.getElementById("help-text").checked = true;
              }
              else
              {
                  document.getElementById("command-names").checked = true;
                  document.getElementById("ui-labels").checked = true;
              }
          }
          else
          {
              document.getElementById("command-names").checked = true;
              document.getElementById("ui-labels").checked = true;
          }
      }

      function onKeyUp (event)
      {
          if (event.keyCode == 13)
              onSearch();
      }

      function onSearch ()
      {
          var search = document.getElementById("search").value;

          var within = 0;
          if (document.getElementById("command-names").checked)
              within |= 0x01;
          if (document.getElementById("ui-labels").checked)
              within |= 0x02;
          if (document.getElementById("help-text").checked)
              within |= 0x04;

          document.location.href = "x-jsd:help?search=" + escape(search) +
                                   "&within=" + within;
      }

      function parseSearch (search)
      {
          var parseResult = new Object();
          var ary = search.match(/([^&]+)/);
          
          while (ary)
          {
              var rest = RegExp.rightContext.substr(1);
              var assignment = ary[1];
              ary = assignment.match(/(.+)=(.*)/);
              if (ary)
              {
                  /* only set the property the first time we see it */
                  if (2 in ary && !(ary[1] in parseResult))
                      parseResult[ary[1]] = ary[2];
              }
              ary = rest.match(/([^&]+)/);
          }

          return parseResult;
      }
    </script>
  </head>

  <body id="venkman-help" onload="onLoad();"
    hasSearched="$has-searched" matchCount="$match-count">

    <a name="top"></a>
    <div id="help-menu">
      <span class="newbie-help">
        <p>
          欢迎使用<b>Venkman 帮助系统</b>.  您可以从此处搜索Venkman中各种命令的帮助。
      要搜索某个命令，只需在下面的输入框中输入搜索表达式然后点击<b>Go</b>, 或者按 <b>回车</b>.
    <p>
    其它帮助可以参考<a href="http://www.mozilla.org/projects/venkman/">Venkman 主页</a>
          或者
          <a href="http://www.hacksrus.com/~ginda/venkman/faq/venkman-faq.html">Venkman 常见问题</a>.
      </span>
      <span class="newbie-help">
       选择框用于控制搜索哪些字段...
        <ul>
          <li><b>命令名称</b> 要符合的命令名, 同您在</b>会话视图</b>中输入的类似.
          <li><b>用户接口标记</b> 命令对应于<b>菜单</b>或者<b>工具栏按钮</b>
中使用的标记.
          <li><b>描述</b> 符合帮助文本的内容。
        </ul>
      </span>
      <p class="search-input">
        搜索: <input type="text" id="search" onkeyup="onKeyUp(event)"/>
        <input type="button" onclick="onSearch()" value="Go">

        <input type="checkbox" id="command-names" value="1">
        <label for="command-names">命令名称</label>

        <input type="checkbox" id="ui-labels" value="1">
        <label for="ui-labels">用户接口标记</label>

        <input type="checkbox" id="help-text" value="1">
        <label for="help-text">描述</label>
      <p class="quick-searches">
        [ <a href="x-jsd:help">会话视图命令</a> |
         <a href="x-jsd:help?search="><b>所有</b> 命令</a> |
         <a href="x-jsd:help?search=%5E%5Ba-c%5D&within=2">A-C</a> |
         <a href="x-jsd:help?search=%5E%5Bd-f%5D&within=2">D-F</a> |
         <a href="x-jsd:help?search=%5E%5Bg-i%5D&within=2">G-I</a> |
         <a href="x-jsd:help?search=%5E%5Bj-l%5D&within=2">J-L</a> |
         <a href="x-jsd:help?search=%5E%5Bm-o%5D&within=2">M-O</a> |
         <a href="x-jsd:help?search=%5E%5Bp-r%5D&within=2">P-R</a> |
         <a href="x-jsd:help?search=%5E%5Bs-u%5D&within=2">S-U</a> |
         <a href="x-jsd:help?search=%5E%5Bv-z%5D&within=2">V-Z</a> ]
    </div>         
       
    <span id="match-count">找到 $match-count 个符合的命令。</span>

    <span id="command-list">
@-header-end
      <span class="command">
        <span class="label" item="command-name">命令名称:</span>
        <span class="value" item="command-name"><a href="x-jsd:help?search=$command-name">$command-name</a></span><br>
        <span class="label" item="ui-label">用户接口标记:</span>
        <span class="value" item="ui-label"><a href="x-jsd:help?search=$ui-label-safe&within=2">$ui-label</a></span><br>
        <br>
        <span class="label" item="usage">用法:</span> <span class="value" item="usage">$command-name $params</span><br>
        <br>
        <span class="label" item="accel-key">快捷键:</span> $key<br>
        <br>
        <span class="label" item="description">描述:</span><br>
        <span class="value" item="description">$desc</span>
        <span class="goto-top"><a href="#top">回到页首</a></span>
      </span>
      <hr>
@-command-end
      <font color="red"><b>未找到符合的命令</b></font>
@-nomatch-end
    </span>
  </body>
</html>
