/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * rdf.FileRDF
 *
 *
 */
ML.load("rdf/rdf.js");
ML.load("io/file.js");

function FileRDF(reader, namespaceURI, prefix)
{
    var ios = Components.classes["@mozilla.org/network/io-service;1"].
       getService(Components.interfaces.nsIIOService);

    var rdfService = Components.classes['@mozilla.org/rdf/rdf-service;1'].
         getService(Components.interfaces.nsIRDFService);

    if (typeof(reader) == "string") {
        try {
            reader = new File(reader);
        } catch (ex) {
            reader = new Reader(reader);
        }
    }

    this.base = RDF;

    if (reader instanceof File && !reader.exists) {
        reader.open(reader.MODE_WRONLY|reader.MODE_CREATE);
        reader.write(
            '<?xml version="1.0" ?>\n' +
            '<RDF:RDF ' +
            'xmlns:'+ prefix +'="'+ namespaceURI +'" ' +
            'xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n' +
            '</RDF:RDF>'); 
        reader.close();
    }

    this.base(namespaceURI,
        rdfService.GetDataSourceBlocking(reader.uri.spec));
}

FileRDF.prototype =
{
    __proto__: RDF.prototype,

    refresh: function()
    {
        try {
            this.DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Refresh(false);
        } catch (ex) { }
    },

    flush: function()
    {
        try {
            this.DS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
        } catch (ex) { }
    },
}
