/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.highlevel.HLAgents
 *
 *
 */

/**
 * HLAgents
 *
 * Constructors:
 *   HLAgents(jabberService)
 *
 * Method:
 *   getAgentIDs()
 *   getAgentInfoById(accountName)
 *
 */

function HLAgents(jabberService)
{
    this.jabberService = jabberService;
    jabberService.core.iq.agents.addObserver(this);
    jabberService.core.iq.auth.addObserver(this);
    jabberService.addObserver(this);
}

function vOn(v) { return v ? v.value : null; }

HLAgents.prototype =
{
    get agents()
    {
        return this.jabberService.localRDF.getContainer("rdf:jim-agents", "bag");
    },

    getAgentIDs: function()
    {
        var it = this.agents.getElements();
        var res = [];

        while (it.hasNext())
            res.push(it.getNext().value);
        return res;
    },

    getAgentInfoById: function(id)
    {
        var agent = this.jabberService.localRDF.getResource(id);

        this.jabberService.localRDF.ns = JIM_NAMESPACE_URI+"rdf/agents#";

        if (agent.hasAnyAssertion("name", JIM_NAMESPACE_URI+"rdf/agents#")) {
            return {
                jid:            vOn(agent.getTarget("jid")),
                name:           vOn(agent.getTarget("name")),
                description:    vOn(agent.getTarget("description")),
                transport:      agent.getTarget("transport") != null,
                grupchat:       agent.getTarget("grupchat") != null,
                service:        vOn(agent.getTarget("service")),
                register:       agent.getTarget("register") != null,
                search:         agent.getTarget("search") != null,
            };
        }
        return null;
    },

    onIQAgents: function(jid, name, description, transport, groupchat, service, register, search)
    {
        var agent = this.jabberService.localRDF.getResource();

        this.jabberService.localRDF.ns = JIM_NAMESPACE_URI+"rdf/agents#";
        agent.setAssertion("jid", jid, true);
        agent.setAssertion("name", name, true);

        if (description)
            agent.setAssertion("description", description, true);
        if (transport)
            agent.setAssertion("transport", "true", true);
        if (groupchat)
            agent.setAssertion("groupchat", "true", true);
        if (service)
            agent.setAssertion("service", service, true);
        if (register)
            agent.setAssertion("register", "true", true);
        if (search)
            agent.setAssertion("search", "true", true);

        this.agents.appendElement(agent);
    },

    onIQAuth: function()
    {
        this.jabberService.core.iq.agents.getAgents();
    },

    onDisconnect: function(statusCode)
    {
        this.agents.removeElements(true);
    },

    onClean: function()
    {
        this.agents.removeElements(true);
    },
}
