/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.highlevel.HLStatusIcons
 *
 *
 */
ML.load("utils/observable.js");
ML.load("io/file.js");
ML.load("rdf/filerdf.js");
ML.load("utils/base64.js");
ML.load("utils/misc.js");

/**
 * HLStatusIcons
 *   Service which controls information about statusicons
 *
 * Constructors:
 *   HLStatusIcons(jabberService) - constructor
 *
 */

function HLStatusIcons(jabberService)
{
    var nodes, node;
    var arr, i, rdf, file;

    this.jabberService = jabberService;
    this.statusiconsHash = { };

    rdf = new FileRDF("chrome://jim/content/data/statusicons/statusicons.rdf",
        JIM_NAMESPACE_URI+"rdf/statusicons#");

    nodes = rdf.getContainer("rdf:jim-statusicons").getElements();
    while (nodes.hasNext()) {
        node = nodes.getNext();
        this.statusiconsHash[node.getTarget("name").value] = {
            available:      node.getTarget("available-uri").value,
            unavailable:    node.getTarget("unavailable-uri").value,
            dnd:            node.getTarget("dnd-uri").value,
            away:           node.getTarget("away-uri").value,
            xa:             node.getTarget("xa-uri").value,
            chat:           node.getTarget("chat-uri").value,
        }
    }

    file = new File(jabberService.settingsDirectory, "status-icon.rdf");
    this.rdf = new FileRDF(file, JIM_NAMESPACE_URI+"rdf/status-icon#", "si");

    this.node = node = this.rdf.getResource("rdf:jim-statusicon")
    if (node && (node = node.getTarget("default")))
        this.defaultStatus = node.value;
    else
        this.defaultStatusIcons = rdf.getResource("rdf:jim-statusicon").
            getTarget("default").value;

    jabberService.core.iq.highlevel.users.addObserver(this);
}

HLStatusIcons.prototype =
{
    setDefaultStatusIcons: function(val)
    {
        this.defaultStatus = val;

        this.node.setAssertion("default", val, true);
    },

    onUsersChanged: function(users, userid, resourceid)
    {
        var uinfo, rinfo, avatar;

        this.jabberService.localRDF.ns = JIM_NAMESPACE_URI+"rdf/users#";

        if (userid) {
            uinfo = this.jabberServiec.core.highlevel.user.
                getInfoByUserId(userid);
            if (resourceid) {
                rinfo = this.jabberServiec.core.highlevel.user.
                    getInfoByResourceId(resourceid);

                if (!rinfo || !rinfo.user)
                    return;

                avatar = this.jabberServiec.core.highlevel.avatars.
                    getAvatarByResourceId(resourceid);

                if (avatar)
                    return;
            } else {
            }
        }
    }
}
